/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPreparedStatement;
import sun.jdbc.odbc.OdbcDef;

public class JdbcOdbcCallableStatement
extends JdbcOdbcPreparedStatement
implements CallableStatement {
    public byte[] scalez = new byte[200];
    private boolean lastParameterNull = false;

    public JdbcOdbcCallableStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        super(jdbcOdbcConnectionInterface);
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.registerOutParameter(n2, n3, 0);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        void var7_10;
        int n5;
        this.setSqlType(n2, n3);
        if (n2 <= 200) {
            this.scalez[n2] = (byte)n4;
        }
        this.setOutputParameter(n2, true);
        switch (n3) {
            case 91: {
                n5 = 10;
                break;
            }
            case 92: {
                n5 = 8;
                break;
            }
            case 93: {
                n5 = 15;
                if (n4 <= 0) break;
                n5 += n4 + 1;
                break;
            }
            case -7: {
                n5 = 3;
                break;
            }
            case -6: {
                n5 = 4;
                break;
            }
            case 5: {
                n5 = 6;
                break;
            }
            case 4: {
                n5 = 11;
                break;
            }
            case -5: {
                n5 = 20;
                break;
            }
            case 7: {
                n5 = 13;
                break;
            }
            case 6: 
            case 8: {
                n5 = 22;
                break;
            }
            case 2: 
            case 3: {
                n5 = 38;
                break;
            }
            default: {
                n5 = this.getPrecision(n3);
                if (n5 > 0 && n5 <= 8000) break;
                n5 = 8000;
            }
        }
        byte[] byArray = this.getLengthBuf(n2);
        n3 = OdbcDef.jdbcTypeToOdbc(n3);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        Object var7_7 = null;
        if (this.boundParams[n2 - 1].isInOutParameter() && this.boundParams[n2 - 1].boundValue == null) {
            Object var7_8 = null;
        } else {
            byte[] byArray2 = this.allocBindBuf(n2, n5 + 1);
        }
        if (this.boundParams[n2 - 1].isInOutParameter()) {
            if (this.boundParams[n2 - 1].boundValue == null) {
                this.OdbcApi.SQLBindInOutParameterNull(this.hStmt, n2, n3, n5, this.boundParams[n2 - 1].scale, byArray, lArray);
            } else if (n3 == 4) {
                if (this.boundParams[n2 - 1].boundType != 4) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
            } else if (n3 == -7) {
                if (this.boundParams[n2 - 1].boundType != -7) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
            } else if (n3 == -6) {
                if (this.boundParams[n2 - 1].boundType != -6) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
            } else if (n3 == 5) {
                if (this.boundParams[n2 - 1].boundType != 5) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
            } else if (n3 == 8 || n3 == 6 || n3 == 7) {
                if (this.boundParams[n2 - 1].boundType != 8 && this.boundParams[n2 - 1].boundType != 6 && this.boundParams[n2 - 1].boundType != 7) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n2, 8, n5, (byte[])var7_10, byArray, lArray);
            } else if (n3 == -5) {
                if (this.boundParams[n2 - 1].boundType != -5) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
            } else if (n3 == 1 || n3 == 12) {
                if (this.boundParams[n2 - 1].boundType != 1) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                byte[] byArray3 = new byte[n5 + 1];
                int n6 = 0;
                while (n6 < byArray3.length) {
                    byArray3[n6] = 0;
                    ++n6;
                }
                int n7 = 0;
                while (n7 < ((void)var7_10).length) {
                    byArray3[n7] = var7_10[n7];
                    ++n7;
                }
                this.boundParams[n2 - 1].resetBindDataBuffer(byArray3);
                this.OdbcApi.SQLBindInOutParameterStr(this.hStmt, n2, n3, n5, byArray3, byArray, lArray, -3);
            } else if (n3 == -2 || n3 == -3) {
                if (this.boundParams[n2 - 1].boundType != -2 && this.boundParams[n2 - 1].boundType != -3) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                byte[] byArray4 = new byte[n5 + 1];
                int n8 = 0;
                while (n8 < byArray4.length) {
                    byArray4[n8] = 0;
                    ++n8;
                }
                int n9 = 0;
                while (n9 < ((void)var7_10).length) {
                    byArray4[n9] = var7_10[n9];
                    ++n9;
                }
                this.boundParams[n2 - 1].resetBindDataBuffer(byArray4);
                this.OdbcApi.SQLBindInOutParameterBin(this.hStmt, n2, n3, n5, byArray4, byArray, lArray, ((void)var7_10).length);
            } else if (n3 == 2 || n3 == 3) {
                String string = null;
                try {
                    string = this.BytesToChars(this.OdbcApi.charSet, (byte[])var7_10);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                BigDecimal bigDecimal = new BigDecimal(string);
                byte[] byArray5 = null;
                byte[] byArray6 = null;
                if (n4 >= bigDecimal.scale()) {
                    BigDecimal bigDecimal2 = bigDecimal.movePointRight(n4).movePointLeft(n4);
                    byArray5 = new byte[n5];
                    int n10 = 0;
                    while (n10 < byArray5.length) {
                        byArray5[n10] = 48;
                        ++n10;
                    }
                    try {
                        byArray6 = this.CharsToBytes(this.OdbcApi.charSet, bigDecimal2.toString().toCharArray());
                        int n11 = byArray5.length - byArray6.length;
                        while (n11 < byArray5.length) {
                            byArray5[n11] = byArray6[n11 - (byArray5.length - byArray6.length)];
                            ++n11;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.boundParams[n2 - 1].resetBindDataBuffer(byArray5);
                    this.boundParams[n2 - 1].scale = bigDecimal2.scale();
                }
                this.OdbcApi.SQLBindInOutParameterString(this.hStmt, n2, n3, n5, this.boundParams[n2 - 1].scale, byArray5, byArray, lArray);
            } else if (n3 == 11) {
                if (this.boundParams[n2 - 1].boundType != 93) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                int n12 = 0;
                int n13 = 0;
                Timestamp timestamp = (Timestamp)this.boundParams[n2 - 1].boundValue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                int n14 = calendar.get(1);
                int n15 = calendar.get(2);
                int n16 = calendar.get(5);
                int n17 = calendar.get(11);
                int n18 = calendar.get(12);
                int n19 = calendar.get(13);
                int n20 = timestamp.getNanos();
                byte[] byArray7 = new byte[16];
                this.OdbcApi.getTimestampStruct(byArray7, n14, ++n15, n16, n17, n18, n19, n20);
                this.boundParams[n2 - 1].resetBindDataBuffer(byArray7);
                Integer n21 = new Integer(n20);
                String string = n21.toString();
                char[] cArray = string.toCharArray();
                n12 = cArray.length;
                while (n12 > 0) {
                    if (cArray[n12 - 1] != '0') break;
                    --n12;
                }
                if (n20 == 0) {
                    n12 = 1;
                }
                n13 = 20 + n12;
                this.OdbcApi.SQLBindInOutParameterTimestamp(this.hStmt, n2, 29, 9, byArray7, byArray, lArray);
            } else if (n3 == 9) {
                if (this.boundParams[n2 - 1].boundType != 91) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                Date date = (Date)this.boundParams[n2 - 1].boundValue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n22 = calendar.get(1);
                int n23 = calendar.get(2);
                int n24 = calendar.get(5);
                byte[] byArray8 = new byte[6];
                this.OdbcApi.getDateStruct(byArray8, n22, ++n23, n24);
                this.boundParams[n2 - 1].resetBindDataBuffer(byArray8);
                this.OdbcApi.SQLBindInOutParameterDate(this.hStmt, n2, this.boundParams[n2 - 1].scale, byArray8, byArray, lArray);
            } else {
                if (n3 != 10) throw new UnsupportedOperationException();
                if (this.boundParams[n2 - 1].boundType != 92) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                Time time = (Time)this.boundParams[n2 - 1].boundValue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                int n25 = calendar.get(11);
                int n26 = calendar.get(12);
                int n27 = calendar.get(13);
                byte[] byArray9 = new byte[6];
                this.OdbcApi.getTimeStruct(byArray9, n25, n26, n27);
                this.boundParams[n2 - 1].resetBindDataBuffer(byArray9);
                this.OdbcApi.SQLBindInOutParameterTime(this.hStmt, n2, this.boundParams[n2 - 1].scale, byArray9, byArray, lArray);
            }
        } else if (n3 == 0) {
            this.OdbcApi.SQLBindOutParameterNull(this.hStmt, n2, n3, n5, this.boundParams[n2 - 1].scale, byArray, lArray);
        } else if (n3 == 8 || n3 == 6 || n3 == 7) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n2, 8, n5, (byte[])var7_10, byArray, lArray);
        } else if (n3 == 4) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
        } else if (n3 == -6) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
        } else if (n3 == 5) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
        } else if (n3 == -7) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
        } else if (n3 == -5) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n2, n3, n5, (byte[])var7_10, byArray, lArray);
        } else if (n3 == 2 || n3 == 3) {
            this.OdbcApi.SQLBindOutParameterString(this.hStmt, n2, n3, this.boundParams[n2 - 1].scale, (byte[])var7_10, byArray, lArray);
        } else if (n3 == 11) {
            this.OdbcApi.SQLBindOutParameterTimestamp(this.hStmt, n2, n5, (byte[])var7_10, byArray, lArray);
        } else if (n3 == 9) {
            this.OdbcApi.SQLBindOutParameterDate(this.hStmt, n2, this.boundParams[n2 - 1].scale, (byte[])var7_10, byArray, lArray);
        } else if (n3 == 10) {
            this.OdbcApi.SQLBindOutParameterTime(this.hStmt, n2, this.boundParams[n2 - 1].scale, (byte[])var7_10, byArray, lArray);
        } else if (n3 == -2 || n3 == -3 || n3 == -4) {
            this.OdbcApi.SQLBindOutParameterBinary(this.hStmt, n2, n3, n5, n4, (byte[])var7_10, byArray, lArray);
        } else if (n3 == 1 || n3 == 12 || n3 == -1) {
            this.OdbcApi.SQLBindOutParameterString(this.hStmt, n2, n3, n4, (byte[])var7_10, byArray, lArray);
        } else {
            this.OdbcApi.SQLBindOutParameterString(this.hStmt, n2, n3, n4, (byte[])var7_10, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].pB1 = lArray[2];
        this.boundParams[n2 - 1].pB2 = lArray[3];
    }

    public boolean wasNull() throws SQLException {
        return this.lastParameterNull;
    }

    public String getString(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        int n3 = this.getSqlType(n2);
        String string = null;
        try {
            byte[] byArray = this.getDataBuf(n2);
            if (byArray != null) {
                string = this.BytesToChars(this.OdbcApi.charSet, byArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("String value for OUT parameter " + n2 + "=" + string);
        }
        return string;
    }

    public boolean getBoolean(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return false;
        }
        return this.getInt(n2) == 1;
    }

    public byte getByte(int n2) throws SQLException {
        return (byte)this.getInt(n2);
    }

    public short getShort(int n2) throws SQLException {
        return (short)this.getInt(n2);
    }

    public int getInt(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return 0;
        }
        return this.OdbcApi.bufferToInt(this.getDataBuf(n2));
    }

    public long getLong(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return 0L;
        }
        return this.OdbcApi.bufferToLong(this.getDataBuf(n2));
    }

    public float getFloat(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return 0.0f;
        }
        return (float)this.OdbcApi.bufferToDouble(this.getDataBuf(n2));
    }

    public double getDouble(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return 0.0;
        }
        return this.OdbcApi.bufferToDouble(this.getDataBuf(n2));
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n2).trim());
        return bigDecimal.setScale(n3, 6);
    }

    public byte[] getBytes(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        if (this.boundParams[n2 - 1].isInOutParameter() || this.boundParams[n2 - 1].isOutputParameter()) {
            byte[] byArray;
            int n3 = this.getParamLength(n2);
            if (n3 < (byArray = this.getDataBuf(n2)).length) {
                byte[] byArray2 = new byte[n3];
                int n4 = 0;
                while (n4 < this.getParamLength(n2)) {
                    byArray2[n4] = byArray[n4];
                    ++n4;
                }
                this.boundParams[n2 - 1].resetBindDataBuffer(byArray2);
                return byArray2;
            }
            return byArray;
        }
        return JdbcOdbcObject.hexStringToByteArray(this.getString(n2).trim());
    }

    public Date getDate(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        byte[] byArray = this.getDataBuf(n2);
        byte[] byArray2 = new byte[11];
        this.OdbcApi.convertDateString(byArray, byArray2);
        return Date.valueOf(new String(byArray2).trim());
    }

    public Time getTime(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        byte[] byArray = this.getDataBuf(n2);
        byte[] byArray2 = new byte[9];
        this.OdbcApi.convertTimeString(byArray, byArray2);
        return Time.valueOf(new String(byArray2).trim());
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        byte[] byArray = this.getDataBuf(n2);
        byte[] byArray2 = new byte[30];
        this.OdbcApi.convertTimestampString(byArray, byArray2);
        return Timestamp.valueOf(new String(byArray2).trim());
    }

    public Object getObject(int n2) throws SQLException {
        Object object = null;
        int n3 = this.getSqlType(n2);
        if (this.isNull(n2)) {
            return null;
        }
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n2);
                break;
            }
            case 2: 
            case 3: {
                if (n2 <= 200) {
                    object = this.getBigDecimal(n2, this.scalez[n2]);
                    break;
                }
                object = this.getBigDecimal(n2, 4);
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n2));
                break;
            }
            case -6: {
                object = new Integer(this.getByte(n2));
                break;
            }
            case 5: {
                object = new Integer(this.getShort(n2));
                break;
            }
            case 4: {
                object = new Integer(this.getInt(n2));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n2));
                break;
            }
            case 7: {
                object = new Float(this.getFloat(n2));
                break;
            }
            case 6: 
            case 8: {
                object = new Double(this.getDouble(n2));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n2);
                break;
            }
            case 91: {
                object = this.getDate(n2);
                break;
            }
            case 92: {
                object = this.getTime(n2);
                break;
            }
            case 93: {
                object = this.getTimestamp(n2);
            }
        }
        return object;
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n2).trim());
        return bigDecimal;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return null;
    }

    public Ref getRef(int n2) throws SQLException {
        return null;
    }

    public Blob getBlob(int n2) throws SQLException {
        return null;
    }

    public Clob getClob(int n2) throws SQLException {
        return null;
    }

    public Array getArray(int n2) throws SQLException {
        return null;
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        long l2 = 0L;
        if (this.getDate(n2) == null) {
            return null;
        }
        if (this.getDate(n2) != null) {
            l2 = this.utils.convertFromGMT(this.getDate(n2), calendar);
        }
        if (l2 == 0L) {
            return null;
        }
        return new Date(l2);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        long l2 = 0L;
        if (this.getTime(n2) == null) {
            return null;
        }
        if (this.getTime(n2) != null) {
            try {
                l2 = this.utils.convertFromGMT(this.getTime(n2), calendar);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (l2 == 0L) {
            return null;
        }
        return new Time(l2);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        long l2 = 0L;
        if (this.getTimestamp(n2) == null) {
            return null;
        }
        try {
            l2 = this.utils.convertFromGMT(this.getTimestamp(n2), calendar);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l2 == 0L) {
            return null;
        }
        return new Timestamp(l2);
    }

    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected boolean isNull(int n2) throws SQLException {
        if (!this.isOutputParameter(n2)) {
            throw new SQLException("Parameter " + n2 + " is not an OUTPUT parameter");
        }
        boolean bl2 = false;
        boolean bl3 = bl2 = this.getParamLength(n2) == -1;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("Output Parameter " + n2 + " null: " + bl2);
        }
        this.lastParameterNull = bl2;
        return bl2;
    }

    protected void setOutputParameter(int n2, boolean bl2) {
        if (n2 >= 1 && n2 <= this.numParams) {
            this.boundParams[n2 - 1].setOutputParameter(bl2);
        }
    }

    protected boolean isOutputParameter(int n2) {
        boolean bl2 = false;
        if (n2 >= 1 && n2 <= this.numParams) {
            bl2 = this.boundParams[n2 - 1].isOutputParameter();
        }
        return bl2;
    }

    public synchronized void close() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0L) {
                if (this.closeCalledFromFinalize) {
                    if (!this.myConnection.isFreeStmtsFromConnectionOnly()) {
                        this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                    }
                } else {
                    this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                }
                this.hStmt = 0L;
                this.FreeParams();
                int n2 = 1;
                while (this.boundParams != null && n2 <= this.boundParams.length) {
                    this.boundParams[n2 - 1].binaryData = null;
                    this.boundParams[n2 - 1].initialize();
                    this.boundParams[n2 - 1].paramInputStream = null;
                    this.boundParams[n2 - 1].inputParameter = false;
                    ++n2;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.myConnection.deregisterStatement(this);
    }

    public synchronized void FreeParams() throws NullPointerException {
        try {
            int n2 = 1;
            while (n2 <= this.boundParams.length) {
                if (this.boundParams[n2 - 1].pA1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n2 - 1].pA1, this.boundParams[n2 - 1].pA2);
                    this.boundParams[n2 - 1].pA1 = 0L;
                    this.boundParams[n2 - 1].pA2 = 0L;
                }
                if (this.boundParams[n2 - 1].pB1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n2 - 1].pB1, this.boundParams[n2 - 1].pB2);
                    this.boundParams[n2 - 1].pB1 = 0L;
                    this.boundParams[n2 - 1].pB2 = 0L;
                }
                if (this.boundParams[n2 - 1].pC1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n2 - 1].pC1, this.boundParams[n2 - 1].pC2);
                    this.boundParams[n2 - 1].pC1 = 0L;
                    this.boundParams[n2 - 1].pC2 = 0L;
                }
                if (this.boundParams[n2 - 1].pS1 != 0L) {
                    JdbcOdbc.ReleaseStoredChars(this.boundParams[n2 - 1].pS1, this.boundParams[n2 - 1].pS2);
                    this.boundParams[n2 - 1].pS1 = 0L;
                    this.boundParams[n2 - 1].pS2 = 0L;
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public URL getURL(int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String string, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(String string, boolean bl2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setShort(String string, short s2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setInt(String string, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setLong(String string, long l2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFloat(String string, float f2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(String string, double d2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(String string, Object object, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String string, int n2, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void registerOutParameter(String string, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getString(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public short getShort(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getInt(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long getLong(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

