/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ISO_8859_1;
import sun.nio.cs.ISO_8859_15;
import sun.nio.cs.MS1252;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.UTF_16;
import sun.nio.cs.UTF_16LE;
import sun.nio.cs.UTF_8;
import sun.nio.cs.UnicodeDecoder;
import sun.nio.cs.UnicodeEncoder;

class UTF_16BE
extends Charset
implements HistoricallyNamedCharset {
    public UTF_16BE() {
        super("UTF-16BE", StandardCharsets.aliasesFor("UTF-16BE"));
    }

    public String historicalName() {
        return "UnicodeBigUnmarked";
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1 || charset instanceof ISO_8859_15 || charset instanceof MS1252 || charset instanceof UTF_8 || charset instanceof UTF_16 || charset instanceof UTF_16BE || charset instanceof UTF_16LE || charset.name().equals("GBK") || charset.name().equals("GB18030") || charset.name().equals("ISO-8859-2") || charset.name().equals("ISO-8859-3") || charset.name().equals("ISO-8859-4") || charset.name().equals("ISO-8859-5") || charset.name().equals("ISO-8859-6") || charset.name().equals("ISO-8859-7") || charset.name().equals("ISO-8859-8") || charset.name().equals("ISO-8859-9") || charset.name().equals("ISO-8859-13") || charset.name().equals("windows-1251") || charset.name().equals("windows-1253") || charset.name().equals("windows-1254") || charset.name().equals("windows-1255") || charset.name().equals("windows-1256") || charset.name().equals("windows-1257") || charset.name().equals("windows-1258") || charset.name().equals("windows-932") || charset.name().equals("windows-936") || charset.name().equals("windows-949") || charset.name().equals("windows-950") || charset.name().equals("windows-31j") || charset.name().equals("JIS0201") || charset.name().equals("JIS0208") || charset.name().equals("JIS0212") || charset.name().equals("SJIS") || charset.name().equals("EUC-CN") || charset.name().equals("EUC-KR") || charset.name().equals("EUC-TW") || charset.name().equals("EUC-JP") || charset.name().equals("EUC-JP-LINUX") || charset.name().equals("KOI8-R") || charset.name().equals("TIS-620") || charset.name().equals("ISCII91") || charset.name().equals("Big5") || charset.name().equals("Big5-HKSCS") || charset.name().equals("ISO-2022-JP") || charset.name().equals("ISO-2022-KR") || charset.name().equals("ISO-2022-CN-CNS") || charset.name().equals("ISO-2022-CN-GB") || charset.name().equals("Big5-HKSCS") || charset.name().equals("Johab") || charset.name().equals("Shift_JIS");
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends UnicodeEncoder {
        public Encoder(Charset charset) {
            super(charset, 0, false);
        }

        public boolean canEncode(char c2) {
            if (Surrogate.isHigh(c2) || Surrogate.isLow(c2)) {
                return false;
            }
            return c2 <= '\uffff';
        }
    }

    private static class Decoder
    extends UnicodeDecoder {
        public Decoder(Charset charset) {
            super(charset, 1);
        }
    }
}

