/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.security.Provider;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSContextImpl;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.ProviderList;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;

public class GSSManagerImpl
extends GSSManager {
    private ProviderList list = new ProviderList();

    public Oid[] getMechs() {
        return this.list.getMechs();
    }

    public Oid[] getNamesForMech(Oid oid) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid);
        return mechanismFactory.getNameTypes();
    }

    public Oid[] getMechsForName(Oid oid) {
        Oid[] oidArray;
        Oid[] oidArray2 = this.getMechs();
        Oid[] oidArray3 = new Oid[oidArray2.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < oidArray2.length) {
            try {
                oidArray = this.getNamesForMech(oidArray2[n3]);
                if (oid.containedIn(oidArray)) {
                    oidArray3[n2++] = oidArray2[n3];
                }
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
            ++n3;
        }
        if (n2 < oidArray3.length) {
            oidArray = new Oid[n2];
            int n4 = 0;
            while (n4 < n2) {
                oidArray[n4] = oidArray3[n4];
                ++n4;
            }
            oidArray3 = oidArray;
        }
        return oidArray3;
    }

    public GSSName createName(String string, Oid oid) throws GSSException {
        return new GSSNameImpl(this, string, oid);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        return new GSSNameImpl(this, byArray, oid);
    }

    public GSSName createName(String string, Oid oid, Oid oid2) throws GSSException {
        return new GSSNameImpl(this, string, oid, oid2);
    }

    public GSSName createName(byte[] byArray, Oid oid, Oid oid2) throws GSSException {
        return new GSSNameImpl(this, byArray, oid, oid2);
    }

    public GSSCredential createCredential(int n2) throws GSSException {
        return new GSSCredentialImpl(this, n2);
    }

    public GSSCredential createCredential(GSSName gSSName, int n2, Oid oid, int n3) throws GSSException {
        return new GSSCredentialImpl(this, gSSName, n2, oid, n3);
    }

    public GSSCredential createCredential(GSSName gSSName, int n2, Oid[] oidArray, int n3) throws GSSException {
        return new GSSCredentialImpl(this, gSSName, n2, oidArray, n3);
    }

    public GSSContext createContext(GSSName gSSName, Oid oid, GSSCredential gSSCredential, int n2) throws GSSException {
        return new GSSContextImpl(this, gSSName, oid, gSSCredential, n2);
    }

    public GSSContext createContext(GSSCredential gSSCredential) throws GSSException {
        return new GSSContextImpl(this, gSSCredential);
    }

    public GSSContext createContext(byte[] byArray) throws GSSException {
        return new GSSContextImpl(this, byArray);
    }

    public void addProviderAtFront(Provider provider, Oid oid) throws GSSException {
        this.list.addProviderAtFront(provider, oid);
    }

    public void addProviderAtEnd(Provider provider, Oid oid) throws GSSException {
        this.list.addProviderAtEnd(provider, oid);
    }

    GSSCredentialSpi getCredentialElement(GSSNameSpi gSSNameSpi, int n2, int n3, Oid oid, int n4) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid);
        return mechanismFactory.getCredentialElement(gSSNameSpi, n2, n3, n4);
    }

    GSSNameSpi getNameElement(Object object, Oid oid, Oid oid2) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid2);
        if (object instanceof String) {
            return mechanismFactory.getNameElement((String)object, oid);
        }
        return mechanismFactory.getNameElement((byte[])object, oid);
    }

    GSSContextSpi getMechanismContext(GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n2, Oid oid) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid);
        return mechanismFactory.getMechanismContext(gSSNameSpi, gSSCredentialSpi, n2);
    }

    GSSContextSpi getMechanismContext(GSSCredentialSpi gSSCredentialSpi, Oid oid) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid);
        return mechanismFactory.getMechanismContext(gSSCredentialSpi);
    }

    GSSContextSpi getMechanismContext(byte[] byArray, Oid oid) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid);
        return mechanismFactory.getMechanismContext(byArray);
    }

    Oid getDefaultMechanism() {
        return this.list.getDefaultMechanism();
    }

    static boolean compareBytes(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

