/*********************************************************************
 *      common.h - common header file 
 * 
 *      Copyright (C) 1999-2000 Rui Sousa
 *********************************************************************
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU General Public License as
 *     published by the Free Software Foundation; either version 2 of
 *     the License, or (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *     USA.
 *********************************************************************
*/

#include <fcntl.h>
#include <linux/types.h>

/* Edit this settings to your liking */
#define DEBUG 0
#define WRITE_FILE 0

/* audio format */
#define SPEED  48000
#define CHANNELS 2
#define FORMAT AFMT_S16_LE

/* buffer parameters */
#define BUF_SIZE 2048 * CHANNELS
#define FRAGS 100
#define FRAGSHIFT 8

/* frequency in Hz channel array */
static const int freq[6] = {220, 330, 440, 660, 293, 55};

/* Volume percentage channel array */
static const int vol[6] = {100, 100, 100, 100, 100, 100};

/* ! Don't change anything bellow ! */

struct wave {
	double buf[BUF_SIZE];
	double w;
	double t0;
};

int setup(char *, mode_t);

void output_devbuf(__u8 *);
void fill_devbuf(struct wave *, __u8 *);

void print_info(int, mode_t);
