#    Copyright (C) 1989, 2000 Aladdin Enterprises.  All rights reserved.
# 
# This software is provided AS-IS with no warranty, either express or
# implied.
# 
# This software is distributed under license and may not be copied,
# modified or distributed except as expressly authorized under the terms
# of the license contained in the file LICENSE in this distribution.
# 
# For more information about licensing, please refer to
# http://www.ghostscript.com/licensing/. For information on
# commercial licensing, go to http://www.artifex.com/licensing/ or
# contact Artifex Software, Inc., 101 Lucas Valley Road #110,
# San Rafael, CA  94903, U.S.A., +1(415)492-9861.

# $Id: contrib.mak,v 1.27 2002/10/12 23:24:34 tillkamppeter Exp $
# makefile for contributed device drivers.

# Define the name of this makefile.
CONTRIB_MAK=$(GLSRC)contrib.mak

###### --------------------------- Catalog -------------------------- ######

# The following drivers are user-contributed, and maintained (if at all)
# by users.  Please do not ask Aladdin about problems with these drivers.

# Displays:
#   MS-DOS (note: not usable with Desqview/X):
#	herc	Hercules Graphics display   [MS-DOS only]
#	pe	Private Eye display
#   Unix and VMS:
#	att3b1	AT&T 3b1/Unixpc monochrome display   [3b1 only]
#	sonyfb	Sony Microsystems monochrome display   [Sony only]
#	sunview  SunView window system   [SunOS only]
# Printers:
#	alc2000	Epson AcuLaser C2000
#	alc4000	Epson AcuLaser C4000
#	alc8500	Epson AcuLaser C8500
#	alc8600	Epson AcuLaser C8600
#	ap3250	Epson AP3250 printer
#	appledmp  Apple Dot Matrix Printer (should also work with Imagewriter)
#	bj10e	Canon BubbleJet BJ10e
#	bj10v	Canon BubbleJet BJ10v/BJ15v (japanese)
#	bj10vh	Canon BubbleJet BJ10v/BJ15v/BJ35v (japanese)
#	bj200	Canon BubbleJet BJ200; also good for BJ300 in ProPrinter mode
#		(see comments in source code)
#	bjc600   Canon Color BubbleJet BJC-600, BJC-4000 and BJC-70
#               also good for Apple printers like the StyleWriter 2x00
#	bjc800   Canon Color BubbleJet BJC-800
#	bjc880j	 Canon Color BubbleJet BJC-880J (japanese)
#	bjccmyk  Canon Color BubbleJet BJC-210/240/250/250ex/265/1000
#	bjccolor Canon Color BubbleJet BJC-210 ... 1000 truecolor printing
#	bjcgray  Canon Color BubbleJet BJC-210 ... 1000 grayscale printing
#	bjcmono  Canon Color BubbleJet BJC-210 ... 1000 monochrome printing
#	ccr     CalComp Raster format
#	cdeskjet  H-P DeskJet 500C with 1 bit/pixel color
#	cdjcolor  H-P DeskJet 500C with 24 bit/pixel color and
#		high-quality color (Floyd-Steinberg) dithering;
#		also good for DeskJet 540C and Citizen Projet IIc (-r200x300)
#	cdjmono  H-P DeskJet 500C printing black only;
#		also good for DeskJet 510, 520, and 540C (black only)
#	cdj500	H-P DeskJet 500C (same as cdjcolor)
#	cdj550	H-P DeskJet 550C/560C/660C/660Cse
#	chp2200 H-P Business Inkjet 2200
#	cljet5	H-P Color LaserJet 5/5M (see below for some notes)
#	cljet5c  H-P Color LaserJet 5/5M (see below for some notes)
#	coslw2p  CoStar LabelWriter II II/Plus
#	coslwxl  CoStar LabelWriter XL
#	cp50	Mitsubishi CP50 color printer
#	declj250  alternate DEC LJ250 driver
#	dj505j  HP DeskJet 505 (japanese)
#	djet500c  H-P DeskJet 500C alternate driver
#		(does not work on 550C or 560C)
#	djet820c  HP DeskJet 820C (experimental driver)
#	dmprt	Dot Matrix PRinTers: NEC PC-H98 and others (japanese)
#	dnj650c	H-P DesignJet 650C
#	epl5800	Epson EPL-5800
#	epl5900	Epson EPL-5900
#	epl6100	Epson EPL-6100
#	epl2050	Epson EPL-N2050
#	epl2050p Epson EPL-N2050P
#	epl2120	Epson EPL-N2120
#	epson	Epson-compatible dot matrix printers (9- or 24-pin)
#	eps9mid  Epson-compatible 9-pin, interleaved lines
#		(intermediate resolution)
#	eps9high  Epson-compatible 9-pin, interleaved lines
#		(triple resolution)
#	epsonc	Epson LQ-2550 and Fujitsu 3400/2400/1200 color printers
#	escpage	Epson ESC/Page lasers, Epson LP-xx00 series (japanese)
#	fmpr	Fujitsu FMPR (japanese)
#	fmlbp	Fujitsu FMLBP2xx Page Printer (japanese)
#	gdi	Samsung's driver for their SmartGDI laser printers:
#		ML-4500, ML-2xx, ML-1xxx, ML-5080, ML-6040, ... and
#		Lexmark E210
#	hl7x0   Brother HL 720 and HL 730 (HL 760 is PCL compliant);
#		also usable with the MFC6550MC Fax Machine.
#	ibmpro  IBM 9-pin Proprinter
#	imagen	Imagen ImPress printers
#	iwhi	Apple Imagewriter in high-resolution mode
#	iwlo	Apple Imagewriter in low-resolution mode
#	iwlq	Apple Imagewriter LQ in 320 x 216 dpi mode
#	jetp3852  IBM Jetprinter ink-jet color printer (Model #3852)
#	jj100   Star JJ-100 (japanese)
#	lbp310	Canon LBP-310 (japanese)
#	lbp320	Canon LBP-320 Pro/LBP-350 (japanese)
#	lbp8	Canon LBP-8II laser printer
#       lex2050 Lexmark 2050
#       lex3200 Lexmark 3200
#       lex5700 Lexmark 5700
#       lex7000 Lexmark 7000, Lexmark IJ900, Compaq A900, Z51
#	lips2p	Canon LIPS-II+ (japanese)
#	lips3	Canon LIPS-III laser printer in English (CaPSL) mode
#	lips4	Canon LIPS-IV (japanese)
#	lips4v	Canon LIPS-IVv (japanese)
#	lj250	DEC LJ250 Companion color printer
#	lj3100sw H-P LaserJet 3100 (requires installed HP-Software)
#	lj4dith  H-P LaserJet 4 with Floyd-Steinberg dithering
#	ljet4pjl HP LaserJet 4V/4LJ Pro (japanese)
#	lj4dithp HP LaserJet 4V/4LJ Pro (japanese, Floyd-Steinberg
#		dithering)
#	lp1800	Epson LP-1800 laser printer
#	lp1900	Epson LP-1900 laser printer
#	lp2000	Epson LP-2000 laser printer (japanese)
#	lp2200	Epson LP-2200 laser printer
#	lp3000c	Epson LP-3000c laser printer
#	lp7700	Epson LP-7700 laser printer
#	lp8000	Epson LP-8000 laser printer
#	lp8000c	Epson LP-8000c laser printer
#	lp8100	Epson LP-8100 laser printer
#	lp8200c	Epson LP-8200c laser printer
#	lp8300c	Epson LP-8300c laser printer
#	lp8300f	Epson LP-8300f laser printer
#	lp8400f	Epson LP-8400f laser printer
#	lp8500c	Epson LP-8500c laser printer
#	lp8600	Epson LP-8600 laser printer
#	lp8600f	Epson LP-8600f laser printer
#	lp8700	Epson LP-8700 laser printer
#	lp8800c	Epson LP-8800c laser printer
#	lp8900	Epson LP-8900 laser printer
#	lp9300	Epson LP-9300 laser printer
#	lp9400	Epson LP-9400 laser printer
#	lp9600	Epson LP-9600 laser printer
#	lp9600s	Epson LP-9600s laser printer
#	lq850   Epson LQ850 printer at 360 x 360 DPI resolution;
#               also good for Canon BJ300 with LQ850 emulation
#	lx5000  Lexmark 5000
#	lxm3200 Lexmark 3200, Z31, Z12
#	lxm5700m Lexmark 5700 monochrome
#	m8510	C.Itoh M8510 printer
#	md1xMono Alps MD-1000/1300/1500 (monochrome mode, japanese)
#	md2k	Alps MD-2000/2010/4000/1000/1300/1500
#	md50Mono Alps MD-5000, Oki DP-5000 (monochrome mode, japanese)
#	md50Eco	Alps MD-5000, Oki DP-5000 (economy mode, japanese)
#	md5k	Alps MD-5000, Oki DP-5000
#	mj500c	Epson Stylus Color IIs, 200, 1500 (japanese)
#	mj700v2c Epson Stylus, Epson MachJet (japanese)
#	mj6000c	Epson Stylus Color 400, 800, 1520 (japanese)
#	mj8000c	Epson Stylus Color 3000 (japanese)
#	ml600	Okidata Microline 600CL/620CL (japanese)
#	necp6	NEC P6/P6+/P60 printers at 360 x 360 DPI resolution
#	npdl	NEC MultiWriter, PC-PR1000/PC-PR2000 (japanese)
#	nwp533  Sony Microsystems NWP533 laser printer   [Sony only]
#	oki182	Okidata MicroLine 182
#	okiibm	Okidata MicroLine IBM-compatible printers
#	paintjet  alternate H-P PaintJet color printer
#	pcl3    PCL-3 printers: Many, especially older HP inkjets,
#		non-HP inkjets as Sharp AJ, Xerox DocuPrint, ...
#	photoex  Epson Stylus Color Photo, Photo EX, Photo 700
#	picty180 NEC Picty 180 (japanese)
#	pj	H-P PaintJet XL driver 
#	pjetxl	alternate H-P PaintJet XL driver
#	pjxl	H-P PaintJet XL color printer
#	pjxl300  H-P PaintJet XL300 color printer;
#		also good for PaintJet 1200C and CopyJet
#	pr1000	NEC PC-PR 1000 (japanese)
#	pr1000_4 NEC PC-PR 1000/4 (japanese)
#	pr150	NEC PC-PR 150 (japanese)
#	pr201	NEC PC-PR 201 (japanese)
#	r4081	Ricoh 4081 laser printer
#       rpdl    Ricoh RPDL printers (japanese)
#	samsunggdi Samsung's driver for their SmartGDI laser printers:
#		ML-4500, ML-2xx, ML-1xxx, ML-5080, ML-6040, ... and
#		Lexmark E210
#	sj48	StarJet 48 inkjet printer
#	sparc	SPARCprinter
#	st800	Epson Stylus 800 printer
#	stcolor	Epson Stylus Color
#	t4693d2  Tektronix 4693d color printer, 2 bits per R/G/B component
#	t4693d4  Tektronix 4693d color printer, 4 bits per R/G/B component
#	t4693d8  Tektronix 4693d color printer, 8 bits per R/G/B component
#	tek4696  Tektronix 4695/4696 inkjet plotter
#	uniprint  Unified printer driver -- Configurable Color ESC/P-,
#		ESC/P2-, HP-RTL/PCL mono/color driver
# Fax systems:
# 	bff	Ferrari, electronic AG BFF fax format
#	cfax	SFF format for CAPI fax interface
#	dfaxhigh  DigiBoard, Inc.'s DigiFAX software format (high resolution)
#	dfaxlow  DigiFAX low (normal) resolution
# Other raster file formats and devices:
#	cif	CIF file format for VLSI
#	inferno  Inferno bitmaps
#	mag16	MAG file format (from Red Hat's japanese driver pack)
#	mag256	MAG file format (from Red Hat's japanese driver pack)
#	mgrmono  1-bit monochrome MGR devices
#	mgrgray2  2-bit gray scale MGR devices
#	mgrgray4  4-bit gray scale MGR devices
#	mgrgray8  8-bit gray scale MGR devices
#	mgr4	4-bit (VGA) color MGR devices
#	mgr8	8-bit color MGR devices
#	sgirgb	SGI RGB pixmap format
#	sunhmono  Harlequin variant of 1-bit Sun raster file

# If you add drivers, it would be nice if you keep each list
# in alphabetical order.

###### ----------------------- End of catalog ----------------------- ######

###### ------------------- MS-DOS display devices ------------------- ######

### ------------------- The Hercules Graphics display ------------------- ###

herc_=$(GLOBJ)gdevherc.$(OBJ)
$(DD)herc.dev : $(herc_)
	$(SETDEV) $(DD)herc $(herc_)

$(GLOBJ)gdevherc.$(OBJ) : $(GLSRC)gdevherc.c $(GDEV) $(dos__h)\
 $(gsmatrix_h) $(gxbitmap_h)
	$(GLCC) $(GLO_)gdevherc.$(OBJ) $(C_) $(GLSRC)gdevherc.c

### ---------------------- The Private Eye display ---------------------- ###
### Note: this driver was contributed by a user:                          ###
###   please contact narf@media-lab.media.mit.edu if you have questions.  ###

pe_=$(GLOBJ)gdevpe.$(OBJ)
$(DD)pe.dev : $(pe_)
	$(SETDEV) $(DD)pe $(pe_)

$(GLOBJ)gdevpe.$(OBJ) : $(GLSRC)gdevpe.c $(GDEV) $(memory__h)
	$(GLCC) $(GLO_)gdevpe.$(OBJ) $(C_) $(GLSRC)gdevpe.c

###### ----------------------- Other displays ------------------------ ######

### -------------- The AT&T 3b1 Unixpc monochrome display --------------- ###
### Note: this driver was contributed by a user: please contact           ###
###       Andy Fyfe (andy@cs.caltech.edu) if you have questions.          ###

att3b1_=$(GLOBJ)gdev3b1.$(OBJ)
$(DD)att3b1.dev : $(att3b1_)
	$(SETDEV) $(DD)att3b1 $(att3b1_)

$(GLOBJ)gdev3b1.$(OBJ) : $(GLSRC)gdev3b1.c $(GDEV)
	$(GLCC) $(GLO_)gdev3b1.$(OBJ) $(C_) $(GLSRC)gdev3b1.c

### ------------------- Sony NeWS frame buffer device ------------------ ###
### Note: this driver was contributed by a user: please contact          ###
###       Mike Smolenski (mike@intertech.com) if you have questions.     ###

# This is implemented as a 'printer' device.
sonyfb_=$(GLOBJ)gdevsnfb.$(OBJ)
$(DD)sonyfb.dev : $(sonyfb_) $(DD)page.dev
	$(SETPDEV) $(DD)sonyfb $(sonyfb_)

$(GLOBJ)gdevsnfb.$(OBJ) : $(GLSRC)gdevsnfb.c $(PDEVH)
	$(GLCC) $(GLO_)gdevsnfb.$(OBJ) $(C_) $(GLSRC)gdevsnfb.c

### ------------------------ The SunView device ------------------------ ###
### Note: this driver is maintained by a user: if you have questions,    ###
###       please contact Andreas Stolcke (stolcke@icsi.berkeley.edu).    ###

sunview_=$(GLOBJ)gdevsun.$(OBJ)
$(DD)sunview.dev : $(sunview_)
	$(SETDEV) $(DD)sunview $(sunview_)
	$(ADDMOD) $(GLGEN)sunview -lib suntool sunwindow pixrect

$(GLOBJ)gdevsun.$(OBJ) : $(GLSRC)gdevsun.c $(GDEV) $(malloc__h)\
 $(gscdefs_h) $(gserrors_h) $(gsmatrix_h)
	$(GLCC) $(GLO_)gdevsun.$(OBJ) $(C_) $(GLSRC)gdevsun.c

###### --------------- Memory-buffered printer devices --------------- ######

### --------------------- The Apple printer devices --------------------- ###
### Note: these drivers were contributed by users.                        ###
###   If you have questions about the DMP driver, please contact          ###
###	Mark Wedel (master@cats.ucsc.edu).                                ###
###   If you have questions about the Imagewriter drivers, please contact ###
###	Jonathan Luckey (luckey@rtfm.mlb.fl.us).                          ###
###   If you have questions about the Imagewriter LQ driver, please       ###
###	contact Scott Barker (barkers@cuug.ab.ca).                        ###

appledmp_=$(GLOBJ)gdevadmp.$(OBJ)

$(GLOBJ)gdevadmp.$(OBJ) : $(GLSRC)gdevadmp.c $(PDEVH)
	$(GLCC) $(GLO_)gdevadmp.$(OBJ) $(C_) $(GLSRC)gdevadmp.c

$(DD)appledmp.dev : $(appledmp_) $(DD)page.dev
	$(SETPDEV) $(DD)appledmp $(appledmp_)

$(DD)iwhi.dev : $(appledmp_) $(DD)page.dev
	$(SETPDEV) $(DD)iwhi $(appledmp_)

$(DD)iwlo.dev : $(appledmp_) $(DD)page.dev
	$(SETPDEV) $(DD)iwlo $(appledmp_)

$(DD)iwlq.dev : $(appledmp_) $(DD)page.dev
	$(SETPDEV) $(DD)iwlq $(appledmp_)

### ------------ The Canon BubbleJet BJ10e and BJ200 devices ------------ ###

bj10e_=$(GLOBJ)gdevbj10.$(OBJ)

$(DD)bj10e.dev : $(bj10e_) $(DD)page.dev
	$(SETPDEV) $(DD)bj10e $(bj10e_)

$(DD)bj200.dev : $(bj10e_) $(DD)page.dev
	$(SETPDEV) $(DD)bj200 $(bj10e_)

$(GLOBJ)gdevbj10.$(OBJ) : $(GLSRC)gdevbj10.c $(PDEVH)
	$(GLCC) $(GLO_)gdevbj10.$(OBJ) $(C_) $(GLSRC)gdevbj10.c

### ------------- The CalComp Raster Format ----------------------------- ###
### Note: this driver was contributed by a user: please contact           ###
###       Ernst Muellner (ernst.muellner@oenzl.siemens.de) if you have    ###
###       questions.                                                      ###

ccr_=$(GLOBJ)gdevccr.$(OBJ)
$(DD)ccr.dev : $(ccr_) $(DD)page.dev
	$(SETPDEV) $(DD)ccr $(ccr_)

$(GLOBJ)gdevccr.$(OBJ) : $(GLSRC)gdevccr.c $(PDEVH)
	$(GLCC) $(GLO_)gdevccr.$(OBJ) $(C_) $(GLSRC)gdevccr.c

### The H-P DeskJet, PaintJet, and DesignJet family color printer devices.###
### Note: there are two different 500C drivers, both contributed by users.###
###   If you have questions about the djet500c driver,                    ###
###       please contact AKayser@et.tudelft.nl.                           ###
###   If you have questions about the cdj* drivers,                       ###
###       please contact g.cameron@biomed.abdn.ac.uk.                     ###
###   If you have questions about the dnj560c driver,                     ###
###       please contact koert@zen.cais.com.                              ###
###   If you have questions about the lj4dith driver,                     ###
###       please contact Eckhard.Rueggeberg@ts.go.dlr.de.                 ###
###   The BJC600/BJC4000, BJC800, and ESCP were originally contributed    ###
###       by yves.arrouye@usa.net, but he no longer answers questions     ###
###       about them.                                                     ###

cdeskjet_=$(GLOBJ)gdevcdj.$(OBJ) $(HPPCL)

$(DD)cdeskjet.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)cdeskjet $(cdeskjet_)

$(DD)cdjcolor.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)cdjcolor $(cdeskjet_)

$(DD)cdjmono.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)cdjmono $(cdeskjet_)

$(DD)cdj500.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)cdj500 $(cdeskjet_)

$(DD)cdj550.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)cdj550 $(cdeskjet_)

$(DD)declj250.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)declj250 $(cdeskjet_)

$(DD)dnj650c.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)dnj650c $(cdeskjet_)

$(DD)lj4dith.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)lj4dith $(cdeskjet_)

$(DD)pj.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)pj $(cdeskjet_)

$(DD)pjxl.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)pjxl $(cdeskjet_)

# Note: the pjxl300 driver also works for the CopyJet.
$(DD)pjxl300.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)pjxl300 $(cdeskjet_)

# Note: the BJC600 driver also works for the BJC4000.
$(DD)bjc600.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)bjc600 $(cdeskjet_)

$(DD)bjc800.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)bjc800 $(cdeskjet_)

$(DD)escp.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)escp $(cdeskjet_)

$(DD)escpc.dev : $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)escpc $(cdeskjet_)

# NB: you can also customise the build if required, using
# -DBitsPerPixel=<number> if you wish the default to be other than 24
# for the generic drivers (cdj500, cdj550, pjxl300, pjtest, pjxltest).

gdevbjc_h=$(GLSRC)gdevbjc.h

$(GLOBJ)gdevcdj.$(OBJ) : $(GLSRC)gdevcdj.c $(std_h) $(PDEVH)\
 $(gsparam_h) $(gsstate_h) $(gxlum_h)\
 $(gdevbjc_h) $(gdevpcl_h)
	$(GLCC) $(GLO_)gdevcdj.$(OBJ) $(C_) $(GLSRC)gdevcdj.c

djet500c_=$(GLOBJ)gdevdjtc.$(OBJ) $(HPPCL)
$(DD)djet500c.dev : $(djet500c_) $(DD)page.dev
	$(SETPDEV) $(DD)djet500c $(djet500c_)

$(GLOBJ)gdevdjtc.$(OBJ) : $(GLSRC)gdevdjtc.c $(PDEVH) $(malloc__h) $(gdevpcl_h)
	$(GLCC) $(GLO_)gdevdjtc.$(OBJ) $(C_) $(GLSRC)gdevdjtc.c

### ----------------- The BJC-210/240/250/250ex/265/1000 ---------------- ###

### 
### For questions about the driver, mailto://szaszg@hu.inter.net
### http://bjc250gs.sourceforge.net
###

bjc_h=$(GLSRC)gdevbjc_.h

bjc_=$(GLOBJ)gdevbjc_.$(OBJ) $(GLOBJ)gdevbjca.$(OBJ)

$(GLOBJ)gdevbjc_.$(OBJ) : $(GLSRC)gdevbjc_.c $(PDEVH) $(bjc_h)
	$(GLCC) $(GLO_)gdevbjc_.$(OBJ) $(C_) $(GLSRC)gdevbjc_.c

$(GLOBJ)gdevbjca.$(OBJ) : $(GLSRC)gdevbjca.c $(PDEVH) $(bjc_h)
	$(GLCC) $(GLO_)gdevbjca.$(OBJ) $(C_) $(GLSRC)gdevbjca.c

$(DD)bjcmono.dev : $(bjc_) $(DD)page.dev
	$(SETPDEV) $(DD)bjcmono $(bjc_)

$(DD)bjcgray.dev : $(bjc_) $(DD)page.dev
	$(SETPDEV) $(DD)bjcgray $(bjc_)

$(DD)bjccmyk.dev : $(bjc_) $(DD)page.dev
	$(SETPDEV) $(DD)bjccmyk $(bjc_)

$(DD)bjccolor.dev : $(bjc_) $(DD)page.dev
	$(SETPDEV) $(DD)bjccolor $(bjc_)

### -------------------- The H-P Color LaserJet 5/5M -------------------- ###

### There are two different drivers for this device.
### For questions about the cljet5/cljet5pr (more general) driver, contact
###	Jan Stoeckenius <jan@orimp.com>
### For questions about the cljet5c (simple) driver, contact
###	Henry Stiles <henrys@meerkat.dimensional.com>
### Note that this is a long-edge-feed device, so the default page size is
### wider than it is high.  To print portrait pages, specify the page size
### explicitly, e.g. -c letter or -c a4 on the command line.

cljet5_=$(GLOBJ)gdevclj.$(OBJ) $(HPPCL)

$(DD)cljet5.dev : $(DEVS_MAK) $(cljet5_) $(GLD)page.dev
	$(SETPDEV) $(DD)cljet5 $(cljet5_)

# The cljet5pr driver has hacks for trying to handle page rotation.
# The hacks only work with one special PCL interpreter.  Don't use it!
$(DD)cljet5pr.dev : $(DEVS_MAK) $(cljet5_) $(GLD)page.dev
	$(SETPDEV) $(DD)cljet5pr $(cljet5_)

$(GLOBJ)gdevclj.$(OBJ) : $(GLSRC)gdevclj.c $(math__h) $(PDEVH)\
 $(gx_h) $(gsparam_h) $(gdevpcl_h)
	$(GLCC) $(GLO_)gdevclj.$(OBJ) $(C_) $(GLSRC)gdevclj.c

cljet5c_=$(GLOBJ)gdevcljc.$(OBJ) $(HPPCL)
$(DD)cljet5c.dev : $(DEVS_MAK) $(cljet5c_) $(GLD)page.dev
	$(SETPDEV) $(DD)cljet5c $(cljet5c_)

$(GLOBJ)gdevcljc.$(OBJ) : $(GLSRC)gdevcljc.c $(math__h) $(PDEVH) $(gdevpcl_h)
	$(GLCC) $(GLO_)gdevcljc.$(OBJ) $(C_) $(GLSRC)gdevcljc.c

### --------------- The H-P LaserJet 3100 software device --------------- ###

### NOTE: This driver requires installed HP-Software to print.            ###
###       It can be used with smbclient to print from an UNIX box to a    ###
###       LaserJet 3100 printer attached to a MS-Windows box.             ###
### NOTE: this driver was contributed by a user: please contact           ###
###       Ulrich Schmid (uschmid@mail.hh.provi.de) if you have questions. ###

lj3100sw_=$(GLOBJ)gdevl31s.$(OBJ) $(GLOBJ)gdevmeds.$(OBJ)
$(DD)lj3100sw.dev : $(lj3100sw_) $(DD)page.dev
	$(SETPDEV) $(DD)lj3100sw $(lj3100sw_)

gdevmeds_h=$(GLSRC)gdevmeds.h $(gdevprn_h)

$(GLOBJ)gdevl31s.$(OBJ) : $(GLSRC)gdevl31s.c $(gdevmeds_h) $(PDEVH)
	$(GLCC) $(GLO_)gdevl31s.$(OBJ) $(C_) $(GLSRC)gdevl31s.c

$(GLOBJ)gdevmeds.$(OBJ) : $(GLSRC)gdevmeds.c $(AK) $(gdevmeds_h)
	$(GLCC) $(GLO_)gdevmeds.$(OBJ) $(C_) $(GLSRC)gdevmeds.c

### ------ CoStar LabelWriter II II/Plus device ------ ###
### Contributed by Mike McCauley mikem@open.com.au     ###

coslw_=$(GLOBJ)gdevcslw.$(OBJ)

$(DD)coslw2p.dev : $(coslw_) $(DD)page.dev
	$(SETPDEV) $(DD)coslw2p $(coslw_)

$(DD)coslwxl.dev : $(coslw_) $(DD)page.dev
	$(SETPDEV) $(DD)coslwxl $(coslw_)

$(GLOBJ)gdevcslw.$(OBJ) : $(GLSRC)gdevcslw.c $(PDEVH)
	$(GLCC) $(GLO_)gdevcslw.$(OBJ) $(C_) $(GLSRC)gdevcslw.c

### -------------------- The Mitsubishi CP50 printer -------------------- ###
### Note: this driver was contributed by a user: please contact           ###
###       Michael Hu (michael@ximage.com) if you have questions.          ###

cp50_=$(GLOBJ)gdevcp50.$(OBJ)
$(DD)cp50.dev : $(cp50_) $(DD)page.dev
	$(SETPDEV) $(DD)cp50 $(cp50_)

$(GLOBJ)gdevcp50.$(OBJ) : $(GLSRC)gdevcp50.c $(PDEVH)
	$(GLCC) $(GLO_)gdevcp50.$(OBJ) $(C_) $(GLSRC)gdevcp50.c

### ----------------- The generic Epson printer device ----------------- ###
### Note: most of this code was contributed by users.  Please contact    ###
###       the following people if you have questions:                    ###
###   eps9mid - Guenther Thomsen (thomsen@cs.tu-berlin.de)               ###
###   eps9high - David Wexelblat (dwex@mtgzfs3.att.com)                  ###
###   ibmpro - James W. Birdsall (jwbirdsa@picarefy.picarefy.com)        ###

epson_=$(GLOBJ)gdevepsn.$(OBJ)

$(DD)epson.dev : $(epson_) $(DD)page.dev
	$(SETPDEV) $(DD)epson $(epson_)

$(DD)eps9mid.dev : $(epson_) $(DD)page.dev
	$(SETPDEV) $(DD)eps9mid $(epson_)

$(DD)eps9high.dev : $(epson_) $(DD)page.dev
	$(SETPDEV) $(DD)eps9high $(epson_)

$(GLOBJ)gdevepsn.$(OBJ) : $(GLSRC)gdevepsn.c $(PDEVH)
	$(GLCC) $(GLO_)gdevepsn.$(OBJ) $(C_) $(GLSRC)gdevepsn.c

### ----------------- The IBM Proprinter printer device ---------------- ###

$(DD)ibmpro.dev : $(epson_) $(DD)page.dev
	$(SETPDEV) $(DD)ibmpro $(epson_)

### -------------- The Epson LQ-2550 color printer device -------------- ###
### Note: this driver was contributed by users: please contact           ###
###       Dave St. Clair (dave@exlog.com) if you have questions.         ###

epsonc_=$(GLOBJ)gdevepsc.$(OBJ)
$(DD)epsonc.dev : $(epsonc_) $(DD)page.dev
	$(SETPDEV) $(DD)epsonc $(epsonc_)

$(GLOBJ)gdevepsc.$(OBJ) : $(GLSRC)gdevepsc.c $(PDEVH)
	$(GLCC) $(GLO_)gdevepsc.$(OBJ) $(C_) $(GLSRC)gdevepsc.c

### ------------- The Epson ESC/P 2 language printer devices ------------- ###
### Note: these drivers were contributed by users.                         ###
### For questions about the Stylus 800 and AP3250 drivers, please contact  ###
###        Richard Brown (rab@tauon.ph.unimelb.edu.au).                    ###
### For questions about the Stylus Color drivers, please contact           ###
###        Gunther Hess (gunther@elmos.de).                                ###

ESCP2=$(GLOBJ)gdevescp.$(OBJ)

$(GLOBJ)gdevescp.$(OBJ) : $(GLSRC)gdevescp.c $(PDEVH)
	$(GLCC) $(GLO_)gdevescp.$(OBJ) $(C_) $(GLSRC)gdevescp.c

$(DD)ap3250.dev : $(ESCP2) $(DD)page.dev
	$(SETPDEV) $(DD)ap3250 $(ESCP2)

$(DD)st800.dev : $(ESCP2) $(DD)page.dev
	$(SETPDEV) $(DD)st800 $(ESCP2)

stcolor1_=$(GLOBJ)gdevstc.$(OBJ) $(GLOBJ)gdevstc1.$(OBJ) $(GLOBJ)gdevstc2.$(OBJ)
stcolor2_=$(GLOBJ)gdevstc3.$(OBJ) $(GLOBJ)gdevstc4.$(OBJ)
$(DD)stcolor.dev : $(stcolor1_) $(stcolor2_) $(DD)page.dev
	$(SETPDEV) $(DD)stcolor $(stcolor1_)
	$(ADDMOD) $(GLGEN)stcolor -obj $(stcolor2_)

gdevstc_h=$(GLSRC)gdevstc.h $(gdevprn_h) $(gsparam_h) $(gsstate_h)

$(GLOBJ)gdevstc.$(OBJ) : $(GLSRC)gdevstc.c $(gdevstc_h) $(PDEVH)
	$(GLCC) $(GLO_)gdevstc.$(OBJ) $(C_) $(GLSRC)gdevstc.c

$(GLOBJ)gdevstc1.$(OBJ) : $(GLSRC)gdevstc1.c $(gdevstc_h) $(PDEVH)
	$(GLCC) $(GLO_)gdevstc1.$(OBJ) $(C_) $(GLSRC)gdevstc1.c

$(GLOBJ)gdevstc2.$(OBJ) : $(GLSRC)gdevstc2.c $(gdevstc_h) $(PDEVH)
	$(GLCC) $(GLO_)gdevstc2.$(OBJ) $(C_) $(GLSRC)gdevstc2.c

$(GLOBJ)gdevstc3.$(OBJ) : $(GLSRC)gdevstc3.c $(gdevstc_h) $(PDEVH)
	$(GLCC) $(GLO_)gdevstc3.$(OBJ) $(C_) $(GLSRC)gdevstc3.c

$(GLOBJ)gdevstc4.$(OBJ) : $(GLSRC)gdevstc4.c $(gdevstc_h) $(PDEVH)
	$(GLCC) $(GLO_)gdevstc4.$(OBJ) $(C_) $(GLSRC)gdevstc4.c

###--------------- Added Omni --------------------------###

epclr_h1=$(GLSRC)defs.h

$(DD)omni.dev : $(GLOBJ)gomni.$(OBJ) $(DD)page.dev $(DD)bmp16m.dev
	$(SETPDEV) $(DD)omni $(GLOBJ)gomni.$(OBJ)

$(GLOBJ)gomni.$(OBJ) : $(GLSRC)gomni.c $(epclr_h1) $(PDEVH)
	$(GLCC) $(GLO_)gomni.$(OBJ) $(C_) $(GLSRC)gomni.c

### --------------- Ugly/Update -> Unified Printer Driver ---------------- ###
### For questions about this driver, please contact:                       ###
###        Gunther Hess (gunther@elmos.de)                                 ###

uniprint_=$(GLOBJ)gdevupd.$(OBJ)
$(DD)uniprint.dev : $(uniprint_) $(DD)page.dev
	$(SETPDEV) $(DD)uniprint $(uniprint_)

$(GLOBJ)gdevupd.$(OBJ) : $(GLSRC)gdevupd.c $(PDEVH) $(gsparam_h)
	$(GLCC) $(GLO_)gdevupd.$(OBJ) $(C_) $(GLSRC)gdevupd.c

### ------------- Hewlett-Packard Co. Inkjet Driver -------------- ###

hpijs_=$(GLOBJ)gdevhpij.$(OBJ)

$(GLOBJ)gdevhpij.$(OBJ) : $(GLSRC)gdevhpij.c $(PDEVH)
	$(GLCC) $(GLO_)gdevhpij.$(OBJ) $(C_) $(GLSRC)gdevhpij.c

$(DD)DJ630.dev : $(hpijs_) $(DD)page.dev
	$(SETPDEV) $(DD)DJ630 $(hpijs_)

$(DD)DJ6xx.dev : $(hpijs_) $(DD)page.dev
	$(SETPDEV) $(DD)DJ6xx $(hpijs_)

$(DD)DJ6xxP.dev : $(hpijs_) $(DD)page.dev
	$(SETPDEV) $(DD)DJ6xxP $(hpijs_)

$(DD)DJ8xx.dev : $(hpijs_) $(DD)page.dev
	$(SETPDEV) $(DD)DJ8xx $(hpijs_)

$(DD)DJ9xx.dev : $(hpijs_) $(DD)page.dev
	$(SETPDEV) $(DD)DJ9xx $(hpijs_)

$(DD)DJ9xxVIP.dev : $(hpijs_) $(DD)page.dev
	$(SETPDEV) $(DD)DJ9xxVIP $(hpijs_)

$(DD)AP21xx.dev : $(hpijs_) $(DD)page.dev
	$(SETPDEV) $(DD)AP21xx $(hpijs_)

### ------------ The H-P PaintJet color printer device ----------------- ###
### Note: this driver also supports the DEC LJ250 color printer, which   ###
###       has a PaintJet-compatible mode, and the PaintJet XL.           ###
### If you have questions about the XL, please contact Rob Reiss         ###
###       (rob@moray.berkeley.edu).                                      ###

PJET=$(GLOBJ)gdevpjet.$(OBJ) $(HPPCL)

$(GLOBJ)gdevpjet.$(OBJ) : $(GLSRC)gdevpjet.c $(PDEVH) $(gdevpcl_h)
	$(GLCC) $(GLO_)gdevpjet.$(OBJ) $(C_) $(GLSRC)gdevpjet.c

$(DD)lj250.dev : $(PJET) $(DD)page.dev
	$(SETPDEV) $(DD)lj250 $(PJET)

$(DD)paintjet.dev : $(PJET) $(DD)page.dev
	$(SETPDEV) $(DD)paintjet $(PJET)

$(DD)pjetxl.dev : $(PJET) $(DD)page.dev
	$(SETPDEV) $(DD)pjetxl $(PJET)

###--------------------- The Brother HL 7x0 printer --------------------- ### 
### Note: this driver was contributed by users: please contact            ###
###       Pierre-Olivier Gaillard (pierre.gaillard@hol.fr)                ###
###         for questions about the basic driver;                         ###
###       Ross Martin (ross@ross.interwrx.com, martin@walnut.eas.asu.edu) ###
###         for questions about usage with the MFC6550MC Fax Machine.     ###

hl7x0_=$(GLOBJ)gdevhl7x.$(OBJ)
$(DD)hl7x0.dev : $(hl7x0_) $(DD)page.dev
	$(SETPDEV) $(DD)hl7x0 $(hl7x0_)

$(GLOBJ)gdevhl7x.$(OBJ) : $(GLSRC)gdevhl7x.c $(PDEVH) $(gdevpcl_h)
	$(GLCC) $(GLO_)gdevhl7x.$(OBJ) $(C_) $(GLSRC)gdevhl7x.c

### -------------- Imagen ImPress Laser Printer device ----------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Alan Millar (AMillar@bolis.sf-bay.org) if you have questions.  ###
### Set USE_BYTE_STREAM if using parallel interface;                     ###
### Don't set it if using 'ipr' spooler (default).                       ###
### You may also add -DA4 if needed for A4 paper.			 ###

imagen_=$(GLOBJ)gdevimgn.$(OBJ)
$(DD)imagen.dev : $(imagen_) $(DD)page.dev
	$(SETPDEV) $(DD)imagen $(imagen_)

# Uncomment the first line for the ipr spooler, the second line for parallel.
IMGN_OPT=
#IMGN_OPT=-DUSE_BYTE_STREAM
$(GLOBJ)gdevimgn.$(OBJ) : $(GLSRC)gdevimgn.c $(PDEVH)
	$(GLCC) $(IMGN_OPT) $(GLO_)gdevimgn.$(OBJ) $(C_) $(GLSRC)gdevimgn.c

### ------- The IBM 3852 JetPrinter color inkjet printer device -------- ###
### Note: this driver was contributed by users: please contact           ###
###       Kevin Gift (kgift@draper.com) if you have questions.           ###
### Note that the paper size that can be addressed by the graphics mode  ###
###   used in this driver is fixed at 7-1/2 inches wide (the printable   ###
###   width of the jetprinter itself.)                                   ###

jetp3852_=$(GLOBJ)gdev3852.$(OBJ)
$(DD)jetp3852.dev : $(jetp3852_) $(DD)page.dev
	$(SETPDEV) $(DD)jetp3852 $(jetp3852_)

$(GLOBJ)gdev3852.$(OBJ) : $(GLSRC)gdev3852.c $(PDEVH) $(gdevpcl_h)
	$(GLCC) $(GLO_)gdev3852.$(OBJ) $(C_) $(GLSRC)gdev3852.c

### ---------- The Canon LBP-8II and LIPS III printer devices ---------- ###
### Note: these drivers were contributed by users.                       ###
### For questions about these drivers, please contact                    ###
###       Lauri Paatero, lauri.paatero@paatero.pp.fi                     ###

lbp8_=$(GLOBJ)gdevlbp8.$(OBJ)
$(DD)lbp8.dev : $(lbp8_) $(DD)page.dev
	$(SETPDEV) $(DD)lbp8 $(lbp8_)

$(DD)lips3.dev : $(lbp8_) $(DD)page.dev
	$(SETPDEV) $(DD)lips3 $(lbp8_)

$(GLOBJ)gdevlbp8.$(OBJ) : $(GLSRC)gdevlbp8.c $(PDEVH)
	$(GLCC) $(GLO_)gdevlbp8.$(OBJ) $(C_) $(GLSRC)gdevlbp8.c

### -------------- The Epson LP-8000 laser printer device -------------- ###
### Note: this driver was contributed by a user: please contact Oleg     ###
###       Oleg Fat'yanov <faty1@rlem.titech.ac.jp> if you have questions.###

lp8000_=$(GLOBJ)gdevlp8k.$(OBJ)
$(DD)lp8000.dev : $(lp8000_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8000 $(lp8000_)

$(GLOBJ)gdevlp8k.$(OBJ) : $(GLSRC)gdevlp8k.c $(PDEVH)
	$(GLCC) $(GLO_)gdevlp8k.$(OBJ) $(C_) $(GLSRC)gdevlp8k.c

### -------------- The C.Itoh M8510 printer device --------------------- ###
### Note: this driver was contributed by a user: please contact Bob      ###
###       Smith <bob@snuffy.penfield.ny.us> if you have questions.       ###

m8510_=$(GLOBJ)gdev8510.$(OBJ)
$(DD)m8510.dev : $(m8510_) $(DD)page.dev
	$(SETPDEV) $(DD)m8510 $(m8510_)

$(GLOBJ)gdev8510.$(OBJ) : $(GLSRC)gdev8510.c $(PDEVH)
	$(GLCC) $(GLO_)gdev8510.$(OBJ) $(C_) $(GLSRC)gdev8510.c

### -------------- 24pin Dot-matrix printer with 360DPI ---------------- ###
### Note: this driver was contributed by users.  Please contact:         ###
###    Andreas Schwab (schwab@ls5.informatik.uni-dortmund.de) for        ###
###      questions about the NEC P6;                                     ###
###    Christian Felsch (felsch@tu-harburg.d400.de) for                  ###
###      questions about the Epson LQ850.                                ###

dm24_=$(GLOBJ)gdevdm24.$(OBJ)
$(DD)necp6.dev : $(dm24_) $(DD)page.dev
	$(SETPDEV) $(DD)necp6 $(dm24_)

$(DD)lq850.dev : $(dm24_) $(DD)page.dev
	$(SETPDEV) $(DD)lq850 $(dm24_)

$(GLOBJ)gdevdm24.$(OBJ) : $(GLSRC)gdevdm24.c $(PDEVH)
	$(GLCC) $(GLO_)gdevdm24.$(OBJ) $(C_) $(GLSRC)gdevdm24.c

### ----------------- Lexmark 5700 printer ----------------------------- ###
### Note: this driver was contributed by users.  Please contact:         ###
###   Stephen Taylor (setaylor@ma.ultranet.com) if you have questions.   ###

lxm5700m_=$(GLOBJ)gdevlxm.$(OBJ)
$(DD)lxm5700m.dev : $(lxm5700m_) $(DD)page.dev
	$(SETPDEV) $(DD)lxm5700m $(lxm5700m_)

$(GLOBJ)gdevlxm.$(OBJ) : $(GLSRC)gdevlxm.c $(PDEVH) $(gsparams_h)
	$(GLCC) $(GLO_)gdevlxm.$(OBJ) $(C_) $(GLSRC)gdevlxm.c

### ----------------- The Okidata MicroLine 182 device ----------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Maarten Koning (smeg@bnr.ca) if you have questions.            ###

oki182_=$(GLOBJ)gdevo182.$(OBJ)
$(DD)oki182.dev : $(oki182_) $(DD)page.dev
	$(SETPDEV) $(DD)oki182 $(oki182_)

$(GLOBJ)gdevo182.$(OBJ) : $(GLSRC)gdevo182.c $(PDEVH)
	$(GLCC) $(GLO_)gdevo182.$(OBJ) $(C_) $(GLSRC)gdevo182.c

### ------------- The Okidata IBM compatible printer device ------------ ###
### Note: this driver was contributed by a user: please contact          ###
###       Charles Mack (chasm@netcom.com) if you have questions.         ###

okiibm_=$(GLOBJ)gdevokii.$(OBJ)
$(DD)okiibm.dev : $(okiibm_) $(DD)page.dev
	$(SETPDEV) $(DD)okiibm $(okiibm_)

$(GLOBJ)gdevokii.$(OBJ) : $(GLSRC)gdevokii.c $(PDEVH)
	$(GLCC) $(GLO_)gdevokii.$(OBJ) $(C_) $(GLSRC)gdevokii.c

### ------------------ The Epson Stylus Photo devices ------------------ ###
### This driver was contributed by a user: please contact                ###
###	Zoltan Kocsi (zoltan@bendor.com.au) if you have questions.       ###

photoex_=$(GLOBJ)gdevphex.$(OBJ)
$(DD)photoex.dev : $(photoex_) $(DD)page.dev
	$(SETPDEV) $(DD)photoex $(photoex_)

$(GLOBJ)gdevphex.$(OBJ) : $(GLSRC)gdevphex.c $(PDEVH)
	$(GLCC) $(GLO_)gdevphex.$(OBJ) $(C_) $(GLSRC)gdevphex.c

### ------------- The Ricoh 4081 laser printer device ------------------ ###
### Note: this driver was contributed by users:                          ###
###       please contact kdw@oasis.icl.co.uk if you have questions.      ###

r4081_=$(GLOBJ)gdev4081.$(OBJ)
$(DD)r4081.dev : $(r4081_) $(DD)page.dev
	$(SETPDEV) $(DD)r4081 $(r4081_)


$(GLOBJ)gdev4081.$(OBJ) : $(GLSRC)gdev4081.c $(PDEVH)
	$(GLCC) $(GLO_)gdev4081.$(OBJ) $(C_) $(GLSRC)gdev4081.c

### -------------------- Sony NWP533 printer device -------------------- ###
### Note: this driver was contributed by a user: please contact Tero     ###
###       Kivinen (kivinen@joker.cs.hut.fi) if you have questions.       ###

nwp533_=$(GLOBJ)gdevn533.$(OBJ)
$(DD)nwp533.dev : $(nwp533_) $(DD)page.dev
	$(SETPDEV) $(DD)nwp533 $(nwp533_)

$(GLOBJ)gdevn533.$(OBJ) : $(GLSRC)gdevn533.c $(PDEVH)
	$(GLCC) $(GLO_)gdevn533.$(OBJ) $(C_) $(GLSRC)gdevn533.c

### ------------------------- The SPARCprinter ------------------------- ###
### Note: this driver was contributed by users: please contact Martin    ###
###       Schulte (schulte@thp.uni-koeln.de) if you have questions.      ###
###       He would also like to hear from anyone using the driver.       ###
### Please consult the source code for additional documentation.         ###

sparc_=$(GLOBJ)gdevsppr.$(OBJ)
$(DD)sparc.dev : $(sparc_) $(DD)page.dev
	$(SETPDEV) $(DD)sparc $(sparc_)

$(GLOBJ)gdevsppr.$(OBJ) : $(GLSRC)gdevsppr.c $(PDEVH)
	$(GLCC) $(GLO_)gdevsppr.$(OBJ) $(C_) $(GLSRC)gdevsppr.c

### ----------------- The StarJet SJ48 device -------------------------- ###
### Note: this driver was contributed by a user: if you have questions,  ###
###	                      .                                          ###
###       please contact Mats Akerblom (f86ma@dd.chalmers.se).           ###

sj48_=$(GLOBJ)gdevsj48.$(OBJ)
$(DD)sj48.dev : $(sj48_) $(DD)page.dev
	$(SETPDEV) $(DD)sj48 $(sj48_)

$(GLOBJ)gdevsj48.$(OBJ) : $(GLSRC)gdevsj48.c $(PDEVH)
	$(GLCC) $(GLO_)gdevsj48.$(OBJ) $(C_) $(GLSRC)gdevsj48.c

### ----------------- Tektronix 4396d color printer -------------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Karl Hakimian (hakimian@haney.eecs.wsu.edu)                    ###
###       if you have questions.                                         ###

t4693d_=$(GLOBJ)gdev4693.$(OBJ)
$(DD)t4693d2.dev : $(t4693d_) $(DD)page.dev
	$(SETPDEV) $(DD)t4693d2 $(t4693d_)

$(DD)t4693d4.dev : $(t4693d_) $(DD)page.dev
	$(SETPDEV) $(DD)t4693d4 $(t4693d_)

$(DD)t4693d8.dev : $(t4693d_) $(DD)page.dev
	$(SETPDEV) $(DD)t4693d8 $(t4693d_)

$(GLOBJ)gdev4693.$(OBJ) : $(GLSRC)gdev4693.c $(PDEVH)
	$(GLCC) $(GLO_)gdev4693.$(OBJ) $(C_) $(GLSRC)gdev4693.c

### -------------------- Tektronix ink-jet printers -------------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Karsten Spang (spang@nbivax.nbi.dk) if you have questions.     ###

tek4696_=$(GLOBJ)gdevtknk.$(OBJ)
$(DD)tek4696.dev : $(tek4696_) $(DD)page.dev
	$(SETPDEV) $(DD)tek4696 $(tek4696_)

$(GLOBJ)gdevtknk.$(OBJ) : $(GLSRC)gdevtknk.c $(PDEVH) $(malloc__h)
	$(GLCC) $(GLO_)gdevtknk.$(OBJ) $(C_) $(GLSRC)gdevtknk.c

###### ------------------------- Fax devices ------------------------- ######

### ------------------------- CAPI fax devices -------------------------- ###
### Note: this driver was contributed by a user: please contact           ###
###       Peter Schaefer <peter.schaefer@gmx.de> if you have questions.   ###

cfax_=$(GLOBJ)gdevcfax.$(OBJ)

$(DD)cfax.dev : $(cfax_) $(DD)fax.dev
	$(SETDEV) $(DD)cfax $(cfax_)
	$(ADDMOD) $(DD)cfax -include $(DD)fax

$(GLOBJ)gdevcfax.$(OBJ) : $(GLSRC)gdevcfax.c $(PDEVH)\
 $(gdevfax_h) $(scfx_h) $(strimpl_h)
	$(GLCC) $(GLO_)gdevcfax.$(OBJ) $(C_) $(GLSRC)gdevcfax.c

### ------------------------- The DigiFAX device ------------------------ ###
###    This driver outputs images in a format suitable for use with       ###
###    DigiBoard, Inc.'s DigiFAX software.  Use -sDEVICE=dfaxhigh for     ###
###    high resolution output, -sDEVICE=dfaxlow for normal output.        ###
### Note: this driver was contributed by a user: please contact           ###
###       Rick Richardson (rick@digibd.com) if you have questions.        ###

dfax_=$(GLOBJ)gdevdfax.$(OBJ)

$(DD)dfaxlow.dev : $(dfax_) $(DD)tfax.dev
	$(SETDEV) $(DD)dfaxlow $(dfax_)
	$(ADDMOD) $(GLGEN)dfaxlow -include $(DD)tfax

$(DD)dfaxhigh.dev : $(dfax_) $(DD)tfax.dev
	$(SETDEV) $(DD)dfaxhigh $(dfax_)
	$(ADDMOD) $(GLGEN)dfaxhigh -include $(DD)tfax

$(GLOBJ)gdevdfax.$(OBJ) : $(GLSRC)gdevdfax.c $(PDEVH)\
 $(gdevfax_h) $(gdevtfax_h) $(scfx_h) $(strimpl_h)
	$(GLCC) $(GLO_)gdevdfax.$(OBJ) $(C_) $(GLSRC)gdevdfax.c

###### --------------------- Raster file formats --------------------- ######

### -------------------- The CIF file format for VLSI ------------------ ###
### Note: this driver was contributed by a user: please contact          ###
###       Frederic Petrot (petrot@masi.ibp.fr) if you have questions.    ###

cif_=$(GLOBJ)gdevcif.$(OBJ)
$(DD)cif.dev : $(cif_) $(DD)page.dev
	$(SETPDEV) $(DD)cif $(cif_)

$(GLOBJ)gdevcif.$(OBJ) : $(GLSRC)gdevcif.c $(PDEVH)
	$(GLCC) $(GLO_)gdevcif.$(OBJ) $(C_) $(GLSRC)gdevcif.c

### ------------------------- Inferno bitmaps -------------------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Russ Cox <rsc@plan9.bell-labs.com> if you have questions.      ###

inferno_=$(GLOBJ)gdevifno.$(OBJ)
$(DD)inferno.dev : $(inferno_) $(DD)page.dev
	$(SETPDEV) $(DD)inferno $(inferno_)

$(GLOBJ)gdevifno.$(OBJ) : $(GLSRC)gdevifno.c $(PDEVH)\
 $(gsparam_h) $(gxlum_h)
	$(GLCC) $(GLO_)gdevifno.$(OBJ) $(C_) $(GLSRC)gdevifno.c

### --------------------------- MGR devices ---------------------------- ###
### Note: these drivers were contributed by a user: please contact       ###
###       Carsten Emde (ce@ceag.ch) if you have questions.               ###

MGR=$(GLOBJ)gdevmgr.$(OBJ) $(GLOBJ)gdevpccm.$(OBJ)

gdevmgr_h= $(GLSRC)gdevmgr.h

$(GLOBJ)gdevmgr.$(OBJ) : $(GLSRC)gdevmgr.c $(PDEVH)\
 $(gdevmgr_h) $(gdevpccm_h)
	$(GLCC) $(GLO_)gdevmgr.$(OBJ) $(C_) $(GLSRC)gdevmgr.c

$(DD)mgrmono.dev : $(MGR) $(DD)page.dev
	$(SETPDEV) $(DD)mgrmono $(MGR)

$(DD)mgrgray2.dev : $(MGR) $(DD)page.dev
	$(SETPDEV) $(DD)mgrgray2 $(MGR)

$(DD)mgrgray4.dev : $(MGR) $(DD)page.dev
	$(SETPDEV) $(DD)mgrgray4 $(MGR)

$(DD)mgrgray8.dev : $(MGR) $(DD)page.dev
	$(SETPDEV) $(DD)mgrgray8 $(MGR)

$(DD)mgr4.dev : $(MGR) $(DD)page.dev
	$(SETPDEV) $(DD)mgr4 $(MGR)

$(DD)mgr8.dev : $(MGR) $(DD)page.dev
	$(SETPDEV) $(DD)mgr8 $(MGR)

### -------------------------- SGI RGB pixmaps -------------------------- ###

sgirgb_=$(GLOBJ)gdevsgi.$(OBJ)
$(DD)sgirgb.dev : $(sgirgb_) $(DD)page.dev
	$(SETPDEV) $(DD)sgirgb $(sgirgb_)

gdevsgi_h=$(GLSRC)gdevsgi.h

$(GLOBJ)gdevsgi.$(OBJ) : $(GLSRC)gdevsgi.c $(PDEVH) $(gdevsgi_h)
	$(GLCC) $(GLO_)gdevsgi.$(OBJ) $(C_) $(GLSRC)gdevsgi.c

### ---------------- Sun raster files ---------------- ###

sunr_=$(GLOBJ)gdevsunr.$(OBJ)

# Harlequin variant, 1-bit
$(DD)sunhmono.dev : $(sunr_) $(DD)page.dev
	$(SETPDEV) $(DD)sunhmono $(sunr_)

$(GLOBJ)gdevsunr.$(OBJ) : $(GLSRC)gdevsunr.c $(PDEVH)
	$(GLCC) $(GLO_)gdevsunr.$(OBJ) $(C_) $(GLSRC)gdevsunr.c

### -------------- chp2200 - HP Business Inkjet 2200 ------------- ###

### NOTE:  Depends on the presence of the cdj850 section in gnudevs.mak.

$(DD)chp2200.dev : $(cdeskjet8_) $(DD)page.dev
	$(SETPDEV2) $(DD)chp2200 $(cdeskjet8_)

### Driver "pcl3" for various PCL-3+ printers #################################
#
# @(#)$Id: contrib.mak,v 1.27 2002/10/12 23:24:34 tillkamppeter Exp $
# Author: Martin Lottermoser, Greifswaldstrasse 28, 38124 Braunschweig,
#         Germany, e-mail: Martin.Lottermoser@t-online.de.
#
# Read the file README in the pcl3 distribution for general installation
# instructions. If you don't have a distribution, visit
# http://home.t-online.de/home/Martin.Lottermoser/pcl3.html.
#
# If you are including both, hpdj and pcl3, in the compilation, you should
# disable the rules for pclcomp.$(OBJ) and pagecount.$(OBJ) in the hpdj
# section. The versions of these files contained in the pcl3 distribution are
# binary compatible with what hpdj 2.6 expects.
#
# You can add compilation options to the variable "pcl3_options" below.
#
#   NDEBUG
#	Define this to remove certain runtime checks from the code which might
#	then become slightly faster. Don't define this for pcl3 beta releases
#	or ghostscript test releases.
#
#   PCL3_MEDIA_FILE
#	Define this to be a C string containing the absolute path name of a
#	media configuration file if you want the "unspec" subdevice to use this
#	file instead of its default HP DeskJet 850C/855C/870C/890C media
#	configuration. An example definition for UNIX systems is:
#
#	    pcl3_options=-DPCL3_MEDIA_FILE='"$(gsdatadir)/pcl3.mcf"'
#
#       A detailed description of the meaning and the syntax of this file can
#       be found in the reference page gs-pcl3(1). Briefly, it tells the
#	driver which media sizes your printer supports and how. You can
#       override this at run time with the option "-sMediaConfigurationFile".
#
# The variable "eprn_fs_options" is intended for optimization options used only
# when compiling eprnfs.c. Choose the combination producing the fastest code.
# You should leave this variable empty unless (a) you definitely know which
# options produce the fastest code from eprnfs.c, and (b) ghostscript does not
# use the same options anyway.
#
# You should also look at the section below containing the rules for the *.dev
# files in order to find out which values you can add to the DEVICE_DEVS*
# variables in the platform-specific make file. You should always add at least
# the "pcl3" device but you may add others; the latter are shortcuts to the
# subdevices of pcl3.
#
#
# Remarks for Microsoft Windows
# =============================
# When compiling on Microsoft Windows and unless you are using Cygwin, you must
# define the preprocessor symbol "EPRN_NO_PAGECOUNTFILE" and either remove the
# dependency of pcl3 on pagecount.obj or replace pagecount.c with an empty
# file.
#
###############################################################################

# Compilation options
pcl3_options=
eprn_fs_options=

# Version of the pcl3 rules: $Revision: 1.27 $.

#==============================================================================

# eprn rules
# This is the part you need if you are developing another eprn-based driver.

# Complete set of compilation options
eprn_opts=-DGS_REVISION=$(GS_REVISION) $(pcl3_options)

# Directory with eprn's source code as seen from the gs directory. The name
# does not include a trailing path separator.
eprn_dir=pcl3$(D)eprn
# Same as above but with a separator
eprn_src=$(eprn_dir)$(D)

# List of all eprn object files
eprn_=$(GLOBJ)gdeveprn.$(OBJ) $(GLOBJ)pagecount.$(OBJ) \
  $(GLOBJ)mediasize.$(OBJ) $(GLOBJ)eprnparm.$(OBJ) $(GLOBJ)eprnrend.$(OBJ) \
  $(GLOBJ)eprnfs.$(OBJ)

# List of eprn headers needed when gdeveprn.h is included:
eprn_headers=$(eprn_src)mediasize.h $(eprn_src)gdeveprn.h

#------------------------------------------------------------------------------

# Rules for individual files

$(GLOBJ)mediasize.$(OBJ): $(eprn_src)mediasize.c $(eprn_src)mediasize.h
	$(GLCC) $(C_) $(O_)$@ $(eprn_opts) $(eprn_src)mediasize.c

$(GLOBJ)gdeveprn.$(OBJ): $(eprn_src)gdeveprn.c $(eprn_headers) \
	  $(eprn_src)pagecount.h
	$(GLCC) $(C_) $(O_)$@ $(eprn_opts) $(eprn_src)gdeveprn.c

$(GLOBJ)eprnparm.$(OBJ): $(eprn_src)eprnparm.c $(eprn_headers)
	$(GLCC) $(C_) $(O_)$@ $(eprn_opts) $(eprn_src)eprnparm.c

$(GLOBJ)eprnrend.$(OBJ): $(eprn_src)eprnrend.c $(eprn_headers)
	$(GLCC) $(C_) $(O_)$@ $(eprn_opts) $(eprn_src)eprnrend.c

$(GLOBJ)eprnfs.$(OBJ): $(eprn_src)eprnfs.c $(eprn_headers)
	$(GLCC) $(C_) $(O_)$@ $(eprn_opts) $(eprn_fs_options) \
	  $(eprn_src)eprnfs.c

# File also used by hpdj:
$(GLOBJ)pagecount.$(OBJ): $(eprn_src)pagecount.c $(eprn_src)pagecount.h
	$(GLCC) $(C_) $(O_)$@ $(eprn_opts) $(eprn_src)pagecount.c

#==============================================================================

# pcl3 rules

# Complete set of compilation options
pcl3_opts=-DGS_REVISION=$(GS_REVISION) -I$(eprn_dir) $(pcl3_options)

# Root directory of pcl3 distribution as seen from the gs directory. The
# variable includes a trailing path separator.
pcl3_root=pcl3$(D)

# Directory with pcl3's source code (name includes a trailing path separator)
pcl3_src=$(pcl3_root)src$(D)

# Headers used by most pcl3 files
pcl3_headers=$(eprn_headers) \
  $(pcl3_src)pclgen.h $(pcl3_src)pclcap.h $(pcl3_src)pclsize.h

# List of all object files needed for pcl3
pcl3_=$(eprn_) $(GLOBJ)gdevpcl3.$(OBJ) $(GLOBJ)pclcap.$(OBJ) \
  $(GLOBJ)pclgen.$(OBJ) $(GLOBJ)pclcomp.$(OBJ) $(GLOBJ)pclsize.$(OBJ)

#------------------------------------------------------------------------------

# Rules for individual files

$(GLOBJ)pclgen.$(OBJ): $(pcl3_src)pclgen.c $(pcl3_src)pclgen.h
	$(GLCC) $(C_) $(O_)$@ $(pcl3_opts) $(pcl3_src)pclgen.c

$(GLOBJ)pclsize.$(OBJ): $(pcl3_src)pclsize.c $(eprn_src)mediasize.h \
	  $(pcl3_src)pclsize.h $(pcl3_src)pclgen.h
	$(GLCC) $(C_) $(O_)$@ $(pcl3_opts) $(pcl3_src)pclsize.c

$(GLOBJ)pclcap.$(OBJ): $(pcl3_src)pclcap.c $(pcl3_headers)
	$(GLCC) $(C_) $(O_)$@ $(pcl3_opts) $(pcl3_src)pclcap.c

$(GLOBJ)gdevpcl3.$(OBJ): $(pcl3_src)gdevpcl3.c $(pcl3_headers)
	$(GLCC) $(C_) $(O_)$@ $(pcl3_opts) $(pcl3_src)gdevpcl3.c

# File also used by hpdj:
$(GLOBJ)pclcomp.$(OBJ): $(pcl3_src)pclcomp.c $(pcl3_src)pclgen.h
	$(GLCC) $(C_) $(O_)$@ $(pcl3_opts) $(pcl3_src)pclcomp.c

#------------------------------------------------------------------------------

# Device rules. The targets here (e.g., "$(DD)pcl3.dev") are the values you
# can add to the DEVICE_DEVS* variables in the platform-specific make file.

# The generic pcl3 device with selectable subdevices
$(DD)pcl3.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)pcl3 $(pcl3_)

# Fixed devices for specific printers
$(DD)hpdjplus.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdjplus $(pcl3_)
$(DD)hpdjportable.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdjportable $(pcl3_)
$(DD)hpdj310.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj310 $(pcl3_)
$(DD)hpdj320.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj320 $(pcl3_)
$(DD)hpdj340.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj340 $(pcl3_)
$(DD)hpdj400.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj400 $(pcl3_)
$(DD)hpdj500.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj500 $(pcl3_)
$(DD)hpdj500c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj500c $(pcl3_)
$(DD)hpdj510.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj510 $(pcl3_)
$(DD)hpdj520.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj520 $(pcl3_)
$(DD)hpdj540.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj540 $(pcl3_)
$(DD)hpdj550c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj550c $(pcl3_)
$(DD)hpdj560c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj560c $(pcl3_)
$(DD)hpdj600.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj600 $(pcl3_)
$(DD)hpdj660c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj660c $(pcl3_)
$(DD)hpdj670c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj670c $(pcl3_)
$(DD)hpdj680c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj680c $(pcl3_)
$(DD)hpdj690c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj690c $(pcl3_)
$(DD)hpdj850c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj850c $(pcl3_)
$(DD)hpdj855c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj855c $(pcl3_)
$(DD)hpdj870c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj870c $(pcl3_)
$(DD)hpdj890c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj890c $(pcl3_)
$(DD)hpdj1120c.dev: $(pcl3_) $(DD)page.dev
	$(SETPDEV) $(DD)hpdj1120c $(pcl3_)

#------------------------------------------------------------------------------

# The pcl3opts command.
# This is deliberately not included in the normal compilation because (a) the
# rule is unlikely to work and (b) the code is unlikely to compile on any but
# UNIX systems.

pcl3opts: $(BINDIR)$(D)pcl3opts$(XE)
pcl3opts_=$(pcl3_src)pcl3opts.c $(pcl3_src)pclscan.c $(eprn_src)mediasize.c \
	$(pcl3_src)pclsize.c

$(BINDIR)$(D)pcl3opts$(XE): $(pcl3opts_)
	$(CC_) -o $@ -I$(eprn_src) $(pcl3opts_)
	gencat $(GLOBJ)pcl3opts-en.cat $(pcl3_src)pcl3opts-en.msg
	gencat $(GLOBJ)pcl3opts-de.cat $(pcl3_src)pcl3opts-de.msg

#------------------------------------------------------------------------------

# Installation rules (work only for UNIX). Note that the PostScript examples
# and the PPD files are not copied.
pcl3-install:
	for f in gs-pcl3 pcl3opts; do	\
	  $(INSTALL_DATA) $(pcl3_root)doc$(D)$$f.1 $(man1dir)/$$f.$(man1ext) \
	    || exit 1;	\
	  $(INSTALL_DATA) $(pcl3_root)doc$(D)$$f.html $(docdir) || exit 1; done
	$(INSTALL_PROGRAM) $(BINDIR)$(D)pcl3opts$(XE) $(bindir)

### ----------------- LexMark 5000 printer ----------------------------- ###
### Note: this driver was contributed by users.  Please contact:         ###
###   Peter B. West <p.west@uq.net.au>                                   ###

lx5000_=$(GLOBJ)gdevlx50.$(OBJ)
$(DD)lx5000.dev:    $(lx5000_)
	$(SETPDEV) $(DD)lx5000 $(lx5000_)

$(GLOBJ)gdevlx50.$(OBJ): $(GLSRC)gdevlx50.c $(PDEVH)
	$(GLCC) $(GLO_)gdevlx50.$(OBJ) $(C_) $(GLSRC)gdevlx50.c

### ----------- Lexmark 3200 device ------------ ###

lxm3200_=$(GLOBJ)gdevlx32.$(OBJ)

$(GLOBJ)gdevlx32.$(OBJ): $(GLSRC)gdevlx32.c $(PDEVH) $(gsparam_h)
	$(GLCC) $(GLO_)gdevlx32.$(OBJ) $(C_) $(GLSRC)gdevlx32.c

$(DD)lxm3200.dev: $(lxm3200_) $(DD)page.dev
	$(SETPDEV) $(DD)lxm3200 $(lxm3200_)


# ------ The Lexmark 5700 and 7000 devices ------ #

lex7000_=$(GLOBJ)gdevlx7.$(OBJ)
$(DD)lex7000.dev: $(lex7000_) $(DD)page.dev
	$(SETPDEV) $(DD)lex7000 $(lex7000_)

lex5700_=$(GLOBJ)gdevlx7.$(OBJ)
$(DD)lex5700.dev: $(lex5700_) $(DD)page.dev
	$(SETPDEV) $(DD)lex5700 $(lex5700_)

lex3200_=$(GLOBJ)gdevlx7.$(OBJ)
$(DD)lex3200.dev: $(lex3200_) $(DD)page.dev
	$(SETPDEV) $(DD)lex3200 $(lex3200_)

lex2050_=$(GLOBJ)gdevlx7.$(OBJ)
$(DD)lex2050.dev: $(lex2050_) $(DD)page.dev
	$(SETPDEV) $(DD)lex2050 $(lex2050_)

$(GLOBJ)gdevlx7.$(OBJ): $(GLSRC)gdevlx7.c $(PDEVH)
	$(GLCC) $(GLO_)gdevlx7.$(OBJ) $(C_) $(GLSRC)gdevlx7.c


### ------------ ALPS MD series printer devices ------------ ###

md2k_=$(GLOBJ)gdevmd2k.$(OBJ)

$(DD)md2k.dev: $(md2k_) $(DD)page.dev
	$(SETPDEV) $(DD)md2k $(md2k_)

$(DD)md5k.dev: $(md2k_) $(DD)page.dev
	$(SETPDEV) $(DD)md5k $(md2k_)

$(GLOBJ)gdevmd2k.$(OBJ): $(GLSRC)gdevmd2k.c $(PDEVH) $(gsparam_h)
	$(GLCC) $(GLO_)gdevmd2k.$(OBJ) $(C_) $(GLSRC)gdevmd2k.c
 
### ---------------- The Samsung SmartGDI laser printer devices --------- ###
### Note : this driver is used by Samsung SmartGDI compatible printers.   ###
###

GDIMONO=$(GLOBJ)gdevgdi.$(OBJ) $(HPPCL)

$(DD)gdi.dev: $(GDIMONO) $(DD)page.dev
	$(SETPDEV) $(DD)gdi $(GDIMONO)

$(DD)samsunggdi.dev: $(GDIMONO) $(DD)page.dev
	$(SETPDEV) $(DD)samsunggdi $(GDIMONO)

$(GLOBJ)gdevgdi.$(OBJ): $(GLSRC)gdevgdi.c $(PDEVH) $(gdevpcl_h)
	$(GLCC) $(GLO_)gdevgdi.$(OBJ) $(C_) $(GLSRC)gdevgdi.c

### -------------------------- EPSON Page/Color -------------------------- ###

eplaser_opts=-DGS_VERSION_MAJOR=$(GS_VERSION_MAJOR)

escv_=$(GLOBJ)gdevescv.$(OBJ)
$(GLOBJ)gdevescv.$(OBJ): $(GLSRC)gdevescv.c $(GLSRC)gdevescv.h $(PDEVH)
	$(GLCC) -DA4 $(GLO_)gdevescv.$(OBJ) $(C_) $(eplaser_opts) $(GLSRC)gdevescv.c

$(DD)lp8800c.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8800c $(escv_)

$(DD)lp8300c.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8300c $(escv_)

$(DD)lp8500c.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8500c $(escv_)

$(DD)lp3000c.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp3000c $(escv_)

$(DD)lp8200c.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8200c $(escv_)

$(DD)lp8000c.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8000c $(escv_)

$(DD)alc8600.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)alc8600 $(escv_)

$(DD)alc8500.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)alc8500 $(escv_)

$(DD)alc2000.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)alc2000 $(escv_)

$(DD)alc4000.dev: $(escv_) $(DD)page.dev
	$(SETPDEV) $(DD)alc4000 $(escv_)

### -------------------------- EPSON ESC/Page ----------------------------- ###

eplaser_opts=-DGS_VERSION_MAJOR=$(GS_VERSION_MAJOR)

esmv_=$(GLOBJ)gdevesmv.$(OBJ)
$(GLOBJ)gdevesmv.$(OBJ): $(GLSRC)gdevesmv.c $(GLSRC)gdevescv.h $(PDEVH)
	$(GLCC) -DA4 $(GLO_)gdevesmv.$(OBJ) $(C_) $(eplaser_opts) $(GLSRC)gdevesmv.c

$(DD)lp2200.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp2200 $(esmv_)

$(DD)lp9400.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp9400 $(esmv_)

$(DD)lp8900.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8900 $(esmv_)

$(DD)lp8700.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8700 $(esmv_)

$(DD)lp8100.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8100 $(esmv_)

$(DD)lp7700.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp7700 $(esmv_)

$(DD)lp8600f.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8600f $(esmv_)

$(DD)lp8400f.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8400f $(esmv_)

$(DD)lp8300f.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8300f $(esmv_)

$(DD)lp1900.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp1900 $(esmv_)

$(DD)lp9600s.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp9600s $(esmv_)

$(DD)lp9300.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp9300 $(esmv_)

$(DD)lp9600.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp9600 $(esmv_)

$(DD)lp8600.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp8600 $(esmv_)

$(DD)lp1800.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)lp1800 $(esmv_)

$(DD)epl6100.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)epl6100 $(esmv_)

$(DD)epl5900.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)epl5900 $(esmv_)

$(DD)epl5800.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)epl5800 $(esmv_)

$(DD)epl2050.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)epl2050 $(esmv_)

$(DD)epl2050p.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)epl2050p $(esmv_)

$(DD)epl2120.dev: $(esmv_) $(DD)page.dev
	$(SETPDEV) $(DD)epl2120 $(esmv_)

### --------------------Japanese printer addons --------------------- ###

$(DD)ljet4pjl.dev: $(HPMONO) $(DD)page.dev
	$(SETPDEV) $(DD)ljet4pjl $(HPMONO)

$(DD)lj4dithp.dev: $(cdeskjet_) $(DD)page.dev
	$(SETPDEV) $(DD)lj4dithp $(cdeskjet_)

$(DD)dj505j.dev: $(cdeskjet_)
	$(SETPDEV) $(DD)dj505j $(cdeskjet_)

$(DD)picty180.dev: $(cdeskjet_)
	$(SETPDEV) $(DD)picty180 $(cdeskjet_)

# handled in gs6 base
#$(DD)cdj880.dev: $(cdeskjet8_) $(DD)page.dev
#	$(SETPDEV) $(DD)cdj880 $(cdeskjet8_)

### ----------------- The NEC PC-PR201 printer device ----------------- ###

pr201_=$(GLOBJ)gdevp201.$(OBJ) $(GLOBJ)gdevprn.$(OBJ)

$(DD)pr201.dev: $(pr201_)
	$(SETPDEV) $(DD)pr201 $(pr201_)

$(DD)pr150.dev: $(pr201_)
	$(SETPDEV) $(DD)pr150 $(pr201_)

$(DD)pr1000.dev: $(pr201_)
	$(SETPDEV) $(DD)pr1000 $(pr201_)

$(DD)pr1000_4.dev: $(pr201_)
	$(SETPDEV) $(DD)pr1000_4 $(pr201_)

$(GLO_)gdevp201.$(OBJ): $(GLSRC)gdevp201.c $(PDEVH)
	$(GLCC) $(GLO_)gdevp201.$(OBJ) $(C_) $(GLSRC)gdevp201.c

### ----------------- The Star JJ-100 printer device ----------------- ###

jj100_=$(GLOBJ)gdevj100.$(OBJ) $(GLOBJ)gdevprn.$(OBJ)

$(DD)jj100.dev: $(jj100_)
	$(SETPDEV) $(DD)jj100 $(jj100_)

$(GLOBJ)gdevj100.$(OBJ): $(GLSRC)gdevj100.c $(PDEVH)
	$(GLCC) $(O_)$@ $(C_) $(GLSRC)gdevj100.c

### ----------------- The Canon BubbleJet BJ10v device ----------------- ###

bj10v_=$(GLOBJ)gdev10v.$(OBJ) $(GLOBJ)gdevprn.$(OBJ)

$(DD)bj10v.dev: $(bj10v_)
	$(SETPDEV) $(DD)bj10v $(bj10v_)

$(DD)bj10vh.dev: $(bj10v_)
	$(SETPDEV) $(DD)bj10vh $(bj10v_)

# Uncomment the following line if you are using MS-DOS on PC9801 series.

$(GLOBJ)gdev10v.$(OBJ): $(GLSRC)gdev10v.c $(PDEVH)
	$(GLCC) $(O_)$@ $(C_) $(GLSRC)gdev10v.c
#	$(GLCC) -DPC9801 $(O_)$@ $(C_) $(GLSRC)gdev10v.c


### ------------------------- MAG file formats ------------------------- ###

maguro_=$(GLOBJ)gdevmag.$(OBJ) $(GLOBJ)gdevpccm.$(OBJ) $(GLOBJ)gdevprn.$(OBJ)
$(GLOBJ)gdevmag.$(OBJ): $(GLSRC)gdevmag.c $(PDEVH)
	$(GLCC) $(O_)$@ $(C_) $(GLSRC)gdevmag.c

$(DD)mag16.dev: $(maguro_)
	$(SETDEV) $(DD)mag16 $(maguro_)

$(DD)mag256.dev: $(maguro_)
	$(SETDEV) $(DD)mag256 $(maguro_)

### ---------------- Dot matrix printer device ---------------- ###
dmprt_=$(GLOBJ)gdevdmpr.$(OBJ) $(GLOBJ)dviprlib.$(OBJ) $(GLOBJ)gdevprn.$(OBJ)

$(DD)dmprt.dev: $(dmprt_) $(DD)page.dev
	$(SETDEV) $(DD)dmprt $(dmprt_)
	$(ADDMOD) $(DD)dmprt -ps dmp_init

$(GLOBJ)gdevdmpr.$(OBJ): $(GLSRC)gdevdmpr.c $(GLSRC)dviprlib.h $(PDEVH)
	$(GLCC) $(O_)$@ $(C_) $(GLSRC)gdevdmpr.c

$(GLOBJ)dviprlib.$(OBJ): $(GLSRC)dviprlib.c $(GLSRC)dviprlib.h
	$(GLCC) $(O_)$@ $(C_) $(GLSRC)dviprlib.c

##
## EPSON MachJet driver 
##

mj700v2c_=$(GLOBJ)gdevmjc.$(OBJ) $(HPPCL)

$(GLOBJ)gdevmjc.$(OBJ): $(GLSRC)gdevmjc.c $(GLSRC)gdevmjc.h $(PDEVH) $(gdevpcl_h)
	$(GLCC) -DA4 $(GLO_)gdevmjc.$(OBJ) $(C_) $(GLSRC)gdevmjc.c

$(DD)mj700v2c.dev: $(mj700v2c_) $(DD)page.dev
	$(SETPDEV) $(DD)mj700v2c $(mj700v2c_)

$(DD)mj500c.dev: $(mj700v2c_) $(DD)page.dev
	$(SETPDEV) $(DD)mj500c $(mj700v2c_)

$(DD)mj6000c.dev: $(mj700v2c_) $(DD)page.dev
	$(SETPDEV) $(DD)mj6000c $(mj700v2c_)

$(DD)mj8000c.dev: $(mj700v2c_) $(DD)page.dev
	$(SETPDEV) $(DD)mj8000c $(mj700v2c_)

### ----------------- The Fujitsu FMPR printer device ----------------- ###

fmpr_=$(GLOBJ)gdevfmpr.$(OBJ) $(GLOBJ)gdevprn.$(OBJ)

$(DD)fmpr.dev: $(fmpr_) $(DD)page.dev
	$(SETPDEV) $(DD)fmpr $(fmpr_)

$(GLOBJ)gdevfmpr.$(OBJ): $(GLSRC)gdevfmpr.c $(PDEVH)
	$(GLCC) $(GLO_)gdevfmpr.$(OBJ) $(C_) $(GLSRC)gdevfmpr.c

### --------------- The Fujitsu FMLBP-2xx printer device --------------- ###

fmlbp_=$(GLOBJ)gdevfmlbp.$(OBJ) $(GLOBJ)gdevprn.$(OBJ)

$(DD)fmlbp.dev: $(fmlbp_) $(DD)page.dev
	$(SETPDEV) $(DD)fmlbp $(fmlbp_)

$(GLOBJ)gdevfmlbp.$(OBJ): $(GLSRC)gdevfmlbp.c $(PDEVH)
	$(GLCC) -DFMLBP_NOADJUST_MARGIN $(O_)$@ $(C_) $(GLSRC)gdevfmlbp.c

### ------ The OKI MICROLINE620CL (IPL) printer device ------- ###
#
#  by N.Tagawa
#
#  $Id: contrib.mak,v 1.27 2002/10/12 23:24:34 tillkamppeter Exp $
#

ml6_=$(GLOBJ)gdevml6.$(OBJ) $(GLOBJ)gdevprn.$(OBJ)

$(DD)ml600.dev: $(ml6_) $(DD)page.dev
	$(SETPDEV) $(DD)ml600 $(ml6_)

$(GLOBJ)gdevml6.$(OBJ): $(GLSRC)gdevml6.c $(PDEVH)
	$(GLCC) $(O_)$@ $(C_) $(GLSRC)gdevml6.c
## 
### ----------------- The Okidata OkiPage 4w+ device ------------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Ivan Schreter (ivan@shadow.sk) if you have questions.          ###

# Provided by gs6
#oki4w_=$(GLOBJ)gdevop4w.$(OBJ)
#
#$(DD)oki4w.dev: $(oki4w_) $(DD)page.dev
#	$(SETPDEV) $(DD)oki4w $(oki4w_)
#
#$(GLOBJ)gdevop4w.$(OBJ): $(GLSRC)gdevop4w.c $(PDEVH)
#	$(GLCC) $(O_)$@ $(C_) $(GLSRC)gdevop4w.c

lbp3x0_=$(GLOBJ)gdevlbp3.$(OBJ)

$(DD)lbp310.dev:$(lbp3x0_) $(DD)page.dev
	$(SETPDEV) $(DD)lbp310 $(lbp3x0_)

$(DD)lbp320.dev:$(lbp3x0_) $(DD)page.dev
	$(SETPDEV) $(DD)lbp320 $(lbp3x0_)

$(GLOBJ)gdevlbp3.$(OBJ): $(GLSRC)gdevlbp3.c $(PDEVH)
	$(GLCC) $(O_)$@ $(C_) $(GLSRC)gdevlbp3.c

# ---------------- Laser Printer devices ---------------- #
# $Id: contrib.mak,v 1.27 2002/10/12 23:24:34 tillkamppeter Exp $

$(GLOBJ)gdevlprn.$(OBJ): $(GLSRC)gdevlprn.c $(GLSRC)gdevlprn.h\
 $(gdevprn_h) $(PDEVH)
	$(GLCC) $(GLO_)gdevlprn.$(OBJ) $(C_) $(GLSRC)gdevlprn.c

### --- The Canon LIPS II+/III/IVc/IV printer device --- ###

lipsr_=$(GLOBJ)gdevl4r.$(OBJ) $(GLOBJ)gdevlips.$(OBJ) $(GLOBJ)gdevlprn.$(OBJ)

$(GLOBJ)gdevl4r.$(OBJ): $(GLSRC)gdevl4r.c $(GLSRC)gdevlips.h $(PDEVH)
	$(GLCC) -DA4 $(GLO_)gdevl4r.$(OBJ) $(C_) $(GLSRC)gdevl4r.c

$(GLOBJ)gdevlips.$(OBJ): $(GLSRC)gdevlips.c
	$(GLCC) $(GLO_)gdevlips.$(OBJ) $(C_) $(GLSRC)gdevlips.c

$(DD)lips2p.dev: $(lipsr_) $(DD)page.dev
	$(SETPDEV) $(DD)lips2p $(lipsr_)

# Superseded in gs 6 by the gdevlbp8 driver
#$(DD)lips3.dev: $(lipsr_) $(DD)page.dev
#	$(SETPDEV) $(DD)lips3 $(lipsr_)

$(DD)bjc880j.dev: $(lipsr_) $(DD)page.dev
	$(SETPDEV) $(DD)bjc880j $(lipsr_)

$(DD)lips4.dev: $(lipsr_) $(DD)page.dev
	$(SETPDEV) $(DD)lips4 $(lipsr_)

lipsv_=$(GLOBJ)gdevl4v.$(OBJ) $(GLOBJ)gdevlips.$(OBJ)

$(DD)lips4v.dev: $(ECHOGS_XE) $(lipsv_) $(DD)vector.dev
	$(SETDEV) $(DD)lips4v $(lipsv_)
	$(ADDMOD) $(DD)lips4v -include $(GLD)vector

$(GLOBJ)gdevl4v.$(OBJ): $(GLSRC)gdevl4v.c $(GLSRC)gdevlips.h $(GDEV) $(math__h)\
 $(gscspace_h) $(gsutil_h) $(gsparam_h) $(gsmatrix_h) $(gdevvec_h)\
 $(ghost_h) $(gzstate_h) $(igstate_h)
	$(GLCC) -DA4 $(GLO_)gdevl4v.$(OBJ) $(C_) $(GLSRC)gdevl4v.c

### --- The NEC NPDL language printer device ------ ###

npdl_=$(GLOBJ)gdevnpdl.$(OBJ) $(GLOBJ)gdevlprn.$(OBJ)

$(GLOBJ)gdevnpdl.$(OBJ): $(GLSRC)gdevnpdl.c $(GLSRC)gdevlprn.h $(PDEVH)
	$(GLCC) -DA4 $(GLO_)gdevnpdl.$(OBJ) $(C_) $(GLSRC)gdevnpdl.c

$(DD)npdl.dev: $(npdl_) $(DD)page.dev
	$(SETPDEV) $(DD)npdl $(npdl_)

### --- The RICOH RPDL language printer device ------ ###

rpdl_=$(GLOBJ)gdevrpdl.$(OBJ) $(GLOBJ)gdevlprn.$(OBJ)
$(GLOBJ)gdevrpdl.$(OBJ): $(GLSRC)gdevrpdl.c $(GLSRC)gdevlprn.h $(PDEVH)
	$(GLCC) -DA4 $(GLO_)gdevrpdl.$(OBJ) $(C_) $(GLSRC)gdevrpdl.c

$(GLOBJ)rpdl.dev: $(rpdl_) $(DD)page.dev
	$(SETPDEV) $(DD)rpdl $(rpdl_)

### ------- EPSON ESC/Page printer device ----------------- ###

escpage_=$(GLOBJ)gdevespg.$(OBJ) $(GLOBJ)gdevlprn.$(OBJ) $(GLOBJ)gdevlips.$(OBJ)

$(GLOBJ)gdevespg.$(OBJ): $(GLSRC)gdevespg.c $(GLSRC)gdevlprn.h $(PDEVH)
	$(GLCC) -DA4 $(GLO_)gdevespg.$(OBJ) $(C_) $(GLSRC)gdevespg.c

$(DD)escpage.dev: $(escpage_) $(DD)page.dev
	$(SETPDEV) $(DD)escpage $(escpage_)

$(DD)lp2000.dev: $(escpage_) $(DD)page.dev
	$(SETPDEV) $(DD)lp2000 $(escpage_)

### ------------ The ALPS Micro Dry printer devices ------------ ###

alps_=$(GLOBJ)gdevalps.$(OBJ)

$(DD)md50Mono.dev: $(alps_) $(DD)page.dev
	$(SETPDEV) $(DD)md50Mono $(alps_)

$(DD)md50Eco.dev: $(alps_) $(DD)page.dev
	$(SETPDEV) $(DD)md50Eco $(alps_)

$(DD)md1xMono.dev: $(alps_) $(DD)page.dev
	$(SETPDEV) $(DD)md1xMono $(alps_)

$(GLOBJ)gdevalps.$(OBJ): $(GLSRC)gdevalps.c $(PDEVH)
	$(GLCC) $(O_)$@ $(C_) $(GLSRC)gdevalps.c

### ----------------------------- bff files ------------------------------ ###

bff_=$(GLOBJ)gdevbff.$(OBJ)

$(DD)bff.dev : $(bff_)
	$(SETPDEV) $(DD)bff $(bff_)

$(GLOBJ)gdevbff.$(OBJ) : $(GLSRC)gdevbff.c $(PDEVH)
	$(GLCC) $(GLO_)gdevbff.$(OBJ) $(C_) $(GLSRC)gdevbff.c

### -------------- djet820c - HP 820c experimental Driver -------------- ###
### EXPERIMENTAL: NO COLOR, HARDCODED PAPER SIZES (A4, letter)           ###
### available via anonymous ftp from:                                    ###
###         ftp://ftp.ig.utexas.edu/outgoing/scottk/820C/                ###

$(GLOBJ)gdev820c.$(OBJ): $(GLSRC)gdev820c.c $(PDEVH)
	$(GLCC) $(GLO_)gdev820c.$(OBJ) $(C_) $(GLSRC)gdev820c.c

djet820c_=$(GLOBJ)gdev820c.$(OBJ) $(GLOBJ)gdevprn.$(OBJ)

$(DD)djet820c.dev: $(djet820c_) $(DD)page.dev
	$(SETDEV) $(DD)djet820c $(djet820c_)

