/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2002 by Andreas Zehender
    email                : zehender@kde.org
    copyright            : (C) 2002 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#include "pmsettingsdialog.h"

#include <qstring.h>
#include <qframe.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

#include <klocale.h>
#include <kcolorbutton.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <kiconloader.h>

#include "pmlineedits.h"

#include "pmrendermanager.h"
#include "pmglview.h"
#include "pmshell.h"
#include "pmpart.h"
#include "pmdialogeditbase.h"
#include "pmpovrayrenderwidget.h"
#include "pmdocumentationmap.h"
#include "pmviewlayoutmanager.h"

#include "pmsphere.h"
#include "pmcone.h"
#include "pmcylinder.h"
#include "pmtorus.h"
#include "pmplane.h"
#include "pmdisc.h"
#include "pmblobsphere.h"
#include "pmblobcylinder.h"
#include "pmlathe.h"
#include "pmsor.h"
#include "pmprism.h"
#include "pmsqe.h"
#include "pmtext.h"
#include "pmresourcelocator.h"

#include "pmcontrolpoint.h"

#include "pmdefaults.h"

QSize PMSettingsDialog::s_size = QSize( 640, 400 );

PMSettingsDialog::PMSettingsDialog( PMPart* part, QWidget* parent, const char* name )
      : KDialogBase( TreeList, i18n( "Settings" ), Ok | Apply | Cancel | Default, Ok,
                     parent, name )
{
   QStringList sl;
   QHBoxLayout* hlayout;
   QVBoxLayout* vlayout;
   QVBoxLayout* gvl;
   QGridLayout* grid;
   QGroupBox* gb;
   QGroupBox* gbe;
   QHBoxLayout* ghe;
   QVBoxLayout* gvle;

   m_pPart = part;

   /************* Povray **********************/

   sl.clear( );
   sl.append( i18n( "Povray" ) );
   m_pPovrayOptions = addPage( sl, i18n( "Povray Options" ) );

   vlayout = new QVBoxLayout( m_pPovrayOptions, 0, spacingHint( ) );

   gb = new QGroupBox( i18n( "Povray Command" ), m_pPovrayOptions );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );
   hlayout = new QHBoxLayout( gvl );
   hlayout->addWidget( new QLabel( i18n( "Command:" ), gb ) );
   m_pPovrayCommand = new QLineEdit( gb );
   hlayout->addWidget( m_pPovrayCommand );
   m_pBrowsePovrayCommand = new QPushButton( gb );
   m_pBrowsePovrayCommand->setPixmap( SmallIcon( "fileopen" ) );
   connect( m_pBrowsePovrayCommand, SIGNAL( clicked( ) ), 
            SLOT( slotBrowsePovrayCommand( ) ) );
   hlayout->addWidget( m_pBrowsePovrayCommand );
   vlayout->addWidget( gb );

   gb = new QGroupBox( i18n( "Povray User Documentation" ), m_pPovrayOptions );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );
   hlayout = new QHBoxLayout( gvl );
   hlayout->addWidget( new QLabel( i18n( "Path:" ), gb ) );
   m_pDocumentationPath = new QLineEdit( gb );
   hlayout->addWidget( m_pDocumentationPath );
   m_pBrowseDocumentationPath = new QPushButton( gb );
   m_pBrowseDocumentationPath->setPixmap( SmallIcon( "fileopen" ) );
   connect( m_pBrowseDocumentationPath, SIGNAL( clicked( ) ), 
            SLOT( slotBrowsePovrayDocumentation( ) ) );
   hlayout->addWidget( m_pBrowseDocumentationPath );
   vlayout->addWidget( gb );
   hlayout = new QHBoxLayout( gvl );
   hlayout->addWidget( new QLabel( i18n( "Version:" ), gb ) );
   m_pDocumentationVersion = new QComboBox( false, gb );
   QValueList<QString> versions = PMDocumentationMap::theMap( )->availableVersions( );
   QValueListIterator<QString> it;
   for( it = versions.begin( ); it != versions.end( ); ++it )
      m_pDocumentationVersion->insertItem( *it );
   hlayout->addWidget( m_pDocumentationVersion );
   hlayout->addStretch( );
   

   m_selectionIndex = 0;
   gb = new QGroupBox( i18n( "Library Paths" ), m_pPovrayOptions );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );
   hlayout = new QHBoxLayout( gvl );
   m_pLibraryPaths = new QListBox( gb );
   connect( m_pLibraryPaths, SIGNAL( highlighted( int ) ),
            SLOT( slotPathSelected( int ) ) );
   hlayout->addWidget( m_pLibraryPaths );

   QVBoxLayout* bl = new QVBoxLayout( hlayout );
   m_pAddLibraryPath = new QPushButton( i18n( "Add..." ), gb );
   connect( m_pAddLibraryPath, SIGNAL( clicked( ) ), SLOT( slotAddPath( ) ) );
   bl->addWidget( m_pAddLibraryPath );
   m_pRemoveLibraryPath = new QPushButton( i18n( "Remove" ), gb );
   connect( m_pRemoveLibraryPath, SIGNAL( clicked( ) ),
            SLOT( slotRemovePath( ) ) );
   bl->addWidget( m_pRemoveLibraryPath );
   m_pChangeLibraryPath = new QPushButton( i18n( "Edit..." ), gb );
   connect( m_pChangeLibraryPath, SIGNAL( clicked( ) ),
            SLOT( slotEditPath( ) ) );
   bl->addWidget( m_pChangeLibraryPath );
   m_pLibraryPathUp = new QPushButton( i18n( "Up" ), gb );
   connect( m_pLibraryPathUp, SIGNAL( clicked( ) ), SLOT( slotPathUp( ) ) );
   bl->addWidget( m_pLibraryPathUp );
   m_pLibraryPathDown = new QPushButton( i18n( "Down" ), gb );
   connect( m_pLibraryPathDown, SIGNAL( clicked( ) ),
            SLOT( slotPathDown( ) ) );
   bl->addWidget( m_pLibraryPathDown );
   bl->addStretch( 1 );
   vlayout->addWidget( gb );

   vlayout->addStretch( 1 );

   /************* Color **********************/
   
   sl.clear( );
   sl.append( i18n( "Graphical view" ) );
   sl.append( i18n( "Colors" ) );
   m_pViewColors = addPage( sl, i18n( "Color Settings" ) );

   vlayout = new QVBoxLayout( m_pViewColors, 0, spacingHint( ) );
   grid = new QGridLayout( vlayout, 6, 3 );
   
   grid->addWidget( new QLabel( i18n( "Background:" ), m_pViewColors ), 0, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 0, 2 );
   m_pBackgroundColor = new KColorButton( m_pViewColors );
   hlayout->addWidget( m_pBackgroundColor );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Wire frame:" ), m_pViewColors ), 1, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 1, 2 );
   m_pGraphicalObjectsColor[0] = new KColorButton( m_pViewColors );
   hlayout->addWidget( m_pGraphicalObjectsColor[0] );
   hlayout->addWidget( new QLabel( i18n( "Selected:" ), m_pViewColors ) );
   m_pGraphicalObjectsColor[1] = new KColorButton( m_pViewColors );
   hlayout->addWidget( m_pGraphicalObjectsColor[1] );
   hlayout->addStretch( 1 );
   
   grid->addWidget( new QLabel( i18n( "Control points:" ), m_pViewColors ), 2, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 2, 2 );
   m_pControlPointsColor[0] = new KColorButton( m_pViewColors );
   hlayout->addWidget( m_pControlPointsColor[0] );
   hlayout->addWidget( new QLabel( i18n( "Selected:" ), m_pViewColors ) );
   m_pControlPointsColor[1] = new KColorButton( m_pViewColors );
   hlayout->addWidget( m_pControlPointsColor[1] );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Axes:" ), m_pViewColors ), 3, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 3, 2 );
   grid->addWidget( new QLabel( "x", m_pViewColors ), 3, 1 );
   m_pAxesColor[0] = new KColorButton( m_pViewColors );
   hlayout->addWidget( m_pAxesColor[0] );
   hlayout->addWidget( new QLabel( "y", m_pViewColors ) );
   m_pAxesColor[1] = new KColorButton( m_pViewColors );
   hlayout->addWidget( m_pAxesColor[1] );
   hlayout->addWidget( new QLabel( "z", m_pViewColors ) );
   m_pAxesColor[2] = new KColorButton( m_pViewColors );
   hlayout->addWidget( m_pAxesColor[2] );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Field of view:" ), m_pViewColors ), 4, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 4, 2 );
   m_pFieldOfViewColor = new KColorButton( m_pViewColors );
   hlayout->addWidget( m_pFieldOfViewColor );
   hlayout->addStretch( 1 );
   

   /************* Grid **********************/

   sl.clear( );
   sl.append( i18n( "Graphical view" ) );
   sl.append( i18n( "Grid" ) );
   m_pViewGrid = addPage( sl, i18n( "Grid Settings" ) );

   vlayout = new QVBoxLayout( m_pViewGrid, 0, spacingHint( ) );
   gb = new QGroupBox( i18n( "Displayed Grid" ), m_pViewGrid );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );

   hlayout = new QHBoxLayout( gvl );
   hlayout->addWidget( new QLabel( i18n( "Color:" ), gb ) );
   m_pGridColor = new KColorButton( gb );
   hlayout->addWidget( m_pGridColor );
   hlayout->addStretch( 1 );

   hlayout = new QHBoxLayout( gvl );
   hlayout->addWidget( new QLabel( i18n( "Distance:" ), gb ) );
   m_pGridDistance = new PMIntEdit( gb );
   m_pGridDistance->setValidation( true, 20, false, 0 );
   hlayout->addWidget( m_pGridDistance );
   hlayout->addStretch( 1 );

//   vlayout->addSpacing( 15 );
   gb = new QGroupBox( i18n( "Control Point Grid" ), m_pViewGrid );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );

   hlayout = new QHBoxLayout( gvl );
   grid = new QGridLayout( hlayout, 3, 2 );
   grid->addWidget( new QLabel( i18n( "2D/3D movement:" ), gb ), 0, 0 );
   m_pMoveGrid = new PMFloatEdit( gb );
   m_pMoveGrid->setValidation( true, 0.001, true, 100 );
   grid->addWidget( m_pMoveGrid, 0, 1 );
   
   grid->addWidget( new QLabel( i18n( "Scale:" ), gb ), 1, 0 );
   m_pScaleGrid = new PMFloatEdit( gb );
   m_pScaleGrid->setValidation( true, 0.001, true, 100 );
   grid->addWidget( m_pScaleGrid, 1, 1 );
   
   grid->addWidget( new QLabel( i18n( "Rotation:" ), gb ), 2, 0 );
   m_pRotateGrid = new PMFloatEdit( gb );
   m_pRotateGrid->setValidation( true, 0.001, true, 180 );
   grid->addWidget( m_pRotateGrid, 2, 1 );

   hlayout->addStretch( 1 );

   vlayout->addStretch( 1 );
   
   /************* Object details **********************/

   sl.clear( );
   sl.append( i18n( "Graphical view" ) );
   sl.append( i18n( "Objects" ) );
   m_pViewDetails = addPage( sl, i18n( "Display Settings for Objects" ) );

   vlayout = new QVBoxLayout( m_pViewDetails, 0, spacingHint( ) );

   gb = new QGroupBox( i18n( "Subdivisions" ), m_pViewDetails );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );
   grid = new QGridLayout( gvl, 11, 3 );
   
   grid->addWidget( new QLabel( i18n( "Sphere:" ), gb ), 0, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 0, 2 );
   grid->addWidget( new QLabel( "u", gb ), 0, 1 );
   m_pSphereUSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pSphereUSteps );
   m_pSphereUSteps->setValidation( true, 2, true, 32 );
   hlayout->addWidget( new QLabel( "v", gb ) );
   m_pSphereVSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pSphereVSteps );
   m_pSphereVSteps->setValidation( true, 4, true, 64 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Cylinder:" ), gb ), 1, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 1, 2 );
   m_pCylinderSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pCylinderSteps );
   m_pCylinderSteps->setValidation( true, 4, true, 64 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Cone:" ), gb ), 2, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 2, 2 );
   m_pConeSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pConeSteps );
   m_pConeSteps->setValidation( true, 4, true, 64 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Torus:" ), gb ), 3, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 3, 2 );
   grid->addWidget( new QLabel( "u", gb ), 3, 1 );
   m_pTorusUSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pTorusUSteps );
   m_pTorusUSteps->setValidation( true, 2, true, 16 );
   hlayout->addWidget( new QLabel( "v", gb ) );
   m_pTorusVSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pTorusVSteps );
   m_pTorusVSteps->setValidation( true, 4, true, 64 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Disc:" ), gb ), 4, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 4, 2 );
   m_pDiscSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pDiscSteps );
   m_pDiscSteps->setValidation( true, 4, true, 64 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Blob sphere:" ), gb ), 5, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 5, 2 );
   grid->addWidget( new QLabel( "u", gb ), 5, 1 );
   m_pBlobSphereUSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pBlobSphereUSteps );
   m_pBlobSphereUSteps->setValidation( true, 2, true, 32 );
   hlayout->addWidget( new QLabel( "v", gb ) );
   m_pBlobSphereVSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pBlobSphereVSteps );
   m_pBlobSphereVSteps->setValidation( true, 4, true, 64 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Blob cylinder:" ), gb ), 6, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 6, 2 );
   grid->addWidget( new QLabel( "u", gb ), 6, 1 );
   m_pBlobCylinderUSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pBlobCylinderUSteps );
   m_pBlobCylinderUSteps->setValidation( true, 2, true, 32 );
   hlayout->addWidget( new QLabel( "v", gb ) );
   m_pBlobCylinderVSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pBlobCylinderVSteps );
   m_pBlobCylinderVSteps->setValidation( true, 4, true, 64 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Lathe:" ), gb ), 7, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 7, 2 );
   grid->addWidget( new QLabel( "u", gb ), 7, 1 );
   m_pLatheUSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pLatheUSteps );
   m_pLatheUSteps->setValidation( true, 1, true, 16 );
   hlayout->addWidget( new QLabel( "v", gb ) );
   m_pLatheRSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pLatheRSteps );
   m_pLatheRSteps->setValidation( true, 4, true, 64 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Surface of revolution:" ), gb ), 8, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 8, 2 );
   grid->addWidget( new QLabel( "u", gb ), 8, 1 );
   m_pSorUSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pSorUSteps );
   m_pSorUSteps->setValidation( true, 1, true, 16 );
   hlayout->addWidget( new QLabel( "v", gb ) );
   m_pSorRSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pSorRSteps );
   m_pSorRSteps->setValidation( true, 4, true, 64 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Prism:" ), gb ), 9, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 9, 2 );
   m_pPrismSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pPrismSteps );
   m_pPrismSteps->setValidation( true, 1, true, 16 );
   hlayout->addStretch( 1 );

   grid->addWidget( new QLabel( i18n( "Superquadric ellipsoid:" ), gb ), 10, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 10, 2 );
   grid->addWidget( new QLabel( "u", gb ), 10, 1 );
   m_pSqeUSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pSqeUSteps );
   m_pSqeUSteps->setValidation( true, 2, true, 8 );
   hlayout->addWidget( new QLabel( "v", gb ) );
   m_pSqeVSteps = new PMIntEdit( gb );
   hlayout->addWidget( m_pSqeVSteps );
   m_pSqeVSteps->setValidation( true, 2, true, 8 );
   hlayout->addStretch( 1 );

   gb = new QGroupBox( i18n( "Sizes" ), m_pViewDetails );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );

   grid = new QGridLayout( gvl, 1, 2 );
   
   grid->addWidget( new QLabel( i18n( "Plane:" ), gb ), 0, 0 );
   hlayout = new QHBoxLayout( );
   grid->addLayout( hlayout, 0, 1 );
   m_pPlaneSize = new PMFloatEdit( gb );
   hlayout->addWidget( m_pPlaneSize );
   m_pPlaneSize->setValidation( true, 0.1, false, 0.0 );
   hlayout->addStretch( 1 );

   gb = new QGroupBox( i18n( "Camera Views" ), m_pViewDetails );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );

   m_pHighDetailCameraViews = new QCheckBox( i18n( "High detail for enhanced projections" ), gb );
   gvl->addWidget( m_pHighDetailCameraViews );
   
   vlayout->addStretch( 1 );

   /************* Texture preview **********************/

   sl.clear( );
   sl.append( i18n( "Properties view" ) );
   sl.append( i18n( "Texture preview" ) );
   m_pTexturePreview = addPage( sl, i18n( "Display Settings for Texture Previews" ) );

   vlayout = new QVBoxLayout( m_pTexturePreview, 0, spacingHint( ) );
   
   hlayout = new QHBoxLayout( vlayout );
   grid = new QGridLayout( hlayout, 2, 2 );
   grid->addWidget( new QLabel( i18n( "Size:" ), m_pTexturePreview ), 0, 0 );
   m_pPreviewSize = new PMIntEdit( m_pTexturePreview );
   m_pPreviewSize->setValidation( true, 10, true, 400 );
   grid->addWidget( m_pPreviewSize, 0, 1 );

   grid->addWidget( new QLabel( i18n( "Gamma:" ), m_pTexturePreview ), 1, 0 );
   m_pPreviewGamma = new PMFloatEdit( m_pTexturePreview );
   grid->addWidget( m_pPreviewGamma, 1, 1 );
   hlayout->addStretch( 1 );

   gb = new QGroupBox( i18n( "Rendered Objects" ), m_pTexturePreview );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );
   m_pPreviewSphere = new QCheckBox( i18n( "Sphere" ), gb );
   gvl->addWidget( m_pPreviewSphere );
   m_pPreviewCylinder = new QCheckBox( i18n( "Cylinder" ), gb );
   gvl->addWidget( m_pPreviewCylinder );
   m_pPreviewBox = new QCheckBox( i18n( "Box" ), gb );
   gvl->addWidget( m_pPreviewBox );

   gb = new QGroupBox( i18n( "Wall" ), m_pTexturePreview );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );
   m_pPreviewWall = new QCheckBox( i18n( "Enable wall" ), gb );
   gvl->addWidget( m_pPreviewWall );
   hlayout = new QHBoxLayout( gvl );
   hlayout->addWidget( new QLabel( i18n( "Color 1:" ), gb ) );
   m_pWallColor1 = new KColorButton( gb );
   hlayout->addWidget( m_pWallColor1 );
   hlayout->addWidget( new QLabel( i18n( "Color 2:" ), gb ) );
   m_pWallColor2 = new KColorButton( gb );
   hlayout->addWidget( m_pWallColor2 );
   hlayout->addStretch( 1 );

   gb = new QGroupBox( i18n( "Floor" ), m_pTexturePreview );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );
   m_pPreviewFloor = new QCheckBox( i18n( "Enable floor" ), gb );
   gvl->addWidget( m_pPreviewFloor );
   hlayout = new QHBoxLayout( gvl );
   hlayout->addWidget( new QLabel( i18n( "Color 1:" ), gb ) );
   m_pFloorColor1 = new KColorButton( gb );
   hlayout->addWidget( m_pFloorColor1 );
   hlayout->addWidget( new QLabel( i18n( "Color 2:" ), gb ) );
   m_pFloorColor2 = new KColorButton( gb );
   hlayout->addWidget( m_pFloorColor2 );
   hlayout->addStretch( 1 );

   gb = new QGroupBox( i18n( "Antialiasing" ), m_pTexturePreview );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );
   m_pPreviewAA = new QCheckBox( i18n( "Enable antialiasing" ), gb );
   gvl->addWidget( m_pPreviewAA );
   hlayout = new QHBoxLayout( gvl );
   hlayout->addWidget( new QLabel( i18n( "Depth:" ), gb ) );
   m_pPreviewAALevel = new PMIntEdit( gb );
   m_pPreviewAALevel->setValidation( true, 1, true, 9 );
   hlayout->addWidget( m_pPreviewAALevel );
   hlayout->addWidget( new QLabel( i18n( "Threshold:" ), gb ) );
   m_pPreviewAAThreshold = new PMFloatEdit( gb );
   hlayout->addWidget( m_pPreviewAAThreshold );
   hlayout->addStretch( 1 );
   
   vlayout->addStretch( 1 );

   /************* View Layout Options **********************/

   sl.clear( );
   sl.append( i18n( "View Layout" ) );
   m_pLayoutOptions = addPage( sl, i18n( "Display Settings for View Layouts" ) );

   vlayout = new QVBoxLayout( m_pLayoutOptions, 0, spacingHint( ) );

   hlayout = new QHBoxLayout( vlayout );
   hlayout->addWidget( new QLabel( i18n( "Default view layout:" ), m_pLayoutOptions ) );
   m_pDefaultLayout = new QComboBox( m_pLayoutOptions );
   hlayout->addWidget( m_pDefaultLayout, 1 );
   hlayout->addStretch( 1 );

   gb = new QGroupBox( i18n( "Available View Layouts" ), m_pLayoutOptions );
   vlayout->addWidget( gb );
   gvl = new QVBoxLayout( gb, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvl->addSpacing( 10 );
   
   grid = new QGridLayout( gvl, 3, 2 );
   m_pViewLayouts = new QListBox( gb );
   connect( m_pViewLayouts, SIGNAL( highlighted( int ) ), 
                            SLOT( slotLayoutSelected( int ) ) );
   grid->addMultiCellWidget( m_pViewLayouts, 0, 2, 0, 0 );
   m_pAddLayout = new QPushButton( i18n( "Add" ), gb );
   connect( m_pAddLayout, SIGNAL( clicked( ) ), SLOT( slotAddLayout( ) ) );
   grid->addWidget( m_pAddLayout, 0, 1 );
   m_pRemoveLayout = new QPushButton( i18n( "Remove" ), gb );
   connect( m_pRemoveLayout, SIGNAL( clicked( ) ), SLOT( slotRemoveLayout( ) ) );
   grid->addWidget( m_pRemoveLayout, 1, 1 );
   grid->setRowStretch( 2, 1 );

   gbe = new QGroupBox( i18n( "View Layout" ), gb );
   gvl->addWidget( gbe );
   gvle = new QVBoxLayout( gbe, KDialog::marginHint( ), KDialog::spacingHint( ) );
   gvle->addSpacing( 10 );
   ghe = new QHBoxLayout( gvle );
   ghe->addWidget( new QLabel( i18n( "Name:" ), gbe ) );
   m_pViewLayoutName = new QLineEdit( gbe );
   connect( m_pViewLayoutName, SIGNAL( textChanged( const QString& ) ), 
                               SLOT( slotLayoutNameChanged( const QString& ) ) );
   ghe->addWidget( m_pViewLayoutName );
   grid = new QGridLayout( gvle, 4, 2 );
   m_pViewEntries = new QListView( gbe );
   m_pViewEntries->setAllColumnsShowFocus( true );
   m_pViewEntries->addColumn( " " );  // This column is for the view entry number 
   m_pViewEntries->addColumn( i18n( "Type" ) );
   m_pViewEntries->addColumn( i18n( "Position" ) );
   m_pViewEntries->setSorting( -1 );
   m_pViewEntries->setMaximumHeight( 150 );
   connect( m_pViewEntries, SIGNAL( selectionChanged( QListViewItem* ) ),
                            SLOT( slotViewEntrySelected( QListViewItem* ) ) );
   grid->addMultiCellWidget( m_pViewEntries, 0, 3, 0, 0 );
   m_pAddEntry = new QPushButton( i18n( "Add" ), gbe );
   connect( m_pAddEntry, SIGNAL( clicked( ) ), SLOT( slotAddViewEntryClicked( ) ) );
   grid->addWidget( m_pAddEntry, 0, 1 );
   m_pRemoveEntry = new QPushButton( i18n( "Remove" ), gbe );
   connect( m_pRemoveEntry, SIGNAL( clicked( ) ), SLOT( slotRemoveViewEntryClicked( ) ) );
   grid->addWidget( m_pRemoveEntry, 1, 1 );
   /*
   m_pMoveUpEntry = new QPushButton( i18n( "Move Up" ), gbe );
   connect( m_pMoveUpEntry, SIGNAL( clicked( ) ), SLOT( slotMoveUpViewEntryClicked( ) ) );
   grid->addWidget( m_pMoveUpEntry, 2, 1 );
   m_pMoveDownEntry = new QPushButton( i18n( "Move Down" ), gbe );
   connect( m_pMoveDownEntry, SIGNAL( clicked( ) ), SLOT( slotMoveDownViewEntryClicked( ) ) );
   grid->addWidget( m_pMoveDownEntry, 3, 1 );
   */

   QHBoxLayout* ghl = new QHBoxLayout( gvle );
   grid = new QGridLayout( ghl, 7, 4 );
   grid->addWidget( new QLabel( i18n( "Type:" ), gbe ), 0, 0 );
   m_pGLViewTypeLabel = new QLabel( i18n( "3D view type:" ), gbe );
   grid->addWidget( m_pGLViewTypeLabel, 1, 0 );
   grid->addWidget( new QLabel( i18n( "Dock position:" ), gbe ), 2, 0 );
   m_pColumnWidthLabel = new QLabel( i18n( "Column width:" ), gbe );
   grid->addWidget( m_pColumnWidthLabel, 3, 0 );
   m_pViewHeightLabel = new QLabel( i18n( "View height:" ), gbe );
   grid->addWidget( m_pViewHeightLabel, 4, 0 );
   m_pViewTypeEdit = new QComboBox( gbe );
   m_pViewTypeEdit->insertItem( i18n( "Object Tree" ) );
   m_pViewTypeEdit->insertItem( i18n( "Properties View" ) );
   m_pViewTypeEdit->insertItem( i18n( "3D View" ) );
   connect( m_pViewTypeEdit, SIGNAL( activated( int ) ),
                             SLOT( slotViewTypeChanged( int ) ) );
   grid->addWidget( m_pViewTypeEdit, 0, 1 );
   m_pGLViewTypeEdit = new QComboBox( gbe );
   m_pGLViewTypeEdit->insertItem( i18n( "Top" ) );
   m_pGLViewTypeEdit->insertItem( i18n( "Bottom" ) );
   m_pGLViewTypeEdit->insertItem( i18n( "Left" ) );
   m_pGLViewTypeEdit->insertItem( i18n( "Right" ) );
   m_pGLViewTypeEdit->insertItem( i18n( "Front" ) );
   m_pGLViewTypeEdit->insertItem( i18n( "Back" ) );
   m_pGLViewTypeEdit->insertItem( i18n( "Camera" ) );
   connect( m_pGLViewTypeEdit, SIGNAL( activated( int ) ),
                               SLOT( slotGLViewTypeChanged( int ) ) );
   grid->addWidget( m_pGLViewTypeEdit, 1, 1 );
   m_pDockPositionEdit = new QComboBox( gbe );
   m_pDockPositionEdit->insertItem( i18n( "New Column" ) );
   m_pDockPositionEdit->insertItem( i18n( "Below" ) );
   m_pDockPositionEdit->insertItem( i18n( "Tabbed" ) );
   m_pDockPositionEdit->insertItem( i18n( "Floating" ) );
   connect( m_pDockPositionEdit, SIGNAL( activated( int ) ),
            SLOT( slotDockPositionChanged( int ) ) );
   grid->addWidget( m_pDockPositionEdit, 2, 1 );
   
   m_pColumnWidthEdit = new PMIntEdit( gbe );
   connect( m_pColumnWidthEdit, SIGNAL( textChanged( const QString& ) ),
            SLOT( slotColumnWidthChanged( const QString& ) ) );
   grid->addWidget( m_pColumnWidthEdit, 3, 1 );
   
   m_pViewHeightEdit = new PMIntEdit( gbe );
   connect( m_pViewHeightEdit, SIGNAL( textChanged( const QString& ) ),
            SLOT( slotViewHeightChanged( const QString& ) ) );
   grid->addWidget( m_pViewHeightEdit, 4, 1 );

   m_pFloatingWidthLabel = new QLabel( i18n( "Width:" ), gbe );
   m_pFloatingHeightLabel = new QLabel( i18n( "Height:" ), gbe );
   m_pFloatingPosXLabel = new QLabel( i18n( "Position x:" ), gbe );
   m_pFloatingPosYLabel = new QLabel( QString( "y:" ), gbe );
   grid->addWidget( m_pFloatingWidthLabel, 5, 0 );
   grid->addWidget( m_pFloatingHeightLabel, 5, 2 );
   grid->addWidget( m_pFloatingPosXLabel, 6, 0 );
   grid->addWidget( m_pFloatingPosYLabel, 6, 2 );

   m_pFloatingWidth = new PMIntEdit( gbe );
   connect( m_pFloatingWidth, SIGNAL( textChanged( const QString& ) ),
            SLOT( slotFloatingWidthChanged( const QString& ) ) );
   m_pFloatingHeight = new PMIntEdit( gbe );
   connect( m_pFloatingHeight, SIGNAL( textChanged( const QString& ) ),
            SLOT( slotFloatingHeightChanged( const QString& ) ) );
   m_pFloatingPosX = new PMIntEdit( gbe );
   connect( m_pFloatingPosX, SIGNAL( textChanged( const QString& ) ),
            SLOT( slotFloatingPosXChanged( const QString& ) ) );
   m_pFloatingPosY = new PMIntEdit( gbe );
   connect( m_pFloatingPosY, SIGNAL( textChanged( const QString& ) ),
            SLOT( slotFloatingPosYChanged( const QString& ) ) );
   grid->addWidget( m_pFloatingWidth, 5, 1 );
   grid->addWidget( m_pFloatingHeight, 5, 3 );
   grid->addWidget( m_pFloatingPosX, 6, 1 );
   grid->addWidget( m_pFloatingPosY, 6, 3 );
   
   ghl->addStretch( 1 );

   vlayout->addStretch( 1 );

   m_viewColorsIndex = pageIndex( m_pViewColors );
   m_viewGridIndex = pageIndex( m_pViewGrid );
   m_viewDetailsIndex = pageIndex( m_pViewDetails );
   m_texturePreviewIndex = pageIndex( m_pTexturePreview );
   m_povrayIndex = pageIndex( m_pPovrayOptions );
   m_layoutIndex = pageIndex( m_pLayoutOptions );

   displaySettings( );

   resize( s_size );
}

void PMSettingsDialog::displaySettings( )
{
   m_pPovrayCommand->setText( PMPovrayRenderWidget::povrayCommand( ) );
   m_pDocumentationPath->setText( PMDocumentationMap::theMap( )->povrayDocumentationPath( ) );
   int c = m_pDocumentationVersion->count( );
   QString s = PMDocumentationMap::theMap( )->documentationVersion( );
   int i;
   for( i = 0; i < c; i++ )
      if( m_pDocumentationVersion->text( i ) == s )
         m_pDocumentationVersion->setCurrentItem( i );
   
   bool sb = m_pLibraryPaths->signalsBlocked( );
   m_pLibraryPaths->blockSignals( true );
   m_pLibraryPaths->clear( );
   QStringList plist = PMPovrayRenderWidget::povrayLibraryPaths( );
   QStringList::ConstIterator it = plist.begin( );
   m_selectionIndex = -1;
   for( ; it != plist.end( ); ++it )
   {
      m_pLibraryPaths->insertItem( *it );
      m_selectionIndex++;
   }
   
   m_pRemoveLibraryPath->setEnabled( false );
   m_pChangeLibraryPath->setEnabled( false );
   m_pLibraryPathUp->setEnabled( false );
   m_pLibraryPathDown->setEnabled( false );   
   m_pLibraryPaths->blockSignals( sb );
   
   PMRenderManager* rm = PMRenderManager::theManager( );
   m_pBackgroundColor->setColor( rm->backgroundColor( ) );
   m_pGraphicalObjectsColor[0]->setColor( rm->graphicalObjectColor( 0 ) );
   m_pGraphicalObjectsColor[1]->setColor( rm->graphicalObjectColor( 1 ) );
   m_pControlPointsColor[0]->setColor( rm->controlPointColor( 0 ) );
   m_pControlPointsColor[1]->setColor( rm->controlPointColor( 1 ) );
   m_pAxesColor[0]->setColor( rm->axesColor( 0 ) );
   m_pAxesColor[1]->setColor( rm->axesColor( 1 ) );
   m_pAxesColor[2]->setColor( rm->axesColor( 2 ) );
   m_pFieldOfViewColor->setColor( rm->fieldOfViewColor( ) );
   m_pHighDetailCameraViews->setChecked( rm->highDetailCameraViews( ) );
   
   m_pGridColor->setColor( rm->gridColor( ) );
   m_pGridDistance->setValue( rm->gridDistance( ) );
   m_pMoveGrid->setValue( PMControlPoint::moveGrid( ) );
   m_pScaleGrid->setValue( PMControlPoint::scaleGrid( ) );
   m_pRotateGrid->setValue( PMControlPoint::rotateGrid( ) );

   m_pSphereUSteps->setValue( PMSphere::uSteps( ) );
   m_pSphereVSteps->setValue( PMSphere::vSteps( ) );
   m_pCylinderSteps->setValue( PMCylinder::steps( ) );
   m_pConeSteps->setValue( PMCone::steps( ) );
   m_pTorusUSteps->setValue( PMTorus::uSteps( ) );
   m_pTorusVSteps->setValue( PMTorus::vSteps( ) );
   m_pDiscSteps->setValue( PMDisc::steps( ) );
   m_pBlobSphereUSteps->setValue( PMBlobSphere::uSteps( ) );
   m_pBlobSphereVSteps->setValue( PMBlobSphere::vSteps( ) );
   m_pBlobCylinderUSteps->setValue( PMBlobCylinder::uSteps( ) );
   m_pBlobCylinderVSteps->setValue( PMBlobCylinder::vSteps( ) );
   m_pPlaneSize->setValue( PMPlane::planeSize( ) );
   m_pLatheUSteps->setValue( PMLathe::sSteps( ) );
   m_pLatheRSteps->setValue( PMLathe::rSteps( ) );
   m_pSorUSteps->setValue( PMSurfaceOfRevolution::sSteps( ) );
   m_pSorRSteps->setValue( PMSurfaceOfRevolution::rSteps( ) );
   m_pPrismSteps->setValue( PMPrism::sSteps( ) );
   m_pSqeUSteps->setValue( PMSuperquadricEllipsoid::uSteps( ) );
   m_pSqeVSteps->setValue( PMSuperquadricEllipsoid::vSteps( ) );

   m_pPreviewSize->setValue( PMDialogEditBase::previewSize( ) );
   m_pPreviewGamma->setValue( PMDialogEditBase::previewGamma( ) );
   m_pPreviewSphere->setChecked( PMDialogEditBase::previewShowSphere( ) );
   m_pPreviewCylinder->setChecked( PMDialogEditBase::previewShowCylinder( ) );
   m_pPreviewBox->setChecked( PMDialogEditBase::previewShowBox( ) );
   m_pPreviewAA->setChecked( PMDialogEditBase::isPreviewAAEnabled( ) );
   m_pPreviewAALevel->setValue( PMDialogEditBase::previewAADepth( ) );
   m_pPreviewAAThreshold->setValue( PMDialogEditBase::previewAAThreshold( ) );
   m_pPreviewWall->setChecked( PMDialogEditBase::previewShowWall( ) );
   m_pPreviewFloor->setChecked( PMDialogEditBase::previewShowFloor( ) );
   m_pFloorColor1->setColor( PMDialogEditBase::previewFloorColor1( ) );
   m_pFloorColor2->setColor( PMDialogEditBase::previewFloorColor2( ) );
   m_pWallColor1->setColor( PMDialogEditBase::previewWallColor1( ) );
   m_pWallColor2->setColor( PMDialogEditBase::previewWallColor2( ) );

   PMViewLayoutManager* m = PMViewLayoutManager::theManager( );
   m_viewLayouts = m->layouts( );
   m_currentViewLayout = m_viewLayouts.begin( );
   m_defaultViewLayout = m_viewLayouts.begin( );
   for( ; ( m_defaultViewLayout != m_viewLayouts.end( ) ) &&
          ( *m_defaultViewLayout ).name( ) != m->defaultLayout( );
        ++m_defaultViewLayout );
   displayLayoutList( );
   m_pViewLayouts->setCurrentItem( 0 );
   if( m_pViewLayouts->numRows( ) == 1 )
      m_pRemoveLayout->setEnabled( false );
}

void PMSettingsDialog::slotCancel( )
{
   QDialog::reject( );
}

void PMSettingsDialog::slotApply( )
{
   if( validateData( ) )
      saveSettings( );
}

void PMSettingsDialog::slotOk( )
{
   if( validateData( ) )
   {
      saveSettings( );
      QDialog::accept( );
   }
}

void PMSettingsDialog::slotDefault( )
{
   int api = activePageIndex( );
   
   if( api == m_povrayIndex )
   {
      m_pPovrayCommand->setText( c_defaultPovrayCommand );
      m_pDocumentationVersion->setCurrentItem( 0 );
   }
   else if( api == m_viewColorsIndex )
   {
      m_pBackgroundColor->setColor( c_defaultBackgroundColor );
      m_pGraphicalObjectsColor[0]->setColor( c_defaultGraphicalObjectColor0 );
      m_pGraphicalObjectsColor[1]->setColor( c_defaultGraphicalObjectColor1 );
      m_pControlPointsColor[0]->setColor( c_defaultControlPointColor0 );
      m_pControlPointsColor[1]->setColor( c_defaultControlPointColor1 );
      m_pAxesColor[0]->setColor( c_defaultAxesColorX );
      m_pAxesColor[1]->setColor( c_defaultAxesColorY );
      m_pAxesColor[2]->setColor( c_defaultAxesColorZ );
      m_pFieldOfViewColor->setColor( c_defaultFieldOfViewColor );
      m_pHighDetailCameraViews->setChecked( c_defaultHighDetailCameraView );
   }
   else if( api == m_viewGridIndex )
   {
      m_pGridColor->setColor( c_defaultGridColor );
      m_pGridDistance->setValue( c_defaultGridDistance );
      m_pMoveGrid->setValue( c_defaultMoveGrid );
      m_pScaleGrid->setValue( c_defaultScaleGrid );
      m_pRotateGrid->setValue( c_defaultRotateGrid );      
   }
   else if( api == m_viewDetailsIndex )
   {
      m_pSphereUSteps->setValue( c_defaultSphereUSteps );
      m_pSphereVSteps->setValue( c_defaultSphereVSteps );
      m_pCylinderSteps->setValue( c_defaultCylinderSteps );
      m_pConeSteps->setValue( c_defaultConeSteps );
      m_pTorusUSteps->setValue( c_defaultTorusUSteps );
      m_pTorusVSteps->setValue( c_defaultTorusVSteps );
      m_pDiscSteps->setValue( c_defaultDiscSteps );
      m_pBlobSphereUSteps->setValue( c_defaultBlobSphereUSteps );
      m_pBlobSphereVSteps->setValue( c_defaultBlobSphereVSteps );
      m_pBlobCylinderUSteps->setValue( c_defaultBlobCylinderUSteps );
      m_pBlobCylinderVSteps->setValue( c_defaultBlobCylinderVSteps );
      m_pLatheUSteps->setValue( c_defaultLatheSSteps );
      m_pLatheRSteps->setValue( c_defaultLatheRSteps );
      m_pSorUSteps->setValue( c_defaultSurfaceOfRevolutionSSteps );
      m_pSorRSteps->setValue( c_defaultSurfaceOfRevolutionRSteps );
      m_pPrismSteps->setValue( c_defaultPrismSSteps );
      m_pSqeUSteps->setValue( c_defaultSuperquadricEllipsoidUSteps );
      m_pSqeVSteps->setValue( c_defaultSuperquadricEllipsoidVSteps );
      m_pPlaneSize->setValue( c_defaultPlaneSize );
   }
   else if( api == m_texturePreviewIndex )
   {
      m_pPreviewSize->setValue( c_defaultTPSize );
      m_pPreviewGamma->setValue( c_defaultTPGamma );
      m_pPreviewSphere->setChecked( c_defaultTPShowSphere );
      m_pPreviewCylinder->setChecked( c_defaultTPShowCylinder );
      m_pPreviewBox->setChecked( c_defaultTPShowBox );
      m_pPreviewAA->setChecked( c_defaultTPAA );
      m_pPreviewAALevel->setValue( c_defaultTPAADepth );
      m_pPreviewAAThreshold->setValue( c_defaultTPAAThreshold );
      m_pPreviewWall->setChecked( c_defaultTPShowWall );
      m_pPreviewFloor->setChecked( c_defaultTPShowFloor );
      m_pFloorColor1->setColor( c_defaultTPFloorColor1 );
      m_pFloorColor2->setColor( c_defaultTPFloorColor2 );
      m_pWallColor1->setColor( c_defaultTPWallColor1 );
      m_pWallColor2->setColor( c_defaultTPWallColor2 );
   }
   else if( api == m_layoutIndex )
   {
   }
}

bool PMSettingsDialog::validateData( )
{
   if( !m_pGridDistance->isDataValid( ) )
   {
      showPage( m_viewGridIndex );
      m_pGridDistance->setFocus( );
      return false;
   }
   if( !m_pMoveGrid->isDataValid( ) )
   {
      showPage( m_viewGridIndex );
      m_pMoveGrid->setFocus( );
      return false;
   }
   if( !m_pScaleGrid->isDataValid( ) )
   {
      showPage( m_viewGridIndex );
      m_pScaleGrid->setFocus( );
      return false;
   }
   if( !m_pRotateGrid->isDataValid( ) )
   {
      showPage( m_viewGridIndex );
      m_pRotateGrid->setFocus( );
      return false;
   }
   if( !m_pSphereUSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pSphereUSteps->setFocus( );
      return false;
   }
   if( !m_pSphereVSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pSphereVSteps->setFocus( );
      return false;
   }
   if( !m_pCylinderSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pCylinderSteps->setFocus( );
      return false;
   }
   if( !m_pConeSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pConeSteps->setFocus( );
      return false;
   }
   if( !m_pTorusUSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pTorusUSteps->setFocus( );
      return false;
   }
   if( !m_pTorusVSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pTorusVSteps->setFocus( );
      return false;
   }
   if( !m_pDiscSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pDiscSteps->setFocus( );
      return false;
   }
   if( !m_pBlobSphereUSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pBlobSphereUSteps->setFocus( );
      return false;
   }
   if( !m_pBlobSphereVSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pBlobSphereVSteps->setFocus( );
      return false;      
   }
   if( !m_pBlobCylinderUSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pBlobCylinderUSteps->setFocus( );
      return false;      
   }
   if( !m_pBlobCylinderVSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pBlobCylinderVSteps->setFocus( );
      return false;      
   }
   if( !m_pLatheUSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pLatheUSteps->setFocus( );
      return false;
   }
   if( !m_pLatheRSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pLatheRSteps->setFocus( );
      return false;
   }
   if( !m_pSorUSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pSorUSteps->setFocus( );
      return false;
   }
   if( !m_pSorRSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pSorRSteps->setFocus( );
      return false;
   }
   if( !m_pPrismSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pPrismSteps->setFocus( );
      return false;
   }
   if( !m_pSqeUSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pSqeUSteps->setFocus( );
      return false;
   }
   if( !m_pSqeVSteps->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pSqeVSteps->setFocus( );
      return false;
   }
   if( !m_pPlaneSize->isDataValid( ) )
   {
      showPage( m_viewDetailsIndex );
      m_pPlaneSize->setFocus( );
      return false;
   }
   if( !m_pPreviewSize->isDataValid( ) )
   {
      showPage( m_texturePreviewIndex );
      m_pPreviewSize->setFocus( );
      return false;
   }
   if( !m_pPreviewGamma->isDataValid( ) )
   {
      showPage( m_texturePreviewIndex );
      m_pPreviewGamma->setFocus( );
      return false;
   }
   if( !m_pPreviewAALevel->isDataValid( ) )
   {
      showPage( m_texturePreviewIndex );
      m_pPreviewAALevel->setFocus( );
      return false;
   }
   if( !m_pPreviewAAThreshold->isDataValid( ) )
   {
      showPage( m_texturePreviewIndex );
      m_pPreviewAAThreshold->setFocus( );
      return false;
   }
   if( !( m_pPreviewSphere->isChecked( ) || m_pPreviewCylinder->isChecked( )
          || m_pPreviewBox->isChecked( ) ) )
   {
      showPage( m_texturePreviewIndex );
      KMessageBox::error( this, i18n( "At least one object has to be selected." ),
                          i18n( "Error" ) );
  
      return false;
   }

   QValueListIterator<PMViewLayout> lit;
   for( lit = m_viewLayouts.begin( ); lit != m_viewLayouts.end( ); ++lit )
   {
      if( ( *lit ).name( ).isEmpty( ) )
      {
         showPage( m_layoutIndex );
         KMessageBox::error( this, i18n( "View layouts may not have empty names." ),
                             i18n( "Error" ) );
         return false;
      }
      QValueListIterator<PMViewLayoutEntry> eit = ( *lit ).begin( );
      if( eit != ( *lit ).end( ) )
      {
         if( ( *eit ).dockPosition( ) != PMDockWidget::DockRight )
         {
            showPage( m_layoutIndex );
            KMessageBox::error( this, i18n( "The docking position of the first view layout entry has to be 'New Column'" ),
                                i18n( "Error" ) );
            return false;
         }
      }
   }
   
   return true;
}

void PMSettingsDialog::saveSettings( )
{
   bool repaint = false;
   int i;

   PMPovrayRenderWidget::setPovrayCommand( m_pPovrayCommand->text( ) );
   PMDocumentationMap::theMap( )->setPovrayDocumentationPath(
      m_pDocumentationPath->text( ) );
   PMDocumentationMap::theMap( )->setDocumentationVersion(
      m_pDocumentationVersion->currentText( ) );
   QStringList plist;
   int num = ( signed ) m_pLibraryPaths->count( );
   for( i = 0; i < num; i++ )
      plist.append( m_pLibraryPaths->text( i ) );

   if( PMPovrayRenderWidget::povrayLibraryPaths( ) != plist )
   {
      PMPovrayRenderWidget::setPovrayLibraryPaths( plist );
      PMResourceLocator::clearCache( );
      PMText::povrayLibraryPathsChanged( );
      repaint = true;
   }
   
   PMRenderManager* rm = PMRenderManager::theManager( );
   if( rm->backgroundColor( ) != m_pBackgroundColor->color( ) )
   {
      rm->setBackgroundColor( m_pBackgroundColor->color( ) );
      repaint = true;
   }
   for( i = 0; i < 2; i++ )
   {
      if( rm->graphicalObjectColor( i ) != m_pGraphicalObjectsColor[i]->color( ) )
      {
         rm->setGraphicalObjectColor( i, m_pGraphicalObjectsColor[i]->color( ) );
         repaint = true;
      }
   }
   for( i = 0; i < 2; i++ )
   {
      if( rm->controlPointColor( i ) != m_pControlPointsColor[i]->color( ) )
      {
         rm->setControlPointColor( i, m_pControlPointsColor[i]->color( ) );
         repaint = true;
      }
   }
   for( i = 0; i < 3; i++ )
   {
      if( rm->axesColor( i ) != m_pAxesColor[i]->color( ) )
      {
         rm->setAxesColor( i, m_pAxesColor[i]->color( ) );
         repaint = true;
      }
   }
   
   if( rm->gridColor( ) != m_pGridColor->color( ) )
   {
      rm->setGridColor( m_pGridColor->color( ) );
      repaint = true;
   }
   if( rm->gridDistance( ) != m_pGridDistance->value( ) )
   {
      rm->setGridDistance( m_pGridDistance->value( ) );
      repaint = true;
   }
   if( rm->fieldOfViewColor( ) != m_pFieldOfViewColor->color( ) )
   {
      rm->setFieldOfViewColor( m_pFieldOfViewColor->color( ) );
      repaint = true;
   }
   if( rm->highDetailCameraViews( ) != m_pHighDetailCameraViews->isChecked( ) )
   {
      rm->setHighDetailCameraViews( m_pHighDetailCameraViews->isChecked( ) );
      repaint = true;
   }

   PMControlPoint::setMoveGrid( m_pMoveGrid->value( ) );
   PMControlPoint::setScaleGrid( m_pScaleGrid->value( ) );
   PMControlPoint::setRotateGrid( m_pRotateGrid->value( ) );

   if( PMSphere::uSteps( ) != m_pSphereUSteps->value( ) )
   {
      PMSphere::setUSteps( m_pSphereUSteps->value( ) );
      repaint = true;
   }
   if( PMSphere::vSteps( ) != m_pSphereVSteps->value( ) )
   {
      PMSphere::setVSteps( m_pSphereVSteps->value( ) );
      repaint = true;
   }
   if( PMCylinder::steps( ) != m_pCylinderSteps->value( ) )
   {
      PMCylinder::setSteps( m_pCylinderSteps->value( ) );
      repaint = true;
   }
   if( PMCone::steps( ) != m_pConeSteps->value( ) )
   {
      PMCone::setSteps( m_pConeSteps->value( ) );
      repaint = true;
   }
   if( PMTorus::uSteps( ) != m_pTorusUSteps->value( ) )
   {
      PMTorus::setUSteps( m_pTorusUSteps->value( ) );
      repaint = true;
   }
   if( PMTorus::vSteps( ) != m_pTorusVSteps->value( ) )
   {
      PMTorus::setVSteps( m_pTorusVSteps->value( ) );
      repaint = true;
   }
   if( PMDisc::steps( ) != m_pDiscSteps->value( ) )
   {
      PMDisc::setSteps( m_pDiscSteps->value( ) );
      repaint = true;
   }
   if( PMBlobSphere::uSteps( ) != m_pBlobSphereUSteps->value( ) )
   {
      PMBlobSphere::setUSteps( m_pBlobSphereUSteps->value( ) );
      repaint = true;
   }
   if( PMBlobSphere::vSteps( ) != m_pBlobSphereVSteps->value( ) )
   {
      PMBlobSphere::setVSteps( m_pBlobSphereVSteps->value( ) );
      repaint = true;
   }
   if( PMBlobCylinder::uSteps( ) != m_pBlobCylinderUSteps->value( ) )
   {
      PMBlobCylinder::setUSteps( m_pBlobCylinderUSteps->value( ) );
      repaint = true;
   }
   if( PMBlobCylinder::vSteps( ) != m_pBlobCylinderVSteps->value( ) )
   {
      PMBlobCylinder::setVSteps( m_pBlobCylinderVSteps->value( ) );
      repaint = true;
   }
   if( PMPlane::planeSize( ) != m_pPlaneSize->value( ) )
   {
      PMPlane::setPlaneSize( m_pPlaneSize->value( ) );
      repaint = true;
   }
   if( PMLathe::sSteps( ) != m_pLatheUSteps->value( ) )
   {
      PMLathe::setSSteps( m_pLatheUSteps->value( ) );
      repaint = true;
   }
   if( PMLathe::rSteps( ) != m_pLatheRSteps->value( ) )
   {
      PMLathe::setRSteps( m_pLatheRSteps->value( ) );
      repaint = true;
   }
   if( PMSurfaceOfRevolution::sSteps( ) != m_pSorUSteps->value( ) )
   {
      PMSurfaceOfRevolution::setSSteps( m_pSorUSteps->value( ) );
      repaint = true;
   }
   if( PMSurfaceOfRevolution::rSteps( ) != m_pSorRSteps->value( ) )
   {
      PMSurfaceOfRevolution::setRSteps( m_pSorRSteps->value( ) );
      repaint = true;
   }
   if( PMPrism::sSteps( ) != m_pPrismSteps->value( ) )
   {
      PMPrism::setSSteps( m_pPrismSteps->value( ) );
      repaint = true;
   }
   if( PMSuperquadricEllipsoid::uSteps( ) != m_pSqeUSteps->value( ) )
   {
      PMSuperquadricEllipsoid::setUSteps( m_pSqeUSteps->value( ) );
      repaint = true;
   }
   if( PMSuperquadricEllipsoid::vSteps( ) != m_pSqeVSteps->value( ) )
   {
      PMSuperquadricEllipsoid::setVSteps( m_pSqeVSteps->value( ) );
      repaint = true;
   }
   
   PMDialogEditBase::setPreviewSize( m_pPreviewSize->value( ) );
   PMDialogEditBase::setPreviewGamma( m_pPreviewGamma->value( ) );
   PMDialogEditBase::previewShowSphere( m_pPreviewSphere->isChecked( ) );
   PMDialogEditBase::previewShowCylinder( m_pPreviewCylinder->isChecked( ) );
   PMDialogEditBase::previewShowBox( m_pPreviewBox->isChecked( ) );
   PMDialogEditBase::setPreviewAAEnabled( m_pPreviewAA->isChecked( ) );
   PMDialogEditBase::setPreviewAADepth( m_pPreviewAALevel->value( ) );
   PMDialogEditBase::setPreviewAAThreshold( m_pPreviewAAThreshold->value( ) );
   PMDialogEditBase::previewShowFloor( m_pPreviewFloor->isChecked( ) );
   PMDialogEditBase::previewShowWall( m_pPreviewWall->isChecked( ) );
   PMDialogEditBase::setPreviewWallColor1( m_pWallColor1->color( ) );
   PMDialogEditBase::setPreviewWallColor2( m_pWallColor2->color( ) );
   PMDialogEditBase::setPreviewFloorColor1( m_pFloorColor1->color( ) );
   PMDialogEditBase::setPreviewFloorColor2( m_pFloorColor2->color( ) );

   QValueListIterator<PMViewLayout> lit;
   for( lit = m_viewLayouts.begin( ); lit != m_viewLayouts.end( ); ++lit )
      ( *lit ).normalize( );
   PMViewLayoutManager::theManager( )->setDefaultLayout( m_pDefaultLayout->currentText( ) );
   PMViewLayoutManager::theManager( )->setLayouts( m_viewLayouts );
   PMViewLayoutManager::theManager( )->saveData( );

   if( repaint )
      rm->slotRenderingSettingsChanged( );
}

void PMSettingsDialog::saveConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );
   cfg->writeEntry( "SettingsDialogSize", s_size );
}

void PMSettingsDialog::restoreConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );

   QSize defaultSize( 640, 400 );
   s_size = cfg->readSizeEntry( "SettingsDialogSize", &defaultSize );
}

void PMSettingsDialog::resizeEvent( QResizeEvent* ev )
{
   s_size = ev->size( );
}

void PMSettingsDialog::slotAddPath( )
{
   if( m_pLibraryPaths->count( ) >= 20 )
      KMessageBox::error( this, i18n( "Povray only supports up to 20 library paths." ) );
   else
   {
      QString path = KFileDialog::getExistingDirectory( QString::null, this );
      if( !path.isEmpty( ) )
      {
#if ( QT_VERSION >= 300 )
         QListBoxItem* item = m_pLibraryPaths->findItem( path, ExactMatch );
#else
         QListBoxItem* item = 0;
#endif
         if( !item )
         {
            m_pLibraryPaths->insertItem( path, m_selectionIndex + 1 );
            m_pLibraryPaths->setCurrentItem( m_selectionIndex + 1 );
         }
         else
            KMessageBox::error( this, i18n( "The list of library paths already contains this path." ) );
      }
   }
}

void PMSettingsDialog::slotRemovePath( )
{
   m_pLibraryPaths->removeItem( m_selectionIndex );
   if( ( unsigned ) m_selectionIndex >= m_pLibraryPaths->count( ) )
      m_selectionIndex--;
   m_pLibraryPaths->setCurrentItem( m_selectionIndex );
}

void PMSettingsDialog::slotPathUp( )
{
   QListBoxItem* lbi = m_pLibraryPaths->item( m_selectionIndex );
   if( lbi )
   {
      QString text = lbi->text( );
      m_pLibraryPaths->removeItem( m_selectionIndex );
      if( m_selectionIndex > 0 )
         m_selectionIndex--;
      m_pLibraryPaths->insertItem( text, m_selectionIndex );
      m_pLibraryPaths->setCurrentItem( m_selectionIndex );
   }
}

void PMSettingsDialog::slotPathDown( )
{
   QListBoxItem* lbi = m_pLibraryPaths->item( m_selectionIndex );
   if( lbi )
   {
      QString text = lbi->text( );
      m_pLibraryPaths->removeItem( m_selectionIndex );
      if( ( unsigned ) m_selectionIndex < m_pLibraryPaths->count( ) )
         m_selectionIndex++;
      m_pLibraryPaths->insertItem( text, m_selectionIndex );
      m_pLibraryPaths->setCurrentItem( m_selectionIndex );
   }
}

void PMSettingsDialog::slotEditPath( )
{
   QListBoxItem* lbi = m_pLibraryPaths->item( m_selectionIndex );
   if( lbi )
   {
      QString text = lbi->text( );
      QString path = KFileDialog::getExistingDirectory( text, this );
      if( !path.isEmpty( ) )
      {
#if ( QT_VERSION >= 300 )
         QListBoxItem* item = m_pLibraryPaths->findItem( path, ExactMatch );
#else
         QListBoxItem* item = 0;
#endif
         if( !item )
            m_pLibraryPaths->changeItem( path, m_selectionIndex );
         else if( item != lbi )
            KMessageBox::error( this, i18n( "The list of library paths already contains this path." ) );
      }
   }
}

void PMSettingsDialog::slotPathSelected( int index )
{
   m_selectionIndex = index;
   QListBoxItem* lbi = m_pLibraryPaths->item( m_selectionIndex );
   if( lbi )
   {
      m_pRemoveLibraryPath->setEnabled( true );
      m_pChangeLibraryPath->setEnabled( true );
      m_pLibraryPathUp->setEnabled( index > 0 );
      m_pLibraryPathDown->setEnabled( index < ( ( signed ) m_pLibraryPaths->count( ) - 1 ) );
   }
   else
   {
      m_pRemoveLibraryPath->setEnabled( false );
      m_pChangeLibraryPath->setEnabled( false );
      m_pLibraryPathUp->setEnabled( false );
      m_pLibraryPathDown->setEnabled( false );
   }
}

void PMSettingsDialog::slotBrowsePovrayCommand( )
{
   QString str = KFileDialog::getOpenFileName( QString::null, QString::null );

   if( str != "" && str != QString::null )
   {
      m_pPovrayCommand->setText( str );
   }
}

void PMSettingsDialog::slotBrowsePovrayDocumentation( )
{
   QString str = KFileDialog::getExistingDirectory( );

   if( !str.isEmpty( ) )
      m_pDocumentationPath->setText( str );
}

// ********************** view layout methods **************************

void PMSettingsDialog::displayLayoutList( )
{
   QValueListIterator<PMViewLayout> it;
   
   m_pViewLayouts->clear( );
   m_pDefaultLayout->clear( );
   for( it = m_viewLayouts.begin( ); it != m_viewLayouts.end( ); ++it )
   {
      m_pViewLayouts->insertItem( ( *it ).name( ) );
      m_pDefaultLayout->insertItem( ( *it ).name( ) );
      if( it == m_defaultViewLayout )
         m_pDefaultLayout->setCurrentText( ( *it ).name( ) );
   }
}

void PMSettingsDialog::slotAddLayout( )
{
   QString new_name;
   int i = 1;
   QString str;

   new_name = i18n( "Unnamed" );
   str.setNum( i );
   while( m_pViewLayouts->findItem( new_name, Qt::ExactMatch ) )
   {
      new_name = i18n( "Unnamed" ) + str;
      i++;
      str.setNum( i );
   }

   PMViewLayout l;
   l.setName( new_name );

   m_currentViewLayout++;
   m_viewLayouts.insert( m_currentViewLayout, l );
   displayLayoutList( );
   m_pViewLayouts->setCurrentItem( m_pViewLayouts->findItem( new_name, Qt::ExactMatch ) );
   m_pRemoveLayout->setEnabled( true );
}

void PMSettingsDialog::slotRemoveLayout( )
{
   if( m_currentViewLayout == m_defaultViewLayout )
   {
      m_defaultViewLayout--;
      if( m_defaultViewLayout == m_viewLayouts.end( ) )
      {
         m_defaultViewLayout++;
         m_defaultViewLayout++;
      }
   }
   m_viewLayouts.remove( m_currentViewLayout );
   displayLayoutList( );
   m_pViewLayouts->setCurrentItem( m_pViewLayouts->firstItem( ) );

   if( m_pViewLayouts->numRows( ) == 1 )
      m_pRemoveLayout->setEnabled( false );
}

void PMSettingsDialog::slotLayoutSelected( int index )
{
  int i;
  QString str;
  bool sb;

  m_currentViewLayout = m_viewLayouts.at( index );
  m_currentViewEntry = ( *m_currentViewLayout ).begin( );

  sb = m_pViewLayoutName->signalsBlocked( );
  m_pViewLayoutName->blockSignals( true );
  m_pViewLayoutName->setText( ( *m_currentViewLayout ).name( ) );
  m_pViewLayoutName->blockSignals( sb );
  
  PMViewLayout::iterator it;
  QListViewItem* previous = NULL;
  m_pViewEntries->clear( );
  i = 0;
  for( it = ( *m_currentViewLayout ).begin( );
       it != ( *m_currentViewLayout ).end( ); ++it )
  {
     i++; str.setNum( i );
     previous = new QListViewItem( m_pViewEntries, previous, str,
                                   ( *it ).extendedViewTypeAsString( ),
                                   ( *it ).dockPositionAsString( ) );
     if( i == 1 )
        m_pViewEntries->setSelected( previous, true );
  }
  if( i == 0 )
     slotViewEntrySelected( 0 );
}

void PMSettingsDialog::slotLayoutNameChanged( const QString& text )
{
   int n_item = m_pViewLayouts->currentItem( );
   bool sb = m_pViewLayouts->signalsBlocked( );
   m_pViewLayouts->blockSignals( true );
   m_pViewLayouts->removeItem( n_item );
   m_pViewLayouts->insertItem( text, n_item );
   m_pViewLayouts->setCurrentItem( n_item );
   m_pViewLayouts->blockSignals( sb );

   ( *m_currentViewLayout ).setName( text );
   
   QValueListIterator<PMViewLayout> it;   
   m_pDefaultLayout->clear( );
   for( it = m_viewLayouts.begin( ); it != m_viewLayouts.end( ); ++it )
   {
      m_pDefaultLayout->insertItem( ( *it ).name( ) );
      if( it == m_defaultViewLayout )
         m_pDefaultLayout->setCurrentText( ( *it ).name( ) );
   }
}

void PMSettingsDialog::slotViewEntrySelected( QListViewItem *item )
{
   if( item )
   {
      m_pViewTypeEdit->setEnabled( true );
      m_pDockPositionEdit->setEnabled( true );
      
      int n_item = item->text( 0 ).toInt( ) - 1;

      m_currentViewEntry = ( *m_currentViewLayout ).at( n_item );
      switch( ( *m_currentViewEntry ).viewType( ) )
      {
         case PMViewLayoutEntry::PMTreeView:
            m_pViewTypeEdit->setCurrentItem( 0 );
            m_pGLViewTypeLabel->hide( );
            m_pGLViewTypeEdit->hide( );
            break;
         case PMViewLayoutEntry::PMDialogView:
            m_pViewTypeEdit->setCurrentItem( 1 );
            m_pGLViewTypeLabel->hide( );
            m_pGLViewTypeEdit->hide( );
            break;
         case PMViewLayoutEntry::PMGLView:
            m_pViewTypeEdit->setCurrentItem( 2 );
            m_pGLViewTypeLabel->show( );
            m_pGLViewTypeEdit->show( );
            break;
      }
      switch( ( *m_currentViewEntry ).glViewType( ) )
      {
         case PMGLView::PMViewNegY:
            m_pGLViewTypeEdit->setCurrentItem( 0 );
            break;
         case PMGLView::PMViewPosY:
            m_pGLViewTypeEdit->setCurrentItem( 1 );
            break;
         case PMGLView::PMViewPosX:
            m_pGLViewTypeEdit->setCurrentItem( 2 );
            break;
         case PMGLView::PMViewNegX:
            m_pGLViewTypeEdit->setCurrentItem( 3 );
            break;
         case PMGLView::PMViewPosZ:
            m_pGLViewTypeEdit->setCurrentItem( 4 );
            break;
         case PMGLView::PMViewNegZ:
            m_pGLViewTypeEdit->setCurrentItem( 5 );
            break;
         case PMGLView::PMViewCamera:
            m_pGLViewTypeEdit->setCurrentItem( 6 );
            break;
      }
      switch( ( *m_currentViewEntry ).dockPosition( ) )
      {
         case PMDockWidget::DockRight:
            m_pDockPositionEdit->setCurrentItem( 0 );
            m_pColumnWidthLabel->show( );
            m_pColumnWidthEdit->show( );
            m_pViewHeightEdit->show( );
            m_pViewHeightLabel->show( );
            m_pFloatingWidth->hide( );
            m_pFloatingHeight->hide( );
            m_pFloatingPosX->hide( );
            m_pFloatingPosY->hide( );
            m_pFloatingWidthLabel->hide( );
            m_pFloatingHeightLabel->hide( );
            m_pFloatingPosXLabel->hide( );
            m_pFloatingPosYLabel->hide( );
            break;
         case PMDockWidget::DockBottom:
            m_pDockPositionEdit->setCurrentItem( 1 );
            m_pColumnWidthLabel->hide( );
            m_pColumnWidthEdit->hide( );
            m_pViewHeightEdit->show( );
            m_pViewHeightLabel->show( );
            m_pFloatingWidth->hide( );
            m_pFloatingHeight->hide( );
            m_pFloatingPosX->hide( );
            m_pFloatingPosY->hide( );
            m_pFloatingWidthLabel->hide( );
            m_pFloatingHeightLabel->hide( );
            m_pFloatingPosXLabel->hide( );
            m_pFloatingPosYLabel->hide( );
            break;
         case PMDockWidget::DockCenter:
            m_pDockPositionEdit->setCurrentItem( 2 );
            m_pColumnWidthLabel->hide( );
            m_pColumnWidthEdit->hide( );
            m_pViewHeightEdit->hide( );
            m_pViewHeightLabel->hide( );
            m_pFloatingWidth->hide( );
            m_pFloatingHeight->hide( );
            m_pFloatingPosX->hide( );
            m_pFloatingPosY->hide( );
            m_pFloatingWidthLabel->hide( );
            m_pFloatingHeightLabel->hide( );
            m_pFloatingPosXLabel->hide( );
            m_pFloatingPosYLabel->hide( );
            break;
         default:
            m_pDockPositionEdit->setCurrentItem( 3 );
            m_pColumnWidthLabel->hide( );
            m_pColumnWidthEdit->hide( );
            m_pViewHeightEdit->hide( );
            m_pViewHeightLabel->hide( );
            m_pFloatingWidth->show( );
            m_pFloatingHeight->show( );
            m_pFloatingPosX->show( );
            m_pFloatingPosY->show( );
            m_pFloatingWidthLabel->show( );
            m_pFloatingHeightLabel->show( );
            m_pFloatingPosXLabel->show( );
            m_pFloatingPosYLabel->show( );
            break;
      }
      m_pColumnWidthEdit->setValue( ( *m_currentViewEntry ).columnWidth( ) );
      m_pViewHeightEdit->setValue( ( *m_currentViewEntry ).height( ) );
      m_pFloatingWidth->setValue( ( *m_currentViewEntry ).floatingWidth( ) );
      m_pFloatingHeight->setValue( ( *m_currentViewEntry ).floatingHeight( ) );
      m_pFloatingPosX->setValue( ( *m_currentViewEntry ).floatingPositionX( ) );
      m_pFloatingPosY->setValue( ( *m_currentViewEntry ).floatingPositionY( ) );
      m_pViewEntries->triggerUpdate( );
   }
   else
   {
      m_pViewTypeEdit->setEnabled( false );
      m_pDockPositionEdit->setEnabled( false );
      m_pGLViewTypeLabel->hide( );
      m_pGLViewTypeEdit->hide( );
      m_pColumnWidthLabel->hide( );
      m_pColumnWidthEdit->hide( );
      m_pViewHeightEdit->hide( );
      m_pViewHeightLabel->hide( );
      m_pFloatingWidth->hide( );
      m_pFloatingHeight->hide( );
      m_pFloatingPosX->hide( );
      m_pFloatingPosY->hide( );
      m_pFloatingWidthLabel->hide( );
      m_pFloatingHeightLabel->hide( );
      m_pFloatingPosXLabel->hide( );
      m_pFloatingPosYLabel->hide( );
   }
}

void PMSettingsDialog::slotViewTypeChanged( int index )
{
   switch( index )
   {
      case 0:
         ( *m_currentViewEntry ).setViewType( PMViewLayoutEntry::PMTreeView );
         m_pGLViewTypeLabel->hide( );
         m_pGLViewTypeEdit->hide( );
         break;
      case 1:
         ( *m_currentViewEntry ).setViewType( PMViewLayoutEntry::PMDialogView );
         m_pGLViewTypeLabel->hide( );
         m_pGLViewTypeEdit->hide( );
         break;
      case 2:
         ( *m_currentViewEntry ).setViewType( PMViewLayoutEntry::PMGLView );
         m_pGLViewTypeLabel->show( );
         m_pGLViewTypeEdit->show( );
         break;
   }
   QListViewItem* item = m_pViewEntries->currentItem( );
   if( item )
      item->setText( 1, ( *m_currentViewEntry ).extendedViewTypeAsString( ) );
}

void PMSettingsDialog::slotGLViewTypeChanged( int index )
{
   switch( index )
   {
      case 0:
         ( *m_currentViewEntry ).setGLViewType( PMGLView::PMViewNegY );
         break;
      case 1:
         ( *m_currentViewEntry ).setGLViewType( PMGLView::PMViewPosY );
         break;
      case 2:
         ( *m_currentViewEntry ).setGLViewType( PMGLView::PMViewPosX );
         break;
      case 3:
         ( *m_currentViewEntry ).setGLViewType( PMGLView::PMViewNegX );
         break;
      case 4:
         ( *m_currentViewEntry ).setGLViewType( PMGLView::PMViewPosZ );
         break;
      case 5:
         ( *m_currentViewEntry ).setGLViewType( PMGLView::PMViewNegZ );
         break;
      case 6:
         ( *m_currentViewEntry ).setGLViewType( PMGLView::PMViewCamera );
         break;
   }
   QListViewItem* item = m_pViewEntries->currentItem( );
   if( item )
      item->setText( 1, ( *m_currentViewEntry ).extendedViewTypeAsString( ) );
}

void PMSettingsDialog::slotDockPositionChanged( int index )
{
   switch( index )
   {
      case 0:
         ( *m_currentViewEntry ).setDockPosition( PMDockWidget::DockRight );
         m_pColumnWidthLabel->show( );
         m_pColumnWidthEdit->show( );
         m_pViewHeightEdit->show( );
         m_pViewHeightLabel->show( );
         m_pFloatingWidth->hide( );
         m_pFloatingHeight->hide( );
         m_pFloatingPosX->hide( );
         m_pFloatingPosY->hide( );
         m_pFloatingWidthLabel->hide( );
         m_pFloatingHeightLabel->hide( );
         m_pFloatingPosXLabel->hide( );
         m_pFloatingPosYLabel->hide( );
         break;
      case 1:
         ( *m_currentViewEntry ).setDockPosition( PMDockWidget::DockBottom );
         m_pColumnWidthLabel->hide( );
         m_pColumnWidthEdit->hide( );
         m_pViewHeightEdit->show( );
         m_pViewHeightLabel->show( );
         m_pFloatingWidth->hide( );
         m_pFloatingHeight->hide( );
         m_pFloatingPosX->hide( );
         m_pFloatingPosY->hide( );
         m_pFloatingWidthLabel->hide( );
         m_pFloatingHeightLabel->hide( );
         m_pFloatingPosXLabel->hide( );
         m_pFloatingPosYLabel->hide( );
         break;
      case 2:
         ( *m_currentViewEntry ).setDockPosition( PMDockWidget::DockCenter );
         m_pColumnWidthLabel->hide( );
         m_pColumnWidthEdit->hide( );
         m_pViewHeightEdit->hide( );
         m_pViewHeightLabel->hide( );
         m_pFloatingWidth->hide( );
         m_pFloatingHeight->hide( );
         m_pFloatingPosX->hide( );
         m_pFloatingPosY->hide( );
         m_pFloatingWidthLabel->hide( );
         m_pFloatingHeightLabel->hide( );
         m_pFloatingPosXLabel->hide( );
         m_pFloatingPosYLabel->hide( );
         break;
      case 3:
         ( *m_currentViewEntry ).setDockPosition( PMDockWidget::DockNone );
         m_pColumnWidthLabel->hide( );
         m_pColumnWidthEdit->hide( );
         m_pViewHeightEdit->hide( );
         m_pViewHeightLabel->hide( );
         m_pFloatingWidth->show( );
         m_pFloatingHeight->show( );
         m_pFloatingPosX->show( );
         m_pFloatingPosY->show( );
         m_pFloatingWidthLabel->show( );
         m_pFloatingHeightLabel->show( );
         m_pFloatingPosXLabel->show( );
         m_pFloatingPosYLabel->show( );
         break;
   }
   QListViewItem* item = m_pViewEntries->currentItem( );
   if( item )
      item->setText( 2, ( *m_currentViewEntry ).dockPositionAsString( ) );
}

void PMSettingsDialog::slotViewHeightChanged( const QString& text )
{
   ( *m_currentViewEntry ).setHeight( text.toInt( ) );
}

void PMSettingsDialog::slotColumnWidthChanged( const QString& text )
{
   ( *m_currentViewEntry ).setColumnWidth( text.toInt( ) );
}

void PMSettingsDialog::slotFloatingWidthChanged( const QString& text )
{
   ( *m_currentViewEntry ).setFloatingWidth( text.toInt( ) );
}

void PMSettingsDialog::slotFloatingHeightChanged( const QString& text )
{
   ( *m_currentViewEntry ).setFloatingHeight( text.toInt( ) );
}

void PMSettingsDialog::slotFloatingPosXChanged( const QString& text )
{
   ( *m_currentViewEntry ).setFloatingPositionX( text.toInt( ) );
}

void PMSettingsDialog::slotFloatingPosYChanged( const QString& text )
{
   ( *m_currentViewEntry ).setFloatingPositionY( text.toInt( ) );
}

void PMSettingsDialog::slotAddViewEntryClicked( )
{
   PMViewLayoutEntry p;
   QString str;
   QListViewItem* temp;

   temp = m_pViewEntries->currentItem( );
   if( temp )
   {
      int n_item = temp->text( 0 ).toInt( );
      ( *m_currentViewLayout ).addEntry( p, n_item );
      n_item++;
      str.setNum( n_item );
      QListViewItem* a = new QListViewItem( m_pViewEntries, temp,
                                            str, p.extendedViewTypeAsString( ),
                                            p.dockPositionAsString( ) );
      m_pViewEntries->setSelected( a, true );
      temp = a->nextSibling( );
      while( temp )
      {
         n_item++;
         str.setNum( n_item );
         temp->setText( 0, str );
         temp = temp->nextSibling( );
      }
   } 
   else
   {
      // If there is no selected the list must be empty
      ( *m_currentViewLayout ).addEntry( p );
      str.setNum( 1 );
      QListViewItem* a = new QListViewItem( m_pViewEntries, NULL,
                                            str, p.extendedViewTypeAsString( ),
                                            p.dockPositionAsString( ) );
      m_pViewEntries->setSelected( a, true );
   }
}

void PMSettingsDialog::slotRemoveViewEntryClicked( )
{
   QListViewItem* temp;
   QString str;

   QListViewItem* current = m_pViewEntries->currentItem( );
   if( current )
   {
      int n_item = current->text( 0 ).toInt( ) - 1;
      ( *m_currentViewLayout ).removeEntry( n_item );

      // Save the next selected item in temp, since the current item will
      // be removed.
      temp = current->nextSibling( );
      if( !temp )
         temp = current->itemAbove( );
      else
         n_item++;

      delete current;

      if( temp )
      {
         str.setNum( n_item );
         temp->setText( 0, str );
         m_pViewEntries->setSelected( temp, true );
         n_item++;
         temp = temp->nextSibling( );
      }
      else
         slotViewEntrySelected( 0 );
      while( temp )
      {
         str.setNum( n_item );
         temp->setText( 0, str );
         n_item++;
         temp = temp->nextSibling( );
      }
   }
}

void PMSettingsDialog::slotMoveUpViewEntryClicked( )
{
}

void PMSettingsDialog::slotMoveDownViewEntryClicked( )
{
}

#include "pmsettingsdialog.moc"
