/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>

#include <string.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <pan/base/pan-i18n.h>
#include <pan/dialogs/dialogs.h>
#include <pan/dialogs/pan-about.h>

static char * get_credits_code (void);
static char * get_credits_users (void);
static char * get_credits_translators (void);

/**
 * dialog_about:
 *
 * About window to display program information, version number, and
 * copyright.
 **/
void
dialog_about (GtkWidget * window)
{
	char * pch;
	char * credits_bugs;
	char * credits_i18n;
	char * credits_code;
	GtkWidget * about;

	about = pan_about_new (GTK_WINDOW(window),
	                       "Pan", VERSION,
	                       _("A newsreader for GNOME"),
	                       _("Copyright (C) 2002 Charles Kerr"),
	                       PAN_ABOUT_LICENSE_GPL,
	                       "http://pan.rebelbase.com/");

	pan_about_add_author (about, "Charles Kerr", "charles@rebelbase.com",
	                      _("Programmer"));
	pan_about_add_author (about, "Christophe Lambin", "clambin@easynet.be",
	                      _("Programmer"));
	pan_about_add_author (about, "Adam Huffman", "bloch@verdurin.com",
	                      _("Programmer & Documentation"));
	pan_about_add_author (about, "Matt Eagleson", "e.Messiah@superpimp.org",
	                      _("Project Originator, Programmer"));
	pan_about_add_author (about, "Jason Leach", NULL,
	                      _("Programmer, 0.6 - 0.7"));

	credits_i18n = get_credits_translators ();
	credits_code = get_credits_code ();
	credits_bugs = get_credits_users ();
	pch = g_strdup_printf (_("Pan %s Translations\n%s\n"
                                 "\n"
                                 "Pan %s Code or Patches\n%s\n"
                                 "\n"
                                 "Pan %s Suggestions and Testing\n%s\n"
                                 "\n"
	                         "Contributors to previous versions are listed at\n"
	                         "http://pan.rebelbase.com/CREDITS"),
	                         VERSION, credits_i18n,
	                         VERSION, credits_code,
	                         VERSION, credits_bugs);
	pan_about_add_text (about, _("Thanks"), pch);
	g_free (credits_i18n);
	g_free (credits_code);
	g_free (credits_bugs);
	g_free (pch);

	gtk_widget_show (about);
}


static char *
get_credits_translators (void)
{
	const char * str =
		"\n\tam - Ge'ez Frontier Foundation"
		"\n\tcs - Michal Bukovjan, Miloslav Trmac"
		"\n\tde - Benjamin Greiner, Christian Meyer, Karsten Weiss"
		"\n\tes - Pablo del Campo"
		"\n\tet - Tivo Leedjrv"
		"\n\tfr - Gildas Guillemot, Christophe Merlet, Laurent Richard"
		"\n\tno - Kjartan Maraas"
		"\n\tsk - Marcel Telka"
		"\n\tsv - Christian Rose"
		"\n\tlv - Artis Trops"
		"\n\tpl - GNOME PL Team"
		"\n\tpt - Duarte Loreto"
		"\n\tnl - Vincent van Adrighem, Reinout van Schouwen"
		"\n\tuk - Yuri Syrota"
		"\n\tja - Takayuki KUSANO";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}

static char *
get_credits_code (void)
{
	const char * str =
		"\n\tRobert Boucher"
		"\n\tClinton Bunch"
		"\n\tHarav Shivanan"
		"\n\tNam SungHyun";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}

static char *
get_credits_users (void)
{
	const char * str = 
		"\n\tRobert Boucher"
		"\n\tMichaela Susan Buesin"
		"\n\tBobby D. Bryant (#102208)"
		"\n\tJean-Marc Desperrier (#104479)"
		"\n\tNicolas Girard (#104155)"
		"\n\tJakob Breivik Grimstveit (#105879)"
		"\n\tMike Hearn (#103563)"
		"\n\tHolger Hoffsttte (#102881)"
		"\n\tMark Kelly"
		"\n\tMaurizio (#101013)"
		"\n\tBas Mevissen (#103908, #103907)"
		"\n\tMr. Nice (#107025)"
		"\n\tMatt Pinkham (#103579)"
		"\n\tMartin Schrode (#88869)"
		"\n\tJerry Segers (#102586, #102577)"
		"\n\tHarav Shivanan"
		"\n\tVille Skytt (#102158)"
		"\n\tLuigi Trovato"
		"\n\tAdam Warner (#102469)"
		"\n\tMichael Waters";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}
