/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FLAGSET_H
#define FLAGSET_H

#include <glib.h>
#include <pan/base/pan-callback.h>
#include <pan/base/message-identifier.h>

void          flagset_init            (void);

gboolean      flagset_has_message     (const char          * message_id);

void          flagset_add_messages    (MessageIdentifier  ** mids,
                                       int                   qty);

void          flagset_add_articles    (const Article      ** articles,
                                       int                   qty);

void          flagset_remove_messages (MessageIdentifier  ** mids,
                                       int                   qty);

void          flagset_remove_articles (const Article      ** articles,
                                       int                   qty);

void          flagset_flush           (void);



#endif
