/*******************************************************************
*                                                                  *
*             This software is part of the ast package             *
*                Copyright (c) 1985-2001 AT&T Corp.                *
*        and it may only be used by you under license from         *
*                       AT&T Corp. ("AT&T")                        *
*         A copy of the Source Code Agreement is available         *
*                at the AT&T Internet web site URL                 *
*                                                                  *
*       http://www.research.att.com/sw/license/ast-open.html       *
*                                                                  *
*        If you have copied this software without agreeing         *
*        to the terms of the license you are infringing on         *
*           the license and copyright and are violating            *
*               AT&T's intellectual property rights.               *
*                                                                  *
*                 This software was created by the                 *
*                 Network Services Research Center                 *
*                        AT&T Labs Research                        *
*                         Florham Park NJ                          *
*                                                                  *
*               Glenn Fowler <gsf@research.att.com>                *
*                David Korn <dgk@research.att.com>                 *
*                 Phong Vo <kpv@research.att.com>                  *
*******************************************************************/
#pragma prototyped

/* : : generated by ucs_names.c : : */

/*
 * ucs name and alias tables
 * define UCS_BYTE for 8 bit ascii/latin only
 */

#define UCS_UC		1
#define UCS_LC		2

static const char	ucs_strings[] = "\
letter\0\
with\0\
and\0\
digit\0\
form\0\
sign\0\
capital\0\
uc\0\
small\0\
lc\0\
above\0\
acute\0\
alef\0\
alpha\0\
arabic\0\
below\0\
bopomofo\0\
box\0\
breve\0\
caron\0\
cedilla\0\
circled\0\
circumflex\0\
cyrillic\0\
dasia\0\
diaeresis\0\
dot\0\
double\0\
down\0\
drawings\0\
eta\0\
final\0\
full\0\
grave\0\
greek\0\
heavy\0\
hebrew\0\
hiragana\0\
hook\0\
horizontal\0\
horn\0\
initial\0\
iota\0\
isolated\0\
katakana\0\
latin\0\
left\0\
light\0\
line\0\
macron\0\
mark\0\
medial\0\
number\0\
numeral\0\
omega\0\
one\0\
oxia\0\
parenthesized\0\
perispomeni\0\
prosgegrammeni\0\
psili\0\
right\0\
roman\0\
single\0\
tilde\0\
to\0\
up\0\
upsilon\0\
varia\0\
vertical\0\
white\0\
of\0\
stop\0\
black\0\
fraction\0\
vulgar\0\
superscript\0\
subscript\0\
square\0\
ligature\0\
space\0\
indic\0\
ideograph\0\
ideographic\0\
equal\0\
arrow\0\
than\0\
suit\0\
or\0\
bracket\0\
ocr\0\
half\0\
end\0\
big\0\
byelorussian\0\
inverted\0\
middle\0\
ogonek\0\
ring\0\
short\0\
stroke\0\
tonos\0\
ukrainian\0\
upturn\0\
null\0\
nul\0\
nu\0\
start heading\0\
soh\0\
sh\0\
start text\0\
stx\0\
sx\0\
text\0\
etx\0\
ex\0\
transmission\0\
eot\0\
et\0\
enquiry\0\
enq\0\
eq\0\
acknowledge\0\
ack\0\
ak\0\
bell\0\
bel\0\
bl\0\
alert\0\
backspace\0\
bs\0\
tabulation\0\
tab\0\
ht\0\
feed\0\
lf\0\
newline\0\
vt\0\
ff\0\
carriage return\0\
cr\0\
shift out\0\
so\0\
shift in\0\
si\0\
data link escape\0\
dl\0\
dle\0\
device control\0\
d1\0\
dc1\0\
device control two\0\
d2\0\
dc2\0\
device control three\0\
d3\0\
dc3\0\
device control four\0\
d4\0\
dc4\0\
negative acknowledge\0\
nak\0\
nk\0\
synchronous idle\0\
sy\0\
syn\0\
transmission block\0\
eb\0\
etb\0\
cancel\0\
can\0\
cn\0\
medium\0\
em\0\
substitute\0\
sb\0\
sub\0\
escape\0\
ec\0\
esc\0\
file separator\0\
fs\0\
is4\0\
group separator\0\
gs\0\
is3\0\
intro\0\
record separator\0\
is2\0\
rs\0\
unit separator\0\
is1\0\
us\0\
\0\
sp\0\
exclamation\0\
quotation\0\
nb\0\
h-\0\
dollar\0\
do\0\
!s\0\
percent\0\
ampersand\0\
apostrophe\0\
parenthesis\0\
asterisk\0\
plus\0\
comma\0\
hyphen minus\0\
hyphen\0\
period\0\
solidus\0\
slash\0\
zero\0\
two\0\
three\0\
four\0\
five\0\
six\0\
seven\0\
eight\0\
nine\0\
colon\0\
semicolon\0\
less\0\
equals\0\
greater\0\
question\0\
commercial at\0\
at\0\
oa\0\
a\0\
b\0\
c\0\
d\0\
e\0\
f\0\
g\0\
h\0\
i\0\
j\0\
k\0\
l\0\
m\0\
n\0\
o\0\
p\0\
q\0\
r\0\
s\0\
t\0\
u\0\
v\0\
w\0\
x\0\
y\0\
z\0\
reverse solidus\0\
backslash\0\
)>\0\
accent\0\
hat\0\
'>\0\
low\0\
underscore\0\
'!\0\
curly\0\
brace\0\
(!\0\
bar\0\
!)\0\
'?e\0\
delete\0\
del\0\
dt\0\
padding character\0\
pa\0\
pad\0\
high octet preset\0\
ho\0\
hop\0\
break permitted here\0\
bh\0\
bph\0\
no break here\0\
nh\0\
nbh\0\
index\0\
in\0\
ind\0\
next\0\
nl\0\
nel\0\
start selected area\0\
sa\0\
ssa\0\
selected area\0\
es\0\
esa\0\
character tabulation set\0\
hs\0\
hts\0\
character tabulation justification\0\
hj\0\
htj\0\
tabulation set\0\
vs\0\
vts\0\
partial forward\0\
pd\0\
pld\0\
partial backward\0\
pu\0\
plu\0\
reverse feed\0\
ri\0\
shift two\0\
s2\0\
ss2\0\
shift three\0\
s3\0\
ss3\0\
device control string\0\
dc\0\
dcs\0\
private use\0\
p1\0\
pu1\0\
private use two\0\
p2\0\
pu2\0\
set transmit state\0\
ts\0\
sts\0\
cancel character\0\
cc\0\
cch\0\
message waiting\0\
mw\0\
start guarded area\0\
sg\0\
spa\0\
guarded area\0\
eg\0\
epa\0\
start string\0\
sos\0\
graphic character introducer\0\
gc\0\
sgci\0\
character introducer\0\
sc\0\
sci\0\
control sequence introducer\0\
ci\0\
csi\0\
string terminator\0\
st\0\
operating system command\0\
oc\0\
osc\0\
privacy message\0\
pm\0\
application program command\0\
ac\0\
apc\0\
no break\0\
ns\0\
!i\0\
cent\0\
ct\0\
!c\0\
pound\0\
l-\0\
currency\0\
cu\0\
xo\0\
yen\0\
ye\0\
y-\0\
broken bar\0\
bb\0\
!b\0\
section\0\
se\0\
':\0\
copyright\0\
co\0\
feminine ordinal indicator\0\
-a\0\
pointing angle quotation\0\
<<\0\
not\0\
no\0\
7!\0\
soft hyphen\0\
--\0\
registered\0\
rg\0\
'm\0\
degree\0\
dg\0\
plus minus\0\
+-\0\
2s\0\
3s\0\
micro\0\
my\0\
pilcrow\0\
pi\0\
9i\0\
.m\0\
',\0\
1s\0\
masculine ordinal indicator\0\
-o\0\
>>\0\
quarter\0\
14\0\
12\0\
three quarters\0\
34\0\
?i\0\
a!\0\
a'\0\
a>\0\
a?\0\
a:\0\
aa\0\
ae\0\
c,\0\
e!\0\
e'\0\
e>\0\
e:\0\
i!\0\
i'\0\
i>\0\
i:\0\
eth\0\
d-\0\
n?\0\
o!\0\
o'\0\
o>\0\
o?\0\
o:\0\
multiplication\0\
*x\0\
o/\0\
u!\0\
u'\0\
u>\0\
u:\0\
y'\0\
thorn\0\
th\0\
sharp s\0\
ss\0\
division\0\
-:\0\
y:\0\
";

#if !UCS_BYTE
static const char ucs_strings_mb[] = "\
a-\0\
a(\0\
a;\0\
c'\0\
c>\0\
c.\0\
c<\0\
d<\0\
d/\0\
e-\0\
e(\0\
e.\0\
e;\0\
e<\0\
g>\0\
g(\0\
g.\0\
g,\0\
h>\0\
h/\0\
i?\0\
i-\0\
i(\0\
i;\0\
i.\0\
dotless i\0\
ij\0\
j>\0\
k,\0\
kra\0\
kk\0\
l'\0\
l,\0\
l<\0\
l.\0\
l/\0\
n'\0\
n,\0\
n<\0\
n preceded by apostrophe\0\
'n\0\
eng\0\
ng\0\
o-\0\
o(\0\
o\"\0\
oe\0\
r'\0\
r,\0\
r<\0\
s'\0\
s>\0\
s,\0\
s<\0\
t,\0\
t<\0\
t/\0\
u?\0\
u-\0\
u(\0\
u0\0\
u\"\0\
u;\0\
w>\0\
y>\0\
z'\0\
z.\0\
z<\0\
long s\0\
s1\0\
b/\0\
b2\0\
c2\0\
f2\0\
k2\0\
o9\0\
oi\0\
yr\0\
u9\0\
z/\0\
ezh\0\
ed\0\
dz\0\
dz<\0\
d z\0\
lj\0\
lj3\0\
l j\0\
nj\0\
nj3\0\
n j\0\
a<\0\
i<\0\
o<\0\
u<\0\
u:-\0\
u:'\0\
u:<\0\
u:!\0\
turned e\0\
e1\0\
a1\0\
a7\0\
a3\0\
g/\0\
g<\0\
k<\0\
o;\0\
o1\0\
ez\0\
j<\0\
dz3\0\
g'\0\
aa'\0\
ae'\0\
o/'\0\
a!!\0\
a)\0\
e!!\0\
e)\0\
i!!\0\
i)\0\
o!!\0\
o)\0\
r!!\0\
r)\0\
u!!\0\
u)\0\
r long leg\0\
r1\0\
modifier turned comma\0\
;s\0\
modifier accent\0\
1>\0\
'<\0\
modifier\0\
1-\0\
1!\0\
'(\0\
'.\0\
'0\0\
';\0\
1?\0\
'\"\0\
combining accent\0\
\"`\0\
\"'\0\
'g\0\
lower\0\
,g\0\
ypogegrammeni\0\
j3\0\
?%\0\
'*\0\
dialytika\0\
'%\0\
a%\0\
ano teleia\0\
.*\0\
epsilon\0\
e%\0\
y%\0\
i%\0\
omicron\0\
o%\0\
u%\0\
w%\0\
i3\0\
a*\0\
beta\0\
b*\0\
gamma\0\
g*\0\
delta\0\
d*\0\
e*\0\
zeta\0\
z*\0\
"
"\
y*\0\
theta\0\
h*\0\
i*\0\
kappa\0\
k*\0\
lamda\0\
l*\0\
mu\0\
m*\0\
n*\0\
xi\0\
c*\0\
o*\0\
p*\0\
rho\0\
r*\0\
sigma\0\
s*\0\
tau\0\
t*\0\
u*\0\
phi\0\
f*\0\
chi\0\
x*\0\
psi\0\
q*\0\
w*\0\
j*\0\
v*\0\
u3\0\
*s\0\
beta symbol\0\
b3\0\
stigma\0\
t3\0\
digamma\0\
m3\0\
koppa\0\
k3\0\
sampi\0\
p3\0\
io\0\
dje\0\
d%\0\
gje\0\
g%\0\
ie\0\
dze\0\
ds\0\
ii\0\
yi\0\
je\0\
j%\0\
lje\0\
nje\0\
tshe\0\
kje\0\
kj\0\
v%\0\
dzhe\0\
a=\0\
be\0\
b=\0\
ve\0\
v=\0\
ghe\0\
g=\0\
de\0\
d=\0\
e=\0\
zhe\0\
z%\0\
ze\0\
z=\0\
i=\0\
j=\0\
ka\0\
k=\0\
el\0\
l=\0\
m=\0\
en\0\
n=\0\
o=\0\
pe\0\
p=\0\
er\0\
r=\0\
s=\0\
te\0\
t=\0\
u=\0\
ef\0\
f=\0\
ha\0\
h=\0\
tse\0\
c=\0\
che\0\
c%\0\
sha\0\
s%\0\
shcha\0\
hard\0\
=\"\0\
yeru\0\
y=\0\
soft\0\
%\"\0\
yu\0\
ju\0\
ya\0\
ja\0\
='\0\
%'\0\
yat\0\
y3\0\
yus\0\
o3\0\
fita\0\
f3\0\
izhitsa\0\
v3\0\
c3\0\
g3\0\
a+\0\
bet\0\
b+\0\
gimel\0\
g+\0\
dalet\0\
d+\0\
he\0\
h+\0\
vav\0\
w+\0\
zayin\0\
z+\0\
het\0\
x+\0\
tet\0\
tj\0\
yod\0\
j+\0\
kaf\0\
k%\0\
k+\0\
lamed\0\
l+\0\
mem\0\
m%\0\
m+\0\
nun\0\
n%\0\
n+\0\
samekh\0\
s+\0\
ayin\0\
e+\0\
p%\0\
p+\0\
tsadi\0\
zj\0\
qof\0\
q+\0\
resh\0\
r+\0\
shin\0\
tav\0\
t+\0\
,+\0\
;+\0\
?+\0\
hamza\0\
h'\0\
madda\0\
am\0\
ah\0\
waw hamza\0\
wh\0\
yeh hamza\0\
yh\0\
beh\0\
teh marbuta\0\
tm\0\
teh\0\
theh\0\
tk\0\
jeem\0\
hah\0\
hk\0\
khah\0\
dal\0\
thal\0\
dk\0\
reh\0\
zain\0\
seen\0\
sheen\0\
sn\0\
sad\0\
c+\0\
dad\0\
dd\0\
tah\0\
zah\0\
zh\0\
ain\0\
ghain\0\
i+\0\
tatweel\0\
++\0\
feh\0\
f+\0\
qaf\0\
lam\0\
meem\0\
noon\0\
heh\0\
waw\0\
maksura\0\
yeh\0\
y+\0\
fathatan\0\
:+\0\
dammatan\0\
\"+\0\
kasratan\0\
=+\0\
fatha\0\
/+\0\
damma\0\
'+\0\
kasra\0\
1+\0\
shadda\0\
3+\0\
sukun\0\
0+\0\
0a\0\
1a\0\
2a\0\
3a\0\
4a\0\
5a\0\
6a\0\
7a\0\
8a\0\
9a\0\
%a\0\
as\0\
peh\0\
hah hamza\0\
hh\0\
tcheh\0\
tc\0\
jeh\0\
veh\0\
v+\0\
gaf\0\
gf\0\
a-0\0\
b.\0\
b-.\0\
b_\0\
c,'\0\
d.\0\
d-.\0\
d_\0\
d,\0\
d->\0\
e-!\0\
e-'\0\
e->\0\
e-?\0\
e,(\0\
f.\0\
g-\0\
h.\0\
h-.\0\
h:\0\
h,\0\
h-(\0\
i-?\0\
i:'\0\
k'\0\
k-.\0\
k_\0\
l-.\0\
l--.\0\
l_\0\
l->\0\
m'\0\
m.\0\
m-.\0\
n.\0\
n-.\0\
n_\0\
n->\0\
o?'\0\
o?:\0\
o-!\0\
o-'\0\
p'\0\
p.\0\
r.\0\
r-.\0\
r--.\0\
r_\0\
s.\0\
s-.\0\
s'.\0\
s<.\0\
s.-.\0\
t.\0\
t-.\0\
t_\0\
t->\0\
u--:\0\
u-?\0\
u->\0\
u?'\0\
u-:\0\
v?\0\
v-.\0\
w!\0\
w'\0\
w:\0\
w.\0\
w-.\0\
x.\0\
x:\0\
y.\0\
z>\0\
z-.\0\
z_\0\
a-.\0\
a2\0\
a>'\0\
a>!\0\
a>2\0\
a>?\0\
a>-.\0\
a('\0\
a(!\0\
a(2\0\
a(?\0\
a(-.\0\
e-.\0\
e2\0\
e?\0\
e>'\0\
e>!\0\
e>2\0\
e>?\0\
e>-.\0\
i2\0\
i-.\0\
o-.\0\
o2\0\
o>'\0\
o>!\0\
o>2\0\
o>?\0\
o>-.\0\
o9'\0\
o9!\0\
o92\0\
o9?\0\
o9-.\0\
u-.\0\
u2\0\
u9'\0\
u9!\0\
u92\0\
u9?\0\
u9-.\0\
y!\0\
y-.\0\
y2\0\
y?\0\
a*,\0\
a*;\0\
a*,!\0\
a*;!\0\
a*,'\0\
a*;'\0\
a*,?\0\
a*;?\0\
e*,\0\
e*;\0\
e*,!\0\
e*;!\0\
e*,'\0\
e*;'\0\
y*,\0\
y*;\0\
y*,!\0\
y*;!\0\
y*,'\0\
y*;'\0\
y*,?\0\
y*;?\0\
i*,\0\
i*;\0\
i*,!\0\
i*;!\0\
i*,'\0\
i*;'\0\
i*,?\0\
i*;?\0\
o*,\0\
o*;\0\
o*,!\0\
o*;!\0\
o*,'\0\
o*;'\0\
u*,\0\
u*;\0\
u*,!\0\
u*;!\0\
u*,'\0\
u*;'\0\
u*,?\0\
u*;?\0\
w*,\0\
w*;\0\
w*,!\0\
w*;!\0\
w*,'\0\
w*;'\0\
w*,?\0\
w*;?\0\
a*!\0\
a*'\0\
e*!\0\
e*'\0\
y*!\0\
y*'\0\
i*!\0\
i*'\0\
o*!\0\
o*'\0\
u*!\0\
u*'\0\
w*!\0\
w*'\0\
a*,j\0\
a*;j\0\
a*,!j\0\
a*;!j\0\
a*,'j\0\
a*;'j\0\
a*,?j\0\
a*;?j\0\
y*,j\0\
y*;j\0\
y*,!j\0\
y*;!j\0\
y*,'j\0\
y*;'j\0\
y*,?j\0\
y*;?j\0\
w*,j\0\
w*;j\0\
w*,!j\0\
w*;!j\0\
w*,'j\0\
w*;'j\0\
w*,?j\0\
w*;?j\0\
vrachy\0\
a*(\0\
a*-\0\
a*!j\0\
a*j\0\
a*'j\0\
a*?\0\
a*?j\0\
koronis\0\
)*\0\
,,\0\
?*\0\
?:\0\
y*!j\0\
y*j\0\
y*'j\0\
y*?\0\
y*?j\0\
e*!!\0\
,!\0\
,'\0\
?,\0\
i*(\0\
i*-\0\
i*:!\0\
i*:'\0\
i*?\0\
i*:?\0\
;!\0\
;'\0\
?;\0\
u*(\0\
u*-\0\
u*:!\0\
u*:'\0\
r*,\0\
r*;\0\
u*?\0\
u*:?\0\
!:\0\
:'\0\
!*\0\
w*!j\0\
w*j\0\
w*'j\0\
w*?\0\
w*?j\0\
/*\0\
;;\0\
1n\0\
1m\0\
three per em\0\
3m\0\
four per em\0\
4m\0\
six per em\0\
6m\0\
thin\0\
1t\0\
hair\0\
1h\0\
lr\0\
rl\0\
en dash\0\
-n\0\
em dash\0\
-m\0\
-3\0\
!2\0\
=2\0\
'6\0\
'9\0\
low-9 quotation\0\
.9\0\
high reversed-9 quotation\0\
9'\0\
\"6\0\
\"9\0\
:9\0\
9\"\0\
dagger\0\
/-\0\
/=\0\
bullet\0\
triangular bullet\0\
3b\0\
two leader\0\
..\0\
ellipsis\0\
.3\0\
hyphenation point\0\
.-\0\
separator\0\
linesep\0\
paragraph separator\0\
parsep\0\
per mille\0\
%0\0\
prime\0\
1'\0\
2'\0\
triple prime\0\
3'\0\
reversed prime\0\
1\"\0\
2\"\0\
reversed triple prime\0\
3\"\0\
caret\0\
ca\0\
<1\0\
>1\0\
reference\0\
:x\0\
!*2\0\
overline\0\
'-\0\
hyphen bullet\0\
-b\0\
/f\0\
0s\0\
4s\0\
5s\0\
6s\0\
7s\0\
8s\0\
9s\0\
+s\0\
minus\0\
-s\0\
=s\0\
(s\0\
)s\0\
french franc\0\
lira\0\
peseta\0\
won\0\
w=\0\
euro\0\
combining harpoon\0\
\"7\0\
degree celsius\0\
care\0\
degree fahrenheit\0\
numero\0\
n0\0\
sound recording copyright\0\
po\0\
prescription take\0\
rx\0\
service\0\
sm\0\
trade\0\
"
"\
ohm\0\
om\0\
angstrom\0\
ao\0\
estimated symbol\0\
est\0\
third\0\
13\0\
two thirds\0\
23\0\
fifth\0\
15\0\
two fifths\0\
25\0\
three fifths\0\
35\0\
four fifths\0\
45\0\
sixth\0\
16\0\
five sixths\0\
56\0\
eighth\0\
18\0\
three eighths\0\
38\0\
five eighths\0\
58\0\
seven eighths\0\
78\0\
1r\0\
2r\0\
3r\0\
4r\0\
5r\0\
6r\0\
7r\0\
8r\0\
9r\0\
ten\0\
ar\0\
eleven\0\
br\0\
twelve\0\
fifty\0\
50r\0\
hundred\0\
100r\0\
five hundred\0\
500r\0\
thousand\0\
1000r\0\
thousand c d\0\
1000rcd\0\
five thousand\0\
5000r\0\
ten thousand\0\
10000r\0\
leftwards\0\
<-\0\
upwards\0\
-!\0\
rightwards\0\
->\0\
downwards\0\
-v\0\
<>\0\
ud\0\
north west\0\
<!!\0\
north east\0\
//>\0\
south east\0\
!!>\0\
south west\0\
<//\0\
base\0\
ud-\0\
rightwards harpoon barb upwards\0\
>v\0\
<=\0\
=>\0\
==\0\
for all\0\
fa\0\
partial differential\0\
dp\0\
there exists\0\
empty set\0\
/0\0\
increment\0\
nabla\0\
element\0\
(-\0\
contains as member\0\
-)\0\
proof\0\
fp\0\
n ary product\0\
*p\0\
n ary summation\0\
+z\0\
-2\0\
minus plus\0\
-+\0\
.+\0\
asterisk operator\0\
*-\0\
operator\0\
ob\0\
bullet operator\0\
root\0\
rt\0\
proportional\0\
0(\0\
infinity\0\
00\0\
angle\0\
-l\0\
parallel\0\
pp\0\
logical\0\
an\0\
intersection\0\
(u\0\
union\0\
)u\0\
integral\0\
di\0\
contour integral\0\
therefore\0\
.:\0\
because\0\
:.\0\
ratio\0\
:r\0\
proportion\0\
::\0\
?1\0\
lazy s\0\
cg\0\
asymptotically\0\
?-\0\
approximately\0\
?=\0\
almost\0\
?2\0\
all\0\
=?\0\
image approximately\0\
hi\0\
!=\0\
identical\0\
=3\0\
=<\0\
>=\0\
much less\0\
<*\0\
much greater\0\
*>\0\
not less\0\
!<\0\
not greater\0\
!>\0\
subset\0\
(c\0\
superset\0\
)c\0\
(_\0\
)_\0\
0.\0\
02\0\
tack\0\
-t\0\
.p\0\
:3\0\
house\0\
eh\0\
ceiling\0\
<7\0\
>7\0\
floor\0\
7<\0\
7>\0\
reversed not\0\
ni\0\
arc\0\
(a\0\
telephone recorder\0\
tr\0\
place interest\0\
88\0\
top integral\0\
iu\0\
bottom integral\0\
il\0\
pointing angle\0\
</\0\
/>\0\
open\0\
chair\0\
3h\0\
fork\0\
2h\0\
4h\0\
branch bank identification\0\
1j\0\
amount check\0\
2j\0\
dash\0\
3j\0\
customer account\0\
4j\0\
1-o\0\
2-o\0\
3-o\0\
4-o\0\
5-o\0\
6-o\0\
7-o\0\
8-o\0\
9-o\0\
10-o\0\
11-o\0\
12-o\0\
thirteen\0\
13-o\0\
fourteen\0\
14-o\0\
fifteen\0\
15-o\0\
sixteen\0\
16-o\0\
seventeen\0\
17-o\0\
eighteen\0\
18-o\0\
nineteen\0\
19-o\0\
twenty\0\
20-o\0\
(1)\0\
(2)\0\
(3)\0\
(4)\0\
(5)\0\
(6)\0\
(7)\0\
(8)\0\
(9)\0\
(10)\0\
(11)\0\
(12)\0\
(13)\0\
(14)\0\
(15)\0\
(16)\0\
(17)\0\
(18)\0\
(19)\0\
(20)\0\
1.\0\
2.\0\
3.\0\
4.\0\
5.\0\
6.\0\
7.\0\
8.\0\
9.\0\
10.\0\
11.\0\
12.\0\
13.\0\
14.\0\
15.\0\
16.\0\
17.\0\
18.\0\
19.\0\
20.\0\
(a)\0\
(b)\0\
(c)\0\
(d)\0\
(e)\0\
(f)\0\
(g)\0\
(h)\0\
(i)\0\
(j)\0\
(k)\0\
(l)\0\
(m)\0\
(n)\0\
(o)\0\
(p)\0\
(q)\0\
(r)\0\
(s)\0\
(t)\0\
(u)\0\
(v)\0\
(w)\0\
(x)\0\
(y)\0\
(z)\0\
a o\0\
b o\0\
c o\0\
d o\0\
e o\0\
f o\0\
g o\0\
h o\0\
i o\0\
j o\0\
k o\0\
l o\0\
m o\0\
n o\0\
o o\0\
p o\0\
q o\0\
r o\0\
s o\0\
t o\0\
u o\0\
v o\0\
w o\0\
x o\0\
y o\0\
z o\0\
0-o\0\
_-\0\
hh-\0\
_=\0\
vv\0\
_!\0\
vv-\0\
triple dash\0\
3-\0\
3_\0\
3!\0\
3/\0\
quadruple dash\0\
4-\0\
4_\0\
4!\0\
4/\0\
dr\0\
_v>\0\
dr-\0\
_v<w\0\
dl-\0\
ld-\0\
ur\0\
_a>\0\
ur-\0\
ul\0\
_a<\0\
ul-\0\
vr\0\
_!>\0\
vr-\0\
udr\0\
vl\0\
_!<\0\
vl-\0\
udl\0\
dh\0\
_v-\0\
dlr\0\
dh-\0\
uh\0\
_-a\0\
ulr\0\
uh-\0\
vh\0\
_!-\0\
vlr\0\
vh-\0\
udh\0\
udlr\0\
ld\0\
diagonal upper lower\0\
fd\0\
_>/\0\
bd\0\
upper block\0\
tb\0\
lower block\0\
lb\0\
block\0\
fb\0\
rb\0\
shade\0\
.s\0\
medium shade\0\
:s\0\
dark shade\0\
?s\0\
os\0\
rounded corners\0\
ro\0\
containing\0\
rr\0\
fill\0\
rf\0\
ry\0\
orthogonal crosshatch fill\0\
rh\0\
upper lower fill\0\
rz\0\
rk\0\
diagonal crosshatch fill\0\
rectangle\0\
sr\0\
pointing triangle\0\
ut\0\
pointing pointer\0\
pr\0\
tl\0\
pl\0\
diamond\0\
db\0\
dw\0\
lozenge\0\
lz\0\
circle\0\
0m\0\
bullseye\0\
0o\0\
0l\0\
0r\0\
inverse bullet\0\
inverse circle\0\
ic\0\
lower triangle\0\
_.>/\0\
large circle\0\
star\0\
*2\0\
*1\0\
telephone\0\
tel\0\
pointing index\0\
<h\0\
>h\0\
smiling face\0\
0u\0\
sun rays\0\
su\0\
female\0\
fm\0\
male\0\
ml\0\
spade\0\
cs\0\
heart\0\
ch\0\
cd\0\
club\0\
cs-\0\
ch-\0\
cd-\0\
cc-\0\
quarter note\0\
md\0\
eighth note\0\
m8\0\
_d!\0\
beamed eighth notes\0\
m2\0\
beamed sixteenth notes\0\
m16\0\
music flat\0\
mb\0\
music natural\0\
mx\0\
music sharp\0\
check\0\
ok\0\
ballot x\0\
xx\0\
maltese cross\0\
-x\0\
is\0\
,_\0\
._\0\
ditto\0\
+\"\0\
japanese industrial standard symbol\0\
jis\0\
iteration\0\
*_\0\
closing\0\
;_\0\
0_\0\
<+\0\
>+\0\
corner\0\
<'\0\
>'\0\
<\"\0\
>\"\0\
lenticular\0\
(\"\0\
)\"\0\
postal\0\
=t\0\
geta\0\
=_\0\
tortoise shell\0\
"
"\
('\0\
)'\0\
(i\0\
)i\0\
wave dash\0\
-?\0\
postal face\0\
=t:)\0\
a5\0\
i5\0\
u5\0\
e5\0\
o5\0\
ga\0\
ki\0\
gi\0\
ku\0\
gu\0\
ke\0\
ge\0\
ko\0\
go\0\
za\0\
zi\0\
zu\0\
zo\0\
ta\0\
da\0\
ti\0\
tu\0\
du\0\
na\0\
ne\0\
ba\0\
bi\0\
hu\0\
bu\0\
bo\0\
ma\0\
mi\0\
me\0\
mo\0\
yo\0\
ra\0\
ru\0\
re\0\
wa\0\
wi\0\
we\0\
wo\0\
n5\0\
vu\0\
voiced sound\0\
\"5\0\
semi voiced sound\0\
05\0\
*5\0\
voiced iteration\0\
+5\0\
a6\0\
i6\0\
u6\0\
e6\0\
o6\0\
n6\0\
va\0\
vi\0\
vo\0\
.6\0\
prolonged sound\0\
-6\0\
*6\0\
+6\0\
b4\0\
p4\0\
m4\0\
f4\0\
t4\0\
n4\0\
l4\0\
g4\0\
k4\0\
h4\0\
j4\0\
q4\0\
x4\0\
r4\0\
z4\0\
c4\0\
s4\0\
a4\0\
o4\0\
e4\0\
eh4\0\
ai\0\
ei\0\
au\0\
ou\0\
ang\0\
i4\0\
u4\0\
v4\0\
gn\0\
hangul cieuc u\0\
(ju)\0\
1c\0\
2c\0\
3c\0\
4c\0\
5c\0\
6c\0\
7c\0\
8c\0\
9c\0\
10c\0\
korean standard symbol\0\
ksc\0\
fi\0\
fl\0\
ffi\0\
ffl\0\
long s t\0\
3+;\0\
h'-\0\
am-\0\
am.\0\
ah-\0\
ah.\0\
wh-\0\
yh,\0\
a+-\0\
a+.\0\
b+-\0\
b+.\0\
b+,\0\
b+;\0\
tm-\0\
tm.\0\
t+-\0\
t+.\0\
t+,\0\
t+;\0\
tk-\0\
tk.\0\
tk,\0\
tk;\0\
g+-\0\
g+.\0\
g+,\0\
g+;\0\
hk-\0\
hk.\0\
hk,\0\
hk;\0\
x+-\0\
x+.\0\
x+,\0\
x+;\0\
d+-\0\
d+.\0\
dk-\0\
dk.\0\
r+-\0\
r+.\0\
z+-\0\
z+.\0\
s+-\0\
s+.\0\
s+,\0\
s+;\0\
sn-\0\
sn.\0\
sn,\0\
sn;\0\
c+-\0\
c+.\0\
c+,\0\
c+;\0\
dd-\0\
dd.\0\
dd,\0\
dd;\0\
tj-\0\
tj.\0\
tj,\0\
tj;\0\
zh-\0\
zh.\0\
zh,\0\
zh;\0\
e+-\0\
e+.\0\
e+,\0\
e+;\0\
i+-\0\
i+.\0\
i+,\0\
i+;\0\
f+-\0\
f+.\0\
f+,\0\
f+;\0\
q+-\0\
q+.\0\
q+,\0\
q+;\0\
k+-\0\
k+.\0\
k+,\0\
k+;\0\
l+-\0\
l+.\0\
l+,\0\
l+;\0\
m+-\0\
m+.\0\
m+,\0\
m+;\0\
n+-\0\
n+.\0\
n+,\0\
n+;\0\
h+-\0\
h+.\0\
h+,\0\
h+;\0\
w+-\0\
w+.\0\
j+-\0\
j+.\0\
y+-\0\
y+.\0\
y+,\0\
y+;\0\
lam madda\0\
lm-\0\
lm.\0\
lam hamza\0\
lh-\0\
lh.\0\
la-\0\
la.\0\
";
#endif /* UCS_BYTE */

static Ucs_map_t	ucs_attrs[] =
{
	{{0x00000001,0x00000000,0x00000000},0x0000,&ucs_strings[0]},
	{{0x00000001,0x00000000,0x00000000},0x0000,&ucs_strings[7]},
	{{0x00000001,0x00000000,0x00000000},0x0000,&ucs_strings[12]},
	{{0x00000001,0x00000000,0x00000000},0x0000,&ucs_strings[16]},
	{{0x00000001,0x00000000,0x00000000},0x0000,&ucs_strings[22]},
	{{0x00000001,0x00000000,0x00000000},0x0000,&ucs_strings[27]},
	{{0x00000002,0x00000000,0x00000000},0x0001,&ucs_strings[32]},
	{{0x00000002,0x00000000,0x00000000},0x0001,&ucs_strings[40]},
	{{0x00000004,0x00000000,0x00000000},0x0002,&ucs_strings[43]},
	{{0x00000004,0x00000000,0x00000000},0x0002,&ucs_strings[49]},
	{{0x00000008,0x00000000,0x00000000},0x0003,&ucs_strings[52]},
	{{0x00000010,0x00000000,0x00000000},0x0004,&ucs_strings[58]},
	{{0x00000020,0x00000000,0x00000000},0x0005,&ucs_strings[64]},
	{{0x00000040,0x00000000,0x00000000},0x0006,&ucs_strings[69]},
	{{0x00000080,0x00000000,0x00000000},0x0007,&ucs_strings[75]},
	{{0x00000100,0x00000000,0x00000000},0x0008,&ucs_strings[82]},
	{{0x00000200,0x00000000,0x00000000},0x0009,&ucs_strings[88]},
	{{0x00000400,0x00000000,0x00000000},0x000a,&ucs_strings[97]},
	{{0x00000800,0x00000000,0x00000000},0x000b,&ucs_strings[101]},
	{{0x00001000,0x00000000,0x00000000},0x000c,&ucs_strings[107]},
	{{0x00002000,0x00000000,0x00000000},0x000d,&ucs_strings[113]},
	{{0x00004000,0x00000000,0x00000000},0x000e,&ucs_strings[121]},
	{{0x00008000,0x00000000,0x00000000},0x000f,&ucs_strings[129]},
	{{0x00010000,0x00000000,0x00000000},0x0010,&ucs_strings[140]},
	{{0x00020000,0x00000000,0x00000000},0x0011,&ucs_strings[149]},
	{{0x00040000,0x00000000,0x00000000},0x0012,&ucs_strings[155]},
	{{0x00080000,0x00000000,0x00000000},0x0013,&ucs_strings[165]},
	{{0x00100000,0x00000000,0x00000000},0x0014,&ucs_strings[169]},
	{{0x00200000,0x00000000,0x00000000},0x0015,&ucs_strings[176]},
	{{0x00400000,0x00000000,0x00000000},0x0016,&ucs_strings[181]},
	{{0x00800000,0x00000000,0x00000000},0x0017,&ucs_strings[190]},
	{{0x01000000,0x00000000,0x00000000},0x0018,&ucs_strings[194]},
	{{0x02000000,0x00000000,0x00000000},0x0019,&ucs_strings[200]},
	{{0x04000000,0x00000000,0x00000000},0x001a,&ucs_strings[205]},
	{{0x08000000,0x00000000,0x00000000},0x001b,&ucs_strings[211]},
	{{0x10000000,0x00000000,0x00000000},0x001c,&ucs_strings[217]},
	{{0x20000000,0x00000000,0x00000000},0x001d,&ucs_strings[223]},
	{{0x40000000,0x00000000,0x00000000},0x001e,&ucs_strings[230]},
	{{0x80000000,0x00000000,0x00000000},0x001f,&ucs_strings[239]},
	{{0x00000000,0x00000001,0x00000000},0x0020,&ucs_strings[244]},
	{{0x00000000,0x00000002,0x00000000},0x0021,&ucs_strings[255]},
	{{0x00000000,0x00000004,0x00000000},0x0022,&ucs_strings[260]},
	{{0x00000000,0x00000008,0x00000000},0x0023,&ucs_strings[268]},
	{{0x00000000,0x00000010,0x00000000},0x0024,&ucs_strings[273]},
	{{0x00000000,0x00000020,0x00000000},0x0025,&ucs_strings[282]},
	{{0x00000000,0x00000040,0x00000000},0x0026,&ucs_strings[291]},
	{{0x00000000,0x00000080,0x00000000},0x0027,&ucs_strings[297]},
	{{0x00000000,0x00000100,0x00000000},0x0028,&ucs_strings[302]},
	{{0x00000000,0x00000200,0x00000000},0x0029,&ucs_strings[308]},
	{{0x00000000,0x00000400,0x00000000},0x002a,&ucs_strings[313]},
	{{0x00000000,0x00000800,0x00000000},0x002b,&ucs_strings[320]},
	{{0x00000000,0x00001000,0x00000000},0x002c,&ucs_strings[325]},
	{{0x00000000,0x00002000,0x00000000},0x002d,&ucs_strings[332]},
	{{0x00000000,0x00004000,0x00000000},0x002e,&ucs_strings[339]},
	{{0x00000000,0x00008000,0x00000000},0x002f,&ucs_strings[347]},
	{{0x00000000,0x00010000,0x00000000},0x0030,&ucs_strings[353]},
	{{0x00000000,0x00020000,0x00000000},0x0031,&ucs_strings[357]},
	{{0x00000000,0x00040000,0x00000000},0x0032,&ucs_strings[362]},
	{{0x00000000,0x00080000,0x00000000},0x0033,&ucs_strings[376]},
	{{0x00000000,0x00100000,0x00000000},0x0034,&ucs_strings[388]},
	{{0x00000000,0x00200000,0x00000000},0x0035,&ucs_strings[403]},
	{{0x00000000,0x00400000,0x00000000},0x0036,&ucs_strings[409]},
	{{0x00000000,0x00800000,0x00000000},0x0037,&ucs_strings[415]},
	{{0x00000000,0x01000000,0x00000000},0x0038,&ucs_strings[421]},
	{{0x00000000,0x02000000,0x00000000},0x0039,&ucs_strings[428]},
	{{0x00000000,0x04000000,0x00000000},0x003a,&ucs_strings[434]},
	{{0x00000000,0x08000000,0x00000000},0x003b,&ucs_strings[437]},
	{{0x00000000,0x10000000,0x00000000},0x003c,&ucs_strings[440]},
	{{0x00000000,0x20000000,0x00000000},0x003d,&ucs_strings[448]},
	{{0x00000000,0x40000000,0x00000000},0x003e,&ucs_strings[454]},
	{{0x00000000,0x80000000,0x00000000},0x003f,&ucs_strings[463]},
	{{0x00000000,0x00000000,0x00000001},0x0040,&ucs_strings[469]},
	{{0x00000000,0x00000000,0x00000002},0x0041,&ucs_strings[472]},
	{{0x00000000,0x00000000,0x00000004},0x0042,&ucs_strings[477]},
	{{0x00000000,0x00000000,0x00000008},0x0043,&ucs_strings[483]},
	{{0x00000000,0x00000000,0x00000010},0x0044,&ucs_strings[492]},
	{{0x00000000,0x00000000,0x00000020},0x0045,&ucs_strings[499]},
	{{0x00000000,0x00000000,0x00000040},0x0046,&ucs_strings[511]},
	{{0x00000000,0x00000000,0x00000080},0x0047,&ucs_strings[521]},
	{{0x00000000,0x00000000,0x00000100},0x0048,&ucs_strings[528]},
	{{0x00000000,0x00000000,0x00000200},0x0049,&ucs_strings[537]},
	{{0x00000000,0x00000000,0x00000400},0x004a,&ucs_strings[543]},
	{{0x00000000,0x00000000,0x00000800},0x004b,&ucs_strings[549]},
	{{0x00000000,0x00000000,0x00000800},0x004b,&ucs_strings[559]},
	{{0x00000000,0x00000000,0x00001000},0x004c,&ucs_strings[571]},
	{{0x00000000,0x00000000,0x00002000},0x004d,&ucs_strings[577]},
	{{0x00000000,0x00000000,0x00004000},0x004e,&ucs_strings[583]},
	{{0x00000000,0x00000000,0x00008000},0x004f,&ucs_strings[588]},
	{{0x00000000,0x00000000,0x00010000},0x0050,&ucs_strings[593]},
	{{0x00000000,0x00000000,0x00020000},0x0051,&ucs_strings[596]},
	{{0x00000000,0x00000000,0x00040000},0x0052,&ucs_strings[604]},
	{{0x00000000,0x00000000,0x00080000},0x0053,&ucs_strings[608]},
	{{0x00000000,0x00000000,0x00100000},0x0054,&ucs_strings[613]},
	{{0x00000000,0x00000000,0x00200000},0x0055,&ucs_strings[617]},
	{{0x00000000,0x00000000,0x00400000},0x0056,&ucs_strings[621]},
	{{0x00000000,0x00000000,0x00800000},0x0057,&ucs_strings[634]},
	{{0x00000000,0x00000000,0x01000000},0x0058,&ucs_strings[643]},
	{{0x00000000,0x00000000,0x02000000},0x0059,&ucs_strings[650]},
	{{0x00000000,0x00000000,0x04000000},0x005a,&ucs_strings[657]},
	{{0x00000000,0x00000000,0x08000000},0x005b,&ucs_strings[662]},
	{{0x00000000,0x00000000,0x10000000},0x005c,&ucs_strings[668]},
	{{0x00000000,0x00000000,0x20000000},0x005d,&ucs_strings[675]},
	{{0x00000000,0x00000000,0x40000000},0x005e,&ucs_strings[681]},
	{{0x00000000,0x00000000,0x80000000},0x005f,&ucs_strings[691]},
};

static Ucs_map_t	ucs_names[] =
{
	{{0x00000000,0x00000000,0x00000200},0x0020,&ucs_strings[1288]},
	{{0x00000001,0x00002000,0x00000000},0x0023,&ucs_strings[1288]},
	{{0x00080000,0x00000000,0x00000000},0x002e,&ucs_strings[1288]},
	{{0x00000001,0x00010000,0x00000000},0x0031,&ucs_strings[1288]},
	{{0x00008000,0x00000000,0x00000000},0x005e,&ucs_strings[1288]},
	{{0x00000000,0x02000000,0x00000000},0x007e,&ucs_strings[1288]},
	{{0x00040000,0x00000000,0x00000000},0x00a8,&ucs_strings[1288]},
	{{0x00000000,0x00000400,0x00000000},0x00af,&ucs_strings[1288]},
	{{0x00002000,0x00000000,0x00000000},0x00b8,&ucs_strings[1288]},
	{{0x02000000,0x00000000,0x00000002},0x002e,&ucs_strings[1288]},
	{{0x00000000,0x40000200,0x00000000},0x007c,&ucs_strings[1288]},
	{{0x00080000,0x00000000,0x01000000},0x00b7,&ucs_strings[1288]},
	{{0x00000000,0x00010000,0x00000020},0x00b9,&ucs_strings[1288]},
	{{0x00000000,0x00400000,0x00020080},0x005d,&ucs_strings[1288]},
	{{0x00000000,0x00010000,0x00080018},0x00bd,&ucs_strings[1288]},
	{{0x00000000,0x00000000,0x00000000},0x007d,&ucs_strings[1678]},
	{{0x00000000,0x00000000,0x00000000},0x00a6,&ucs_strings[2550]},
	{{0x00000000,0x00000000,0x00000000},0x00a2,&ucs_strings[2499]},
	{{0x00000000,0x00000000,0x00000000},0x00a1,&ucs_strings[2488]},
	{{0x00000000,0x00000000,0x00000000},0x0024,&ucs_strings[1330]},
	{{0x00000000,0x00000000,0x00000000},0x0060,&ucs_strings[1656]},
	{{0x00000000,0x00000000,0x00000000},0x00b8,&ucs_strings[2736]},
	{{0x00000000,0x00000000,0x00000000},0x00a8,&ucs_strings[2564]},
	{{0x00000000,0x00000000,0x00000000},0x005e,&ucs_strings[1638]},
	{{0x00000000,0x00000000,0x00000000},0x007e,&ucs_strings[1681]},
	{{0x00000000,0x00000000,0x00000000},0x00af,&ucs_strings[2677]},
	{{0x00000000,0x00000000,0x00000000},0x007b,&ucs_strings[1671]},
	{{0x00000000,0x00000000,0x00000000},0x005d,&ucs_strings[1624]},
	{{0x00000000,0x00000000,0x00000000},0x00d7,&ucs_strings[2899]},
	{{0x00000000,0x00000000,0x00000000},0x00b1,&ucs_strings[2701]},
	{{0x00000000,0x00000000,0x00000000},0x00ad,&ucs_strings[2660]},
	{{0x00000000,0x00000000,0x00000000},0x00f7,&ucs_strings[2949]},
	{{0x00000000,0x00000000,0x00000000},0x00aa,&ucs_strings[2607]},
	{{0x00000000,0x00000000,0x00000000},0x00ba,&ucs_strings[2770]},
	{{0x00000000,0x00000000,0x00000000},0x00b7,&ucs_strings[2733]},
	{{0x00000000,0x00000000,0x00000000},0x00bd,&ucs_strings[2787]},
	{{0x00000000,0x00000000,0x00000000},0x00bc,&ucs_strings[2784]},
	{{0x00000000,0x00000000,0x00000000},0x00b9,&ucs_strings[2739]},
	{{0x00000000,0x00000000,0x00000000},0x00b2,&ucs_strings[2704]},
	{{0x00000000,0x00000000,0x00000000},0x00be,&ucs_strings[2805]},
	{{0x00000000,0x00000000,0x00000000},0x00b3,&ucs_strings[2707]},
	{{0x00000000,0x00000000,0x00000000},0x00ac,&ucs_strings[2645]},
	{{0x00000000,0x00000000,0x00000000},0x00b6,&ucs_strings[2730]},
	{{0x00000000,0x00000000,0x00000000},0x00ab,&ucs_strings[2635]},
	{{0x00000000,0x00000000,0x00000000},0x00bb,&ucs_strings[2773]},
	{{0x00000000,0x00000000,0x00000000},0x00bf,&ucs_strings[2808]},
	{{0x00000003,0x00000040,0x00000000},0x0041,&ucs_strings[1546]},
	{{0x00000005,0x00000040,0x00000000},0x0061,&ucs_strings[1546]},
	{{0x04000003,0x00000040,0x00000000},0x00c0,&ucs_strings[1546]},
	{{0x00000013,0x00000040,0x00000000},0x00c1,&ucs_strings[1546]},
	{{0x00008003,0x00000040,0x00000000},0x00c2,&ucs_strings[1546]},
	{{0x00000003,0x02000040,0x00000000},0x00c3,&ucs_strings[1546]},
	{{0x00040003,0x00000040,0x00000000},0x00c4,&ucs_strings[1546]},
	{{0x04000005,0x00000040,0x00000000},0x00e0,&ucs_strings[1546]},
	{{0x00000015,0x00000040,0x00000000},0x00e1,&ucs_strings[1546]},
	{{0x00008005,0x00000040,0x00000000},0x00e2,&ucs_strings[1546]},
	{{0x00000005,0x02000040,0x00000000},0x00e3,&ucs_strings[1546]},
	{{0x00040005,0x00000040,0x00000000},0x00e4,&ucs_strings[1546]},
	{{0x0000000b,0x00000040,0x04000000},0x00c5,&ucs_strings[1546]},
	{{0x0000000d,0x00000040,0x04000000},0x00e5,&ucs_strings[1546]},
	{{0x00000000,0x00000000,0x00000000},0x00c0,&ucs_strings[2811]},
	{{0x00000000,0x00000000,0x00000000},0x00e0,&ucs_strings[2811]},
	{{0x00000000,0x00000000,0x00000000},0x00c1,&ucs_strings[2814]},
	{{0x00000000,0x00000000,0x00000000},0x00e1,&ucs_strings[2814]},
	{{0x00000000,0x00000000,0x00000000},0x00c4,&ucs_strings[2823]},
	{{0x00000000,0x00000000,0x00000000},0x00e4,&ucs_strings[2823]},
	{{0x00000000,0x00000000,0x00000000},0x00c2,&ucs_strings[2817]},
	{{0x00000000,0x00000000,0x00000000},0x00e2,&ucs_strings[2817]},
	{{0x00000000,0x00000000,0x00000000},0x00c3,&ucs_strings[2820]},
	{{0x00000000,0x00000000,0x00000000},0x00e3,&ucs_strings[2820]},
	{{0x00000000,0x00000000,0x00000000},0x00c5,&ucs_strings[2826]},
	{{0x00000000,0x00000000,0x00000000},0x00e5,&ucs_strings[2826]},
	{{0x00000000,0x00000000,0x00000000},0x009f,&ucs_strings[2469]},
	{{0x00008000,0x00000000,0x00000000},0x005e,&ucs_strings[1627]},
	{{0x04000000,0x00000000,0x00000000},0x0060,&ucs_strings[1627]},
	{{0x00000010,0x00000000,0x00000000},0x00b4,&ucs_strings[1627]},
	{{0x00000000,0x00000000,0x00000000},0x0006,&ucs_strings[808]},
	{{0x00000000,0x00000000,0x00000000},0x0006,&ucs_strings[796]},
	{{0x00000000,0x00000000,0x00000000},0x00c6,&ucs_strings[2829]},
	{{0x00000000,0x00000000,0x00000000},0x00e6,&ucs_strings[2829]},
	{{0x00000003,0x00000040,0x00000000},0x00c6,&ucs_strings[2829]},
	{{0x00000005,0x00000040,0x00000000},0x00e6,&ucs_strings[2829]},
	{{0x00000000,0x00000000,0x00000000},0x0006,&ucs_strings[812]},
	{{0x00000000,0x00000000,0x00000000},0x0007,&ucs_strings[827]},
	{{0x00000000,0x00000000,0x00000000},0x0026,&ucs_strings[1341]},
	{{0x00000000,0x00000000,0x00000000},0x009f,&ucs_strings[2472]},
	{{0x00000000,0x00000000,0x00000000},0x0027,&ucs_strings[1351]},
	{{0x00000000,0x00000000,0x00000000},0x009f,&ucs_strings[2441]},
	{{0x00000000,0x00000000,0x00000000},0x002a,&ucs_strings[1374]},
	{{0x00000000,0x00000000,0x00000000},0x0040,&ucs_strings[1540]},
	{{0x00000003,0x00000040,0x00000000},0x0042,&ucs_strings[1548]},
	{{0x00000005,0x00000040,0x00000000},0x0062,&ucs_strings[1548]},
	{{0x00000000,0x00000000,0x00000000},0x005c,&ucs_strings[1614]},
	{{0x00000000,0x00000000,0x00000000},0x0008,&ucs_strings[833]},
	{{0x00000000,0x00000000,0x00000000},0x007c,&ucs_strings[1674]},
	{{0x00000000,0x00000000,0x00000000},0x00a6,&ucs_strings[2547]},
	{{0x00000000,0x00000000,0x00000000},0x0007,&ucs_strings[820]},
	{{0x00000000,0x00000000,0x00000000},0x0007,&ucs_strings[815]},
	{{0x00000000,0x00000000,0x00000000},0x0082,&ucs_strings[1770]},
	{{0x00000000,0x00000000,0x00000000},0x0007,&ucs_strings[824]},
	{{0x00000000,0x00000000,0x00000000},0x0082,&ucs_strings[1773]},
	{{0x00000000,0x00000080,0x00000000},0x007b,&ucs_strings[1665]},
	{{0x00000000,0x00400000,0x00000000},0x007d,&ucs_strings[1665]},
	{{0x00000000,0x00000000,0x00000000},0x0082,&ucs_strings[1749]},
	{{0x00000000,0x00000000,0x00000000},0x00a6,&ucs_strings[2536]},
	{{0x00000000,0x00000000,0x00000000},0x0008,&ucs_strings[843]},
	{{0x00000003,0x00000040,0x00000000},0x0043,&ucs_strings[1550]},
	{{0x00000005,0x00000040,0x00000000},0x0063,&ucs_strings[1550]},
	{{0x00002003,0x00000040,0x00000000},0x00c7,&ucs_strings[1550]},
	{{0x00002005,0x00000040,0x00000000},0x00e7,&ucs_strings[1550]},
	{{0x00000000,0x00000000,0x00000000},0x00c7,&ucs_strings[2832]},
	{{0x00000000,0x00000000,0x00000000},0x00e7,&ucs_strings[2832]},
	{{0x00000000,0x00000000,0x00000000},0x0018,&ucs_strings[1142]},
	{{0x00000000,0x00000000,0x00000000},0x0018,&ucs_strings[1135]},
	{{0x00000000,0x00000000,0x00000000},0x0094,&ucs_strings[2163]},
	{{0x00000000,0x00000000,0x00000000},0x000d,&ucs_strings[886]},
	{{0x00000000,0x00000000,0x00000000},0x0094,&ucs_strings[2180]},
	{{0x00000000,0x00000000,0x00000000},0x0094,&ucs_strings[2183]},
	{{0x00000001,0x00000000,0x00000000},0x00a2,&ucs_strings[2491]},
	{{0x00000000,0x01000000,0x00000000},0x009a,&ucs_strings[2306]},
	{{0x00000001,0x00000000,0x00000000},0x0089,&ucs_strings[1903]},
	{{0x00000000,0x00000000,0x00000000},0x0088,&ucs_strings[1871]},
	{{0x00000000,0x00000000,0x00000000},0x009b,&ucs_strings[2362]},
	{{0x00000000,0x00000000,0x00000000},0x0018,&ucs_strings[1146]},
	{{0x00000000,0x00000000,0x00000000},0x00a9,&ucs_strings[2577]},
	{{0x00000000,0x00000000,0x00000000},0x003a,&ucs_strings[1481]},
	{{0x00000000,0x00000000,0x00000000},0x002c,&ucs_strings[1388]},
	{{0x00000000,0x00000000,0x00000000},0x0040,&ucs_strings[1526]},
	{{0x00000000,0x00000000,0x00000000},0x009b,&ucs_strings[2334]},
	{{0x00000001,0x00000000,0x00000000},0x00a9,&ucs_strings[2567]},
	{{0x00000000,0x00000000,0x00000000},0x000d,&ucs_strings[902]},
	{{0x00000000,0x00000000,0x00000000},0x009b,&ucs_strings[2365]},
	{{0x00000000,0x00000000,0x00000000},0x00a2,&ucs_strings[2496]},
	{{0x00000000,0x00000000,0x00000000},0x00a4,&ucs_strings[2520]},
	{{0x00000000,0x00000080,0x00020000},0x007b,&ucs_strings[1659]},
	{{0x00000000,0x00400000,0x00020000},0x007d,&ucs_strings[1659]},
	{{0x00000001,0x00000000,0x00000000},0x00a4,&ucs_strings[2511]},
	{{0x00000003,0x00000040,0x00000000},0x0044,&ucs_strings[1552]},
	{{0x00000005,0x00000040,0x00000000},0x0064,&ucs_strings[1552]},
	{{0x00000000,0x00000000,0x00000000},0x00d0,&ucs_strings[2863]},
	{{0x00000000,0x00000000,0x00000000},0x00f0,&ucs_strings[2863]},
	{{0x00000000,0x00000000,0x00000000},0x0011,&ucs_strings[969]},
	{{0x00000000,0x00000000,0x00000000},0x0012,&ucs_strings[995]},
	{{0x00000000,0x00000000,0x00000000},0x0013,&ucs_strings[1023]},
	{{0x00000000,0x00000000,0x00000000},0x0014,&ucs_strings[1050]},
	{{0x00000000,0x00000000,0x00000000},0x0010,&ucs_strings[930]},
	{{0x00000000,0x00000000,0x00000000},0x0090,&ucs_strings[2088]},
	{{0x00000000,0x00000000,0x00000000},0x0011,&ucs_strings[972]},
	{{0x00000000,0x00000000,0x00000000},0x0012,&ucs_strings[998]},
	{{0x00000000,0x00000000,0x00000000},0x0013,&ucs_strings[1026]},
	{{0x00000000,0x00000000,0x00000000},0x0014,&ucs_strings[1053]},
	{{0x00000000,0x00000000,0x00000000},0x0090,&ucs_strings[2091]},
	{{0x00000001,0x00000000,0x00000000},0x00b0,&ucs_strings[2680]},
	{{0x00000000,0x00000000,0x00000000},0x007f,&ucs_strings[1692]},
	{{0x00000000,0x00000000,0x00000000},0x007f,&ucs_strings[1685]},
	{{0x00000000,0x00010000,0x00000000},0x0011,&ucs_strings[954]},
	{{0x00000000,0x00000000,0x00000000},0x0014,&ucs_strings[1030]},
	{{0x00000000,0x00000000,0x00000000},0x0090,&ucs_strings[2066]},
	{{0x00000000,0x00000000,0x00000000},0x0013,&ucs_strings[1002]},
	{{0x00000000,0x00000000,0x00000000},0x0012,&ucs_strings[976]},
	{{0x00000000,0x00000000,0x00000000},0x00b0,&ucs_strings[2687]},
	{{0x00000001,0x00000000,0x00000000},0x00f7,&ucs_strings[2940]},
	{{0x00000000,0x00000000,0x00000000},0x0010,&ucs_strings[947]},
	{{0x00000000,0x00000000,0x00000000},0x0010,&ucs_strings[950]},
	{{0x00000000,0x00000000,0x00000000},0x0024,&ucs_strings[1327]},
	{{0x00000001,0x00000000,0x00000000},0x0024,&ucs_strings[1320]},
	{{0x00000000,0x00000000,0x00000000},0x007f,&ucs_strings[1696]},
	{{0x00000003,0x00000040,0x00000000},0x0045,&ucs_strings[1554]},
	{{0x00000005,0x00000040,0x00000000},0x0065,&ucs_strings[1554]},
	{{0x04000003,0x00000040,0x00000000},0x00c8,&ucs_strings[1554]},
	{{0x00000013,0x00000040,0x00000000},0x00c9,&ucs_strings[1554]},
	{{0x00008003,0x00000040,0x00000000},0x00ca,&ucs_strings[1554]},
	{{0x00040003,0x00000040,0x00000000},0x00cb,&ucs_strings[1554]},
	{{0x04000005,0x00000040,0x00000000},0x00e8,&ucs_strings[1554]},
	{{0x00000015,0x00000040,0x00000000},0x00e9,&ucs_strings[1554]},
	{{0x00008005,0x00000040,0x00000000},0x00ea,&ucs_strings[1554]},
	{{0x00040005,0x00000040,0x00000000},0x00eb,&ucs_strings[1554]},
	{{0x00000000,0x00000000,0x00000000},0x00c8,&ucs_strings[2835]},
	{{0x00000000,0x00000000,0x00000000},0x00e8,&ucs_strings[2835]},
	{{0x00000000,0x00000000,0x00000000},0x00c9,&ucs_strings[2838]},
	{{0x00000000,0x00000000,0x00000000},0x00e9,&ucs_strings[2838]},
	{{0x00000000,0x00000000,0x00000000},0x00cb,&ucs_strings[2844]},
	{{0x00000000,0x00000000,0x00000000},0x00eb,&ucs_strings[2844]},
	{{0x00000000,0x00000000,0x00000000},0x00ca,&ucs_strings[2841]},
	{{0x00000000,0x00000000,0x00000000},0x00ea,&ucs_strings[2841]},
	{{0x00000000,0x00000000,0x00000000},0x0017,&ucs_strings[1128]},
	{{0x00000000,0x00000000,0x00000000},0x001b,&ucs_strings[1184]},
	{{0x00000000,0x00000000,0x00000000},0x0097,&ucs_strings[2245]},
	{{0x00000001,0x00000000,0x00000000},0x0038,&ucs_strings[1470]},
	{{0x00000000,0x00000000,0x00000000},0x0019,&ucs_strings[1156]},
	{{0x00000000,0x00000000,0x00000000},0x0005,&ucs_strings[789]},
	{{0x00000000,0x00000000,0x00000000},0x0005,&ucs_strings[781]},
	{{0x00000000,0x00000000,0x00000000},0x0004,&ucs_strings[774]},
	{{0x00000000,0x00000000,0x00000000},0x0097,&ucs_strings[2248]},
	{{0x00000000,0x00000000,0x00000000},0x0005,&ucs_strings[793]},
	{{0x00000001,0x00000000,0x00000000},0x003d,&ucs_strings[1502]},
	{{0x00000000,0x00000000,0x00000000},0x0087,&ucs_strings[1864]},
	{{0x00000000,0x00000000,0x00000000},0x0087,&ucs_strings[1867]},
	{{0x00000000,0x00000000,0x00000000},0x001b,&ucs_strings[1187]},
	{{0x00000000,0x00000000,0x00000000},0x001b,&ucs_strings[1177]},
	{{0x00000000,0x00000000,0x00000000},0x0004,&ucs_strings[778]},
	{{0x00000000,0x00000000,0x00000000},0x0017,&ucs_strings[1131]},
	{{0x00000003,0x00000040,0x00000000},0x00d0,&ucs_strings[2859]},
	{{0x00000005,0x00000040,0x00000000},0x00f0,&ucs_strings[2859]},
	{{0x00000000,0x00000000,0x00000000},0x0003,&ucs_strings[754]},
	{{0x00000000,0x00000000,0x00000000},0x0003,&ucs_strings[758]},
	{{0x00000000,0x00000800,0x00000000},0x0021,&ucs_strings[1292]},
	{{0x00000000,0x00000800,0x00800000},0x00a1,&ucs_strings[1292]},
	{{0x00000003,0x00000040,0x00000000},0x0046,&ucs_strings[1556]},
	{{0x00000005,0x00000040,0x00000000},0x0066,&ucs_strings[1556]},
	{{0x00000001,0x00000000,0x00000000},0x000c,&ucs_strings[864]},
	{{0x00000000,0x00000200,0x00000000},0x000a,&ucs_strings[864]},
	{{0x00000000,0x00000000,0x00000000},0x00aa,&ucs_strings[2580]},
	{{0x00000000,0x00000000,0x00000000},0x000c,&ucs_strings[883]},
	{{0x00000000,0x00000000,0x00000000},0x001c,&ucs_strings[1191]},
	{{0x00000001,0x00000000,0x00000000},0x0035,&ucs_strings[1455]},
	{{0x00000001,0x00000000,0x00000000},0x0034,&ucs_strings[1450]},
	{{0x00000000,0x00000000,0x00000000},0x001c,&ucs_strings[1206]},
	{{0x00000003,0x00000040,0x00000000},0x0047,&ucs_strings[1558]},
	{{0x00000005,0x00000040,0x00000000},0x0067,&ucs_strings[1558]},
	{{0x00000000,0x00000000,0x00000000},0x0099,&ucs_strings[2298]},
	{{0x00000000,0x01000000,0x00000000},0x0099,&ucs_strings[2269]},
	{{0x00000001,0x00000000,0x00004000},0x003e,&ucs_strings[1509]},
	{{0x00000000,0x00000000,0x00000000},0x001d,&ucs_strings[1213]},
	{{0x00000000,0x00000000,0x00000000},0x001d,&ucs_strings[1229]},
	{{0x00000000,0x00000000,0x00100001},0x0097,&ucs_strings[2232]},
	{{0x00000003,0x00000040,0x00000000},0x0048,&ucs_strings[1560]},
	{{0x00000005,0x00000040,0x00000000},0x0068,&ucs_strings[1560]},
	{{0x00000000,0x00000000,0x00000000},0x0023,&ucs_strings[1317]},
	{{0x00000000,0x00000000,0x00000000},0x005e,&ucs_strings[1634]},
	{{0x00000000,0x00000000,0x00000000},0x0081,&ucs_strings[1724]},
	{{0x00000000,0x00000000,0x00000000},0x0089,&ucs_strings[1938]},
	{{0x00000000,0x00000000,0x00000000},0x0081,&ucs_strings[1742]},
	{{0x00000000,0x00000000,0x00000000},0x0081,&ucs_strings[1745]},
	{{0x00000000,0x00000000,0x00000000},0x0088,&ucs_strings[1896]},
	{{0x00000000,0x00000000,0x00000000},0x0009,&ucs_strings[861]},
	{{0x00000000,0x00000000,0x00000000},0x0089,&ucs_strings[1941]},
	{{0x00000000,0x00000000,0x00000000},0x0088,&ucs_strings[1899]},
	{{0x00000000,0x00000000,0x00000000},0x002d,&ucs_strings[1407]},
	{{0x00000000,0x00000000,0x00000000},0x002d,&ucs_strings[1394]},
	{{0x00000003,0x00000040,0x00000000},0x0049,&ucs_strings[1562]},
	{{0x00000005,0x00000040,0x00000000},0x0069,&ucs_strings[1562]},
	{{0x04000003,0x00000040,0x00000000},0x00cc,&ucs_strings[1562]},
	{{0x00000013,0x00000040,0x00000000},0x00cd,&ucs_strings[1562]},
	{{0x00008003,0x00000040,0x00000000},0x00ce,&ucs_strings[1562]},
	{{0x00040003,0x00000040,0x00000000},0x00cf,&ucs_strings[1562]},
	{{0x04000005,0x00000040,0x00000000},0x00ec,&ucs_strings[1562]},
	{{0x00000015,0x00000040,0x00000000},0x00ed,&ucs_strings[1562]},
	{{0x00008005,0x00000040,0x00000000},0x00ee,&ucs_strings[1562]},
	{{0x00040005,0x00000040,0x00000000},0x00ef,&ucs_strings[1562]},
	{{0x00000000,0x00000000,0x00000000},0x00cc,&ucs_strings[2847]},
	{{0x00000000,0x00000000,0x00000000},0x00ec,&ucs_strings[2847]},
	{{0x00000000,0x00000000,0x00000000},0x00cd,&ucs_strings[2850]},
	{{0x00000000,0x00000000,0x00000000},0x00ed,&ucs_strings[2850]},
	{{0x00000000,0x00000000,0x00000000},0x00cf,&ucs_strings[2856]},
	{{0x00000000,0x00000000,0x00000000},0x00ef,&ucs_strings[2856]},
	{{0x00000000,0x00000000,0x00000000},0x00ce,&ucs_strings[2853]},
	{{0x00000000,0x00000000,0x00000000},0x00ee,&ucs_strings[2853]},
	{{0x00000000,0x00000000,0x00000000},0x0084,&ucs_strings[1804]},
	{{0x00000000,0x00000000,0x00000000},0x0084,&ucs_strings[1807]},
	{{0x00000000,0x00000000,0x00000000},0x0084,&ucs_strings[1798]},
	{{0x00000000,0x00000000,0x00000000},0x001d,&ucs_strings[1236]},
	{{0x00000000,0x00000000,0x00000000},0x001f,&ucs_strings[1281]},
	{{0x00000000,0x00000000,0x00000000},0x001e,&ucs_strings[1259]},
	{{0x00000000,0x00000000,0x00000000},0x001d,&ucs_strings[1232]},
	{{0x00000000,0x00000000,0x00000000},0x001c,&ucs_strings[1209]},
	{{0x00000003,0x00000040,0x00000000},0x004a,&ucs_strings[1564]},
	{{0x00000005,0x00000040,0x00000000},0x006a,&ucs_strings[1564]},
	{{0x00000003,0x00000040,0x00000000},0x004b,&ucs_strings[1566]},
	{{0x00000005,0x00000040,0x00000000},0x006b,&ucs_strings[1566]},
	{{0x00000003,0x00000040,0x00000000},0x004c,&ucs_strings[1568]},
	{{0x00000005,0x00000040,0x00000000},0x006c,&ucs_strings[1568]},
	{{0x00000000,0x00000000,0x00000000},0x00a3,&ucs_strings[2508]},
	{{0x00000001,0x00000000,0x00004000},0x003c,&ucs_strings[1497]},
	{{0x00000000,0x00000000,0x00000000},0x000a,&ucs_strings[869]},
	{{0x00000000,0x00000200,0x00000000},0x005f,&ucs_strings[1641]},
	{{0x00000003,0x00000040,0x00000000},0x004d,&ucs_strings[1570]},
	{{0x00000005,0x00000040,0x00000000},0x006d,&ucs_strings[1570]},
	{{0x00000000,0x00000000,0x00000000},0x00ba,&ucs_strings[2742]},
	{{0x00000000,0x00000000,0x00100001},0x0019,&ucs_strings[1149]},
	{{0x00000000,0x00000000,0x00000000},0x0095,&ucs_strings[2187]},
	{{0x00000001,0x00000000,0x00000000},0x00b5,&ucs_strings[2710]},
	{{0x00000001,0x00000000,0x00000000},0x00d7,&ucs_strings[2884]},
	{{0x00000000,0x00000000,0x00000000},0x0095,&ucs_strings[2203]},
	{{0x00000000,0x00000000,0x00000000},0x00b5,&ucs_strings[2716]},
	{{0x00000003,0x00000040,0x00000000},0x004e,&ucs_strings[1572]},
	{{0x00000005,0x00000040,0x00000000},0x006e,&ucs_strings[1572]},
	{{0x00000003,0x02000040,0x00000000},0x00d1,&ucs_strings[1572]},
	{{0x00000005,0x02000040,0x00000000},0x00f1,&ucs_strings[1572]},
	{{0x00000000,0x00000000,0x00000000},0x00d1,&ucs_strings[2866]},
	{{0x00000000,0x00000000,0x00000000},0x00f1,&ucs_strings[2866]},
	{{0x00000000,0x00000000,0x00000000},0x0015,&ucs_strings[1078]},
	{{0x00000000,0x00000000,0x00000000},0x0023,&ucs_strings[1314]},
	{{0x00000000,0x00000000,0x00000000},0x0083,&ucs_strings[1794]},
	{{0x00000000,0x00000000,0x00000000},0x0015,&ucs_strings[1057]},
	{{0x00000000,0x00000000,0x00000000},0x0085,&ucs_strings[1819]},
	{{0x00000000,0x00000000,0x00000000},0x000a,&ucs_strings[872]},
	{{0x00000000,0x00000200,0x00000000},0x0085,&ucs_strings[1811]},
	{{0x00000000,0x00000000,0x00000000},0x0083,&ucs_strings[1791]},
	{{0x00000001,0x00000000,0x00000000},0x0039,&ucs_strings[1476]},
	{{0x00000000,0x00000000,0x00000000},0x0015,&ucs_strings[1082]},
	{{0x00000000,0x00000000,0x00000000},0x0085,&ucs_strings[1816]},
	{{0x00000000,0x00000000,0x00000000},0x00ac,&ucs_strings[2642]},
	{{0x00000000,0x00000000,0x00000200},0x00a0,&ucs_strings[2476]},
	{{0x00000000,0x00000000,0x00000000},0x0083,&ucs_strings[1777]},
	{{0x00000001,0x00000000,0x00000000},0x00ac,&ucs_strings[2638]},
	{{0x00000000,0x00000000,0x00000000},0x00a0,&ucs_strings[2485]},
	{{0x00000000,0x00000000,0x00000000},0x0000,&ucs_strings[707]},
	{{0x00000000,0x00000000,0x00000000},0x0000,&ucs_strings[703]},
	{{0x00000000,0x00000000,0x00000000},0x0000,&ucs_strings[698]},
	{{0x00000003,0x00000040,0x00000000},0x004f,&ucs_strings[1574]},
	{{0x00000005,0x00000040,0x00000000},0x006f,&ucs_strings[1574]},
	{{0x04000003,0x00000040,0x00000000},0x00d2,&ucs_strings[1574]},
	{{0x00000013,0x00000040,0x00000000},0x00d3,&ucs_strings[1574]},
	{{0x00008003,0x00000040,0x00000000},0x00d4,&ucs_strings[1574]},
	{{0x00000003,0x02000040,0x00000000},0x00d5,&ucs_strings[1574]},
	{{0x00040003,0x00000040,0x00000000},0x00d6,&ucs_strings[1574]},
	{{0x00000003,0x00000040,0x10000000},0x00d8,&ucs_strings[1574]},
	{{0x04000005,0x00000040,0x00000000},0x00f2,&ucs_strings[1574]},
	{{0x00000015,0x00000040,0x00000000},0x00f3,&ucs_strings[1574]},
	{{0x00008005,0x00000040,0x00000000},0x00f4,&ucs_strings[1574]},
	{{0x00000005,0x02000040,0x00000000},0x00f5,&ucs_strings[1574]},
	{{0x00040005,0x00000040,0x00000000},0x00f6,&ucs_strings[1574]},
	{{0x00000005,0x00000040,0x10000000},0x00f8,&ucs_strings[1574]},
	{{0x00000000,0x00000000,0x00000000},0x00d2,&ucs_strings[2869]},
	{{0x00000000,0x00000000,0x00000000},0x00f2,&ucs_strings[2869]},
	{{0x00000000,0x00000000,0x00000000},0x00d3,&ucs_strings[2872]},
	{{0x00000000,0x00000000,0x00000000},0x00f3,&ucs_strings[2872]},
	{{0x00000000,0x00000000,0x00000000},0x00d8,&ucs_strings[2902]},
	{{0x00000000,0x00000000,0x00000000},0x00f8,&ucs_strings[2902]},
	{{0x00000000,0x00000000,0x00000000},0x00d6,&ucs_strings[2881]},
	{{0x00000000,0x00000000,0x00000000},0x00f6,&ucs_strings[2881]},
	{{0x00000000,0x00000000,0x00000000},0x00d4,&ucs_strings[2875]},
	{{0x00000000,0x00000000,0x00000000},0x00f4,&ucs_strings[2875]},
	{{0x00000000,0x00000000,0x00000000},0x00d5,&ucs_strings[2878]},
	{{0x00000000,0x00000000,0x00000000},0x00f5,&ucs_strings[2878]},
	{{0x00000000,0x00000000,0x00000000},0x0040,&ucs_strings[1543]},
	{{0x00000000,0x00000000,0x00000000},0x009d,&ucs_strings[2415]},
	{{0x00000000,0x00000000,0x00000000},0x009d,&ucs_strings[2390]},
	{{0x00000000,0x00000000,0x00000000},0x009d,&ucs_strings[2418]},
	{{0x00000003,0x00000040,0x00000000},0x0050,&ucs_strings[1576]},
	{{0x00000005,0x00000040,0x00000000},0x0070,&ucs_strings[1576]},
	{{0x00000000,0x00000000,0x00000000},0x0091,&ucs_strings[2107]},
	{{0x00000000,0x00000000,0x00000000},0x0092,&ucs_strings[2130]},
	{{0x00000000,0x00000000,0x00000000},0x0080,&ucs_strings[1717]},
	{{0x00000000,0x00000000,0x00000000},0x0080,&ucs_strings[1720]},
	{{0x00000000,0x00000000,0x00000000},0x0080,&ucs_strings[1699]},
	{{0x00000000,0x00000080,0x00000000},0x0028,&ucs_strings[1362]},
	{{0x00000000,0x00400000,0x00000000},0x0029,&ucs_strings[1362]},
	{{0x00000000,0x00000200,0x00000000},0x008c,&ucs_strings[1990]},
	{{0x00000000,0x00000200,0x00000000},0x008b,&ucs_strings[1967]},
	{{0x00000000,0x00000000,0x00000000},0x008b,&ucs_strings[1983]},
	{{0x00000000,0x00000000,0x00000000},0x00a3,&ucs_strings[1983]},
	{{0x00000001,0x00000000,0x00000000},0x0025,&ucs_strings[1333]},
	{{0x00000000,0x00000000,0x00000000},0x002e,&ucs_strings[1414]},
	{{0x00000000,0x00000000,0x00000000},0x00b6,&ucs_strings[2727]},
	{{0x00000001,0x00000000,0x00000000},0x00b6,&ucs_strings[2719]},
	{{0x00000000,0x00000000,0x00000000},0x008b,&ucs_strings[1986]},
	{{0x00000000,0x00000000,0x00000000},0x008c,&ucs_strings[2010]},
	{{0x00000001,0x00000000,0x00000000},0x002b,&ucs_strings[1383]},
	{{0x00000001,0x00000000,0x00000000},0x00b1,&ucs_strings[2690]},
	{{0x00000000,0x00000000,0x00000000},0x009e,&ucs_strings[2438]},
	{{0x00100000,0x00000880,0x00000000},0x00ab,&ucs_strings[2610]},
	{{0x00100000,0x00400800,0x00000000},0x00bb,&ucs_strings[2610]},
	{{0x00000001,0x00000000,0x00000000},0x00a3,&ucs_strings[2502]},
	{{0x00000000,0x00000000,0x00000000},0x009e,&ucs_strings[2422]},
	{{0x00000000,0x00010000,0x00000000},0x0091,&ucs_strings[2095]},
	{{0x00000000,0x00000000,0x00000000},0x0092,&ucs_strings[2114]},
	{{0x00000000,0x00000000,0x00000000},0x008c,&ucs_strings[2007]},
	{{0x00000000,0x00000000,0x00000000},0x0091,&ucs_strings[2110]},
	{{0x00000000,0x00000000,0x00000000},0x0092,&ucs_strings[2133]},
	{{0x00000003,0x00000040,0x00000000},0x0051,&ucs_strings[1578]},
	{{0x00000005,0x00000040,0x00000000},0x0071,&ucs_strings[1578]},
	{{0x00000000,0x00010000,0x00000018},0x00bc,&ucs_strings[2776]},
	{{0x00000000,0x00000800,0x00000000},0x003f,&ucs_strings[1517]},
	{{0x00000000,0x00000800,0x00800000},0x00bf,&ucs_strings[1517]},
	{{0x00000000,0x00000800,0x00000000},0x0022,&ucs_strings[1304]},
	{{0x00000003,0x00000040,0x00000000},0x0052,&ucs_strings[1580]},
	{{0x00000005,0x00000040,0x00000000},0x0072,&ucs_strings[1580]},
	{{0x00000000,0x00000000,0x00000000},0x001e,&ucs_strings[1242]},
	{{0x00000001,0x00000000,0x00000000},0x00ae,&ucs_strings[2663]},
	{{0x00000000,0x00000200,0x00000000},0x008d,&ucs_strings[2014]},
	{{0x00000000,0x00000000,0x00000000},0x005c,&ucs_strings[1598]},
	{{0x00000000,0x00000000,0x00000000},0x00ae,&ucs_strings[2674]},
	{{0x00000000,0x00000000,0x00000000},0x008d,&ucs_strings[2027]},
	{{0x00000000,0x00000000,0x00000000},0x001e,&ucs_strings[1263]},
	{{0x00000003,0x00000040,0x00000000},0x0053,&ucs_strings[1582]},
	{{0x00000005,0x00000040,0x00000000},0x0073,&ucs_strings[1582]},
	{{0x00000000,0x00000000,0x00000000},0x008e,&ucs_strings[2040]},
	{{0x00000000,0x00000000,0x00000000},0x008f,&ucs_strings[2059]},
	{{0x00000000,0x00000000,0x00000000},0x0086,&ucs_strings[1843]},
	{{0x00000000,0x00000000,0x00000000},0x001a,&ucs_strings[1170]},
	{{0x00000000,0x00000000,0x00000000},0x009a,&ucs_strings[2327]},
	{{0x00000000,0x00000000,0x00000000},0x009a,&ucs_strings[2330]},
	{{0x00000000,0x00000000,0x00000000},0x00a7,&ucs_strings[2561]},
	{{0x00000001,0x00000000,0x00000000},0x00a7,&ucs_strings[2553]},
	{{0x00000000,0x00000000,0x00100001},0x0087,&ucs_strings[1850]},
	{{0x00000000,0x00000000,0x00000000},0x003b,&ucs_strings[1487]},
	{{0x00000000,0x00000000,0x00000000},0x0093,&ucs_strings[2137]},
	{{0x00000001,0x00000000,0x00000000},0x0037,&ucs_strings[1464]},
	{{0x00000000,0x00000000,0x00000000},0x0096,&ucs_strings[2225]},
	{{0x00000000,0x00000000,0x00000000},0x0099,&ucs_strings[2301]},
	{{0x00000000,0x00000000,0x00000000},0x0001,&ucs_strings[728]},
	{{0x00000005,0x00000040,0x00000000},0x00df,&ucs_strings[2929]},
	{{0x00000000,0x00000000,0x00000000},0x000f,&ucs_strings[918]},
	{{0x00000000,0x00000000,0x00000000},0x000e,&ucs_strings[905]},
	{{0x00000000,0x01000000,0x00000000},0x008f,&ucs_strings[2047]},
	{{0x00000000,0x01000000,0x00000000},0x008e,&ucs_strings[2030]},
	{{0x00000000,0x00000000,0x00000000},0x000f,&ucs_strings[927]},
	{{0x00000001,0x00000000,0x00000000},0x0036,&ucs_strings[1460]},
	{{0x00000000,0x00000000,0x00000000},0x002f,&ucs_strings[1429]},
	{{0x00000000,0x00000000,0x00000000},0x000e,&ucs_strings[915]},
	{{0x00000000,0x00000000,0x00000000},0x00ad,&ucs_strings[2648]},
	{{0x00000000,0x00000000,0x00000000},0x0001,&ucs_strings[724]},
	{{0x00000000,0x00000000,0x00000000},0x002f,&ucs_strings[1421]},
	{{0x00000000,0x00000000,0x00000000},0x0098,&ucs_strings[2265]},
	{{0x00000000,0x00000000,0x00000000},0x0020,&ucs_strings[1289]},
	{{0x00000000,0x00000000,0x00000000},0x0096,&ucs_strings[2228]},
	{{0x00000000,0x00000000,0x00000000},0x00df,&ucs_strings[2937]},
	{{0x00000000,0x00000000,0x00000000},0x008e,&ucs_strings[2043]},
	{{0x00000000,0x00000000,0x00000000},0x008f,&ucs_strings[2062]},
	{{0x00000000,0x00000000,0x00000000},0x0086,&ucs_strings[1846]},
	{{0x00000000,0x00000000,0x00000000},0x009c,&ucs_strings[2387]},
	{{0x00000000,0x00000000,0x00000001},0x0096,&ucs_strings[2206]},
	{{0x00000000,0x00000000,0x00000001},0x0001,&ucs_strings[710]},
	{{0x00000000,0x00000000,0x00000001},0x0086,&ucs_strings[1823]},
	{{0x00000000,0x00000000,0x00000001},0x0098,&ucs_strings[2252]},
	{{0x00000000,0x00000000,0x00000001},0x0002,&ucs_strings[731]},
	{{0x00000000,0x00000000,0x00000000},0x009c,&ucs_strings[2369]},
	{{0x00000000,0x00000000,0x00000000},0x0093,&ucs_strings[2159]},
	{{0x00000000,0x00000000,0x00000000},0x0002,&ucs_strings[742]},
	{{0x00000000,0x00000000,0x00000000},0x001a,&ucs_strings[1173]},
	{{0x00000000,0x00000000,0x00000000},0x001a,&ucs_strings[1159]},
	{{0x00000000,0x00000000,0x00000000},0x0002,&ucs_strings[746]},
	{{0x00000000,0x00000000,0x00000000},0x0016,&ucs_strings[1102]},
	{{0x00000000,0x00000000,0x00000000},0x0016,&ucs_strings[1105]},
	{{0x00000000,0x00000000,0x00000000},0x0016,&ucs_strings[1085]},
	{{0x00000003,0x00000040,0x00000000},0x0054,&ucs_strings[1584]},
	{{0x00000005,0x00000040,0x00000000},0x0074,&ucs_strings[1584]},
	{{0x00000000,0x00000000,0x00000000},0x0009,&ucs_strings[857]},
	{{0x00000000,0x00000001,0x00000000},0x0009,&ucs_strings[857]},
	{{0x00000000,0x40000000,0x00000000},0x000b,&ucs_strings[857]},
	{{0x00000000,0x00000001,0x00000000},0x0009,&ucs_strings[846]},
	{{0x00000000,0x40000000,0x00000000},0x000b,&ucs_strings[846]},
	{{0x00000000,0x00000200,0x00000000},0x008a,&ucs_strings[1945]},
	{{0x00000000,0x00000000,0x00100001},0x0003,&ucs_strings[749]},
	{{0x00000000,0x00000000,0x00000000},0x00de,&ucs_strings[2926]},
	{{0x00000000,0x00000000,0x00000000},0x00fe,&ucs_strings[2926]},
	{{0x00000003,0x00000040,0x00000000},0x00de,&ucs_strings[2920]},
	{{0x00000005,0x00000040,0x00000000},0x00fe,&ucs_strings[2920]},
	{{0x00000001,0x00000000,0x00000000},0x0033,&ucs_strings[1444]},
	{{0x00000000,0x00000000,0x00000020},0x00b3,&ucs_strings[1444]},
	{{0x00000000,0x00000000,0x00000018},0x00be,&ucs_strings[2790]},
	{{0x00000000,0x00000000,0x00100001},0x0004,&ucs_strings[761]},
	{{0x00000000,0x00000000,0x00100001},0x0017,&ucs_strings[1109]},
	{{0x00000000,0x00000000,0x00000000},0x0093,&ucs_strings[2156]},
	{{0x00000001,0x00000000,0x00000000},0x0032,&ucs_strings[1440]},
	{{0x00000000,0x00000000,0x00000020},0x00b2,&ucs_strings[1440]},
	{{0x00000003,0x00000040,0x00000000},0x0055,&ucs_strings[1586]},
	{{0x00000005,0x00000040,0x00000000},0x0075,&ucs_strings[1586]},
	{{0x04000003,0x00000040,0x00000000},0x00d9,&ucs_strings[1586]},
	{{0x00000013,0x00000040,0x00000000},0x00da,&ucs_strings[1586]},
	{{0x00008003,0x00000040,0x00000000},0x00db,&ucs_strings[1586]},
	{{0x00040003,0x00000040,0x00000000},0x00dc,&ucs_strings[1586]},
	{{0x04000005,0x00000040,0x00000000},0x00f9,&ucs_strings[1586]},
	{{0x00000015,0x00000040,0x00000000},0x00fa,&ucs_strings[1586]},
	{{0x00008005,0x00000040,0x00000000},0x00fb,&ucs_strings[1586]},
	{{0x00040005,0x00000040,0x00000000},0x00fc,&ucs_strings[1586]},
	{{0x00000000,0x00000000,0x00000000},0x00d9,&ucs_strings[2905]},
	{{0x00000000,0x00000000,0x00000000},0x00f9,&ucs_strings[2905]},
	{{0x00000000,0x00000000,0x00000000},0x00da,&ucs_strings[2908]},
	{{0x00000000,0x00000000,0x00000000},0x00fa,&ucs_strings[2908]},
	{{0x00000000,0x00000000,0x00000000},0x00dc,&ucs_strings[2914]},
	{{0x00000000,0x00000000,0x00000000},0x00fc,&ucs_strings[2914]},
	{{0x00000000,0x00000000,0x00000000},0x00db,&ucs_strings[2911]},
	{{0x00000000,0x00000000,0x00000000},0x00fb,&ucs_strings[2911]},
	{{0x00000000,0x00000000,0x00000000},0x005f,&ucs_strings[1645]},
	{{0x00000000,0x00000000,0x00000000},0x001f,&ucs_strings[1266]},
	{{0x00000000,0x00000000,0x00000000},0x001f,&ucs_strings[1285]},
	{{0x00000003,0x00000040,0x00000000},0x0056,&ucs_strings[1588]},
	{{0x00000005,0x00000040,0x00000000},0x0076,&ucs_strings[1588]},
	{{0x00000000,0x00000000,0x00000000},0x008a,&ucs_strings[1960]},
	{{0x00000000,0x00000000,0x00000000},0x000b,&ucs_strings[880]},
	{{0x00000000,0x00000000,0x00000000},0x008a,&ucs_strings[1963]},
	{{0x00000003,0x00000040,0x00000000},0x0057,&ucs_strings[1590]},
	{{0x00000005,0x00000040,0x00000000},0x0077,&ucs_strings[1590]},
	{{0x00000003,0x00000040,0x00000000},0x0058,&ucs_strings[1592]},
	{{0x00000005,0x00000040,0x00000000},0x0078,&ucs_strings[1592]},
	{{0x00000000,0x00000000,0x00000000},0x00a4,&ucs_strings[2523]},
	{{0x00000003,0x00000040,0x00000000},0x0059,&ucs_strings[1594]},
	{{0x00000005,0x00000040,0x00000000},0x0079,&ucs_strings[1594]},
	{{0x00000013,0x00000040,0x00000000},0x00dd,&ucs_strings[1594]},
	{{0x00000015,0x00000040,0x00000000},0x00fd,&ucs_strings[1594]},
	{{0x00040005,0x00000040,0x00000000},0x00ff,&ucs_strings[1594]},
	{{0x00000000,0x00000000,0x00000000},0x00dd,&ucs_strings[2917]},
	{{0x00000000,0x00000000,0x00000000},0x00fd,&ucs_strings[2917]},
	{{0x00000000,0x00000000,0x00000000},0x00a5,&ucs_strings[2533]},
	{{0x00000000,0x00000000,0x00000000},0x00ff,&ucs_strings[2952]},
	{{0x00000000,0x00000000,0x00000000},0x00a5,&ucs_strings[2530]},
	{{0x00000001,0x00000000,0x00000000},0x00a5,&ucs_strings[2526]},
	{{0x00000003,0x00000040,0x00000000},0x005a,&ucs_strings[1596]},
	{{0x00000005,0x00000040,0x00000000},0x007a,&ucs_strings[1596]},
	{{0x00000001,0x00000000,0x00000000},0x0030,&ucs_strings[1435]},
#if !UCS_BYTE
	{{0x00001000,0x00000000,0x00000000},0x02c7,&ucs_strings[1288]},
	{{0x00000800,0x00000000,0x00000000},0x02d8,&ucs_strings[1288]},
	{{0x00000000,0x00000000,0x02000000},0x02db,&ucs_strings[1288]},
	{{0x00000000,0x00000000,0x00000001},0x2109,&ucs_strings[1288]},
	{{0x00000000,0x00000000,0x00010000},0x2228,&ucs_strings[1288]},
	{{0x00000000,0x00000000,0x00010000},0x25ad,&ucs_strings[1288]},
	{{0x00080008,0x00000000,0x00000000},0x02d9,&ucs_strings[1288]},
	{{0x00000008,0x00000000,0x04000000},0x02da,&ucs_strings[1288]},
	{{0x00000004,0x02000000,0x00000000},0x02dc,&ucs_strings[1288]},
	{{0x08000001,0x00004000,0x00000000},0x0374,&ucs_strings[1288]},
	{{0x08000000,0x00000000,0x20000000},0x0384,&ucs_strings[1288]},
	{{0x20000021,0x00000000,0x00000000},0x05d0,&ucs_strings[1288]},
	{{0x000000a1,0x00000000,0x00000000},0x0627,&ucs_strings[1288]},
	{{0x08000000,0x00100000,0x00000000},0x1fbe,&ucs_strings[1288]},
	{{0x08000000,0x00200000,0x00000000},0x1fbf,&ucs_strings[1288]},
	{{0x08000000,0x00080000,0x00000000},0x1fc0,&ucs_strings[1288]},
	{{0x08000000,0x20000000,0x00000000},0x1fef,&ucs_strings[1288]},
	{{0x08000000,0x00020000,0x00000000},0x1ffd,&ucs_strings[1288]},
	{{0x08020000,0x00000000,0x00000000},0x1ffe,&ucs_strings[1288]},
	{{0x00000000,0x00010000,0x00000040},0x2081,&ucs_strings[1288]},
	{{0x80000000,0x00000000,0x00040000},0x2440,&ucs_strings[1288]},
	{{0x00004001,0x00010000,0x00000000},0x2460,&ucs_strings[1288]},
	{{0x00000001,0x00050000,0x00000000},0x2474,&ucs_strings[1288]},
	{{0x00000000,0x00000000,0x00000084},0x25a0,&ucs_strings[1288]},
	{{0x00000000,0x80000000,0x00000080},0x25a1,&ucs_strings[1288]},
	{{0x00000000,0x00000000,0x00000a00},0x3000,&ucs_strings[1288]},
	{{0x40000001,0x04000000,0x00000000},0x3068,&ucs_strings[1288]},
	{{0x00000001,0x04000020,0x00000000},0x30c8,&ucs_strings[1288]},
	{{0x08000043,0x00000000,0x00000000},0x0391,&ucs_strings[1288]},
	{{0x08800003,0x00000000,0x00000000},0x0397,&ucs_strings[1288]},
	{{0x08000003,0x00000008,0x00000000},0x0399,&ucs_strings[1288]},
	{{0x08000003,0x10000000,0x00000000},0x03a5,&ucs_strings[1288]},
	{{0x08000003,0x00008000,0x00000000},0x03a9,&ucs_strings[1288]},
	{{0x08000045,0x00000000,0x00000000},0x03b1,&ucs_strings[1288]},
	{{0x08800005,0x00000000,0x00000000},0x03b7,&ucs_strings[1288]},
	{{0x08000005,0x00000008,0x00000000},0x03b9,&ucs_strings[1288]},
	{{0x08000005,0x10000000,0x00000000},0x03c5,&ucs_strings[1288]},
	{{0x08000005,0x00008000,0x00000000},0x03c9,&ucs_strings[1288]},
	{{0x00000081,0x00010000,0x00000400},0x0661,&ucs_strings[1288]},
	{{0x000000a1,0x00000000,0x00000020},0x0670,&ucs_strings[1288]},
	{{0x08000001,0x20200000,0x00000000},0x1fcd,&ucs_strings[1288]},
	{{0x08000001,0x00220000,0x00000000},0x1fce,&ucs_strings[1288]},
	{{0x08000001,0x00280000,0x00000000},0x1fcf,&ucs_strings[1288]},
	{{0x08020001,0x20000000,0x00000000},0x1fdd,&ucs_strings[1288]},
	{{0x08020001,0x00020000,0x00000000},0x1fde,&ucs_strings[1288]},
	{{0x08020001,0x00080000,0x00000000},0x1fdf,&ucs_strings[1288]},
	{{0x00100000,0x40000200,0x00000000},0x2016,&ucs_strings[1288]},
	{{0x00000000,0x00814000,0x00000000},0x2160,&ucs_strings[1288]},
	{{0x00000000,0x00400080,0x00002000},0x2194,&ucs_strings[1288]},
	{{0x00200000,0x08000000,0x00002000},0x2195,&ucs_strings[1288]},
	{{0x02000001,0x00010000,0x00000002},0x2488,&ucs_strings[1288]},
	{{0x00000004,0x00000000,0x00000084},0x25aa,&ucs_strings[1288]},
	{{0x02000000,0x00000000,0x00000802},0x3002,&ucs_strings[1288]},
	{{0x00080000,0x00000020,0x01000000},0x30fb,&ucs_strings[1288]},
	{{0x00000000,0x00050000,0x00000800},0x3220,&ucs_strings[1288]},
	{{0x000000a1,0x00000010,0x00000000},0xfe8d,&ucs_strings[1288]},
	{{0x010000a1,0x00000000,0x00000000},0xfe8e,&ucs_strings[1288]},
	{{0x08000043,0x00000000,0x20000000},0x0386,&ucs_strings[1288]},
	{{0x08800003,0x00000000,0x20000000},0x0389,&ucs_strings[1288]},
	{{0x08000003,0x00000008,0x20000000},0x038a,&ucs_strings[1288]},
	{{0x08000003,0x10000000,0x20000000},0x038e,&ucs_strings[1288]},
	{{0x08000003,0x00008000,0x20000000},0x038f,&ucs_strings[1288]},
	{{0x08000045,0x00000000,0x20000000},0x03ac,&ucs_strings[1288]},
	{{0x08800005,0x00000000,0x20000000},0x03ae,&ucs_strings[1288]},
	{{0x08000005,0x00000008,0x20000000},0x03af,&ucs_strings[1288]},
	{{0x08000005,0x10000000,0x20000000},0x03cd,&ucs_strings[1288]},
	{{0x08000005,0x00008000,0x20000000},0x03ce,&ucs_strings[1288]},
	{{0x08000045,0x00200000,0x00000000},0x1f00,&ucs_strings[1288]},
	{{0x08020045,0x00000000,0x00000000},0x1f01,&ucs_strings[1288]},
	{{0x08000043,0x00200000,0x00000000},0x1f08,&ucs_strings[1288]},
	{{0x08020043,0x00000000,0x00000000},0x1f09,&ucs_strings[1288]},
	{{0x08800005,0x00200000,0x00000000},0x1f20,&ucs_strings[1288]},
	{{0x08820005,0x00000000,0x00000000},0x1f21,&ucs_strings[1288]},
	{{0x08800003,0x00200000,0x00000000},0x1f28,&ucs_strings[1288]},
	{{0x08820003,0x00000000,0x00000000},0x1f29,&ucs_strings[1288]},
	{{0x08000005,0x00200008,0x00000000},0x1f30,&ucs_strings[1288]},
	{{0x08020005,0x00000008,0x00000000},0x1f31,&ucs_strings[1288]},
	{{0x08000003,0x00200008,0x00000000},0x1f38,&ucs_strings[1288]},
	{{0x08020003,0x00000008,0x00000000},0x1f39,&ucs_strings[1288]},
	{{0x08000005,0x10200000,0x00000000},0x1f50,&ucs_strings[1288]},
	{{0x08020005,0x10000000,0x00000000},0x1f51,&ucs_strings[1288]},
	{{0x08020003,0x10000000,0x00000000},0x1f59,&ucs_strings[1288]},
	{{0x08000005,0x00208000,0x00000000},0x1f60,&ucs_strings[1288]},
	{{0x08020005,0x00008000,0x00000000},0x1f61,&ucs_strings[1288]},
	{{0x08000003,0x00208000,0x00000000},0x1f68,&ucs_strings[1288]},
	{{0x08020003,0x00008000,0x00000000},0x1f69,&ucs_strings[1288]},
	{{0x08000045,0x20000000,0x00000000},0x1f70,&ucs_strings[1288]},
	{{0x08000045,0x00020000,0x00000000},0x1f71,&ucs_strings[1288]},
	{{0x08800005,0x20000000,0x00000000},0x1f74,&ucs_strings[1288]},
	{{0x08800005,0x00020000,0x00000000},0x1f75,&ucs_strings[1288]},
	{{0x08000005,0x20000008,0x00000000},0x1f76,&ucs_strings[1288]},
	{{0x08000005,0x00020008,0x00000000},0x1f77,&ucs_strings[1288]},
	{{0x08000005,0x30000000,0x00000000},0x1f7a,&ucs_strings[1288]},
	{{0x08000005,0x10020000,0x00000000},0x1f7b,&ucs_strings[1288]},
	{{0x08000005,0x20008000,0x00000000},0x1f7c,&ucs_strings[1288]},
	{{0x08000005,0x00028000,0x00000000},0x1f7d,&ucs_strings[1288]},
	{{0x08000045,0x00000400,0x00000000},0x1fb1,&ucs_strings[1288]},
	{{0x08000045,0x00080000,0x00000000},0x1fb6,&ucs_strings[1288]},
	{{0x08000043,0x00000400,0x00000000},0x1fb9,&ucs_strings[1288]},
	{{0x08000043,0x20000000,0x00000000},0x1fba,&ucs_strings[1288]},
	{{0x08000043,0x00020000,0x00000000},0x1fbb,&ucs_strings[1288]},
	{{0x08000043,0x00100000,0x00000000},0x1fbc,&ucs_strings[1288]},
	{{0x08800005,0x00080000,0x00000000},0x1fc6,&ucs_strings[1288]},
	{{0x08800003,0x20000000,0x00000000},0x1fca,&ucs_strings[1288]},
	{{0x08800003,0x00020000,0x00000000},0x1fcb,&ucs_strings[1288]},
	{{0x08800003,0x00100000,0x00000000},0x1fcc,&ucs_strings[1288]},
	{{0x08000005,0x00000408,0x00000000},0x1fd1,&ucs_strings[1288]},
	{{0x08000005,0x00080008,0x00000000},0x1fd6,&ucs_strings[1288]},
	{{0x08000003,0x00000408,0x00000000},0x1fd9,&ucs_strings[1288]},
	{{0x08000003,0x20000008,0x00000000},0x1fda,&ucs_strings[1288]},
	{{0x08000003,0x00020008,0x00000000},0x1fdb,&ucs_strings[1288]},
	{{0x08000005,0x10000400,0x00000000},0x1fe1,&ucs_strings[1288]},
	{{0x08000005,0x10080000,0x00000000},0x1fe6,&ucs_strings[1288]},
	{{0x08000003,0x10000400,0x00000000},0x1fe9,&ucs_strings[1288]},
	{{0x08000003,0x30000000,0x00000000},0x1fea,&ucs_strings[1288]},
	{{0x08000003,0x10020000,0x00000000},0x1feb,&ucs_strings[1288]},
	{{0x08000005,0x00088000,0x00000000},0x1ff6,&ucs_strings[1288]},
	{{0x08000003,0x20008000,0x00000000},0x1ffa,&ucs_strings[1288]},
	{{0x08000003,0x00028000,0x00000000},0x1ffb,&ucs_strings[1288]},
	{{0x08000003,0x00108000,0x00000000},0x1ffc,&ucs_strings[1288]},
	{{0x00000000,0x04400880,0x00000000},0x200e,&ucs_strings[1288]},
	{{0x00000000,0x04400880,0x00000000},0x200f,&ucs_strings[1288]},
	{{0x00000004,0x00814000,0x00000000},0x2170,&ucs_strings[1288]},
	{{0x00100000,0x00400080,0x00002000},0x21d4,&ucs_strings[1288]},
	{{0x00400400,0x00000101,0x00000000},0x2500,&ucs_strings[1288]},
	{{0x10400400,0x00000001,0x00000000},0x2501,&ucs_strings[1288]},
	{{0x00400400,0x40000100,0x00000000},0x2502,&ucs_strings[1288]},
	{{0x10400400,0x40000000,0x00000000},0x2503,&ucs_strings[1288]},
	{{0x00500400,0x00000001,0x00000000},0x2550,&ucs_strings[1288]},
	{{0x00500400,0x40000000,0x00000000},0x2551,&ucs_strings[1288]},
	{{0x08000045,0x20200000,0x00000000},0x1f02,&ucs_strings[1288]},
	{{0x08020045,0x20000000,0x00000000},0x1f03,&ucs_strings[1288]},
	{{0x08000045,0x00220000,0x00000000},0x1f04,&ucs_strings[1288]},
	{{0x08020045,0x00020000,0x00000000},0x1f05,&ucs_strings[1288]},
	{{0x08000045,0x00280000,0x00000000},0x1f06,&ucs_strings[1288]},
	{{0x08020045,0x00080000,0x00000000},0x1f07,&ucs_strings[1288]},
	{{0x08000043,0x20200000,0x00000000},0x1f0a,&ucs_strings[1288]},
	{{0x08020043,0x20000000,0x00000000},0x1f0b,&ucs_strings[1288]},
	{{0x08000043,0x00220000,0x00000000},0x1f0c,&ucs_strings[1288]},
	{{0x08020043,0x00020000,0x00000000},0x1f0d,&ucs_strings[1288]},
	{{0x08000043,0x00280000,0x00000000},0x1f0e,&ucs_strings[1288]},
	{{0x08020043,0x00080000,0x00000000},0x1f0f,&ucs_strings[1288]},
	{{0x08800005,0x20200000,0x00000000},0x1f22,&ucs_strings[1288]},
	{{0x08820005,0x20000000,0x00000000},0x1f23,&ucs_strings[1288]},
	{{0x08800005,0x00220000,0x00000000},0x1f24,&ucs_strings[1288]},
	{{0x08820005,0x00020000,0x00000000},0x1f25,&ucs_strings[1288]},
	{{0x08800005,0x00280000,0x00000000},0x1f26,&ucs_strings[1288]},
	{{0x08820005,0x00080000,0x00000000},0x1f27,&ucs_strings[1288]},
	{{0x08800003,0x20200000,0x00000000},0x1f2a,&ucs_strings[1288]},
	{{0x08820003,0x20000000,0x00000000},0x1f2b,&ucs_strings[1288]},
	{{0x08800003,0x00220000,0x00000000},0x1f2c,&ucs_strings[1288]},
	{{0x08820003,0x00020000,0x00000000},0x1f2d,&ucs_strings[1288]},
	{{0x08800003,0x00280000,0x00000000},0x1f2e,&ucs_strings[1288]},
	{{0x08820003,0x00080000,0x00000000},0x1f2f,&ucs_strings[1288]},
	{{0x08000005,0x20200008,0x00000000},0x1f32,&ucs_strings[1288]},
	{{0x08020005,0x20000008,0x00000000},0x1f33,&ucs_strings[1288]},
	{{0x08000005,0x00220008,0x00000000},0x1f34,&ucs_strings[1288]},
	{{0x08020005,0x00020008,0x00000000},0x1f35,&ucs_strings[1288]},
	{{0x08000005,0x00280008,0x00000000},0x1f36,&ucs_strings[1288]},
	{{0x08020005,0x00080008,0x00000000},0x1f37,&ucs_strings[1288]},
	{{0x08000003,0x20200008,0x00000000},0x1f3a,&ucs_strings[1288]},
	{{0x08020003,0x20000008,0x00000000},0x1f3b,&ucs_strings[1288]},
	{{0x08000003,0x00220008,0x00000000},0x1f3c,&ucs_strings[1288]},
	{{0x08020003,0x00020008,0x00000000},0x1f3d,&ucs_strings[1288]},
	{{0x08000003,0x00280008,0x00000000},0x1f3e,&ucs_strings[1288]},
	{{0x08020003,0x00080008,0x00000000},0x1f3f,&ucs_strings[1288]},
	{{0x08000005,0x30200000,0x00000000},0x1f52,&ucs_strings[1288]},
	{{0x08020005,0x30000000,0x00000000},0x1f53,&ucs_strings[1288]},
	{{0x08000005,0x10220000,0x00000000},0x1f54,&ucs_strings[1288]},
	{{0x08020005,0x10020000,0x00000000},0x1f55,&ucs_strings[1288]},
	{{0x08000005,0x10280000,0x00000000},0x1f56,&ucs_strings[1288]},
	{{0x08020005,0x10080000,0x00000000},0x1f57,&ucs_strings[1288]},
	{{0x08020003,0x30000000,0x00000000},0x1f5b,&ucs_strings[1288]},
	{{0x08020003,0x10020000,0x00000000},0x1f5d,&ucs_strings[1288]},
	{{0x08020003,0x10080000,0x00000000},0x1f5f,&ucs_strings[1288]},
	{{0x08000005,0x20208000,0x00000000},0x1f62,&ucs_strings[1288]},
	{{0x08020005,0x20008000,0x00000000},0x1f63,&ucs_strings[1288]},
	{{0x08000005,0x00228000,0x00000000},0x1f64,&ucs_strings[1288]},
	{{0x08020005,0x00028000,0x00000000},0x1f65,&ucs_strings[1288]},
	{{0x08000005,0x00288000,0x00000000},0x1f66,&ucs_strings[1288]},
	{{0x08020005,0x00088000,0x00000000},0x1f67,&ucs_strings[1288]},
	{{0x08000003,0x20208000,0x00000000},0x1f6a,&ucs_strings[1288]},
	{{0x08020003,0x20008000,0x00000000},0x1f6b,&ucs_strings[1288]},
	{{0x08000003,0x00228000,0x00000000},0x1f6c,&ucs_strings[1288]},
	{{0x08020003,0x00028000,0x00000000},0x1f6d,&ucs_strings[1288]},
	{{0x08000003,0x00288000,0x00000000},0x1f6e,&ucs_strings[1288]},
	{{0x08020003,0x00088000,0x00000000},0x1f6f,&ucs_strings[1288]},
	{{0x08000043,0x00300000,0x00000000},0x1f88,&ucs_strings[1288]},
	{{0x08020043,0x00100000,0x00000000},0x1f89,&ucs_strings[1288]},
	{{0x08800003,0x00300000,0x00000000},0x1f98,&ucs_strings[1288]},
	{{0x08820003,0x00100000,0x00000000},0x1f99,&ucs_strings[1288]},
	{{0x08000003,0x00308000,0x00000000},0x1fa8,&ucs_strings[1288]},
	{{0x08020003,0x00108000,0x00000000},0x1fa9,&ucs_strings[1288]},
	{{0x00600401,0x00400100,0x00000000},0x250c,&ucs_strings[1288]},
	{{0x10600401,0x00400000,0x00000000},0x250f,&ucs_strings[1288]},
	{{0x00600401,0x00000180,0x00000000},0x2510,&ucs_strings[1288]},
	{{0x10600401,0x00000080,0x00000000},0x2513,&ucs_strings[1288]},
	{{0x00400401,0x08400100,0x00000000},0x2514,&ucs_strings[1288]},
	{{0x10400401,0x08400000,0x00000000},0x2517,&ucs_strings[1288]},
	{{0x00400401,0x08000180,0x00000000},0x2518,&ucs_strings[1288]},
	{{0x10400401,0x08000080,0x00000000},0x251b,&ucs_strings[1288]},
	{{0x00400401,0x40400100,0x00000000},0x251c,&ucs_strings[1288]},
	{{0x10400401,0x40400000,0x00000000},0x2523,&ucs_strings[1288]},
	{{0x00400401,0x40000180,0x00000000},0x2524,&ucs_strings[1288]},
	{{0x10400401,0x40000080,0x00000000},0x252b,&ucs_strings[1288]},
	{{0x00600401,0x00000101,0x00000000},0x252c,&ucs_strings[1288]},
	{{0x10600401,0x00000001,0x00000000},0x2533,&ucs_strings[1288]},
	{{0x00400401,0x08000101,0x00000000},0x2534,&ucs_strings[1288]},
	{{0x10400401,0x08000001,0x00000000},0x253b,&ucs_strings[1288]},
	{{0x00400401,0x40000101,0x00000000},0x253c,&ucs_strings[1288]},
	{{0x10400401,0x40000001,0x00000000},0x254b,&ucs_strings[1288]},
	{{0x00700401,0x00400000,0x00000000},0x2554,&ucs_strings[1288]},
	{{0x00700401,0x00000080,0x00000000},0x2557,&ucs_strings[1288]},
	{{0x00500401,0x08400000,0x00000000},0x255a,&ucs_strings[1288]},
	{{0x00500401,0x08000080,0x00000000},0x255d,&ucs_strings[1288]},
	{{0x00500401,0x40400000,0x00000000},0x2560,&ucs_strings[1288]},
	{{0x00500401,0x40000080,0x00000000},0x2563,&ucs_strings[1288]},
	{{0x00700401,0x00000001,0x00000000},0x2566,&ucs_strings[1288]},
	{{0x00500401,0x08000001,0x00000000},0x2569,&ucs_strings[1288]},
	{{0x00500401,0x40000001,0x00000000},0x256c,&ucs_strings[1288]},
	{{0x08000043,0x20300000,0x00000000},0x1f8a,&ucs_strings[1288]},
	{{0x08020043,0x20100000,0x00000000},0x1f8b,&ucs_strings[1288]},
	{{0x08000043,0x00320000,0x00000000},0x1f8c,&ucs_strings[1288]},
	{{0x08020043,0x00120000,0x00000000},0x1f8d,&ucs_strings[1288]},
	{{0x08000043,0x00380000,0x00000000},0x1f8e,&ucs_strings[1288]},
	{{0x08020043,0x00180000,0x00000000},0x1f8f,&ucs_strings[1288]},
	{{0x08800003,0x20300000,0x00000000},0x1f9a,&ucs_strings[1288]},
	{{0x08820003,0x20100000,0x00000000},0x1f9b,&ucs_strings[1288]},
	{{0x08800003,0x00320000,0x00000000},0x1f9c,&ucs_strings[1288]},
	{{0x08820003,0x00120000,0x00000000},0x1f9d,&ucs_strings[1288]},
	{{0x08800003,0x00380000,0x00000000},0x1f9e,&ucs_strings[1288]},
	{{0x08820003,0x00180000,0x00000000},0x1f9f,&ucs_strings[1288]},
	{{0x08000003,0x20308000,0x00000000},0x1faa,&ucs_strings[1288]},
	{{0x08020003,0x20108000,0x00000000},0x1fab,&ucs_strings[1288]},
	{{0x08000003,0x00328000,0x00000000},0x1fac,&ucs_strings[1288]},
	{{0x08020003,0x00128000,0x00000000},0x1fad,&ucs_strings[1288]},
	{{0x08000003,0x00388000,0x00000000},0x1fae,&ucs_strings[1288]},
	{{0x08020003,0x00188000,0x00000000},0x1faf,&ucs_strings[1288]},
	{{0x10600401,0x00400100,0x00000000},0x250d,&ucs_strings[1288]},
	{{0x10600401,0x00400100,0x00000000},0x250e,&ucs_strings[1288]},
	{{0x10600401,0x00000180,0x00000000},0x2511,&ucs_strings[1288]},
	{{0x10600401,0x00000180,0x00000000},0x2512,&ucs_strings[1288]},
	{{0x10400401,0x08400100,0x00000000},0x2515,&ucs_strings[1288]},
	{{0x10400401,0x08400100,0x00000000},0x2516,&ucs_strings[1288]},
	{{0x10400401,0x08000180,0x00000000},0x2519,&ucs_strings[1288]},
	{{0x10400401,0x08000180,0x00000000},0x251a,&ucs_strings[1288]},
	{{0x10400401,0x40400100,0x00000000},0x251d,&ucs_strings[1288]},
	{{0x10400401,0x40400100,0x00000000},0x2520,&ucs_strings[1288]},
	{{0x10400401,0x40000180,0x00000000},0x2525,&ucs_strings[1288]},
	{{0x10400401,0x40000180,0x00000000},0x2528,&ucs_strings[1288]},
	{{0x10600401,0x00000101,0x00000000},0x252f,&ucs_strings[1288]},
	{{0x10600401,0x00000101,0x00000000},0x2530,&ucs_strings[1288]},
	{{0x10400401,0x08000101,0x00000000},0x2537,&ucs_strings[1288]},
	{{0x10400401,0x08000101,0x00000000},0x2538,&ucs_strings[1288]},
	{{0x10400401,0x40000101,0x00000000},0x253f,&ucs_strings[1288]},
	{{0x10400401,0x40000101,0x00000000},0x2542,&ucs_strings[1288]},
	{{0x00700401,0x01400000,0x00000000},0x2552,&ucs_strings[1288]},
	{{0x00700401,0x01400000,0x00000000},0x2553,&ucs_strings[1288]},
	{{0x00700401,0x01000080,0x00000000},0x2555,&ucs_strings[1288]},
	{{0x00700401,0x01000080,0x00000000},0x2556,&ucs_strings[1288]},
	{{0x00500401,0x09400000,0x00000000},0x2558,&ucs_strings[1288]},
	{{0x00500401,0x09400000,0x00000000},0x2559,&ucs_strings[1288]},
	{{0x00500401,0x09000080,0x00000000},0x255b,&ucs_strings[1288]},
	{{0x00500401,0x09000080,0x00000000},0x255c,&ucs_strings[1288]},
	{{0x00500401,0x41400000,0x00000000},0x255e,&ucs_strings[1288]},
	{{0x00500401,0x41400000,0x00000000},0x255f,&ucs_strings[1288]},
	{{0x00500401,0x41000080,0x00000000},0x2561,&ucs_strings[1288]},
	{{0x00500401,0x41000080,0x00000000},0x2562,&ucs_strings[1288]},
	{{0x00700401,0x01000001,0x00000000},0x2564,&ucs_strings[1288]},
	{{0x00700401,0x01000001,0x00000000},0x2565,&ucs_strings[1288]},
	{{0x00500401,0x09000001,0x00000000},0x2567,&ucs_strings[1288]},
	{{0x00500401,0x09000001,0x00000000},0x2568,&ucs_strings[1288]},
	{{0x00500401,0x41000001,0x00000000},0x256a,&ucs_strings[1288]},
	{{0x00500401,0x41000001,0x00000000},0x256b,&ucs_strings[1288]},
	{{0x10600401,0x08400100,0x00000000},0x251e,&ucs_strings[1288]},
	{{0x10600401,0x08400100,0x00000000},0x251f,&ucs_strings[1288]},
	{{0x10600401,0x08400100,0x00000000},0x2521,&ucs_strings[1288]},
	{{0x10600401,0x08400100,0x00000000},0x2522,&ucs_strings[1288]},
	{{0x10600401,0x08000180,0x00000000},0x2526,&ucs_strings[1288]},
	{{0x10600401,0x08000180,0x00000000},0x2527,&ucs_strings[1288]},
	{{0x10600401,0x08000180,0x00000000},0x2529,&ucs_strings[1288]},
	{{0x10600401,0x08000180,0x00000000},0x252a,&ucs_strings[1288]},
	{{0x10600401,0x00400180,0x00000000},0x252d,&ucs_strings[1288]},
	{{0x10600401,0x00400180,0x00000000},0x252e,&ucs_strings[1288]},
	{{0x10600401,0x00400180,0x00000000},0x2531,&ucs_strings[1288]},
	{{0x10600401,0x00400180,0x00000000},0x2532,&ucs_strings[1288]},
	{{0x10400401,0x08400180,0x00000000},0x2535,&ucs_strings[1288]},
	{{0x10400401,0x08400180,0x00000000},0x2536,&ucs_strings[1288]},
	{{0x10400401,0x08400180,0x00000000},0x2539,&ucs_strings[1288]},
	{{0x10400401,0x08400180,0x00000000},0x253a,&ucs_strings[1288]},
	{{0x10400401,0x40400180,0x00000000},0x253d,&ucs_strings[1288]},
	{{0x10400401,0x40400180,0x00000000},0x253e,&ucs_strings[1288]},
	{{0x10600401,0x08000101,0x00000000},0x2540,&ucs_strings[1288]},
	{{0x10600401,0x08000101,0x00000000},0x2541,&ucs_strings[1288]},
	{{0x10600401,0x08000101,0x00000000},0x2547,&ucs_strings[1288]},
	{{0x10600401,0x08000101,0x00000000},0x2548,&ucs_strings[1288]},
	{{0x10400401,0x40400180,0x00000000},0x2549,&ucs_strings[1288]},
	{{0x10400401,0x40400180,0x00000000},0x254a,&ucs_strings[1288]},
	{{0x10600401,0x08400180,0x00000000},0x2543,&ucs_strings[1288]},
	{{0x10600401,0x08400180,0x00000000},0x2544,&ucs_strings[1288]},
	{{0x10600401,0x08400180,0x00000000},0x2545,&ucs_strings[1288]},
	{{0x10600401,0x08400180,0x00000000},0x2546,&ucs_strings[1288]},
	{{0x00000000,0x00000000,0x00000000},0x2198,&ucs_strings_mb[3955]},
	{{0x00000000,0x00000000,0x00000000},0x1fef,&ucs_strings_mb[2787]},
	{{0x00000000,0x00000000,0x00000000},0x203c,&ucs_strings_mb[3237]},
	{{0x00000000,0x00000000,0x00000000},0x2016,&ucs_strings_mb[2917]},
	{{0x00000000,0x00000000,0x00000000},0x1fed,&ucs_strings_mb[2781]},
	{{0x00000000,0x00000000,0x00000000},0x226e,&ucs_strings_mb[4568]},
	{{0x00000000,0x00000000,0x00000000},0x2260,&ucs_strings_mb[4508]},
	{{0x00000000,0x00000000,0x00000000},0x226f,&ucs_strings_mb[4583]},
	{{0x00000000,0x00000000,0x00000000},0x0301,&ucs_strings_mb[560]},
	{{0x00000000,0x00000000,0x00000000},0x064c,&ucs_strings_mb[1587]},
	{{0x00000000,0x00000000,0x00000000},0x309b,&ucs_strings_mb[6688]},
	{{0x00000000,0x00000000,0x00000000},0x201c,&ucs_strings_mb[2977]},
	{{0x00000000,0x00000000,0x00000000},0x20d1,&ucs_strings_mb[3370]},
	{{0x00000000,0x00000000,0x00000000},0x201d,&ucs_strings_mb[2980]},
	{{0x00000000,0x00000000,0x00000000},0x0300,&ucs_strings_mb[557]},
	{{0x00000000,0x00000000,0x00000000},0x042c,&ucs_strings_mb[1100]},
	{{0x00000000,0x00000000,0x00000000},0x044c,&ucs_strings_mb[1118]},
	{{0x00000000,0x00000000,0x00000000},0x2030,&ucs_strings_mb[3132]},
	{{0x00000000,0x00000000,0x00000000},0x066a,&ucs_strings_mb[1678]},
	{{0x00000000,0x00000000,0x00000000},0x02dd,&ucs_strings_mb[537]},
	{{0x00000000,0x00000000,0x00000000},0x0385,&ucs_strings_mb[608]},
	{{0x00000000,0x00000000,0x00000000},0x02d8,&ucs_strings_mb[522]},
	{{0x00000000,0x00000000,0x00000000},0x0384,&ucs_strings_mb[595]},
	{{0x00000000,0x00000000,0x00000000},0x064f,&ucs_strings_mb[1617]},
	{{0x00000000,0x00000000,0x00000000},0x203e,&ucs_strings_mb[3250]},
	{{0x00000000,0x00000000,0x00000000},0x02d9,&ucs_strings_mb[525]},
	{{0x00000000,0x00000000,0x00000000},0x02da,&ucs_strings_mb[528]},
	{{0x00000000,0x00000000,0x00000000},0x2018,&ucs_strings_mb[2923]},
	{{0x00000000,0x00000000,0x00000000},0x2019,&ucs_strings_mb[2926]},
	{{0x00000000,0x00000000,0x00000000},0x02db,&ucs_strings_mb[531]},
	{{0x00000000,0x00000000,0x00000000},0x02c7,&ucs_strings_mb[504]},
	{{0x00000000,0x00000000,0x00000000},0x0374,&ucs_strings_mb[563]},
	{{0x00000000,0x00000000,0x00000000},0x0149,&ucs_strings_mb[150]},
	{{0x00000000,0x00000000,0x00000000},0x3010,&ucs_strings_mb[6462]},
	{{0x00000000,0x00000000,0x00000000},0x3014,&ucs_strings_mb[6501]},
	{{0x00000000,0x00000000,0x00000000},0x2208,&ucs_strings_mb[4112]},
	{{0x00000000,0x00000000,0x00000000},0x2474,&ucs_strings_mb[5047]},
	{{0x00000000,0x00000000,0x00000000},0x247d,&ucs_strings_mb[5083]},
	{{0x00000000,0x00000000,0x00000000},0x247e,&ucs_strings_mb[5088]},
	{{0x00000000,0x00000000,0x00000000},0x247f,&ucs_strings_mb[5093]},
	{{0x00000000,0x00000000,0x00000000},0x2480,&ucs_strings_mb[5098]},
	{{0x00000000,0x00000000,0x00000000},0x2481,&ucs_strings_mb[5103]},
	{{0x00000000,0x00000000,0x00000000},0x2482,&ucs_strings_mb[5108]},
	{{0x00000000,0x00000000,0x00000000},0x2483,&ucs_strings_mb[5113]},
	{{0x00000000,0x00000000,0x00000000},0x2484,&ucs_strings_mb[5118]},
	{{0x00000000,0x00000000,0x00000000},0x2485,&ucs_strings_mb[5123]},
	{{0x00000000,0x00000000,0x00000000},0x2486,&ucs_strings_mb[5128]},
	{{0x00000000,0x00000000,0x00000000},0x2475,&ucs_strings_mb[5051]},
	{{0x00000000,0x00000000,0x00000000},0x2487,&ucs_strings_mb[5133]},
	{{0x00000000,0x00000000,0x00000000},0x2476,&ucs_strings_mb[5055]},
	{{0x00000000,0x00000000,0x00000000},0x2477,&ucs_strings_mb[5059]},
	{{0x00000000,0x00000000,0x00000000},0x2478,&ucs_strings_mb[5063]},
	{{0x00000000,0x00000000,0x00000000},0x2479,&ucs_strings_mb[5067]},
	{{0x00000000,0x00000000,0x00000000},0x247a,&ucs_strings_mb[5071]},
	{{0x00000000,0x00000000,0x00000000},0x247b,&ucs_strings_mb[5075]},
	{{0x00000000,0x00000000,0x00000000},0x247c,&ucs_strings_mb[5079]},
	{{0x00000000,0x00000000,0x00000000},0x2286,&ucs_strings_mb[4608]},
	{{0x00000000,0x00000000,0x00000000},0x2312,&ucs_strings_mb[4689]},
	{{0x00000000,0x00000000,0x00000000},0x249c,&ucs_strings_mb[5209]},
	{{0x00000000,0x00000000,0x00000000},0x249d,&ucs_strings_mb[5213]},
	{{0x00000000,0x00000000,0x00000000},0x2282,&ucs_strings_mb[4593]},
	{{0x00000000,0x00000000,0x00000000},0x249e,&ucs_strings_mb[5217]},
	{{0x00000000,0x00000000,0x00000000},0x249f,&ucs_strings_mb[5221]},
	{{0x00000000,0x00000000,0x00000000},0x24a0,&ucs_strings_mb[5225]},
	{{0x00000000,0x00000000,0x00000000},0x24a1,&ucs_strings_mb[5229]},
	{{0x00000000,0x00000000,0x00000000},0x24a2,&ucs_strings_mb[5233]},
	{{0x00000000,0x00000000,0x00000000},0x24a3,&ucs_strings_mb[5237]},
	{{0x00000000,0x00000000,0x00000000},0x3016,&ucs_strings_mb[6507]},
	{{0x00000000,0x00000000,0x00000000},0x24a4,&ucs_strings_mb[5241]},
	{{0x00000000,0x00000000,0x00000000},0x24a5,&ucs_strings_mb[5245]},
	{{0x00000000,0x00000000,0x00000000},0x321c,&ucs_strings_mb[6897]},
	{{0x00000000,0x00000000,0x00000000},0x24a6,&ucs_strings_mb[5249]},
	{{0x00000000,0x00000000,0x00000000},0x24a7,&ucs_strings_mb[5253]},
	{{0x00000000,0x00000000,0x00000000},0x24a8,&ucs_strings_mb[5257]},
	{{0x00000000,0x00000000,0x00000000},0x24a9,&ucs_strings_mb[5261]},
	{{0x00000000,0x00000000,0x00000000},0x24aa,&ucs_strings_mb[5265]},
	{{0x00000000,0x00000000,0x00000000},0x24ab,&ucs_strings_mb[5269]},
	{{0x00000000,0x00000000,0x00000000},0x24ac,&ucs_strings_mb[5273]},
	{{0x00000000,0x00000000,0x00000000},0x24ad,&ucs_strings_mb[5277]},
	{{0x00000000,0x00000000,0x00000000},0x207d,&ucs_strings_mb[3309]},
	{{0x00000000,0x00000000,0x00000000},0x208d,&ucs_strings_mb[3309]},
	{{0x00000000,0x00000000,0x00000000},0x24ae,&ucs_strings_mb[5281]},
	{{0x00000000,0x00000000,0x00000000},0x24af,&ucs_strings_mb[5285]},
	{{0x00000000,0x00000000,0x00000000},0x2229,&ucs_strings_mb[4332]},
	{{0x00000000,0x00000000,0x00000000},0x24b0,&ucs_strings_mb[5289]},
	{{0x00000000,0x00000000,0x00000000},0x24b1,&ucs_strings_mb[5293]},
	{{0x00000000,0x00000000,0x00000000},0x24b2,&ucs_strings_mb[5297]},
	{{0x00000000,0x00000000,0x00000000},0x24b3,&ucs_strings_mb[5301]},
	{{0x00000000,0x00000000,0x00000000},0x24b4,&ucs_strings_mb[5305]},
	{{0x00000000,0x00000000,0x00000000},0x24b5,&ucs_strings_mb[5309]},
	{{0x00000000,0x00000000,0x00000000},0x3011,&ucs_strings_mb[6465]},
	{{0x00000000,0x00000000,0x00000000},0x3015,&ucs_strings_mb[6504]},
	{{0x00000000,0x00000000,0x00000000},0x1fbd,&ucs_strings_mb[2661]},
	{{0x00000000,0x00000000,0x00000000},0x2287,&ucs_strings_mb[4611]},
	{{0x00000000,0x00000000,0x00000000},0x2283,&ucs_strings_mb[4605]},
	{{0x00000000,0x00000000,0x00000000},0x3017,&ucs_strings_mb[6510]},
	{{0x00000000,0x00000000,0x00000000},0x207e,&ucs_strings_mb[3312]},
	{{0x00000000,0x00000000,0x00000000},0x208e,&ucs_strings_mb[3312]},
	{{0x00000000,0x00000000,0x00000000},0x222a,&ucs_strings_mb[4341]},
	{{0x00000000,0x00000000,0x00000000},0x2217,&ucs_strings_mb[4220]},
	{{0x00000000,0x00000000,0x00000000},0x2606,&ucs_strings_mb[6049]},
	{{0x00000000,0x00000000,0x00000000},0x2605,&ucs_strings_mb[6046]},
	{{0x00000000,0x00000000,0x00000000},0x309d,&ucs_strings_mb[6712]},
	{{0x00000000,0x00000000,0x00000000},0x30fd,&ucs_strings_mb[6784]},
	{{0x00000000,0x00000000,0x00000000},0x226b,&ucs_strings_mb[4556]},
	{{0x00000000,0x00000000,0x00000000},0x3005,&ucs_strings_mb[6409]},
	{{0x00000000,0x00000000,0x00000000},0x220f,&ucs_strings_mb[4160]},
	{{0x00000000,0x00000000,0x00000000},0x03c2,&ucs_strings_mb[818]},
	{{0x00000000,0x00000000,0x00000000},0x3003,&ucs_strings_mb[6356]},
	{{0x00000000,0x00000000,0x00000000},0x0640,&ucs_strings_mb[1515]},
	{{0x00000000,0x00000000,0x00000000},0x309e,&ucs_strings_mb[6732]},
	{{0x00000000,0x00000000,0x00000000},0x30fe,&ucs_strings_mb[6787]},
	{{0x00000000,0x00000000,0x00000000},0x207a,&ucs_strings_mb[3294]},
	{{0x00000000,0x00000000,0x00000000},0x208a,&ucs_strings_mb[3294]},
	{{0x00000000,0x00000000,0x00000000},0x2211,&ucs_strings_mb[4179]},
	{{0x00000000,0x00000000,0x00000000},0x1fcd,&ucs_strings_mb[2701]},
	{{0x00000000,0x00000000,0x00000000},0x1fce,&ucs_strings_mb[2704]},
	{{0x00000000,0x00000000,0x00000000},0x060c,&ucs_strings_mb[1330]},
	{{0x00000000,0x00000000,0x00000000},0x1fbf,&ucs_strings_mb[2664]},
	{{0x00000000,0x00000000,0x00000000},0x3001,&ucs_strings_mb[6344]},
	{{0x00000000,0x00000000,0x00000000},0x0375,&ucs_strings_mb[572]},
	{{0x00000000,0x00000000,0x00000000},0x2191,&ucs_strings_mb[3878]},
	{{0x00000000,0x00000000,0x00000000},0x220b,&ucs_strings_mb[4134]},
	{{0x00000000,0x00000000,0x00000000},0x2213,&ucs_strings_mb[4196]},
	{{0x00000000,0x00000000,0x00000000},0x2212,&ucs_strings_mb[4182]},
	{{0x00000000,0x00000000,0x00000000},0x2015,&ucs_strings_mb[2914]},
	{{0x00000000,0x00000000,0x00000000},0x30fc,&ucs_strings_mb[6781]},
	{{0x00000000,0x00000000,0x00000000},0x2192,&ucs_strings_mb[3892]},
	{{0x00000000,0x00000000,0x00000000},0x301c,&ucs_strings_mb[6523]},
	{{0x00000000,0x00000000,0x00000000},0x2043,&ucs_strings_mb[3267]},
	{{0x00000000,0x00000000,0x00000000},0x221f,&ucs_strings_mb[4293]},
	{{0x00000000,0x00000000,0x00000000},0x2014,&ucs_strings_mb[2911]},
	{{0x00000000,0x00000000,0x00000000},0x2013,&ucs_strings_mb[2900]},
	{{0x00000000,0x00000000,0x00000000},0x207b,&ucs_strings_mb[3303]},
	{{0x00000000,0x00000000,0x00000000},0x208b,&ucs_strings_mb[3303]},
	{{0x00000000,0x00000000,0x00000000},0x22a5,&ucs_strings_mb[4625]},
	{{0x00000000,0x00000000,0x00000000},0x2193,&ucs_strings_mb[3905]},
	{{0x00000000,0x00000000,0x00000000},0x2220,&ucs_strings_mb[3905]},
	{{0x00000000,0x00000000,0x00000000},0x2720,&ucs_strings_mb[6338]},
	{{0x00000000,0x00000000,0x00000000},0x0387,&ucs_strings_mb[625]},
	{{0x00000000,0x00000000,0x00000000},0x2214,&ucs_strings_mb[4199]},
	{{0x00000000,0x00000000,0x00000000},0x2027,&ucs_strings_mb[3074]},
	{{0x00000000,0x00000000,0x00000000},0x2025,&ucs_strings_mb[3041]},
	{{0x00000000,0x00000000,0x00000000},0x2026,&ucs_strings_mb[3053]},
	{{0x00000000,0x00000000,0x00000000},0x30fb,&ucs_strings_mb[6762]},
	{{0x00000000,0x00000000,0x00000000},0x201a,&ucs_strings_mb[2945]},
	{{0x00000000,0x00000000,0x00000000},0x2234,&ucs_strings_mb[4383]},
	{{0x00000000,0x00000000,0x00000000},0x3002,&ucs_strings_mb[6347]},
	{{0x00000000,0x00000000,0x00000000},0x22c5,&ucs_strings_mb[4628]},
	{{0x00000000,0x00000000,0x00000000},0x2591,&ucs_strings_mb[5704]},
	{{0x00000000,0x00000000,0x00000000},0x1ffd,&ucs_strings_mb[2813]},
	{{0x00000000,0x00000000,0x00000000},0x064e,&ucs_strings_mb[1608]},
	{{0x00000000,0x00000000,0x00000000},0x2020,&ucs_strings_mb[2996]},
	{{0x00000000,0x00000000,0x00000000},0x2197,&ucs_strings_mb[3940]},
	{{0x00000000,0x00000000,0x00000000},0x2205,&ucs_strings_mb[4085]},
	{{0x00000000,0x00000000,0x00000000},0x2021,&ucs_strings_mb[2999]},
	{{0x00000000,0x00000000,0x00000000},0x232a,&ucs_strings_mb[4785]},
	{{0x00000000,0x00000000,0x00000000},0x2044,&ucs_strings_mb[3270]},
	{{0x00000000,0x00000000,0x00000000},0x221d,&ucs_strings_mb[4272]},
	{{0x00000000,0x00000000,0x00000000},0x0652,&ucs_strings_mb[1645]},
	{{0x00000000,0x00000000,0x00000000},0x24ea,&ucs_strings_mb[5417]},
	{{0x00000000,0x00000000,0x00000000},0x2299,&ucs_strings_mb[4614]},
	{{0x00000000,0x00000000,0x00000000},0x221e,&ucs_strings_mb[4284]},
	{{0x00000000,0x00000000,0x00000000},0x229a,&ucs_strings_mb[4617]},
	{{0x00000000,0x00000000,0x00000000},0x309c,&ucs_strings_mb[6709]},
	{{0x00000000,0x00000000,0x00000000},0x3007,&ucs_strings_mb[6423]},
	{{0x00000000,0x00000000,0x00000000},0x0660,&ucs_strings_mb[1648]},
	{{0x00000000,0x00000000,0x00000000},0x25d0,&ucs_strings_mb[5969]},
	{{0x00000000,0x00000000,0x00000000},0x25cb,&ucs_strings_mb[5954]},
	{{0x00000000,0x00000000,0x00000000},0x25cf,&ucs_strings_mb[5954]},
	{{0x00000000,0x00000000,0x00000000},0x25ce,&ucs_strings_mb[5966]},
	{{0x00000000,0x00000000,0x00000000},0x25d1,&ucs_strings_mb[5972]},
	{{0x00000000,0x00000000,0x00000000},0x2070,&ucs_strings_mb[3273]},
	{{0x00000000,0x00000000,0x00000000},0x2080,&ucs_strings_mb[3273]},
	{{0x00000000,0x00000000,0x00000000},0x263a,&ucs_strings_mb[6100]},
	{{0x00000000,0x00000000,0x00000000},0x263b,&ucs_strings_mb[6100]},
	{{0x00000000,0x00000000,0x00000000},0x02cb,&ucs_strings_mb[519]},
	{{0x00000000,0x00000000,0x00000000},0x2035,&ucs_strings_mb[3178]},
	{{0x00000000,0x00000000,0x00000000},0x2032,&ucs_strings_mb[3141]},
	{{0x00000000,0x00000000,0x00000000},0x0650,&ucs_strings_mb[1626]},
	{{0x00000000,0x00000000,0x00000000},0x02c9,&ucs_strings_mb[516]},
	{{0x00000000,0x00000000,0x00000000},0x2460,&ucs_strings_mb[4887]},
	{{0x00000000,0x00000000,0x00000000},0x2488,&ucs_strings_mb[5138]},
	{{0x00000000,0x00000000,0x00000000},0x2469,&ucs_strings_mb[4923]},
	{{0x00000000,0x00000000,0x00000000},0x2491,&ucs_strings_mb[5165]},
	{{0x00000000,0x00000000,0x00000000},0x2182,&ucs_strings_mb[3850]},
	{{0x00000000,0x00000000,0x00000000},0x216f,&ucs_strings_mb[3790]},
	{{0x00000000,0x00000000,0x00000000},0x217f,&ucs_strings_mb[3790]},
	{{0x00000000,0x00000000,0x00000000},0x2180,&ucs_strings_mb[3809]},
	{{0x00000000,0x00000000,0x00000000},0x216d,&ucs_strings_mb[3758]},
	{{0x00000000,0x00000000,0x00000000},0x217d,&ucs_strings_mb[3758]},
	{{0x00000000,0x00000000,0x00000000},0x3229,&ucs_strings_mb[6929]},
	{{0x00000000,0x00000000,0x00000000},0x246a,&ucs_strings_mb[4928]},
	{{0x00000000,0x00000000,0x00000000},0x2492,&ucs_strings_mb[5169]},
	{{0x00000000,0x00000000,0x00000000},0x246b,&ucs_strings_mb[4933]},
	{{0x00000000,0x00000000,0x00000000},0x2493,&ucs_strings_mb[5173]},
	{{0x00000000,0x00000000,0x00000000},0x2153,&ucs_strings_mb[3534]},
	{{0x00000000,0x00000000,0x00000000},0x246c,&ucs_strings_mb[4947]},
	{{0x00000000,0x00000000,0x00000000},0x2494,&ucs_strings_mb[5177]},
	{{0x00000000,0x00000000,0x00000000},0x246d,&ucs_strings_mb[4961]},
	{{0x00000000,0x00000000,0x00000000},0x2495,&ucs_strings_mb[5181]},
	{{0x00000000,0x00000000,0x00000000},0x2155,&ucs_strings_mb[3557]},
	{{0x00000000,0x00000000,0x00000000},0x246e,&ucs_strings_mb[4974]},
	{{0x00000000,0x00000000,0x00000000},0x2496,&ucs_strings_mb[5185]},
	{{0x00000000,0x00000000,0x00000000},0x2159,&ucs_strings_mb[3611]},
	{{0x00000000,0x00000000,0x00000000},0x246f,&ucs_strings_mb[4987]},
	{{0x00000000,0x00000000,0x00000000},0x2497,&ucs_strings_mb[5189]},
	{{0x00000000,0x00000000,0x00000000},0x2470,&ucs_strings_mb[5002]},
	{{0x00000000,0x00000000,0x00000000},0x2498,&ucs_strings_mb[5193]},
	{{0x00000000,0x00000000,0x00000000},0x215b,&ucs_strings_mb[3636]},
	{{0x00000000,0x00000000,0x00000000},0x2471,&ucs_strings_mb[5016]},
	{{0x00000000,0x00000000,0x00000000},0x2499,&ucs_strings_mb[5197]},
	{{0x00000000,0x00000000,0x00000000},0x2472,&ucs_strings_mb[5030]},
	{{0x00000000,0x00000000,0x00000000},0x249a,&ucs_strings_mb[5201]},
	{{0x00000000,0x00000000,0x00000000},0x02c6,&ucs_strings_mb[501]},
	{{0x00000000,0x00000000,0x00000000},0x02dc,&ucs_strings_mb[534]},
	{{0x00000000,0x00000000,0x00000000},0x0661,&ucs_strings_mb[1651]},
	{{0x00000000,0x00000000,0x00000000},0x3220,&ucs_strings_mb[6902]},
	{{0x00000000,0x00000000,0x00000000},0x200a,&ucs_strings_mb[2883]},
	{{0x00000000,0x00000000,0x00000000},0x2440,&ucs_strings_mb[2883]},
	{{0x00000000,0x00000000,0x00000000},0x2446,&ucs_strings_mb[4840]},
	{{0x00000000,0x00000000,0x00000000},0x2003,&ucs_strings_mb[2822]},
	{{0x00000000,0x00000000,0x00000000},0x2002,&ucs_strings_mb[2819]},
	{{0x00000000,0x00000000,0x00000000},0x2160,&ucs_strings_mb[3689]},
	{{0x00000000,0x00000000,0x00000000},0x2170,&ucs_strings_mb[3689]},
	{{0x00000000,0x00000000,0x00000000},0x2081,&ucs_strings[2739]},
	{{0x00000000,0x00000000,0x00000000},0x2009,&ucs_strings_mb[2875]},
	{{0x00000000,0x00000000,0x00000000},0x2036,&ucs_strings_mb[3181]},
	{{0x00000000,0x00000000,0x00000000},0x2033,&ucs_strings_mb[3144]},
	{{0x00000000,0x00000000,0x00000000},0x2461,&ucs_strings_mb[4891]},
	{{0x00000000,0x00000000,0x00000000},0x2489,&ucs_strings_mb[5141]},
	{{0x00000000,0x00000000,0x00000000},0x2473,&ucs_strings_mb[5042]},
	{{0x00000000,0x00000000,0x00000000},0x249b,&ucs_strings_mb[5205]},
	{{0x00000000,0x00000000,0x00000000},0x2154,&ucs_strings_mb[3548]},
	{{0x00000000,0x00000000,0x00000000},0x2156,&ucs_strings_mb[3571]},
	{{0x00000000,0x00000000,0x00000000},0x0662,&ucs_strings_mb[1654]},
	{{0x00000000,0x00000000,0x00000000},0x3221,&ucs_strings_mb[6905]},
	{{0x00000000,0x00000000,0x00000000},0x2442,&ucs_strings_mb[4807]},
	{{0x00000000,0x00000000,0x00000000},0x2447,&ucs_strings_mb[4856]},
	{{0x00000000,0x00000000,0x00000000},0x2161,&ucs_strings_mb[3692]},
	{{0x00000000,0x00000000,0x00000000},0x2171,&ucs_strings_mb[3692]},
	{{0x00000000,0x00000000,0x00000000},0x2082,&ucs_strings[2704]},
	{{0x00000000,0x00000000,0x00000000},0x2506,&ucs_strings_mb[5459]},
	{{0x00000000,0x00000000,0x00000000},0x2037,&ucs_strings_mb[3206]},
	{{0x00000000,0x00000000,0x00000000},0x2034,&ucs_strings_mb[3160]},
	{{0x00000000,0x00000000,0x00000000},0x0651,&ucs_strings_mb[1636]},
	{{0x00000000,0x00000000,0x00000000},0xfe7d,&ucs_strings_mb[6983]},
	{{0x00000000,0x00000000,0x00000000},0x2504,&ucs_strings_mb[5453]},
	{{0x00000000,0x00000000,0x00000000},0x2462,&ucs_strings_mb[4895]},
	{{0x00000000,0x00000000,0x00000000},0x248a,&ucs_strings_mb[5144]},
	{{0x00000000,0x00000000,0x00000000},0x2507,&ucs_strings_mb[5462]},
	{{0x00000000,0x00000000,0x00000000},0x2157,&ucs_strings_mb[3587]},
	{{0x00000000,0x00000000,0x00000000},0x215c,&ucs_strings_mb[3653]},
	{{0x00000000,0x00000000,0x00000000},0x2505,&ucs_strings_mb[5456]},
	{{0x00000000,0x00000000,0x00000000},0x0663,&ucs_strings_mb[1657]},
	{{0x00000000,0x00000000,0x00000000},0x2023,&ucs_strings_mb[3027]},
	{{0x00000000,0x00000000,0x00000000},0x3222,&ucs_strings_mb[6908]},
	{{0x00000000,0x00000000,0x00000000},0x2441,&ucs_strings_mb[4799]},
	{{0x00000000,0x00000000,0x00000000},0x2448,&ucs_strings_mb[4864]},
	{{0x00000000,0x00000000,0x00000000},0x2004,&ucs_strings_mb[2838]},
	{{0x00000000,0x00000000,0x00000000},0x2162,&ucs_strings_mb[3695]},
	{{0x00000000,0x00000000,0x00000000},0x2172,&ucs_strings_mb[3695]},
	{{0x00000000,0x00000000,0x00000000},0x2083,&ucs_strings[2707]},
	{{0x00000000,0x00000000,0x00000000},0x250a,&ucs_strings_mb[5486]},
	{{0x00000000,0x00000000,0x00000000},0x2508,&ucs_strings_mb[5480]},
	{{0x00000000,0x00000000,0x00000000},0x2463,&ucs_strings_mb[4899]},
	{{0x00000000,0x00000000,0x00000000},0x248b,&ucs_strings_mb[5147]},
	{{0x00000000,0x00000000,0x00000000},0x250b,&ucs_strings_mb[5489]},
	{{0x00000000,0x00000000,0x00000000},0x2158,&ucs_strings_mb[3602]},
	{{0x00000000,0x00000000,0x00000000},0x2509,&ucs_strings_mb[5483]},
	{{0x00000000,0x00000000,0x00000000},0x0664,&ucs_strings_mb[1660]},
	{{0x00000000,0x00000000,0x00000000},0x3223,&ucs_strings_mb[6911]},
	{{0x00000000,0x00000000,0x00000000},0x2443,&ucs_strings_mb[4810]},
	{{0x00000000,0x00000000,0x00000000},0x2449,&ucs_strings_mb[4884]},
	{{0x00000000,0x00000000,0x00000000},0x2005,&ucs_strings_mb[2853]},
	{{0x00000000,0x00000000,0x00000000},0x2163,&ucs_strings_mb[3698]},
	{{0x00000000,0x00000000,0x00000000},0x2173,&ucs_strings_mb[3698]},
	{{0x00000000,0x00000000,0x00000000},0x2074,&ucs_strings_mb[3276]},
	{{0x00000000,0x00000000,0x00000000},0x2084,&ucs_strings_mb[3276]},
	{{0x00000000,0x00000000,0x00000000},0x2464,&ucs_strings_mb[4903]},
	{{0x00000000,0x00000000,0x00000000},0x248c,&ucs_strings_mb[5150]},
	{{0x00000000,0x00000000,0x00000000},0x2181,&ucs_strings_mb[3831]},
	{{0x00000000,0x00000000,0x00000000},0x216e,&ucs_strings_mb[3776]},
	{{0x00000000,0x00000000,0x00000000},0x217e,&ucs_strings_mb[3776]},
	{{0x00000000,0x00000000,0x00000000},0x216c,&ucs_strings_mb[3746]},
	{{0x00000000,0x00000000,0x00000000},0x217c,&ucs_strings_mb[3746]},
	{{0x00000000,0x00000000,0x00000000},0x215a,&ucs_strings_mb[3626]},
	{{0x00000000,0x00000000,0x00000000},0x215d,&ucs_strings_mb[3669]},
	{{0x00000000,0x00000000,0x00000000},0x0665,&ucs_strings_mb[1663]},
	{{0x00000000,0x00000000,0x00000000},0x3224,&ucs_strings_mb[6914]},
	{{0x00000000,0x00000000,0x00000000},0x2164,&ucs_strings_mb[3701]},
	{{0x00000000,0x00000000,0x00000000},0x2174,&ucs_strings_mb[3701]},
	{{0x00000000,0x00000000,0x00000000},0x2075,&ucs_strings_mb[3279]},
	{{0x00000000,0x00000000,0x00000000},0x2085,&ucs_strings_mb[3279]},
	{{0x00000000,0x00000000,0x00000000},0x2465,&ucs_strings_mb[4907]},
	{{0x00000000,0x00000000,0x00000000},0x248d,&ucs_strings_mb[5153]},
	{{0x00000000,0x00000000,0x00000000},0x0666,&ucs_strings_mb[1666]},
	{{0x00000000,0x00000000,0x00000000},0x3225,&ucs_strings_mb[6917]},
	{{0x00000000,0x00000000,0x00000000},0x2006,&ucs_strings_mb[2867]},
	{{0x00000000,0x00000000,0x00000000},0x2165,&ucs_strings_mb[3704]},
	{{0x00000000,0x00000000,0x00000000},0x2175,&ucs_strings_mb[3704]},
	{{0x00000000,0x00000000,0x00000000},0x2076,&ucs_strings_mb[3282]},
	{{0x00000000,0x00000000,0x00000000},0x2086,&ucs_strings_mb[3282]},
	{{0x00000000,0x00000000,0x00000000},0x2466,&ucs_strings_mb[4911]},
	{{0x00000000,0x00000000,0x00000000},0x248e,&ucs_strings_mb[5156]},
	{{0x00000000,0x00000000,0x00000000},0x215e,&ucs_strings_mb[3686]},
	{{0x00000000,0x00000000,0x00000000},0x230a,&ucs_strings_mb[4663]},
	{{0x00000000,0x00000000,0x00000000},0x230b,&ucs_strings_mb[4666]},
	{{0x00000000,0x00000000,0x00000000},0x0667,&ucs_strings_mb[1669]},
	{{0x00000000,0x00000000,0x00000000},0x3226,&ucs_strings_mb[6920]},
	{{0x00000000,0x00000000,0x00000000},0x2166,&ucs_strings_mb[3707]},
	{{0x00000000,0x00000000,0x00000000},0x2176,&ucs_strings_mb[3707]},
	{{0x00000000,0x00000000,0x00000000},0x2077,&ucs_strings_mb[3285]},
	{{0x00000000,0x00000000,0x00000000},0x2087,&ucs_strings_mb[3285]},
	{{0x00000000,0x00000000,0x00000000},0x2467,&ucs_strings_mb[4915]},
	{{0x00000000,0x00000000,0x00000000},0x248f,&ucs_strings_mb[5159]},
	{{0x00000000,0x00000000,0x00000000},0x2318,&ucs_strings_mb[4729]},
	{{0x00000000,0x00000000,0x00000000},0x0668,&ucs_strings_mb[1672]},
	{{0x00000000,0x00000000,0x00000000},0x3227,&ucs_strings_mb[6923]},
	{{0x00000000,0x00000000,0x00000000},0x2167,&ucs_strings_mb[3710]},
	{{0x00000000,0x00000000,0x00000000},0x2177,&ucs_strings_mb[3710]},
	{{0x00000000,0x00000000,0x00000000},0x2078,&ucs_strings_mb[3288]},
	{{0x00000000,0x00000000,0x00000000},0x2088,&ucs_strings_mb[3288]},
	{{0x00000000,0x00000000,0x00000000},0x201f,&ucs_strings_mb[2986]},
	{{0x00000000,0x00000000,0x00000000},0x201b,&ucs_strings_mb[2974]},
	{{0x00000000,0x00000000,0x00000000},0x2468,&ucs_strings_mb[4919]},
	{{0x00000000,0x00000000,0x00000000},0x2490,&ucs_strings_mb[5162]},
	{{0x00000000,0x00000000,0x00000000},0x0669,&ucs_strings_mb[1675]},
	{{0x00000000,0x00000000,0x00000000},0x3228,&ucs_strings_mb[6926]},
	{{0x00000000,0x00000000,0x00000000},0x2168,&ucs_strings_mb[3713]},
	{{0x00000000,0x00000000,0x00000000},0x2178,&ucs_strings_mb[3713]},
	{{0x00000000,0x00000000,0x00000000},0x2079,&ucs_strings_mb[3291]},
	{{0x00000000,0x00000000,0x00000000},0x2089,&ucs_strings_mb[3291]},
	{{0x00000000,0x00000000,0x00000000},0x1fee,&ucs_strings_mb[2784]},
	{{0x00000000,0x00000000,0x00000000},0x064b,&ucs_strings_mb[1575]},
	{{0x00000000,0x00000000,0x00000000},0x2235,&ucs_strings_mb[4394]},
	{{0x00000000,0x00000000,0x00000000},0x22ee,&ucs_strings_mb[4631]},
	{{0x00000000,0x00000000,0x00000000},0x201e,&ucs_strings_mb[2983]},
	{{0x00000000,0x00000000,0x00000000},0x2237,&ucs_strings_mb[4417]},
	{{0x00000000,0x00000000,0x00000000},0x2236,&ucs_strings_mb[4403]},
	{{0x00000000,0x00000000,0x00000000},0x2592,&ucs_strings_mb[5720]},
	{{0x00000000,0x00000000,0x00000000},0x203b,&ucs_strings_mb[3234]},
	{{0x00000000,0x00000000,0x00000000},0x1fdd,&ucs_strings_mb[2737]},
	{{0x00000000,0x00000000,0x00000000},0x1fde,&ucs_strings_mb[2740]},
	{{0x00000000,0x00000000,0x00000000},0x061b,&ucs_strings_mb[1333]},
	{{0x00000000,0x00000000,0x00000000},0x1ffe,&ucs_strings_mb[2816]},
	{{0x00000000,0x00000000,0x00000000},0x3006,&ucs_strings_mb[6420]},
	{{0x00000000,0x00000000,0x00000000},0x02bb,&ucs_strings_mb[482]},
	{{0x00000000,0x00000000,0x00000000},0x2196,&ucs_strings_mb[3925]},
	{{0x00000000,0x00000000,0x00000000},0x300e,&ucs_strings_mb[6445]},
	{{0x00000000,0x00000000,0x00000000},0x300c,&ucs_strings_mb[6439]},
	{{0x00000000,0x00000000,0x00000000},0x226a,&ucs_strings_mb[4540]},
	{{0x00000000,0x00000000,0x00000000},0x300a,&ucs_strings_mb[6426]},
	{{0x00000000,0x00000000,0x00000000},0x2190,&ucs_strings_mb[3867]},
	{{0x00000000,0x00000000,0x00000000},0x2329,&ucs_strings_mb[4782]},
	{{0x00000000,0x00000000,0x00000000},0x2199,&ucs_strings_mb[3970]},
	{{0x00000000,0x00000000,0x00000000},0x2039,&ucs_strings_mb[3218]},
	{{0x00000000,0x00000000,0x00000000},0x2308,&ucs_strings_mb[4651]},
	{{0x00000000,0x00000000,0x00000000},0x21d0,&ucs_strings_mb[4018]},
	{{0x00000000,0x00000000,0x00000000},0x2194,&ucs_strings_mb[3908]},
	{{0x00000000,0x00000000,0x00000000},0x261c,&ucs_strings_mb[6081]},
	{{0x00000000,0x00000000,0x00000000},0x042a,&ucs_strings_mb[1084]},
	{{0x00000000,0x00000000,0x00000000},0x044a,&ucs_strings_mb[1115]},
	{{0x00000000,0x00000000,0x00000000},0x064d,&ucs_strings_mb[1599]},
	{{0x00000000,0x00000000,0x00000000},0x2017,&ucs_strings_mb[2920]},
	{{0x00000000,0x00000000,0x00000000},0x2261,&ucs_strings_mb[4521]},
	{{0x00000000,0x00000000,0x00000000},0x2264,&ucs_strings_mb[4524]},
	{{0x00000000,0x00000000,0x00000000},0x21d4,&ucs_strings_mb[4024]},
	{{0x00000000,0x00000000,0x00000000},0x21d2,&ucs_strings_mb[4021]},
	{{0x00000000,0x00000000,0x00000000},0x224c,&ucs_strings_mb[4482]},
	{{0x00000000,0x00000000,0x00000000},0x3013,&ucs_strings_mb[6483]},
	{{0x00000000,0x00000000,0x00000000},0x207c,&ucs_strings_mb[3306]},
	{{0x00000000,0x00000000,0x00000000},0x208c,&ucs_strings_mb[3306]},
	{{0x00000000,0x00000000,0x00000000},0x3012,&ucs_strings_mb[6475]},
	{{0x00000000,0x00000000,0x00000000},0x3020,&ucs_strings_mb[6538]},
	{{0x00000000,0x00000000,0x00000000},0x300f,&ucs_strings_mb[6448]},
	{{0x00000000,0x00000000,0x00000000},0x300d,&ucs_strings_mb[6442]},
	{{0x00000000,0x00000000,0x00000000},0x300b,&ucs_strings_mb[6429]},
	{{0x00000000,0x00000000,0x00000000},0x203a,&ucs_strings_mb[3221]},
	{{0x00000000,0x00000000,0x00000000},0x2309,&ucs_strings_mb[4654]},
	{{0x00000000,0x00000000,0x00000000},0x2265,&ucs_strings_mb[4527]},
	{{0x00000000,0x00000000,0x00000000},0x261e,&ucs_strings_mb[6084]},
	{{0x00000000,0x00000000,0x00000000},0x21c0,&ucs_strings_mb[4015]},
	{{0x00000000,0x00000000,0x00000000},0x037e,&ucs_strings_mb[592]},
	{{0x00000000,0x00000000,0x00000000},0x1fc0,&ucs_strings_mb[2667]},
	{{0x00000000,0x00000000,0x00000000},0x061f,&ucs_strings_mb[1336]},
	{{0x00000000,0x00000000,0x00000000},0x1fcf,&ucs_strings_mb[2707]},
	{{0x00000000,0x00000000,0x00000000},0x2243,&ucs_strings_mb[4448]},
	{{0x00000000,0x00000000,0x00000000},0x223c,&ucs_strings_mb[4420]},
	{{0x00000000,0x00000000,0x00000000},0x2248,&ucs_strings_mb[4475]},
	{{0x00000000,0x00000000,0x00000000},0x1fc1,&ucs_strings_mb[2670]},
	{{0x00000000,0x00000000,0x00000000},0x1fdf,&ucs_strings_mb[2743]},
	{{0x00000000,0x00000000,0x00000000},0x2245,&ucs_strings_mb[4465]},
	{{0x00000000,0x00000000,0x00000000},0x2593,&ucs_strings_mb[5734]},
	{{0x00000000,0x00000000,0x00000000},0x2502,&ucs_strings_mb[5434]},
	{{0x00000000,0x00000000,0x00000000},0x253c,&ucs_strings_mb[5601]},
	{{0x00000000,0x00000000,0x00000000},0x2524,&ucs_strings_mb[5556]},
	{{0x00000000,0x00000000,0x00000000},0x251c,&ucs_strings_mb[5541]},
	{{0x00000000,0x00000000,0x00000000},0x2500,&ucs_strings_mb[5421]},
	{{0x00000000,0x00000000,0x00000000},0x2534,&ucs_strings_mb[5586]},
	{{0x00000000,0x00000000,0x00000000},0x25e2,&ucs_strings_mb[6023]},
	{{0x00000000,0x00000000,0x00000000},0x2501,&ucs_strings_mb[5428]},
	{{0x00000000,0x00000000,0x00000000},0x2571,&ucs_strings_mb[5649]},
	{{0x00000000,0x00000000,0x00000000},0x2518,&ucs_strings_mb[5530]},
	{{0x00000000,0x00000000,0x00000000},0x2514,&ucs_strings_mb[5519]},
	{{0x00000000,0x00000000,0x00000000},0x266a,&ucs_strings_mb[6206]},
	{{0x00000000,0x00000000,0x00000000},0x252c,&ucs_strings_mb[5571]},
	{{0x00000000,0x00000000,0x00000000},0x2510,&ucs_strings_mb[5503]},
	{{0x00000000,0x00000000,0x00000000},0x250c,&ucs_strings_mb[5495]},
	{{0x40000001,0x00000000,0x00000000},0x3042,&ucs_strings[1546]},
	{{0x00000001,0x00000020,0x00000000},0x30a2,&ucs_strings[1546]},
	{{0x00000201,0x00000000,0x00000000},0x311a,&ucs_strings[1546]},
	{{0x00010003,0x00000000,0x00000000},0x0410,&ucs_strings[1546]},
	{{0x00010005,0x00000000,0x00000000},0x0430,&ucs_strings[1546]},
	{{0x40000005,0x00000000,0x00000000},0x3041,&ucs_strings[1546]},
	{{0x00000005,0x00000020,0x00000000},0x30a1,&ucs_strings[1546]},
	{{0x00000003,0x00000440,0x00000000},0x0100,&ucs_strings[1546]},
	{{0x00000005,0x00000440,0x00000000},0x0101,&ucs_strings[1546]},
	{{0x00000803,0x00000040,0x00000000},0x0102,&ucs_strings[1546]},
	{{0x00000805,0x00000040,0x00000000},0x0103,&ucs_strings[1546]},
	{{0x00000003,0x00000040,0x02000000},0x0104,&ucs_strings[1546]},
	{{0x00000005,0x00000040,0x02000000},0x0105,&ucs_strings[1546]},
	{{0x00001003,0x00000040,0x00000000},0x01cd,&ucs_strings[1546]},
	{{0x00001005,0x00000040,0x00000000},0x01ce,&ucs_strings[1546]},
	{{0x00000005,0x00040040,0x00000000},0x249c,&ucs_strings[1546]},
	{{0x00004003,0x00000040,0x00000000},0x24b6,&ucs_strings[1546]},
	{{0x00004005,0x00000040,0x00000000},0x24d0,&ucs_strings[1546]},
	{{0x00040003,0x00000440,0x00000000},0x01de,&ucs_strings[1546]},
	{{0x00040005,0x00000440,0x00000000},0x01df,&ucs_strings[1546]},
	{{0x04100003,0x00000040,0x00000000},0x0200,&ucs_strings[1546]},
	{{0x04100005,0x00000040,0x00000000},0x0201,&ucs_strings[1546]},
	{{0x00000803,0x00000040,0x00800000},0x0202,&ucs_strings[1546]},
	{{0x00000805,0x00000040,0x00800000},0x0203,&ucs_strings[1546]},
	{{0x00000103,0x00000040,0x04000000},0x1e00,&ucs_strings[1546]},
	{{0x00000105,0x00000040,0x04000000},0x1e01,&ucs_strings[1546]},
	{{0x00080103,0x00000040,0x00000000},0x1ea0,&ucs_strings[1546]},
	{{0x00080105,0x00000040,0x00000000},0x1ea1,&ucs_strings[1546]},
	{{0x8000000b,0x00000040,0x00000000},0x1ea2,&ucs_strings[1546]},
	{{0x8000000d,0x00000040,0x00000000},0x1ea3,&ucs_strings[1546]},
	{{0x00008013,0x00000040,0x00000000},0x1ea4,&ucs_strings[1546]},
	{{0x00008015,0x00000040,0x00000000},0x1ea5,&ucs_strings[1546]},
	{{0x04008003,0x00000040,0x00000000},0x1ea6,&ucs_strings[1546]},
	{{0x04008005,0x00000040,0x00000000},0x1ea7,&ucs_strings[1546]},
	{{0x00008003,0x02000040,0x00000000},0x1eaa,&ucs_strings[1546]},
	{{0x00008005,0x02000040,0x00000000},0x1eab,&ucs_strings[1546]},
	{{0x00000813,0x00000040,0x00000000},0x1eae,&ucs_strings[1546]},
	{{0x00000815,0x00000040,0x00000000},0x1eaf,&ucs_strings[1546]},
	{{0x04000803,0x00000040,0x00000000},0x1eb0,&ucs_strings[1546]},
	{{0x04000805,0x00000040,0x00000000},0x1eb1,&ucs_strings[1546]},
	{{0x00000803,0x02000040,0x00000000},0x1eb4,&ucs_strings[1546]},
	{{0x00000805,0x02000040,0x00000000},0x1eb5,&ucs_strings[1546]},
	{{0x0008000b,0x00000440,0x00000000},0x01e0,&ucs_strings[1546]},
	{{0x0008000d,0x00000440,0x00000000},0x01e1,&ucs_strings[1546]},
	{{0x0000001b,0x00000040,0x04000000},0x01fa,&ucs_strings[1546]},
	{{0x0000001d,0x00000040,0x04000000},0x01fb,&ucs_strings[1546]},
	{{0x8000800b,0x00000040,0x00000000},0x1ea8,&ucs_strings[1546]},
	{{0x8000800d,0x00000040,0x00000000},0x1ea9,&ucs_strings[1546]},
	{{0x00088103,0x00000040,0x00000000},0x1eac,&ucs_strings[1546]},
	{{0x00088105,0x00000040,0x00000000},0x1ead,&ucs_strings[1546]},
	{{0x8000080b,0x00000040,0x00000000},0x1eb2,&ucs_strings[1546]},
	{{0x8000080d,0x00000040,0x00000000},0x1eb3,&ucs_strings[1546]},
	{{0x00080903,0x00000040,0x00000000},0x1eb6,&ucs_strings[1546]},
	{{0x00080905,0x00000040,0x00000000},0x1eb7,&ucs_strings[1546]},
	{{0x00000000,0x00000000,0x00000000},0x24b6,&ucs_strings_mb[5313]},
	{{0x00000000,0x00000000,0x00000000},0x24d0,&ucs_strings_mb[5313]},
	{{0x00000000,0x00000000,0x00000000},0x0200,&ucs_strings_mb[404]},
	{{0x00000000,0x00000000,0x00000000},0x0201,&ucs_strings_mb[404]},
	{{0x00000000,0x00000000,0x00000000},0x0386,&ucs_strings_mb[611]},
	{{0x00000000,0x00000000,0x00000000},0x03ac,&ucs_strings_mb[611]},
	{{0x00000000,0x00000000,0x00000000},0x0102,&ucs_strings_mb[3]},
	{{0x00000000,0x00000000,0x00000000},0x0103,&ucs_strings_mb[3]},
	{{0x00000000,0x00000000,0x00000000},0x1eb0,&ucs_strings_mb[2030]},
	{{0x00000000,0x00000000,0x00000000},0x1eb1,&ucs_strings_mb[2030]},
	{{0x00000000,0x00000000,0x00000000},0x1eae,&ucs_strings_mb[2026]},
	{{0x00000000,0x00000000,0x00000000},0x1eaf,&ucs_strings_mb[2026]},
	{{0x00000000,0x00000000,0x00000000},0x1eb6,&ucs_strings_mb[2042]},
	{{0x00000000,0x00000000,0x00000000},0x1eb7,&ucs_strings_mb[2042]},
	{{0x00000000,0x00000000,0x00000000},0x1eb2,&ucs_strings_mb[2034]},
	{{0x00000000,0x00000000,0x00000000},0x1eb3,&ucs_strings_mb[2034]},
	{{0x00000000,0x00000000,0x00000000},0x1eb4,&ucs_strings_mb[2038]},
	{{0x00000000,0x00000000,0x00000000},0x1eb5,&ucs_strings_mb[2038]},
	{{0x00000000,0x00000000,0x00000000},0x0202,&ucs_strings_mb[408]},
	{{0x00000000,0x00000000,0x00000000},0x0203,&ucs_strings_mb[408]},
	{{0x00000000,0x00000000,0x00000000},0x0391,&ucs_strings_mb[665]},
	{{0x00000000,0x00000000,0x00000000},0x03b1,&ucs_strings_mb[665]},
	{{0x00000000,0x00000000,0x00000000},0x1f70,&ucs_strings_mb[2421]},
	{{0x00000000,0x00000000,0x00000000},0x1fba,&ucs_strings_mb[2421]},
	{{0x00000000,0x00000000,0x00000000},0x1fb2,&ucs_strings_mb[2630]},
	{{0x00000000,0x00000000,0x00000000},0x1f71,&ucs_strings_mb[2425]},
	{{0x00000000,0x00000000,0x00000000},0x1fbb,&ucs_strings_mb[2425]},
	{{0x00000000,0x00000000,0x00000000},0x1fb4,&ucs_strings_mb[2639]},
	{{0x00000000,0x00000000,0x00000000},0x1fb0,&ucs_strings_mb[2622]},
	{{0x00000000,0x00000000,0x00000000},0x1fb8,&ucs_strings_mb[2622]},
	{{0x00000000,0x00000000,0x00000000},0x1f00,&ucs_strings_mb[2175]},
	{{0x00000000,0x00000000,0x00000000},0x1f08,&ucs_strings_mb[2175]},
	{{0x00000000,0x00000000,0x00000000},0x1f02,&ucs_strings_mb[2183]},
	{{0x00000000,0x00000000,0x00000000},0x1f0a,&ucs_strings_mb[2183]},
	{{0x00000000,0x00000000,0x00000000},0x1f82,&ucs_strings_mb[2487]},
	{{0x00000000,0x00000000,0x00000000},0x1f8a,&ucs_strings_mb[2487]},
	{{0x00000000,0x00000000,0x00000000},0x1f04,&ucs_strings_mb[2193]},
	{{0x00000000,0x00000000,0x00000000},0x1f0c,&ucs_strings_mb[2193]},
	{{0x00000000,0x00000000,0x00000000},0x1f84,&ucs_strings_mb[2499]},
	{{0x00000000,0x00000000,0x00000000},0x1f8c,&ucs_strings_mb[2499]},
	{{0x00000000,0x00000000,0x00000000},0x1f06,&ucs_strings_mb[2203]},
	{{0x00000000,0x00000000,0x00000000},0x1f0e,&ucs_strings_mb[2203]},
	{{0x00000000,0x00000000,0x00000000},0x1f86,&ucs_strings_mb[2511]},
	{{0x00000000,0x00000000,0x00000000},0x1f8e,&ucs_strings_mb[2511]},
	{{0x00000000,0x00000000,0x00000000},0x1f80,&ucs_strings_mb[2477]},
	{{0x00000000,0x00000000,0x00000000},0x1f88,&ucs_strings_mb[2477]},
	{{0x00000000,0x00000000,0x00000000},0x1fb1,&ucs_strings_mb[2626]},
	{{0x00000000,0x00000000,0x00000000},0x1fb9,&ucs_strings_mb[2626]},
	{{0x00000000,0x00000000,0x00000000},0x1f01,&ucs_strings_mb[2179]},
	{{0x00000000,0x00000000,0x00000000},0x1f09,&ucs_strings_mb[2179]},
	{{0x00000000,0x00000000,0x00000000},0x1f03,&ucs_strings_mb[2188]},
	{{0x00000000,0x00000000,0x00000000},0x1f0b,&ucs_strings_mb[2188]},
	{{0x00000000,0x00000000,0x00000000},0x1f83,&ucs_strings_mb[2493]},
	{{0x00000000,0x00000000,0x00000000},0x1f8b,&ucs_strings_mb[2493]},
	{{0x00000000,0x00000000,0x00000000},0x1f05,&ucs_strings_mb[2198]},
	{{0x00000000,0x00000000,0x00000000},0x1f0d,&ucs_strings_mb[2198]},
	{{0x00000000,0x00000000,0x00000000},0x1f85,&ucs_strings_mb[2505]},
	{{0x00000000,0x00000000,0x00000000},0x1f8d,&ucs_strings_mb[2505]},
	{{0x00000000,0x00000000,0x00000000},0x1f07,&ucs_strings_mb[2208]},
	{{0x00000000,0x00000000,0x00000000},0x1f0f,&ucs_strings_mb[2208]},
	{{0x00000000,0x00000000,0x00000000},0x1f87,&ucs_strings_mb[2517]},
	{{0x00000000,0x00000000,0x00000000},0x1f8f,&ucs_strings_mb[2517]},
	{{0x00000000,0x00000000,0x00000000},0x1f81,&ucs_strings_mb[2482]},
	{{0x00000000,0x00000000,0x00000000},0x1f89,&ucs_strings_mb[2482]},
	{{0x00000000,0x00000000,0x00000000},0x1fb6,&ucs_strings_mb[2644]},
	{{0x00000000,0x00000000,0x00000000},0x1fb7,&ucs_strings_mb[2648]},
	{{0x00000000,0x00000000,0x00000000},0x1fb3,&ucs_strings_mb[2635]},
	{{0x00000000,0x00000000,0x00000000},0x1fbc,&ucs_strings_mb[2635]},
	{{0x00000000,0x00000000,0x00000000},0x05d0,&ucs_strings_mb[1160]},
	{{0x00000000,0x00000000,0x00000000},0x0627,&ucs_strings_mb[1160]},
	{{0x00000000,0x00000000,0x00000000},0xfe8d,&ucs_strings_mb[7015]},
	{{0x00000000,0x00000000,0x00000000},0xfe8e,&ucs_strings_mb[7019]},
	{{0x00000000,0x00000000,0x00000000},0x0100,&ucs_strings_mb[0]},
	{{0x00000000,0x00000000,0x00000000},0x0101,&ucs_strings_mb[0]},
	{{0x00000000,0x00000000,0x00000000},0x1ea0,&ucs_strings_mb[1998]},
	{{0x00000000,0x00000000,0x00000000},0x1ea1,&ucs_strings_mb[1998]},
	{{0x00000000,0x00000000,0x00000000},0x1e00,&ucs_strings_mb[1728]},
	{{0x00000000,0x00000000,0x00000000},0x1e01,&ucs_strings_mb[1728]},
	{{0x00000000,0x00000000,0x00000000},0x01de,&ucs_strings_mb[355]},
	{{0x00000000,0x00000000,0x00000000},0x01df,&ucs_strings_mb[355]},
	{{0x00000000,0x00000000,0x00000000},0x1ea2,&ucs_strings_mb[2002]},
	{{0x00000000,0x00000000,0x00000000},0x1ea3,&ucs_strings_mb[2002]},
	{{0x00000000,0x00000000,0x00000000},0x01e2,&ucs_strings_mb[361]},
	{{0x00000000,0x00000000,0x00000000},0x01e3,&ucs_strings_mb[361]},
	{{0x00000000,0x00000000,0x00000000},0x311a,&ucs_strings_mb[6841]},
	{{0x00000000,0x00000000,0x00000000},0x3041,&ucs_strings_mb[6543]},
	{{0x00000000,0x00000000,0x00000000},0x3042,&ucs_strings_mb[6543]},
	{{0x00000000,0x00000000,0x00000000},0x30a1,&ucs_strings_mb[6735]},
	{{0x00000000,0x00000000,0x00000000},0x30a2,&ucs_strings_mb[6735]},
	{{0x00000000,0x00000000,0x00000000},0x01e0,&ucs_strings_mb[358]},
	{{0x00000000,0x00000000,0x00000000},0x01e1,&ucs_strings_mb[358]},
	{{0x00000000,0x00000000,0x00000000},0x0104,&ucs_strings_mb[6]},
	{{0x00000000,0x00000000,0x00000000},0x0105,&ucs_strings_mb[6]},
	{{0x00000000,0x00000000,0x00000000},0x01cd,&ucs_strings_mb[315]},
	{{0x00000000,0x00000000,0x00000000},0x01ce,&ucs_strings_mb[315]},
	{{0x00000000,0x00000000,0x00000000},0x0410,&ucs_strings_mb[942]},
	{{0x00000000,0x00000000,0x00000000},0x0430,&ucs_strings_mb[942]},
	{{0x00000000,0x00000000,0x00000000},0x1ea6,&ucs_strings_mb[2009]},
	{{0x00000000,0x00000000,0x00000000},0x1ea7,&ucs_strings_mb[2009]},
	{{0x00000000,0x00000000,0x00000000},0x1ea4,&ucs_strings_mb[2005]},
	{{0x00000000,0x00000000,0x00000000},0x1ea5,&ucs_strings_mb[2005]},
	{{0x00000000,0x00000000,0x00000000},0x1eac,&ucs_strings_mb[2021]},
	{{0x00000000,0x00000000,0x00000000},0x1ead,&ucs_strings_mb[2021]},
	{{0x00000000,0x00000000,0x00000000},0x1ea8,&ucs_strings_mb[2013]},
	{{0x00000000,0x00000000,0x00000000},0x1ea9,&ucs_strings_mb[2013]},
	{{0x00000000,0x00000000,0x00000000},0x1eaa,&ucs_strings_mb[2017]},
	{{0x00000000,0x00000000,0x00000000},0x1eab,&ucs_strings_mb[2017]},
	{{0x00000000,0x00000000,0x00000000},0x01fa,&ucs_strings_mb[392]},
	{{0x00000000,0x00000000,0x00000000},0x01fb,&ucs_strings_mb[392]},
	{{0x00100010,0x00000000,0x00000000},0x02dd,&ucs_strings[1627]},
	{{0x00000003,0x00000440,0x00000000},0x01e2,&ucs_strings[2829]},
	{{0x00000005,0x00000440,0x00000000},0x01e3,&ucs_strings[2829]},
	{{0x00000013,0x00000040,0x00000000},0x01fc,&ucs_strings[2829]},
	{{0x00000015,0x00000040,0x00000000},0x01fd,&ucs_strings[2829]},
	{{0x00000000,0x00000000,0x00000000},0x01fc,&ucs_strings_mb[396]},
	{{0x00000000,0x00000000,0x00000000},0x01fd,&ucs_strings_mb[396]},
	{{0x00000000,0x00000000,0x00000000},0x0623,&ucs_strings_mb[1357]},
	{{0x00000000,0x00000000,0x00000000},0x0625,&ucs_strings_mb[1357]},
	{{0x00000000,0x00000000,0x00000000},0xfe83,&ucs_strings_mb[6999]},
	{{0x00000000,0x00000000,0x00000000},0xfe84,&ucs_strings_mb[7003]},
	{{0x00000000,0x00000000,0x00000000},0xfe88,&ucs_strings_mb[7003]},
	{{0x00000201,0x00000000,0x00000000},0x311e,&ucs_strings_mb[6854]},
	{{0x00000081,0x00000000,0x00000000},0x0639,&ucs_strings_mb[1494]},
	{{0x00000081,0x00000010,0x00000000},0xfec9,&ucs_strings_mb[1494]},
	{{0x01000081,0x00000000,0x00000000},0xfeca,&ucs_strings_mb[1494]},
	{{0x00000081,0x00000004,0x00000000},0xfecb,&ucs_strings_mb[1494]},
	{{0x00000081,0x00001000,0x00000000},0xfecc,&ucs_strings_mb[1494]},
	{{0x00000000,0x04000000,0x00001000},0x224c,&ucs_strings_mb[4478]},
	{{0x00000000,0x04000000,0x00001000},0x2248,&ucs_strings_mb[4468]},
	{{0x00000000,0x00000000,0x00000000},0x0622,&ucs_strings_mb[1354]},
	{{0x00000000,0x00000000,0x00000080},0x33c2,&ucs_strings_mb[1354]},
	{{0x00000000,0x00000000,0x00000000},0xfe81,&ucs_strings_mb[6991]},
	{{0x00000000,0x00000000,0x00000000},0xfe82,&ucs_strings_mb[6995]},
	{{0x00000000,0x00000000,0x00040001},0x2447,&ucs_strings_mb[4843]},
	{{0x00000000,0x00000000,0x00000000},0x2227,&ucs_strings_mb[4316]},
	{{0x00000201,0x00000000,0x00000000},0x3122,&ucs_strings_mb[4316]},
	{{0x00000201,0x00000000,0x00000000},0x3124,&ucs_strings_mb[6866]},
	{{0x00000000,0x00000000,0x00000000},0x2220,&ucs_strings_mb[4287]},
	{{0x00000000,0x00400000,0x00000000},0x221f,&ucs_strings_mb[4287]},
	{{0x00100000,0x00000080,0x00020000},0x300a,&ucs_strings_mb[4287]},
	{{0x00100000,0x00400000,0x00020000},0x300b,&ucs_strings_mb[4287]},
	{{0x00000001,0x00000000,0x00000000},0x212b,&ucs_strings_mb[3495]},
	{{0x08000000,0x00000000,0x00000000},0x0387,&ucs_strings_mb[614]},
	{{0x00000000,0x00000000,0x00000000},0x212b,&ucs_strings_mb[3504]},
	{{0x00000000,0x04000000,0x00001000},0x2245,&ucs_strings_mb[4451]},
	{{0x00000000,0x00000000,0x00000000},0x2169,&ucs_strings_mb[3720]},
	{{0x00000000,0x00000000,0x00000000},0x2179,&ucs_strings_mb[3720]},
	{{0x00000000,0x00000000,0x00000000},0x2312,&ucs_strings_mb[4685]},
	{{0x00000000,0x00000000,0x00000000},0x0670,&ucs_strings_mb[1681]},
	{{0x00000000,0x00000000,0x00000000},0x2217,&ucs_strings_mb[4202]},
	{{0x00000000,0x04000000,0x00001000},0x2243,&ucs_strings_mb[4433]},
	{{0x00000201,0x00000000,0x00000000},0x3120,&ucs_strings_mb[6860]},
	{{0x20000001,0x00000000,0x00000000},0x05e2,&ucs_strings_mb[1280]},
	{{0x00000201,0x00000000,0x00000000},0x3105,&ucs_strings[1548]},
	{{0x00000005,0x00000040,0x10000000},0x0180,&ucs_strings[1548]},
	{{0x80000003,0x00000040,0x00000000},0x0181,&ucs_strings[1548]},
	{{0x00000005,0x00040040,0x00000000},0x249d,&ucs_strings[1548]},
	{{0x00004003,0x00000040,0x00000000},0x24b7,&ucs_strings[1548]},
	{{0x00004005,0x00000040,0x00000000},0x24d1,&ucs_strings[1548]},
	{{0x0008000b,0x00000040,0x00000000},0x1e02,&ucs_strings[1548]},
	{{0x0008000d,0x00000040,0x00000000},0x1e03,&ucs_strings[1548]},
	{{0x00080103,0x00000040,0x00000000},0x1e04,&ucs_strings[1548]},
	{{0x00080105,0x00000040,0x00000000},0x1e05,&ucs_strings[1548]},
	{{0x00000103,0x00000240,0x00000000},0x1e06,&ucs_strings[1548]},
	{{0x00000105,0x00000240,0x00000000},0x1e07,&ucs_strings[1548]},
	{{0x00000000,0x00000000,0x00000000},0x24b7,&ucs_strings_mb[5317]},
	{{0x00000000,0x00000000,0x00000000},0x24d1,&ucs_strings_mb[5317]},
	{{0x00000000,0x00000000,0x00000000},0x0392,&ucs_strings_mb[673]},
	{{0x00000000,0x00000000,0x00000000},0x03b2,&ucs_strings_mb[673]},
	{{0x00000000,0x00000000,0x00000000},0x05d1,&ucs_strings_mb[1167]},
	{{0x00000000,0x00000000,0x00000000},0x0628,&ucs_strings_mb[1167]},
	{{0x00000000,0x00000000,0x00000000},0xfe91,&ucs_strings_mb[7031]},
	{{0x00000000,0x00000000,0x00000000},0xfe8f,&ucs_strings_mb[7023]},
	{{0x00000000,0x00000000,0x00000000},0xfe90,&ucs_strings_mb[7027]},
	{{0x00000000,0x00000000,0x00000000},0xfe92,&ucs_strings_mb[7035]},
	{{0x00000000,0x00000000,0x00000000},0x1e04,&ucs_strings_mb[1735]},
	{{0x00000000,0x00000000,0x00000000},0x1e05,&ucs_strings_mb[1735]},
	{{0x00000000,0x00000000,0x00000000},0x1e02,&ucs_strings_mb[1732]},
	{{0x00000000,0x00000000,0x00000000},0x1e03,&ucs_strings_mb[1732]},
	{{0x00000000,0x00000000,0x00000000},0x0180,&ucs_strings_mb[245]},
	{{0x00000000,0x00000000,0x00000000},0x0181,&ucs_strings_mb[248]},
	{{0x00000000,0x00000000,0x00000000},0x03d0,&ucs_strings_mb[833]},
	{{0x00000000,0x00000000,0x00000000},0x3105,&ucs_strings_mb[6790]},
	{{0x00000000,0x00000000,0x00000000},0x0411,&ucs_strings_mb[948]},
	{{0x00000000,0x00000000,0x00000000},0x0431,&ucs_strings_mb[948]},
	{{0x00000000,0x00000000,0x00000000},0x1e06,&ucs_strings_mb[1739]},
	{{0x00000000,0x00000000,0x00000000},0x1e07,&ucs_strings_mb[1739]},
	{{0x40000001,0x00000000,0x00000000},0x3070,&ucs_strings_mb[6618]},
	{{0x00000001,0x00000020,0x00000000},0x30d0,&ucs_strings_mb[6618]},
	{{0x00000000,0x00000000,0x00000000},0x2717,&ucs_strings_mb[6312]},
	{{0x00000000,0x00000001,0x00000000},0x2015,&ucs_strings[1674]},
	{{0x00200001,0x08000000,0x00002000},0x21a8,&ucs_strings_mb[3974]},
	{{0x00000000,0x00000000,0x00000000},0x2572,&ucs_strings_mb[5653]},
	{{0x00000000,0x00000000,0x00000000},0x25e3,&ucs_strings_mb[5653]},
	{{0x40000001,0x00000000,0x00000000},0x3079,&ucs_strings_mb[945]},
	{{0x00000001,0x00000020,0x00000000},0x30d9,&ucs_strings_mb[945]},
	{{0x00010003,0x00000000,0x00000000},0x0411,&ucs_strings_mb[945]},
	{{0x00010005,0x00000000,0x00000000},0x0431,&ucs_strings_mb[945]},
	{{0x00000000,0x00000000,0x00000000},0x266b,&ucs_strings_mb[6210]},
	{{0x00000000,0x00000000,0x00000000},0x266c,&ucs_strings_mb[6233]},
	{{0x00000000,0x00000000,0x00000000},0x2235,&ucs_strings_mb[4386]},
	{{0x00000081,0x00000000,0x00000000},0x0628,&ucs_strings_mb[1386]},
	{{0x00000081,0x00000010,0x00000000},0xfe8f,&ucs_strings_mb[1386]},
	{{0x01000081,0x00000000,0x00000000},0xfe90,&ucs_strings_mb[1386]},
	{{0x00000081,0x00000004,0x00000000},0xfe91,&ucs_strings_mb[1386]},
	{{0x00000081,0x00001000,0x00000000},0xfe92,&ucs_strings_mb[1386]},
	{{0x20000001,0x00000000,0x00000000},0x05d1,&ucs_strings_mb[1163]},
	{{0x08000003,0x00000000,0x00000000},0x0392,&ucs_strings_mb[668]},
	{{0x08000005,0x00000000,0x00000000},0x03b2,&ucs_strings_mb[668]},
	{{0x08000000,0x00000000,0x00000000},0x03d0,&ucs_strings_mb[821]},
	{{0x40000001,0x00000000,0x00000000},0x3073,&ucs_strings_mb[6621]},
	{{0x00000001,0x00000020,0x00000000},0x30d3,&ucs_strings_mb[6621]},
	{{0x02000000,0x00000000,0x00000000},0x2588,&ucs_strings_mb[5686]},
	{{0x00000000,0x00000080,0x00080000},0x258c,&ucs_strings_mb[5686]},
	{{0x00000000,0x00400000,0x00080000},0x2590,&ucs_strings_mb[5686]},
	{{0x40000001,0x00000000,0x00000000},0x307c,&ucs_strings_mb[6630]},
	{{0x00000001,0x00000020,0x00000000},0x30dc,&ucs_strings_mb[6630]},
	{{0x00000000,0x00000000,0x00080000},0x2321,&ucs_strings_mb[4748]},
	{{0x00000000,0x00000000,0x00000000},0x216a,&ucs_strings_mb[3730]},
	{{0x00000000,0x00000000,0x00000000},0x217a,&ucs_strings_mb[3730]},
	{{0x00000000,0x00000000,0x00040000},0x2446,&ucs_strings_mb[4813]},
	{{0x40000001,0x00000000,0x00000000},0x3076,&ucs_strings_mb[6627]},
	{{0x00000001,0x00000020,0x00000000},0x30d6,&ucs_strings_mb[6627]},
	{{0x00000000,0x00000000,0x00000000},0x2022,&ucs_strings_mb[3002]},
	{{0x00000000,0x00000000,0x00000000},0x2219,&ucs_strings_mb[4235]},
	{{0x00000000,0x00000000,0x00000000},0x25ce,&ucs_strings_mb[5957]},
	{{0x00000201,0x00000000,0x00000000},0x3118,&ucs_strings[1550]},
	{{0x00000013,0x00000040,0x00000000},0x0106,&ucs_strings[1550]},
	{{0x00000015,0x00000040,0x00000000},0x0107,&ucs_strings[1550]},
	{{0x00008003,0x00000040,0x00000000},0x0108,&ucs_strings[1550]},
	{{0x00008005,0x00000040,0x00000000},0x0109,&ucs_strings[1550]},
	{{0x00001003,0x00000040,0x00000000},0x010c,&ucs_strings[1550]},
	{{0x00001005,0x00000040,0x00000000},0x010d,&ucs_strings[1550]},
	{{0x80000003,0x00000040,0x00000000},0x0187,&ucs_strings[1550]},
	{{0x80000005,0x00000040,0x00000000},0x0188,&ucs_strings[1550]},
	{{0x00000005,0x00040040,0x00000000},0x249e,&ucs_strings[1550]},
	{{0x00004003,0x00000040,0x00000000},0x24b8,&ucs_strings[1550]},
	{{0x00004005,0x00000040,0x00000000},0x24d2,&ucs_strings[1550]},
	{{0x0008000b,0x00000040,0x00000000},0x010a,&ucs_strings[1550]},
	{{0x0008000d,0x00000040,0x00000000},0x010b,&ucs_strings[1550]},
	{{0x00002013,0x00000040,0x00000000},0x1e08,&ucs_strings[1550]},
	{{0x00002015,0x00000040,0x00000000},0x1e09,&ucs_strings[1550]},
	{{0x00000000,0x00000000,0x00000000},0x24b8,&ucs_strings_mb[5321]},
	{{0x00000000,0x00000000,0x00000000},0x24d2,&ucs_strings_mb[5321]},
	{{0x00000000,0x00000000,0x00000000},0x0427,&ucs_strings_mb[1063]},
	{{0x00000000,0x00000000,0x00000000},0x0447,&ucs_strings_mb[1063]},
	{{0x00000000,0x00000000,0x00000000},0x0106,&ucs_strings_mb[9]},
	{{0x00000000,0x00000000,0x00000000},0x0107,&ucs_strings_mb[9]},
	{{0x00000000,0x00000000,0x00000000},0x039e,&ucs_strings_mb[750]},
	{{0x00000000,0x00000000,0x00000000},0x03be,&ucs_strings_mb[750]},
	{{0x00000000,0x00000000,0x00000000},0x0635,&ucs_strings_mb[1473]},
	{{0x00000000,0x00000000,0x00000000},0xfebb,&ucs_strings_mb[7199]},
	{{0x00000000,0x00000000,0x00000000},0xfeb9,&ucs_strings_mb[7191]},
	{{0x00000000,0x00000000,0x00000000},0xfeba,&ucs_strings_mb[7195]},
	{{0x00000000,0x00000000,0x00000000},0xfebc,&ucs_strings_mb[7203]},
	{{0x00000000,0x00000000,0x00000000},0x1e08,&ucs_strings_mb[1742]},
	{{0x00000000,0x00000000,0x00000000},0x1e09,&ucs_strings_mb[1742]},
	{{0x00000000,0x00000000,0x00000000},0x010a,&ucs_strings_mb[15]},
	{{0x00000000,0x00000000,0x00000000},0x010b,&ucs_strings_mb[15]},
	{{0x00000000,0x00000000,0x00000000},0x0187,&ucs_strings_mb[251]},
	{{0x00000000,0x00000000,0x00000000},0x0188,&ucs_strings_mb[251]},
	{{0x00000000,0x00000000,0x00000000},0x0480,&ucs_strings_mb[1154]},
	{{0x00000000,0x00000000,0x00000000},0x0481,&ucs_strings_mb[1154]},
	{{0x00000000,0x00000000,0x00000000},0x3118,&ucs_strings_mb[6835]},
	{{0x00000000,0x00000000,0x00000000},0x010c,&ucs_strings_mb[18]},
	{{0x00000000,0x00000000,0x00000000},0x010d,&ucs_strings_mb[18]},
	{{0x00000000,0x00000000,0x00000000},0x0426,&ucs_strings_mb[1056]},
	{{0x00000000,0x00000000,0x00000000},0x0446,&ucs_strings_mb[1056]},
	{{0x00000000,0x00000000,0x00000000},0x0108,&ucs_strings_mb[12]},
	{{0x00000000,0x00000000,0x00000000},0x0109,&ucs_strings_mb[12]},
	{{0x00000000,0x00000000,0x00000000},0x2038,&ucs_strings_mb[3215]},
	{{0x00000000,0x00000000,0x00000001},0x2105,&ucs_strings_mb[3388]},
	{{0x00000000,0x00000000,0x00000000},0x2038,&ucs_strings_mb[3209]},
	{{0x00000000,0x00000000,0x00000000},0x2663,&ucs_strings[2180]},
	{{0x00000000,0x00000000,0x00000000},0x2667,&ucs_strings_mb[6171]},
	{{0x00000000,0x00000000,0x00000000},0x2662,&ucs_strings_mb[6151]},
	{{0x00000000,0x00000000,0x00000000},0x2666,&ucs_strings_mb[6167]},
	{{0x00000000,0x00000080,0x00000000},0x2308,&ucs_strings_mb[4643]},
	{{0x00000000,0x00400000,0x00000000},0x2309,&ucs_strings_mb[4643]},
	{{0x00000000,0x00000000,0x00000000},0x223e,&ucs_strings_mb[4430]},
	{{0x00000000,0x00000000,0x00000000},0x2661,&ucs_strings_mb[6148]},
	{{0x00000201,0x00000000,0x00000000},0x3114,&ucs_strings_mb[6148]},
	{{0x00000000,0x00000000,0x00000000},0x2665,&ucs_strings_mb[6163]},
	{{0x00000000,0x00000000,0x00040000},0x2441,&ucs_strings_mb[4793]},
	{{0x00010003,0x00000000,0x00000000},0x0427,&ucs_strings_mb[1059]},
	{{0x00010005,0x00000000,0x00000000},0x0447,&ucs_strings_mb[1059]},
	{{0x00000000,0x00000800,0x00000000},0x2713,&ucs_strings_mb[6303]},
	{{0x08000003,0x00000000,0x00000000},0x03a7,&ucs_strings_mb[792]},
	{{0x08000005,0x00000000,0x00000000},0x03c7,&ucs_strings_mb[792]},
	{{0x00000000,0x00000000,0x00000000},0x25ef,&ucs_strings[2362]},
	{{0x00000000,0x80000000,0x00000000},0x25cb,&ucs_strings_mb[5947]},
	{{0x00000000,0x00000000,0x00000004},0x25cf,&ucs_strings_mb[5947]},
	{{0x00000001,0x00000080,0x00080004},0x25d0,&ucs_strings_mb[5947]},
	{{0x00000001,0x00400000,0x00080004},0x25d1,&ucs_strings_mb[5947]},
	{{0x00000000,0x00000800,0x00000800},0x3006,&ucs_strings_mb[6412]},
	{{0x00000000,0x00000000,0x00008004},0x2663,&ucs_strings_mb[6154]},
	{{0x00000000,0x80000000,0x00008000},0x2667,&ucs_strings_mb[6154]},
	{{0x00000000,0x00000000,0x00000000},0x2105,&ucs_strings[2577]},
	{{0x04000000,0x00000000,0x00000000},0x0300,&ucs_strings_mb[540]},
	{{0x00000010,0x00000000,0x00000000},0x0301,&ucs_strings_mb[540]},
	{{0x00000008,0x00400000,0x00000000},0x20d1,&ucs_strings_mb[3352]},
	{{0x00000080,0x00000000,0x00000000},0x060c,&ucs_strings[1388]},
	{{0x00000000,0x00000000,0x00000800},0x3001,&ucs_strings[1388]},
	{{0x00000004,0x80000000,0x00000084},0x25a3,&ucs_strings_mb[5759]},
	{{0x00000000,0x00000000,0x00000000},0x220b,&ucs_strings_mb[4115]},
	{{0x00000000,0x00000000,0x00000000},0x222e,&ucs_strings_mb[4356]},
	{{0x00000000,0x00000080,0x00020000},0x300c,&ucs_strings_mb[6432]},
	{{0x00000000,0x00400000,0x00020000},0x300d,&ucs_strings_mb[6432]},
	{{0x00000000,0x80000080,0x00020000},0x300e,&ucs_strings_mb[6432]},
	{{0x00000000,0x80400000,0x00020000},0x300f,&ucs_strings_mb[6432]},
	{{0x00000000,0x00000000,0x00000000},0x216b,&ucs_strings[902]},
	{{0x00000000,0x00000000,0x00000000},0x217b,&ucs_strings[902]},
	{{0x00000000,0x00000000,0x00000000},0x2660,&ucs_strings_mb[6139]},
	{{0x00000000,0x00000000,0x00000000},0x2664,&ucs_strings_mb[6159]},
	{{0x00000000,0x00002000,0x00040000},0x2449,&ucs_strings_mb[4867]},
	{{0x00000201,0x00000000,0x00000000},0x3109,&ucs_strings[1552]},
	{{0x00001003,0x00000040,0x00000000},0x010e,&ucs_strings[1552]},
	{{0x00001005,0x00000040,0x00000000},0x010f,&ucs_strings[1552]},
	{{0x00000003,0x00000040,0x10000000},0x0110,&ucs_strings[1552]},
	{{0x00000005,0x00000040,0x10000000},0x0111,&ucs_strings[1552]},
	{{0x00002003,0x00000040,0x00000000},0x1e10,&ucs_strings[1552]},
	{{0x00002005,0x00000040,0x00000000},0x1e11,&ucs_strings[1552]},
	{{0x00000005,0x00040040,0x00000000},0x249f,&ucs_strings[1552]},
	{{0x00004003,0x00000040,0x00000000},0x24b9,&ucs_strings[1552]},
	{{0x00004005,0x00000040,0x00000000},0x24d3,&ucs_strings[1552]},
	{{0x0008000b,0x00000040,0x00000000},0x1e0a,&ucs_strings[1552]},
	{{0x0008000d,0x00000040,0x00000000},0x1e0b,&ucs_strings[1552]},
	{{0x00080103,0x00000040,0x00000000},0x1e0c,&ucs_strings[1552]},
	{{0x00080105,0x00000040,0x00000000},0x1e0d,&ucs_strings[1552]},
	{{0x00000103,0x00000240,0x00000000},0x1e0e,&ucs_strings[1552]},
	{{0x00000105,0x00000240,0x00000000},0x1e0f,&ucs_strings[1552]},
	{{0x00008103,0x00000040,0x00000000},0x1e12,&ucs_strings[1552]},
	{{0x00008105,0x00000040,0x00000000},0x1e13,&ucs_strings[1552]},
	{{0x00000000,0x00000000,0x00000000},0x24b9,&ucs_strings_mb[5325]},
	{{0x00000000,0x00000000,0x00000000},0x24d3,&ucs_strings_mb[5325]},
	{{0x00000007,0x00000040,0x00000000},0x01f2,&ucs_strings_mb[289]},
	{{0x00001007,0x00000040,0x00000000},0x01c5,&ucs_strings_mb[289]},
	{{0x00000000,0x00000000,0x00000000},0x0402,&ucs_strings_mb[882]},
	{{0x00000000,0x00000000,0x00000000},0x0452,&ucs_strings_mb[882]},
	{{0x00000000,0x00000000,0x00000000},0x0394,&ucs_strings_mb[691]},
	{{0x00000000,0x00000000,0x00000000},0x03b4,&ucs_strings_mb[691]},
	{{0x00000000,0x00000000,0x00000000},0x05d3,&ucs_strings_mb[1185]},
	{{0x00000000,0x00000000,0x00000000},0x062f,&ucs_strings_mb[1185]},
	{{0x00000000,0x00000000,0x00000000},0xfea9,&ucs_strings_mb[7127]},
	{{0x00000000,0x00000000,0x00000000},0xfeaa,&ucs_strings_mb[7131]},
	{{0x00000000,0x00000000,0x00000000},0x1e10,&ucs_strings_mb[1756]},
	{{0x00000000,0x00000000,0x00000000},0x1e11,&ucs_strings_mb[1756]},
	{{0x00000000,0x00000000,0x00000000},0x1e0c,&ucs_strings_mb[1749]},
	{{0x00000000,0x00000000,0x00000000},0x1e0d,&ucs_strings_mb[1749]},
	{{0x00000000,0x00000000,0x00000000},0x1e12,&ucs_strings_mb[1759]},
	{{0x00000000,0x00000000,0x00000000},0x1e13,&ucs_strings_mb[1759]},
	{{0x00000000,0x00000000,0x00000000},0x1e0a,&ucs_strings_mb[1746]},
	{{0x00000000,0x00000000,0x00000000},0x1e0b,&ucs_strings_mb[1746]},
	{{0x00000000,0x00000000,0x00000000},0x0110,&ucs_strings_mb[24]},
	{{0x00000000,0x00000000,0x00000000},0x0111,&ucs_strings_mb[24]},
	{{0x00000000,0x00000000,0x00000000},0x3109,&ucs_strings[1050]},
	{{0x00000000,0x00000000,0x00000000},0x010e,&ucs_strings_mb[21]},
	{{0x00000000,0x00000000,0x00000000},0x010f,&ucs_strings_mb[21]},
	{{0x00000000,0x00000000,0x00000000},0x0414,&ucs_strings_mb[967]},
	{{0x00000000,0x00000000,0x00000000},0x0434,&ucs_strings_mb[967]},
	{{0x00000000,0x00000000,0x00000000},0x1e0e,&ucs_strings_mb[1753]},
	{{0x00000000,0x00000000,0x00000000},0x1e0f,&ucs_strings_mb[1753]},
	{{0x40000001,0x00000000,0x00000000},0x3060,&ucs_strings_mb[6600]},
	{{0x00000001,0x00000020,0x00000000},0x30c0,&ucs_strings_mb[6600]},
	{{0x00000081,0x00000000,0x00000000},0x0636,&ucs_strings_mb[1476]},
	{{0x00000081,0x00000010,0x00000000},0xfebd,&ucs_strings_mb[1476]},
	{{0x01000081,0x00000000,0x00000000},0xfebe,&ucs_strings_mb[1476]},
	{{0x00000081,0x00000004,0x00000000},0xfebf,&ucs_strings_mb[1476]},
	{{0x00000081,0x00001000,0x00000000},0xfec0,&ucs_strings_mb[1476]},
	{{0x00000000,0x00000000,0x00000000},0x2020,&ucs_strings_mb[2989]},
	{{0x00100000,0x00000000,0x00000000},0x2021,&ucs_strings_mb[2989]},
	{{0x00000081,0x00000000,0x00000000},0x062f,&ucs_strings_mb[1434]},
	{{0x00000081,0x00000010,0x00000000},0xfea9,&ucs_strings_mb[1434]},
	{{0x01000081,0x00000000,0x00000000},0xfeaa,&ucs_strings_mb[1434]},
	{{0x20000001,0x00000000,0x00000000},0x05d3,&ucs_strings_mb[1179]},
	{{0x00000080,0x00000000,0x00000000},0x064f,&ucs_strings_mb[1611]},
	{{0x00000080,0x00000000,0x00000000},0x064c,&ucs_strings_mb[1578]},
	{{0x00000000,0x00000000,0x00000000},0x2593,&ucs_strings_mb[5723]},
	{{0x00000000,0x00000000,0x00040000},0x2448,&ucs_strings_mb[4859]},
	{{0x00000000,0x00000000,0x00000000},0x25c6,&ucs_strings_mb[5930]},
	{{0x00000000,0x00000000,0x00000000},0x0636,&ucs_strings_mb[1480]},
	{{0x00000000,0x00000000,0x00000000},0xfebf,&ucs_strings_mb[7215]},
	{{0x00000000,0x00000000,0x00000000},0xfebd,&ucs_strings_mb[7207]},
	{{0x00000000,0x00000000,0x00000000},0xfebe,&ucs_strings_mb[7211]},
	{{0x00000000,0x00000000,0x00000000},0xfec0,&ucs_strings_mb[7219]},
	{{0x00000000,0x00000000,0x00000000},0x2206,&ucs_strings_mb[964]},
	{{0x40000001,0x00000000,0x00000000},0x3067,&ucs_strings_mb[964]},
	{{0x00000001,0x00000020,0x00000000},0x30c7,&ucs_strings_mb[964]},
	{{0x00010003,0x00000000,0x00000000},0x0414,&ucs_strings_mb[964]},
	{{0x00010005,0x00000000,0x00000000},0x0434,&ucs_strings_mb[964]},
	{{0x00000000,0x00000000,0x00000000},0x2103,&ucs_strings_mb[3373]},
	{{0x00000000,0x00000000,0x00000000},0x2109,&ucs_strings_mb[3393]},
	{{0x08000003,0x00000000,0x00000000},0x0394,&ucs_strings_mb[685]},
	{{0x08000005,0x00000000,0x00000000},0x03b4,&ucs_strings_mb[685]},
	{{0x00000000,0x00000000,0x00000000},0x252c,&ucs_strings_mb[5568]},
	{{0x00000000,0x00000000,0x00000000},0x2564,&ucs_strings_mb[5568]},
	{{0x00000000,0x00000000,0x00000000},0x2565,&ucs_strings_mb[5568]},
	{{0x00000000,0x00000000,0x00000000},0x2566,&ucs_strings_mb[5568]},
	{{0x00000000,0x00000000,0x00000000},0x252f,&ucs_strings_mb[5579]},
	{{0x00000000,0x00000000,0x00000000},0x2530,&ucs_strings_mb[5579]},
	{{0x00000000,0x00000000,0x00000000},0x2533,&ucs_strings_mb[5579]},
	{{0x00000000,0x00000000,0x00000000},0x222c,&ucs_strings_mb[4353]},
	{{0x40000001,0x00000000,0x00000000},0x3062,&ucs_strings_mb[4353]},
	{{0x00000001,0x00000020,0x00000000},0x30c2,&ucs_strings_mb[4353]},
	{{0x00000001,0x00000000,0x00000080},0x25a9,&ucs_strings_mb[5837]},
	{{0x00400400,0x04400180,0x00000000},0x2571,&ucs_strings_mb[5625]},
	{{0x00400400,0x04400180,0x00000000},0x2572,&ucs_strings_mb[5625]},
	{{0x08000000,0x00000000,0x20000000},0x0385,&ucs_strings_mb[598]},
	{{0x08000001,0x00080000,0x00000000},0x1fc1,&ucs_strings_mb[598]},
	{{0x08000001,0x20000000,0x00000000},0x1fed,&ucs_strings_mb[598]},
	{{0x08000001,0x00020000,0x00000000},0x1fee,&ucs_strings_mb[598]},
	{{0x08000003,0x00000008,0x00000000},0x03aa,&ucs_strings_mb[598]},
	{{0x08000003,0x10000000,0x00000000},0x03ab,&ucs_strings_mb[598]},
	{{0x08000005,0x00000008,0x00000000},0x03ca,&ucs_strings_mb[598]},
	{{0x08000005,0x10000000,0x00000000},0x03cb,&ucs_strings_mb[598]},
	{{0x08000005,0x00000008,0x20000000},0x0390,&ucs_strings_mb[598]},
	{{0x08000005,0x10000000,0x20000000},0x03b0,&ucs_strings_mb[598]},
	{{0x08000005,0x20000008,0x00000000},0x1fd2,&ucs_strings_mb[598]},
	{{0x08000005,0x00020008,0x00000000},0x1fd3,&ucs_strings_mb[598]},
	{{0x08000005,0x00080008,0x00000000},0x1fd7,&ucs_strings_mb[598]},
	{{0x08000005,0x30000000,0x00000000},0x1fe2,&ucs_strings_mb[598]},
	{{0x08000005,0x10020000,0x00000000},0x1fe3,&ucs_strings_mb[598]},
	{{0x08000005,0x10080000,0x00000000},0x1fe7,&ucs_strings_mb[598]},
	{{0x00000000,0x00000000,0x00000004},0x25c6,&ucs_strings_mb[5922]},
	{{0x00000000,0x80000000,0x00000000},0x25c7,&ucs_strings_mb[5922]},
	{{0x00000000,0x80000000,0x00008000},0x2662,&ucs_strings_mb[5922]},
	{{0x00000000,0x00000000,0x00008004},0x2666,&ucs_strings_mb[5922]},
	{{0x08000001,0x00000000,0x00000000},0x03dc,&ucs_strings_mb[846]},
	{{0x00000000,0x00000800,0x00000000},0x3003,&ucs_strings_mb[6350]},
	{{0x00010003,0x00000000,0x00000000},0x0402,&ucs_strings_mb[878]},
	{{0x00010005,0x00000000,0x00000000},0x0452,&ucs_strings_mb[878]},
	{{0x00000000,0x00000000,0x00000000},0x0630,&ucs_strings_mb[1443]},
	{{0x00000000,0x00000000,0x00000000},0xfeab,&ucs_strings_mb[7135]},
	{{0x00000000,0x00000000,0x00000000},0xfeac,&ucs_strings_mb[7139]},
	{{0x00000000,0x00000000,0x00000000},0x2510,&ucs_strings[947]},
	{{0x00000000,0x00000000,0x00000000},0x2555,&ucs_strings[947]},
	{{0x00000000,0x00000000,0x00000000},0x2556,&ucs_strings[947]},
	{{0x00000000,0x00000000,0x00000000},0x2511,&ucs_strings_mb[5508]},
	{{0x00000000,0x00000000,0x00000000},0x2512,&ucs_strings_mb[5508]},
	{{0x00000000,0x00000000,0x00000000},0x252d,&ucs_strings_mb[5575]},
	{{0x00000000,0x00000000,0x00000000},0x252e,&ucs_strings_mb[5575]},
	{{0x00000000,0x00000000,0x00000000},0x2531,&ucs_strings_mb[5575]},
	{{0x00000000,0x00000000,0x00000000},0x2532,&ucs_strings_mb[5575]},
	{{0x40000001,0x00000000,0x00000000},0x3069,&ucs_strings[1327]},
	{{0x00000001,0x00000020,0x00000000},0x30c9,&ucs_strings[1327]},
	{{0x00000005,0x00000040,0x00000000},0x0131,&ucs_strings_mb[75]},
	{{0x00000000,0x00000000,0x00002000},0x2193,&ucs_strings_mb[3895]},
	{{0x00000000,0x00000000,0x00000000},0x2202,&ucs_strings_mb[4059]},
	{{0x00000000,0x00000000,0x00000000},0x250c,&ucs_strings_mb[5492]},
	{{0x00000000,0x00000000,0x00000000},0x2552,&ucs_strings_mb[5492]},
	{{0x00000000,0x00000000,0x00000000},0x2553,&ucs_strings_mb[5492]},
	{{0x00000000,0x00000000,0x00000000},0x2554,&ucs_strings_mb[5492]},
	{{0x00000000,0x00000000,0x00000000},0x250d,&ucs_strings_mb[5499]},
	{{0x00000000,0x00000000,0x00000000},0x250e,&ucs_strings_mb[5499]},
	{{0x00000000,0x00000000,0x00000000},0x250f,&ucs_strings_mb[5499]},
	{{0x00000000,0x00000000,0x00000000},0x0405,&ucs_strings_mb[899]},
	{{0x00000000,0x00000000,0x00000000},0x0455,&ucs_strings_mb[899]},
	{{0x00000000,0x00000000,0x00000000},0x25bc,&ucs_strings[1696]},
	{{0x00000000,0x00000000,0x00000000},0x25bd,&ucs_strings[1696]},
	{{0x40000001,0x00000000,0x00000000},0x3065,&ucs_strings_mb[6609]},
	{{0x00000001,0x00000020,0x00000000},0x30c5,&ucs_strings_mb[6609]},
	{{0x00000000,0x00000000,0x00000000},0x25c7,&ucs_strings_mb[5933]},
	{{0x00000000,0x00000000,0x00000000},0x040f,&ucs_strings_mb[282]},
	{{0x00000000,0x00000000,0x00000000},0x045f,&ucs_strings_mb[282]},
	{{0x00000003,0x00000040,0x00000000},0x01f1,&ucs_strings_mb[282]},
	{{0x00000005,0x00000040,0x00000000},0x01f3,&ucs_strings_mb[282]},
	{{0x00001003,0x00000040,0x00000000},0x01c4,&ucs_strings_mb[282]},
	{{0x00001005,0x00000040,0x00000000},0x01c6,&ucs_strings_mb[282]},
	{{0x00000000,0x00000000,0x00000000},0x01f1,&ucs_strings_mb[385]},
	{{0x00000000,0x00000000,0x00000000},0x01f2,&ucs_strings_mb[385]},
	{{0x00000000,0x00000000,0x00000000},0x01f3,&ucs_strings_mb[385]},
	{{0x00000000,0x00000000,0x00000000},0x01c4,&ucs_strings_mb[285]},
	{{0x00000000,0x00000000,0x00000000},0x01c5,&ucs_strings_mb[285]},
	{{0x00000000,0x00000000,0x00000000},0x01c6,&ucs_strings_mb[285]},
	{{0x00010003,0x00000000,0x00000000},0x0405,&ucs_strings_mb[895]},
	{{0x00010005,0x00000000,0x00000000},0x0455,&ucs_strings_mb[895]},
	{{0x00010003,0x00000000,0x00000000},0x040f,&ucs_strings_mb[937]},
	{{0x00010005,0x00000000,0x00000000},0x045f,&ucs_strings_mb[937]},
	{{0x40000001,0x00000000,0x00000000},0x3048,&ucs_strings[1554]},
	{{0x00000001,0x00000020,0x00000000},0x30a8,&ucs_strings[1554]},
	{{0x00000201,0x00000000,0x00000000},0x311c,&ucs_strings[1554]},
	{{0x00010003,0x00000000,0x00000000},0x042d,&ucs_strings[1554]},
	{{0x00010005,0x00000000,0x00000000},0x044d,&ucs_strings[1554]},
	{{0x40000005,0x00000000,0x00000000},0x3047,&ucs_strings[1554]},
	{{0x00000005,0x00000020,0x00000000},0x30a7,&ucs_strings[1554]},
	{{0x00000003,0x00000440,0x00000000},0x0112,&ucs_strings[1554]},
	{{0x00000005,0x00000440,0x00000000},0x0113,&ucs_strings[1554]},
	{{0x00000803,0x00000040,0x00000000},0x0114,&ucs_strings[1554]},
	{{0x00000805,0x00000040,0x00000000},0x0115,&ucs_strings[1554]},
	{{0x00000003,0x00000040,0x02000000},0x0118,&ucs_strings[1554]},
	{{0x00000005,0x00000040,0x02000000},0x0119,&ucs_strings[1554]},
	{{0x00001003,0x00000040,0x00000000},0x011a,&ucs_strings[1554]},
	{{0x00001005,0x00000040,0x00000000},0x011b,&ucs_strings[1554]},
	{{0x00000003,0x02000040,0x00000000},0x1ebc,&ucs_strings[1554]},
	{{0x00000005,0x02000040,0x00000000},0x1ebd,&ucs_strings[1554]},
	{{0x00000005,0x00040040,0x00000000},0x24a0,&ucs_strings[1554]},
	{{0x00004003,0x00000040,0x00000000},0x24ba,&ucs_strings[1554]},
	{{0x00004005,0x00000040,0x00000000},0x24d4,&ucs_strings[1554]},
	{{0x0008000b,0x00000040,0x00000000},0x0116,&ucs_strings[1554]},
	{{0x0008000d,0x00000040,0x00000000},0x0117,&ucs_strings[1554]},
	{{0x04100003,0x00000040,0x00000000},0x0204,&ucs_strings[1554]},
	{{0x04100005,0x00000040,0x00000000},0x0205,&ucs_strings[1554]},
	{{0x00000803,0x00000040,0x00800000},0x0206,&ucs_strings[1554]},
	{{0x00000805,0x00000040,0x00800000},0x0207,&ucs_strings[1554]},
	{{0x04000003,0x00000440,0x00000000},0x1e14,&ucs_strings[1554]},
	{{0x04000005,0x00000440,0x00000000},0x1e15,&ucs_strings[1554]},
	{{0x00000013,0x00000440,0x00000000},0x1e16,&ucs_strings[1554]},
	{{0x00000015,0x00000440,0x00000000},0x1e17,&ucs_strings[1554]},
	{{0x00008103,0x00000040,0x00000000},0x1e18,&ucs_strings[1554]},
	{{0x00008105,0x00000040,0x00000000},0x1e19,&ucs_strings[1554]},
	{{0x00000103,0x02000040,0x00000000},0x1e1a,&ucs_strings[1554]},
	{{0x00000105,0x02000040,0x00000000},0x1e1b,&ucs_strings[1554]},
	{{0x00002803,0x00000040,0x00000000},0x1e1c,&ucs_strings[1554]},
	{{0x00002805,0x00000040,0x00000000},0x1e1d,&ucs_strings[1554]},
	{{0x00080103,0x00000040,0x00000000},0x1eb8,&ucs_strings[1554]},
	{{0x00080105,0x00000040,0x00000000},0x1eb9,&ucs_strings[1554]},
	{{0x8000000b,0x00000040,0x00000000},0x1eba,&ucs_strings[1554]},
	{{0x8000000d,0x00000040,0x00000000},0x1ebb,&ucs_strings[1554]},
	{{0x00008013,0x00000040,0x00000000},0x1ebe,&ucs_strings[1554]},
	{{0x00008015,0x00000040,0x00000000},0x1ebf,&ucs_strings[1554]},
	{{0x04008003,0x00000040,0x00000000},0x1ec0,&ucs_strings[1554]},
	{{0x04008005,0x00000040,0x00000000},0x1ec1,&ucs_strings[1554]},
	{{0x00008003,0x02000040,0x00000000},0x1ec4,&ucs_strings[1554]},
	{{0x00008005,0x02000040,0x00000000},0x1ec5,&ucs_strings[1554]},
	{{0x8000800b,0x00000040,0x00000000},0x1ec2,&ucs_strings[1554]},
	{{0x8000800d,0x00000040,0x00000000},0x1ec3,&ucs_strings[1554]},
	{{0x00088103,0x00000040,0x00000000},0x1ec6,&ucs_strings[1554]},
	{{0x00088105,0x00000040,0x00000000},0x1ec7,&ucs_strings[1554]},
	{{0x00000000,0x00000000,0x00000000},0x24ba,&ucs_strings_mb[5329]},
	{{0x00000000,0x00000000,0x00000000},0x24d4,&ucs_strings_mb[5329]},
	{{0x00000000,0x00000000,0x00000000},0x0204,&ucs_strings_mb[411]},
	{{0x00000000,0x00000000,0x00000000},0x0205,&ucs_strings_mb[411]},
	{{0x00000000,0x00000000,0x00000000},0x0388,&ucs_strings_mb[636]},
	{{0x00000000,0x00000000,0x00000000},0x03ad,&ucs_strings_mb[636]},
	{{0x00000000,0x00000000,0x00000000},0x0114,&ucs_strings_mb[30]},
	{{0x00000000,0x00000000,0x00000000},0x0115,&ucs_strings_mb[30]},
	{{0x00000000,0x00000000,0x00000000},0x0206,&ucs_strings_mb[415]},
	{{0x00000000,0x00000000,0x00000000},0x0207,&ucs_strings_mb[415]},
	{{0x00000000,0x00000000,0x00000000},0x0395,&ucs_strings_mb[694]},
	{{0x00000000,0x00000000,0x00000000},0x03b5,&ucs_strings_mb[694]},
	{{0x00000000,0x00000000,0x00000000},0x1f72,&ucs_strings_mb[2429]},
	{{0x00000000,0x00000000,0x00000000},0x1fc8,&ucs_strings_mb[2696]},
	{{0x00000000,0x00000000,0x00000000},0x1f73,&ucs_strings_mb[2433]},
	{{0x00000000,0x00000000,0x00000000},0x1fc9,&ucs_strings_mb[2433]},
	{{0x00000000,0x00000000,0x00000000},0x1f10,&ucs_strings_mb[2213]},
	{{0x00000000,0x00000000,0x00000000},0x1f18,&ucs_strings_mb[2213]},
	{{0x00000000,0x00000000,0x00000000},0x1f12,&ucs_strings_mb[2221]},
	{{0x00000000,0x00000000,0x00000000},0x1f1a,&ucs_strings_mb[2221]},
	{{0x00000000,0x00000000,0x00000000},0x1f14,&ucs_strings_mb[2231]},
	{{0x00000000,0x00000000,0x00000000},0x1f1c,&ucs_strings_mb[2231]},
	{{0x00000000,0x00000000,0x00000000},0x1f11,&ucs_strings_mb[2217]},
	{{0x00000000,0x00000000,0x00000000},0x1f19,&ucs_strings_mb[2217]},
	{{0x00000000,0x00000000,0x00000000},0x1f13,&ucs_strings_mb[2226]},
	{{0x00000000,0x00000000,0x00000000},0x1f1b,&ucs_strings_mb[2226]},
	{{0x00000000,0x00000000,0x00000000},0x1f15,&ucs_strings_mb[2236]},
	{{0x00000000,0x00000000,0x00000000},0x1f1d,&ucs_strings_mb[2236]},
	{{0x00000000,0x00000000,0x00000000},0x05e2,&ucs_strings_mb[1285]},
	{{0x00000000,0x00000000,0x00000000},0x0639,&ucs_strings_mb[1285]},
	{{0x00000000,0x00000000,0x00000000},0xfecb,&ucs_strings_mb[7263]},
	{{0x00000000,0x00000000,0x00000000},0xfec9,&ucs_strings_mb[7255]},
	{{0x00000000,0x00000000,0x00000000},0xfeca,&ucs_strings_mb[7259]},
	{{0x00000000,0x00000000,0x00000000},0xfecc,&ucs_strings_mb[7267]},
	{{0x00000000,0x00000000,0x00000000},0x1e1c,&ucs_strings_mb[1779]},
	{{0x00000000,0x00000000,0x00000000},0x1e1d,&ucs_strings_mb[1779]},
	{{0x00000000,0x00000000,0x00000000},0x0112,&ucs_strings_mb[27]},
	{{0x00000000,0x00000000,0x00000000},0x0113,&ucs_strings_mb[27]},
	{{0x00000000,0x00000000,0x00000000},0x1e14,&ucs_strings_mb[1763]},
	{{0x00000000,0x00000000,0x00000000},0x1e15,&ucs_strings_mb[1763]},
	{{0x00000000,0x00000000,0x00000000},0x1e16,&ucs_strings_mb[1767]},
	{{0x00000000,0x00000000,0x00000000},0x1e17,&ucs_strings_mb[1767]},
	{{0x00000000,0x00000000,0x00000000},0x1eb8,&ucs_strings_mb[2047]},
	{{0x00000000,0x00000000,0x00000000},0x1eb9,&ucs_strings_mb[2047]},
	{{0x00000000,0x00000000,0x00000000},0x1e18,&ucs_strings_mb[1771]},
	{{0x00000000,0x00000000,0x00000000},0x1e19,&ucs_strings_mb[1771]},
	{{0x00000000,0x00000000,0x00000000},0x1e1a,&ucs_strings_mb[1775]},
	{{0x00000000,0x00000000,0x00000000},0x1e1b,&ucs_strings_mb[1775]},
	{{0x00000000,0x00000000,0x00000000},0x0116,&ucs_strings_mb[33]},
	{{0x00000000,0x00000000,0x00000000},0x0117,&ucs_strings_mb[33]},
	{{0x00000000,0x00000000,0x00000000},0x01dd,&ucs_strings_mb[352]},
	{{0x00000000,0x00000000,0x00000000},0x1eba,&ucs_strings_mb[2051]},
	{{0x00000000,0x00000000,0x00000000},0x1ebb,&ucs_strings_mb[2051]},
	{{0x00000000,0x00000000,0x00000000},0x311c,&ucs_strings_mb[6847]},
	{{0x00000000,0x00000000,0x00000000},0x3047,&ucs_strings_mb[6552]},
	{{0x00000000,0x00000000,0x00000000},0x3048,&ucs_strings_mb[6552]},
	{{0x00000000,0x00000000,0x00000000},0x30a7,&ucs_strings_mb[6744]},
	{{0x00000000,0x00000000,0x00000000},0x30a8,&ucs_strings_mb[6744]},
	{{0x00000000,0x00000000,0x00000000},0x0118,&ucs_strings_mb[36]},
	{{0x00000000,0x00000000,0x00000000},0x0119,&ucs_strings_mb[36]},
	{{0x00000000,0x00000000,0x00000000},0x011a,&ucs_strings_mb[39]},
	{{0x00000000,0x00000000,0x00000000},0x011b,&ucs_strings_mb[39]},
	{{0x00000000,0x00000000,0x00000000},0x0415,&ucs_strings_mb[970]},
	{{0x00000000,0x00000000,0x00000000},0x0435,&ucs_strings_mb[970]},
	{{0x00000000,0x00000000,0x00000000},0x1ec0,&ucs_strings_mb[2061]},
	{{0x00000000,0x00000000,0x00000000},0x1ec1,&ucs_strings_mb[2061]},
	{{0x00000000,0x00000000,0x00000000},0x1ebe,&ucs_strings_mb[2057]},
	{{0x00000000,0x00000000,0x00000000},0x1ebf,&ucs_strings_mb[2057]},
	{{0x00000000,0x00000000,0x00000000},0x1ec6,&ucs_strings_mb[2073]},
	{{0x00000000,0x00000000,0x00000000},0x1ec7,&ucs_strings_mb[2073]},
	{{0x00000000,0x00000000,0x00000000},0x1ec2,&ucs_strings_mb[2065]},
	{{0x00000000,0x00000000,0x00000000},0x1ec3,&ucs_strings_mb[2065]},
	{{0x00000000,0x00000000,0x00000000},0x1ec4,&ucs_strings_mb[2069]},
	{{0x00000000,0x00000000,0x00000000},0x1ec5,&ucs_strings_mb[2069]},
	{{0x00000000,0x00000000,0x00000000},0x1ebc,&ucs_strings_mb[2054]},
	{{0x00000000,0x00000000,0x00000000},0x1ebd,&ucs_strings_mb[2054]},
	{{0x00000000,0x00000000,0x00000000},0x01b7,&ucs_strings_mb[279]},
	{{0x00000000,0x00000000,0x00000000},0x0292,&ucs_strings_mb[279]},
	{{0x00010003,0x00000000,0x00000000},0x0424,&ucs_strings_mb[1040]},
	{{0x00010005,0x00000000,0x00000000},0x0444,&ucs_strings_mb[1040]},
	{{0x00000000,0x00000000,0x00000000},0x2302,&ucs_strings_mb[4640]},
	{{0x00000201,0x00000000,0x00000000},0x311d,&ucs_strings_mb[4640]},
	{{0x00000000,0x00000000,0x00000000},0x311d,&ucs_strings_mb[6850]},
	{{0x00000201,0x00000000,0x00000000},0x311f,&ucs_strings_mb[6857]},
	{{0x00000000,0x00000000,0x00000020},0x2078,&ucs_strings[1470]},
	{{0x00000000,0x00000000,0x00000040},0x2088,&ucs_strings[1470]},
	{{0x00004001,0x00000000,0x00000000},0x2467,&ucs_strings[1470]},
	{{0x00000001,0x00040000,0x00000000},0x247b,&ucs_strings[1470]},
	{{0x00000081,0x00000000,0x00000400},0x0668,&ucs_strings[1470]},
	{{0x00000000,0x00804000,0x00000000},0x2167,&ucs_strings[1470]},
	{{0x02000001,0x00000000,0x00000002},0x248f,&ucs_strings[1470]},
	{{0x00000000,0x00040000,0x00000800},0x3227,&ucs_strings[1470]},
	{{0x00000004,0x00804000,0x00000000},0x2177,&ucs_strings[1470]},
	{{0x00004000,0x00002000,0x00000000},0x2471,&ucs_strings_mb[5007]},
	{{0x00000000,0x00042000,0x00000000},0x2485,&ucs_strings_mb[5007]},
	{{0x02000000,0x00002000,0x00000002},0x2499,&ucs_strings_mb[5007]},
	{{0x00000000,0x00010000,0x00000018},0x215b,&ucs_strings_mb[3629]},
	{{0x00000000,0x00000000,0x00000000},0x266a,&ucs_strings_mb[6191]},
	{{0x00010003,0x00000000,0x00000000},0x041b,&ucs_strings_mb[998]},
	{{0x00010005,0x00000000,0x00000000},0x043b,&ucs_strings_mb[998]},
	{{0x00000000,0x00000000,0x00000001},0x2208,&ucs_strings_mb[4104]},
	{{0x00000000,0x00804000,0x00000000},0x216a,&ucs_strings_mb[3723]},
	{{0x00004000,0x00002000,0x00000000},0x246a,&ucs_strings_mb[3723]},
	{{0x00000000,0x00042000,0x00000000},0x247e,&ucs_strings_mb[3723]},
	{{0x00000004,0x00804000,0x00000000},0x217a,&ucs_strings_mb[3723]},
	{{0x02000000,0x00002000,0x00000002},0x2492,&ucs_strings_mb[3723]},
	{{0x00000000,0x00000001,0x00000000},0x2026,&ucs_strings_mb[3044]},
	{{0x00000000,0x40000000,0x00000000},0x22ee,&ucs_strings_mb[3044]},
	{{0x00000000,0x00000000,0x00000200},0x2003,&ucs_strings[1156]},
	{{0x00010003,0x00000000,0x00000000},0x041c,&ucs_strings[1156]},
	{{0x00010005,0x00000000,0x00000000},0x043c,&ucs_strings[1156]},
	{{0x00000000,0x00000000,0x00000000},0x2014,&ucs_strings_mb[2903]},
	{{0x00000000,0x00000000,0x00000000},0x2205,&ucs_strings_mb[4075]},
	{{0x00000000,0x00000000,0x00000200},0x2002,&ucs_strings_mb[1007]},
	{{0x00000201,0x00000000,0x00000000},0x3123,&ucs_strings_mb[1007]},
	{{0x00010003,0x00000000,0x00000000},0x041d,&ucs_strings_mb[1007]},
	{{0x00010005,0x00000000,0x00000000},0x043d,&ucs_strings_mb[1007]},
	{{0x00000000,0x00000000,0x00000000},0x2013,&ucs_strings_mb[2892]},
	{{0x00000201,0x00000000,0x00000000},0x3125,&ucs_strings_mb[153]},
	{{0x00000003,0x00000040,0x00000000},0x014a,&ucs_strings_mb[153]},
	{{0x00000005,0x00000040,0x00000000},0x014b,&ucs_strings_mb[153]},
	{{0x08000003,0x00000000,0x00000000},0x0395,&ucs_strings_mb[628]},
	{{0x08000005,0x00000000,0x00000000},0x03b5,&ucs_strings_mb[628]},
	{{0x08000003,0x00000000,0x20000000},0x0388,&ucs_strings_mb[628]},
	{{0x08000005,0x00000000,0x20000000},0x03ad,&ucs_strings_mb[628]},
	{{0x08000005,0x00200000,0x00000000},0x1f10,&ucs_strings_mb[628]},
	{{0x08020005,0x00000000,0x00000000},0x1f11,&ucs_strings_mb[628]},
	{{0x08000003,0x00200000,0x00000000},0x1f18,&ucs_strings_mb[628]},
	{{0x08020003,0x00000000,0x00000000},0x1f19,&ucs_strings_mb[628]},
	{{0x08000005,0x20000000,0x00000000},0x1f72,&ucs_strings_mb[628]},
	{{0x08000005,0x00020000,0x00000000},0x1f73,&ucs_strings_mb[628]},
	{{0x08000003,0x20000000,0x00000000},0x1fc8,&ucs_strings_mb[628]},
	{{0x08000003,0x00020000,0x00000000},0x1fc9,&ucs_strings_mb[628]},
	{{0x08000005,0x20200000,0x00000000},0x1f12,&ucs_strings_mb[628]},
	{{0x08020005,0x20000000,0x00000000},0x1f13,&ucs_strings_mb[628]},
	{{0x08000005,0x00220000,0x00000000},0x1f14,&ucs_strings_mb[628]},
	{{0x08020005,0x00020000,0x00000000},0x1f15,&ucs_strings_mb[628]},
	{{0x08000003,0x20200000,0x00000000},0x1f1a,&ucs_strings_mb[628]},
	{{0x08020003,0x20000000,0x00000000},0x1f1b,&ucs_strings_mb[628]},
	{{0x08000003,0x00220000,0x00000000},0x1f1c,&ucs_strings_mb[628]},
	{{0x08020003,0x00020000,0x00000000},0x1f1d,&ucs_strings_mb[628]},
	{{0x00000001,0x00000000,0x00000020},0x207c,&ucs_strings[1502]},
	{{0x00000001,0x00000000,0x00000040},0x208c,&ucs_strings[1502]},
	{{0x00000201,0x00000000,0x00000000},0x3126,&ucs_strings_mb[1022]},
	{{0x00010003,0x00000000,0x00000000},0x0420,&ucs_strings_mb[1022]},
	{{0x00010005,0x00000000,0x00000000},0x0440,&ucs_strings_mb[1022]},
	{{0x00010003,0x00000000,0x00000000},0x0421,&ucs_strings[1864]},
	{{0x00010005,0x00000000,0x00000000},0x0441,&ucs_strings[1864]},
	{{0x00000000,0x00000000,0x00000000},0x212e,&ucs_strings_mb[3524]},
	{{0x00000000,0x00000000,0x00000000},0x212e,&ucs_strings_mb[3507]},
	{{0x00000001,0x00000000,0x00000000},0x20ac,&ucs_strings_mb[3347]},
	{{0x00100000,0x00000800,0x00000000},0x203c,&ucs_strings[1292]},
	{{0x00000000,0x00000000,0x00000000},0x01ee,&ucs_strings_mb[379]},
	{{0x00000000,0x00000000,0x00000000},0x01ef,&ucs_strings_mb[379]},
	{{0x00000003,0x00000040,0x00000000},0x01b7,&ucs_strings_mb[275]},
	{{0x00000005,0x00000040,0x00000000},0x0292,&ucs_strings_mb[275]},
	{{0x00001003,0x00000040,0x00000000},0x01ee,&ucs_strings_mb[275]},
	{{0x00001005,0x00000040,0x00000000},0x01ef,&ucs_strings_mb[275]},
	{{0x00000201,0x00000000,0x00000000},0x3108,&ucs_strings[1556]},
	{{0x80000003,0x00000040,0x00000000},0x0191,&ucs_strings[1556]},
	{{0x80000005,0x00000040,0x00000000},0x0192,&ucs_strings[1556]},
	{{0x00000005,0x00040040,0x00000000},0x24a1,&ucs_strings[1556]},
	{{0x00004003,0x00000040,0x00000000},0x24bb,&ucs_strings[1556]},
	{{0x00004005,0x00000040,0x00000000},0x24d5,&ucs_strings[1556]},
	{{0x0008000b,0x00000040,0x00000000},0x1e1e,&ucs_strings[1556]},
	{{0x0008000d,0x00000040,0x00000000},0x1e1f,&ucs_strings[1556]},
	{{0x00000000,0x00000000,0x00000000},0x24bb,&ucs_strings_mb[5333]},
	{{0x00000000,0x00000000,0x00000000},0x24d5,&ucs_strings_mb[5333]},
	{{0x00000000,0x00000000,0x00000000},0x03a6,&ucs_strings_mb[789]},
	{{0x00000000,0x00000000,0x00000000},0x03c6,&ucs_strings_mb[789]},
	{{0x00000000,0x00000000,0x00000000},0x0641,&ucs_strings_mb[1522]},
	{{0x00000000,0x00000000,0x00000000},0xfed3,&ucs_strings_mb[7295]},
	{{0x00000000,0x00000000,0x00000000},0xfed1,&ucs_strings_mb[7287]},
	{{0x00000000,0x00000000,0x00000000},0xfed2,&ucs_strings_mb[7291]},
	{{0x00000000,0x00000000,0x00000000},0xfed4,&ucs_strings_mb[7299]},
	{{0x00000000,0x00000000,0x00000000},0x1e1e,&ucs_strings_mb[1783]},
	{{0x00000000,0x00000000,0x00000000},0x1e1f,&ucs_strings_mb[1783]},
	{{0x00000000,0x00000000,0x00000000},0x0191,&ucs_strings_mb[254]},
	{{0x00000000,0x00000000,0x00000000},0x0192,&ucs_strings_mb[254]},
	{{0x00000000,0x00000000,0x00000000},0x0472,&ucs_strings_mb[1140]},
	{{0x00000000,0x00000000,0x00000000},0x0473,&ucs_strings_mb[1140]},
	{{0x00000000,0x00000000,0x00000000},0x3108,&ucs_strings_mb[6799]},
	{{0x00000000,0x00000000,0x00000000},0x0424,&ucs_strings_mb[1043]},
	{{0x00000000,0x00000000,0x00000000},0x0444,&ucs_strings_mb[1043]},
	{{0x00000000,0x00000000,0x00000000},0x2200,&ucs_strings_mb[4035]},
	{{0x00000080,0x00000000,0x00000000},0x064e,&ucs_strings_mb[1602]},
	{{0x00000080,0x00000000,0x00000000},0x064b,&ucs_strings_mb[1566]},
	{{0x00000000,0x00000000,0x00000000},0x2588,&ucs_strings_mb[5692]},
	{{0x00000000,0x00000000,0x00000000},0x2571,&ucs_strings_mb[5646]},
	{{0x00000000,0x00000000,0x00000000},0x25e2,&ucs_strings_mb[5646]},
	{{0x00000081,0x00000000,0x00000000},0x0641,&ucs_strings_mb[1518]},
	{{0x00000081,0x00000010,0x00000000},0xfed1,&ucs_strings_mb[1518]},
	{{0x01000081,0x00000000,0x00000000},0xfed2,&ucs_strings_mb[1518]},
	{{0x00000081,0x00000004,0x00000000},0xfed3,&ucs_strings_mb[1518]},
	{{0x00000081,0x00001000,0x00000000},0xfed4,&ucs_strings_mb[1518]},
	{{0x00000001,0x00000000,0x00000000},0x2640,&ucs_strings_mb[6115]},
	{{0x00000000,0x00000000,0x00000000},0xfb00,&ucs_strings[883]},
	{{0x00000004,0x00000040,0x00000100},0xfb00,&ucs_strings[883]},
	{{0x00000000,0x00000000,0x00000000},0xfb03,&ucs_strings_mb[6966]},
	{{0x00000004,0x00000040,0x00000100},0xfb03,&ucs_strings_mb[6966]},
	{{0x00000000,0x00000000,0x00000000},0xfb04,&ucs_strings_mb[6970]},
	{{0x00000004,0x00000040,0x00000100},0xfb04,&ucs_strings_mb[6970]},
	{{0x00000000,0x00000000,0x00000000},0xfb01,&ucs_strings_mb[6960]},
	{{0x00000004,0x00000040,0x00000100},0xfb01,&ucs_strings_mb[6960]},
	{{0x00004000,0x00002000,0x00000000},0x246e,&ucs_strings_mb[4966]},
	{{0x00000000,0x00042000,0x00000000},0x2482,&ucs_strings_mb[4966]},
	{{0x02000000,0x00002000,0x00000002},0x2496,&ucs_strings_mb[4966]},
	{{0x00000000,0x00010000,0x00000018},0x2155,&ucs_strings_mb[3551]},
	{{0x00000000,0x00804000,0x00000000},0x216c,&ucs_strings_mb[3740]},
	{{0x00000004,0x00804000,0x00000000},0x217c,&ucs_strings_mb[3740]},
	{{0x00000001,0x00000001,0x00000080},0x25a4,&ucs_strings_mb[5773]},
	{{0x00000001,0x40000000,0x00000080},0x25a5,&ucs_strings_mb[5773]},
	{{0x00010003,0x00000000,0x00000000},0x0472,&ucs_strings_mb[1135]},
	{{0x00010005,0x00000000,0x00000000},0x0473,&ucs_strings_mb[1135]},
	{{0x00000000,0x00000000,0x00000020},0x2075,&ucs_strings[1455]},
	{{0x00000000,0x00000000,0x00000040},0x2085,&ucs_strings[1455]},
	{{0x00004001,0x00000000,0x00000000},0x2464,&ucs_strings[1455]},
	{{0x00000001,0x00040000,0x00000000},0x2478,&ucs_strings[1455]},
	{{0x00000081,0x00000000,0x00000400},0x0665,&ucs_strings[1455]},
	{{0x00000000,0x00804000,0x00000000},0x2164,&ucs_strings[1455]},
	{{0x02000001,0x00000000,0x00000002},0x248c,&ucs_strings[1455]},
	{{0x00000000,0x00040000,0x00000800},0x3224,&ucs_strings[1455]},
	{{0x00000004,0x00804000,0x00000000},0x2174,&ucs_strings[1455]},
	{{0x00000000,0x00000000,0x00000018},0x215d,&ucs_strings_mb[3656]},
	{{0x00000000,0x00804000,0x00000000},0x216e,&ucs_strings_mb[3763]},
	{{0x00000004,0x00804000,0x00000000},0x217e,&ucs_strings_mb[3763]},
	{{0x00000000,0x00000000,0x00000018},0x215a,&ucs_strings_mb[3614]},
	{{0x00000000,0x00804000,0x00000000},0x2181,&ucs_strings_mb[3817]},
	{{0x00000000,0x00000000,0x00000000},0xfb02,&ucs_strings_mb[6963]},
	{{0x00000004,0x00000040,0x00000100},0xfb02,&ucs_strings_mb[6963]},
	{{0x00000000,0x00000080,0x00000000},0x230a,&ucs_strings_mb[4657]},
	{{0x00000000,0x00400000,0x00000000},0x230b,&ucs_strings_mb[4657]},
	{{0x00000000,0x00000000,0x00000000},0x2640,&ucs_strings_mb[6122]},
	{{0x00000000,0x00000000,0x00000000},0x2200,&ucs_strings_mb[4027]},
	{{0x00000000,0x00000000,0x00040000},0x2442,&ucs_strings_mb[4802]},
	{{0x00000000,0x00000000,0x00840000},0x2443,&ucs_strings_mb[4802]},
	{{0x00000000,0x00000000,0x00000020},0x2074,&ucs_strings[1450]},
	{{0x00000000,0x00000000,0x00000040},0x2084,&ucs_strings[1450]},
	{{0x00004001,0x00000000,0x00000000},0x2463,&ucs_strings[1450]},
	{{0x00000001,0x00040000,0x00000000},0x2477,&ucs_strings[1450]},
	{{0x00000081,0x00000000,0x00000400},0x0664,&ucs_strings[1450]},
	{{0x00000000,0x00804000,0x00000000},0x2163,&ucs_strings[1450]},
	{{0x02000001,0x00000000,0x00000002},0x248b,&ucs_strings[1450]},
	{{0x00000000,0x00040000,0x00000800},0x3223,&ucs_strings[1450]},
	{{0x00000004,0x00804000,0x00000000},0x2173,&ucs_strings[1450]},
	{{0x00000000,0x00000000,0x00000018},0x2158,&ucs_strings_mb[3590]},
	{{0x00000000,0x00000000,0x00000200},0x2005,&ucs_strings_mb[2841]},
	{{0x00004000,0x00002000,0x00000000},0x246d,&ucs_strings_mb[4952]},
	{{0x00000000,0x00042000,0x00000000},0x2481,&ucs_strings_mb[4952]},
	{{0x02000000,0x00002000,0x00000002},0x2495,&ucs_strings_mb[4952]},
	{{0x00000000,0x00000000,0x00000000},0x220e,&ucs_strings_mb[4143]},
	{{0x00000001,0x00000000,0x00000000},0x20a3,&ucs_strings_mb[3315]},
	{{0x00000000,0x00000000,0x00000000},0x25a0,&ucs_strings[1206]},
	{{0x00000201,0x00000000,0x00000000},0x310d,&ucs_strings[1558]},
	{{0x00008003,0x00000040,0x00000000},0x011c,&ucs_strings[1558]},
	{{0x00008005,0x00000040,0x00000000},0x011d,&ucs_strings[1558]},
	{{0x00000803,0x00000040,0x00000000},0x011e,&ucs_strings[1558]},
	{{0x00000805,0x00000040,0x00000000},0x011f,&ucs_strings[1558]},
	{{0x00002003,0x00000040,0x00000000},0x0122,&ucs_strings[1558]},
	{{0x00002005,0x00000040,0x00000000},0x0123,&ucs_strings[1558]},
	{{0x00000003,0x00000040,0x10000000},0x01e4,&ucs_strings[1558]},
	{{0x00000005,0x00000040,0x10000000},0x01e5,&ucs_strings[1558]},
	{{0x00001003,0x00000040,0x00000000},0x01e6,&ucs_strings[1558]},
	{{0x00001005,0x00000040,0x00000000},0x01e7,&ucs_strings[1558]},
	{{0x00000013,0x00000040,0x00000000},0x01f4,&ucs_strings[1558]},
	{{0x00000015,0x00000040,0x00000000},0x01f5,&ucs_strings[1558]},
	{{0x00000003,0x00000440,0x00000000},0x1e20,&ucs_strings[1558]},
	{{0x00000005,0x00000440,0x00000000},0x1e21,&ucs_strings[1558]},
	{{0x00000005,0x00040040,0x00000000},0x24a2,&ucs_strings[1558]},
	{{0x00004003,0x00000040,0x00000000},0x24bc,&ucs_strings[1558]},
	{{0x00004005,0x00000040,0x00000000},0x24d6,&ucs_strings[1558]},
	{{0x0008000b,0x00000040,0x00000000},0x0120,&ucs_strings[1558]},
	{{0x0008000d,0x00000040,0x00000000},0x0121,&ucs_strings[1558]},
	{{0x00000000,0x00000000,0x00000000},0x24bc,&ucs_strings_mb[5337]},
	{{0x00000000,0x00000000,0x00000000},0x24d6,&ucs_strings_mb[5337]},
	{{0x00000000,0x00000000,0x00000000},0x0403,&ucs_strings_mb[889]},
	{{0x00000000,0x00000000,0x00000000},0x0453,&ucs_strings_mb[889]},
	{{0x00000000,0x00000000,0x00000000},0x01f4,&ucs_strings_mb[389]},
	{{0x00000000,0x00000000,0x00000000},0x01f5,&ucs_strings_mb[389]},
	{{0x00000000,0x00000000,0x00000000},0x011e,&ucs_strings_mb[45]},
	{{0x00000000,0x00000000,0x00000000},0x011f,&ucs_strings_mb[45]},
	{{0x00000000,0x00000000,0x00000000},0x0393,&ucs_strings_mb[682]},
	{{0x00000000,0x00000000,0x00000000},0x03b3,&ucs_strings_mb[682]},
	{{0x00000000,0x00000000,0x00000000},0x05d2,&ucs_strings_mb[1176]},
	{{0x00000000,0x00000000,0x00000000},0x062c,&ucs_strings_mb[1176]},
	{{0x00000000,0x00000000,0x00000000},0xfe9f,&ucs_strings_mb[7087]},
	{{0x00000000,0x00000000,0x00000000},0xfe9d,&ucs_strings_mb[7079]},
	{{0x00000000,0x00000000,0x00000000},0xfe9e,&ucs_strings_mb[7083]},
	{{0x00000000,0x00000000,0x00000000},0xfea0,&ucs_strings_mb[7091]},
	{{0x00000000,0x00000000,0x00000000},0x0122,&ucs_strings_mb[51]},
	{{0x00000000,0x00000000,0x00000000},0x0123,&ucs_strings_mb[51]},
	{{0x00000000,0x00000000,0x00000000},0x1e20,&ucs_strings_mb[1786]},
	{{0x00000000,0x00000000,0x00000000},0x1e21,&ucs_strings_mb[1786]},
	{{0x00000000,0x00000000,0x00000000},0x0120,&ucs_strings_mb[48]},
	{{0x00000000,0x00000000,0x00000000},0x0121,&ucs_strings_mb[48]},
	{{0x00000000,0x00000000,0x00000000},0x01e4,&ucs_strings_mb[364]},
	{{0x00000000,0x00000000,0x00000000},0x01e5,&ucs_strings_mb[364]},
	{{0x00000000,0x00000000,0x00000000},0x0490,&ucs_strings_mb[1157]},
	{{0x00000000,0x00000000,0x00000000},0x0491,&ucs_strings_mb[1157]},
	{{0x00000000,0x00000000,0x00000000},0x310d,&ucs_strings_mb[6811]},
	{{0x00000000,0x00000000,0x00000000},0x01e6,&ucs_strings_mb[367]},
	{{0x00000000,0x00000000,0x00000000},0x01e7,&ucs_strings_mb[367]},
	{{0x00000000,0x00000000,0x00000000},0x0413,&ucs_strings_mb[961]},
	{{0x00000000,0x00000000,0x00000000},0x0433,&ucs_strings_mb[961]},
	{{0x00000000,0x00000000,0x00000000},0x011c,&ucs_strings_mb[42]},
	{{0x00000000,0x00000000,0x00000000},0x011d,&ucs_strings_mb[42]},
	{{0x40000001,0x00000000,0x00000000},0x304c,&ucs_strings_mb[6558]},
	{{0x00000001,0x00000020,0x00000000},0x30ac,&ucs_strings_mb[6558]},
	{{0x00000081,0x00000000,0x00000000},0x06af,&ucs_strings_mb[1721]},
	{{0x08000003,0x00000000,0x00000000},0x0393,&ucs_strings_mb[676]},
	{{0x08000005,0x00000000,0x00000000},0x03b3,&ucs_strings_mb[676]},
	{{0x40000001,0x00000000,0x00000000},0x3052,&ucs_strings_mb[6576]},
	{{0x00000001,0x00000020,0x00000000},0x30b2,&ucs_strings_mb[6576]},
	{{0x00000000,0x00000800,0x00000000},0x3013,&ucs_strings_mb[6478]},
	{{0x00000000,0x00000000,0x00000000},0x06af,&ucs_strings_mb[1725]},
	{{0x00000081,0x00000000,0x00000000},0x063a,&ucs_strings_mb[1498]},
	{{0x00000081,0x00000010,0x00000000},0xfecd,&ucs_strings_mb[1498]},
	{{0x01000081,0x00000000,0x00000000},0xfece,&ucs_strings_mb[1498]},
	{{0x00000081,0x00000004,0x00000000},0xfecf,&ucs_strings_mb[1498]},
	{{0x00000081,0x00001000,0x00000000},0xfed0,&ucs_strings_mb[1498]},
	{{0x00010003,0x00000000,0x00000000},0x0413,&ucs_strings_mb[957]},
	{{0x00010005,0x00000000,0x00000000},0x0433,&ucs_strings_mb[957]},
	{{0x00010003,0x00000000,0x80000000},0x0490,&ucs_strings_mb[957]},
	{{0x00010005,0x00000000,0x80000000},0x0491,&ucs_strings_mb[957]},
	{{0x40000001,0x00000000,0x00000000},0x304e,&ucs_strings_mb[6564]},
	{{0x00000001,0x00000020,0x00000000},0x30ae,&ucs_strings_mb[6564]},
	{{0x20000001,0x00000000,0x00000000},0x05d2,&ucs_strings_mb[1170]},
	{{0x00010003,0x00000000,0x00000000},0x0403,&ucs_strings_mb[885]},
	{{0x00010005,0x00000000,0x00000000},0x0453,&ucs_strings_mb[885]},
	{{0x00000201,0x00000000,0x00000000},0x312c,&ucs_strings_mb[6879]},
	{{0x40000001,0x00000000,0x00000000},0x3054,&ucs_strings_mb[6582]},
	{{0x00000001,0x00000020,0x00000000},0x30b4,&ucs_strings_mb[6582]},
	{{0x00000000,0x04000000,0x00015000},0x2265,&ucs_strings[1509]},
	{{0x40000001,0x00000000,0x00000000},0x3050,&ucs_strings_mb[6570]},
	{{0x00000001,0x00000020,0x00000000},0x30b0,&ucs_strings_mb[6570]},
	{{0x00000201,0x00000000,0x00000000},0x310f,&ucs_strings[1560]},
	{{0x00008003,0x00000040,0x00000000},0x0124,&ucs_strings[1560]},
	{{0x00008005,0x00000040,0x00000000},0x0125,&ucs_strings[1560]},
	{{0x00000003,0x00000040,0x10000000},0x0126,&ucs_strings[1560]},
	{{0x00000005,0x00000040,0x10000000},0x0127,&ucs_strings[1560]},
	{{0x00040003,0x00000040,0x00000000},0x1e26,&ucs_strings[1560]},
	{{0x00040005,0x00000040,0x00000000},0x1e27,&ucs_strings[1560]},
	{{0x00002003,0x00000040,0x00000000},0x1e28,&ucs_strings[1560]},
	{{0x00002005,0x00000040,0x00000000},0x1e29,&ucs_strings[1560]},
	{{0x00000005,0x00040040,0x00000000},0x24a3,&ucs_strings[1560]},
	{{0x00004003,0x00000040,0x00000000},0x24bd,&ucs_strings[1560]},
	{{0x00004005,0x00000040,0x00000000},0x24d7,&ucs_strings[1560]},
	{{0x0008000b,0x00000040,0x00000000},0x1e22,&ucs_strings[1560]},
	{{0x0008000d,0x00000040,0x00000000},0x1e23,&ucs_strings[1560]},
	{{0x00080103,0x00000040,0x00000000},0x1e24,&ucs_strings[1560]},
	{{0x00080105,0x00000040,0x00000000},0x1e25,&ucs_strings[1560]},
	{{0x00000903,0x00000040,0x00000000},0x1e2a,&ucs_strings[1560]},
	{{0x00000905,0x00000040,0x00000000},0x1e2b,&ucs_strings[1560]},
	{{0x00000000,0x00000000,0x00000000},0x24bd,&ucs_strings_mb[5341]},
	{{0x00000000,0x00000000,0x00000000},0x24d7,&ucs_strings_mb[5341]},
	{{0x00000000,0x00000000,0x00000000},0x0621,&ucs_strings_mb[1345]},
	{{0x00000000,0x00000000,0x00000000},0xfe80,&ucs_strings_mb[6987]},
	{{0x00000000,0x00000000,0x00000000},0x0398,&ucs_strings_mb[714]},
	{{0x00000000,0x00000000,0x00000000},0x03b8,&ucs_strings_mb[714]},
	{{0x00000000,0x00000000,0x00000000},0x05d4,&ucs_strings_mb[1191]},
	{{0x00000000,0x00000000,0x00000000},0x0647,&ucs_strings_mb[1191]},
	{{0x00000000,0x00000000,0x00000000},0xfeeb,&ucs_strings_mb[7391]},
	{{0x00000000,0x00000000,0x00000000},0xfee9,&ucs_strings_mb[7383]},
	{{0x00000000,0x00000000,0x00000000},0xfeea,&ucs_strings_mb[7387]},
	{{0x00000000,0x00000000,0x00000000},0xfeec,&ucs_strings_mb[7395]},
	{{0x00000000,0x00000000,0x00000000},0x1e28,&ucs_strings_mb[1799]},
	{{0x00000000,0x00000000,0x00000000},0x1e29,&ucs_strings_mb[1799]},
	{{0x00000000,0x00000000,0x00000000},0x1e2a,&ucs_strings_mb[1802]},
	{{0x00000000,0x00000000,0x00000000},0x1e2b,&ucs_strings_mb[1802]},
	{{0x00000000,0x00000000,0x00000000},0x1e24,&ucs_strings_mb[1792]},
	{{0x00000000,0x00000000,0x00000000},0x1e25,&ucs_strings_mb[1792]},
	{{0x00000000,0x00000000,0x00000000},0x1e22,&ucs_strings_mb[1789]},
	{{0x00000000,0x00000000,0x00000000},0x1e23,&ucs_strings_mb[1789]},
	{{0x00000000,0x00000000,0x00000000},0x0126,&ucs_strings_mb[57]},
	{{0x00000000,0x00000000,0x00000000},0x0127,&ucs_strings_mb[57]},
	{{0x00000000,0x00000000,0x00000000},0x310f,&ucs_strings_mb[6817]},
	{{0x00000000,0x00000000,0x00000000},0x1e26,&ucs_strings_mb[1796]},
	{{0x00000000,0x00000000,0x00000000},0x1e27,&ucs_strings_mb[1796]},
	{{0x00000000,0x00000000,0x00000000},0x0425,&ucs_strings_mb[1049]},
	{{0x00000000,0x00000000,0x00000000},0x0445,&ucs_strings_mb[1049]},
	{{0x00000000,0x00000000,0x00000000},0x0124,&ucs_strings_mb[54]},
	{{0x00000000,0x00000000,0x00000000},0x0125,&ucs_strings_mb[54]},
	{{0x40000001,0x00000000,0x00000000},0x306f,&ucs_strings_mb[1046]},
	{{0x00000001,0x00000020,0x00000000},0x30cf,&ucs_strings_mb[1046]},
	{{0x00010003,0x00000000,0x00000000},0x0425,&ucs_strings_mb[1046]},
	{{0x00010005,0x00000000,0x00000000},0x0445,&ucs_strings_mb[1046]},
	{{0x00000081,0x00000000,0x00000000},0x062d,&ucs_strings_mb[1422]},
	{{0x00000081,0x00000010,0x00000000},0xfea1,&ucs_strings_mb[1422]},
	{{0x01000081,0x00000000,0x00000000},0xfea2,&ucs_strings_mb[1422]},
	{{0x00000081,0x00000004,0x00000000},0xfea3,&ucs_strings_mb[1422]},
	{{0x00000081,0x00001000,0x00000000},0xfea4,&ucs_strings_mb[1422]},
	{{0x00000089,0x00000000,0x00000000},0x0681,&ucs_strings_mb[1688]},
	{{0x00000000,0x00000000,0x00000200},0x200a,&ucs_strings_mb[2878]},
	{{0x00000081,0x00000000,0x00000000},0x0621,&ucs_strings_mb[1339]},
	{{0x00000081,0x00000010,0x00000000},0xfe80,&ucs_strings_mb[1339]},
	{{0x000000a9,0x00000000,0x00000000},0x0623,&ucs_strings_mb[1339]},
	{{0x000001a1,0x00000000,0x00000000},0x0625,&ucs_strings_mb[1339]},
	{{0x000000a9,0x00000010,0x00000000},0xfe83,&ucs_strings_mb[1339]},
	{{0x010000a9,0x00000000,0x00000000},0xfe84,&ucs_strings_mb[1339]},
	{{0x010001a1,0x00000000,0x00000000},0xfe88,&ucs_strings_mb[1339]},
	{{0x00000000,0x00040000,0x00000000},0x321c,&ucs_strings_mb[6882]},
	{{0x00010003,0x00000000,0x00000000},0x042a,&ucs_strings_mb[1079]},
	{{0x00010005,0x00000000,0x00000000},0x044a,&ucs_strings_mb[1079]},
	{{0x20000001,0x00000000,0x00000000},0x05d4,&ucs_strings_mb[1188]},
	{{0x40000001,0x00000000,0x00000000},0x3078,&ucs_strings_mb[1188]},
	{{0x00000001,0x00000020,0x00000000},0x30d8,&ucs_strings_mb[1188]},
	{{0x00000000,0x80000000,0x00008000},0x2661,&ucs_strings_mb[6142]},
	{{0x00000000,0x00000000,0x00008004},0x2665,&ucs_strings_mb[6142]},
	{{0x00000081,0x00000000,0x00000000},0x0647,&ucs_strings_mb[1543]},
	{{0x00000081,0x00000010,0x00000000},0xfee9,&ucs_strings_mb[1543]},
	{{0x01000081,0x00000000,0x00000000},0xfeea,&ucs_strings_mb[1543]},
	{{0x00000081,0x00000004,0x00000000},0xfeeb,&ucs_strings_mb[1543]},
	{{0x00000081,0x00001000,0x00000000},0xfeec,&ucs_strings_mb[1543]},
	{{0x20000001,0x00000000,0x00000000},0x05d7,&ucs_strings_mb[1210]},
	{{0x00000000,0x00000000,0x00000000},0x0681,&ucs_strings_mb[1698]},
	{{0x00000000,0x00000000,0x00000000},0x2500,&ucs_strings_mb[1698]},
	{{0x00000000,0x00000000,0x00000000},0x2550,&ucs_strings_mb[1698]},
	{{0x00000000,0x00000000,0x00000000},0x2501,&ucs_strings_mb[5424]},
	{{0x00000000,0x00000000,0x00000000},0x2253,&ucs_strings_mb[4505]},
	{{0x40000001,0x00000000,0x00000000},0x3072,&ucs_strings_mb[4505]},
	{{0x00000001,0x00000020,0x00000000},0x30d2,&ucs_strings_mb[4505]},
	{{0x00000000,0x01000800,0x00000000},0x201b,&ucs_strings_mb[2948]},
	{{0x00100000,0x00000800,0x00000000},0x201f,&ucs_strings_mb[2948]},
	{{0x00000000,0x00000000,0x00000000},0x062d,&ucs_strings_mb[1426]},
	{{0x00000000,0x00000000,0x00000000},0xfea3,&ucs_strings_mb[7103]},
	{{0x00000000,0x00000000,0x00000000},0xfea1,&ucs_strings_mb[7095]},
	{{0x00000000,0x00000000,0x00000000},0xfea2,&ucs_strings_mb[7099]},
	{{0x00000000,0x00000000,0x00000000},0xfea4,&ucs_strings_mb[7107]},
	{{0x40000001,0x00000000,0x00000000},0x307b,&ucs_strings[1742]},
	{{0x00000001,0x00000020,0x00000000},0x30db,&ucs_strings[1742]},
	{{0x00000000,0x00000000,0x00000000},0x2302,&ucs_strings_mb[4634]},
	{{0x40000001,0x00000000,0x00000000},0x3075,&ucs_strings_mb[6624]},
	{{0x00000001,0x00000020,0x00000000},0x30d5,&ucs_strings_mb[6624]},
	{{0x00000000,0x00814000,0x00000000},0x216d,&ucs_strings_mb[3750]},
	{{0x00000004,0x00814000,0x00000000},0x217d,&ucs_strings_mb[3750]},
	{{0x00000000,0x00000000,0x00000000},0x2010,&ucs_strings[1407]},
	{{0x00000000,0x00000000,0x00000000},0x2043,&ucs_strings_mb[3253]},
	{{0x00000000,0x00000000,0x00000000},0x2027,&ucs_strings_mb[3056]},
	{{0x40000001,0x00000000,0x00000000},0x3044,&ucs_strings[1562]},
	{{0x00000001,0x00000020,0x00000000},0x30a4,&ucs_strings[1562]},
	{{0x00000201,0x00000000,0x00000000},0x3127,&ucs_strings[1562]},
	{{0x00010003,0x00000000,0x00000000},0x0418,&ucs_strings[1562]},
	{{0x00010005,0x00000000,0x00000000},0x0438,&ucs_strings[1562]},
	{{0x40000005,0x00000000,0x00000000},0x3043,&ucs_strings[1562]},
	{{0x00000005,0x00000020,0x00000000},0x30a3,&ucs_strings[1562]},
	{{0x00000003,0x02000040,0x00000000},0x0128,&ucs_strings[1562]},
	{{0x00000005,0x02000040,0x00000000},0x0129,&ucs_strings[1562]},
	{{0x00000003,0x00000440,0x00000000},0x012a,&ucs_strings[1562]},
	{{0x00000005,0x00000440,0x00000000},0x012b,&ucs_strings[1562]},
	{{0x00000803,0x00000040,0x00000000},0x012c,&ucs_strings[1562]},
	{{0x00000805,0x00000040,0x00000000},0x012d,&ucs_strings[1562]},
	{{0x00000003,0x00000040,0x02000000},0x012e,&ucs_strings[1562]},
	{{0x00000005,0x00000040,0x02000000},0x012f,&ucs_strings[1562]},
	{{0x00001003,0x00000040,0x00000000},0x01cf,&ucs_strings[1562]},
	{{0x00001005,0x00000040,0x00000000},0x01d0,&ucs_strings[1562]},
	{{0x00010003,0x00000000,0x08000000},0x0419,&ucs_strings[1562]},
	{{0x00010005,0x00000000,0x08000000},0x0439,&ucs_strings[1562]},
	{{0x00000005,0x00040040,0x00000000},0x24a4,&ucs_strings[1562]},
	{{0x00004003,0x00000040,0x00000000},0x24be,&ucs_strings[1562]},
	{{0x00004005,0x00000040,0x00000000},0x24d8,&ucs_strings[1562]},
	{{0x0008000b,0x00000040,0x00000000},0x0130,&ucs_strings[1562]},
	{{0x04100003,0x00000040,0x00000000},0x0208,&ucs_strings[1562]},
	{{0x04100005,0x00000040,0x00000000},0x0209,&ucs_strings[1562]},
	{{0x00000803,0x00000040,0x00800000},0x020a,&ucs_strings[1562]},
	{{0x00000805,0x00000040,0x00800000},0x020b,&ucs_strings[1562]},
	{{0x00010003,0x00000000,0x40400000},0x0406,&ucs_strings[1562]},
	{{0x00010005,0x00000000,0x40400000},0x0456,&ucs_strings[1562]},
	{{0x00000103,0x02000040,0x00000000},0x1e2c,&ucs_strings[1562]},
	{{0x00000105,0x02000040,0x00000000},0x1e2d,&ucs_strings[1562]},
	{{0x00040013,0x00000040,0x00000000},0x1e2e,&ucs_strings[1562]},
	{{0x00040015,0x00000040,0x00000000},0x1e2f,&ucs_strings[1562]},
	{{0x8000000b,0x00000040,0x00000000},0x1ec8,&ucs_strings[1562]},
	{{0x8000000d,0x00000040,0x00000000},0x1ec9,&ucs_strings[1562]},
	{{0x00080103,0x00000040,0x00000000},0x1eca,&ucs_strings[1562]},
	{{0x00080105,0x00000040,0x00000000},0x1ecb,&ucs_strings[1562]},
	{{0x00000000,0x00000000,0x00000000},0x24be,&ucs_strings_mb[5345]},
	{{0x00000000,0x00000000,0x00000000},0x24d8,&ucs_strings_mb[5345]},
	{{0x00000000,0x00000000,0x00000000},0x0208,&ucs_strings_mb[418]},
	{{0x00000000,0x00000000,0x00000000},0x0209,&ucs_strings_mb[418]},
	{{0x00000000,0x00000000,0x00000000},0x038a,&ucs_strings_mb[642]},
	{{0x00000000,0x00000000,0x00000000},0x03af,&ucs_strings_mb[642]},
	{{0x00000000,0x00000000,0x00000000},0x012c,&ucs_strings_mb[66]},
	{{0x00000000,0x00000000,0x00000000},0x012d,&ucs_strings_mb[66]},
	{{0x00000000,0x00000000,0x00000000},0x020a,&ucs_strings_mb[422]},
	{{0x00000000,0x00000000,0x00000000},0x020b,&ucs_strings_mb[422]},
	{{0x00000000,0x00000000,0x00000000},0x0399,&ucs_strings_mb[717]},
	{{0x00000000,0x00000000,0x00000000},0x03b9,&ucs_strings_mb[717]},
	{{0x00000000,0x00000000,0x00000000},0x1f76,&ucs_strings_mb[2445]},
	{{0x00000000,0x00000000,0x00000000},0x1fda,&ucs_strings_mb[2445]},
	{{0x00000000,0x00000000,0x00000000},0x1f77,&ucs_strings_mb[2449]},
	{{0x00000000,0x00000000,0x00000000},0x1fdb,&ucs_strings_mb[2449]},
	{{0x00000000,0x00000000,0x00000000},0x1fd0,&ucs_strings_mb[2710]},
	{{0x00000000,0x00000000,0x00000000},0x1fd8,&ucs_strings_mb[2710]},
	{{0x00000000,0x00000000,0x00000000},0x1f30,&ucs_strings_mb[2279]},
	{{0x00000000,0x00000000,0x00000000},0x1f38,&ucs_strings_mb[2279]},
	{{0x00000000,0x00000000,0x00000000},0x1f32,&ucs_strings_mb[2287]},
	{{0x00000000,0x00000000,0x00000000},0x1f3a,&ucs_strings_mb[2287]},
	{{0x00000000,0x00000000,0x00000000},0x1f34,&ucs_strings_mb[2297]},
	{{0x00000000,0x00000000,0x00000000},0x1f3c,&ucs_strings_mb[2297]},
	{{0x00000000,0x00000000,0x00000000},0x1f36,&ucs_strings_mb[2307]},
	{{0x00000000,0x00000000,0x00000000},0x1f3e,&ucs_strings_mb[2307]},
	{{0x00000000,0x00000000,0x00000000},0x1fd1,&ucs_strings_mb[2714]},
	{{0x00000000,0x00000000,0x00000000},0x1fd9,&ucs_strings_mb[2714]},
	{{0x00000000,0x00000000,0x00000000},0x1fd2,&ucs_strings_mb[2718]},
	{{0x00000000,0x00000000,0x00000000},0x1fd3,&ucs_strings_mb[2723]},
	{{0x00000000,0x00000000,0x00000000},0x1fd7,&ucs_strings_mb[2732]},
	{{0x00000000,0x00000000,0x00000000},0x1f31,&ucs_strings_mb[2283]},
	{{0x00000000,0x00000000,0x00000000},0x1f39,&ucs_strings_mb[2283]},
	{{0x00000000,0x00000000,0x00000000},0x1f33,&ucs_strings_mb[2292]},
	{{0x00000000,0x00000000,0x00000000},0x1f3b,&ucs_strings_mb[2292]},
	{{0x00000000,0x00000000,0x00000000},0x1f35,&ucs_strings_mb[2302]},
	{{0x00000000,0x00000000,0x00000000},0x1f3d,&ucs_strings_mb[2302]},
	{{0x00000000,0x00000000,0x00000000},0x1f37,&ucs_strings_mb[2312]},
	{{0x00000000,0x00000000,0x00000000},0x1f3f,&ucs_strings_mb[2312]},
	{{0x00000000,0x00000000,0x00000000},0x1fd6,&ucs_strings_mb[2728]},
	{{0x00000000,0x00000000,0x00000000},0x063a,&ucs_strings_mb[1504]},
	{{0x00000000,0x00000000,0x00000000},0xfecf,&ucs_strings_mb[7279]},
	{{0x00000000,0x00000000,0x00000000},0xfecd,&ucs_strings_mb[7271]},
	{{0x00000000,0x00000000,0x00000000},0xfece,&ucs_strings_mb[7275]},
	{{0x00000000,0x00000000,0x00000000},0xfed0,&ucs_strings_mb[7283]},
	{{0x00000000,0x00000000,0x00000000},0x012a,&ucs_strings_mb[63]},
	{{0x00000000,0x00000000,0x00000000},0x012b,&ucs_strings_mb[63]},
	{{0x00000000,0x00000000,0x00000000},0x1eca,&ucs_strings_mb[2081]},
	{{0x00000000,0x00000000,0x00000000},0x1ecb,&ucs_strings_mb[2081]},
	{{0x00000000,0x00000000,0x00000000},0x1e2c,&ucs_strings_mb[1806]},
	{{0x00000000,0x00000000,0x00000000},0x1e2d,&ucs_strings_mb[1806]},
	{{0x00000000,0x00000000,0x00000000},0x0130,&ucs_strings_mb[72]},
	{{0x00000000,0x00000000,0x00000000},0x0131,&ucs_strings_mb[72]},
	{{0x00000000,0x00000000,0x00000000},0x1ec8,&ucs_strings_mb[2078]},
	{{0x00000000,0x00000000,0x00000000},0x1ec9,&ucs_strings_mb[2078]},
	{{0x00000000,0x00000000,0x00000000},0x0390,&ucs_strings_mb[662]},
	{{0x00000000,0x00000000,0x00000000},0x3127,&ucs_strings_mb[6870]},
	{{0x00000000,0x00000000,0x00000000},0x3043,&ucs_strings_mb[6546]},
	{{0x00000000,0x00000000,0x00000000},0x3044,&ucs_strings_mb[6546]},
	{{0x00000000,0x00000000,0x00000000},0x30a3,&ucs_strings_mb[6738]},
	{{0x00000000,0x00000000,0x00000000},0x30a4,&ucs_strings_mb[6738]},
	{{0x00000000,0x00000000,0x00000000},0x1e2e,&ucs_strings_mb[1810]},
	{{0x00000000,0x00000000,0x00000000},0x1e2f,&ucs_strings_mb[1810]},
	{{0x00000000,0x00000000,0x00000000},0x012e,&ucs_strings_mb[69]},
	{{0x00000000,0x00000000,0x00000000},0x012f,&ucs_strings_mb[69]},
	{{0x00000000,0x00000000,0x00000000},0x01cf,&ucs_strings_mb[318]},
	{{0x00000000,0x00000000,0x00000000},0x01d0,&ucs_strings_mb[318]},
	{{0x00000000,0x00000000,0x00000000},0x0418,&ucs_strings_mb[986]},
	{{0x00000000,0x00000000,0x00000000},0x0438,&ucs_strings_mb[986]},
	{{0x00000000,0x00000000,0x00000000},0x0128,&ucs_strings_mb[60]},
	{{0x00000000,0x00000000,0x00000000},0x0129,&ucs_strings_mb[60]},
	{{0x00000000,0x00000000,0x00000000},0x25d9,&ucs_strings_mb[6005]},
	{{0x00000000,0x04000000,0x00000000},0x2261,&ucs_strings_mb[4511]},
	{{0x00000000,0x00000000,0x00000000},0x0404,&ucs_strings_mb[892]},
	{{0x00000000,0x00000000,0x00000000},0x0454,&ucs_strings_mb[892]},
	{{0x00010003,0x00000000,0x00000000},0x0415,&ucs_strings_mb[892]},
	{{0x00010005,0x00000000,0x00000000},0x0435,&ucs_strings_mb[892]},
	{{0x00010003,0x00000000,0x40000000},0x0404,&ucs_strings_mb[892]},
	{{0x00010005,0x00000000,0x40000000},0x0454,&ucs_strings_mb[892]},
	{{0x00000000,0x00000000,0x00000000},0x0406,&ucs_strings_mb[902]},
	{{0x00000000,0x00000000,0x00000000},0x0456,&ucs_strings_mb[902]},
	{{0x00000000,0x00000000,0x00000000},0x0132,&ucs_strings_mb[85]},
	{{0x00000000,0x00000000,0x00000000},0x0133,&ucs_strings_mb[85]},
	{{0x00000002,0x00000040,0x00000100},0x0132,&ucs_strings_mb[85]},
	{{0x00000004,0x00000040,0x00000100},0x0133,&ucs_strings_mb[85]},
	{{0x00000000,0x00000000,0x00000000},0x2321,&ucs_strings_mb[4764]},
	{{0x00000000,0x04000000,0x00011001},0x2253,&ucs_strings_mb[4485]},
	{{0x00000000,0x00000000,0x00000000},0x222b,&ucs_strings[1804]},
	{{0x00000000,0x00000000,0x00000000},0x2206,&ucs_strings_mb[4088]},
	{{0x00000000,0x00000000,0x00000000},0x221e,&ucs_strings_mb[4275]},
	{{0x00000000,0x00000000,0x00000000},0x222b,&ucs_strings_mb[4344]},
	{{0x00100000,0x00000000,0x00000000},0x222c,&ucs_strings_mb[4344]},
	{{0x00000000,0x00000000,0x00000000},0x2229,&ucs_strings_mb[4319]},
	{{0x00000000,0x00000000,0x00000000},0x25d8,&ucs_strings_mb[5975]},
	{{0x00000000,0x80000000,0x00000000},0x25d9,&ucs_strings_mb[5990]},
	{{0x00000000,0x00000000,0x00000000},0x0401,&ucs_strings_mb[875]},
	{{0x00000000,0x00000000,0x00000000},0x0451,&ucs_strings_mb[875]},
	{{0x00000000,0x00000000,0x00000000},0x222e,&ucs_strings_mb[875]},
	{{0x00010003,0x00000000,0x00000000},0x0401,&ucs_strings_mb[875]},
	{{0x00010005,0x00000000,0x00000000},0x0451,&ucs_strings_mb[875]},
	{{0x00000000,0x00000000,0x00000000},0x3000,&ucs_strings_mb[6341]},
	{{0x00000000,0x00000800,0x00000800},0x3005,&ucs_strings_mb[6399]},
	{{0x40000000,0x00000800,0x00000000},0x309d,&ucs_strings_mb[6399]},
	{{0x00000000,0x00000820,0x00000000},0x30fd,&ucs_strings_mb[6399]},
	{{0x00000000,0x00000000,0x00000000},0x2320,&ucs_strings_mb[4745]},
	{{0x00000201,0x00000000,0x00000000},0x3129,&ucs_strings_mb[4745]},
	{{0x00010003,0x00000000,0x00000000},0x0474,&ucs_strings_mb[1143]},
	{{0x00010005,0x00000000,0x00000000},0x0475,&ucs_strings_mb[1143]},
	{{0x00000201,0x00000000,0x00000000},0x3110,&ucs_strings[1564]},
	{{0x00008003,0x00000040,0x00000000},0x0134,&ucs_strings[1564]},
	{{0x00008005,0x00000040,0x00000000},0x0135,&ucs_strings[1564]},
	{{0x00001005,0x00000040,0x00000000},0x01f0,&ucs_strings[1564]},
	{{0x00000005,0x00040040,0x00000000},0x24a5,&ucs_strings[1564]},
	{{0x00004003,0x00000040,0x00000000},0x24bf,&ucs_strings[1564]},
	{{0x00004005,0x00000040,0x00000000},0x24d9,&ucs_strings[1564]},
	{{0x00000000,0x00000000,0x00000000},0x24bf,&ucs_strings_mb[5349]},
	{{0x00000000,0x00000000,0x00000000},0x24d9,&ucs_strings_mb[5349]},
	{{0x00000000,0x00000000,0x00000000},0x0408,&ucs_strings_mb[911]},
	{{0x00000000,0x00000000,0x00000000},0x0458,&ucs_strings_mb[911]},
	{{0x00000000,0x00000000,0x00000000},0x03aa,&ucs_strings_mb[809]},
	{{0x00000000,0x00000000,0x00000000},0x03ca,&ucs_strings_mb[809]},
	{{0x00000000,0x00000000,0x00000000},0x05d9,&ucs_strings_mb[1228]},
	{{0x00000000,0x00000000,0x00000000},0x0649,&ucs_strings_mb[1228]},
	{{0x00000000,0x00000000,0x00000000},0xfeef,&ucs_strings_mb[7407]},
	{{0x00000000,0x00000000,0x00000000},0xfef0,&ucs_strings_mb[7411]},
	{{0x00000000,0x00000000,0x00000000},0x037a,&ucs_strings_mb[589]},
	{{0x00000000,0x00000000,0x00000000},0x1fbe,&ucs_strings_mb[589]},
	{{0x00000000,0x00000000,0x00000000},0x3110,&ucs_strings_mb[6820]},
	{{0x00000000,0x00000000,0x00000000},0x01f0,&ucs_strings_mb[382]},
	{{0x00000000,0x00000000,0x00000000},0x0419,&ucs_strings_mb[989]},
	{{0x00000000,0x00000000,0x00000000},0x0439,&ucs_strings_mb[989]},
	{{0x00000000,0x00000000,0x00000000},0x0134,&ucs_strings_mb[88]},
	{{0x00000000,0x00000000,0x00000000},0x0135,&ucs_strings_mb[88]},
	{{0x00000000,0x00000000,0x00000000},0x042f,&ucs_strings_mb[1112]},
	{{0x00000000,0x00000000,0x00000000},0x044f,&ucs_strings_mb[1112]},
	{{0x00000000,0x00000000,0x00000000},0x3004,&ucs_strings_mb[6359]},
	{{0x00000000,0x00000000,0x00000000},0x042d,&ucs_strings_mb[908]},
	{{0x00000000,0x00000000,0x00000000},0x044d,&ucs_strings_mb[908]},
	{{0x00010003,0x00000000,0x00000000},0x0408,&ucs_strings_mb[908]},
	{{0x00010005,0x00000000,0x00000000},0x0458,&ucs_strings_mb[908]},
	{{0x00000081,0x00000000,0x00000000},0x062c,&ucs_strings_mb[1417]},
	{{0x00000081,0x00000010,0x00000000},0xfe9d,&ucs_strings_mb[1417]},
	{{0x01000081,0x00000000,0x00000000},0xfe9e,&ucs_strings_mb[1417]},
	{{0x00000081,0x00000004,0x00000000},0xfe9f,&ucs_strings_mb[1417]},
	{{0x00000081,0x00001000,0x00000000},0xfea0,&ucs_strings_mb[1417]},
	{{0x00000081,0x00000000,0x00000000},0x0698,&ucs_strings_mb[1710]},
	{{0x00000000,0x00000000,0x00000000},0x3004,&ucs_strings_mb[6395]},
	{{0x00000000,0x00000000,0x00000000},0x042e,&ucs_strings_mb[1106]},
	{{0x00000000,0x00000000,0x00000000},0x044e,&ucs_strings_mb[1106]},
	{{0x00000201,0x00000000,0x00000000},0x310e,&ucs_strings[1566]},
	{{0x00002003,0x00000040,0x00000000},0x0136,&ucs_strings[1566]},
	{{0x00002005,0x00000040,0x00000000},0x0137,&ucs_strings[1566]},
	{{0x80000003,0x00000040,0x00000000},0x0198,&ucs_strings[1566]},
	{{0x80000005,0x00000040,0x00000000},0x0199,&ucs_strings[1566]},
	{{0x00001003,0x00000040,0x00000000},0x01e8,&ucs_strings[1566]},
	{{0x00001005,0x00000040,0x00000000},0x01e9,&ucs_strings[1566]},
	{{0x00000013,0x00000040,0x00000000},0x1e30,&ucs_strings[1566]},
	{{0x00000015,0x00000040,0x00000000},0x1e31,&ucs_strings[1566]},
	{{0x00000005,0x00040040,0x00000000},0x24a6,&ucs_strings[1566]},
	{{0x00004003,0x00000040,0x00000000},0x24c0,&ucs_strings[1566]},
	{{0x00004005,0x00000040,0x00000000},0x24da,&ucs_strings[1566]},
	{{0x00080103,0x00000040,0x00000000},0x1e32,&ucs_strings[1566]},
	{{0x00080105,0x00000040,0x00000000},0x1e33,&ucs_strings[1566]},
	{{0x00000103,0x00000240,0x00000000},0x1e34,&ucs_strings[1566]},
	{{0x00000105,0x00000240,0x00000000},0x1e35,&ucs_strings[1566]},
	{{0x00000000,0x00000000,0x00000000},0x24c0,&ucs_strings_mb[5353]},
	{{0x00000000,0x00000000,0x00000000},0x24da,&ucs_strings_mb[5353]},
	{{0x00000000,0x00000000,0x00000000},0x05da,&ucs_strings_mb[1235]},
	{{0x00000000,0x00000000,0x00000000},0x1e30,&ucs_strings_mb[1814]},
	{{0x00000000,0x00000000,0x00000000},0x1e31,&ucs_strings_mb[1814]},
	{{0x00000000,0x00000000,0x00000000},0x039a,&ucs_strings_mb[726]},
	{{0x00000000,0x00000000,0x00000000},0x03ba,&ucs_strings_mb[726]},
	{{0x00000000,0x00000000,0x00000000},0x05db,&ucs_strings_mb[1238]},
	{{0x00000000,0x00000000,0x00000000},0x0643,&ucs_strings_mb[1238]},
	{{0x00000000,0x00000000,0x00000000},0xfedb,&ucs_strings_mb[7327]},
	{{0x00000000,0x00000000,0x00000000},0xfed9,&ucs_strings_mb[7319]},
	{{0x00000000,0x00000000,0x00000000},0xfeda,&ucs_strings_mb[7323]},
	{{0x00000000,0x00000000,0x00000000},0xfedc,&ucs_strings_mb[7331]},
	{{0x00000000,0x00000000,0x00000000},0x0136,&ucs_strings_mb[91]},
	{{0x00000000,0x00000000,0x00000000},0x0137,&ucs_strings_mb[91]},
	{{0x00000000,0x00000000,0x00000000},0x1e32,&ucs_strings_mb[1817]},
	{{0x00000000,0x00000000,0x00000000},0x1e33,&ucs_strings_mb[1817]},
	{{0x00000000,0x00000000,0x00000000},0x0198,&ucs_strings_mb[257]},
	{{0x00000000,0x00000000,0x00000000},0x0199,&ucs_strings_mb[257]},
	{{0x00000000,0x00000000,0x00000000},0x03de,&ucs_strings_mb[863]},
	{{0x00000000,0x00000000,0x00000000},0x310e,&ucs_strings_mb[6814]},
	{{0x00000000,0x00000000,0x00000000},0x01e8,&ucs_strings_mb[370]},
	{{0x00000000,0x00000000,0x00000000},0x01e9,&ucs_strings_mb[370]},
	{{0x00000000,0x00000000,0x00000000},0x041a,&ucs_strings_mb[995]},
	{{0x00000000,0x00000000,0x00000000},0x043a,&ucs_strings_mb[995]},
	{{0x00000000,0x00000000,0x00000000},0x1e34,&ucs_strings_mb[1821]},
	{{0x00000000,0x00000000,0x00000000},0x1e35,&ucs_strings_mb[1821]},
	{{0x40000001,0x00000000,0x00000000},0x304b,&ucs_strings_mb[992]},
	{{0x00000001,0x00000020,0x00000000},0x30ab,&ucs_strings_mb[992]},
	{{0x00010003,0x00000000,0x00000000},0x041a,&ucs_strings_mb[992]},
	{{0x00010005,0x00000000,0x00000000},0x043a,&ucs_strings_mb[992]},
	{{0x00000005,0x00000020,0x00000000},0x30f5,&ucs_strings_mb[992]},
	{{0x20000001,0x00000000,0x00000000},0x05db,&ucs_strings_mb[1231]},
	{{0x00000081,0x00000000,0x00000000},0x0643,&ucs_strings_mb[1231]},
	{{0x21000001,0x00000000,0x00000000},0x05da,&ucs_strings_mb[1231]},
	{{0x00000081,0x00000010,0x00000000},0xfed9,&ucs_strings_mb[1231]},
	{{0x01000081,0x00000000,0x00000000},0xfeda,&ucs_strings_mb[1231]},
	{{0x00000081,0x00000004,0x00000000},0xfedb,&ucs_strings_mb[1231]},
	{{0x00000081,0x00001000,0x00000000},0xfedc,&ucs_strings_mb[1231]},
	{{0x08000003,0x00000000,0x00000000},0x039a,&ucs_strings_mb[720]},
	{{0x08000005,0x00000000,0x00000000},0x03ba,&ucs_strings_mb[720]},
	{{0x00000080,0x00000000,0x00000000},0x0650,&ucs_strings_mb[1620]},
	{{0x00000080,0x00000000,0x00000000},0x064d,&ucs_strings_mb[1590]},
	{{0x40000001,0x00000000,0x00000000},0x3051,&ucs_strings_mb[6573]},
	{{0x00000001,0x00000020,0x00000000},0x30b1,&ucs_strings_mb[6573]},
	{{0x00000005,0x00000020,0x00000000},0x30f6,&ucs_strings_mb[6573]},
	{{0x00000081,0x00000000,0x00000000},0x062e,&ucs_strings_mb[1429]},
	{{0x00000081,0x00000010,0x00000000},0xfea5,&ucs_strings_mb[1429]},
	{{0x01000081,0x00000000,0x00000000},0xfea6,&ucs_strings_mb[1429]},
	{{0x00000081,0x00000004,0x00000000},0xfea7,&ucs_strings_mb[1429]},
	{{0x00000081,0x00001000,0x00000000},0xfea8,&ucs_strings_mb[1429]},
	{{0x40000001,0x00000000,0x00000000},0x304d,&ucs_strings_mb[6561]},
	{{0x00000001,0x00000020,0x00000000},0x30ad,&ucs_strings_mb[6561]},
	{{0x00000000,0x00000000,0x00000000},0x040c,&ucs_strings_mb[931]},
	{{0x00000000,0x00000000,0x00000000},0x045c,&ucs_strings_mb[931]},
	{{0x00010003,0x00000000,0x00000000},0x040c,&ucs_strings_mb[927]},
	{{0x00010005,0x00000000,0x00000000},0x045c,&ucs_strings_mb[927]},
	{{0x00000000,0x00000000,0x00000000},0x0138,&ucs_strings_mb[98]},
	{{0x40000001,0x00000000,0x00000000},0x3053,&ucs_strings_mb[6579]},
	{{0x00000001,0x00000020,0x00000000},0x30b3,&ucs_strings_mb[6579]},
	{{0x08000001,0x00000000,0x00000000},0x03de,&ucs_strings_mb[857]},
	{{0x00010003,0x00000000,0x00000000},0x0480,&ucs_strings_mb[857]},
	{{0x00010005,0x00000000,0x00000000},0x0481,&ucs_strings_mb[857]},
	{{0x00000000,0x00000000,0x00000000},0x327f,&ucs_strings_mb[6933]},
	{{0x08000000,0x00000000,0x00000000},0x1fbd,&ucs_strings_mb[2653]},
	{{0x00000005,0x00000040,0x00000000},0x0138,&ucs_strings_mb[94]},
	{{0x00000000,0x00000000,0x00000000},0x327f,&ucs_strings_mb[6956]},
	{{0x40000001,0x00000000,0x00000000},0x304f,&ucs_strings_mb[6567]},
	{{0x00000001,0x00000020,0x00000000},0x30af,&ucs_strings_mb[6567]},
	{{0x00000201,0x00000000,0x00000000},0x310c,&ucs_strings[1568]},
	{{0x00000013,0x00000040,0x00000000},0x0139,&ucs_strings[1568]},
	{{0x00000015,0x00000040,0x00000000},0x013a,&ucs_strings[1568]},
	{{0x00002003,0x00000040,0x00000000},0x013b,&ucs_strings[1568]},
	{{0x00002005,0x00000040,0x00000000},0x013c,&ucs_strings[1568]},
	{{0x00001003,0x00000040,0x00000000},0x013d,&ucs_strings[1568]},
	{{0x00001005,0x00000040,0x00000000},0x013e,&ucs_strings[1568]},
	{{0x00000003,0x00000040,0x10000000},0x0141,&ucs_strings[1568]},
	{{0x00000005,0x00000040,0x10000000},0x0142,&ucs_strings[1568]},
	{{0x00000005,0x00040040,0x00000000},0x24a7,&ucs_strings[1568]},
	{{0x00004003,0x00000040,0x00000000},0x24c1,&ucs_strings[1568]},
	{{0x00004005,0x00000040,0x00000000},0x24db,&ucs_strings[1568]},
	{{0x00080003,0x00000040,0x01000000},0x013f,&ucs_strings[1568]},
	{{0x00080005,0x00000040,0x01000000},0x0140,&ucs_strings[1568]},
	{{0x00080103,0x00000040,0x00000000},0x1e36,&ucs_strings[1568]},
	{{0x00080105,0x00000040,0x00000000},0x1e37,&ucs_strings[1568]},
	{{0x00000103,0x00000240,0x00000000},0x1e3a,&ucs_strings[1568]},
	{{0x00000105,0x00000240,0x00000000},0x1e3b,&ucs_strings[1568]},
	{{0x00008103,0x00000040,0x00000000},0x1e3c,&ucs_strings[1568]},
	{{0x00008105,0x00000040,0x00000000},0x1e3d,&ucs_strings[1568]},
	{{0x00080103,0x00000440,0x00000000},0x1e38,&ucs_strings[1568]},
	{{0x00080105,0x00000440,0x00000000},0x1e39,&ucs_strings[1568]},
	{{0x00000007,0x00000040,0x00000000},0x01c8,&ucs_strings_mb[300]},
	{{0x00000000,0x00000000,0x00000000},0x24c1,&ucs_strings_mb[5357]},
	{{0x00000000,0x00000000,0x00000000},0x24db,&ucs_strings_mb[5357]},
	{{0x00000000,0x00000000,0x00000000},0x0139,&ucs_strings_mb[101]},
	{{0x00000000,0x00000000,0x00000000},0x013a,&ucs_strings_mb[101]},
	{{0x00000000,0x00000000,0x00000000},0x039b,&ucs_strings_mb[735]},
	{{0x00000000,0x00000000,0x00000000},0x03bb,&ucs_strings_mb[735]},
	{{0x00000000,0x00000000,0x00000000},0x05dc,&ucs_strings_mb[1247]},
	{{0x00000000,0x00000000,0x00000000},0x0644,&ucs_strings_mb[1247]},
	{{0x00000000,0x00000000,0x00000000},0xfedf,&ucs_strings_mb[7343]},
	{{0x00000000,0x00000000,0x00000000},0xfedd,&ucs_strings_mb[7335]},
	{{0x00000000,0x00000000,0x00000000},0xfede,&ucs_strings_mb[7339]},
	{{0x00000000,0x00000000,0x00000000},0xfee0,&ucs_strings_mb[7347]},
	{{0x00000000,0x00000000,0x00000000},0x013b,&ucs_strings_mb[104]},
	{{0x00000000,0x00000000,0x00000000},0x013c,&ucs_strings_mb[104]},
	{{0x00000000,0x00000000,0x00000000},0x1e38,&ucs_strings_mb[1828]},
	{{0x00000000,0x00000000,0x00000000},0x1e39,&ucs_strings_mb[1828]},
	{{0x00000000,0x00000000,0x00000000},0x1e36,&ucs_strings_mb[1824]},
	{{0x00000000,0x00000000,0x00000000},0x1e37,&ucs_strings_mb[1824]},
	{{0x00000000,0x00000000,0x00000000},0x1e3c,&ucs_strings_mb[1836]},
	{{0x00000000,0x00000000,0x00000000},0x1e3d,&ucs_strings_mb[1836]},
	{{0x00000000,0x00000000,0x00000000},0x013f,&ucs_strings_mb[110]},
	{{0x00000000,0x00000000,0x00000000},0x0140,&ucs_strings_mb[110]},
	{{0x00000000,0x00000000,0x00000000},0x0141,&ucs_strings_mb[113]},
	{{0x00000000,0x00000000,0x00000000},0x0142,&ucs_strings_mb[113]},
	{{0x00000000,0x00000000,0x00000000},0x310c,&ucs_strings_mb[6808]},
	{{0x00000000,0x00000000,0x00000000},0x013d,&ucs_strings_mb[107]},
	{{0x00000000,0x00000000,0x00000000},0x013e,&ucs_strings_mb[107]},
	{{0x00000000,0x00000000,0x00000000},0x041b,&ucs_strings_mb[1001]},
	{{0x00000000,0x00000000,0x00000000},0x043b,&ucs_strings_mb[1001]},
	{{0x00000000,0x00000000,0x00000000},0x1e3a,&ucs_strings_mb[1833]},
	{{0x00000000,0x00000000,0x00000000},0x1e3b,&ucs_strings_mb[1833]},
	{{0x00000000,0x00000000,0x00000000},0xfefb,&ucs_strings_mb[7467]},
	{{0x00000000,0x00000000,0x00000000},0xfefc,&ucs_strings_mb[7471]},
	{{0x00000081,0x00000000,0x00000000},0x0644,&ucs_strings_mb[1529]},
	{{0x00000081,0x00000010,0x00000000},0xfedd,&ucs_strings_mb[1529]},
	{{0x01000081,0x00000000,0x00000000},0xfede,&ucs_strings_mb[1529]},
	{{0x00000081,0x00000004,0x00000000},0xfedf,&ucs_strings_mb[1529]},
	{{0x00000081,0x00001000,0x00000000},0xfee0,&ucs_strings_mb[1529]},
	{{0x000000a1,0x00000010,0x00000100},0xfefb,&ucs_strings_mb[1529]},
	{{0x010000a1,0x00000000,0x00000100},0xfefc,&ucs_strings_mb[1529]},
	{{0x000000a9,0x00000010,0x00000100},0xfef7,&ucs_strings_mb[7449]},
	{{0x010000a9,0x00000000,0x00000100},0xfef8,&ucs_strings_mb[7449]},
	{{0x000001a1,0x00000010,0x00000100},0xfef9,&ucs_strings_mb[7449]},
	{{0x010001a1,0x00000000,0x00000100},0xfefa,&ucs_strings_mb[7449]},
	{{0x000000a9,0x00000010,0x00000100},0xfef5,&ucs_strings_mb[7431]},
	{{0x010000a9,0x00000000,0x00000100},0xfef6,&ucs_strings_mb[7431]},
	{{0x08000003,0x00000000,0x00000000},0x039b,&ucs_strings_mb[729]},
	{{0x08000005,0x00000000,0x00000000},0x03bb,&ucs_strings_mb[729]},
	{{0x20000001,0x00000000,0x00000000},0x05dc,&ucs_strings_mb[1241]},
	{{0x00000000,0x00000000,0x00000000},0x25ef,&ucs_strings_mb[6028]},
	{{0x00000000,0x00000000,0x00800000},0x223e,&ucs_strings_mb[4423]},
	{{0x00000000,0x00000000,0x00000000},0x2584,&ucs_strings_mb[5683]},
	{{0x00000000,0x00000000,0x00000000},0x258c,&ucs_strings_mb[5683]},
	{{0x00000000,0x00000000,0x00000000},0x2557,&ucs_strings_mb[5622]},
	{{0x00000000,0x00000000,0x00000000},0x2513,&ucs_strings_mb[5512]},
	{{0x00000000,0x00000000,0x00002000},0x2190,&ucs_strings_mb[3857]},
	{{0x00100000,0x00000000,0x00002000},0x21d0,&ucs_strings_mb[3857]},
	{{0x00000000,0x00000080,0x00020004},0x3010,&ucs_strings_mb[6451]},
	{{0x00000000,0x00400000,0x00020004},0x3011,&ucs_strings_mb[6451]},
	{{0x00000000,0x80000080,0x00020000},0x3016,&ucs_strings_mb[6451]},
	{{0x00000000,0x80400000,0x00020000},0x3017,&ucs_strings_mb[6451]},
	{{0x00000000,0x04000000,0x00015000},0x2264,&ucs_strings[1497]},
	{{0x00000000,0x00000000,0x00000000},0xfef7,&ucs_strings_mb[7459]},
	{{0x00000000,0x00000000,0x00000000},0xfef9,&ucs_strings_mb[7459]},
	{{0x00000000,0x00000000,0x00000000},0xfef8,&ucs_strings_mb[7463]},
	{{0x00000000,0x00000000,0x00000000},0xfefa,&ucs_strings_mb[7463]},
	{{0x00000000,0x00000000,0x00000000},0x2028,&ucs_strings_mb[3087]},
	{{0x00000001,0x00000000,0x00000000},0x20a4,&ucs_strings_mb[3328]},
	{{0x00000000,0x00000000,0x00000000},0x0409,&ucs_strings_mb[293]},
	{{0x00000000,0x00000000,0x00000000},0x0459,&ucs_strings_mb[293]},
	{{0x00000003,0x00000040,0x00000000},0x01c7,&ucs_strings_mb[293]},
	{{0x00000005,0x00000040,0x00000000},0x01c9,&ucs_strings_mb[293]},
	{{0x00000000,0x00000000,0x00000000},0x01c7,&ucs_strings_mb[296]},
	{{0x00000000,0x00000000,0x00000000},0x01c8,&ucs_strings_mb[296]},
	{{0x00000000,0x00000000,0x00000000},0x01c9,&ucs_strings_mb[296]},
	{{0x00010003,0x00000000,0x00000000},0x0409,&ucs_strings_mb[914]},
	{{0x00010005,0x00000000,0x00000000},0x0459,&ucs_strings_mb[914]},
	{{0x00000000,0x00000000,0x00000000},0xfef5,&ucs_strings_mb[7441]},
	{{0x00000000,0x00000000,0x00000000},0xfef6,&ucs_strings_mb[7445]},
	{{0x00000001,0x00000000,0x00000000},0x2227,&ucs_strings_mb[4308]},
	{{0x00000000,0x00000000,0x00010000},0x2228,&ucs_strings_mb[4308]},
	{{0x00000005,0x00000040,0x00000000},0x017f,&ucs_strings_mb[235]},
	{{0x00000004,0x00000040,0x00000100},0xfb05,&ucs_strings_mb[6974]},
	{{0x00100000,0x00000200,0x00000000},0x2017,&ucs_strings[1641]},
	{{0x00000000,0x01000800,0x00000000},0x201a,&ucs_strings_mb[2929]},
	{{0x00100000,0x00000800,0x00000000},0x201e,&ucs_strings_mb[2929]},
	{{0x08000001,0x00004000,0x00000000},0x0375,&ucs_strings_mb[566]},
	{{0x00000000,0x00000000,0x00080000},0x2584,&ucs_strings_mb[5671]},
	{{0x00000000,0x00400000,0x00000004},0x25e2,&ucs_strings_mb[6008]},
	{{0x00000000,0x00000080,0x00000004},0x25e3,&ucs_strings_mb[6008]},
	{{0x00000000,0x00000000,0x00000000},0x25ca,&ucs_strings_mb[5936]},
	{{0x00000000,0x00000000,0x00000000},0x200e,&ucs_strings_mb[2886]},
	{{0x00000000,0x00000000,0x00000000},0x25ca,&ucs_strings_mb[5944]},
	{{0x00000201,0x00000000,0x00000000},0x3107,&ucs_strings[1570]},
	{{0x00000013,0x00000040,0x00000000},0x1e3e,&ucs_strings[1570]},
	{{0x00000015,0x00000040,0x00000000},0x1e3f,&ucs_strings[1570]},
	{{0x00000005,0x00040040,0x00000000},0x24a8,&ucs_strings[1570]},
	{{0x00004003,0x00000040,0x00000000},0x24c2,&ucs_strings[1570]},
	{{0x00004005,0x00000040,0x00000000},0x24dc,&ucs_strings[1570]},
	{{0x0008000b,0x00000040,0x00000000},0x1e40,&ucs_strings[1570]},
	{{0x0008000d,0x00000040,0x00000000},0x1e41,&ucs_strings[1570]},
	{{0x00080103,0x00000040,0x00000000},0x1e42,&ucs_strings[1570]},
	{{0x00080105,0x00000040,0x00000000},0x1e43,&ucs_strings[1570]},
	{{0x00000000,0x00000000,0x00000000},0x24c2,&ucs_strings_mb[5361]},
	{{0x00000000,0x00000000,0x00000000},0x24dc,&ucs_strings_mb[5361]},
	{{0x00000000,0x00000000,0x00000000},0x05dd,&ucs_strings_mb[1254]},
	{{0x00000000,0x00000000,0x00000000},0x1e3e,&ucs_strings_mb[1840]},
	{{0x00000000,0x00000000,0x00000000},0x1e3f,&ucs_strings_mb[1840]},
	{{0x00000000,0x00000000,0x00000000},0x039c,&ucs_strings_mb[741]},
	{{0x00000000,0x00000000,0x00000000},0x03bc,&ucs_strings_mb[741]},
	{{0x00000000,0x00000000,0x00000000},0x05de,&ucs_strings_mb[1257]},
	{{0x00000000,0x00000000,0x00000000},0x0645,&ucs_strings_mb[1257]},
	{{0x00000000,0x00000000,0x00000000},0xfee3,&ucs_strings_mb[7359]},
	{{0x00000000,0x00000000,0x00000000},0xfee1,&ucs_strings_mb[7351]},
	{{0x00000000,0x00000000,0x00000000},0xfee2,&ucs_strings_mb[7355]},
	{{0x00000000,0x00000000,0x00000000},0xfee4,&ucs_strings_mb[7363]},
	{{0x00000000,0x00000000,0x00000000},0x1e42,&ucs_strings_mb[1846]},
	{{0x00000000,0x00000000,0x00000000},0x1e43,&ucs_strings_mb[1846]},
	{{0x00000000,0x00000000,0x00000000},0x1e40,&ucs_strings_mb[1843]},
	{{0x00000000,0x00000000,0x00000000},0x1e41,&ucs_strings_mb[1843]},
	{{0x00000000,0x00000000,0x00000000},0x266c,&ucs_strings_mb[6256]},
	{{0x00000000,0x00000000,0x00000000},0x266b,&ucs_strings_mb[6230]},
	{{0x00000000,0x00000000,0x00000000},0x03dc,&ucs_strings_mb[854]},
	{{0x00000000,0x00000000,0x00000000},0x3107,&ucs_strings_mb[6796]},
	{{0x00000000,0x00000000,0x00000000},0x266a,&ucs_strings_mb[6203]},
	{{0x00000000,0x00000000,0x00000000},0x041c,&ucs_strings_mb[1004]},
	{{0x00000000,0x00000000,0x00000000},0x043c,&ucs_strings_mb[1004]},
	{{0x40000001,0x00000000,0x00000000},0x307e,&ucs_strings_mb[6633]},
	{{0x00000001,0x00000020,0x00000000},0x30de,&ucs_strings_mb[6633]},
	{{0x000000a9,0x00000000,0x00000000},0x0622,&ucs_strings_mb[1348]},
	{{0x000000a9,0x00000010,0x00000000},0xfe81,&ucs_strings_mb[1348]},
	{{0x010000a9,0x00000000,0x00000000},0xfe82,&ucs_strings_mb[1348]},
	{{0x000000a1,0x00000000,0x00000000},0x0649,&ucs_strings_mb[1551]},
	{{0x000000a1,0x00000010,0x00000000},0xfeef,&ucs_strings_mb[1551]},
	{{0x010000a1,0x00000000,0x00000000},0xfef0,&ucs_strings_mb[1551]},
	{{0x00000001,0x00000000,0x00000000},0x2642,&ucs_strings_mb[6125]},
	{{0x00000000,0x00000000,0x00000000},0x2720,&ucs_strings_mb[6324]},
	{{0x00000000,0x00000000,0x00000000},0x266d,&ucs_strings_mb[6271]},
	{{0x00000000,0x00000000,0x00000000},0x2669,&ucs_strings_mb[6188]},
	{{0x40000001,0x00000000,0x00000000},0x3081,&ucs_strings_mb[6639]},
	{{0x00000001,0x00000020,0x00000000},0x30e1,&ucs_strings_mb[6639]},
	{{0x00000000,0x00000000,0x00000000},0x2592,&ucs_strings_mb[5707]},
	{{0x00000081,0x00000000,0x00000000},0x0645,&ucs_strings_mb[1533]},
	{{0x00000081,0x00000010,0x00000000},0xfee1,&ucs_strings_mb[1533]},
	{{0x01000081,0x00000000,0x00000000},0xfee2,&ucs_strings_mb[1533]},
	{{0x00000081,0x00000004,0x00000000},0xfee3,&ucs_strings_mb[1533]},
	{{0x00000081,0x00001000,0x00000000},0xfee4,&ucs_strings_mb[1533]},
	{{0x20000001,0x00000000,0x00000000},0x05de,&ucs_strings_mb[1250]},
	{{0x21000001,0x00000000,0x00000000},0x05dd,&ucs_strings_mb[1250]},
	{{0x40000001,0x00000000,0x00000000},0x307f,&ucs_strings_mb[6636]},
	{{0x00000001,0x00000020,0x00000000},0x30df,&ucs_strings_mb[6636]},
	{{0x00000001,0x00000000,0x00000000},0x2212,&ucs_strings_mb[3297]},
	{{0x00000000,0x00000000,0x00000020},0x207b,&ucs_strings_mb[3297]},
	{{0x00000000,0x00000000,0x00000040},0x208b,&ucs_strings_mb[3297]},
	{{0x00000001,0x00000000,0x00010000},0x2213,&ucs_strings_mb[4185]},
	{{0x00000000,0x00000000,0x00000000},0x2642,&ucs_strings_mb[6130]},
	{{0x40000001,0x00000000,0x00000000},0x3082,&ucs_strings_mb[6642]},
	{{0x00000001,0x00000020,0x00000000},0x30e2,&ucs_strings_mb[6642]},
	{{0x00000001,0x00000400,0x00000000},0x02c9,&ucs_strings_mb[507]},
	{{0x00008001,0x00000000,0x00000000},0x02c6,&ucs_strings_mb[485]},
	{{0x04000001,0x00000000,0x00000000},0x02cb,&ucs_strings_mb[485]},
	{{0x00000001,0x00000000,0x00000000},0x02bb,&ucs_strings_mb[460]},
	{{0x40000001,0x00000000,0x00000000},0x3080,&ucs_strings_mb[738]},
	{{0x00000001,0x00000020,0x00000000},0x30e0,&ucs_strings_mb[738]},
	{{0x08000003,0x00000000,0x00000000},0x039c,&ucs_strings_mb[738]},
	{{0x08000005,0x00000000,0x00000000},0x03bc,&ucs_strings_mb[738]},
	{{0x00000000,0x00000000,0x00004000},0x226b,&ucs_strings_mb[4543]},
	{{0x00000000,0x00000000,0x00004000},0x226a,&ucs_strings_mb[4530]},
	{{0x00000001,0x00000000,0x00000000},0x266d,&ucs_strings_mb[6260]},
	{{0x00000001,0x00000000,0x00000000},0x266e,&ucs_strings_mb[6274]},
	{{0x00000001,0x00000000,0x00000000},0x266f,&ucs_strings_mb[6291]},
	{{0x00000000,0x00000000,0x00000000},0x266e,&ucs_strings_mb[6288]},
	{{0x00000000,0x00000000,0x00000000},0x266f,&ucs_strings_mb[6288]},
	{{0x40000001,0x00000000,0x00000000},0x3093,&ucs_strings[1572]},
	{{0x00000001,0x00000020,0x00000000},0x30f3,&ucs_strings[1572]},
	{{0x00000201,0x00000000,0x00000000},0x310b,&ucs_strings[1572]},
	{{0x00000013,0x00000040,0x00000000},0x0143,&ucs_strings[1572]},
	{{0x00000015,0x00000040,0x00000000},0x0144,&ucs_strings[1572]},
	{{0x00002003,0x00000040,0x00000000},0x0145,&ucs_strings[1572]},
	{{0x00002005,0x00000040,0x00000000},0x0146,&ucs_strings[1572]},
	{{0x00001003,0x00000040,0x00000000},0x0147,&ucs_strings[1572]},
	{{0x00001005,0x00000040,0x00000000},0x0148,&ucs_strings[1572]},
	{{0x00000005,0x00000040,0x00000020},0x207f,&ucs_strings[1572]},
	{{0x00000005,0x00040040,0x00000000},0x24a9,&ucs_strings[1572]},
	{{0x00004003,0x00000040,0x00000000},0x24c3,&ucs_strings[1572]},
	{{0x00004005,0x00000040,0x00000000},0x24dd,&ucs_strings[1572]},
	{{0x0008000b,0x00000040,0x00000000},0x1e44,&ucs_strings[1572]},
	{{0x0008000d,0x00000040,0x00000000},0x1e45,&ucs_strings[1572]},
	{{0x00080103,0x00000040,0x00000000},0x1e46,&ucs_strings[1572]},
	{{0x00080105,0x00000040,0x00000000},0x1e47,&ucs_strings[1572]},
	{{0x00000103,0x00000240,0x00000000},0x1e48,&ucs_strings[1572]},
	{{0x00000105,0x00000240,0x00000000},0x1e49,&ucs_strings[1572]},
	{{0x00008103,0x00000040,0x00000000},0x1e4a,&ucs_strings[1572]},
	{{0x00008105,0x00000040,0x00000000},0x1e4b,&ucs_strings[1572]},
	{{0x00000000,0x00000000,0x00000000},0x220f,&ucs_strings_mb[4146]},
	{{0x00000000,0x00000000,0x00000000},0x2211,&ucs_strings_mb[4163]},
	{{0x00000007,0x00000040,0x00000000},0x01cb,&ucs_strings_mb[311]},
	{{0x00000000,0x00000000,0x00000000},0x24c3,&ucs_strings_mb[5365]},
	{{0x00000000,0x00000000,0x00000000},0x24dd,&ucs_strings_mb[5365]},
	{{0x00000005,0x00000040,0x00000000},0x0149,&ucs_strings_mb[125]},
	{{0x00000000,0x00000000,0x00000000},0x05df,&ucs_strings_mb[1264]},
	{{0x00000000,0x00000000,0x00000000},0x0143,&ucs_strings_mb[116]},
	{{0x00000000,0x00000000,0x00000000},0x0144,&ucs_strings_mb[116]},
	{{0x00000000,0x00000000,0x00000000},0x039d,&ucs_strings_mb[744]},
	{{0x00000000,0x00000000,0x00000000},0x03bd,&ucs_strings_mb[744]},
	{{0x00000000,0x00000000,0x00000000},0x05e0,&ucs_strings_mb[1267]},
	{{0x00000000,0x00000000,0x00000000},0x0646,&ucs_strings_mb[1267]},
	{{0x00000000,0x00000000,0x00000000},0xfee7,&ucs_strings_mb[7375]},
	{{0x00000000,0x00000000,0x00000000},0xfee5,&ucs_strings_mb[7367]},
	{{0x00000000,0x00000000,0x00000000},0xfee6,&ucs_strings_mb[7371]},
	{{0x00000000,0x00000000,0x00000000},0xfee8,&ucs_strings_mb[7379]},
	{{0x00000000,0x00000000,0x00000000},0x0145,&ucs_strings_mb[119]},
	{{0x00000000,0x00000000,0x00000000},0x0146,&ucs_strings_mb[119]},
	{{0x00000000,0x00000000,0x00000000},0x1e46,&ucs_strings_mb[1853]},
	{{0x00000000,0x00000000,0x00000000},0x1e47,&ucs_strings_mb[1853]},
	{{0x00000000,0x00000000,0x00000000},0x1e4a,&ucs_strings_mb[1860]},
	{{0x00000000,0x00000000,0x00000000},0x1e4b,&ucs_strings_mb[1860]},
	{{0x00000000,0x00000000,0x00000000},0x1e44,&ucs_strings_mb[1850]},
	{{0x00000000,0x00000000,0x00000000},0x1e45,&ucs_strings_mb[1850]},
	{{0x00000000,0x00000000,0x00000000},0x2116,&ucs_strings_mb[3418]},
	{{0x00000000,0x00000000,0x00000000},0x310b,&ucs_strings_mb[6805]},
	{{0x00000000,0x00000000,0x00000000},0x3093,&ucs_strings_mb[6669]},
	{{0x00000000,0x00000000,0x00000000},0x30f3,&ucs_strings_mb[6750]},
	{{0x00000000,0x00000000,0x00000000},0x0147,&ucs_strings_mb[122]},
	{{0x00000000,0x00000000,0x00000000},0x0148,&ucs_strings_mb[122]},
	{{0x00000000,0x00000000,0x00000000},0x041d,&ucs_strings_mb[1010]},
	{{0x00000000,0x00000000,0x00000000},0x043d,&ucs_strings_mb[1010]},
	{{0x00000000,0x00000000,0x00000000},0x1e48,&ucs_strings_mb[1857]},
	{{0x00000000,0x00000000,0x00000000},0x1e49,&ucs_strings_mb[1857]},
	{{0x40000001,0x00000000,0x00000000},0x306a,&ucs_strings_mb[6612]},
	{{0x00000001,0x00000020,0x00000000},0x30ca,&ucs_strings_mb[6612]},
	{{0x00000000,0x00000000,0x00000000},0x2207,&ucs_strings_mb[4098]},
	{{0x00000000,0x00000000,0x00000000},0x2207,&ucs_strings[1314]},
	{{0x40000001,0x00000000,0x00000000},0x306d,&ucs_strings_mb[6615]},
	{{0x00000001,0x00000020,0x00000000},0x30cd,&ucs_strings_mb[6615]},
	{{0x00000000,0x00000000,0x00000000},0x014a,&ucs_strings_mb[157]},
	{{0x00000000,0x00000000,0x00000000},0x014b,&ucs_strings_mb[157]},
	{{0x00000201,0x00000000,0x00000000},0x312b,&ucs_strings_mb[157]},
	{{0x00000000,0x00000000,0x00000000},0x2310,&ucs_strings_mb[4682]},
	{{0x40000001,0x00000000,0x00000000},0x306b,&ucs_strings_mb[4682]},
	{{0x00000001,0x00000020,0x00000000},0x30cb,&ucs_strings_mb[4682]},
	{{0x00000000,0x00000000,0x00000020},0x2079,&ucs_strings[1476]},
	{{0x00000000,0x00000000,0x00000040},0x2089,&ucs_strings[1476]},
	{{0x00004001,0x00000000,0x00000000},0x2468,&ucs_strings[1476]},
	{{0x00000001,0x00040000,0x00000000},0x247c,&ucs_strings[1476]},
	{{0x00000081,0x00000000,0x00000400},0x0669,&ucs_strings[1476]},
	{{0x00000000,0x00804000,0x00000000},0x2168,&ucs_strings[1476]},
	{{0x02000001,0x00000000,0x00000002},0x2490,&ucs_strings[1476]},
	{{0x00000000,0x00040000,0x00000800},0x3228,&ucs_strings[1476]},
	{{0x00000004,0x00804000,0x00000000},0x2178,&ucs_strings[1476]},
	{{0x00004000,0x00002000,0x00000000},0x2472,&ucs_strings_mb[5021]},
	{{0x00000000,0x00042000,0x00000000},0x2486,&ucs_strings_mb[5021]},
	{{0x02000000,0x00002000,0x00000002},0x249a,&ucs_strings_mb[5021]},
	{{0x00000000,0x00000000,0x00000000},0x040a,&ucs_strings_mb[304]},
	{{0x00000000,0x00000000,0x00000000},0x045a,&ucs_strings_mb[304]},
	{{0x00000003,0x00000040,0x00000000},0x01ca,&ucs_strings_mb[304]},
	{{0x00000005,0x00000040,0x00000000},0x01cc,&ucs_strings_mb[304]},
	{{0x00000000,0x00000000,0x00000000},0x01ca,&ucs_strings_mb[307]},
	{{0x00000000,0x00000000,0x00000000},0x01cb,&ucs_strings_mb[307]},
	{{0x00000000,0x00000000,0x00000000},0x01cc,&ucs_strings_mb[307]},
	{{0x00010003,0x00000000,0x00000000},0x040a,&ucs_strings_mb[918]},
	{{0x00010005,0x00000000,0x00000000},0x045a,&ucs_strings_mb[918]},
	{{0x40000001,0x00000000,0x00000000},0x306e,&ucs_strings[2642]},
	{{0x00000001,0x00000020,0x00000000},0x30ce,&ucs_strings[2642]},
	{{0x00000081,0x00000000,0x00000000},0x0646,&ucs_strings_mb[1538]},
	{{0x00000081,0x00000010,0x00000000},0xfee5,&ucs_strings_mb[1538]},
	{{0x01000081,0x00000000,0x00000000},0xfee6,&ucs_strings_mb[1538]},
	{{0x00000081,0x00000004,0x00000000},0xfee7,&ucs_strings_mb[1538]},
	{{0x00000081,0x00001000,0x00000000},0xfee8,&ucs_strings_mb[1538]},
	{{0x00000000,0x00000000,0x00002000},0x2197,&ucs_strings_mb[3929]},
	{{0x00000000,0x00000000,0x00002000},0x2196,&ucs_strings_mb[3914]},
	{{0x00000000,0x04000000,0x00001000},0x2260,&ucs_strings[2638]},
	{{0x00000000,0x00000000,0x00004000},0x226f,&ucs_strings_mb[4571]},
	{{0x00000000,0x00000000,0x00004000},0x226e,&ucs_strings_mb[4559]},
	{{0x00000000,0x00000000,0x00000000},0x207f,&ucs_strings[2485]},
	{{0x40000001,0x00000000,0x00000000},0x306c,&ucs_strings[707]},
	{{0x00000001,0x00000020,0x00000000},0x30cc,&ucs_strings[707]},
	{{0x08000003,0x00000000,0x00000000},0x039d,&ucs_strings[707]},
	{{0x08000005,0x00000000,0x00000000},0x03bd,&ucs_strings[707]},
	{{0x00000001,0x00000000,0x00000000},0x2116,&ucs_strings_mb[3411]},
	{{0x20000001,0x00000000,0x00000000},0x05e0,&ucs_strings_mb[1260]},
	{{0x21000001,0x00000000,0x00000000},0x05df,&ucs_strings_mb[1260]},
	{{0x40000001,0x00000000,0x00000000},0x304a,&ucs_strings[1574]},
	{{0x00000001,0x00000020,0x00000000},0x30aa,&ucs_strings[1574]},
	{{0x00000201,0x00000000,0x00000000},0x311b,&ucs_strings[1574]},
	{{0x00010003,0x00000000,0x00000000},0x041e,&ucs_strings[1574]},
	{{0x00010005,0x00000000,0x00000000},0x043e,&ucs_strings[1574]},
	{{0x40000005,0x00000000,0x00000000},0x3049,&ucs_strings[1574]},
	{{0x00000005,0x00000020,0x00000000},0x30a9,&ucs_strings[1574]},
	{{0x00000003,0x00000440,0x00000000},0x014c,&ucs_strings[1574]},
	{{0x00000005,0x00000440,0x00000000},0x014d,&ucs_strings[1574]},
	{{0x00000803,0x00000040,0x00000000},0x014e,&ucs_strings[1574]},
	{{0x00000805,0x00000040,0x00000000},0x014f,&ucs_strings[1574]},
	{{0x00000003,0x00000042,0x00000000},0x01a0,&ucs_strings[1574]},
	{{0x00000005,0x00000042,0x00000000},0x01a1,&ucs_strings[1574]},
	{{0x00001003,0x00000040,0x00000000},0x01d1,&ucs_strings[1574]},
	{{0x00001005,0x00000040,0x00000000},0x01d2,&ucs_strings[1574]},
	{{0x00000003,0x00000040,0x02000000},0x01ea,&ucs_strings[1574]},
	{{0x00000005,0x00000040,0x02000000},0x01eb,&ucs_strings[1574]},
	{{0x00000005,0x00040040,0x00000000},0x24aa,&ucs_strings[1574]},
	{{0x00004003,0x00000040,0x00000000},0x24c4,&ucs_strings[1574]},
	{{0x00004005,0x00000040,0x00000000},0x24de,&ucs_strings[1574]},
	{{0x00100013,0x00000040,0x00000000},0x0150,&ucs_strings[1574]},
	{{0x00100015,0x00000040,0x00000000},0x0151,&ucs_strings[1574]},
	{{0x00000003,0x00000440,0x02000000},0x01ec,&ucs_strings[1574]},
	{{0x00000005,0x00000440,0x02000000},0x01ed,&ucs_strings[1574]},
	{{0x00000013,0x00000040,0x10000000},0x01fe,&ucs_strings[1574]},
	{{0x00000015,0x00000040,0x10000000},0x01ff,&ucs_strings[1574]},
	{{0x04100003,0x00000040,0x00000000},0x020c,&ucs_strings[1574]},
	{{0x04100005,0x00000040,0x00000000},0x020d,&ucs_strings[1574]},
	{{0x00000803,0x00000040,0x00800000},0x020e,&ucs_strings[1574]},
	{{0x00000805,0x00000040,0x00800000},0x020f,&ucs_strings[1574]},
	{{0x00000013,0x02000040,0x00000000},0x1e4c,&ucs_strings[1574]},
	{{0x00000015,0x02000040,0x00000000},0x1e4d,&ucs_strings[1574]},
	{{0x00040003,0x02000040,0x00000000},0x1e4e,&ucs_strings[1574]},
	{{0x00040005,0x02000040,0x00000000},0x1e4f,&ucs_strings[1574]},
	{{0x04000003,0x00000440,0x00000000},0x1e50,&ucs_strings[1574]},
	{{0x04000005,0x00000440,0x00000000},0x1e51,&ucs_strings[1574]},
	{{0x00000013,0x00000440,0x00000000},0x1e52,&ucs_strings[1574]},
	{{0x00000015,0x00000440,0x00000000},0x1e53,&ucs_strings[1574]},
	{{0x00080103,0x00000040,0x00000000},0x1ecc,&ucs_strings[1574]},
	{{0x00080105,0x00000040,0x00000000},0x1ecd,&ucs_strings[1574]},
	{{0x8000000b,0x00000040,0x00000000},0x1ece,&ucs_strings[1574]},
	{{0x8000000d,0x00000040,0x00000000},0x1ecf,&ucs_strings[1574]},
	{{0x00008013,0x00000040,0x00000000},0x1ed0,&ucs_strings[1574]},
	{{0x00008015,0x00000040,0x00000000},0x1ed1,&ucs_strings[1574]},
	{{0x04008003,0x00000040,0x00000000},0x1ed2,&ucs_strings[1574]},
	{{0x04008005,0x00000040,0x00000000},0x1ed3,&ucs_strings[1574]},
	{{0x00008003,0x02000040,0x00000000},0x1ed6,&ucs_strings[1574]},
	{{0x00008005,0x02000040,0x00000000},0x1ed7,&ucs_strings[1574]},
	{{0x00000013,0x00000042,0x00000000},0x1eda,&ucs_strings[1574]},
	{{0x00000015,0x00000042,0x00000000},0x1edb,&ucs_strings[1574]},
	{{0x04000003,0x00000042,0x00000000},0x1edc,&ucs_strings[1574]},
	{{0x04000005,0x00000042,0x00000000},0x1edd,&ucs_strings[1574]},
	{{0x00000003,0x02000042,0x00000000},0x1ee0,&ucs_strings[1574]},
	{{0x00000005,0x02000042,0x00000000},0x1ee1,&ucs_strings[1574]},
	{{0x8000800b,0x00000040,0x00000000},0x1ed4,&ucs_strings[1574]},
	{{0x8000800d,0x00000040,0x00000000},0x1ed5,&ucs_strings[1574]},
	{{0x00088103,0x00000040,0x00000000},0x1ed8,&ucs_strings[1574]},
	{{0x00088105,0x00000040,0x00000000},0x1ed9,&ucs_strings[1574]},
	{{0x8000000b,0x00000042,0x00000000},0x1ede,&ucs_strings[1574]},
	{{0x8000000d,0x00000042,0x00000000},0x1edf,&ucs_strings[1574]},
	{{0x00080103,0x00000042,0x00000000},0x1ee2,&ucs_strings[1574]},
	{{0x00080105,0x00000042,0x00000000},0x1ee3,&ucs_strings[1574]},
	{{0x00000000,0x00000000,0x00000000},0x24c4,&ucs_strings_mb[5369]},
	{{0x00000000,0x00000000,0x00000000},0x24de,&ucs_strings_mb[5369]},
	{{0x00000000,0x00000000,0x00000000},0x020c,&ucs_strings_mb[425]},
	{{0x00000000,0x00000000,0x00000000},0x020d,&ucs_strings_mb[425]},
	{{0x00000000,0x00000000,0x00000000},0x0150,&ucs_strings_mb[166]},
	{{0x00000000,0x00000000,0x00000000},0x0151,&ucs_strings_mb[166]},
	{{0x00000000,0x00000000,0x00000000},0x038c,&ucs_strings_mb[653]},
	{{0x00000000,0x00000000,0x00000000},0x03cc,&ucs_strings_mb[653]},
	{{0x00000000,0x00000000,0x00000000},0x014e,&ucs_strings_mb[163]},
	{{0x00000000,0x00000000,0x00000000},0x014f,&ucs_strings_mb[163]},
	{{0x00000000,0x00000000,0x00000000},0x020e,&ucs_strings_mb[429]},
	{{0x00000000,0x00000000,0x00000000},0x020f,&ucs_strings_mb[429]},
	{{0x00000000,0x00000000,0x00000000},0x039f,&ucs_strings_mb[753]},
	{{0x00000000,0x00000000,0x00000000},0x03bf,&ucs_strings_mb[753]},
	{{0x00000000,0x00000000,0x00000000},0x1f78,&ucs_strings_mb[2453]},
	{{0x00000000,0x00000000,0x00000000},0x1ff8,&ucs_strings_mb[2453]},
	{{0x00000000,0x00000000,0x00000000},0x1f79,&ucs_strings_mb[2457]},
	{{0x00000000,0x00000000,0x00000000},0x1ff9,&ucs_strings_mb[2457]},
	{{0x00000000,0x00000000,0x00000000},0x1f40,&ucs_strings_mb[2317]},
	{{0x00000000,0x00000000,0x00000000},0x1f48,&ucs_strings_mb[2317]},
	{{0x00000000,0x00000000,0x00000000},0x1f42,&ucs_strings_mb[2325]},
	{{0x00000000,0x00000000,0x00000000},0x1f4a,&ucs_strings_mb[2325]},
	{{0x00000000,0x00000000,0x00000000},0x1f44,&ucs_strings_mb[2335]},
	{{0x00000000,0x00000000,0x00000000},0x1f4c,&ucs_strings_mb[2335]},
	{{0x00000000,0x00000000,0x00000000},0x1f41,&ucs_strings_mb[2321]},
	{{0x00000000,0x00000000,0x00000000},0x1f49,&ucs_strings_mb[2321]},
	{{0x00000000,0x00000000,0x00000000},0x1f43,&ucs_strings_mb[2330]},
	{{0x00000000,0x00000000,0x00000000},0x1f4b,&ucs_strings_mb[2330]},
	{{0x00000000,0x00000000,0x00000000},0x1f45,&ucs_strings_mb[2340]},
	{{0x00000000,0x00000000,0x00000000},0x1f4d,&ucs_strings_mb[2340]},
	{{0x00000000,0x00000000,0x00000000},0x014c,&ucs_strings_mb[160]},
	{{0x00000000,0x00000000,0x00000000},0x014d,&ucs_strings_mb[160]},
	{{0x00000000,0x00000000,0x00000000},0x1e50,&ucs_strings_mb[1872]},
	{{0x00000000,0x00000000,0x00000000},0x1e51,&ucs_strings_mb[1872]},
	{{0x00000000,0x00000000,0x00000000},0x1e52,&ucs_strings_mb[1876]},
	{{0x00000000,0x00000000,0x00000000},0x1e53,&ucs_strings_mb[1876]},
	{{0x00000000,0x00000000,0x00000000},0x1ecc,&ucs_strings_mb[2085]},
	{{0x00000000,0x00000000,0x00000000},0x1ecd,&ucs_strings_mb[2085]},
	{{0x00000000,0x00000000,0x00000000},0x01fe,&ucs_strings_mb[400]},
	{{0x00000000,0x00000000,0x00000000},0x01ff,&ucs_strings_mb[400]},
	{{0x00000000,0x00000000,0x00000000},0x01ec,&ucs_strings_mb[376]},
	{{0x00000000,0x00000000,0x00000000},0x01ed,&ucs_strings_mb[376]},
	{{0x00000000,0x00000000,0x00000000},0x1ece,&ucs_strings_mb[2089]},
	{{0x00000000,0x00000000,0x00000000},0x1ecf,&ucs_strings_mb[2089]},
	{{0x00000000,0x00000000,0x00000000},0x046a,&ucs_strings_mb[1132]},
	{{0x00000000,0x00000000,0x00000000},0x046b,&ucs_strings_mb[1132]},
	{{0x00000000,0x00000000,0x00000000},0x311b,&ucs_strings_mb[6844]},
	{{0x00000000,0x00000000,0x00000000},0x3049,&ucs_strings_mb[6555]},
	{{0x00000000,0x00000000,0x00000000},0x304a,&ucs_strings_mb[6555]},
	{{0x00000000,0x00000000,0x00000000},0x30a9,&ucs_strings_mb[6747]},
	{{0x00000000,0x00000000,0x00000000},0x30aa,&ucs_strings_mb[6747]},
	{{0x00000000,0x00000000,0x00000000},0x01a0,&ucs_strings_mb[260]},
	{{0x00000000,0x00000000,0x00000000},0x01a1,&ucs_strings_mb[260]},
	{{0x00000000,0x00000000,0x00000000},0x1edc,&ucs_strings_mb[2117]},
	{{0x00000000,0x00000000,0x00000000},0x1edd,&ucs_strings_mb[2117]},
	{{0x00000000,0x00000000,0x00000000},0x1eda,&ucs_strings_mb[2113]},
	{{0x00000000,0x00000000,0x00000000},0x1edb,&ucs_strings_mb[2113]},
	{{0x00000000,0x00000000,0x00000000},0x1ee2,&ucs_strings_mb[2129]},
	{{0x00000000,0x00000000,0x00000000},0x1ee3,&ucs_strings_mb[2129]},
	{{0x00000000,0x00000000,0x00000000},0x1ede,&ucs_strings_mb[2121]},
	{{0x00000000,0x00000000,0x00000000},0x1edf,&ucs_strings_mb[2121]},
	{{0x00000000,0x00000000,0x00000000},0x1ee0,&ucs_strings_mb[2125]},
	{{0x00000000,0x00000000,0x00000000},0x1ee1,&ucs_strings_mb[2125]},
	{{0x00000000,0x00000000,0x00000000},0x01ea,&ucs_strings_mb[373]},
	{{0x00000000,0x00000000,0x00000000},0x01eb,&ucs_strings_mb[373]},
	{{0x00000000,0x00000000,0x00000000},0x01d1,&ucs_strings_mb[321]},
	{{0x00000000,0x00000000,0x00000000},0x01d2,&ucs_strings_mb[321]},
	{{0x00000000,0x00000000,0x00000000},0x041e,&ucs_strings_mb[1013]},
	{{0x00000000,0x00000000,0x00000000},0x043e,&ucs_strings_mb[1013]},
	{{0x00000000,0x00000000,0x00000000},0x1ed2,&ucs_strings_mb[2096]},
	{{0x00000000,0x00000000,0x00000000},0x1ed3,&ucs_strings_mb[2096]},
	{{0x00000000,0x00000000,0x00000000},0x1ed0,&ucs_strings_mb[2092]},
	{{0x00000000,0x00000000,0x00000000},0x1ed1,&ucs_strings_mb[2092]},
	{{0x00000000,0x00000000,0x00000000},0x1ed8,&ucs_strings_mb[2108]},
	{{0x00000000,0x00000000,0x00000000},0x1ed9,&ucs_strings_mb[2108]},
	{{0x00000000,0x00000000,0x00000000},0x1ed4,&ucs_strings_mb[2100]},
	{{0x00000000,0x00000000,0x00000000},0x1ed5,&ucs_strings_mb[2100]},
	{{0x00000000,0x00000000,0x00000000},0x1ed6,&ucs_strings_mb[2104]},
	{{0x00000000,0x00000000,0x00000000},0x1ed7,&ucs_strings_mb[2104]},
	{{0x00000000,0x00000000,0x00000000},0x1e4c,&ucs_strings_mb[1864]},
	{{0x00000000,0x00000000,0x00000000},0x1e4d,&ucs_strings_mb[1864]},
	{{0x00000000,0x00000000,0x00000000},0x1e4e,&ucs_strings_mb[1868]},
	{{0x00000000,0x00000000,0x00000000},0x1e4f,&ucs_strings_mb[1868]},
	{{0x00000000,0x00000000,0x00000000},0x2218,&ucs_strings_mb[4232]},
	{{0x00000000,0x00000000,0x00000000},0x2103,&ucs_strings[2415]},
	{{0x00000000,0x00000000,0x00000000},0x0152,&ucs_strings_mb[169]},
	{{0x00000000,0x00000000,0x00000000},0x0153,&ucs_strings_mb[169]},
	{{0x00000002,0x00000040,0x00000100},0x0152,&ucs_strings_mb[169]},
	{{0x00000004,0x00000040,0x00000100},0x0153,&ucs_strings_mb[169]},
	{{0x00000001,0x00000000,0x00000000},0x2126,&ucs_strings_mb[3488]},
	{{0x00000000,0x00000000,0x00000000},0x01a2,&ucs_strings_mb[263]},
	{{0x00000000,0x00000000,0x00000000},0x01a3,&ucs_strings_mb[263]},
	{{0x00000003,0x00000040,0x00000000},0x01a2,&ucs_strings_mb[263]},
	{{0x00000005,0x00000040,0x00000000},0x01a3,&ucs_strings_mb[263]},
	{{0x00000000,0x00000000,0x00000000},0x2713,&ucs_strings_mb[6309]},
	{{0x00000000,0x00000000,0x00000000},0x2126,&ucs_strings_mb[3492]},
	{{0x08000003,0x00000000,0x00000000},0x039f,&ucs_strings_mb[645]},
	{{0x08000005,0x00000000,0x00000000},0x03bf,&ucs_strings_mb[645]},
	{{0x08000003,0x00000000,0x20000000},0x038c,&ucs_strings_mb[645]},
	{{0x08000005,0x00000000,0x20000000},0x03cc,&ucs_strings_mb[645]},
	{{0x08000005,0x00200000,0x00000000},0x1f40,&ucs_strings_mb[645]},
	{{0x08020005,0x00000000,0x00000000},0x1f41,&ucs_strings_mb[645]},
	{{0x08000003,0x00200000,0x00000000},0x1f48,&ucs_strings_mb[645]},
	{{0x08020003,0x00000000,0x00000000},0x1f49,&ucs_strings_mb[645]},
	{{0x08000005,0x20000000,0x00000000},0x1f78,&ucs_strings_mb[645]},
	{{0x08000005,0x00020000,0x00000000},0x1f79,&ucs_strings_mb[645]},
	{{0x08000003,0x20000000,0x00000000},0x1ff8,&ucs_strings_mb[645]},
	{{0x08000003,0x00020000,0x00000000},0x1ff9,&ucs_strings_mb[645]},
	{{0x08000005,0x20200000,0x00000000},0x1f42,&ucs_strings_mb[645]},
	{{0x08020005,0x20000000,0x00000000},0x1f43,&ucs_strings_mb[645]},
	{{0x08000005,0x00220000,0x00000000},0x1f44,&ucs_strings_mb[645]},
	{{0x08020005,0x00020000,0x00000000},0x1f45,&ucs_strings_mb[645]},
	{{0x08000003,0x20200000,0x00000000},0x1f4a,&ucs_strings_mb[645]},
	{{0x08020003,0x20000000,0x00000000},0x1f4b,&ucs_strings_mb[645]},
	{{0x08000003,0x00220000,0x00000000},0x1f4c,&ucs_strings_mb[645]},
	{{0x08020003,0x00020000,0x00000000},0x1f4d,&ucs_strings_mb[645]},
	{{0x00000400,0x00000000,0x00000000},0x2423,&ucs_strings_mb[4788]},
	{{0x00000000,0x00000000,0x04000000},0x2218,&ucs_strings_mb[4223]},
	{{0x00000000,0x02000000,0x00000000},0x223c,&ucs_strings_mb[4223]},
	{{0x00080000,0x00000000,0x00000000},0x22c5,&ucs_strings_mb[4223]},
	{{0x00084000,0x00000000,0x00000000},0x2299,&ucs_strings_mb[4223]},
	{{0x00004000,0x00000000,0x04000000},0x229a,&ucs_strings_mb[4223]},
	{{0x00000001,0x00000000,0x00000080},0x25a6,&ucs_strings_mb[5784]},
	{{0x00000000,0x00000000,0x00000000},0x25a1,&ucs_strings_mb[5737]},
	{{0x00000201,0x00000000,0x00000000},0x3121,&ucs_strings_mb[6863]},
	{{0x00000000,0x00000000,0x00000000},0x203e,&ucs_strings_mb[3241]},
	{{0x00000201,0x00000000,0x00000000},0x3106,&ucs_strings[1576]},
	{{0x00000013,0x00000040,0x00000000},0x1e54,&ucs_strings[1576]},
	{{0x00000015,0x00000040,0x00000000},0x1e55,&ucs_strings[1576]},
	{{0x00000005,0x00040040,0x00000000},0x24ab,&ucs_strings[1576]},
	{{0x00004003,0x00000040,0x00000000},0x24c5,&ucs_strings[1576]},
	{{0x00004005,0x00000040,0x00000000},0x24df,&ucs_strings[1576]},
	{{0x0008000b,0x00000040,0x00000000},0x1e56,&ucs_strings[1576]},
	{{0x0008000d,0x00000040,0x00000000},0x1e57,&ucs_strings[1576]},
	{{0x00000000,0x00000000,0x00000000},0x24c5,&ucs_strings_mb[5373]},
	{{0x00000000,0x00000000,0x00000000},0x24df,&ucs_strings_mb[5373]},
	{{0x00000000,0x00000000,0x00000000},0x05e3,&ucs_strings_mb[1288]},
	{{0x00000000,0x00000000,0x00000000},0x1e54,&ucs_strings_mb[1880]},
	{{0x00000000,0x00000000,0x00000000},0x1e55,&ucs_strings_mb[1880]},
	{{0x00000000,0x00000000,0x00000000},0x03a0,&ucs_strings_mb[756]},
	{{0x00000000,0x00000000,0x00000000},0x03c0,&ucs_strings_mb[756]},
	{{0x00000000,0x00000000,0x00000000},0x05e4,&ucs_strings_mb[1291]},
	{{0x00000000,0x00000000,0x00000000},0x067e,&ucs_strings_mb[1291]},
	{{0x00000000,0x00000000,0x00000000},0x1e56,&ucs_strings_mb[1883]},
	{{0x00000000,0x00000000,0x00000000},0x1e57,&ucs_strings_mb[1883]},
	{{0x00000000,0x00000000,0x00000000},0x03e0,&ucs_strings_mb[872]},
	{{0x00000000,0x00000000,0x00000000},0x3106,&ucs_strings_mb[6793]},
	{{0x00000000,0x00000000,0x00000000},0x041f,&ucs_strings_mb[1019]},
	{{0x00000000,0x00000000,0x00000000},0x043f,&ucs_strings_mb[1019]},
	{{0x40000001,0x00000000,0x00000000},0x3071,&ucs_strings[1717]},
	{{0x00000001,0x00000020,0x00000000},0x30d1,&ucs_strings[1717]},
	{{0x00000000,0x00000000,0x00000000},0x2029,&ucs_strings_mb[3095]},
	{{0x00000000,0x04000000,0x00000000},0x2225,&ucs_strings_mb[4296]},
	{{0x00000000,0x00000080,0x00000020},0x207d,&ucs_strings[1362]},
	{{0x00000000,0x00400000,0x00000020},0x207e,&ucs_strings[1362]},
	{{0x00000000,0x00000080,0x00000040},0x208d,&ucs_strings[1362]},
	{{0x00000000,0x00400000,0x00000040},0x208e,&ucs_strings[1362]},
	{{0x00000000,0x00000000,0x00000000},0x2029,&ucs_strings_mb[3115]},
	{{0x00000000,0x00000000,0x00000000},0x2202,&ucs_strings_mb[4038]},
	{{0x20000001,0x00000000,0x00000000},0x05e4,&ucs_strings_mb[1016]},
	{{0x40000001,0x00000000,0x00000000},0x307a,&ucs_strings_mb[1016]},
	{{0x00000001,0x00000020,0x00000000},0x30da,&ucs_strings_mb[1016]},
	{{0x00010003,0x00000000,0x00000000},0x041f,&ucs_strings_mb[1016]},
	{{0x00010005,0x00000000,0x00000000},0x043f,&ucs_strings_mb[1016]},
	{{0x21000001,0x00000000,0x00000000},0x05e3,&ucs_strings_mb[1016]},
	{{0x00000081,0x00000000,0x00000000},0x067e,&ucs_strings_mb[1684]},
	{{0x00000001,0x00000000,0x00000000},0x2030,&ucs_strings_mb[3122]},
	{{0x00000081,0x00000000,0x00000000},0x066a,&ucs_strings[1333]},
	{{0x00000001,0x00000000,0x00000000},0x20a7,&ucs_strings_mb[3333]},
	{{0x08000003,0x00000000,0x00000000},0x03a6,&ucs_strings_mb[785]},
	{{0x08000005,0x00000000,0x00000000},0x03c6,&ucs_strings_mb[785]},
	{{0x40000001,0x00000000,0x00000000},0x3074,&ucs_strings[2727]},
	{{0x00000001,0x00000020,0x00000000},0x30d4,&ucs_strings[2727]},
	{{0x08000003,0x00000000,0x00000000},0x03a0,&ucs_strings[2727]},
	{{0x08000005,0x00000000,0x00000000},0x03c0,&ucs_strings[2727]},
	{{0x00000000,0x00000000,0x00000000},0x25c4,&ucs_strings_mb[5919]},
	{{0x00000001,0x00000000,0x00000001},0x2318,&ucs_strings_mb[4714]},
	{{0x00000001,0x00000000,0x00000020},0x207a,&ucs_strings[1383]},
	{{0x00000001,0x00000000,0x00000040},0x208a,&ucs_strings[1383]},
	{{0x00080000,0x00000000,0x00000000},0x2214,&ucs_strings[1383]},
	{{0x00000000,0x00000000,0x00000080},0x33d8,&ucs_strings[2438]},
	{{0x00000000,0x00000000,0x00000000},0x2117,&ucs_strings_mb[3447]},
	{{0x40000001,0x00000000,0x00000000},0x307d,&ucs_strings_mb[3447]},
	{{0x00000001,0x00000020,0x00000000},0x30dd,&ucs_strings_mb[3447]},
	{{0x00000000,0x00000080,0x00020000},0x2329,&ucs_strings_mb[4767]},
	{{0x00000000,0x00400000,0x00020000},0x232a,&ucs_strings_mb[4767]},
	{{0x00000000,0x01000880,0x00000000},0x2039,&ucs_strings[2610]},
	{{0x00000000,0x01400800,0x00000000},0x203a,&ucs_strings[2610]},
	{{0x00000000,0x80000080,0x00000000},0x261c,&ucs_strings_mb[6066]},
	{{0x00000000,0x80400000,0x00000000},0x261e,&ucs_strings_mb[6066]},
	{{0x00000000,0x00400000,0x00000004},0x25ba,&ucs_strings_mb[5896]},
	{{0x00000000,0x00000080,0x00000004},0x25c4,&ucs_strings_mb[5896]},
	{{0x00000000,0x08000000,0x00000004},0x25b2,&ucs_strings_mb[5875]},
	{{0x00000000,0x88000000,0x00000000},0x25b3,&ucs_strings_mb[5875]},
	{{0x00000000,0x80400000,0x00000000},0x25b7,&ucs_strings_mb[5875]},
	{{0x00200000,0x00000000,0x00000004},0x25bc,&ucs_strings_mb[5875]},
	{{0x00200000,0x80000000,0x00000000},0x25bd,&ucs_strings_mb[5875]},
	{{0x00000000,0x80000080,0x00000000},0x25c1,&ucs_strings_mb[5875]},
	{{0x00000000,0x00000800,0x00000000},0x3012,&ucs_strings_mb[6468]},
	{{0x00000000,0x00000800,0x00000000},0x3020,&ucs_strings_mb[6526]},
	{{0x00000000,0x00000000,0x00000000},0x2225,&ucs_strings_mb[4305]},
	{{0x00000000,0x00000000,0x00000000},0x25ba,&ucs_strings_mb[5913]},
	{{0x00000000,0x00000000,0x00000000},0x211e,&ucs_strings_mb[3450]},
	{{0x00000000,0x00000000,0x00000000},0x2032,&ucs_strings_mb[3135]},
	{{0x00100000,0x00000000,0x00000000},0x2033,&ucs_strings_mb[3135]},
	{{0x40000000,0x00000820,0x00000000},0x30fc,&ucs_strings_mb[6765]},
	{{0x00000000,0x00000000,0x00100001},0x220e,&ucs_strings_mb[4137]},
	{{0x00000000,0x00000000,0x00000000},0x2237,&ucs_strings_mb[4406]},
	{{0x00000000,0x04000000,0x00000000},0x221d,&ucs_strings_mb[4259]},
	{{0x08000003,0x00000000,0x00000000},0x03a8,&ucs_strings_mb[799]},
	{{0x08000005,0x00000000,0x00000000},0x03c8,&ucs_strings_mb[799]},
	{{0x40000001,0x00000000,0x00000000},0x3077,&ucs_strings[2007]},
	{{0x00000001,0x00000020,0x00000000},0x30d7,&ucs_strings[2007]},
	{{0x00000201,0x00000000,0x00000000},0x3111,&ucs_strings[1578]},
	{{0x00000005,0x00040040,0x00000000},0x24ac,&ucs_strings[1578]},
	{{0x00004003,0x00000040,0x00000000},0x24c6,&ucs_strings[1578]},
	{{0x00004005,0x00000040,0x00000000},0x24e0,&ucs_strings[1578]},
	{{0x00000000,0x00000000,0x00000000},0x24c6,&ucs_strings_mb[5377]},
	{{0x00000000,0x00000000,0x00000000},0x24e0,&ucs_strings_mb[5377]},
	{{0x00000000,0x00000000,0x00000000},0x03a8,&ucs_strings_mb[803]},
	{{0x00000000,0x00000000,0x00000000},0x03c8,&ucs_strings_mb[803]},
	{{0x00000000,0x00000000,0x00000000},0x05e7,&ucs_strings_mb[1307]},
	{{0x00000000,0x00000000,0x00000000},0x0642,&ucs_strings_mb[1307]},
	{{0x00000000,0x00000000,0x00000000},0xfed7,&ucs_strings_mb[7311]},
	{{0x00000000,0x00000000,0x00000000},0xfed5,&ucs_strings_mb[7303]},
	{{0x00000000,0x00000000,0x00000000},0xfed6,&ucs_strings_mb[7307]},
	{{0x00000000,0x00000000,0x00000000},0xfed8,&ucs_strings_mb[7315]},
	{{0x00000000,0x00000000,0x00000000},0x3111,&ucs_strings_mb[6823]},
	{{0x00000081,0x00000000,0x00000000},0x0642,&ucs_strings_mb[1525]},
	{{0x00000081,0x00000010,0x00000000},0xfed5,&ucs_strings_mb[1525]},
	{{0x01000081,0x00000000,0x00000000},0xfed6,&ucs_strings_mb[1525]},
	{{0x00000081,0x00000004,0x00000000},0xfed7,&ucs_strings_mb[1525]},
	{{0x00000081,0x00001000,0x00000000},0xfed8,&ucs_strings_mb[1525]},
	{{0x20000001,0x00000000,0x00000000},0x05e7,&ucs_strings_mb[1303]},
	{{0x00400400,0x00000101,0x00000000},0x2508,&ucs_strings_mb[5465]},
	{{0x10400400,0x00000001,0x00000000},0x2509,&ucs_strings_mb[5465]},
	{{0x00400400,0x40000100,0x00000000},0x250a,&ucs_strings_mb[5465]},
	{{0x10400400,0x40000000,0x00000000},0x250b,&ucs_strings_mb[5465]},
	{{0x00000000,0x00000000,0x00000000},0x2669,&ucs_strings_mb[6175]},
	{{0x08000000,0x00000800,0x00000000},0x037e,&ucs_strings[1517]},
	{{0x00000080,0x00000800,0x00000000},0x061f,&ucs_strings[1517]},
	{{0x00000000,0x01000880,0x00000000},0x2018,&ucs_strings[1304]},
	{{0x00000000,0x01400800,0x00000000},0x2019,&ucs_strings[1304]},
	{{0x00100000,0x00000880,0x00000000},0x201c,&ucs_strings[1304]},
	{{0x00100000,0x00400800,0x00000000},0x201d,&ucs_strings[1304]},
	{{0x00000201,0x00000000,0x00000000},0x3116,&ucs_strings[1580]},
	{{0x00000013,0x00000040,0x00000000},0x0154,&ucs_strings[1580]},
	{{0x00000015,0x00000040,0x00000000},0x0155,&ucs_strings[1580]},
	{{0x00002003,0x00000040,0x00000000},0x0156,&ucs_strings[1580]},
	{{0x00002005,0x00000040,0x00000000},0x0157,&ucs_strings[1580]},
	{{0x00001003,0x00000040,0x00000000},0x0158,&ucs_strings[1580]},
	{{0x00001005,0x00000040,0x00000000},0x0159,&ucs_strings[1580]},
	{{0x00000005,0x00040040,0x00000000},0x24ad,&ucs_strings[1580]},
	{{0x00004003,0x00000040,0x00000000},0x24c7,&ucs_strings[1580]},
	{{0x00004005,0x00000040,0x00000000},0x24e1,&ucs_strings[1580]},
	{{0x04100003,0x00000040,0x00000000},0x0210,&ucs_strings[1580]},
	{{0x04100005,0x00000040,0x00000000},0x0211,&ucs_strings[1580]},
	{{0x00000803,0x00000040,0x00800000},0x0212,&ucs_strings[1580]},
	{{0x00000805,0x00000040,0x00800000},0x0213,&ucs_strings[1580]},
	{{0x0008000b,0x00000040,0x00000000},0x1e58,&ucs_strings[1580]},
	{{0x0008000d,0x00000040,0x00000000},0x1e59,&ucs_strings[1580]},
	{{0x00080103,0x00000040,0x00000000},0x1e5a,&ucs_strings[1580]},
	{{0x00080105,0x00000040,0x00000000},0x1e5b,&ucs_strings[1580]},
	{{0x00000103,0x00000240,0x00000000},0x1e5e,&ucs_strings[1580]},
	{{0x00000105,0x00000240,0x00000000},0x1e5f,&ucs_strings[1580]},
	{{0x00080103,0x00000440,0x00000000},0x1e5c,&ucs_strings[1580]},
	{{0x00080105,0x00000440,0x00000000},0x1e5d,&ucs_strings[1580]},
	{{0x00000005,0x00000040,0x00000000},0x027c,&ucs_strings_mb[446]},
	{{0x00000000,0x00000000,0x00000000},0x24c7,&ucs_strings_mb[5381]},
	{{0x00000000,0x00000000,0x00000000},0x24e1,&ucs_strings_mb[5381]},
	{{0x00000000,0x00000000,0x00000000},0x0210,&ucs_strings_mb[432]},
	{{0x00000000,0x00000000,0x00000000},0x0211,&ucs_strings_mb[432]},
	{{0x00000000,0x00000000,0x00000000},0x0154,&ucs_strings_mb[172]},
	{{0x00000000,0x00000000,0x00000000},0x0155,&ucs_strings_mb[172]},
	{{0x00000000,0x00000000,0x00000000},0x0212,&ucs_strings_mb[436]},
	{{0x00000000,0x00000000,0x00000000},0x0213,&ucs_strings_mb[436]},
	{{0x00000000,0x00000000,0x00000000},0x03a1,&ucs_strings_mb[763]},
	{{0x00000000,0x00000000,0x00000000},0x03c1,&ucs_strings_mb[763]},
	{{0x00000000,0x00000000,0x00000000},0x1fe4,&ucs_strings_mb[2764]},
	{{0x00000000,0x00000000,0x00000000},0x1fe5,&ucs_strings_mb[2768]},
	{{0x00000000,0x00000000,0x00000000},0x1fec,&ucs_strings_mb[2768]},
	{{0x00000000,0x00000000,0x00000000},0x05e8,&ucs_strings_mb[1315]},
	{{0x00000000,0x00000000,0x00000000},0x0631,&ucs_strings_mb[1315]},
	{{0x00000000,0x00000000,0x00000000},0xfead,&ucs_strings_mb[7143]},
	{{0x00000000,0x00000000,0x00000000},0xfeae,&ucs_strings_mb[7147]},
	{{0x00000000,0x00000000,0x00000000},0x0156,&ucs_strings_mb[175]},
	{{0x00000000,0x00000000,0x00000000},0x0157,&ucs_strings_mb[175]},
	{{0x00000000,0x00000000,0x00000000},0x1e5c,&ucs_strings_mb[1893]},
	{{0x00000000,0x00000000,0x00000000},0x1e5d,&ucs_strings_mb[1893]},
	{{0x00000000,0x00000000,0x00000000},0x1e5a,&ucs_strings_mb[1889]},
	{{0x00000000,0x00000000,0x00000000},0x1e5b,&ucs_strings_mb[1889]},
	{{0x00000000,0x00000000,0x00000000},0x1e58,&ucs_strings_mb[1886]},
	{{0x00000000,0x00000000,0x00000000},0x1e59,&ucs_strings_mb[1886]},
	{{0x00000000,0x00000000,0x00000000},0x027c,&ucs_strings_mb[457]},
	{{0x00000000,0x00000000,0x00000000},0x3116,&ucs_strings_mb[6829]},
	{{0x00000000,0x00000000,0x00000000},0x0158,&ucs_strings_mb[178]},
	{{0x00000000,0x00000000,0x00000000},0x0159,&ucs_strings_mb[178]},
	{{0x00000000,0x00000000,0x00000000},0x0420,&ucs_strings_mb[1025]},
	{{0x00000000,0x00000000,0x00000000},0x0440,&ucs_strings_mb[1025]},
	{{0x00000000,0x00000000,0x00000000},0x1e5e,&ucs_strings_mb[1898]},
	{{0x00000000,0x00000000,0x00000000},0x1e5f,&ucs_strings_mb[1898]},
	{{0x40000001,0x00000000,0x00000000},0x3089,&ucs_strings_mb[6648]},
	{{0x00000001,0x00000020,0x00000000},0x30e9,&ucs_strings_mb[6648]},
	{{0x00000000,0x00000000,0x00000000},0x2236,&ucs_strings_mb[4397]},
	{{0x00000000,0x00000000,0x00000000},0x2590,&ucs_strings_mb[5695]},
	{{0x40000001,0x00000000,0x00000000},0x308c,&ucs_strings_mb[6654]},
	{{0x00000001,0x00000020,0x00000000},0x30ec,&ucs_strings_mb[6654]},
	{{0x00000000,0x00000000,0x00000004},0x25ac,&ucs_strings_mb[5862]},
	{{0x00000000,0x80000000,0x00000000},0x25ad,&ucs_strings_mb[5862]},
	{{0x00000000,0x00000800,0x00000000},0x203b,&ucs_strings_mb[3224]},
	{{0x00000081,0x00000000,0x00000000},0x0631,&ucs_strings_mb[1446]},
	{{0x00000081,0x00000010,0x00000000},0xfead,&ucs_strings_mb[1446]},
	{{0x01000081,0x00000000,0x00000000},0xfeae,&ucs_strings_mb[1446]},
	{{0x20000001,0x00000000,0x00000000},0x05e8,&ucs_strings_mb[1310]},
	{{0x00000001,0x00000000,0x00000000},0x2310,&ucs_strings_mb[4669]},
	{{0x00000000,0x00000000,0x00000000},0x2035,&ucs_strings_mb[3163]},
	{{0x00100000,0x00000000,0x00000000},0x2036,&ucs_strings_mb[3163]},
	{{0x00000000,0x00000000,0x00000000},0x2037,&ucs_strings_mb[3184]},
	{{0x00000000,0x00000000,0x00000000},0x25a4,&ucs_strings_mb[5778]},
	{{0x00000000,0x00000000,0x00000000},0x25a6,&ucs_strings_mb[5811]},
	{{0x08000003,0x00000000,0x00000000},0x03a1,&ucs_strings_mb[759]},
	{{0x08000005,0x00000000,0x00000000},0x03c1,&ucs_strings_mb[759]},
	{{0x08000005,0x00200000,0x00000000},0x1fe4,&ucs_strings_mb[759]},
	{{0x08020005,0x00000000,0x00000000},0x1fe5,&ucs_strings_mb[759]},
	{{0x08020003,0x00000000,0x00000000},0x1fec,&ucs_strings_mb[759]},
	{{0x40000001,0x00000000,0x00000000},0x308a,&ucs_strings[2027]},
	{{0x00000001,0x00000020,0x00000000},0x30ea,&ucs_strings[2027]},
	{{0x00000000,0x00000000,0x00002000},0x2192,&ucs_strings_mb[3881]},
	{{0x00100000,0x00000000,0x00002000},0x21d2,&ucs_strings_mb[3881]},
	{{0x00000001,0x00000000,0x00000000},0x21c0,&ucs_strings_mb[3983]},
	{{0x00000000,0x00000000,0x00000000},0x25a8,&ucs_strings_mb[5834]},
	{{0x00000000,0x00000000,0x00000000},0x200f,&ucs_strings_mb[2889]},
	{{0x00000000,0x00000000,0x00000000},0x25a2,&ucs_strings_mb[5756]},
	{{0x40000001,0x00000000,0x00000000},0x308d,&ucs_strings_mb[5756]},
	{{0x00000001,0x00000020,0x00000000},0x30ed,&ucs_strings_mb[5756]},
	{{0x00000000,0x00000000,0x00000080},0x221a,&ucs_strings_mb[4251]},
	{{0x00000001,0x80000000,0x00000080},0x25a2,&ucs_strings_mb[5740]},
	{{0x00000000,0x00000000,0x00000000},0x25a3,&ucs_strings_mb[5770]},
	{{0x00000000,0x00000000,0x00000000},0x221a,&ucs_strings_mb[4256]},
	{{0x40000001,0x00000000,0x00000000},0x308b,&ucs_strings_mb[6651]},
	{{0x00000001,0x00000020,0x00000000},0x30eb,&ucs_strings_mb[6651]},
	{{0x00000000,0x00000000,0x00000000},0x211e,&ucs_strings_mb[3468]},
	{{0x00000000,0x00000000,0x00000000},0x25a9,&ucs_strings_mb[3468]},
	{{0x00000000,0x00000000,0x00000000},0x25a5,&ucs_strings_mb[5781]},
	{{0x00000000,0x00000000,0x00000000},0x25a7,&ucs_strings_mb[5831]},
	{{0x00000201,0x00000000,0x00000000},0x3119,&ucs_strings[1582]},
	{{0x00000013,0x00000040,0x00000000},0x015a,&ucs_strings[1582]},
	{{0x00000015,0x00000040,0x00000000},0x015b,&ucs_strings[1582]},
	{{0x00008003,0x00000040,0x00000000},0x015c,&ucs_strings[1582]},
	{{0x00008005,0x00000040,0x00000000},0x015d,&ucs_strings[1582]},
	{{0x00002003,0x00000040,0x00000000},0x015e,&ucs_strings[1582]},
	{{0x00002005,0x00000040,0x00000000},0x015f,&ucs_strings[1582]},
	{{0x00001003,0x00000040,0x00000000},0x0160,&ucs_strings[1582]},
	{{0x00001005,0x00000040,0x00000000},0x0161,&ucs_strings[1582]},
	{{0x00000005,0x00040040,0x00000000},0x24ae,&ucs_strings[1582]},
	{{0x00004003,0x00000040,0x00000000},0x24c8,&ucs_strings[1582]},
	{{0x00004005,0x00000040,0x00000000},0x24e2,&ucs_strings[1582]},
	{{0x0008000b,0x00000040,0x00000000},0x1e60,&ucs_strings[1582]},
	{{0x0008000d,0x00000040,0x00000000},0x1e61,&ucs_strings[1582]},
	{{0x00080103,0x00000040,0x00000000},0x1e62,&ucs_strings[1582]},
	{{0x00080105,0x00000040,0x00000000},0x1e63,&ucs_strings[1582]},
	{{0x0008001b,0x00000040,0x00000000},0x1e64,&ucs_strings[1582]},
	{{0x0008001d,0x00000040,0x00000000},0x1e65,&ucs_strings[1582]},
	{{0x0008100b,0x00000040,0x00000000},0x1e66,&ucs_strings[1582]},
	{{0x0008100d,0x00000040,0x00000000},0x1e67,&ucs_strings[1582]},
	{{0x0008010b,0x00000040,0x00000000},0x1e68,&ucs_strings[1582]},
	{{0x0008010d,0x00000040,0x00000000},0x1e69,&ucs_strings[1582]},
	{{0x00000000,0x00000000,0x00000000},0x24c8,&ucs_strings_mb[5385]},
	{{0x00000000,0x00000000,0x00000000},0x24e2,&ucs_strings_mb[5385]},
	{{0x00000000,0x00000000,0x00000000},0x0428,&ucs_strings_mb[1070]},
	{{0x00000000,0x00000000,0x00000000},0x0448,&ucs_strings_mb[1070]},
	{{0x00000000,0x00000000,0x00000000},0x015a,&ucs_strings_mb[181]},
	{{0x00000000,0x00000000,0x00000000},0x015b,&ucs_strings_mb[181]},
	{{0x00000000,0x00000000,0x00000000},0x1e64,&ucs_strings_mb[1908]},
	{{0x00000000,0x00000000,0x00000000},0x1e65,&ucs_strings_mb[1908]},
	{{0x00000000,0x00000000,0x00000000},0x03a3,&ucs_strings_mb[772]},
	{{0x00000000,0x00000000,0x00000000},0x03c3,&ucs_strings_mb[772]},
	{{0x00000000,0x00000000,0x00000000},0x05e1,&ucs_strings_mb[1277]},
	{{0x00000000,0x00000000,0x00000000},0x0633,&ucs_strings_mb[1277]},
	{{0x00000000,0x00000000,0x00000000},0xfeb3,&ucs_strings_mb[7167]},
	{{0x00000000,0x00000000,0x00000000},0xfeb1,&ucs_strings_mb[7159]},
	{{0x00000000,0x00000000,0x00000000},0xfeb2,&ucs_strings_mb[7163]},
	{{0x00000000,0x00000000,0x00000000},0xfeb4,&ucs_strings_mb[7171]},
	{{0x00000000,0x00000000,0x00000000},0x015e,&ucs_strings_mb[187]},
	{{0x00000000,0x00000000,0x00000000},0x015f,&ucs_strings_mb[187]},
	{{0x00000000,0x00000000,0x00000000},0x1e62,&ucs_strings_mb[1904]},
	{{0x00000000,0x00000000,0x00000000},0x1e63,&ucs_strings_mb[1904]},
	{{0x00000000,0x00000000,0x00000000},0x1e60,&ucs_strings_mb[1901]},
	{{0x00000000,0x00000000,0x00000000},0x1e61,&ucs_strings_mb[1901]},
	{{0x00000000,0x00000000,0x00000000},0x1e68,&ucs_strings_mb[1916]},
	{{0x00000000,0x00000000,0x00000000},0x1e69,&ucs_strings_mb[1916]},
	{{0x00000000,0x00000000,0x00000000},0x017f,&ucs_strings_mb[242]},
	{{0x00000000,0x00000000,0x00000000},0x3119,&ucs_strings_mb[6838]},
	{{0x00000000,0x00000000,0x00000000},0x0160,&ucs_strings_mb[190]},
	{{0x00000000,0x00000000,0x00000000},0x0161,&ucs_strings_mb[190]},
	{{0x00000000,0x00000000,0x00000000},0x1e66,&ucs_strings_mb[1912]},
	{{0x00000000,0x00000000,0x00000000},0x1e67,&ucs_strings_mb[1912]},
	{{0x00000000,0x00000000,0x00000000},0x0421,&ucs_strings_mb[1028]},
	{{0x00000000,0x00000000,0x00000000},0x0441,&ucs_strings_mb[1028]},
	{{0x00000000,0x00000000,0x00000000},0x015c,&ucs_strings_mb[184]},
	{{0x00000000,0x00000000,0x00000000},0x015d,&ucs_strings_mb[184]},
	{{0x40000001,0x00000000,0x00000000},0x3055,&ucs_strings[1843]},
	{{0x00000001,0x00000020,0x00000000},0x30b5,&ucs_strings[1843]},
	{{0x00000081,0x00000000,0x00000000},0x0635,&ucs_strings_mb[1469]},
	{{0x00000081,0x00000010,0x00000000},0xfeb9,&ucs_strings_mb[1469]},
	{{0x01000081,0x00000000,0x00000000},0xfeba,&ucs_strings_mb[1469]},
	{{0x00000081,0x00000004,0x00000000},0xfebb,&ucs_strings_mb[1469]},
	{{0x00000081,0x00001000,0x00000000},0xfebc,&ucs_strings_mb[1469]},
	{{0x20000001,0x00000000,0x00000000},0x05e1,&ucs_strings_mb[1270]},
	{{0x08000001,0x00000000,0x00000000},0x03e0,&ucs_strings_mb[866]},
	{{0x00000000,0x00000000,0x00000000},0x2022,&ucs_strings[1170]},
	{{0x00000000,0x00000000,0x00000000},0x2219,&ucs_strings[1170]},
	{{0x00000000,0x00000000,0x00000000},0x25aa,&ucs_strings[1170]},
	{{0x00000000,0x00000000,0x00000000},0x0429,&ucs_strings[2327]},
	{{0x00000000,0x00000000,0x00000000},0x0449,&ucs_strings[2327]},
	{{0x40000001,0x00000000,0x00000000},0x305b,&ucs_strings[2561]},
	{{0x00000001,0x00000020,0x00000000},0x30bb,&ucs_strings[2561]},
	{{0x00000081,0x00000000,0x00000000},0x0633,&ucs_strings_mb[1455]},
	{{0x00000081,0x00000010,0x00000000},0xfeb1,&ucs_strings_mb[1455]},
	{{0x01000081,0x00000000,0x00000000},0xfeb2,&ucs_strings_mb[1455]},
	{{0x00000081,0x00000004,0x00000000},0xfeb3,&ucs_strings_mb[1455]},
	{{0x00000081,0x00001000,0x00000000},0xfeb4,&ucs_strings_mb[1455]},
	{{0x40000000,0x00000820,0x00000000},0x309c,&ucs_strings_mb[6691]},
	{{0x00000080,0x00000000,0x00000000},0x061b,&ucs_strings[1487]},
	{{0x00000000,0x00000200,0x00000000},0x2028,&ucs_strings_mb[3077]},
	{{0x00000000,0x00000800,0x00000000},0x2120,&ucs_strings_mb[3471]},
	{{0x00000000,0x00000000,0x00000020},0x2077,&ucs_strings[1464]},
	{{0x00000000,0x00000000,0x00000040},0x2087,&ucs_strings[1464]},
	{{0x00004001,0x00000000,0x00000000},0x2466,&ucs_strings[1464]},
	{{0x00000001,0x00040000,0x00000000},0x247a,&ucs_strings[1464]},
	{{0x00000081,0x00000000,0x00000400},0x0667,&ucs_strings[1464]},
	{{0x00000000,0x00804000,0x00000000},0x2166,&ucs_strings[1464]},
	{{0x02000001,0x00000000,0x00000002},0x248e,&ucs_strings[1464]},
	{{0x00000000,0x00040000,0x00000800},0x3226,&ucs_strings[1464]},
	{{0x00000004,0x00804000,0x00000000},0x2176,&ucs_strings[1464]},
	{{0x00000000,0x00000000,0x00000018},0x215e,&ucs_strings_mb[3672]},
	{{0x00004000,0x00002000,0x00000000},0x2470,&ucs_strings_mb[4992]},
	{{0x00000000,0x00042000,0x00000000},0x2484,&ucs_strings_mb[4992]},
	{{0x02000000,0x00002000,0x00000002},0x2498,&ucs_strings_mb[4992]},
	{{0x00000000,0x00000000,0x00000000},0x05e9,&ucs_strings[728]},
	{{0x00000201,0x00000000,0x00000000},0x3115,&ucs_strings[728]},
	{{0x00010003,0x00000000,0x00000000},0x0428,&ucs_strings_mb[1066]},
	{{0x00010005,0x00000000,0x00000000},0x0448,&ucs_strings_mb[1066]},
	{{0x00000080,0x00000000,0x00000000},0x0651,&ucs_strings_mb[1629]},
	{{0x00000081,0x00001000,0x00000000},0xfe7d,&ucs_strings_mb[1629]},
	{{0x00000000,0x00000100,0x00000000},0x2591,&ucs_strings_mb[5698]},
	{{0x00010003,0x00000000,0x00000000},0x0429,&ucs_strings_mb[1073]},
	{{0x00010005,0x00000000,0x00000000},0x0449,&ucs_strings_mb[1073]},
	{{0x00000081,0x00000000,0x00000000},0x0634,&ucs_strings_mb[1460]},
	{{0x00000081,0x00000010,0x00000000},0xfeb5,&ucs_strings_mb[1460]},
	{{0x01000081,0x00000000,0x00000000},0xfeb6,&ucs_strings_mb[1460]},
	{{0x00000081,0x00000004,0x00000000},0xfeb7,&ucs_strings_mb[1460]},
	{{0x00000081,0x00001000,0x00000000},0xfeb8,&ucs_strings_mb[1460]},
	{{0x20000001,0x00000000,0x00000000},0x05e9,&ucs_strings_mb[1318]},
	{{0x40000001,0x00000000,0x00000000},0x3057,&ucs_strings[927]},
	{{0x00000001,0x00000020,0x00000000},0x30b7,&ucs_strings[927]},
	{{0x08000003,0x00000000,0x00000000},0x03a3,&ucs_strings_mb[766]},
	{{0x08000005,0x00000000,0x00000000},0x03c3,&ucs_strings_mb[766]},
	{{0x09000005,0x00000000,0x00000000},0x03c2,&ucs_strings_mb[766]},
	{{0x00000000,0x00000000,0x00000020},0x2076,&ucs_strings[1460]},
	{{0x00000000,0x00000000,0x00000040},0x2086,&ucs_strings[1460]},
	{{0x00004001,0x00000000,0x00000000},0x2465,&ucs_strings[1460]},
	{{0x00000001,0x00040000,0x00000000},0x2479,&ucs_strings[1460]},
	{{0x00000081,0x00000000,0x00000400},0x0666,&ucs_strings[1460]},
	{{0x00000000,0x00804000,0x00000000},0x2165,&ucs_strings[1460]},
	{{0x02000001,0x00000000,0x00000002},0x248d,&ucs_strings[1460]},
	{{0x00000000,0x00040000,0x00000800},0x3225,&ucs_strings[1460]},
	{{0x00000004,0x00804000,0x00000000},0x2175,&ucs_strings[1460]},
	{{0x00000000,0x00000000,0x00000200},0x2006,&ucs_strings_mb[2856]},
	{{0x00004000,0x00002000,0x00000000},0x246f,&ucs_strings_mb[4979]},
	{{0x00000000,0x00042000,0x00000000},0x2483,&ucs_strings_mb[4979]},
	{{0x02000000,0x00002000,0x00000002},0x2497,&ucs_strings_mb[4979]},
	{{0x00000000,0x00010000,0x00000018},0x2159,&ucs_strings_mb[3605]},
	{{0x00000000,0x00000000,0x00000008},0x2044,&ucs_strings[1429]},
	{{0x00000000,0x00000000,0x00000000},0x2120,&ucs_strings_mb[3479]},
	{{0x00000000,0x80000000,0x00000000},0x263a,&ucs_strings_mb[6087]},
	{{0x00000000,0x00000000,0x00000004},0x263b,&ucs_strings_mb[6087]},
	{{0x00000000,0x00000000,0x00000000},0x0634,&ucs_strings_mb[1466]},
	{{0x00000000,0x00000000,0x00000000},0x25d8,&ucs_strings_mb[1466]},
	{{0x00000000,0x00000000,0x00000000},0xfeb7,&ucs_strings_mb[7183]},
	{{0x00000000,0x00000000,0x00000000},0xfeb5,&ucs_strings_mb[7175]},
	{{0x00000000,0x00000000,0x00000000},0xfeb6,&ucs_strings_mb[7179]},
	{{0x00000000,0x00000000,0x00000000},0xfeb8,&ucs_strings_mb[7187]},
	{{0x40000001,0x00000000,0x00000000},0x305d,&ucs_strings[915]},
	{{0x00000001,0x00000020,0x00000000},0x30bd,&ucs_strings[915]},
	{{0x00010003,0x00000000,0x00000000},0x042c,&ucs_strings_mb[1095]},
	{{0x00010005,0x00000000,0x00000000},0x044c,&ucs_strings_mb[1095]},
	{{0x00000000,0x00000000,0x00000000},0x2117,&ucs_strings_mb[3421]},
	{{0x00000000,0x00000000,0x00002000},0x2198,&ucs_strings_mb[3944]},
	{{0x00000000,0x00000000,0x00002000},0x2199,&ucs_strings_mb[3959]},
	{{0x00000000,0x00000000,0x00008004},0x2660,&ucs_strings_mb[6133]},
	{{0x00000000,0x80000000,0x00008000},0x2664,&ucs_strings_mb[6133]},
	{{0x00000000,0x00000000,0x00000000},0x25ac,&ucs_strings_mb[5872]},
	{{0x00000000,0x00000000,0x00000000},0xfb05,&ucs_strings[2387]},
	{{0x00000000,0x00000000,0x00000000},0xfb06,&ucs_strings[2387]},
	{{0x00000004,0x00000040,0x00000100},0xfb06,&ucs_strings[2387]},
	{{0x00000000,0x00000000,0x00000004},0x2605,&ucs_strings_mb[6041]},
	{{0x00000000,0x80000000,0x00000000},0x2606,&ucs_strings_mb[6041]},
	{{0x08000001,0x00000000,0x00000000},0x03da,&ucs_strings_mb[836]},
	{{0x00000000,0x00000000,0x00000000},0x263c,&ucs_strings_mb[6112]},
	{{0x40000001,0x00000000,0x00000000},0x3059,&ucs_strings_mb[6112]},
	{{0x00000001,0x00000020,0x00000000},0x30b9,&ucs_strings_mb[6112]},
	{{0x00000000,0x00000000,0x00000001},0x2282,&ucs_strings_mb[4586]},
	{{0x00000000,0x04000000,0x00011001},0x2286,&ucs_strings_mb[4586]},
	{{0x00000080,0x00000000,0x00000000},0x0652,&ucs_strings_mb[1639]},
	{{0x00000001,0x80000000,0x00000000},0x263c,&ucs_strings_mb[6103]},
	{{0x00000000,0x00000000,0x00000001},0x2283,&ucs_strings_mb[4596]},
	{{0x00000000,0x04000000,0x00011001},0x2287,&ucs_strings_mb[4596]},
	{{0x00000201,0x00000000,0x00000000},0x310a,&ucs_strings[1584]},
	{{0x00002003,0x00000040,0x00000000},0x0162,&ucs_strings[1584]},
	{{0x00002005,0x00000040,0x00000000},0x0163,&ucs_strings[1584]},
	{{0x00001003,0x00000040,0x00000000},0x0164,&ucs_strings[1584]},
	{{0x00001005,0x00000040,0x00000000},0x0165,&ucs_strings[1584]},
	{{0x00000003,0x00000040,0x10000000},0x0166,&ucs_strings[1584]},
	{{0x00000005,0x00000040,0x10000000},0x0167,&ucs_strings[1584]},
	{{0x00000005,0x00040040,0x00000000},0x24af,&ucs_strings[1584]},
	{{0x00004003,0x00000040,0x00000000},0x24c9,&ucs_strings[1584]},
	{{0x00004005,0x00000040,0x00000000},0x24e3,&ucs_strings[1584]},
	{{0x0008000b,0x00000040,0x00000000},0x1e6a,&ucs_strings[1584]},
	{{0x0008000d,0x00000040,0x00000000},0x1e6b,&ucs_strings[1584]},
	{{0x00080103,0x00000040,0x00000000},0x1e6c,&ucs_strings[1584]},
	{{0x00080105,0x00000040,0x00000000},0x1e6d,&ucs_strings[1584]},
	{{0x00000103,0x00000240,0x00000000},0x1e6e,&ucs_strings[1584]},
	{{0x00000105,0x00000240,0x00000000},0x1e6f,&ucs_strings[1584]},
	{{0x00008103,0x00000040,0x00000000},0x1e70,&ucs_strings[1584]},
	{{0x00008105,0x00000040,0x00000000},0x1e71,&ucs_strings[1584]},
	{{0x00000000,0x00000000,0x00000000},0x24c9,&ucs_strings_mb[5389]},
	{{0x00000000,0x00000000,0x00000000},0x24e3,&ucs_strings_mb[5389]},
	{{0x00000000,0x00000000,0x00000000},0x03a4,&ucs_strings_mb[779]},
	{{0x00000000,0x00000000,0x00000000},0x03c4,&ucs_strings_mb[779]},
	{{0x00000000,0x00000000,0x00000000},0x05ea,&ucs_strings_mb[1327]},
	{{0x00000000,0x00000000,0x00000000},0x062a,&ucs_strings_mb[1327]},
	{{0x00000000,0x00000000,0x00000000},0xfe97,&ucs_strings_mb[7055]},
	{{0x00000000,0x00000000,0x00000000},0xfe95,&ucs_strings_mb[7047]},
	{{0x00000000,0x00000000,0x00000000},0xfe96,&ucs_strings_mb[7051]},
	{{0x00000000,0x00000000,0x00000000},0xfe98,&ucs_strings_mb[7059]},
	{{0x00000000,0x00000000,0x00000000},0x0162,&ucs_strings_mb[193]},
	{{0x00000000,0x00000000,0x00000000},0x0163,&ucs_strings_mb[193]},
	{{0x00000000,0x00000000,0x00000000},0x1e6c,&ucs_strings_mb[1924]},
	{{0x00000000,0x00000000,0x00000000},0x1e6d,&ucs_strings_mb[1924]},
	{{0x00000000,0x00000000,0x00000000},0x1e70,&ucs_strings_mb[1931]},
	{{0x00000000,0x00000000,0x00000000},0x1e71,&ucs_strings_mb[1931]},
	{{0x00000000,0x00000000,0x00000000},0x1e6a,&ucs_strings_mb[1921]},
	{{0x00000000,0x00000000,0x00000000},0x1e6b,&ucs_strings_mb[1921]},
	{{0x00000000,0x00000000,0x00000000},0x0166,&ucs_strings_mb[199]},
	{{0x00000000,0x00000000,0x00000000},0x0167,&ucs_strings_mb[199]},
	{{0x00000000,0x00000000,0x00000000},0x03da,&ucs_strings_mb[843]},
	{{0x00000000,0x00000000,0x00000000},0x310a,&ucs_strings_mb[6802]},
	{{0x00000000,0x00000000,0x00000000},0x0164,&ucs_strings_mb[196]},
	{{0x00000000,0x00000000,0x00000000},0x0165,&ucs_strings_mb[196]},
	{{0x00000000,0x00000000,0x00000000},0x0422,&ucs_strings_mb[1034]},
	{{0x00000000,0x00000000,0x00000000},0x0442,&ucs_strings_mb[1034]},
	{{0x00000000,0x00000000,0x00000000},0x1e6e,&ucs_strings_mb[1928]},
	{{0x00000000,0x00000000,0x00000000},0x1e6f,&ucs_strings_mb[1928]},
	{{0x40000001,0x00000000,0x00000000},0x305f,&ucs_strings_mb[6597]},
	{{0x00000001,0x00000020,0x00000000},0x30bf,&ucs_strings_mb[6597]},
	{{0x00000000,0x08000000,0x00000000},0x22a5,&ucs_strings_mb[4620]},
	{{0x00000081,0x00000000,0x00000000},0x0637,&ucs_strings_mb[1483]},
	{{0x00000081,0x00000010,0x00000000},0xfec1,&ucs_strings_mb[1483]},
	{{0x01000081,0x00000000,0x00000000},0xfec2,&ucs_strings_mb[1483]},
	{{0x00000081,0x00000004,0x00000000},0xfec3,&ucs_strings_mb[1483]},
	{{0x00000081,0x00001000,0x00000000},0xfec4,&ucs_strings_mb[1483]},
	{{0x00000080,0x00000000,0x00000000},0x0640,&ucs_strings_mb[1507]},
	{{0x08000003,0x00000000,0x00000000},0x03a4,&ucs_strings_mb[775]},
	{{0x08000005,0x00000000,0x00000000},0x03c4,&ucs_strings_mb[775]},
	{{0x20000001,0x00000000,0x00000000},0x05ea,&ucs_strings_mb[1323]},
	{{0x00000000,0x00000000,0x00000000},0x2580,&ucs_strings_mb[5668]},
	{{0x00000000,0x00000000,0x00000000},0x0686,&ucs_strings_mb[1707]},
	{{0x00000081,0x00000000,0x00000000},0x0686,&ucs_strings_mb[1701]},
	{{0x00000000,0x00000000,0x00000000},0x2203,&ucs_strings_mb[1031]},
	{{0x40000001,0x00000000,0x00000000},0x3066,&ucs_strings_mb[1031]},
	{{0x00000001,0x00000020,0x00000000},0x30c6,&ucs_strings_mb[1031]},
	{{0x00010003,0x00000000,0x00000000},0x0422,&ucs_strings_mb[1031]},
	{{0x00010005,0x00000000,0x00000000},0x0442,&ucs_strings_mb[1031]},
	{{0x00000081,0x00000000,0x00000000},0x062a,&ucs_strings_mb[1405]},
	{{0x00000081,0x00000010,0x00000000},0xfe95,&ucs_strings_mb[1405]},
	{{0x01000081,0x00000000,0x00000000},0xfe96,&ucs_strings_mb[1405]},
	{{0x00000081,0x00000004,0x00000000},0xfe97,&ucs_strings_mb[1405]},
	{{0x00000081,0x00001000,0x00000000},0xfe98,&ucs_strings_mb[1405]},
	{{0x00000081,0x00000000,0x00000000},0x0629,&ucs_strings_mb[1390]},
	{{0x00000081,0x00000010,0x00000000},0xfe93,&ucs_strings_mb[1390]},
	{{0x01000081,0x00000000,0x00000000},0xfe94,&ucs_strings_mb[1390]},
	{{0x00000000,0x00000000,0x00000000},0x260e,&ucs_strings_mb[6062]},
	{{0x00000000,0x00000000,0x00000000},0x260f,&ucs_strings_mb[6062]},
	{{0x00000000,0x00000000,0x00000004},0x260e,&ucs_strings_mb[6052]},
	{{0x00000000,0x80000000,0x00000000},0x260f,&ucs_strings_mb[6052]},
	{{0x00000000,0x00000000,0x00000000},0x2315,&ucs_strings_mb[4692]},
	{{0x00000000,0x00804000,0x00000000},0x2169,&ucs_strings_mb[3716]},
	{{0x00004000,0x00002000,0x00000000},0x2469,&ucs_strings_mb[3716]},
	{{0x00000000,0x00042000,0x00000000},0x247d,&ucs_strings_mb[3716]},
	{{0x00000000,0x00040000,0x00000800},0x3229,&ucs_strings_mb[3716]},
	{{0x00000004,0x00804000,0x00000000},0x2179,&ucs_strings_mb[3716]},
	{{0x02000000,0x00002000,0x00000002},0x2491,&ucs_strings_mb[3716]},
	{{0x00000000,0x00804000,0x00000000},0x2182,&ucs_strings_mb[3837]},
	{{0x20000001,0x00000000,0x00000000},0x05d8,&ucs_strings_mb[1217]},
	{{0x00000081,0x00000000,0x00000000},0x0630,&ucs_strings_mb[1438]},
	{{0x00000081,0x00000010,0x00000000},0xfeab,&ucs_strings_mb[1438]},
	{{0x01000081,0x00000000,0x00000000},0xfeac,&ucs_strings_mb[1438]},
	{{0x00000081,0x00000000,0x00000000},0x062b,&ucs_strings_mb[1409]},
	{{0x00000081,0x00000010,0x00000000},0xfe99,&ucs_strings_mb[1409]},
	{{0x01000081,0x00000000,0x00000000},0xfe9a,&ucs_strings_mb[1409]},
	{{0x00000081,0x00000004,0x00000000},0xfe9b,&ucs_strings_mb[1409]},
	{{0x00000081,0x00001000,0x00000000},0xfe9c,&ucs_strings_mb[1409]},
	{{0x00000000,0x00000000,0x00000000},0x2203,&ucs_strings_mb[4062]},
	{{0x00000000,0x00000000,0x00000000},0x2234,&ucs_strings_mb[4373]},
	{{0x08000003,0x00000000,0x00000000},0x0398,&ucs_strings_mb[708]},
	{{0x08000005,0x00000000,0x00000000},0x03b8,&ucs_strings_mb[708]},
	{{0x00000000,0x00000000,0x00000200},0x2009,&ucs_strings_mb[2870]},
	{{0x00000000,0x00010000,0x00000018},0x2153,&ucs_strings_mb[3528]},
	{{0x00004000,0x00002000,0x00000000},0x246c,&ucs_strings_mb[4938]},
	{{0x00000000,0x00042000,0x00000000},0x2480,&ucs_strings_mb[4938]},
	{{0x02000000,0x00002000,0x00000002},0x2494,&ucs_strings_mb[4938]},
	{{0x00000000,0x00814000,0x00000000},0x216f,&ucs_strings_mb[3781]},
	{{0x00000004,0x00814000,0x00000000},0x217f,&ucs_strings_mb[3781]},
	{{0x00000000,0x00814000,0x00000000},0x2180,&ucs_strings_mb[3796]},
	{{0x00000000,0x00000000,0x00000040},0x2083,&ucs_strings[1444]},
	{{0x00004001,0x00000000,0x00000000},0x2462,&ucs_strings[1444]},
	{{0x00000001,0x00040000,0x00000000},0x2476,&ucs_strings[1444]},
	{{0x00000081,0x00000000,0x00000400},0x0663,&ucs_strings[1444]},
	{{0x00000000,0x00804000,0x00000000},0x2162,&ucs_strings[1444]},
	{{0x02000001,0x00000000,0x00000002},0x248a,&ucs_strings[1444]},
	{{0x00000000,0x00040000,0x00000800},0x3222,&ucs_strings[1444]},
	{{0x00000004,0x00804000,0x00000000},0x2172,&ucs_strings[1444]},
	{{0x00000000,0x00000000,0x00000018},0x215c,&ucs_strings_mb[3639]},
	{{0x00000000,0x00000000,0x00000018},0x2157,&ucs_strings_mb[3574]},
	{{0x00000000,0x00000000,0x00000200},0x2004,&ucs_strings_mb[2825]},
	{{0x40000001,0x00000000,0x00000000},0x3061,&ucs_strings_mb[6603]},
	{{0x00000001,0x00000020,0x00000000},0x30c1,&ucs_strings_mb[6603]},
	{{0x00000000,0x00000000,0x00000000},0x05d8,&ucs_strings_mb[1221]},
	{{0x00000000,0x00000000,0x00000000},0x0637,&ucs_strings_mb[1221]},
	{{0x00000000,0x00000000,0x00000000},0xfec3,&ucs_strings_mb[7231]},
	{{0x00000000,0x00000000,0x00000000},0xfec1,&ucs_strings_mb[7223]},
	{{0x00000000,0x00000000,0x00000000},0xfec2,&ucs_strings_mb[7227]},
	{{0x00000000,0x00000000,0x00000000},0xfec4,&ucs_strings_mb[7235]},
	{{0x00000000,0x00000000,0x00000000},0x062b,&ucs_strings_mb[1414]},
	{{0x00000000,0x00000000,0x00000000},0xfe9b,&ucs_strings_mb[7071]},
	{{0x00000000,0x00000000,0x00000000},0xfe99,&ucs_strings_mb[7063]},
	{{0x00000000,0x00000000,0x00000000},0xfe9a,&ucs_strings_mb[7067]},
	{{0x00000000,0x00000000,0x00000000},0xfe9c,&ucs_strings_mb[7075]},
	{{0x00000000,0x00000000,0x00000000},0x25c1,&ucs_strings_mb[5916]},
	{{0x00000000,0x00000000,0x00000000},0x0629,&ucs_strings_mb[1402]},
	{{0x00000000,0x00000000,0x00000000},0x2122,&ucs_strings_mb[1402]},
	{{0x00000000,0x00000000,0x00000000},0xfe93,&ucs_strings_mb[7039]},
	{{0x00000000,0x00000000,0x00000000},0xfe94,&ucs_strings_mb[7043]},
	{{0x00000000,0x00000000,0x00080000},0x2320,&ucs_strings_mb[4732]},
	{{0x00000000,0x00000080,0x00020000},0x3014,&ucs_strings_mb[6486]},
	{{0x00000000,0x00400000,0x00020000},0x3015,&ucs_strings_mb[6486]},
	{{0x00000000,0x00000000,0x00000000},0x2315,&ucs_strings_mb[4711]},
	{{0x00000000,0x00000000,0x00000000},0x25b7,&ucs_strings_mb[4711]},
	{{0x00000001,0x00000800,0x00000000},0x2122,&ucs_strings_mb[3482]},
	{{0x00000000,0x00000000,0x00000000},0x2023,&ucs_strings_mb[3009]},
	{{0x00400400,0x00000101,0x00000000},0x2504,&ucs_strings_mb[5441]},
	{{0x10400400,0x00000001,0x00000000},0x2505,&ucs_strings_mb[5441]},
	{{0x00400400,0x40000100,0x00000000},0x2506,&ucs_strings_mb[5441]},
	{{0x10400400,0x40000000,0x00000000},0x2507,&ucs_strings_mb[5441]},
	{{0x00000000,0x00000000,0x00000000},0x2034,&ucs_strings_mb[3147]},
	{{0x00000000,0x00000000,0x00000000},0x040b,&ucs_strings[2156]},
	{{0x00000000,0x00000000,0x00000000},0x045b,&ucs_strings[2156]},
	{{0x20000001,0x00000000,0x00000000},0x05e6,&ucs_strings_mb[1294]},
	{{0x21000001,0x00000000,0x00000000},0x05e5,&ucs_strings_mb[1294]},
	{{0x00010003,0x00000000,0x00000000},0x0426,&ucs_strings_mb[1052]},
	{{0x00010005,0x00000000,0x00000000},0x0446,&ucs_strings_mb[1052]},
	{{0x00010003,0x00000000,0x00000000},0x040b,&ucs_strings_mb[922]},
	{{0x00010005,0x00000000,0x00000000},0x045b,&ucs_strings_mb[922]},
	{{0x40000001,0x00000000,0x00000000},0x3064,&ucs_strings_mb[6606]},
	{{0x00000001,0x00000020,0x00000000},0x30c4,&ucs_strings_mb[6606]},
	{{0x40000005,0x00000000,0x00000000},0x3063,&ucs_strings_mb[6606]},
	{{0x00000005,0x00000020,0x00000000},0x30c3,&ucs_strings_mb[6606]},
	{{0x00000005,0x00000040,0x00000000},0x01dd,&ucs_strings_mb[343]},
	{{0x00000000,0x00804000,0x00000000},0x216b,&ucs_strings_mb[3733]},
	{{0x00004000,0x00002000,0x00000000},0x246b,&ucs_strings_mb[3733]},
	{{0x00000000,0x00042000,0x00000000},0x247f,&ucs_strings_mb[3733]},
	{{0x00000004,0x00804000,0x00000000},0x217b,&ucs_strings_mb[3733]},
	{{0x02000000,0x00002000,0x00000002},0x2493,&ucs_strings_mb[3733]},
	{{0x00004000,0x00002000,0x00000000},0x2473,&ucs_strings_mb[5035]},
	{{0x00000000,0x00042000,0x00000000},0x2487,&ucs_strings_mb[5035]},
	{{0x02000000,0x00002000,0x00000002},0x249b,&ucs_strings_mb[5035]},
	{{0x00000000,0x00000000,0x00000040},0x2082,&ucs_strings[1440]},
	{{0x00004001,0x00000000,0x00000000},0x2461,&ucs_strings[1440]},
	{{0x00000001,0x00040000,0x00000000},0x2475,&ucs_strings[1440]},
	{{0x00000081,0x00000000,0x00000400},0x0662,&ucs_strings[1440]},
	{{0x00000000,0x00804000,0x00000000},0x2161,&ucs_strings[1440]},
	{{0x02000001,0x00000000,0x00000002},0x2489,&ucs_strings[1440]},
	{{0x00000000,0x00040000,0x00000800},0x3221,&ucs_strings[1440]},
	{{0x00000004,0x00804000,0x00000000},0x2171,&ucs_strings[1440]},
	{{0x00000000,0x00000000,0x00000018},0x2156,&ucs_strings_mb[3560]},
	{{0x00080000,0x00000000,0x00000000},0x2025,&ucs_strings_mb[3030]},
	{{0x00000000,0x00000000,0x00000018},0x2154,&ucs_strings_mb[3537]},
	{{0x40000001,0x00000000,0x00000000},0x3046,&ucs_strings[1586]},
	{{0x00000001,0x00000020,0x00000000},0x30a6,&ucs_strings[1586]},
	{{0x00000201,0x00000000,0x00000000},0x3128,&ucs_strings[1586]},
	{{0x00010003,0x00000000,0x00000000},0x0423,&ucs_strings[1586]},
	{{0x00010005,0x00000000,0x00000000},0x0443,&ucs_strings[1586]},
	{{0x40000005,0x00000000,0x00000000},0x3045,&ucs_strings[1586]},
	{{0x00000005,0x00000020,0x00000000},0x30a5,&ucs_strings[1586]},
	{{0x00000003,0x02000040,0x00000000},0x0168,&ucs_strings[1586]},
	{{0x00000005,0x02000040,0x00000000},0x0169,&ucs_strings[1586]},
	{{0x00000003,0x00000440,0x00000000},0x016a,&ucs_strings[1586]},
	{{0x00000005,0x00000440,0x00000000},0x016b,&ucs_strings[1586]},
	{{0x00000803,0x00000040,0x00000000},0x016c,&ucs_strings[1586]},
	{{0x00000805,0x00000040,0x00000000},0x016d,&ucs_strings[1586]},
	{{0x00000003,0x00000040,0x02000000},0x0172,&ucs_strings[1586]},
	{{0x00000005,0x00000040,0x02000000},0x0173,&ucs_strings[1586]},
	{{0x00000003,0x00000042,0x00000000},0x01af,&ucs_strings[1586]},
	{{0x00000005,0x00000042,0x00000000},0x01b0,&ucs_strings[1586]},
	{{0x00001003,0x00000040,0x00000000},0x01d3,&ucs_strings[1586]},
	{{0x00001005,0x00000040,0x00000000},0x01d4,&ucs_strings[1586]},
	{{0x00010003,0x00000000,0x08000000},0x040e,&ucs_strings[1586]},
	{{0x00010005,0x00000000,0x08000000},0x045e,&ucs_strings[1586]},
	{{0x00000005,0x00040040,0x00000000},0x24b0,&ucs_strings[1586]},
	{{0x00004003,0x00000040,0x00000000},0x24ca,&ucs_strings[1586]},
	{{0x00004005,0x00000040,0x00000000},0x24e4,&ucs_strings[1586]},
	{{0x0000000b,0x00000040,0x04000000},0x016e,&ucs_strings[1586]},
	{{0x0000000d,0x00000040,0x04000000},0x016f,&ucs_strings[1586]},
	{{0x00100013,0x00000040,0x00000000},0x0170,&ucs_strings[1586]},
	{{0x00100015,0x00000040,0x00000000},0x0171,&ucs_strings[1586]},
	{{0x00040003,0x00000440,0x00000000},0x01d5,&ucs_strings[1586]},
	{{0x00040005,0x00000440,0x00000000},0x01d6,&ucs_strings[1586]},
	{{0x00040013,0x00000040,0x00000000},0x01d7,&ucs_strings[1586]},
	{{0x00040015,0x00000040,0x00000000},0x01d8,&ucs_strings[1586]},
	{{0x00041003,0x00000040,0x00000000},0x01d9,&ucs_strings[1586]},
	{{0x00041005,0x00000040,0x00000000},0x01da,&ucs_strings[1586]},
	{{0x04040003,0x00000040,0x00000000},0x01db,&ucs_strings[1586]},
	{{0x04040005,0x00000040,0x00000000},0x01dc,&ucs_strings[1586]},
	{{0x04100003,0x00000040,0x00000000},0x0214,&ucs_strings[1586]},
	{{0x04100005,0x00000040,0x00000000},0x0215,&ucs_strings[1586]},
	{{0x00000803,0x00000040,0x00800000},0x0216,&ucs_strings[1586]},
	{{0x00000805,0x00000040,0x00800000},0x0217,&ucs_strings[1586]},
	{{0x00040103,0x00000040,0x00000000},0x1e72,&ucs_strings[1586]},
	{{0x00040105,0x00000040,0x00000000},0x1e73,&ucs_strings[1586]},
	{{0x00000103,0x02000040,0x00000000},0x1e74,&ucs_strings[1586]},
	{{0x00000105,0x02000040,0x00000000},0x1e75,&ucs_strings[1586]},
	{{0x00008103,0x00000040,0x00000000},0x1e76,&ucs_strings[1586]},
	{{0x00008105,0x00000040,0x00000000},0x1e77,&ucs_strings[1586]},
	{{0x00000013,0x02000040,0x00000000},0x1e78,&ucs_strings[1586]},
	{{0x00000015,0x02000040,0x00000000},0x1e79,&ucs_strings[1586]},
	{{0x00040003,0x00000440,0x00000000},0x1e7a,&ucs_strings[1586]},
	{{0x00040005,0x00000440,0x00000000},0x1e7b,&ucs_strings[1586]},
	{{0x00080103,0x00000040,0x00000000},0x1ee4,&ucs_strings[1586]},
	{{0x00080105,0x00000040,0x00000000},0x1ee5,&ucs_strings[1586]},
	{{0x8000000b,0x00000040,0x00000000},0x1ee6,&ucs_strings[1586]},
	{{0x8000000d,0x00000040,0x00000000},0x1ee7,&ucs_strings[1586]},
	{{0x00000013,0x00000042,0x00000000},0x1ee8,&ucs_strings[1586]},
	{{0x00000015,0x00000042,0x00000000},0x1ee9,&ucs_strings[1586]},
	{{0x04000003,0x00000042,0x00000000},0x1eea,&ucs_strings[1586]},
	{{0x04000005,0x00000042,0x00000000},0x1eeb,&ucs_strings[1586]},
	{{0x00000003,0x02000042,0x00000000},0x1eee,&ucs_strings[1586]},
	{{0x00000005,0x02000042,0x00000000},0x1eef,&ucs_strings[1586]},
	{{0x8000000b,0x00000042,0x00000000},0x1eec,&ucs_strings[1586]},
	{{0x8000000d,0x00000042,0x00000000},0x1eed,&ucs_strings[1586]},
	{{0x00080103,0x00000042,0x00000000},0x1ef0,&ucs_strings[1586]},
	{{0x00080105,0x00000042,0x00000000},0x1ef1,&ucs_strings[1586]},
	{{0x00000000,0x00000000,0x00000000},0x24ca,&ucs_strings_mb[5393]},
	{{0x00000000,0x00000000,0x00000000},0x24e4,&ucs_strings_mb[5393]},
	{{0x00000000,0x00000000,0x00000000},0x0214,&ucs_strings_mb[439]},
	{{0x00000000,0x00000000,0x00000000},0x0215,&ucs_strings_mb[439]},
	{{0x00000000,0x00000000,0x00000000},0x0170,&ucs_strings_mb[214]},
	{{0x00000000,0x00000000,0x00000000},0x0171,&ucs_strings_mb[214]},
	{{0x00000000,0x00000000,0x00000000},0x038e,&ucs_strings_mb[656]},
	{{0x00000000,0x00000000,0x00000000},0x03cd,&ucs_strings_mb[656]},
	{{0x00000000,0x00000000,0x00000000},0x016c,&ucs_strings_mb[208]},
	{{0x00000000,0x00000000,0x00000000},0x016d,&ucs_strings_mb[208]},
	{{0x00000000,0x00000000,0x00000000},0x0216,&ucs_strings_mb[443]},
	{{0x00000000,0x00000000,0x00000000},0x0217,&ucs_strings_mb[443]},
	{{0x00000000,0x00000000,0x00000000},0x03a5,&ucs_strings_mb[782]},
	{{0x00000000,0x00000000,0x00000000},0x03c5,&ucs_strings_mb[782]},
	{{0x00000000,0x00000000,0x00000000},0x1f7a,&ucs_strings_mb[2461]},
	{{0x00000000,0x00000000,0x00000000},0x1fea,&ucs_strings_mb[2461]},
	{{0x00000000,0x00000000,0x00000000},0x1f7b,&ucs_strings_mb[2465]},
	{{0x00000000,0x00000000,0x00000000},0x1feb,&ucs_strings_mb[2465]},
	{{0x00000000,0x00000000,0x00000000},0x1fe0,&ucs_strings_mb[2746]},
	{{0x00000000,0x00000000,0x00000000},0x1fe8,&ucs_strings_mb[2746]},
	{{0x00000000,0x00000000,0x00000000},0x1f50,&ucs_strings_mb[2345]},
	{{0x00000000,0x00000000,0x00000000},0x1f52,&ucs_strings_mb[2353]},
	{{0x00000000,0x00000000,0x00000000},0x1f54,&ucs_strings_mb[2363]},
	{{0x00000000,0x00000000,0x00000000},0x1f56,&ucs_strings_mb[2373]},
	{{0x00000000,0x00000000,0x00000000},0x1fe1,&ucs_strings_mb[2750]},
	{{0x00000000,0x00000000,0x00000000},0x1fe9,&ucs_strings_mb[2750]},
	{{0x00000000,0x00000000,0x00000000},0x1fe2,&ucs_strings_mb[2754]},
	{{0x00000000,0x00000000,0x00000000},0x1fe3,&ucs_strings_mb[2759]},
	{{0x00000000,0x00000000,0x00000000},0x1fe7,&ucs_strings_mb[2776]},
	{{0x00000000,0x00000000,0x00000000},0x1f51,&ucs_strings_mb[2349]},
	{{0x00000000,0x00000000,0x00000000},0x1f59,&ucs_strings_mb[2349]},
	{{0x00000000,0x00000000,0x00000000},0x1f53,&ucs_strings_mb[2358]},
	{{0x00000000,0x00000000,0x00000000},0x1f5b,&ucs_strings_mb[2358]},
	{{0x00000000,0x00000000,0x00000000},0x1f55,&ucs_strings_mb[2368]},
	{{0x00000000,0x00000000,0x00000000},0x1f5d,&ucs_strings_mb[2368]},
	{{0x00000000,0x00000000,0x00000000},0x1f57,&ucs_strings_mb[2378]},
	{{0x00000000,0x00000000,0x00000000},0x1f5f,&ucs_strings_mb[2378]},
	{{0x00000000,0x00000000,0x00000000},0x1fe6,&ucs_strings_mb[2772]},
	{{0x00000000,0x00000000,0x00000000},0x016a,&ucs_strings_mb[205]},
	{{0x00000000,0x00000000,0x00000000},0x016b,&ucs_strings_mb[205]},
	{{0x00000000,0x00000000,0x00000000},0x1e72,&ucs_strings_mb[1935]},
	{{0x00000000,0x00000000,0x00000000},0x1e73,&ucs_strings_mb[1935]},
	{{0x00000000,0x00000000,0x00000000},0x1ee4,&ucs_strings_mb[2134]},
	{{0x00000000,0x00000000,0x00000000},0x1ee5,&ucs_strings_mb[2134]},
	{{0x00000000,0x00000000,0x00000000},0x1e7a,&ucs_strings_mb[1952]},
	{{0x00000000,0x00000000,0x00000000},0x1e7b,&ucs_strings_mb[1952]},
	{{0x00000000,0x00000000,0x00000000},0x1e76,&ucs_strings_mb[1944]},
	{{0x00000000,0x00000000,0x00000000},0x1e77,&ucs_strings_mb[1944]},
	{{0x00000000,0x00000000,0x00000000},0x1e74,&ucs_strings_mb[1940]},
	{{0x00000000,0x00000000,0x00000000},0x1e75,&ucs_strings_mb[1940]},
	{{0x00000000,0x00000000,0x00000000},0x016e,&ucs_strings_mb[211]},
	{{0x00000000,0x00000000,0x00000000},0x016f,&ucs_strings_mb[211]},
	{{0x00000000,0x00000000,0x00000000},0x1ee6,&ucs_strings_mb[2138]},
	{{0x00000000,0x00000000,0x00000000},0x1ee7,&ucs_strings_mb[2138]},
	{{0x00000000,0x00000000,0x00000000},0x03b0,&ucs_strings_mb[815]},
	{{0x00000000,0x00000000,0x00000000},0x3128,&ucs_strings_mb[6873]},
	{{0x00000000,0x00000000,0x00000000},0x3045,&ucs_strings_mb[6549]},
	{{0x00000000,0x00000000,0x00000000},0x3046,&ucs_strings_mb[6549]},
	{{0x00000000,0x00000000,0x00000000},0x30a5,&ucs_strings_mb[6741]},
	{{0x00000000,0x00000000,0x00000000},0x30a6,&ucs_strings_mb[6741]},
	{{0x00000000,0x00000000,0x00000000},0x01af,&ucs_strings_mb[269]},
	{{0x00000000,0x00000000,0x00000000},0x01b0,&ucs_strings_mb[269]},
	{{0x00000000,0x00000000,0x00000000},0x1eea,&ucs_strings_mb[2145]},
	{{0x00000000,0x00000000,0x00000000},0x1eeb,&ucs_strings_mb[2145]},
	{{0x00000000,0x00000000,0x00000000},0x1ee8,&ucs_strings_mb[2141]},
	{{0x00000000,0x00000000,0x00000000},0x1ee9,&ucs_strings_mb[2141]},
	{{0x00000000,0x00000000,0x00000000},0x1ef0,&ucs_strings_mb[2157]},
	{{0x00000000,0x00000000,0x00000000},0x1ef1,&ucs_strings_mb[2157]},
	{{0x00000000,0x00000000,0x00000000},0x1eec,&ucs_strings_mb[2149]},
	{{0x00000000,0x00000000,0x00000000},0x1eed,&ucs_strings_mb[2149]},
	{{0x00000000,0x00000000,0x00000000},0x1eee,&ucs_strings_mb[2153]},
	{{0x00000000,0x00000000,0x00000000},0x1eef,&ucs_strings_mb[2153]},
	{{0x00000000,0x00000000,0x00000000},0x01db,&ucs_strings_mb[339]},
	{{0x00000000,0x00000000,0x00000000},0x01dc,&ucs_strings_mb[339]},
	{{0x00000000,0x00000000,0x00000000},0x01d7,&ucs_strings_mb[331]},
	{{0x00000000,0x00000000,0x00000000},0x01d8,&ucs_strings_mb[331]},
	{{0x00000000,0x00000000,0x00000000},0x01d5,&ucs_strings_mb[327]},
	{{0x00000000,0x00000000,0x00000000},0x01d6,&ucs_strings_mb[327]},
	{{0x00000000,0x00000000,0x00000000},0x01d9,&ucs_strings_mb[335]},
	{{0x00000000,0x00000000,0x00000000},0x01da,&ucs_strings_mb[335]},
	{{0x00000000,0x00000000,0x00000000},0x0172,&ucs_strings_mb[217]},
	{{0x00000000,0x00000000,0x00000000},0x0173,&ucs_strings_mb[217]},
	{{0x00000000,0x00000000,0x00000000},0x01d3,&ucs_strings_mb[324]},
	{{0x00000000,0x00000000,0x00000000},0x01d4,&ucs_strings_mb[324]},
	{{0x00000000,0x00000000,0x00000000},0x0423,&ucs_strings_mb[1037]},
	{{0x00000000,0x00000000,0x00000000},0x0443,&ucs_strings_mb[1037]},
	{{0x00000000,0x00000000,0x00000000},0x0168,&ucs_strings_mb[202]},
	{{0x00000000,0x00000000,0x00000000},0x0169,&ucs_strings_mb[202]},
	{{0x00000000,0x00000000,0x00000000},0x1e78,&ucs_strings_mb[1948]},
	{{0x00000000,0x00000000,0x00000000},0x1e79,&ucs_strings_mb[1948]},
	{{0x00000000,0x00000000,0x00000000},0x2195,&ucs_strings_mb[3911]},
	{{0x00000000,0x00000000,0x00000000},0x21a8,&ucs_strings_mb[3979]},
	{{0x00000000,0x00000000,0x00000000},0x2540,&ucs_strings_mb[5613]},
	{{0x00000000,0x00000000,0x00000000},0x2541,&ucs_strings_mb[5613]},
	{{0x00000000,0x00000000,0x00000000},0x2547,&ucs_strings_mb[5613]},
	{{0x00000000,0x00000000,0x00000000},0x2548,&ucs_strings_mb[5613]},
	{{0x00000000,0x00000000,0x00000000},0x2526,&ucs_strings_mb[5564]},
	{{0x00000000,0x00000000,0x00000000},0x2527,&ucs_strings_mb[5564]},
	{{0x00000000,0x00000000,0x00000000},0x2529,&ucs_strings_mb[5564]},
	{{0x00000000,0x00000000,0x00000000},0x252a,&ucs_strings_mb[5564]},
	{{0x00000000,0x00000000,0x00000000},0x2543,&ucs_strings_mb[5617]},
	{{0x00000000,0x00000000,0x00000000},0x2544,&ucs_strings_mb[5617]},
	{{0x00000000,0x00000000,0x00000000},0x2545,&ucs_strings_mb[5617]},
	{{0x00000000,0x00000000,0x00000000},0x2546,&ucs_strings_mb[5617]},
	{{0x00000000,0x00000000,0x00000000},0x251e,&ucs_strings_mb[5549]},
	{{0x00000000,0x00000000,0x00000000},0x251f,&ucs_strings_mb[5549]},
	{{0x00000000,0x00000000,0x00000000},0x2521,&ucs_strings_mb[5549]},
	{{0x00000000,0x00000000,0x00000000},0x2522,&ucs_strings_mb[5549]},
	{{0x00000000,0x00000000,0x00000000},0x2534,&ucs_strings_mb[5583]},
	{{0x00000000,0x00000000,0x00000000},0x2567,&ucs_strings_mb[5583]},
	{{0x00000000,0x00000000,0x00000000},0x2568,&ucs_strings_mb[5583]},
	{{0x00000000,0x00000000,0x00000000},0x2569,&ucs_strings_mb[5583]},
	{{0x00000000,0x00000000,0x00000000},0x2537,&ucs_strings_mb[5594]},
	{{0x00000000,0x00000000,0x00000000},0x2538,&ucs_strings_mb[5594]},
	{{0x00000000,0x00000000,0x00000000},0x253b,&ucs_strings_mb[5594]},
	{{0x00000000,0x00000000,0x00000000},0x2518,&ucs_strings_mb[5527]},
	{{0x00000000,0x00000000,0x00000000},0x255b,&ucs_strings_mb[5527]},
	{{0x00000000,0x00000000,0x00000000},0x255c,&ucs_strings_mb[5527]},
	{{0x00000000,0x00000000,0x00000000},0x255d,&ucs_strings_mb[5527]},
	{{0x00000000,0x00000000,0x00000000},0x2519,&ucs_strings_mb[5534]},
	{{0x00000000,0x00000000,0x00000000},0x251a,&ucs_strings_mb[5534]},
	{{0x00000000,0x00000000,0x00000000},0x251b,&ucs_strings_mb[5534]},
	{{0x00000000,0x00000000,0x00000000},0x2535,&ucs_strings_mb[5590]},
	{{0x00000000,0x00000000,0x00000000},0x2536,&ucs_strings_mb[5590]},
	{{0x00000000,0x00000000,0x00000000},0x2539,&ucs_strings_mb[5590]},
	{{0x00000000,0x00000000,0x00000000},0x253a,&ucs_strings_mb[5590]},
	{{0x00000000,0x00000000,0x00000000},0x222a,&ucs_strings_mb[4335]},
	{{0x00000000,0x00000000,0x00080000},0x2580,&ucs_strings_mb[5656]},
	{{0x00000001,0x04400080,0x00000080},0x25a7,&ucs_strings_mb[5814]},
	{{0x00000001,0x04400080,0x00000080},0x25a8,&ucs_strings_mb[5814]},
	{{0x00000000,0x00000000,0x00002000},0x2191,&ucs_strings_mb[3870]},
	{{0x00000000,0x00000000,0x00000000},0x2514,&ucs_strings_mb[5516]},
	{{0x00000000,0x00000000,0x00000000},0x2558,&ucs_strings_mb[5516]},
	{{0x00000000,0x00000000,0x00000000},0x2559,&ucs_strings_mb[5516]},
	{{0x00000000,0x00000000,0x00000000},0x255a,&ucs_strings_mb[5516]},
	{{0x00000000,0x00000000,0x00000000},0x2515,&ucs_strings_mb[5523]},
	{{0x00000000,0x00000000,0x00000000},0x2516,&ucs_strings_mb[5523]},
	{{0x00000000,0x00000000,0x00000000},0x2517,&ucs_strings_mb[5523]},
	{{0x00000000,0x00000000,0x00000000},0x25b2,&ucs_strings_mb[5893]},
	{{0x00000000,0x00000000,0x00000000},0x25b3,&ucs_strings_mb[5893]},
	{{0x00000201,0x00000000,0x00000000},0x312a,&ucs_strings[1588]},
	{{0x00000003,0x02000040,0x00000000},0x1e7c,&ucs_strings[1588]},
	{{0x00000005,0x02000040,0x00000000},0x1e7d,&ucs_strings[1588]},
	{{0x00000005,0x00040040,0x00000000},0x24b1,&ucs_strings[1588]},
	{{0x00004003,0x00000040,0x00000000},0x24cb,&ucs_strings[1588]},
	{{0x00004005,0x00000040,0x00000000},0x24e5,&ucs_strings[1588]},
	{{0x00080103,0x00000040,0x00000000},0x1e7e,&ucs_strings[1588]},
	{{0x00080105,0x00000040,0x00000000},0x1e7f,&ucs_strings[1588]},
	{{0x00000000,0x00000000,0x00000000},0x24cb,&ucs_strings_mb[5397]},
	{{0x00000000,0x00000000,0x00000000},0x24e5,&ucs_strings_mb[5397]},
	{{0x00000000,0x00000000,0x00000000},0x040e,&ucs_strings_mb[934]},
	{{0x00000000,0x00000000,0x00000000},0x045e,&ucs_strings_mb[934]},
	{{0x00000000,0x00000000,0x00000000},0x03ab,&ucs_strings_mb[812]},
	{{0x00000000,0x00000000,0x00000000},0x03cb,&ucs_strings_mb[812]},
	{{0x00000000,0x00000000,0x00000000},0x06a4,&ucs_strings_mb[1718]},
	{{0x00000000,0x00000000,0x00000000},0x1e7e,&ucs_strings_mb[1959]},
	{{0x00000000,0x00000000,0x00000000},0x1e7f,&ucs_strings_mb[1959]},
	{{0x00000000,0x00000000,0x00000000},0x0474,&ucs_strings_mb[1151]},
	{{0x00000000,0x00000000,0x00000000},0x0475,&ucs_strings_mb[1151]},
	{{0x00000000,0x00000000,0x00000000},0x312a,&ucs_strings_mb[6876]},
	{{0x00000000,0x00000000,0x00000000},0x0412,&ucs_strings_mb[954]},
	{{0x00000000,0x00000000,0x00000000},0x0432,&ucs_strings_mb[954]},
	{{0x00000000,0x00000000,0x00000000},0x1e7c,&ucs_strings_mb[1956]},
	{{0x00000000,0x00000000,0x00000000},0x1e7d,&ucs_strings_mb[1956]},
	{{0x00000001,0x00000020,0x00000000},0x30f7,&ucs_strings_mb[6753]},
	{{0x20000001,0x00000000,0x00000000},0x05d5,&ucs_strings_mb[1194]},
	{{0x00000001,0x00000020,0x00000000},0x30f9,&ucs_strings_mb[951]},
	{{0x00010003,0x00000000,0x00000000},0x0412,&ucs_strings_mb[951]},
	{{0x00010005,0x00000000,0x00000000},0x0432,&ucs_strings_mb[951]},
	{{0x00000081,0x00000000,0x00000000},0x06a4,&ucs_strings_mb[1714]},
	{{0x00000000,0x00000000,0x00000000},0x253c,&ucs_strings_mb[5598]},
	{{0x00000000,0x00000000,0x00000000},0x256a,&ucs_strings_mb[5598]},
	{{0x00000000,0x00000000,0x00000000},0x256b,&ucs_strings_mb[5598]},
	{{0x00000000,0x00000000,0x00000000},0x256c,&ucs_strings_mb[5598]},
	{{0x00000000,0x00000000,0x00000000},0x253f,&ucs_strings_mb[5609]},
	{{0x00000000,0x00000000,0x00000000},0x2542,&ucs_strings_mb[5609]},
	{{0x00000000,0x00000000,0x00000000},0x254b,&ucs_strings_mb[5609]},
	{{0x00000001,0x00000020,0x00000000},0x30f8,&ucs_strings_mb[6756]},
	{{0x00000000,0x00000000,0x00000000},0x2524,&ucs_strings_mb[5553]},
	{{0x00000000,0x00000000,0x00000000},0x2561,&ucs_strings_mb[5553]},
	{{0x00000000,0x00000000,0x00000000},0x2562,&ucs_strings_mb[5553]},
	{{0x00000000,0x00000000,0x00000000},0x2563,&ucs_strings_mb[5553]},
	{{0x00000000,0x00000000,0x00000000},0x2525,&ucs_strings_mb[5560]},
	{{0x00000000,0x00000000,0x00000000},0x2528,&ucs_strings_mb[5560]},
	{{0x00000000,0x00000000,0x00000000},0x252b,&ucs_strings_mb[5560]},
	{{0x00000000,0x00000000,0x00000000},0x253d,&ucs_strings_mb[5605]},
	{{0x00000000,0x00000000,0x00000000},0x253e,&ucs_strings_mb[5605]},
	{{0x00000000,0x00000000,0x00000000},0x2549,&ucs_strings_mb[5605]},
	{{0x00000000,0x00000000,0x00000000},0x254a,&ucs_strings_mb[5605]},
	{{0x00000001,0x00000020,0x00000000},0x30fa,&ucs_strings_mb[6759]},
	{{0x40000000,0x00000800,0x00000000},0x309e,&ucs_strings_mb[6715]},
	{{0x00000000,0x00000820,0x00000000},0x30fe,&ucs_strings_mb[6715]},
	{{0x40000000,0x00000820,0x00000000},0x309b,&ucs_strings_mb[6675]},
	{{0x00000000,0x00000000,0x00000000},0x251c,&ucs_strings_mb[5538]},
	{{0x00000000,0x00000000,0x00000000},0x255e,&ucs_strings_mb[5538]},
	{{0x00000000,0x00000000,0x00000000},0x255f,&ucs_strings_mb[5538]},
	{{0x00000000,0x00000000,0x00000000},0x2560,&ucs_strings_mb[5538]},
	{{0x00000000,0x00000000,0x00000000},0x251d,&ucs_strings_mb[5545]},
	{{0x00000000,0x00000000,0x00000000},0x2520,&ucs_strings_mb[5545]},
	{{0x00000000,0x00000000,0x00000000},0x2523,&ucs_strings_mb[5545]},
	{{0x08000045,0x00000000,0x00000000},0x1fb0,&ucs_strings_mb[2615]},
	{{0x08000043,0x00000000,0x00000000},0x1fb8,&ucs_strings_mb[2615]},
	{{0x08000005,0x00000008,0x00000000},0x1fd0,&ucs_strings_mb[2615]},
	{{0x08000003,0x00000008,0x00000000},0x1fd8,&ucs_strings_mb[2615]},
	{{0x08000005,0x10000000,0x00000000},0x1fe0,&ucs_strings_mb[2615]},
	{{0x08000003,0x10000000,0x00000000},0x1fe8,&ucs_strings_mb[2615]},
	{{0x00000000,0x00000000,0x00000000},0x2423,&ucs_strings[1960]},
	{{0x40000001,0x00000000,0x00000000},0x3094,&ucs_strings_mb[6672]},
	{{0x00000001,0x00000020,0x00000000},0x30f4,&ucs_strings_mb[6672]},
	{{0x00000000,0x00000000,0x00000000},0x2502,&ucs_strings_mb[5431]},
	{{0x00000000,0x00000000,0x00000000},0x2551,&ucs_strings_mb[5431]},
	{{0x00000000,0x00000000,0x00000000},0x2503,&ucs_strings_mb[5437]},
	{{0x00008003,0x00000040,0x00000000},0x0174,&ucs_strings[1590]},
	{{0x00008005,0x00000040,0x00000000},0x0175,&ucs_strings[1590]},
	{{0x04000003,0x00000040,0x00000000},0x1e80,&ucs_strings[1590]},
	{{0x04000005,0x00000040,0x00000000},0x1e81,&ucs_strings[1590]},
	{{0x00000013,0x00000040,0x00000000},0x1e82,&ucs_strings[1590]},
	{{0x00000015,0x00000040,0x00000000},0x1e83,&ucs_strings[1590]},
	{{0x00040003,0x00000040,0x00000000},0x1e84,&ucs_strings[1590]},
	{{0x00040005,0x00000040,0x00000000},0x1e85,&ucs_strings[1590]},
	{{0x00000005,0x00040040,0x00000000},0x24b2,&ucs_strings[1590]},
	{{0x00004003,0x00000040,0x00000000},0x24cc,&ucs_strings[1590]},
	{{0x00004005,0x00000040,0x00000000},0x24e6,&ucs_strings[1590]},
	{{0x0008000b,0x00000040,0x00000000},0x1e86,&ucs_strings[1590]},
	{{0x0008000d,0x00000040,0x00000000},0x1e87,&ucs_strings[1590]},
	{{0x00080103,0x00000040,0x00000000},0x1e88,&ucs_strings[1590]},
	{{0x00080105,0x00000040,0x00000000},0x1e89,&ucs_strings[1590]},
	{{0x00000000,0x00000000,0x00000000},0x24cc,&ucs_strings_mb[5401]},
	{{0x00000000,0x00000000,0x00000000},0x24e6,&ucs_strings_mb[5401]},
	{{0x00000000,0x00000000,0x00000000},0x1e80,&ucs_strings_mb[1963]},
	{{0x00000000,0x00000000,0x00000000},0x1e81,&ucs_strings_mb[1963]},
	{{0x00000000,0x00000000,0x00000000},0x038f,&ucs_strings_mb[659]},
	{{0x00000000,0x00000000,0x00000000},0x03ce,&ucs_strings_mb[659]},
	{{0x00000000,0x00000000,0x00000000},0x1e82,&ucs_strings_mb[1966]},
	{{0x00000000,0x00000000,0x00000000},0x1e83,&ucs_strings_mb[1966]},
	{{0x00000000,0x00000000,0x00000000},0x03a9,&ucs_strings_mb[806]},
	{{0x00000000,0x00000000,0x00000000},0x03c9,&ucs_strings_mb[806]},
	{{0x00000000,0x00000000,0x00000000},0x1f7c,&ucs_strings_mb[2469]},
	{{0x00000000,0x00000000,0x00000000},0x1ffa,&ucs_strings_mb[2469]},
	{{0x00000000,0x00000000,0x00000000},0x1ff2,&ucs_strings_mb[2790]},
	{{0x00000000,0x00000000,0x00000000},0x1f7d,&ucs_strings_mb[2473]},
	{{0x00000000,0x00000000,0x00000000},0x1ffb,&ucs_strings_mb[2473]},
	{{0x00000000,0x00000000,0x00000000},0x1ff4,&ucs_strings_mb[2799]},
	{{0x00000000,0x00000000,0x00000000},0x1f60,&ucs_strings_mb[2383]},
	{{0x00000000,0x00000000,0x00000000},0x1f68,&ucs_strings_mb[2383]},
	{{0x00000000,0x00000000,0x00000000},0x1f62,&ucs_strings_mb[2391]},
	{{0x00000000,0x00000000,0x00000000},0x1f6a,&ucs_strings_mb[2391]},
	{{0x00000000,0x00000000,0x00000000},0x1fa2,&ucs_strings_mb[2579]},
	{{0x00000000,0x00000000,0x00000000},0x1faa,&ucs_strings_mb[2579]},
	{{0x00000000,0x00000000,0x00000000},0x1f64,&ucs_strings_mb[2401]},
	{{0x00000000,0x00000000,0x00000000},0x1f6c,&ucs_strings_mb[2401]},
	{{0x00000000,0x00000000,0x00000000},0x1fa4,&ucs_strings_mb[2591]},
	{{0x00000000,0x00000000,0x00000000},0x1fac,&ucs_strings_mb[2591]},
	{{0x00000000,0x00000000,0x00000000},0x1f66,&ucs_strings_mb[2411]},
	{{0x00000000,0x00000000,0x00000000},0x1f6e,&ucs_strings_mb[2411]},
	{{0x00000000,0x00000000,0x00000000},0x1fa6,&ucs_strings_mb[2603]},
	{{0x00000000,0x00000000,0x00000000},0x1fae,&ucs_strings_mb[2603]},
	{{0x00000000,0x00000000,0x00000000},0x1fa0,&ucs_strings_mb[2569]},
	{{0x00000000,0x00000000,0x00000000},0x1fa8,&ucs_strings_mb[2569]},
	{{0x00000000,0x00000000,0x00000000},0x1f61,&ucs_strings_mb[2387]},
	{{0x00000000,0x00000000,0x00000000},0x1f69,&ucs_strings_mb[2387]},
	{{0x00000000,0x00000000,0x00000000},0x1f63,&ucs_strings_mb[2396]},
	{{0x00000000,0x00000000,0x00000000},0x1f6b,&ucs_strings_mb[2396]},
	{{0x00000000,0x00000000,0x00000000},0x1fa3,&ucs_strings_mb[2585]},
	{{0x00000000,0x00000000,0x00000000},0x1fab,&ucs_strings_mb[2585]},
	{{0x00000000,0x00000000,0x00000000},0x1f65,&ucs_strings_mb[2406]},
	{{0x00000000,0x00000000,0x00000000},0x1f6d,&ucs_strings_mb[2406]},
	{{0x00000000,0x00000000,0x00000000},0x1fa5,&ucs_strings_mb[2597]},
	{{0x00000000,0x00000000,0x00000000},0x1fad,&ucs_strings_mb[2597]},
	{{0x00000000,0x00000000,0x00000000},0x1f67,&ucs_strings_mb[2416]},
	{{0x00000000,0x00000000,0x00000000},0x1f6f,&ucs_strings_mb[2416]},
	{{0x00000000,0x00000000,0x00000000},0x1fa7,&ucs_strings_mb[2609]},
	{{0x00000000,0x00000000,0x00000000},0x1faf,&ucs_strings_mb[2609]},
	{{0x00000000,0x00000000,0x00000000},0x1fa1,&ucs_strings_mb[2574]},
	{{0x00000000,0x00000000,0x00000000},0x1fa9,&ucs_strings_mb[2574]},
	{{0x00000000,0x00000000,0x00000000},0x1ff6,&ucs_strings_mb[2804]},
	{{0x00000000,0x00000000,0x00000000},0x1ff7,&ucs_strings_mb[2808]},
	{{0x00000000,0x00000000,0x00000000},0x1ff3,&ucs_strings_mb[2795]},
	{{0x00000000,0x00000000,0x00000000},0x1ffc,&ucs_strings_mb[2795]},
	{{0x00000000,0x00000000,0x00000000},0x05d5,&ucs_strings_mb[1198]},
	{{0x00000000,0x00000000,0x00000000},0x0648,&ucs_strings_mb[1198]},
	{{0x00000000,0x00000000,0x00000000},0xfeed,&ucs_strings_mb[7399]},
	{{0x00000000,0x00000000,0x00000000},0xfeee,&ucs_strings_mb[7403]},
	{{0x00000000,0x00000000,0x00000000},0x1e88,&ucs_strings_mb[1975]},
	{{0x00000000,0x00000000,0x00000000},0x1e89,&ucs_strings_mb[1975]},
	{{0x00000000,0x00000000,0x00000000},0x1e86,&ucs_strings_mb[1972]},
	{{0x00000000,0x00000000,0x00000000},0x1e87,&ucs_strings_mb[1972]},
	{{0x00000000,0x00000000,0x00000000},0x1e84,&ucs_strings_mb[1969]},
	{{0x00000000,0x00000000,0x00000000},0x1e85,&ucs_strings_mb[1969]},
	{{0x00000000,0x00000000,0x00000000},0x20a9,&ucs_strings_mb[3344]},
	{{0x00000000,0x00000000,0x00000000},0x0174,&ucs_strings_mb[220]},
	{{0x00000000,0x00000000,0x00000000},0x0175,&ucs_strings_mb[220]},
	{{0x40000001,0x00000000,0x00000000},0x308f,&ucs_strings_mb[6657]},
	{{0x00000001,0x00000020,0x00000000},0x30ef,&ucs_strings_mb[6657]},
	{{0x40000005,0x00000000,0x00000000},0x308e,&ucs_strings_mb[6657]},
	{{0x00000005,0x00000020,0x00000000},0x30ee,&ucs_strings_mb[6657]},
	{{0x00000000,0x00000000,0x00000000},0x301c,&ucs_strings_mb[6513]},
	{{0x00000081,0x00000000,0x00000000},0x0648,&ucs_strings_mb[1547]},
	{{0x00000081,0x00000010,0x00000000},0xfeed,&ucs_strings_mb[1547]},
	{{0x01000081,0x00000000,0x00000000},0xfeee,&ucs_strings_mb[1547]},
	{{0x00000089,0x00000000,0x00000000},0x0624,&ucs_strings_mb[1360]},
	{{0x00000089,0x00000010,0x00000000},0xfe85,&ucs_strings_mb[1360]},
	{{0x40000001,0x00000000,0x00000000},0x3091,&ucs_strings_mb[6663]},
	{{0x00000001,0x00000020,0x00000000},0x30f1,&ucs_strings_mb[6663]},
	{{0x00000000,0x00000000,0x00000000},0x0624,&ucs_strings_mb[1370]},
	{{0x00000000,0x00000000,0x00000000},0xfe85,&ucs_strings_mb[7007]},
	{{0x40000001,0x00000000,0x00000000},0x3090,&ucs_strings_mb[6660]},
	{{0x00000001,0x00000020,0x00000000},0x30f0,&ucs_strings_mb[6660]},
	{{0x40000001,0x00000000,0x00000000},0x3092,&ucs_strings_mb[6666]},
	{{0x00000001,0x00000020,0x00000000},0x30f2,&ucs_strings_mb[6666]},
	{{0x00000001,0x00000000,0x00000000},0x20a9,&ucs_strings_mb[3340]},
	{{0x00000201,0x00000000,0x00000000},0x3112,&ucs_strings[1592]},
	{{0x00040003,0x00000040,0x00000000},0x1e8c,&ucs_strings[1592]},
	{{0x00040005,0x00000040,0x00000000},0x1e8d,&ucs_strings[1592]},
	{{0x00000005,0x00040040,0x00000000},0x24b3,&ucs_strings[1592]},
	{{0x00004003,0x00000040,0x00000000},0x24cd,&ucs_strings[1592]},
	{{0x00004005,0x00000040,0x00000000},0x24e7,&ucs_strings[1592]},
	{{0x0008000b,0x00000040,0x00000000},0x1e8a,&ucs_strings[1592]},
	{{0x0008000d,0x00000040,0x00000000},0x1e8b,&ucs_strings[1592]},
	{{0x00000000,0x00000000,0x00000000},0x24cd,&ucs_strings_mb[5405]},
	{{0x00000000,0x00000000,0x00000000},0x24e7,&ucs_strings_mb[5405]},
	{{0x00000000,0x00000000,0x00000000},0x03a7,&ucs_strings_mb[796]},
	{{0x00000000,0x00000000,0x00000000},0x03c7,&ucs_strings_mb[796]},
	{{0x00000000,0x00000000,0x00000000},0x05d7,&ucs_strings_mb[1214]},
	{{0x00000000,0x00000000,0x00000000},0x062e,&ucs_strings_mb[1214]},
	{{0x00000000,0x00000000,0x00000000},0xfea7,&ucs_strings_mb[7119]},
	{{0x00000000,0x00000000,0x00000000},0xfea5,&ucs_strings_mb[7111]},
	{{0x00000000,0x00000000,0x00000000},0xfea6,&ucs_strings_mb[7115]},
	{{0x00000000,0x00000000,0x00000000},0xfea8,&ucs_strings_mb[7123]},
	{{0x00000000,0x00000000,0x00000000},0x1e8a,&ucs_strings_mb[1979]},
	{{0x00000000,0x00000000,0x00000000},0x1e8b,&ucs_strings_mb[1979]},
	{{0x00000000,0x00000000,0x00000000},0x3112,&ucs_strings_mb[6826]},
	{{0x00000000,0x00000000,0x00000000},0x1e8c,&ucs_strings_mb[1982]},
	{{0x00000000,0x00000000,0x00000000},0x1e8d,&ucs_strings_mb[1982]},
	{{0x08000003,0x00000000,0x00000000},0x039e,&ucs_strings_mb[747]},
	{{0x08000005,0x00000000,0x00000000},0x03be,&ucs_strings_mb[747]},
	{{0x00000000,0x00000000,0x00000000},0x2717,&ucs_strings_mb[6321]},
	{{0x00008003,0x00000040,0x00000000},0x0176,&ucs_strings[1594]},
	{{0x00008005,0x00000040,0x00000000},0x0177,&ucs_strings[1594]},
	{{0x00040003,0x00000040,0x00000000},0x0178,&ucs_strings[1594]},
	{{0x04000003,0x00000040,0x00000000},0x1ef2,&ucs_strings[1594]},
	{{0x04000005,0x00000040,0x00000000},0x1ef3,&ucs_strings[1594]},
	{{0x00000003,0x02000040,0x00000000},0x1ef8,&ucs_strings[1594]},
	{{0x00000005,0x02000040,0x00000000},0x1ef9,&ucs_strings[1594]},
	{{0x00000005,0x00040040,0x00000000},0x24b4,&ucs_strings[1594]},
	{{0x00004003,0x00000040,0x00000000},0x24ce,&ucs_strings[1594]},
	{{0x00004005,0x00000040,0x00000000},0x24e8,&ucs_strings[1594]},
	{{0x0008000b,0x00000040,0x00000000},0x1e8e,&ucs_strings[1594]},
	{{0x0008000d,0x00000040,0x00000000},0x1e8f,&ucs_strings[1594]},
	{{0x00080103,0x00000040,0x00000000},0x1ef4,&ucs_strings[1594]},
	{{0x00080105,0x00000040,0x00000000},0x1ef5,&ucs_strings[1594]},
	{{0x8000000b,0x00000040,0x00000000},0x1ef6,&ucs_strings[1594]},
	{{0x8000000d,0x00000040,0x00000000},0x1ef7,&ucs_strings[1594]},
	{{0x00000000,0x00000000,0x00000000},0x24ce,&ucs_strings_mb[5409]},
	{{0x00000000,0x00000000,0x00000000},0x24e8,&ucs_strings_mb[5409]},
	{{0x00000000,0x00000000,0x00000000},0x1ef2,&ucs_strings_mb[2162]},
	{{0x00000000,0x00000000,0x00000000},0x1ef3,&ucs_strings_mb[2162]},
	{{0x00000000,0x00000000,0x00000000},0x0389,&ucs_strings_mb[639]},
	{{0x00000000,0x00000000,0x00000000},0x03ae,&ucs_strings_mb[639]},
	{{0x00000000,0x00000000,0x00000000},0x0397,&ucs_strings_mb[705]},
	{{0x00000000,0x00000000,0x00000000},0x03b7,&ucs_strings_mb[705]},
	{{0x00000000,0x00000000,0x00000000},0x1f74,&ucs_strings_mb[2437]},
	{{0x00000000,0x00000000,0x00000000},0x1fca,&ucs_strings_mb[2437]},
	{{0x00000000,0x00000000,0x00000000},0x1fc2,&ucs_strings_mb[2673]},
	{{0x00000000,0x00000000,0x00000000},0x1f75,&ucs_strings_mb[2441]},
	{{0x00000000,0x00000000,0x00000000},0x1fcb,&ucs_strings_mb[2441]},
	{{0x00000000,0x00000000,0x00000000},0x1fc4,&ucs_strings_mb[2682]},
	{{0x00000000,0x00000000,0x00000000},0x1f20,&ucs_strings_mb[2241]},
	{{0x00000000,0x00000000,0x00000000},0x1f28,&ucs_strings_mb[2241]},
	{{0x00000000,0x00000000,0x00000000},0x1f22,&ucs_strings_mb[2249]},
	{{0x00000000,0x00000000,0x00000000},0x1f2a,&ucs_strings_mb[2249]},
	{{0x00000000,0x00000000,0x00000000},0x1f92,&ucs_strings_mb[2533]},
	{{0x00000000,0x00000000,0x00000000},0x1f9a,&ucs_strings_mb[2533]},
	{{0x00000000,0x00000000,0x00000000},0x1f24,&ucs_strings_mb[2259]},
	{{0x00000000,0x00000000,0x00000000},0x1f2c,&ucs_strings_mb[2259]},
	{{0x00000000,0x00000000,0x00000000},0x1f94,&ucs_strings_mb[2545]},
	{{0x00000000,0x00000000,0x00000000},0x1f9c,&ucs_strings_mb[2545]},
	{{0x00000000,0x00000000,0x00000000},0x1f26,&ucs_strings_mb[2269]},
	{{0x00000000,0x00000000,0x00000000},0x1f2e,&ucs_strings_mb[2269]},
	{{0x00000000,0x00000000,0x00000000},0x1f96,&ucs_strings_mb[2557]},
	{{0x00000000,0x00000000,0x00000000},0x1f9e,&ucs_strings_mb[2557]},
	{{0x00000000,0x00000000,0x00000000},0x1f90,&ucs_strings_mb[2523]},
	{{0x00000000,0x00000000,0x00000000},0x1f98,&ucs_strings_mb[2523]},
	{{0x00000000,0x00000000,0x00000000},0x1f21,&ucs_strings_mb[2245]},
	{{0x00000000,0x00000000,0x00000000},0x1f29,&ucs_strings_mb[2245]},
	{{0x00000000,0x00000000,0x00000000},0x1f23,&ucs_strings_mb[2254]},
	{{0x00000000,0x00000000,0x00000000},0x1f2b,&ucs_strings_mb[2254]},
	{{0x00000000,0x00000000,0x00000000},0x1f93,&ucs_strings_mb[2539]},
	{{0x00000000,0x00000000,0x00000000},0x1f9b,&ucs_strings_mb[2539]},
	{{0x00000000,0x00000000,0x00000000},0x1f25,&ucs_strings_mb[2264]},
	{{0x00000000,0x00000000,0x00000000},0x1f2d,&ucs_strings_mb[2264]},
	{{0x00000000,0x00000000,0x00000000},0x1f95,&ucs_strings_mb[2551]},
	{{0x00000000,0x00000000,0x00000000},0x1f9d,&ucs_strings_mb[2551]},
	{{0x00000000,0x00000000,0x00000000},0x1f27,&ucs_strings_mb[2274]},
	{{0x00000000,0x00000000,0x00000000},0x1f2f,&ucs_strings_mb[2274]},
	{{0x00000000,0x00000000,0x00000000},0x1f97,&ucs_strings_mb[2563]},
	{{0x00000000,0x00000000,0x00000000},0x1f9f,&ucs_strings_mb[2563]},
	{{0x00000000,0x00000000,0x00000000},0x1f91,&ucs_strings_mb[2528]},
	{{0x00000000,0x00000000,0x00000000},0x1f99,&ucs_strings_mb[2528]},
	{{0x00000000,0x00000000,0x00000000},0x1fc6,&ucs_strings_mb[2687]},
	{{0x00000000,0x00000000,0x00000000},0x1fc7,&ucs_strings_mb[2691]},
	{{0x00000000,0x00000000,0x00000000},0x1fc3,&ucs_strings_mb[2678]},
	{{0x00000000,0x00000000,0x00000000},0x1fcc,&ucs_strings_mb[2678]},
	{{0x00000000,0x00000000,0x00000000},0x064a,&ucs_strings_mb[1563]},
	{{0x00000000,0x00000000,0x00000000},0xfef3,&ucs_strings_mb[7423]},
	{{0x00000000,0x00000000,0x00000000},0xfef1,&ucs_strings_mb[7415]},
	{{0x00000000,0x00000000,0x00000000},0xfef2,&ucs_strings_mb[7419]},
	{{0x00000000,0x00000000,0x00000000},0xfef4,&ucs_strings_mb[7427]},
	{{0x00000000,0x00000000,0x00000000},0x1ef4,&ucs_strings_mb[2165]},
	{{0x00000000,0x00000000,0x00000000},0x1ef5,&ucs_strings_mb[2165]},
	{{0x00000000,0x00000000,0x00000000},0x1e8e,&ucs_strings_mb[1985]},
	{{0x00000000,0x00000000,0x00000000},0x1e8f,&ucs_strings_mb[1985]},
	{{0x00000000,0x00000000,0x00000000},0x1ef6,&ucs_strings_mb[2169]},
	{{0x00000000,0x00000000,0x00000000},0x1ef7,&ucs_strings_mb[2169]},
	{{0x00000000,0x00000000,0x00000000},0x0462,&ucs_strings_mb[1125]},
	{{0x00000000,0x00000000,0x00000000},0x0463,&ucs_strings_mb[1125]},
	{{0x00000000,0x00000000,0x00000000},0x0178,&ucs_strings[2952]},
	{{0x00000000,0x00000000,0x00000000},0x042b,&ucs_strings_mb[1092]},
	{{0x00000000,0x00000000,0x00000000},0x044b,&ucs_strings_mb[1092]},
	{{0x00000000,0x00000000,0x00000000},0x0176,&ucs_strings_mb[223]},
	{{0x00000000,0x00000000,0x00000000},0x0177,&ucs_strings_mb[223]},
	{{0x00000000,0x00000000,0x00000000},0x1ef8,&ucs_strings_mb[2172]},
	{{0x00000000,0x00000000,0x00000000},0x1ef9,&ucs_strings_mb[2172]},
	{{0x40000001,0x00000000,0x00000000},0x3084,&ucs_strings_mb[1109]},
	{{0x00000001,0x00000020,0x00000000},0x30e4,&ucs_strings_mb[1109]},
	{{0x00010003,0x00000000,0x00000000},0x042f,&ucs_strings_mb[1109]},
	{{0x00010005,0x00000000,0x00000000},0x044f,&ucs_strings_mb[1109]},
	{{0x40000005,0x00000000,0x00000000},0x3083,&ucs_strings_mb[1109]},
	{{0x00000005,0x00000020,0x00000000},0x30e3,&ucs_strings_mb[1109]},
	{{0x00010003,0x00000000,0x00000000},0x0462,&ucs_strings_mb[1121]},
	{{0x00010005,0x00000000,0x00000000},0x0463,&ucs_strings_mb[1121]},
	{{0x00000081,0x00000000,0x00000000},0x064a,&ucs_strings_mb[1559]},
	{{0x00000081,0x00000010,0x00000000},0xfef1,&ucs_strings_mb[1559]},
	{{0x01000081,0x00000000,0x00000000},0xfef2,&ucs_strings_mb[1559]},
	{{0x00000081,0x00000004,0x00000000},0xfef3,&ucs_strings_mb[1559]},
	{{0x00000081,0x00001000,0x00000000},0xfef4,&ucs_strings_mb[1559]},
	{{0x00000089,0x00000000,0x00000000},0x0626,&ucs_strings_mb[1373]},
	{{0x00000089,0x00000004,0x00000000},0xfe8b,&ucs_strings_mb[1373]},
	{{0x00010003,0x00000000,0x00000000},0x042b,&ucs_strings_mb[1087]},
	{{0x00010005,0x00000000,0x00000000},0x044b,&ucs_strings_mb[1087]},
	{{0x00000000,0x00000000,0x00000000},0x0626,&ucs_strings_mb[1383]},
	{{0x00000000,0x00000000,0x00000000},0xfe8b,&ucs_strings_mb[7011]},
	{{0x00000000,0x00000000,0x00000000},0x0407,&ucs_strings_mb[905]},
	{{0x00000000,0x00000000,0x00000000},0x0457,&ucs_strings_mb[905]},
	{{0x00010003,0x00000000,0x00000000},0x0407,&ucs_strings_mb[905]},
	{{0x00010005,0x00000000,0x00000000},0x0457,&ucs_strings_mb[905]},
	{{0x40000001,0x00000000,0x00000000},0x3088,&ucs_strings_mb[6645]},
	{{0x00000001,0x00000020,0x00000000},0x30e8,&ucs_strings_mb[6645]},
	{{0x40000005,0x00000000,0x00000000},0x3087,&ucs_strings_mb[6645]},
	{{0x00000005,0x00000020,0x00000000},0x30e7,&ucs_strings_mb[6645]},
	{{0x20000001,0x00000000,0x00000000},0x05d9,&ucs_strings_mb[1224]},
	{{0x08000000,0x00000000,0x00000000},0x037a,&ucs_strings_mb[575]},
	{{0x08000045,0x00000000,0x00000000},0x1fb3,&ucs_strings_mb[575]},
	{{0x08800005,0x00000000,0x00000000},0x1fc3,&ucs_strings_mb[575]},
	{{0x08000005,0x00008000,0x00000000},0x1ff3,&ucs_strings_mb[575]},
	{{0x08000045,0x00200000,0x00000000},0x1f80,&ucs_strings_mb[575]},
	{{0x08020045,0x00000000,0x00000000},0x1f81,&ucs_strings_mb[575]},
	{{0x08800005,0x00200000,0x00000000},0x1f90,&ucs_strings_mb[575]},
	{{0x08820005,0x00000000,0x00000000},0x1f91,&ucs_strings_mb[575]},
	{{0x08000005,0x00208000,0x00000000},0x1fa0,&ucs_strings_mb[575]},
	{{0x08020005,0x00008000,0x00000000},0x1fa1,&ucs_strings_mb[575]},
	{{0x08000045,0x20000000,0x00000000},0x1fb2,&ucs_strings_mb[575]},
	{{0x08000045,0x00020000,0x00000000},0x1fb4,&ucs_strings_mb[575]},
	{{0x08000045,0x00080000,0x00000000},0x1fb7,&ucs_strings_mb[575]},
	{{0x08800005,0x20000000,0x00000000},0x1fc2,&ucs_strings_mb[575]},
	{{0x08800005,0x00020000,0x00000000},0x1fc4,&ucs_strings_mb[575]},
	{{0x08800005,0x00080000,0x00000000},0x1fc7,&ucs_strings_mb[575]},
	{{0x08000005,0x20008000,0x00000000},0x1ff2,&ucs_strings_mb[575]},
	{{0x08000005,0x00028000,0x00000000},0x1ff4,&ucs_strings_mb[575]},
	{{0x08000005,0x00088000,0x00000000},0x1ff7,&ucs_strings_mb[575]},
	{{0x08000045,0x20200000,0x00000000},0x1f82,&ucs_strings_mb[575]},
	{{0x08020045,0x20000000,0x00000000},0x1f83,&ucs_strings_mb[575]},
	{{0x08000045,0x00220000,0x00000000},0x1f84,&ucs_strings_mb[575]},
	{{0x08020045,0x00020000,0x00000000},0x1f85,&ucs_strings_mb[575]},
	{{0x08000045,0x00280000,0x00000000},0x1f86,&ucs_strings_mb[575]},
	{{0x08020045,0x00080000,0x00000000},0x1f87,&ucs_strings_mb[575]},
	{{0x08800005,0x20200000,0x00000000},0x1f92,&ucs_strings_mb[575]},
	{{0x08820005,0x20000000,0x00000000},0x1f93,&ucs_strings_mb[575]},
	{{0x08800005,0x00220000,0x00000000},0x1f94,&ucs_strings_mb[575]},
	{{0x08820005,0x00020000,0x00000000},0x1f95,&ucs_strings_mb[575]},
	{{0x08800005,0x00280000,0x00000000},0x1f96,&ucs_strings_mb[575]},
	{{0x08820005,0x00080000,0x00000000},0x1f97,&ucs_strings_mb[575]},
	{{0x08000005,0x20208000,0x00000000},0x1fa2,&ucs_strings_mb[575]},
	{{0x08020005,0x20008000,0x00000000},0x1fa3,&ucs_strings_mb[575]},
	{{0x08000005,0x00228000,0x00000000},0x1fa4,&ucs_strings_mb[575]},
	{{0x08020005,0x00028000,0x00000000},0x1fa5,&ucs_strings_mb[575]},
	{{0x08000005,0x00288000,0x00000000},0x1fa6,&ucs_strings_mb[575]},
	{{0x08020005,0x00088000,0x00000000},0x1fa7,&ucs_strings_mb[575]},
	{{0x00000000,0x00000000,0x00000000},0x01a6,&ucs_strings_mb[266]},
	{{0x00000001,0x00000040,0x00000000},0x01a6,&ucs_strings_mb[266]},
	{{0x40000001,0x00000000,0x00000000},0x3086,&ucs_strings_mb[1103]},
	{{0x00000001,0x00000020,0x00000000},0x30e6,&ucs_strings_mb[1103]},
	{{0x00010003,0x00000000,0x00000000},0x042e,&ucs_strings_mb[1103]},
	{{0x00010005,0x00000000,0x00000000},0x044e,&ucs_strings_mb[1103]},
	{{0x40000005,0x00000000,0x00000000},0x3085,&ucs_strings_mb[1103]},
	{{0x00000005,0x00000020,0x00000000},0x30e5,&ucs_strings_mb[1103]},
	{{0x00010003,0x00000000,0x00200000},0x046a,&ucs_strings_mb[1128]},
	{{0x00010005,0x00000000,0x00200000},0x046b,&ucs_strings_mb[1128]},
	{{0x00000201,0x00000000,0x00000000},0x3117,&ucs_strings[1596]},
	{{0x00000013,0x00000040,0x00000000},0x0179,&ucs_strings[1596]},
	{{0x00000015,0x00000040,0x00000000},0x017a,&ucs_strings[1596]},
	{{0x00001003,0x00000040,0x00000000},0x017d,&ucs_strings[1596]},
	{{0x00001005,0x00000040,0x00000000},0x017e,&ucs_strings[1596]},
	{{0x00000003,0x00000040,0x10000000},0x01b5,&ucs_strings[1596]},
	{{0x00000005,0x00000040,0x10000000},0x01b6,&ucs_strings[1596]},
	{{0x00008003,0x00000040,0x00000000},0x1e90,&ucs_strings[1596]},
	{{0x00008005,0x00000040,0x00000000},0x1e91,&ucs_strings[1596]},
	{{0x00000005,0x00040040,0x00000000},0x24b5,&ucs_strings[1596]},
	{{0x00004003,0x00000040,0x00000000},0x24cf,&ucs_strings[1596]},
	{{0x00004005,0x00000040,0x00000000},0x24e9,&ucs_strings[1596]},
	{{0x0008000b,0x00000040,0x00000000},0x017b,&ucs_strings[1596]},
	{{0x0008000d,0x00000040,0x00000000},0x017c,&ucs_strings[1596]},
	{{0x00080103,0x00000040,0x00000000},0x1e92,&ucs_strings[1596]},
	{{0x00080105,0x00000040,0x00000000},0x1e93,&ucs_strings[1596]},
	{{0x00000103,0x00000240,0x00000000},0x1e94,&ucs_strings[1596]},
	{{0x00000105,0x00000240,0x00000000},0x1e95,&ucs_strings[1596]},
	{{0x00000000,0x00000000,0x00000000},0x24cf,&ucs_strings_mb[5413]},
	{{0x00000000,0x00000000,0x00000000},0x24e9,&ucs_strings_mb[5413]},
	{{0x00000000,0x00000000,0x00000000},0x0416,&ucs_strings_mb[977]},
	{{0x00000000,0x00000000,0x00000000},0x0436,&ucs_strings_mb[977]},
	{{0x00000000,0x00000000,0x00000000},0x0179,&ucs_strings_mb[226]},
	{{0x00000000,0x00000000,0x00000000},0x017a,&ucs_strings_mb[226]},
	{{0x00000000,0x00000000,0x00000000},0x0396,&ucs_strings_mb[702]},
	{{0x00000000,0x00000000,0x00000000},0x03b6,&ucs_strings_mb[702]},
	{{0x00000000,0x00000000,0x00000000},0x05d6,&ucs_strings_mb[1207]},
	{{0x00000000,0x00000000,0x00000000},0x0632,&ucs_strings_mb[1207]},
	{{0x00000000,0x00000000,0x00000000},0xfeaf,&ucs_strings_mb[7151]},
	{{0x00000000,0x00000000,0x00000000},0xfeb0,&ucs_strings_mb[7155]},
	{{0x00000000,0x00000000,0x00000000},0x1e92,&ucs_strings_mb[1991]},
	{{0x00000000,0x00000000,0x00000000},0x1e93,&ucs_strings_mb[1991]},
	{{0x00000000,0x00000000,0x00000000},0x017b,&ucs_strings_mb[229]},
	{{0x00000000,0x00000000,0x00000000},0x017c,&ucs_strings_mb[229]},
	{{0x00000000,0x00000000,0x00000000},0x01b5,&ucs_strings_mb[272]},
	{{0x00000000,0x00000000,0x00000000},0x01b6,&ucs_strings_mb[272]},
	{{0x00000000,0x00000000,0x00000000},0x3117,&ucs_strings_mb[6832]},
	{{0x00000000,0x00000000,0x00000000},0x017d,&ucs_strings_mb[232]},
	{{0x00000000,0x00000000,0x00000000},0x017e,&ucs_strings_mb[232]},
	{{0x00000000,0x00000000,0x00000000},0x0417,&ucs_strings_mb[983]},
	{{0x00000000,0x00000000,0x00000000},0x0437,&ucs_strings_mb[983]},
	{{0x00000000,0x00000000,0x00000000},0x1e90,&ucs_strings_mb[1988]},
	{{0x00000000,0x00000000,0x00000000},0x1e91,&ucs_strings_mb[1988]},
	{{0x00000000,0x00000000,0x00000000},0x1e94,&ucs_strings_mb[1995]},
	{{0x00000000,0x00000000,0x00000000},0x1e95,&ucs_strings_mb[1995]},
	{{0x40000001,0x00000000,0x00000000},0x3056,&ucs_strings_mb[6585]},
	{{0x00000001,0x00000020,0x00000000},0x30b6,&ucs_strings_mb[6585]},
	{{0x00000081,0x00000000,0x00000000},0x0638,&ucs_strings_mb[1487]},
	{{0x00000081,0x00000010,0x00000000},0xfec5,&ucs_strings_mb[1487]},
	{{0x01000081,0x00000000,0x00000000},0xfec6,&ucs_strings_mb[1487]},
	{{0x00000081,0x00000004,0x00000000},0xfec7,&ucs_strings_mb[1487]},
	{{0x00000081,0x00001000,0x00000000},0xfec8,&ucs_strings_mb[1487]},
	{{0x00000081,0x00000000,0x00000000},0x0632,&ucs_strings_mb[1450]},
	{{0x00000081,0x00000010,0x00000000},0xfeaf,&ucs_strings_mb[1450]},
	{{0x01000081,0x00000000,0x00000000},0xfeb0,&ucs_strings_mb[1450]},
	{{0x20000001,0x00000000,0x00000000},0x05d6,&ucs_strings_mb[1201]},
	{{0x40000001,0x00000000,0x00000000},0x305c,&ucs_strings_mb[980]},
	{{0x00000001,0x00000020,0x00000000},0x30bc,&ucs_strings_mb[980]},
	{{0x00010003,0x00000000,0x00000000},0x0417,&ucs_strings_mb[980]},
	{{0x00010005,0x00000000,0x00000000},0x0437,&ucs_strings_mb[980]},
	{{0x00000000,0x00000000,0x00000020},0x2070,&ucs_strings[1435]},
	{{0x00000000,0x00000000,0x00000040},0x2080,&ucs_strings[1435]},
	{{0x00004001,0x00000000,0x00000000},0x24ea,&ucs_strings[1435]},
	{{0x00000081,0x00000000,0x00000400},0x0660,&ucs_strings[1435]},
	{{0x00000000,0x00002000,0x00000800},0x3007,&ucs_strings[1435]},
	{{0x08000003,0x00000000,0x00000000},0x0396,&ucs_strings_mb[697]},
	{{0x08000005,0x00000000,0x00000000},0x03b6,&ucs_strings_mb[697]},
	{{0x00000000,0x00000000,0x00000000},0x0638,&ucs_strings_mb[1491]},
	{{0x00000201,0x00000000,0x00000000},0x3113,&ucs_strings_mb[1491]},
	{{0x00000000,0x00000000,0x00000000},0xfec7,&ucs_strings_mb[7247]},
	{{0x00000000,0x00000000,0x00000000},0xfec5,&ucs_strings_mb[7239]},
	{{0x00000000,0x00000000,0x00000000},0xfec6,&ucs_strings_mb[7243]},
	{{0x00000000,0x00000000,0x00000000},0xfec8,&ucs_strings_mb[7251]},
	{{0x00010003,0x00000000,0x00000000},0x0416,&ucs_strings_mb[973]},
	{{0x00010005,0x00000000,0x00000000},0x0436,&ucs_strings_mb[973]},
	{{0x40000001,0x00000000,0x00000000},0x3058,&ucs_strings_mb[6588]},
	{{0x00000001,0x00000020,0x00000000},0x30b8,&ucs_strings_mb[6588]},
	{{0x00000000,0x00000000,0x00000000},0x05e5,&ucs_strings_mb[1300]},
	{{0x00000000,0x00000000,0x00000000},0x05e6,&ucs_strings_mb[1300]},
	{{0x00000000,0x00000000,0x00000000},0x0698,&ucs_strings_mb[1300]},
	{{0x40000001,0x00000000,0x00000000},0x305e,&ucs_strings_mb[6594]},
	{{0x00000001,0x00000020,0x00000000},0x30be,&ucs_strings_mb[6594]},
	{{0x40000001,0x00000000,0x00000000},0x305a,&ucs_strings_mb[6591]},
	{{0x00000001,0x00000020,0x00000000},0x30ba,&ucs_strings_mb[6591]},
#endif /* UCS_BYTE */
};
