/*******************************************************************
*                                                                  *
*             This software is part of the ast package             *
*                Copyright (c) 1989-2001 AT&T Corp.                *
*        and it may only be used by you under license from         *
*                       AT&T Corp. ("AT&T")                        *
*         A copy of the Source Code Agreement is available         *
*                at the AT&T Internet web site URL                 *
*                                                                  *
*       http://www.research.att.com/sw/license/ast-open.html       *
*                                                                  *
*        If you have copied this software without agreeing         *
*        to the terms of the license you are infringing on         *
*           the license and copyright and are violating            *
*               AT&T's intellectual property rights.               *
*                                                                  *
*                 This software was created by the                 *
*                 Network Services Research Center                 *
*                        AT&T Labs Research                        *
*                         Florham Park NJ                          *
*                                                                  *
*                 Phong Vo <kpv@research.att.com>                  *
*******************************************************************/
/* : : generated by a yacc that works -- solaris take note : : */
#include "ast.h"

/* # line 2 "/home/gsf/src/lib/libexpr/exparse.y" */

#pragma prototyped

/*
 * Glenn Fowler
 * AT&T Research
 *
 * expression library grammar and compiler
 *
 * NOTE: procedure arguments not implemented yet
 */

#include <ast.h>

#undef	RS	/* hp.pa <signal.h> grabs this!! */


/* # line 20 "/home/gsf/src/lib/libexpr/exparse.y" */
typedef union
#ifdef __cplusplus
	EXSTYPE
#endif

{
	struct Exnode_s*expr;
	double		floating;
	struct Exref_s*	reference;
	struct Exid_s*	id;
	Sflong_t	integer;
	int		op;
	char*		string;
	struct Exbuf_s*	buffer;
} EXSTYPE;
# define MINTOKEN 257
# define CHAR 258
# define INT 259
# define INTEGER 260
# define UNSIGNED 261
# define FLOATING 262
# define STRING 263
# define VOID 264
# define BREAK 265
# define CALL 266
# define CASE 267
# define CONSTANT 268
# define CONTINUE 269
# define DECLARE 270
# define DEFAULT 271
# define DYNAMIC 272
# define ELSE 273
# define EXIT 274
# define FOR 275
# define FUNCTION 276
# define ITERATE 277
# define ID 278
# define IF 279
# define LABEL 280
# define MEMBER 281
# define NAME 282
# define POS 283
# define PRAGMA 284
# define PRE 285
# define PRINTF 286
# define PROCEDURE 287
# define QUERY 288
# define RETURN 289
# define SPRINTF 290
# define SWITCH 291
# define WHILE 292
# define F2I 293
# define F2S 294
# define I2F 295
# define I2S 296
# define S2B 297
# define S2F 298
# define S2I 299
# define F2X 300
# define I2X 301
# define S2X 302
# define X2F 303
# define X2I 304
# define X2S 305
# define OR 306
# define AND 307
# define EQ 308
# define NE 309
# define LE 310
# define GE 311
# define LS 312
# define RS 313
# define UNARY 314
# define INC 315
# define DEC 316
# define CAST 317
# define MAXTOKEN 318

/* # line 127 "/home/gsf/src/lib/libexpr/exparse.y" */

#include "exgram.h"


#include <malloc.h>
#include <memory.h>
#include <unistd.h>
#include <values.h>

#ifdef __cplusplus
extern "C" {
#endif
extern char *gettxt(const char *, const char *);
#if !defined(exlex) && !defined(__my_exlex)
	extern int exlex(void);
#endif

#ifdef __cplusplus
}
#endif

#if (defined(__cplusplus) || defined(_XOPEN_SOURCE)) && !defined(exerror) && !defined(__my_exerror)
	void exerror(const char *);
#endif
int exparse(void);
#define exclearin exchar = -1
#define exerrok exerrflag = 0
extern int exchar;
extern int exerrflag;
EXSTYPE exlval;
EXSTYPE exval;
typedef int extabelem;
#ifndef EXMAXDEPTH
#define EXMAXDEPTH 150
#endif
#if EXMAXDEPTH > 0
int ex_exs[EXMAXDEPTH], *exs = ex_exs;
EXSTYPE ex_exv[EXMAXDEPTH], *exv = ex_exv;
#else	/* user does initial allocation */
int *exs;
EXSTYPE *exv;
#endif
static int exmaxdepth = EXMAXDEPTH;
# define EXERRCODE 256

/* # line 1008 "/home/gsf/src/lib/libexpr/exparse.y" */


#include "exgram.h"
extabelem exexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	276, 103,
	278, 103,
	59, 36,
	-2, 2,
-1, 12,
	59, 36,
	-2, 103,
-1, 13,
	59, 36,
	-2, 103,
-1, 14,
	59, 36,
	-2, 103,
-1, 41,
	59, 36,
	-2, 103,
-1, 45,
	59, 36,
	-2, 103,
-1, 80,
	41, 92,
	-2, 103,
-1, 81,
	41, 92,
	-2, 103,
-1, 105,
	60, 0,
	62, 0,
	310, 0,
	311, 0,
	-2, 40,
-1, 112,
	60, 0,
	62, 0,
	310, 0,
	311, 0,
	-2, 47,
-1, 113,
	60, 0,
	62, 0,
	310, 0,
	311, 0,
	-2, 48,
-1, 114,
	60, 0,
	62, 0,
	310, 0,
	311, 0,
	-2, 49,
-1, 115,
	308, 0,
	309, 0,
	-2, 50,
-1, 116,
	308, 0,
	309, 0,
	-2, 51,
-1, 127,
	41, 92,
	-2, 103,
-1, 142,
	59, 36,
	-2, 103,
-1, 143,
	59, 36,
	-2, 103,
-1, 144,
	59, 36,
	-2, 103,
-1, 145,
	59, 36,
	-2, 103,
-1, 156,
	276, 103,
	278, 103,
	59, 36,
	-2, 5,
-1, 171,
	59, 36,
	-2, 103,
-1, 172,
	41, 36,
	-2, 103,
-1, 184,
	59, 36,
	-2, 103,
-1, 192,
	41, 97,
	-2, 101,
-1, 196,
	276, 103,
	278, 103,
	59, 36,
	-2, 23,
-1, 212,
	59, 36,
	-2, 103,
	};
# define EXNPROD 111
# define EXLAST 1051
extabelem exact[]={

    17,   141,    40,    55,   208,   140,    86,    16,    53,    66,
    20,    52,    19,    54,   207,    33,    77,    78,    78,   134,
   171,   143,   210,   192,    29,    34,    37,    38,    36,   199,
   194,   185,   189,    83,    35,    17,   190,     4,     2,     6,
    90,    86,    16,   188,    41,    20,    95,    19,   211,   173,
   130,   178,    48,    49,    50,    21,   169,   177,   172,    91,
   139,   150,   144,    55,   104,   103,   102,    42,    53,    66,
    17,    52,   204,    54,    82,   138,   200,    16,    86,    92,
    20,   205,    19,    88,    88,    99,    51,   203,    58,   153,
     5,   184,   213,    18,   166,   164,    55,   154,    55,    96,
   127,    53,    66,    53,    52,    17,    54,   152,    54,   126,
    26,    81,    16,    80,    79,    20,    47,    19,    46,   128,
    45,    44,   201,   183,   202,     5,   174,    93,    18,   124,
   158,   187,   133,   181,   146,    43,    55,    63,    87,    89,
    17,    53,    66,    69,    52,   137,    54,    16,    39,     3,
    20,   168,    19,    24,   206,   193,    98,   165,   191,    51,
     5,    58,    70,    18,    55,    63,   186,   175,    94,    53,
    66,    69,    52,   189,    54,   170,   156,   190,   149,   131,
   160,   161,   159,   163,   162,     1,   157,    51,     0,    58,
    70,     0,     0,    65,     0,    96,     0,     0,    18,     0,
     0,     0,   176,     0,     0,     0,     0,     0,     0,   179,
     0,     0,   180,     0,   198,     0,     0,     0,     0,     0,
   155,    65,   195,    64,     0,     0,   196,    37,    38,    36,
    25,   197,    12,    18,   209,    35,    13,     7,     0,    33,
     0,    22,     9,     0,     0,     0,     8,     0,     0,    34,
   212,    64,     0,    30,    23,    31,    14,    32,    11,    10,
    84,    85,    37,    38,    36,    25,     0,    12,     0,     0,
    35,    13,     7,     0,    33,     0,    22,     9,    56,    57,
     0,     8,    27,    28,    34,     0,     0,     0,    30,    23,
    31,    14,    32,    11,    10,    84,    85,    37,    38,    36,
    25,     0,    12,     0,     0,    35,    13,     7,     0,    33,
     0,    22,     9,     0,     0,     0,     8,    27,    28,    34,
     0,     0,     0,    30,    23,    31,    14,    32,    11,    10,
     0,     0,    37,    38,    36,    25,    59,    60,    56,    57,
    35,     0,    72,     0,    33,     0,    22,     0,     0,     0,
     0,     0,    27,    28,    34,     0,     0,     0,    30,    23,
    31,     0,    32,     0,     0,     0,     0,    37,    38,    36,
    25,     0,     0,     0,     0,    35,     0,     0,     0,    33,
     0,    22,     0,     0,     0,     0,     0,    27,    28,    34,
     0,     0,     0,    30,    23,    31,     0,    32,     0,     0,
     0,     0,     0,     0,     0,    68,    67,    61,    62,    59,
    60,    56,    57,     0,     0,     0,     0,     0,     0,     0,
    55,    63,    27,    28,   151,    53,    66,    69,    52,     0,
    54,     0,     0,    68,    67,    61,    62,    59,    60,    56,
    57,     0,     0,    51,     0,    58,    70,    55,    63,     0,
     0,   145,    53,    66,    69,    52,     0,    54,    55,    63,
     0,     0,   142,    53,    66,    69,    52,     0,    54,     0,
    51,     0,    58,    70,     0,     0,     0,    65,     0,     0,
     0,    51,     0,    58,    70,    55,    63,     0,     0,   125,
    53,    66,    69,    52,     0,    54,     0,     0,     0,     0,
     0,     0,     0,     0,    65,     0,     0,    64,    51,     0,
    58,    70,    55,    63,     0,    65,     0,    53,    66,    69,
    52,     0,    54,    55,    63,     0,     0,     0,    53,    66,
     0,    52,     0,    54,    64,    51,     0,    58,    70,     0,
     0,     0,    65,     0,     0,    64,    51,     0,    58,    70,
    55,    63,     0,     0,     0,    53,    66,     0,    52,     0,
    54,     0,     0,     0,     0,     0,     0,     0,     0,    65,
     0,     0,    64,    51,     0,    58,     0,    55,    63,     0,
    65,     0,    53,    66,     0,    52,     0,    54,    55,    63,
     0,     0,     0,    53,    66,     0,    52,     0,    54,    64,
    51,     0,    58,     0,     0,     0,     0,    65,     0,     0,
    64,    51,     0,    58,     0,    55,    63,     0,     0,     0,
    53,    66,     0,    52,     0,    54,     0,     0,     0,     0,
     0,     0,     0,     0,    65,     0,    55,    64,    51,     0,
    58,    53,    66,     0,    52,    65,    54,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    51,
     0,    58,     0,     0,    64,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    68,
    67,    61,    62,    59,    60,    56,    57,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    68,    67,    61,    62,
    59,    60,    56,    57,     0,     0,     0,    68,    67,    61,
    62,    59,    60,    56,    57,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    68,    67,    61,    62,    59,    60,
    56,    57,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    68,    67,    61,    62,    59,    60,    56,    57,     0,
     0,     0,    68,    67,    61,    62,    59,    60,    56,    57,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    67,    61,    62,    59,    60,    56,    57,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    61,    62,
    59,    60,    56,    57,     0,     0,     0,     0,     0,    61,
    62,    59,    60,    56,    57,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    15,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    61,    62,    59,    60,
    56,    57,    71,    73,    74,    75,    76,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    61,    62,    59,
    60,    56,    57,     0,     0,     0,     0,     0,     0,     0,
    97,     0,   100,   101,     0,     0,     0,   105,   106,   107,
   108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
   118,   119,   120,   121,   122,   123,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   129,   132,   132,     0,     0,
     0,     0,   135,     0,     0,     0,     0,   136,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   147,     0,   148,   132,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   167,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   182 };
extabelem expact[]={

-10000000,-10000000,    37,  -278,-10000000,-10000000,     8,-10000000,    81,    80,
    78,    76,   107,   107,   107,   475,    72,   107,   107,   107,
   107,  -260,    74,    73,    71,    28,   -55,  -257,  -257,-10000000,
-10000000,-10000000,-10000000,   -32,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
    21,     2,-10000000,-10000000,   107,   107,   107,   107,     7,     6,
     5,   107,   107,   107,   107,   107,   107,   107,   107,   107,
   107,   107,   107,   107,   107,   107,   107,   107,   107,   107,
-10000000,   448,    68,-10000000,-10000000,-10000000,-10000000,    60,   -32,   107,
   107,   107,  -259,-10000000,-10000000,-10000000,   107,-10000000,  -261,-10000000,
-10000000,   107,-10000000,-10000000,    16,-10000000,  -277,   421,   -20,     3,
   410,   475,-10000000,-10000000,-10000000,   -34,    61,-10000000,-10000000,-10000000,
    59,    59,   -34,   -34,   -34,    26,    26,   599,   551,   578,
    61,   540,   513,   486,   107,-10000000,   107,   107,    15,   383,
    66,    45,   486,    56,-10000000,   486,   127,-10000000,-10000000,-10000000,
-10000000,   -32,    37,    37,   107,    37,    54,    99,-10000000,    53,
-10000000,-10000000,-10000000,   107,-10000000,-10000000,    37,-10000000,   -35,    15,
  -253,-10000000,    -1,-10000000,   -74,-10000000,-10000000,   486,    17,   -42,
-10000000,    37,   107,-10000000,   107,-10000000,-10000000,-10000000,-10000000,-10000000,
    50,   -94,   486,  -247,    37,-10000000,-10000000,  -235,-10000000,  -234,
    18,-10000000,-10000000,    43,-10000000,-10000000,    37,-10000000,    14,-10000000,
-10000000,    40,  -268,  -248,-10000000,   -75,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,   -33,-10000000 };
extabelem expgo[]={

     0,   185,    37,    38,   179,   175,    39,   875,    50,   110,
    33,   168,    46,    40,   167,   166,    24,   158,   155,    30,
    55,   154,   153,   151,   149,   148,   145,   135,   134,   133,
   131,    43,   130,   129,   126,   124,   123,   122 };
extabelem exr1[]={

     0,     1,    24,    24,    26,    25,     3,     3,     2,     2,
    27,     2,     2,     2,     2,     2,    28,     2,     2,     2,
     2,    29,    29,    15,    30,    30,    31,    31,    11,    11,
    32,    12,    21,    21,     5,     5,     6,     6,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,    33,
    34,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,    16,    16,    16,
    16,    16,    22,    22,    22,     9,     9,     9,    23,    23,
    13,    13,     8,     8,     4,     4,    17,    17,    17,    18,
    18,    35,    19,    20,    20,    10,    10,    14,    36,    37,
    14 };
extabelem exr2[]={

     0,     5,     0,     4,     1,     9,     1,     5,     7,     5,
     1,     9,    13,    11,    19,    11,     1,    17,     7,     7,
     7,     1,     4,     5,     2,     4,     7,     5,     2,     7,
     1,    11,     2,     2,     1,     5,     1,     2,     7,     9,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     1,
     1,    15,     5,     5,     5,     5,    11,     9,     9,     9,
     7,     5,     5,     5,     5,     5,     2,     3,     3,     3,
     3,     3,     2,     2,     2,     7,     5,     3,     1,     5,
     1,     7,     1,     3,     3,     7,     1,     3,     2,     3,
     7,     1,     7,     1,     9,     1,     5,     2,     1,     1,
    17 };
extabelem exchk[]={

-10000000,    -1,    -3,   -24,    -2,   123,    -6,   270,   279,   275,
   292,   291,   265,   269,   289,    -7,    40,    33,   126,    45,
    43,   -20,   274,   287,   -22,   263,    -9,   315,   316,   -16,
   286,   288,   290,   272,   282,   268,   262,   260,   261,   -25,
   280,    -3,    59,   -27,    40,    40,    40,    40,    -6,    -6,
    -6,    60,    45,    42,    47,    37,   312,   313,    62,   310,
   311,   308,   309,    38,   124,    94,    43,   307,   306,    44,
    63,    -7,   270,    -7,    -7,    -7,    -7,   276,   278,    40,
    40,    40,    46,   -10,   315,   316,    61,    -9,   -20,    -9,
   -13,    91,    58,   125,   -11,   -12,   -20,    -7,    -9,    -6,
    -7,    -7,    59,    59,    59,    -7,    -7,    -7,    -7,    -7,
    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
    -7,    -7,    -7,    -7,   -33,    41,    41,    40,   -13,    -7,
    -8,    -4,    -7,    -8,   278,    -7,    -7,   -26,    59,    44,
   282,   278,    41,    41,    59,    41,   -28,    -7,    -7,    -8,
    46,    41,    41,    44,    41,    93,    -3,   -12,   -32,   -13,
    -2,    -2,    -6,    -2,    41,    58,    41,    -7,   -23,    91,
    -5,   273,    59,   123,   -34,   -14,   -10,    40,    93,    -2,
    -6,   -29,    -7,   -36,    41,   125,   -15,   -30,   -31,   267,
   271,   -17,   270,   -18,   -19,    -2,    -3,   -31,   -16,   263,
    58,   -37,   -35,    44,    58,    41,   -21,   282,   272,   -19,
   270,   123,    -3,   125 };
extabelem exdef[]={

     6,    -2,    -2,     1,     7,     6,     0,    10,     0,     0,
     0,     0,    -2,    -2,    -2,    37,   103,   103,   103,   103,
   103,     0,     0,     0,     0,    80,   105,   103,   103,    76,
    82,    83,    84,    90,    87,    77,    78,    79,    81,     3,
     0,    -2,     9,   103,   103,    -2,   103,   103,     0,     0,
     0,   103,   103,   103,   103,   103,   103,   103,   103,   103,
   103,   103,   103,   103,   103,   103,   103,   103,   103,   103,
    59,     0,     0,    62,    63,    64,    65,     0,    90,   103,
    -2,    -2,     0,    71,    73,    75,   103,    72,     0,    74,
    86,   103,     4,     8,     0,    28,     0,     0,   105,     0,
     0,    16,    18,    19,    20,    -2,    41,    42,    43,    44,
    45,    46,    -2,    -2,    -2,    -2,    -2,    52,    53,    54,
    55,    56,    57,    58,   103,    38,   103,    -2,    85,     0,
     0,    93,    94,     0,    70,   106,     0,     6,    11,   103,
    30,    90,    -2,    -2,    -2,    -2,     0,     0,    39,     0,
   104,    67,    68,   103,    69,    91,    -2,    29,    88,     0,
    34,    13,     0,    15,     0,    60,    66,    95,   105,     0,
    12,    -2,    -2,    21,   103,    31,   107,   108,    89,    35,
     0,     0,    61,    96,    -2,    17,    22,     6,    24,     0,
     0,   109,    -2,    98,    99,    14,    -2,    25,     0,    80,
    27,     0,     0,     0,    26,     0,   102,    32,    33,   100,
   101,     6,    -2,   110 };
typedef struct
#ifdef __cplusplus
	extoktype
#endif
{ char *t_name; int t_val; } extoktype;
#ifndef EXDEBUG
#	define EXDEBUG	0	/* don't allow debugging */
#endif

#if EXDEBUG

extoktype extoks[] =
{
	"MINTOKEN",	257,
	"CHAR",	258,
	"INT",	259,
	"INTEGER",	260,
	"UNSIGNED",	261,
	"FLOATING",	262,
	"STRING",	263,
	"VOID",	264,
	"BREAK",	265,
	"CALL",	266,
	"CASE",	267,
	"CONSTANT",	268,
	"CONTINUE",	269,
	"DECLARE",	270,
	"DEFAULT",	271,
	"DYNAMIC",	272,
	"ELSE",	273,
	"EXIT",	274,
	"FOR",	275,
	"FUNCTION",	276,
	"ITERATE",	277,
	"ID",	278,
	"IF",	279,
	"LABEL",	280,
	"MEMBER",	281,
	"NAME",	282,
	"POS",	283,
	"PRAGMA",	284,
	"PRE",	285,
	"PRINTF",	286,
	"PROCEDURE",	287,
	"QUERY",	288,
	"RETURN",	289,
	"SPRINTF",	290,
	"SWITCH",	291,
	"WHILE",	292,
	"F2I",	293,
	"F2S",	294,
	"I2F",	295,
	"I2S",	296,
	"S2B",	297,
	"S2F",	298,
	"S2I",	299,
	"F2X",	300,
	"I2X",	301,
	"S2X",	302,
	"X2F",	303,
	"X2I",	304,
	"X2S",	305,
	",",	44,
	"=",	61,
	"?",	63,
	":",	58,
	"OR",	306,
	"AND",	307,
	"|",	124,
	"^",	94,
	"&",	38,
	"EQ",	308,
	"NE",	309,
	"<",	60,
	">",	62,
	"LE",	310,
	"GE",	311,
	"LS",	312,
	"RS",	313,
	"+",	43,
	"-",	45,
	"*",	42,
	"/",	47,
	"%",	37,
	"!",	33,
	"~",	126,
	"UNARY",	314,
	"INC",	315,
	"DEC",	316,
	"CAST",	317,
	"(",	40,
	"MAXTOKEN",	318,
	"-unknown-",	-1	/* ends search */
};

char * exreds[] =
{
	"-no such reduction-",
	"program : statement_list action_list",
	"action_list : /* empty */",
	"action_list : action_list action",
	"action : LABEL ':'",
	"action : LABEL ':' statement_list",
	"statement_list : /* empty */",
	"statement_list : statement_list statement",
	"statement : '{' statement_list '}'",
	"statement : expr_opt ';'",
	"statement : DECLARE",
	"statement : DECLARE dcl_list ';'",
	"statement : IF '(' expr ')' statement else_opt",
	"statement : FOR '(' variable ')' statement",
	"statement : FOR '(' expr_opt ';' expr_opt ';' expr_opt ')' statement",
	"statement : WHILE '(' expr ')' statement",
	"statement : SWITCH '(' expr",
	"statement : SWITCH '(' expr ')' '{' switch_list '}'",
	"statement : BREAK expr_opt ';'",
	"statement : CONTINUE expr_opt ';'",
	"statement : RETURN expr_opt ';'",
	"switch_list : /* empty */",
	"switch_list : switch_list switch_item",
	"switch_item : case_list statement_list",
	"case_list : case_item",
	"case_list : case_list case_item",
	"case_item : CASE constant ':'",
	"case_item : DEFAULT ':'",
	"dcl_list : dcl_item",
	"dcl_list : dcl_list ',' dcl_item",
	"dcl_item : reference NAME",
	"dcl_item : reference NAME array initialize",
	"name : NAME",
	"name : DYNAMIC",
	"else_opt : /* empty */",
	"else_opt : ELSE statement",
	"expr_opt : /* empty */",
	"expr_opt : expr",
	"expr : '(' expr ')'",
	"expr : '(' DECLARE ')' expr",
	"expr : expr '<' expr",
	"expr : expr '-' expr",
	"expr : expr '*' expr",
	"expr : expr '/' expr",
	"expr : expr '%' expr",
	"expr : expr LS expr",
	"expr : expr RS expr",
	"expr : expr '>' expr",
	"expr : expr LE expr",
	"expr : expr GE expr",
	"expr : expr EQ expr",
	"expr : expr NE expr",
	"expr : expr '&' expr",
	"expr : expr '|' expr",
	"expr : expr '^' expr",
	"expr : expr '+' expr",
	"expr : expr AND expr",
	"expr : expr OR expr",
	"expr : expr ',' expr",
	"expr : expr '?'",
	"expr : expr '?' expr ':'",
	"expr : expr '?' expr ':' expr",
	"expr : '!' expr",
	"expr : '~' expr",
	"expr : '-' expr",
	"expr : '+' expr",
	"expr : reference FUNCTION '(' args ')'",
	"expr : EXIT '(' expr ')'",
	"expr : PROCEDURE '(' args ')'",
	"expr : print '(' args ')'",
	"expr : STRING '.' ID",
	"expr : variable assign",
	"expr : INC variable",
	"expr : variable INC",
	"expr : DEC variable",
	"expr : variable DEC",
	"expr : constant",
	"constant : CONSTANT",
	"constant : FLOATING",
	"constant : INTEGER",
	"constant : STRING",
	"constant : UNSIGNED",
	"print : PRINTF",
	"print : QUERY",
	"print : SPRINTF",
	"variable : reference ID index",
	"variable : DYNAMIC index",
	"variable : NAME",
	"array : /* empty */",
	"array : '[' ']'",
	"index : /* empty */",
	"index : '[' expr ']'",
	"args : /* empty */",
	"args : arg_list",
	"arg_list : expr",
	"arg_list : arg_list ',' expr",
	"formals : /* empty */",
	"formals : DECLARE",
	"formals : formal_list",
	"formal_list : formal_item",
	"formal_list : formal_list ',' formal_item",
	"formal_item : DECLARE",
	"formal_item : DECLARE name",
	"reference : /* empty */",
	"reference : reference ID index '.'",
	"assign : /* empty */",
	"assign : '=' expr",
	"initialize : assign",
	"initialize : '('",
	"initialize : '(' formals",
	"initialize : '(' formals ')' '{' statement_list '}'",
};
#endif /* EXDEBUG */
/* 
 *	Copyright 1987 Silicon Graphics, Inc. - All Rights Reserved
 */

/* #ident	"@(#)yacc:yaccpar	1.10" */
/* #ident	"$Revision: 1.11 $" */

/*
** Skeleton parser driver for yacc output
*/
#include "stddef.h"

/*
** yacc user known macros and defines
*/
#define EXERROR		goto exerrlab
#define EXACCEPT	return(0)
#define EXABORT		return(1)
#ifdef __cplusplus
#define EXBACKUP( newtoken, newvalue )\
{\
	if ( exchar >= 0 || ( exr2[ extmp ] >> 1 ) != 1 )\
	{\
		exerror( gettxt("uxlibc:78", "syntax error - cannot backup") );\
		goto exerrlab;\
	}\
	exchar = newtoken;\
	exstate = *exps;\
	exlval = newvalue;\
	goto exnewstate;\
}
#else
#define EXBACKUP( newtoken, newvalue )\
{\
	if ( exchar >= 0 || ( exr2[ extmp ] >> 1 ) != 1 )\
	{\
		exerror( gettxt("uxlibc:78", "Syntax error - cannot backup") );\
		goto exerrlab;\
	}\
	exchar = newtoken;\
	exstate = *exps;\
	exlval = newvalue;\
	goto exnewstate;\
}
#endif
#define EXRECOVERING()	(!!exerrflag)
#define EXNEW(type)	malloc((size_t)(sizeof(type) * exnewmax))
#define EXCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, (size_t)(exnewmax * sizeof(type)))
#define EXENLARGE( from, type) \
	(type *) realloc((char *) from, (size_t)(exnewmax * sizeof(type)))
#ifndef EXDEBUG
#	define EXDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int exdebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define EXFLAG		(-10000000)

/*
** global variables used by the parser
*/
EXSTYPE *expv;			/* top of value stack */
int *exps;			/* top of state stack */

int exstate;			/* current state */
int extmp;			/* extra var (lasts between blocks) */

int exnerrs;			/* number of errors */
int exerrflag;			/* error recovery flag */
int exchar;			/* current input token number */



/*
** exparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int exparse(void)
#else
int exparse()
#endif
{
	register EXSTYPE *expvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - exparse may be called more than once
	*/
	expv = &exv[-1];
	exps = &exs[-1];
	exstate = 0;
	extmp = 0;
	exnerrs = 0;
	exerrflag = 0;
	exchar = -1;

#if EXMAXDEPTH <= 0
	if (exmaxdepth <= 0)
	{
		if ((exmaxdepth = EXEXPAND(0)) <= 0)
		{
#ifdef __cplusplus
			exerror(gettxt("uxlibc:79", "yacc initialization error"));
#else
			exerror(gettxt("uxlibc:79", "Yacc initialization error"));
#endif
			EXABORT;
		}
	}
#endif

	goto exstack;
	{
		register EXSTYPE *ex_pv;	/* top of value stack */
		register int *ex_ps;		/* top of state stack */
		register int ex_state;		/* current state */
		register int  ex_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if EXBACKUP was called.
		*/
	exnewstate:
		ex_pv = expv;
		ex_ps = exps;
		ex_state = exstate;
		goto ex_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	exstack:
		ex_pv = expv;
		ex_ps = exps;
		ex_state = exstate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	ex_stack:
		/*
		** put a state and value onto the stacks
		*/
#if EXDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( exdebug )
		{
			register int ex_i;

			printf( "State %d, token ", ex_state );
			if ( exchar == 0 )
				printf( "end-of-file\n" );
			else if ( exchar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( ex_i = 0; extoks[ex_i].t_val >= 0;
					ex_i++ )
				{
					if ( extoks[ex_i].t_val == exchar )
						break;
				}
				printf( "%s\n", extoks[ex_i].t_name );
			}
		}
#endif /* EXDEBUG */
		if ( ++ex_ps >= &exs[ exmaxdepth ] )	/* room on stack? */
		{
			int exnewmax;
			ptrdiff_t exs_off;

			/* The following pointer-differences are safe, since
			 * expvt, ex_pv, and expv all are a multiple of
			 * sizeof(EXSTYPE) bytes from exv.
			 */
			ptrdiff_t expvt_off = expvt - exv;
			ptrdiff_t ex_pv_off = ex_pv - exv;
			ptrdiff_t expv_off = expv - exv;

			int *exs_base = exs;
#ifdef EXEXPAND
			exnewmax = EXEXPAND(exmaxdepth);
#else
			exnewmax = 2 * exmaxdepth;	/* double table size */
			if (exmaxdepth == EXMAXDEPTH)	/* first time growth */
			{
				void *newexs = EXNEW(int);
				void *newexv = EXNEW(EXSTYPE);
				if (newexs != 0 && newexv != 0)
				{
					exs = EXCOPY(newexs, exs, int);
					exv = EXCOPY(newexv, exv, EXSTYPE);
				}
				else
					exnewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				exs = EXENLARGE(exs, int);
				exv = EXENLARGE(exv, EXSTYPE);
				if (exs == 0 || exv == 0)
					exnewmax = 0;	/* failed */
			}
#endif
			if (exnewmax <= exmaxdepth)	/* tables not expanded */
			{
#ifdef __cplusplus
				exerror( gettxt("uxlibc:80", "yacc stack overflow") );
#else
				exerror( gettxt("uxlibc:80", "Yacc stack overflow") );
#endif
				EXABORT;
			}
			exmaxdepth = exnewmax;

			/* reset pointers into exs */
			exs_off = exs - exs_base;
			ex_ps = ex_ps + exs_off;
			exps = exps + exs_off;

			/* reset pointers into exv */
			expvt = exv + expvt_off;
			ex_pv = exv + ex_pv_off;
			expv = exv + expv_off;
		}
		*ex_ps = ex_state;
		*++ex_pv = exval;

		/*
		** we have a new state - find out what to do
		*/
	ex_newstate:
		if ( ( ex_n = expact[ ex_state ] ) <= EXFLAG )
			goto exdefault;		/* simple state */
#if EXDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		extmp = exchar < 0;
#endif
		if ( ( exchar < 0 ) && ( ( exchar = exlex() ) < 0 ) )
			exchar = 0;		/* reached EOF */
#if EXDEBUG
		if ( exdebug && extmp )
		{
			register int ex_i;

			printf( "Received token " );
			if ( exchar == 0 )
				printf( "end-of-file\n" );
			else if ( exchar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( ex_i = 0; extoks[ex_i].t_val >= 0;
					ex_i++ )
				{
					if ( extoks[ex_i].t_val == exchar )
						break;
				}
				printf( "%s\n", extoks[ex_i].t_name );
			}
		}
#endif /* EXDEBUG */
		if ( ( ( ex_n += exchar ) < 0 ) || ( ex_n >= EXLAST ) )
			goto exdefault;
		if ( exchk[ ex_n = exact[ ex_n ] ] == exchar )	/*valid shift*/
		{
			exchar = -1;
			exval = exlval;
			ex_state = ex_n;
			if ( exerrflag > 0 )
				exerrflag--;
			goto ex_stack;
		}

	exdefault:
		if ( ( ex_n = exdef[ ex_state ] ) == -2 )
		{
#if EXDEBUG
			extmp = exchar < 0;
#endif
			if ( ( exchar < 0 ) && ( ( exchar = exlex() ) < 0 ) )
				exchar = 0;		/* reached EOF */
#if EXDEBUG
			if ( exdebug && extmp )
			{
				register int ex_i;

				printf( "Received token " );
				if ( exchar == 0 )
					printf( "end-of-file\n" );
				else if ( exchar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( ex_i = 0;
						extoks[ex_i].t_val >= 0;
						ex_i++ )
					{
						if ( extoks[ex_i].t_val
							== exchar )
						{
							break;
						}
					}
					printf( "%s\n", extoks[ex_i].t_name );
				}
			}
#endif /* EXDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *exxi = exexca;

				while ( ( *exxi != -1 ) ||
					( exxi[1] != ex_state ) )
				{
					exxi += 2;
				}
				while ( ( *(exxi += 2) >= 0 ) &&
					( *exxi != exchar ) )
					;
				if ( ( ex_n = exxi[1] ) < 0 )
					EXACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( ex_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( exerrflag )
			{
			case 0:		/* new error */
#ifdef __cplusplus
				exerror( gettxt("uxlibc:81", "syntax error") );
#else
				exerror( gettxt("uxlibc:81", "Syntax error") );
#endif
				goto skip_init;
			exerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				ex_pv = expv;
				ex_ps = exps;
				ex_state = exstate;
				exnerrs++;
				/* FALLTHRU */
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				exerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( ex_ps >= exs )
				{
					ex_n = expact[ *ex_ps ] + EXERRCODE;
					if ( ex_n >= 0 && ex_n < EXLAST &&
						exchk[exact[ex_n]] == EXERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						ex_state = exact[ ex_n ];
						goto ex_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if EXDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( exdebug )
						printf( _POP_, *ex_ps,
							ex_ps[-1] );
#	undef _POP_
#endif
					ex_ps--;
					ex_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				EXABORT;
			case 3:		/* no shift yet; eat a token */
#if EXDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( exdebug )
				{
					register int ex_i;

					printf( "Error recovery discards " );
					if ( exchar == 0 )
						printf( "token end-of-file\n" );
					else if ( exchar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( ex_i = 0;
							extoks[ex_i].t_val >= 0;
							ex_i++ )
						{
							if ( extoks[ex_i].t_val
								== exchar )
							{
								break;
							}
						}
						printf( "token %s\n",
							extoks[ex_i].t_name );
					}
				}
#endif /* EXDEBUG */
				if ( exchar == 0 )	/* reached EOF. quit */
					EXABORT;
				exchar = -1;
				goto ex_newstate;
			}
		}/* end if ( ex_n == 0 ) */
		/*
		** reduction by production ex_n
		** put stack tops, etc. so things right after switch
		*/
#if EXDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( exdebug )
			printf( "Reduce by (%d) \"%s\"\n",
				ex_n, exreds[ ex_n ] );
#endif
		extmp = ex_n;			/* value to switch over */
		expvt = ex_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using ex_state here as temporary
		** register variable, but why not, if it works...
		** If exr2[ ex_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto ex_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int ex_len = exr2[ ex_n ];

			if ( !( ex_len & 01 ) )
			{
				ex_len >>= 1;
				exval = ( ex_pv -= ex_len )[1];	/* $$ = $1 */
				ex_state = expgo[ ex_n = exr1[ ex_n ] ] +
					*( ex_ps -= ex_len ) + 1;
				if ( ex_state >= EXLAST ||
					exchk[ ex_state =
					exact[ ex_state ] ] != -ex_n )
				{
					ex_state = exact[ expgo[ ex_n ] ];
				}
				goto ex_stack;
			}
			ex_len >>= 1;
			exval = ( ex_pv -= ex_len )[1];	/* $$ = $1 */
			ex_state = expgo[ ex_n = exr1[ ex_n ] ] +
				*( ex_ps -= ex_len ) + 1;
			if ( ex_state >= EXLAST ||
				exchk[ ex_state = exact[ ex_state ] ] != -ex_n )
			{
				ex_state = exact[ expgo[ ex_n ] ];
			}
		}
					/* save until reenter driver code */
		exstate = ex_state;
		exps = ex_ps;
		expv = ex_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( extmp )
	{
		
case 1:
/* # line 135 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (expvt[-1].expr && !(expr.program->disc->flags & EX_STRICT))
			{
				if (expr.program->main.value && !(expr.program->disc->flags & EX_RETAIN))
					exfreenode(expr.program, expr.program->main.value);
				if (expvt[-1].expr->op == S2B)
				{
					Exnode_t*	x;

					x = expvt[-1].expr;
					expvt[-1].expr = x->data.operand.left;
					x->data.operand.left = 0;
					exfreenode(expr.program, x);
				}
				expr.program->main.lex = PROCEDURE;
				expr.program->main.value = exnewnode(expr.program, PROCEDURE, 1, expvt[-1].expr->type, NiL, expvt[-1].expr);
			}
		} break;
case 4:
/* # line 159 "/home/gsf/src/lib/libexpr/exparse.y" */
{
				register Dtdisc_t*	disc;

				if (expr.procedure)
					exerror("no nested function definitions");
				expvt[-1].id->lex = PROCEDURE;
				expr.procedure = expvt[-1].id->value = exnewnode(expr.program, PROCEDURE, 1, expvt[-1].id->type, NiL, NiL);
				expr.procedure->type = INTEGER;
				if (!(disc = newof(0, Dtdisc_t, 1, 0)))
					exerror("out of space [frame discipline]");
				disc->key = offsetof(Exid_t, name);
				if (!(expr.procedure->data.procedure.frame = dtopen(disc, Dtset)) || !dtview(expr.procedure->data.procedure.frame, expr.program->symbols))
					exerror("out of space [frame table]");
				expr.program->symbols = expr.program->frame = expr.procedure->data.procedure.frame;
			} break;
case 5:
/* # line 174 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			expr.procedure = 0;
			if (expr.program->frame)
			{
				expr.program->symbols = expr.program->frame->view;
				dtview(expr.program->frame, NiL);
			}
			if (expvt[-0].expr && expvt[-0].expr->op == S2B)
			{
				Exnode_t*	x;

				x = expvt[-0].expr;
				expvt[-0].expr = x->data.operand.left;
				x->data.operand.left = 0;
				exfreenode(expr.program, x);
			}
			expvt[-3].id->value->data.operand.right = excast(expr.program, expvt[-0].expr, expvt[-3].id->type, NiL, 0);
		} break;
case 6:
/* # line 195 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = 0;
		} break;
case 7:
/* # line 199 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (!expvt[-1].expr)
				exval.expr = expvt[-0].expr;
			else if (!expvt[-0].expr)
				exval.expr = expvt[-1].expr;
			else if (expvt[-1].expr->op == CONSTANT)
			{
				exfreenode(expr.program, expvt[-1].expr);
				exval.expr = expvt[-0].expr;
			}
			else exval.expr = exnewnode(expr.program, ';', 1, expvt[-0].expr->type, expvt[-1].expr, expvt[-0].expr);
		} break;
case 8:
/* # line 214 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = expvt[-1].expr;
		} break;
case 9:
/* # line 218 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = (expvt[-1].expr && expvt[-1].expr->type == STRING) ? exnewnode(expr.program, S2B, 1, INTEGER, expvt[-1].expr, NiL) : expvt[-1].expr;
		} break;
case 10:
/* # line 221 "/home/gsf/src/lib/libexpr/exparse.y" */
{expr.declare=expvt[-0].id->type;} break;
case 11:
/* # line 222 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = expvt[-1].expr;
		} break;
case 12:
/* # line 226 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (expvt[-3].expr->type == STRING)
				expvt[-3].expr = exnewnode(expr.program, S2B, 1, INTEGER, expvt[-3].expr, NiL);
			else if (!INTEGRAL(expvt[-3].expr->type))
				expvt[-3].expr = excast(expr.program, expvt[-3].expr, INTEGER, NiL, 0);
			exval.expr = exnewnode(expr.program, expvt[-5].id->index, 1, INTEGER, expvt[-3].expr, exnewnode(expr.program, ':', 1, expvt[-1].expr ? expvt[-1].expr->type : 0, expvt[-1].expr, expvt[-0].expr));
		} break;
case 13:
/* # line 234 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, ITERATE, 0, INTEGER, NiL, NiL);
			exval.expr->data.generate.array = expvt[-2].expr;
			if (!expvt[-2].expr->data.variable.index || expvt[-2].expr->data.variable.index->op != DYNAMIC)
				exerror("simple index variable expected");
			exval.expr->data.generate.index = expvt[-2].expr->data.variable.index->data.variable.symbol;
			if (expvt[-2].expr->op == ID && exval.expr->data.generate.index->type != INTEGER)
				exerror("integer index variable expected");
			exfreenode(expr.program, expvt[-2].expr->data.variable.index);
			expvt[-2].expr->data.variable.index = 0;
			exval.expr->data.generate.statement = expvt[-0].expr;
		} break;
case 14:
/* # line 247 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (!expvt[-4].expr)
			{
				expvt[-4].expr = exnewnode(expr.program, CONSTANT, 0, INTEGER, NiL, NiL);
				expvt[-4].expr->data.constant.value.integer = 1;
			}
			else if (expvt[-4].expr->type == STRING)
				expvt[-4].expr = exnewnode(expr.program, S2B, 1, INTEGER, expvt[-4].expr, NiL);
			else if (!INTEGRAL(expvt[-4].expr->type))
				expvt[-4].expr = excast(expr.program, expvt[-4].expr, INTEGER, NiL, 0);
			exval.expr = exnewnode(expr.program, expvt[-8].id->index, 1, INTEGER, expvt[-4].expr, exnewnode(expr.program, ';', 1, 0, expvt[-2].expr, expvt[-0].expr));
			if (expvt[-6].expr)
				exval.expr = exnewnode(expr.program, ';', 1, INTEGER, expvt[-6].expr, exval.expr);
		} break;
case 15:
/* # line 262 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (expvt[-2].expr->type == STRING)
				expvt[-2].expr = exnewnode(expr.program, S2B, 1, INTEGER, expvt[-2].expr, NiL);
			else if (!INTEGRAL(expvt[-2].expr->type))
				expvt[-2].expr = excast(expr.program, expvt[-2].expr, INTEGER, NiL, 0);
			exval.expr = exnewnode(expr.program, expvt[-4].id->index, 1, INTEGER, expvt[-2].expr, exnewnode(expr.program, ';', 1, 0, NiL, expvt[-0].expr));
		} break;
case 16:
/* # line 269 "/home/gsf/src/lib/libexpr/exparse.y" */
{expr.declare=expvt[-0].expr->type;} break;
case 17:
/* # line 270 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			register Switch_t*	sw = expr.swstate;

			exval.expr = exnewnode(expr.program, expvt[-7].id->index, 1, INTEGER, expvt[-5].expr, exnewnode(expr.program, DEFAULT, 1, 0, sw->defcase, sw->firstcase));
			expr.swstate = expr.swstate->prev;
			if (sw->base)
				free(sw->base);
			if (sw != &swstate)
				free(sw);
		} break;
case 18:
/* # line 281 "/home/gsf/src/lib/libexpr/exparse.y" */
{
		loopop:
			if (!expvt[-1].expr)
			{
				expvt[-1].expr = exnewnode(expr.program, CONSTANT, 0, INTEGER, NiL, NiL);
				expvt[-1].expr->data.constant.value.integer = 1;
			}
			else if (!INTEGRAL(expvt[-1].expr->type))
				expvt[-1].expr = excast(expr.program, expvt[-1].expr, INTEGER, NiL, 0);
			exval.expr = exnewnode(expr.program, expvt[-2].id->index, 1, INTEGER, expvt[-1].expr, NiL);
		} break;
case 19:
/* # line 293 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto loopop;
		} break;
case 20:
/* # line 297 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (expvt[-1].expr)
			{
				if (expr.procedure && !expr.procedure->type)
					exerror("return in void function");
				expvt[-1].expr = excast(expr.program, expvt[-1].expr, expr.procedure ? expr.procedure->type : INTEGER, NiL, 0);
			}
			exval.expr = exnewnode(expr.program, RETURN, 1, expvt[-1].expr ? expvt[-1].expr->type : 0, expvt[-1].expr, NiL);
		} break;
case 21:
/* # line 309 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			register Switch_t*		sw;
			int				n;

			if (expr.swstate)
			{
				if (!(sw = newof(0, Switch_t, 1, 0)))
				{
					exerror("out of space [switch]");
					sw = &swstate;
				}
				sw->prev = expr.swstate;
			}
			else sw = &swstate;
			expr.swstate = sw;
			sw->type = expr.declare;
			sw->firstcase = 0;
			sw->lastcase = 0;
			sw->defcase = 0;
			sw->def = 0;
			n = 8;
			if (!(sw->base = newof(0, Extype_t*, n, 0)))
			{
				exerror("out of space [case]");
				n = 0;
			}
			sw->cur = sw->base;
			sw->last = sw->base + n;
		} break;
case 23:
/* # line 342 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			register Switch_t*	sw = expr.swstate;
			int			n;

			exval.expr = exnewnode(expr.program, CASE, 1, 0, expvt[-0].expr, NiL);
			if (sw->cur > sw->base)
			{
				if (sw->lastcase)
					sw->lastcase->data.select.next = exval.expr;
				else sw->firstcase = exval.expr;
				sw->lastcase = exval.expr;
				n = sw->cur - sw->base;
				sw->cur = sw->base;
				exval.expr->data.select.constant = (Extype_t**)exalloc(expr.program, (n + 1) * sizeof(Extype_t*));
				memcpy(exval.expr->data.select.constant, sw->base, n * sizeof(Extype_t*));
				exval.expr->data.select.constant[n] = 0;
			}
			else exval.expr->data.select.constant = 0;
			if (sw->def)
			{
				sw->def = 0;
				if (sw->defcase)
					exerror("duplicate default in switch");
				else sw->defcase = expvt[-0].expr;
			}
		} break;
case 26:
/* # line 375 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			int	n;

			if (expr.swstate->cur >= expr.swstate->last)
			{
				n = expr.swstate->cur - expr.swstate->base;
				if (!(expr.swstate->base = newof(expr.swstate->base, Extype_t*, 2 * n, 0)))
				{
					exerror("too many case labels for switch");
					n = 0;
				}
				expr.swstate->cur = expr.swstate->base + n;
				expr.swstate->last = expr.swstate->base + 2 * n;
			}
			if (expr.swstate->cur)
			{
				expvt[-1].expr = excast(expr.program, expvt[-1].expr, expr.swstate->type, NiL, 0);
				*expr.swstate->cur++ = &(expvt[-1].expr->data.constant.value);
			}
		} break;
case 27:
/* # line 396 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			expr.swstate->def = 1;
		} break;
case 29:
/* # line 403 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (expvt[-0].expr)
				exval.expr = expvt[-2].expr ? exnewnode(expr.program, ',', 1, expvt[-0].expr->type, expvt[-2].expr, expvt[-0].expr) : expvt[-0].expr;
		} break;
case 30:
/* # line 409 "/home/gsf/src/lib/libexpr/exparse.y" */
{expr.id=expvt[-0].id;} break;
case 31:
/* # line 410 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = 0;
			expvt[-3].id->type = expr.declare;
			if (expvt[-4].reference)
			{
				expvt[-3].id->index = MEMBER;
				if (!expr.program->disc->getf || !expr.program->symbols)
					exerror("%s: member references not supported", expvt[-4].reference);
				else if (expvt[-0].expr)
					exerror("%s: member references cannot be initialized", expvt[-3].id);
				else if (expr.program->disc->reff)
					(*expr.program->disc->reff)(expr.program, exval.expr, expvt[-3].id, expvt[-4].reference, NiL, EX_SCALAR, expr.program->disc);
			}
			else if (expvt[-0].expr && expvt[-0].expr->op == PROCEDURE)
			{
				expvt[-3].id->lex = PROCEDURE;
				expvt[-3].id->value = expvt[-0].expr;
			}
			else
			{
				expvt[-3].id->lex = DYNAMIC;
				expvt[-3].id->value = exnewnode(expr.program, 0, 0, 0, NiL, NiL);
				if (expvt[-1].integer && !expvt[-3].id->local.pointer)
				{
					Dtdisc_t*	disc;

					if (!(disc = newof(0, Dtdisc_t, 1, 0)))
						exerror("out of space [associative array]");
					disc->key = offsetof(Exassoc_t, name);
					if (!(expvt[-3].id->local.pointer = (char*)dtopen(disc, Dtoset)))
						exerror("%s: cannot initialize associative array", expvt[-3].id->name);
				}
				if (expvt[-0].expr)
				{
					if (expvt[-0].expr->type != expvt[-3].id->type)
					{
						expvt[-0].expr->type = expvt[-3].id->type;
						expvt[-0].expr->data.operand.right = excast(expr.program, expvt[-0].expr->data.operand.right, expvt[-3].id->type, NiL, 0);
					}
					expvt[-0].expr->data.operand.left = exnewnode(expr.program, DYNAMIC, 0, expvt[-3].id->type, NiL, NiL);
					expvt[-0].expr->data.operand.left->data.variable.symbol = expvt[-3].id;
					exval.expr = expvt[-0].expr;
				}
				else if (!expvt[-1].integer)
					expvt[-3].id->value->data.value = exzero(expvt[-3].id->type);
			}
		} break;
case 34:
/* # line 464 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = 0;
		} break;
case 35:
/* # line 468 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = expvt[-0].expr;
		} break;
case 36:
/* # line 474 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = 0;
		} break;
case 38:
/* # line 481 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = expvt[-1].expr;
		} break;
case 39:
/* # line 485 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = (expvt[-0].expr->type == expvt[-2].id->type) ? expvt[-0].expr : excast(expr.program, expvt[-0].expr, expvt[-2].id->type, NiL, 0);
		} break;
case 40:
/* # line 489 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			int	rel;

		relational:
			rel = INTEGER;
			goto coerce;
		binary:
			rel = 0;
		coerce:
			if (!expvt[-2].expr->type)
			{
				if (!expvt[-0].expr->type)
					expvt[-2].expr->type = expvt[-0].expr->type = rel ? STRING : INTEGER;
				else expvt[-2].expr->type = expvt[-0].expr->type;
			}
			else if (!expvt[-0].expr->type) expvt[-0].expr->type = expvt[-2].expr->type;
			if (expvt[-2].expr->type != expvt[-0].expr->type)
			{
				if (expvt[-2].expr->type == STRING)
					expvt[-2].expr = excast(expr.program, expvt[-2].expr, expvt[-0].expr->type, expvt[-0].expr, 0);
				else if (expvt[-0].expr->type == STRING)
					expvt[-0].expr = excast(expr.program, expvt[-0].expr, expvt[-2].expr->type, expvt[-2].expr, 0);
				else if (expvt[-2].expr->type == FLOATING)
					expvt[-0].expr = excast(expr.program, expvt[-0].expr, FLOATING, expvt[-2].expr, 0);
				else if (expvt[-0].expr->type == FLOATING)
					expvt[-2].expr = excast(expr.program, expvt[-2].expr, FLOATING, expvt[-0].expr, 0);
			}
			if (!rel)
				rel = (expvt[-2].expr->type == STRING) ? STRING : ((expvt[-2].expr->type == UNSIGNED) ? UNSIGNED : expvt[-0].expr->type);
			exval.expr = exnewnode(expr.program, expvt[-1].op, 1, rel, expvt[-2].expr, expvt[-0].expr);
			if (!expr.program->errors && expvt[-2].expr->op == CONSTANT && expvt[-0].expr->op == CONSTANT)
			{
				exval.expr->data.constant.value = exeval(expr.program, exval.expr, NiL);
				exval.expr->binary = 0;
				exval.expr->op = CONSTANT;
				exfreenode(expr.program, expvt[-2].expr);
				exfreenode(expr.program, expvt[-0].expr);
			}
		} break;
case 41:
/* # line 529 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 42:
/* # line 533 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 43:
/* # line 537 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 44:
/* # line 541 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 45:
/* # line 545 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 46:
/* # line 549 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 47:
/* # line 553 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto relational;
		} break;
case 48:
/* # line 557 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto relational;
		} break;
case 49:
/* # line 561 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto relational;
		} break;
case 50:
/* # line 565 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto relational;
		} break;
case 51:
/* # line 569 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto relational;
		} break;
case 52:
/* # line 573 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 53:
/* # line 577 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 54:
/* # line 581 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 55:
/* # line 585 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto binary;
		} break;
case 56:
/* # line 589 "/home/gsf/src/lib/libexpr/exparse.y" */
{
		logical:
			if (expvt[-2].expr->type == STRING)
				expvt[-2].expr = exnewnode(expr.program, S2B, 1, INTEGER, expvt[-2].expr, NiL);
			if (expvt[-0].expr->type == STRING)
				expvt[-0].expr = exnewnode(expr.program, S2B, 1, INTEGER, expvt[-0].expr, NiL);
			goto binary;
		} break;
case 57:
/* # line 598 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto logical;
		} break;
case 58:
/* # line 602 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (expvt[-2].expr->op == CONSTANT)
			{
				exfreenode(expr.program, expvt[-2].expr);
				exval.expr = expvt[-0].expr;
			}
			else exval.expr = exnewnode(expr.program, ',', 1, expvt[-0].expr->type, expvt[-2].expr, expvt[-0].expr);
		} break;
case 59:
/* # line 610 "/home/gsf/src/lib/libexpr/exparse.y" */
{expr.nolabel=1;} break;
case 60:
/* # line 610 "/home/gsf/src/lib/libexpr/exparse.y" */
{expr.nolabel=0;} break;
case 61:
/* # line 611 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (!expvt[-3].expr->type)
			{
				if (!expvt[-0].expr->type)
					expvt[-3].expr->type = expvt[-0].expr->type = INTEGER;
				else expvt[-3].expr->type = expvt[-0].expr->type;
			}
			else if (!expvt[-0].expr->type)
				expvt[-0].expr->type = expvt[-3].expr->type;
			if (expvt[-6].expr->type == STRING)
				expvt[-6].expr = exnewnode(expr.program, S2B, 1, INTEGER, expvt[-6].expr, NiL);
			else if (!INTEGRAL(expvt[-6].expr->type))
				expvt[-6].expr = excast(expr.program, expvt[-6].expr, INTEGER, NiL, 0);
			if (expvt[-3].expr->type != expvt[-0].expr->type)
			{
				if (expvt[-3].expr->type == STRING || expvt[-0].expr->type == STRING)
					exerror("if statement string type mismatch");
				else if (expvt[-3].expr->type == FLOATING)
					expvt[-0].expr = excast(expr.program, expvt[-0].expr, FLOATING, NiL, 0);
				else if (expvt[-0].expr->type == FLOATING)
					expvt[-3].expr = excast(expr.program, expvt[-3].expr, FLOATING, NiL, 0);
			}
			if (expvt[-6].expr->op == CONSTANT)
			{
				if (expvt[-6].expr->data.constant.value.integer)
				{
					exval.expr = expvt[-3].expr;
					exfreenode(expr.program, expvt[-0].expr);
				}
				else
				{
					exval.expr = expvt[-0].expr;
					exfreenode(expr.program, expvt[-3].expr);
				}
				exfreenode(expr.program, expvt[-6].expr);
			}
			else exval.expr = exnewnode(expr.program, '?', 1, expvt[-3].expr->type, expvt[-6].expr, exnewnode(expr.program, ':', 1, expvt[-3].expr->type, expvt[-3].expr, expvt[-0].expr));
		} break;
case 62:
/* # line 650 "/home/gsf/src/lib/libexpr/exparse.y" */
{
		iunary:
			if (expvt[-0].expr->type == STRING)
				expvt[-0].expr = exnewnode(expr.program, S2B, 1, INTEGER, expvt[-0].expr, NiL);
			else if (!INTEGRAL(expvt[-0].expr->type))
				expvt[-0].expr = excast(expr.program, expvt[-0].expr, INTEGER, NiL, 0);
		unary:
			exval.expr = exnewnode(expr.program, expvt[-1].op, 1, expvt[-0].expr->type == UNSIGNED ? INTEGER : expvt[-0].expr->type, expvt[-0].expr, NiL);
			if (expvt[-0].expr->op == CONSTANT)
			{
				exval.expr->data.constant.value = exeval(expr.program, exval.expr, NiL);
				exval.expr->binary = 0;
				exval.expr->op = CONSTANT;
				exfreenode(expr.program, expvt[-0].expr);
			}
		} break;
case 63:
/* # line 667 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto iunary;
		} break;
case 64:
/* # line 671 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto unary;
		} break;
case 65:
/* # line 675 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = expvt[-0].expr;
		} break;
case 66:
/* # line 679 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, FUNCTION, 1, T(expvt[-3].id->type), call(expvt[-4].reference, expvt[-3].id, expvt[-1].expr), expvt[-1].expr);
			if (!expr.program->disc->getf)
				exerror("%s: function references not supported", exval.expr->data.operand.left->data.variable.symbol->name);
			else if (expr.program->disc->reff)
				(*expr.program->disc->reff)(expr.program, exval.expr, exval.expr->data.operand.left->data.variable.symbol, expvt[-4].reference, NiL, EX_CALL, expr.program->disc);
		} break;
case 67:
/* # line 687 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (!INTEGRAL(expvt[-1].expr->type))
				expvt[-1].expr = excast(expr.program, expvt[-1].expr, INTEGER, NiL, 0);
			exval.expr = exnewnode(expr.program, EXIT, 1, INTEGER, expvt[-1].expr, NiL);
		} break;
case 68:
/* # line 693 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, CALL, 1, expvt[-3].id->type, NiL, expvt[-1].expr);
			exval.expr->data.call.procedure = expvt[-3].id;
		} break;
case 69:
/* # line 698 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, expvt[-3].id->index, 0, expvt[-3].id->type, NiL, NiL);
			if (expvt[-1].expr && expvt[-1].expr->data.operand.left->type == INTEGER)
			{
				exval.expr->data.print.descriptor = expvt[-1].expr->data.operand.left;
				expvt[-1].expr = expvt[-1].expr->data.operand.right;
			}
			else switch (expvt[-3].id->index)
			{
			case QUERY:
				exval.expr->data.print.descriptor = exnewnode(expr.program, CONSTANT, 0, INTEGER, NiL, NiL);
				exval.expr->data.print.descriptor->data.constant.value.integer = 2;
				break;
			case PRINTF:
				exval.expr->data.print.descriptor = exnewnode(expr.program, CONSTANT, 0, INTEGER, NiL, NiL);
				exval.expr->data.print.descriptor->data.constant.value.integer = 1;
				break;
			case SPRINTF:
				exval.expr->data.print.descriptor = 0;
				break;
			}
			exval.expr->data.print.args = preprint(expvt[-1].expr);
		} break;
case 70:
/* # line 722 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, CONSTANT, 0, expvt[-0].id->type, NiL, NiL);
			if (!expr.program->disc->reff)
				exerror("%s: qualified identifier references not supported", expvt[-0].id->name);
			else
			{
				exval.expr->data.constant.value = (*expr.program->disc->reff)(expr.program, exval.expr, expvt[-0].id, NiL, expvt[-2].string, EX_SCALAR, expr.program->disc);
				exval.expr->data.constant.reference = expvt[-0].id;
			}
		} break;
case 71:
/* # line 733 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			if (expvt[-0].expr)
			{
				if (expvt[-1].expr->op == ID && !expr.program->disc->setf)
					exerror("%s: variable assignment not supported", expvt[-1].expr->data.variable.symbol->name);
				else
				{
					if (!expvt[-1].expr->type)
						expvt[-1].expr->type = expvt[-0].expr->type;
#if 0
					else if (expvt[-0].expr->type != expvt[-1].expr->type && expvt[-1].expr->type >= 0200)
#else
					else if (expvt[-0].expr->type != expvt[-1].expr->type)
#endif
					{
						expvt[-0].expr->type = expvt[-1].expr->type;
						expvt[-0].expr->data.operand.right = excast(expr.program, expvt[-0].expr->data.operand.right, expvt[-1].expr->type, NiL, 0);
					}
					expvt[-0].expr->data.operand.left = expvt[-1].expr;
					exval.expr = expvt[-0].expr;
				}
			}
		} break;
case 72:
/* # line 757 "/home/gsf/src/lib/libexpr/exparse.y" */
{
		pre:
			if (expvt[-0].expr->type == STRING)
				exerror("++ and -- invalid for string variables");
			exval.expr = exnewnode(expr.program, expvt[-1].op, 0, expvt[-0].expr->type, expvt[-0].expr, NiL);
			exval.expr->subop = PRE;
		} break;
case 73:
/* # line 765 "/home/gsf/src/lib/libexpr/exparse.y" */
{
		pos:
			if (expvt[-1].expr->type == STRING)
				exerror("++ and -- invalid for string variables");
			exval.expr = exnewnode(expr.program, expvt[-0].op, 0, expvt[-1].expr->type, expvt[-1].expr, NiL);
			exval.expr->subop = POS;
		} break;
case 74:
/* # line 773 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto pre;
		} break;
case 75:
/* # line 777 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			goto pos;
		} break;
case 77:
/* # line 784 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, CONSTANT, 0, expvt[-0].id->type, NiL, NiL);
			if (!expr.program->disc->reff)
				exerror("%s: identifier references not supported", expvt[-0].id->name);
			else exval.expr->data.constant.value = (*expr.program->disc->reff)(expr.program, exval.expr, expvt[-0].id, NiL, NiL, EX_SCALAR, expr.program->disc);
		} break;
case 78:
/* # line 791 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, CONSTANT, 0, FLOATING, NiL, NiL);
			exval.expr->data.constant.value.floating = expvt[-0].floating;
		} break;
case 79:
/* # line 796 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, CONSTANT, 0, INTEGER, NiL, NiL);
			exval.expr->data.constant.value.integer = expvt[-0].integer;
		} break;
case 80:
/* # line 801 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, CONSTANT, 0, STRING, NiL, NiL);
			exval.expr->data.constant.value.string = expvt[-0].string;
		} break;
case 81:
/* # line 806 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, CONSTANT, 0, UNSIGNED, NiL, NiL);
			exval.expr->data.constant.value.integer = expvt[-0].integer;
		} break;
case 85:
/* # line 818 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, ID, 0, expvt[-1].id->type, NiL, NiL);
			exval.expr->data.variable.symbol = QUALIFY(expvt[-2].reference, expvt[-1].id);
			exval.expr->data.variable.reference = expvt[-2].reference;
			if (expvt[-0].expr && !INTEGRAL(expvt[-0].expr->type))
				expvt[-0].expr = excast(expr.program, expvt[-0].expr, INTEGER, NiL, 0);
			exval.expr->data.variable.index = expvt[-0].expr;
			if (!expr.program->disc->getf)
				exerror("%s: identifier references not supported", expvt[-1].id->name);
			else if (expr.program->disc->reff)
				(*expr.program->disc->reff)(expr.program, exval.expr, exval.expr->data.variable.symbol, expvt[-2].reference, NiL, expvt[-0].expr ? 0 : EX_SCALAR, expr.program->disc);
			exval.expr->type = exval.expr->data.variable.symbol->type;
		} break;
case 86:
/* # line 832 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, DYNAMIC, 0, expvt[-1].id->type, NiL, NiL);
			exval.expr->data.variable.symbol = expvt[-1].id;
			exval.expr->data.variable.reference = 0;
			if (((exval.expr->data.variable.index = expvt[-0].expr) == 0) != (expvt[-1].id->local.pointer == 0))
				exerror("%s: is%s an array", expvt[-1].id->name, expvt[-1].id->local.pointer ? "" : " not");
		} break;
case 87:
/* # line 840 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, ID, 0, 0, NiL, NiL);
			exval.expr->data.variable.symbol = expvt[-0].id;
			exval.expr->data.variable.reference = 0;
			exval.expr->data.variable.index = 0;
			if (!(expr.program->disc->flags & EX_UNDECLARED))
				exerror("unknown identifier");
		} break;
case 88:
/* # line 851 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.integer = 0;
		} break;
case 89:
/* # line 855 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.integer = 1;
		} break;
case 90:
/* # line 861 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = 0;
		} break;
case 91:
/* # line 865 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = expvt[-1].expr;
		} break;
case 92:
/* # line 871 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = 0;
		} break;
case 93:
/* # line 875 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = expvt[-0].expr->data.operand.left;
			expvt[-0].expr->data.operand.left = expvt[-0].expr->data.operand.right = 0;
			exfreenode(expr.program, expvt[-0].expr);
		} break;
case 94:
/* # line 883 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, ';', 1, 0, exnewnode(expr.program, ';', 1, expvt[-0].expr->type, expvt[-0].expr, NiL), NiL);
			exval.expr->data.operand.right = exval.expr->data.operand.left;
		} break;
case 95:
/* # line 888 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			expvt[-2].expr->data.operand.right = expvt[-2].expr->data.operand.right->data.operand.right = exnewnode(expr.program, ',', 1, expvt[-2].expr->type, expvt[-0].expr, NiL);
		} break;
case 96:
/* # line 894 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = 0;
		} break;
case 97:
/* # line 898 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = 0;
			if (expvt[-0].id->type)
				exerror("(void) expected");
		} break;
case 99:
/* # line 907 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, ',', 1, expvt[-0].expr->type, expvt[-0].expr, NiL);
		} break;
case 100:
/* # line 911 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			register Exnode_t*	x;
			register Exnode_t*	y;

			exval.expr = expvt[-2].expr;
			for (x = expvt[-2].expr; y = x->data.operand.right; x = y);
			x->data.operand.right = exnewnode(expr.program, ',', 1, expvt[-0].expr->type, expvt[-0].expr, NiL);
		} break;
case 101:
/* # line 921 "/home/gsf/src/lib/libexpr/exparse.y" */
{expr.declare=expvt[-0].id->type;} break;
case 102:
/* # line 922 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, ID, 0, expvt[-0].id->type, NiL, NiL);
			exval.expr->data.variable.symbol = expvt[-0].id;
			expvt[-0].id->lex = DYNAMIC;
			expvt[-0].id->value = exnewnode(expr.program, 0, 0, 0, NiL, NiL);
			expr.procedure->data.procedure.arity++;
		} break;
case 103:
/* # line 932 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.reference = expr.refs = expr.lastref = 0;
		} break;
case 104:
/* # line 936 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			Exref_t*	r;

			r = ALLOCATE(expr.program, Exref_t);
			if (expr.lastref)
			{
				r->symbol = QUALIFY(expr.lastref, expvt[-2].id);
				expr.lastref->next = r;
			}
			else
			{
				r->symbol = expvt[-2].id;
				expr.refs = r;
			}
			expr.lastref = r;
			r->next = 0;
			r->index = expvt[-1].expr;
			exval.reference = expr.refs;
		} break;
case 105:
/* # line 958 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = 0;
		} break;
case 106:
/* # line 962 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = exnewnode(expr.program, '=', 1, expvt[-0].expr->type, NiL, expvt[-0].expr);
			exval.expr->subop = expvt[-1].op;
		} break;
case 108:
/* # line 969 "/home/gsf/src/lib/libexpr/exparse.y" */
{
				register Dtdisc_t*	disc;

				if (expr.procedure)
					exerror("no nested function definitions");
				expr.procedure = exnewnode(expr.program, PROCEDURE, 1, expr.declare, NiL, NiL);
				if (!(disc = newof(0, Dtdisc_t, 1, 0)))
					exerror("out of space [frame discipline]");
				disc->key = offsetof(Exid_t, name);
				if (!(expr.procedure->data.procedure.frame = dtopen(disc, Dtset)) || !dtview(expr.procedure->data.procedure.frame, expr.program->symbols))
					exerror("out of space [frame table]");
				expr.program->symbols = expr.program->frame = expr.procedure->data.procedure.frame;
				expr.program->formals = 1;
			} break;
case 109:
/* # line 982 "/home/gsf/src/lib/libexpr/exparse.y" */
{
				expr.program->formals = 0;
				expr.id->lex = PROCEDURE;
				expr.id->type = expr.declare;
			} break;
case 110:
/* # line 987 "/home/gsf/src/lib/libexpr/exparse.y" */
{
			exval.expr = expr.procedure;
			expr.procedure = 0;
			if (expr.program->frame)
			{
				expr.program->symbols = expr.program->frame->view;
				dtview(expr.program->frame, NiL);
			}
			exval.expr->data.operand.left = expvt[-5].expr;
			exval.expr->data.operand.right = excast(expr.program, expvt[-1].expr, exval.expr->type, NiL, 0);

			/*
			 * NOTE: procedure definition was slipped into the
			 *	 declaration initializer statement production,
			 *	 therefore requiring the statement terminator
			 */

			exunlex(expr.program, ';');
		} break;
	}
	goto exstack;		/* reset registers in driver code */
}
