#include "AddNoRet.moc"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <qtooltip.h>
#include <kapplication.h>
#include <kfiledialog.h>
#include <kurlrequester.h>

AddNoRet::AddNoRet(QWidget * parent, char * wname)
  : KURLRequesterDlg(QString::null, i18n("Filename:"), parent, wname)
{
	setCaption(i18n("Add Non-Retrievable File/Directory"));
	QToolTip::add(urlRequester(),i18n("End the filename with a / to indicate it is\nan entire directory; no file in this directory\nwill be retrievable."));
	urlRequester()->setMode(KFile::ExistingOnly | KFile::LocalOnly );
}
AddNoRet::~AddNoRet()
{
}
void AddNoRet::slotOk()
{
	QString f = urlRequester()->url();
	if(!f.isEmpty())
		emit noRetAdded(f);
	accept();
}
