#include "field.h"
#include "field.moc"

#include <qwhatsthis.h>

#include <klocale.h>

#include "generic/gmisc_ui.h"
#include "base/board.h"


FEField::FEField(QWidget *parent)
    : Field(parent)
{
    QWhatsThis::add(removedList,
                    i18n("Display the number of removed groups (\"puyos\")\n"
                         "classified by depth. '-' correponds to depth\n"
                         "higher than 3."));
    for (uint i=0; i<4; i++) {
        KGameLCD *lcd = new KGameLCD(6, removedList);
        removedList->append(lcd);
        lcd->setLeadingString(i==3 ? "-" : QString::number(i));
    }

    connect(board, SIGNAL(removedUpdated(uint, uint)),
            SLOT(removedUpdated(uint, uint)));
}

void FEField::removedUpdated(uint chain, uint removed)
{
    Q_ASSERT( chain<4 );
    KGameLCD *lcd = static_cast<KGameLCD *>(removedList->lcd(chain));
    lcd->displayInt(removed);
    lcd->highlight();
}
