//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#ifndef PMDECLARE_H
#define PMDECLARE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmcompositeobject.h"
#include "pmsymboltable.h"

/**
 * Class for all povray declares
 */
class PMDeclare : public PMCompositeObject
{
   typedef PMCompositeObject Base;
public:
   /** Declare types */
   enum PMDeclareType { NoDeclare, ObjectDeclare, TextureDeclare, PigmentDeclare,
                        FinishDeclare, NormalDeclare, TextureMapDeclare, 
                        PigmentMapDeclare, ColorMapDeclare, NormalMapDeclare, 
                        SlopeMapDeclare, DensityMapDeclare, InteriorDeclare, 
                        MediaDeclare, MaterialDeclare, DensityDeclare, 
                        SkySphereDeclare, RainbowDeclare, FogDeclare };

   /** Constructor */
   PMDeclare( );
   /** Deletes the object */
   ~PMDeclare( );
   
   /** */
   virtual PMObject* newObject( ) const { return new PMDeclare( ); }
   /** */
   virtual QString className( ) const { return QString( "declare" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual QString pixmap( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTDeclare; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual bool canInsert( PMObjectType t, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual int canInsert( const PMObjectList& list, const PMObject* after );
   /** */
   virtual int canInsert( const QValueList<PMObjectType>& list, const PMObject* after );

   /** */
   virtual bool dataChangeOnInsertRemove( ) const { return true; }
   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );

   /** Returns a new @ref PMDeclareEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** Returns the id of the declare */
   virtual QString name( ) const { return m_id; }
   /** Returns the id of the declare */
   QString id( ) const { return m_id; }
   /** Returns the declare type */
   PMDeclareType declareType( ) const { return m_declareType; }
   
   /** Sets the id of the object. */
   void setID( const QString& id );
   /** */
   virtual bool canHaveName( ) const { return true; }

   /** */
   virtual void restoreMemento( PMMemento* s );
   /**
    * Returns an iterator to the list of objects, that are linked to that
    * declare
    */
   PMObjectListIterator linkedObjects( ) const
   {
      return PMObjectListIterator( m_linkedObjects );
   }
   /** Adds the object to the list of linked objects */
   void addLinkedObject( PMObject* o );
   /** Removes the object from the list of linked objects */
   void removeLinkedObject( PMObject* o );

   /** */
   virtual void childAdded( PMObject* o );
   
private:
   /** Sets the declare type */
   void setDeclareType( PMDeclareType t );
   /** IDs for @ref PMMementoData */
   enum PMDeclareMementoID { PMIDID, PMDeclareTypeID };
   /** Returns the declare type for object o */
   PMDeclareType declareTypeByObjectType( PMObjectType t ) const;
   
   /** id of the declare */
   QString m_id;
   /** The linked objects */
   PMObjectList m_linkedObjects;
   /** The declare type */
   PMDeclareType m_declareType;
};

#endif
