//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMPIGMENT_H
#define PMPIGMENT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebase.h"

/**
 * Class for povray pigments
 */
class PMPigment : public PMTextureBase
{
   typedef PMTextureBase Base;
public:
   /** Creates an PMPigment */
   PMPigment( );
   /** Deletes the object */
   virtual ~PMPigment( );
   
   /** */
   virtual PMObject* newObject( ) const { return new PMPigment( ); }
   /** */
   virtual QString className( ) const { return QString( "pigment" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTPigment; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual int canInsert( const QValueList<PMObjectType>& list,
                          const PMObject* after ) const;
   /** */
   virtual int canInsert( const PMObjectList& list,
                          const PMObject* after ) const;
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;

   /** Returns a new @ref PMPigmentEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmpigment" ); }

private:
   void countChild( PMObjectType t,
                    int& color, int& listpattern, int& pattern, int& map,
                    int& warp, int& blend, int& summap, int& sum, 
                    bool& afterPattern, bool& afterMap, bool& afterWarp, 
                    bool& afterBlend, bool& afterTransform, bool insertPoint ) const;
   bool canInsert( PMObjectType t,
                   int color, int listpattern, int pattern, int map,
                   int warp, int blend, int summap, int sum, 
                   bool afterPattern, bool afterMap, bool afterWarp, 
                   bool afterBlend, bool afterTransform ) const;

   /** IDs for @ref PMMementoData */
//   enum PMPigmentMementoID { };
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};


#endif
