//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMSKYSPHERE_H
#define PMSKYSPHERE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebase.h"

/**
 * Class for povray skyspheres
 */
class PMSkySphere : public PMTextureBase
{
   typedef PMTextureBase Base;
public:
   /** Creates an PMSkySphere */
   PMSkySphere( );
   /** Deletes the object */
   virtual ~PMSkySphere( );
   
   /** */
   virtual PMObject* newObject( ) const { return new PMSkySphere( ); }
   /** */
   virtual QString className( ) const { return QString( "skysphere" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTSkySphere; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual bool canInsert( PMObjectType t, const PMObject* after,
                           const PMObjectList* objectsBetween ) const;
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;

   /** Returns a new @ref PMSkySphereEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmskysphere" ); }

private:
   /** IDs for @ref PMMementoData */
//   enum PMSkySphereMementoID { };
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};


#endif
