// $Id: kbbprefs.cpp,v 1.19 2002/09/26 09:16:54 cschumac Exp $
 
#include <qstring.h> 
#include <qstringlist.h> 
 
#include <klocale.h> 
#include <kdebug.h> 
#include <kconfig.h> 
 
#include "kbbprefs.h" 
 
KBBPrefs *KBBPrefs::mInstance = 0; 
 
KBBPrefs::KBBPrefs() : 
  KPrefs() 
{ 
  KPrefs::setCurrentGroup("History"); 
 
  addItemStringList("RecentPackages",&mRecentPackages); 
  addItemInt("RecentPackagesCount",&mRecentPackagesCount,5); 
  addItemString("CurrentPackage",&mCurrentPackage); 
  addItemString("CurrentBug",&mCurrentBug); 
  addItemIntList("Splitter1",&mSplitter1); 
  addItemIntList("Splitter2",&mSplitter2); 
 
  KPrefs::setCurrentGroup("Personal Settings"); 
 
  addItemInt("Mail Client",&mMailClient,MailSender::KMail); 
  addItemBool("ShowClosedBugs",&mShowClosedBugs,false); 
  addItemBool("ShowWishes",&mShowWishes,true); 
  addItemBool("SendBCC",&mSendBCC,false); 
  addItemString("OverrideRecipient",&mOverrideRecipient,QString::null);
  addItemString( "BugzillaURL", &mBugzillaURL, "http://bugs.kde.org" );
  
  KPrefs::setCurrentGroup("MsgInputDlg");

  addItemInt("MsgDialogWidth",&mMsgDlgWidth);
  addItemInt("MsgDialogHeight",&mMsgDlgHeight);
  addItemIntList("MsgDialogSplitter",&mMsgDlgSplitter);

  KPrefs::setCurrentGroup("Servers");
  
  addItemStringList("Servers",&mServers);
} 
 
 
KBBPrefs::~KBBPrefs() 
{ 
  delete mInstance; 
  mInstance = 0; 
} 
 
 
KBBPrefs *KBBPrefs::instance() 
{ 
  if (!mInstance) { 
    mInstance = new KBBPrefs(); 
    mInstance->readConfig(); 
  } 
 
  return mInstance; 
} 
 
void KBBPrefs::usrSetDefaults() 
{
  setMessageButtonsDefault(); 
} 
 
void KBBPrefs::usrReadConfig() 
{ 
  mMessageButtons.clear(); 
 
  config()->setGroup("MessageButtons"); 
  QStringList buttonList = config()->readListEntry("ButtonList"); 
  if (buttonList.isEmpty()) { 
    setMessageButtonsDefault(); 
  } else { 
    QStringList::ConstIterator it; 
    for(it = buttonList.begin(); it != buttonList.end(); ++it) { 
      QString text = config()->readEntry(*it); 
      mMessageButtons.insert(*it,text); 
    } 
  } 
} 
 
void KBBPrefs::usrWriteConfig() 
{ 
  config()->setGroup("MessageButtons"); 
  QStringList buttonList; 
  QMap<QString,QString>::ConstIterator it; 
  for(it = mMessageButtons.begin();it != mMessageButtons.end();++it) { 
    buttonList.append(it.key()); 
    config()->writeEntry(it.key(),it.data()); 
  } 
  config()->writeEntry("ButtonList",buttonList); 
} 
 
void KBBPrefs::setMessageButtonsDefault() 
{ 
  mMessageButtons.clear(); 
  mMessageButtons.insert(i18n("Bug Fixed in CVS"),"Thank you for your bug report.\n" 
  "The bug that you reported has been identified and has been fixed in the\n"
  "latest development (CVS) version of KDE. The bug report will be closed.\n");
  mMessageButtons.insert(i18n("Duplicate Report"),"Thank you for your bug report.\n"
  "This bug/feature request has already been reported and this report will\n"
  "be marked as a duplicate.\n");
  mMessageButtons.insert(i18n("Packaging Bug"),"Thank you for your bug report.\n"
  "The bug that you reported appears to be a packaging bug, due to a\n"
  "problem in the way in which your distribution/vendor has packaged\n"
  "KDE for distribution.\n"
  "The bug report will be closed since it is not a KDE problem.\n"
  "Please send the bug report to your distribution/vendor instead.\n");
  mMessageButtons.insert(i18n("Feature Implemented in CVS"),"Thank you for your bug report.\n"
  "The feature that you requested has been implemented in the latest\n"
  "development (CVS) version of KDE. The feature request will be closed.\n");
  mMessageButtons.insert(i18n("More Information Required"),"Thank you for your bug report.\n"
  "You have not provided enough information for us to be able to reproduce\n"
  "the bug. Please provide a detailed account of the steps required to\n"
  "trigger and reproduce the bug. Without this information, we will not be\n"
  "able to reproduce, identify and fix the bug.\n");
  mMessageButtons.insert(i18n("No Longer Applicable"),"Thank you for your bug report.\n"
  "The bug that your reported no longer applies to the latest development\n"
  "(CVS) version of KDE. This is most probably because it has been fixed,\n"
  "the application has been substantially modified or the application no\n"
  "longer exists. The bug report will be closed.\n");
  mMessageButtons.insert(i18n("Won't Fix Bug"),"Thank you for your bug report/feature request.\n"
  "Unfortunately, this bug will never be fixed or the feature never\n"
  "implemented. The bug report/feature request will be closed.\n");
  mMessageButtons.insert(i18n("Can't Reproduce Bug"),"Thank you for your bug report.\n"
  "This bug can not be reproduced using the current development (CVS)\n"
  "version of KDE. This suggests that the bug has already been fixed.\n"
  "The bug report will be closed.\n");
} 
 
