#ifndef _WINBINDD_PROTO_H_
#define _WINBINDD_PROTO_H_
/* This file is automatically generated with "make proto". DO NOT EDIT */


/* The following definitions come from nsswitch/winbindd.c  */

int main(int argc, char **argv);

/* The following definitions come from nsswitch/winbindd_cache.c  */

void wcache_flush_cache(void);
void winbindd_check_cache_size(time_t t);
struct cache_entry *centry_start(struct winbindd_domain *domain, NTSTATUS status);

/* The following definitions come from nsswitch/winbindd_cm.c  */

NTSTATUS cm_get_lsa_handle(char *domain, CLI_POLICY_HND **return_hnd);
NTSTATUS cm_get_sam_handle(char *domain, CLI_POLICY_HND **return_hnd);
CLI_POLICY_HND *cm_get_sam_dom_handle(char *domain, DOM_SID *domain_sid);
CLI_POLICY_HND *cm_get_sam_user_handle(char *domain, DOM_SID *domain_sid,
				       uint32 user_rid);
CLI_POLICY_HND *cm_get_sam_group_handle(char *domain, DOM_SID *domain_sid,
					uint32 group_rid);
NTSTATUS cm_get_netlogon_cli(char *domain, unsigned char *trust_passwd,
			     struct cli_state **cli);
void winbindd_cm_status(void);
void winbindd_cm_flush(void);

/* The following definitions come from nsswitch/winbindd_group.c  */

enum winbindd_result winbindd_getgrnam(struct winbindd_cli_state *state);
enum winbindd_result winbindd_getgrgid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_setgrent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_endgrent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_getgrent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_list_groups(struct winbindd_cli_state *state);
enum winbindd_result winbindd_getgroups(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_idmap.c  */

BOOL winbindd_idmap_get_uid_from_sid(DOM_SID *sid, uid_t *uid);
BOOL winbindd_idmap_get_gid_from_sid(DOM_SID *sid, gid_t *gid);
BOOL winbindd_idmap_get_uid_from_rid(const char *dom_name, uint32 rid, uid_t *uid);
BOOL winbindd_idmap_get_gid_from_rid(const char *dom_name, uint32 rid, gid_t *gid);
BOOL get_sid_from_id(int id, DOM_SID *sid, BOOL isgroup);
BOOL winbindd_idmap_get_sid_from_uid(uid_t uid, DOM_SID *sid);
BOOL winbindd_idmap_get_sid_from_gid(gid_t gid, DOM_SID *sid);
BOOL winbindd_idmap_get_rid_from_uid(uid_t uid, uint32 *user_rid,
                                     struct winbindd_domain **domain);
BOOL winbindd_idmap_get_rid_from_gid(gid_t gid, uint32 *group_rid, 
                                     struct winbindd_domain **domain);
BOOL winbindd_idmap_init(void);
BOOL winbindd_idmap_close(void);
void winbindd_idmap_status(void);

/* The following definitions come from nsswitch/winbindd_misc.c  */

enum winbindd_result winbindd_check_machine_acct(struct winbindd_cli_state *state);
enum winbindd_result winbindd_list_trusted_domains(struct winbindd_cli_state
						   *state);
enum winbindd_result winbindd_show_sequence(struct winbindd_cli_state *state);
enum winbindd_result winbindd_ping(struct winbindd_cli_state
						   *state);
enum winbindd_result winbindd_info(struct winbindd_cli_state *state);
enum winbindd_result winbindd_interface_version(struct winbindd_cli_state *state);
enum winbindd_result winbindd_domain_name(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_pam.c  */

enum winbindd_result winbindd_pam_auth(struct winbindd_cli_state *state) ;
enum winbindd_result winbindd_pam_auth_crap(struct winbindd_cli_state *state) ;
enum winbindd_result winbindd_pam_chauthtok(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_rpc.c  */


/* The following definitions come from nsswitch/winbindd_sid.c  */

enum winbindd_result winbindd_lookupsid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_lookupname(struct winbindd_cli_state *state);
enum winbindd_result winbindd_sid_to_uid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_sid_to_gid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_uid_to_sid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_gid_to_sid(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_user.c  */

enum winbindd_result winbindd_getpwnam(struct winbindd_cli_state *state) ;
enum winbindd_result winbindd_getpwuid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_setpwent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_endpwent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_getpwent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_list_users(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_util.c  */

struct winbindd_domain *domain_list(void);
void free_domain_list(void);
BOOL init_domain_list(void);
struct winbindd_domain *find_domain_from_name(const char *domain_name);
struct winbindd_domain *find_domain_from_sid(DOM_SID *sid);
BOOL winbindd_lookup_sid_by_name(struct winbindd_domain *domain, 
				 const char *name, DOM_SID *sid, 
				 enum SID_NAME_USE *type);
BOOL winbindd_lookup_name_by_sid(DOM_SID *sid,
				 fstring dom_name,
				 fstring name,
				 enum SID_NAME_USE *type);
void free_getent_state(struct getent_state *state);
BOOL winbindd_param_init(void);
BOOL check_domain_env(char *domain_env, char *domain);
BOOL parse_domain_user(const char *domuser, fstring domain, fstring user);
void fill_domain_username(fstring name, const char *domain, const char *user);

/* The following definitions come from nsswitch/winbindd_wins.c  */

enum winbindd_result winbindd_wins_byip(struct winbindd_cli_state *state);
enum winbindd_result winbindd_wins_byname(struct winbindd_cli_state *state);
#endif /* _PROTO_H_ */
