/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteRef;

public abstract class RemoteObject
implements Remote,
Serializable {
    public static final long serialVersionUID = -3215090123894869218L;
    protected transient RemoteRef ref;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    protected RemoteObject() {
        this(null);
    }

    protected RemoteObject(RemoteRef newref) {
        this.ref = newref;
    }

    public RemoteRef getRef() {
        return this.ref;
    }

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        Class cls = obj.getClass();
        String classname = cls.getName();
        ClassLoader cl = cls.getClassLoader();
        try {
            Class scls = cl.loadClass(classname + "_Stub");
            Class[] stubprototype = new Class[]{RemoteObject.class$("java.rmi.server.RemoteRef")};
            Constructor con = scls.getConstructor(stubprototype);
            return (Remote)con.newInstance(new Object[]{obj});
        }
        catch (Exception e) {
            throw new NoSuchObjectException(obj.getClass().getName());
        }
    }

    public int hashCode() {
        if (this.ref == null) {
            return 0;
        }
        return this.ref.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        if (this.ref == null) {
            return this.getClass().toString();
        }
        return this.ref.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String cname = in.readUTF();
        if (!cname.equals("")) {
            if (cname.equals("UnicastRef2")) {
                cname = "UnicastRef";
                in.read();
            }
            cname = "gnu.java.rmi.server." + cname;
            try {
                Class cls = Class.forName(cname);
                this.ref = (RemoteRef)cls.newInstance();
            }
            catch (InstantiationException e1) {
                throw new UnmarshalException("failed to create ref", e1);
            }
            catch (IllegalAccessException e2) {
                throw new UnmarshalException("failed to create ref", e2);
            }
            this.ref.readExternal(in);
        } else {
            this.ref = (RemoteRef)in.readObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new UnmarshalException("no ref to serialize");
        }
        String cname = this.ref.getRefClass(out);
        if (cname != null && cname.length() > 0) {
            out.writeUTF(cname);
            this.ref.writeExternal(out);
        } else {
            out.writeUTF("");
            out.writeObject(this.ref);
        }
    }
}

