/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.BasicPermissionCollection;
import java.security.Permission;
import java.security.PermissionCollection;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 6279438298436773498L;

    public BasicPermission(String name) {
        super(name);
        if (name.indexOf("*") != -1 && (!name.endsWith(".*") && !name.equals("*") || name.indexOf("*") != name.lastIndexOf("*"))) {
            throw new IllegalArgumentException("Bad wildcard: " + name);
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("Empty name");
        }
    }

    public BasicPermission(String name, String actions) {
        this(name);
    }

    public boolean implies(Permission perm) {
        if (!this.getClass().isInstance(perm)) {
            return false;
        }
        String otherName = perm.getName();
        String name = this.getName();
        if (name.equals(otherName)) {
            return true;
        }
        int last = name.length() - 1;
        return name.charAt(last) == '*' && otherName.startsWith(name.substring(0, last));
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.getName().equals(((BasicPermission)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection(this.getClass());
    }
}

