# - Use Module for QT4
# Sets up C and C++ to use Qt 4.  It is assumed that FindQt.cmake
# has already been loaded.  See FindQt.cmake for information on
# how to load Qt 4 into your CMake project.

#=============================================================================
# Copyright 2005-2009 Kitware, Inc.
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================
# (To distributed this file outside of CMake, substitute the full
#  License text for the above reference.)

ADD_DEFINITIONS(${QT_DEFINITIONS})
SET_PROPERTY(DIRECTORY APPEND PROPERTY COMPILE_DEFINITIONS_DEBUG QT_DEBUG)
SET_PROPERTY(DIRECTORY APPEND PROPERTY COMPILE_DEFINITIONS_RELEASE QT_NO_DEBUG)
SET_PROPERTY(DIRECTORY APPEND PROPERTY COMPILE_DEFINITIONS_RELWITHDEBINFO QT_NO_DEBUG)
SET_PROPERTY(DIRECTORY APPEND PROPERTY COMPILE_DEFINITIONS_MINSIZEREL QT_NO_DEBUG)

INCLUDE_DIRECTORIES(${QT_INCLUDE_DIR})

SET(QT_LIBRARIES "")

IF (QT_USE_QTMAIN)
  IF (WIN32)
    SET(QT_LIBRARIES ${QT_LIBRARIES} ${QT_QTMAIN_LIBRARY})
  ENDIF (WIN32)
ENDIF (QT_USE_QTMAIN)

IF(QT_DONT_USE_QTGUI)
  SET(QT_USE_QTGUI 0)
ELSE(QT_DONT_USE_QTGUI)
  SET(QT_USE_QTGUI 1)
ENDIF(QT_DONT_USE_QTGUI)

IF(QT_DONT_USE_QTCORE)
  SET(QT_USE_QTCORE 0)
ELSE(QT_DONT_USE_QTCORE)
  SET(QT_USE_QTCORE 1)
ENDIF(QT_DONT_USE_QTCORE)

IF (QT_USE_QT3SUPPORT)
  ADD_DEFINITIONS(-DQT3_SUPPORT)
ENDIF (QT_USE_QT3SUPPORT)

# list dependent modules, so dependent libraries are added
SET(QT_QT3SUPPORT_MODULE_DEPENDS QTGUI QTSQL QTXML QTNETWORK QTCORE)
SET(QT_QTSVG_MODULE_DEPENDS QTGUI QTXML QTCORE)
SET(QT_QTUITOOLS_MODULE_DEPENDS QTGUI QTXML QTCORE)
SET(QT_QTHELP_MODULE_DEPENDS QTGUI QTSQL QTXML QTNETWORK QTCORE)
IF(QT_QTDBUS_FOUND)
  SET(QT_PHONON_MODULE_DEPENDS QTGUI QTDBUS QTCORE)
ELSE(QT_QTDBUS_FOUND)
  SET(QT_PHONON_MODULE_DEPENDS QTGUI QTCORE)
ENDIF(QT_QTDBUS_FOUND)
SET(QT_QTDBUS_MODULE_DEPENDS QTXML QTCORE)
SET(QT_QTXMLPATTERNS_MODULE_DEPENDS QTNETWORK QTCORE)
SET(QT_QAXCONTAINER_MODULE_DEPENDS QTGUI QTCORE)
SET(QT_QAXSERVER_MODULE_DEPENDS QTGUI QTCORE)
SET(QT_QTSCRIPTTOOLS_MODULE_DEPENDS QTGUI QTCORE)
SET(QT_QTWEBKIT_MODULE_DEPENDS QTXMLPATTERNS QTGUI QTCORE)
SET(QT_QTDECLARATIVE_MODULE_DEPENDS QTWEBKIT QTSCRIPT QTSVG QTSQL QTXMLPATTERNS QTXML QTOPENGL QTGUI QTNETWORK QTCORE)

# Qt modules  (in order of dependence)
FOREACH(module QT3SUPPORT QTOPENGL QTASSISTANT QTDESIGNER QTMOTIF QTNSPLUGIN
               QAXSERVER QAXCONTAINER QTDECLARATIVE QTSCRIPT QTSVG QTUITOOLS QTHELP
               QTWEBKIT PHONON QTSCRIPTTOOLS QTGUI QTTEST QTDBUS QTXML QTSQL 
               QTXMLPATTERNS QTNETWORK QTCORE)

  IF (QT_USE_${module} OR QT_USE_${module}_DEPENDS)
    IF (QT_${module}_FOUND)
      IF(QT_USE_${module})
        STRING(REPLACE "QT" "" qt_module_def "${module}")
        ADD_DEFINITIONS(-DQT_${qt_module_def}_LIB)
        INCLUDE_DIRECTORIES(${QT_${module}_INCLUDE_DIR})
      ENDIF(QT_USE_${module})
      SET(QT_LIBRARIES ${QT_LIBRARIES} ${QT_${module}_LIBRARY})
      IF(QT_IS_STATIC)
        SET(QT_LIBRARIES ${QT_LIBRARIES} ${QT_${module}_LIB_DEPENDENCIES})
      ENDIF(QT_IS_STATIC)
      FOREACH(depend_module ${QT_${module}_MODULE_DEPENDS})
        SET(QT_USE_${depend_module}_DEPENDS 1)
      ENDFOREACH(depend_module ${QT_${module}_MODULE_DEPENDS})
    ELSE (QT_${module}_FOUND)
      MESSAGE("Qt ${module} library not found.")
    ENDIF (QT_${module}_FOUND)
  ENDIF (QT_USE_${module} OR QT_USE_${module}_DEPENDS)
  
ENDFOREACH(module)

