/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.serql;

import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.serql.ASTVisitorBase;
import org.openrdf.query.parser.serql.SeRQLUtil;
import org.openrdf.query.parser.serql.ast.ASTLiteral;
import org.openrdf.query.parser.serql.ast.ASTQueryContainer;
import org.openrdf.query.parser.serql.ast.ASTString;
import org.openrdf.query.parser.serql.ast.VisitorException;

class StringEscapesProcessor {
    StringEscapesProcessor() {
    }

    public static void process(ASTQueryContainer qc) throws MalformedQueryException {
        StringProcessor visitor = new StringProcessor();
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), e);
        }
    }

    private static class StringProcessor
    extends ASTVisitorBase {
        public Object visit(ASTString stringNode, Object data) throws VisitorException {
            String value = stringNode.getValue();
            try {
                value = SeRQLUtil.decodeString(value);
                stringNode.setValue(value);
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
            return super.visit(stringNode, data);
        }

        public Object visit(ASTLiteral literalNode, Object data) throws VisitorException {
            String label = literalNode.getLabel();
            try {
                label = SeRQLUtil.decodeString(label);
                literalNode.setLabel(label);
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
            return super.visit(literalNode, data);
        }
    }
}

