/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * uwa-trace.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UWA_TRACE_H
#define __UWA_TRACE_H

#include <glib.h>

typedef struct _UwaTrace UwaTrace;

UwaTrace *uwa_trace_new_for_test_name(const gchar *name, const gchar *channel);
void uwa_trace_free (UwaTrace *trace);

gboolean uwa_trace_process_line (UwaTrace *trace, const gchar *line);

gboolean uwa_trace_passed (UwaTrace *trace, gboolean print_next);

#endif
