/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ResourceUtils;

public class SourceFileScanner
implements ResourceFactory {
    protected Task task;
    private FileUtils fileUtils;
    private File destDir;

    public SourceFileScanner(Task task) {
        this.task = task;
        this.fileUtils = FileUtils.newFileUtils();
    }

    public String[] restrict(String[] files, File srcDir, File destDir, FileNameMapper mapper) {
        this.destDir = destDir;
        Vector<Resource> v = new Vector<Resource>();
        int i = 0;
        while (i < files.length) {
            File src = this.fileUtils.resolveFile(srcDir, files[i]);
            v.addElement(new Resource(files[i], src.exists(), src.lastModified(), src.isDirectory()));
            ++i;
        }
        Object[] sourceresources = new Resource[v.size()];
        v.copyInto(sourceresources);
        Resource[] outofdate = ResourceUtils.selectOutOfDateSources(this.task, (Resource[])sourceresources, mapper, this);
        String[] result = new String[outofdate.length];
        int counter = 0;
        while (counter < outofdate.length) {
            result[counter] = outofdate[counter].getName();
            ++counter;
        }
        return result;
    }

    public File[] restrictAsFiles(String[] files, File srcDir, File destDir, FileNameMapper mapper) {
        String[] res = this.restrict(files, srcDir, destDir, mapper);
        File[] result = new File[res.length];
        int i = 0;
        while (i < res.length) {
            result[i] = new File(srcDir, res[i]);
            ++i;
        }
        return result;
    }

    public Resource getResource(String name) {
        File src = this.fileUtils.resolveFile(this.destDir, name);
        return new Resource(name, src.exists(), src.lastModified(), src.isDirectory());
    }
}

