#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <pty.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/wait.h>

static void setup_termios(int fd)
{
	struct termios stermios;
	tcgetattr(fd, &stermios);
	
	/* raw */
	stermios.c_lflag = 0;
	stermios.c_oflag &= ~(ONLCR);
	stermios.c_iflag &= (ISTRIP | IGNBRK);
	stermios.c_cflag = CS8;
	tcsetattr(fd, TCSANOW,&stermios);
}

void setup_termcap(void)
{
	/* setup a dummy termcap entry */
	setenv("TERM", "testpc", 1);
	setenv("TERMCAP", 
		"testpc| for testing dosemu in scancode mode:"
		":am::co#80:it#8:li#25:"
		":ce=\\E[K:cl=\\E[H\\E[2J:cm=\\E[%i%d;%dH:do=\\E[B:ho=\\E[H:"
		":le=\\E[D:nd=\\E[C:ta=^I:up=\\E[A:"
		":S4=pcon:S5=pcoff:"
		, 
		1);
}

void compute_next_time(struct timeval *tv, int usecs_away)
{
	tv->tv_usec += usecs_away;
	if (tv->tv_usec > 1000000) {
		tv->tv_sec += tv->tv_usec / 1000000;
		tv->tv_usec %= 1000000;
	}
}

long diff_times(struct timeval *tv1, struct timeval *tv2) 
{
	long diff;
	diff = 0;
	diff = (tv1->tv_sec - tv2->tv_sec) * 1000000;
	diff += (tv1->tv_usec - tv2->tv_usec);
	return diff;
}

int main(int argc, char **argv)
{
	pid_t child;
	int master_fd;
	long initial_delay;
	long per_character_delay;
	int optind;
	/* place holder in case I ever need to pass these */
	char *slave_name = NULL; 
	struct termios *tp = NULL; 
	struct winsize *ws = NULL;
	struct termios old_termios;

	tcgetattr(STDIN_FILENO, &old_termios);
#if 0
	setup_termios(STDIN_FILENO);
#endif

	setup_termcap();

	optind = 3;
	initial_delay = atol(argv[1]);
	per_character_delay = atol(argv[2]);

	child = forkpty(&master_fd, slave_name, tp, ws);
	if (child == 0) {
		/* child, pass through the command line arguments */
		setup_termios(STDIN_FILENO);
		execvp(argv[optind], argv +optind);
		exit(-1);
	} else if (child > 0) {
		/* parent, send the scancodes */
		char read_buf[256];
		int bytes_read;
		fd_set read_set, write_set, except_set;
		int rc;
		struct timeval write_time;

		FD_ZERO(&read_set);
		FD_ZERO(&write_set);
		FD_ZERO(&except_set);

		setup_termios(master_fd);

		gettimeofday(&write_time, 0);
		compute_next_time(&write_time, initial_delay);
#if 0
		#define MAX_READ sizeof(read_buf)
#else
		#define MAX_READ 1
#endif
		while (1) {
			struct timeval tv;
			long usecs;
			if (waitpid(child, NULL, WNOHANG) == child) {
				break;
			}
			errno = 0;
			gettimeofday(&tv, 0);
			
			usecs = diff_times(&tv, &write_time);
			if (usecs < 0) {
				tv.tv_sec = 0;
				tv.tv_usec = 0;
				compute_next_time(&tv, -usecs);
				FD_CLR(master_fd, &write_set);
			} else {
				tv.tv_sec = 10;
				tv.tv_usec = 0;
				FD_SET(master_fd, &write_set);
			}
			FD_SET(master_fd, &read_set);
			FD_SET(master_fd, &except_set);
			rc = select(master_fd +1, &read_set, &write_set, 0, &tv);

			if ((rc > 0) && FD_ISSET(master_fd, &read_set)) {
				bytes_read = read(master_fd, read_buf, sizeof(read_buf));
				if (bytes_read > 0) {
					write(STDOUT_FILENO, read_buf, bytes_read);
				}
			}
			else if ((rc > 0) && FD_ISSET(master_fd, &write_set)) {
				bytes_read = read(STDIN_FILENO, read_buf, MAX_READ);
				if (bytes_read > 0) {
					write(master_fd, read_buf, bytes_read);
				}
				compute_next_time(&write_time, per_character_delay);
			} else if (((rc >0) && FD_ISSET(master_fd, &except_set)) 
				|| (rc < 0)) {
				fprintf(stderr, "rc = %d %s\n", rc, strerror(errno));
				break;
			}
		}
		tcdrain(master_fd);
		waitpid(child, NULL, 0);
		kill(child, SIGTERM);
		close(master_fd);

		tcsetattr(STDIN_FILENO, TCSANOW, &old_termios);
	}
	return 0;
}
