/***
 *** message printing tools
 *** Written by Koen Gadeyne (kmg@barco.be)
 ***
 *** version : 0.2
 ***/

#ifndef _MESSAGES_H
#define _MESSAGES_H

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (-1)
#endif

void print_msg(char *format,...);

extern char* CommandName;
extern char msgtype[20];
extern int debug_messages;

#define PDEBUG(arg) { if (debug_messages == TRUE) { strcpy(msgtype,"DEBUG") ; print_msg arg; } }

#define PERROR(arg) { strcpy(msgtype,"ERROR") ; print_msg arg; exit (1); }

#define PWARNING(arg) { strcpy(msgtype,"WARNING") ; print_msg arg; }

#define PMESSAGE(arg) { strcpy(msgtype,"") ; print_msg arg; }

#endif