/*
	Copyright (c) Andreas Beck 1995. All Rights reserved.
	  Andreas Beck - becka@hp.rz.uni-duesseldorf.de
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <asm/io.h>
#include "set.h"

#define TRUE      1
#define FALSE     0

#if 0
inline void outportb( unsigned short port, char value)
{
__asm__ __volatile__ ("outb %%al,%%dx"
		::"a" ((char) value),"d" ((unsigned short) port));
}

inline unsigned int inportb(unsigned short port)
{
	unsigned int _v;
__asm__ __volatile__ ("inb %%dx,%%al"
		:"=a" (_v):"d" ((unsigned short) port),"0" (0));
	return _v;
}
#endif
/*
** Routine to set the permissions of i/o
** ports used for clock manipulation.  May not
** be clean, but it works.  --  RLB
*/

void perm_ports(int perm)
{
  ioperm(0x3d4, 1, perm);
  ioperm(0x3d5, 1, perm);
}

/* Enable S3 extended CRTC registers - AB */
void enable_s3(void)
{ outb(0x38,0x03d4);outb(0x48,0x03d5);
  outb(0x39,0x03d4);outb(0xa0,0x03d5);
}

int main(void)
  { 
    perm_ports( TRUE );  /* set i/o permissions - RLB */
    enable_s3();	 /* set access to S3-Registers - AB */
    outb(0x42,0x03d4);
    outb(inb(0x03d5)|4,0x03d5);
    perm_ports( FALSE ); /* clear i/o permissions - RLB */
    return 0;
  }

/* End of FREQ.C */
