/***
 *** setpalette: palette set/get program
 *** (c) 1995 Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <asm/io.h>
#include "vga_prg.h"
#include "messages.h"
#include "configfile.h"

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (-1)
#endif
 
char *CommandName;
int debug_messages=FALSE;
int setreg=FALSE;

void dumprgb(int index)
{
  int r,g,b;
  
  outb(index,0x3c7);
  r=inb(0x3c9);
  g=inb(0x3c9);
  b=inb(0x3c9);
  printf("%03d: %03d %03d %03d\n",index,r,g,b);
}  

#define WRITERGB(index,r,g,b) ( outb((index),0x3c8) , outb((r),0x3c9) , outb((g),0x3c9) , outb((b),0x3c9) )

void usage(int setreg)
{
     PMESSAGE(("version %s. (c) 1995 Koen Gadeyne (kmg@barco.be)\n Usage: %s [options] %s\n\n\
     Options: -n  Don't program VGA hardware\n\
              -d  print debugging information\n\
              -h  print usage information\n\n\
     color_index: index number in the palette look-up table (0..255).\n\
                  %s.\n\
     %s",
      VERSION, CommandName,
      (setreg==TRUE) ? "color_index R G B" : "[color_index]",
      (setreg==TRUE) ? "if '-' instead of number: use standard input" : "if 'all' instead of number: show all 256 entries",
      (setreg==TRUE) ? "R, G, B : color intensity for Red, Green or Blue (0..63).\n" : "" ))
}
 

void main (int argc, char* argv[])
{
  int index,r,g,b;
  char* commandfilename;
  int program_hardware=TRUE;
  char c;
   
 /*
  * See what action is required: read or write VGA register
  */

  CommandName = argv[0];
  commandfilename = strrchr(CommandName, '/'); commandfilename++;
  if (!strncasecmp(commandfilename,"set",3)) setreg = TRUE;
  else setreg = FALSE;
 
 /*
  * command-line argument parsing
  */

  while ((c = getopt (argc, argv, "ndh")) != EOF)
    switch (c)
    {
      case 'n': program_hardware=FALSE;
                break;
      case 'd': debug_messages=TRUE;
                break;
      case 'h': usage(setreg);
                exit(0);
                break;
      case '?': usage(setreg);
                PERROR(("Bad option '-%c'\n",(char)optopt));
                exit(-1);
                break;
      default: PERROR(("getopt returned unknown token '%c'.",c));
    }

  PDEBUG(("'%cetpalette' function selected through command name '%s'", (setreg==TRUE) ? 's' : 'g', commandfilename));
 
  /* get color-index from commandline , if '-' use stdin */
  if (argc<optind+1) PERROR(("Missing color index (or '%s') on commandline", (setreg==TRUE) ? "-" : "all" ));

  if (program_hardware==TRUE) get_VGA_io_perm(CS_VGA);
  
 /*
  * Start doing something usefull
  */
  
  if (setreg==TRUE)
  {
  if(!strcmp(argv[optind],"-"))      /* use standard input */
    {
      char linebuf[1000];
      int lc=0;

     PMESSAGE(("Using standard input. (Input format = '<index>: <R-value> <G-value> <B-value>')"));      
      while(fgets(linebuf,999,stdin))
      {
        lc++;
        r=g=b=-1;
        sscanf(linebuf,"%03d: %03d %03d %03d",&index,&r,&g,&b);
        if(r==-1 || b==-1 || b==-1) PERROR(("Malformed line #%d",lc));
        if (program_hardware==TRUE) WRITERGB(index,r,g,b);
      }
    }
    else 
    {
      index = getbyte(argv[optind], "color index", 0, 255);
      optind++;
      if (argc<optind+1) PERROR(("Missing color value R"));
      r = getbyte(argv[optind], "Color value R", 0, 63);
      optind++;
      if (argc<optind+1) PERROR(("Missing color value G"));
      g = getbyte(argv[optind], "Color value G", 0, 63);
      optind++;
      if (argc<optind+1) PERROR(("Missing color value B"));
      b = getbyte(argv[optind], "Color value B", 0, 63);
      PDEBUG(("Color index = %d (0x%x); Color values : R = %d (0x%x) , G = %d (0x%x) , B = %d (0x%x).", index, index, r, r, g, g, b, b));
 
      if (program_hardware==TRUE) WRITERGB(index,r,g,b);
    }
  }
  else
  {
    if(strcasecmp(argv[optind],"all"))
    {
      index = getbyte(argv[optind], "color index", 0, 255);
      if (program_hardware==TRUE) dumprgb(index);
    }
    else 
      if (program_hardware==TRUE) for(index=0;index<256;index++) dumprgb(index);
  }
exit(0);
}
