/*
 * acctentries.c 
 *
 * A small program to print out what is stored in /var/adm/acct file
 *
 * Author: Juha Virtanen<jiivee@iki.fi>
 *
 * For a copyright apply GPL
 *
 * Last time modified on 12th MArch 1996
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <linux/acct.h>

#define PUT_TO_SBIN
#define DATE_STRING_LEN 64

int main (int argc, char *argv[])
{
	struct acct ac[sizeof (struct acct)];
	long file_len=0;
	long entries=0;
	char starttime[DATE_STRING_LEN];
	char endtime[DATE_STRING_LEN];
	char *tmptime;
	time_t etime;
	FILE *fp;
	char filename[FILENAME_MAX+1];

	if (argc == 2)
	{
		strcpy (filename, argv[1]);
		if ((fp = fopen (filename, "rb")) == NULL)
		{
			fprintf (stderr, "Could not open %s\n", filename);
			exit (3);
		}
#ifndef PUT_TO_SBIN
		fprintf (stderr, "Opened %s for reading\n", filename);
#endif
	}
	else
	{
		fprintf (stderr, "Usage: %s filename\n", argv[0]);
		exit (1);
	}
	if ((fread ((void *) ac, sizeof (struct acct), 1, fp)) != 1)
	{
		fprintf (stderr,
			 "Too short file or read error in the beginning.\n");
		exit (5);
	}
	etime=ac->ac_btime + ac->ac_etime;
	tmptime = ctime(&etime);
	strcpy (starttime, tmptime);
	if ((fseek (fp, 0, SEEK_END)) != 0)
	{
		fprintf (stderr, "Fseek error\n");
		exit (9);
	}
	if ((file_len = ftell (fp)) < 0)
	{
		fprintf (stderr, "Ftell error\n");
		exit (17);
	}
	if ((fseek (fp, (- (sizeof (struct acct))), SEEK_CUR)) != 0)
	{
		fprintf (stderr, "Fseek error\n");
		exit (10);
	}
	if ((fread ((void *) ac, sizeof (struct acct), 1, fp)) != 1)
	{
		fprintf (stderr, "Read error.\n");
		exit (6);
	}
	etime=ac->ac_btime + ac->ac_etime;
	tmptime = ctime(&etime);
	strcpy (endtime, tmptime);
	entries = file_len / (sizeof (struct acct));
#ifdef PUT_TO_SBIN
	printf ("%ld\n%s%s", entries, starttime, endtime);
#else
	printf ("%s has %ld entries\nFirst entry: %s last entry: %s",
		filename, entries, starttime, endtime);
#endif
	return (0);
}
