/* outout.c - writes translation mode output */

/* Written 1994,1995 by Werner Almesberger */


#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "scend.h"
#include "common.h"
#include "descr.h"


static int out_list(FILE *file,char *buffer,const ITEM *curr)
{
    const ITEM *walk;
    char *here;

    here = strchr(buffer,0);
    for (walk = curr; walk; walk = walk->next) {
	if (walk->var) {
	    if (here-buffer+strlen(walk->var) >= MAX_BUFFER-1)
		die("MAX_BUFFER exceeded");
	    strcpy(here,walk->var);
	}
	switch (walk->type) {
	    case it_bool:
		if (walk->u.bool.on)
		    if (fprintf(file,"%s\n",buffer) == EOF) return 0;
		/* fall through */
	    case it_comment:
		/* fall through */
	    case it_if:
		*here = 0;
		break;
	    case it_number:
		if (walk->u.number.value != walk->u.number.off)
		    if (fprintf(file,"%s=%d\n",buffer,walk->u.number.value) ==
		      EOF) return 0;
		*here = 0;
		break;
	    case it_choice:
		{
		    const char *value;

		    value = CURR_VALUE(walk).value;
		    if (fprintf(file,"%s=%s\n",buffer,value) == EOF) return 0;
		    if (here-buffer+strlen(walk->var)+strlen(value) >=
		      MAX_BUFFER-2) die("MAX_BUFFER exceeded");
		    sprintf(here,"%s:%s.",walk->var,value);
		}
		break;
	    case it_set:
		if (here-buffer+strlen(walk->var) >= MAX_BUFFER-1)
		    die("MAX_BUFFER exceeded");
		strcat(here,":");
		break;
	    default:
		;
	}
	if (walk->type != it_set) {
	    if (get_section(walk))
		if (!out_list(file,buffer,get_section(walk))) return 0;
	}
	else {
	    char *temp;
	    int i;

	    temp = strchr(here,0);
	    for (i = 0; i < num_fields(walk); i++)
		if (field_active(walk,i)) {
		    const char *str;

		    str = walk->u.set.value[i].value;
		    if (temp-buffer+strlen(str) >= MAX_BUFFER-1)
			die("MAX_BUFFER exceeded");
		    strcpy(temp,str);
		    if (fprintf(file,"%s\n",buffer) == EOF) return 0;
		    strcat(temp,".");
		    if (!out_list(file,buffer,get_section(walk))) return 0;
		}
	}
    }
    return 1;
}


void output(const char *name)
{
    FILE *file;
    char buffer[MAX_BUFFER+1];

    if (!(file = strcmp(name,"-") ? fopen(name,"w") : stdout))
	die("%s: %s",name,strerror(errno));
    *buffer = 0;
    if (!out_list(file,buffer,descr)) die("%s: %s",name,strerror(errno));
    if (file != stdin && fclose(file) == EOF)
	die("%s: %s",name,strerror(errno));
}
