/* scend.c - main program */

/* Written 1994,1995 by Werner Almesberger */


#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>

#include "screen.h"
#include "scend.h"
#include "parse.h"
#include "descr.h"


ITEM *descr;
int changed = 0,test = 0,seen = 0,edit_group = 0,demo = 0;


const char *subtitle = NULL;


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ -n ] [ -c common ] [ -i input ] "
      "[ -o output ]\n",name);
    fprintf(stderr,"%12s description\n","");
    fprintf(stderr,"%7s%s -t [ -c common ] [ -i input ] description\n","",name);
    exit(1);
}


int main(int argc,char **argv)
{
    const char *name,*common,*infile,*outfile;
    int translate;
    int c;

    common = infile = outfile = NULL;
    translate = 0;
    name = argv[0];
    while ((c = getopt(argc,argv,"c:Dgi:no:tT")) != EOF)
	switch (c) {
	    case 'c':
		common = optarg;
		break;
	    case 'D': /* undocumented */
		demo = 1;
		break;
	    case 'g':
		edit_group = 1;
		break;
	    case 'i':
		infile = optarg;
		break;
	    case 'n':
		seen = 1;
		break;
	    case 'o':
		outfile = optarg;
		break;
	    case 't':
		translate = 1;
		break;
	    case 'T':
		test = 1;
		break;
	    default:
		usage(name);
	}
    if (argc != optind+1 || (translate && outfile)) usage(name);
    parse_open(argv[optind]);
    descr = section((void *) 0);
    check_unique(descr);
    parse_close();
    if (common) {
	parse_open(common);
	read_cfg(FLAG_SEEN | FLAG_PROTECTED,0);
	parse_close();
    }
    if (infile) {
	parse_open(infile);
	read_cfg(FLAG_SEEN,1);
	parse_close();
    }
    if (translate) output("-");
    else {
	scr_begin();
	edit(outfile);
	scr_end();
    }
    return 0;
}
