/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _COLORMAP
#define _COLORMAP

#include "riskgame.h"
#include "types.h"

/* Data structure */
/* Private data structures */
typedef struct _Color
{
  unsigned char r, g, b;
} Color;


#define BLACK 255
#define WHITE 254

void COLOR_SetWorldColormap(Color *cmap);
void COLOR_SetWorldColors(void);
Int  COLOR_DieToColor(Int iDie);
Int  COLOR_PlayerToColor(Int iPlayer);
void COLOR_ColorCountry(Int iCountry, Int iPlayer);
Int  COLOR_CountryToColor(Int iCountry);
Int  COLOR_ColorToCountry(Int iColor);
void COLOR_CopyColor(Int iSrc, Int iDst);
void COLOR_StoreNamedColor(String strPlayerColor, Int iPlayer);

extern unsigned long   plCountryToColor[MAX_COLORS];
extern Int             piColorToCountry[MAX_COLORS];
extern Colormap        cmapColormap;
extern Color           pColors[MAX_COLORS];
extern Int             iNumColors;

#endif
