/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _TYPES 
#define _TYPES 

#define TRUE  1
#define FALSE 0
 
/* The idea here is that we define certain types that are guarenteed 
 * to be identical across platforms and architectures.  Also, a few  
 * extra types, such as String, are defined for clarity: 
 * 
 * Long or Int:  32 bit integer 
 *      UInt:    32 unsigned integer 
 *      Short:   16 bit integer 
 *      UShort:  16 bit unsigned integer 
 *      Float:   single precision floating point 
 *      Double:  double precision floating point 
 *      Byte:    one byte, unsigned 
 *      Char:    a character 
 *      String:  a pointer to an array of characters 
 */ 
 
#ifdef DOS 
typedef long int Int; 
typedef long int Long; 
typedef unsigned long int UInt; 
typedef short int Short; 
typedef unsigned short int UShort; 
typedef float Float; 
typedef double Double; 
typedef unsigned char Byte; 
typedef char Char; 

#ifndef _XtIntrinsic_h
typedef unsigned char Boolean;
typedef char *String;
#endif

#elif (SUN_GCC || DOS_GCC || LINUX_GCC || DEC_GCC | GENERIC_UNIX) 
typedef int Int; 
typedef int Long; 
typedef unsigned int UInt; 
typedef short int Short; 
typedef unsigned short int UShort; 
typedef float Float; 
typedef double Double; 
typedef unsigned char Byte; 
typedef char Char; 

#ifndef _XtIntrinsic_h
typedef unsigned char Boolean;
typedef char *String;
#endif

#endif 
 
 
#endif 
