/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	basmnu.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_basic_menu class header
 *		OI_basic_menu is a simple button, exclusive, or poly menu;
 *		not a scroll or abbreviated menu
 *
 *	RCSid = "$Id: basmnu.H,v 4.11.1.1 1993/06/01 22:52:52 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_basmnu_H
#define OI_basmnu_H

#ifndef OI_mnu_H
#include <OI/mnu.H>
#endif /* OI_mnu_H */

	// class forward reference declaration
	class OI_mdl_basic_menu;

 /* object specific control bits */
#define	OI_BASIC_MENU_WRAP_ARND			0x1L			/* 1 => traversal from keyboard wraps around */
#define	OI_REMOVE_FOCUS_WHEN_DONE		0x2L			/* 1 => remove the focus from around the current cell when menu finished.*/
#define	OI_DISABLE_DESCENDANT_FOCUS		0x4L			/* 1 => descendant_focus member functions return NULL */
#define	OI_BASIC_MENU_PAINTED_ONCE		0x8L			/* 1 => the interior has gotten a real expose event at least once */

	class OI_basic_menu : public OI_menu {
			OI_mdl_basic_menu	*mdl_dep ;		/* ptr to model dependent aspects of OI_box object */
			unsigned long		ctl_bits ;		/* object specific control bits */
			OI_number		fire_cnt ;		/* count of number of cells firing */
			OI_number		unprnt_cell ;		/* number of cell being unparented */
			OI_d_tech		*parnt;			/* Store the parent which was at the time this menu was activated.*/
		protected:
			OI_number		n_cells ;		/* # cells (may be less than nprop!) */
			OI_number		top_xtra,bottom_xtra,left_xtra,right_xtra ;	/* decoration space added for each cell */
			OI_xy			inter_space ;		/* Spacing between cells */
			OI_number		def_cell ;		/* default cell number, 0-n */
			OI_menu_cell		*sel_cellp ;		/* ptr to first currently selected cell (menu still active) */
			OI_bool			ptr_grb;		/* If the menu has done a pointer grab or not. */
		public:
		static	OI_class		*clsp ;			/* ptr to class record */

		private:
			void			construct() ;
			void			res_orientation(void *);	/* callback for orientation resource */
			void			res_wrap_around( void * );

		protected:
						OI_basic_menu(OI_class *clsp, const char *usr_namp, OI_orient or, const char *ttl) ;
						~OI_basic_menu() ;
			void			basic_setup(OI_number,OI_menu_cell**) ;			/* setup basic size and offsets, associate cells */
		virtual	void			new_model(OI_model_type) ;

		public:
		 /* public functions reserved for toolkit use */
		virtual	void			abs_resume_layout(OI_bool=OI_YES);
			void			allow_descendant_focus()	{ ctl_bits &= ~OI_DISABLE_DESCENDANT_FOCUS; }
			void			allow_painted_once()		{ ctl_bits |= OI_BASIC_MENU_PAINTED_ONCE; }
		virtual	OI_d_tech		*associate_parent(OI_d_tech* =NULL) ;
		virtual	void			choose_cell(OI_menu_cell*, OI_bool=OI_YES);
		virtual	void			clear_selected_cell(OI_menu_cell *);
		virtual	OI_stat			create() ;
			void			disallow_descendant_focus()	{ ctl_bits |= OI_DISABLE_DESCENDANT_FOCUS; }
			OI_d_tech		*interior()			{ return (*propp); }
			OI_bool			is_descendant_focus()		{ return((ctl_bits&OI_DISABLE_DESCENDANT_FOCUS)?OI_NO:OI_YES); }
		virtual	OI_d_tech		*val_assoc(OI_d_tech*) ;
		virtual	void			paint(const XEvent*, void* =NULL) ;
		virtual	void			do_resize();
			OI_bool			cell_firing()			{ return((OI_bool)fire_cnt); }
			void			set_cell_firing()		{ fire_cnt++ ; }
			void			clear_cell_firing()		{ fire_cnt-- ; }
		virtual	void			cell_focus_in(OI_menu_cell*);
		virtual	void			cell_focus_out(OI_menu_cell*);
		virtual	void			cell_focus_paint(OI_menu_cell*);
		virtual	void			cell_pre_unparent(OI_menu_cell*) ;
		virtual	void			cell_post_unparent(OI_menu_cell*) ;
/*KNOWN*/		void			cell_resize(OI_menu_cell *cellp) ;
//		virtual	void			cell_resized(OI_menu_cell*, void *) ;
			void			cell_resized(OI_menu_cell*, void *) ;
		virtual	OI_d_tech		*descendant_focus_obj();			/* Find a descendant obj. needing focus,(start at first obj)*/
		virtual	OI_d_tech		*descendant_last_focus_obj();			/* Find a descendant obj. needing focus,(start at last obj) */
		static	OI_bool			init(OI_connection*) ;
			OI_bool			is_painted_once()			{ return ((ctl_bits & OI_BASIC_MENU_PAINTED_ONCE)?OI_yes:OI_no); }
		virtual	void			new_top_pixel(PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_bottom_pixel(PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_down_pixel(PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_bkg_pixel(PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_bdr_pixel(PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_fg_pixel(PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_pixels(PIXEL, PIXEL, PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_layout(OI_layout l, OI_number= -1, OI_number= -1) ;	/* set layout method and default spacing */
			OI_stat			new_orientation(OI_orient);
		virtual	void			new_title(const char *title, OI_char_encode_type);
		virtual	void			new_wrap_limit(OI_number);
		virtual	void			clone_adjust(OI_d_tech*) ;
			void			set_xtra(OI_number tp, OI_number bt, OI_number lf, OI_number rt) ;
			OI_number		top_extra()			{ return(top_xtra); }
			OI_number		bottom_extra()			{ return(bottom_xtra); }
			OI_number		left_extra()			{ return(left_xtra); }
			OI_number		right_extra()			{ return(right_xtra); }
			void			set_intercell_space(OI_number x, OI_number y) { inter_space.x=x; inter_space.y=y; }
		virtual	OI_number		cell_default_extra() ;					/* extra space for default cell */
		virtual	OI_menu_cell		*find_cell(int,int) ;					/* find cell at (x,y) */
		virtual	OI_menu_cell		*abbr_cell() ;						/* cell to display in abbreviated menu */
		virtual	OI_number		num_abbr_cell() ;					/* cell to display in abbreviated menu */
		virtual	OI_stat			set_abbr_cell(const char *cell_name) ;			/* cell to display in abbreviated menu */
		virtual	void			set_selected_cell(OI_menu_cell *);
			OI_stat			set_orientation(OI_orient);				/* change menu orientation */
		virtual	OI_stat			num_set_abbr_cell(OI_number) ;				/* cell to display in abbreviated menu */
			OI_bool			has_submenu();						/* does this menu have a submenu */
			void			paint_submenu_mark(OI_menu_cell *cp) ;
			void			paint_dialog_box_mark(OI_menu_cell *cp) ;
			void			paint_separator_cell(OI_menu_cell *cp) ;
		virtual	OI_number		bullet_space_x() ;					/* space to left of bullet/checkbox in cell */
		virtual	OI_number		bullet_size_x() ;					/* size of bullet/checkbox in cell */
			OI_bool			wrap_around() ;
			void			set_wrap_around()		{ ctl_bits |= OI_BASIC_MENU_WRAP_ARND; }
			void			clear_wrap_around()		{ ctl_bits &= ~OI_BASIC_MENU_WRAP_ARND; }
		virtual	void			reorder_cells();
			void			set_current_cell(OI_menu_cell *c)	{cur_cellp = c;}
			OI_bool			remove_focus_when_done()	{return((OI_bool)((ctl_bits&OI_REMOVE_FOCUS_WHEN_DONE) != 0));}
			void			set_remove_focus_when_done()	{ctl_bits |= OI_REMOVE_FOCUS_WHEN_DONE;}
			void			clear_remove_focus_when_done()	{ctl_bits &= ~OI_REMOVE_FOCUS_WHEN_DONE;}
			OI_bool			pointer_grabbed()		{return(ptr_grb);}
			void			set_pointer_grabbed()		{ptr_grb = OI_YES;}
			void			clear_pointer_grabbed()		{ptr_grb = OI_NO;}
			OI_bool			is_basic_menu();
			void			xlate_event(XEvent*);				/* Xlate the event for the parent menu. */
 		virtual	void			original_state(OI_bool =OI_YES);		/* Reset cells to before interaction started*/
			int			conv_mask_to_btn(int);				/* Return Btn corresponding to any BtnMask bits set.*/
		virtual	OI_menu_cell		*start_current_cell();
			OI_menu_cell		*get_next_active_cell(int);
			OI_menu_cell		*get_prev_active_cell(int);
		virtual	OI_number		inter_cell_x() ;
		virtual	OI_number		inter_cell_y() ;

		virtual void			touch(OI_menu_cell*, OI_bool=OI_YES) ;		/* touch a cell as the current selection */
		virtual	OI_bool			is_write_resq(XrmQuark);
			OI_d_tech		*parent_obj()			{return(parnt);}
			void			set_parent_obj(OI_d_tech *p)	{parnt = p;}
		virtual	void			stick();
		virtual	void			repaint(OI_bool=OI_YES) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//	This particular set of overrides vectors into the interior box
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_d_tech		*descendant(const char *strp) ;
		virtual	OI_layout		layout() ;
		virtual	OI_d_tech		*next_child(OI_d_tech*);			/* get child from property list */
		virtual	OI_number		num_props() ;
		virtual	OI_d_tech		*numbered_child(OI_number n) ;
		virtual	void			resume_layout(OI_bool=OI_YES);
		virtual	void			suspend_layout();
		virtual	OI_d_tech		*subobject(const char *strp) ;
		virtual	OI_d_tech		*subobject(XrmQuark) ;


		 /* functions available to the general public */
		virtual	char			*alpha_value() ;
		virtual	OI_number		cell_number(const char *cell_name) ;
		virtual	OI_menu_cell		*next_selection(OI_menu_cell *cp) ;
		virtual	OI_number		num_cells() ;
		virtual	OI_stat			num_select(OI_bool, OI_number, OI_bool=OI_YES) ;
		virtual	OI_number		num_selected() ;
		virtual	OI_menu_cell		*numbered_cell(OI_number i) ;
		virtual	OI_stat			select(OI_bool, const char *cell_name, OI_bool=OI_YES) ;
		virtual	OI_menu_cell		*selected() ;
		virtual	OI_menu_cell		**multi_selected(OI_number* =NULL) ;
		virtual	OI_number		*num_multi_selected(OI_number*) ;
		virtual	OI_stat			set_default_cell(const char *cell_name) ;
			void			set_max_rows(OI_number);
		virtual	OI_stat			num_set_default_cell(OI_number) ;
		virtual	OI_menu_cell		*default_cell() ;
		virtual	OI_number		num_default_cell() ;
		virtual	OI_menu_cell		**multi_default_cell() ;
		virtual	OI_number		*num_multi_default_cell(OI_number*) ;
		virtual	void			add_cell(OI_menu_cell*, OI_number, OI_bool=OI_YES) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
		// For row/column related member functions, refer to documentation for layout methods derived from OI_lm_row_col

		virtual	OI_number		first_column(OI_number r= OI_undefined) ;
		virtual	OI_number		first_row(OI_number c= OI_undefined) ;
		virtual	OI_number		in_column(OI_number c, long x, OI_number r= OI_undefined, OI_number pct=100) ;
		virtual	OI_number		in_row(OI_number r, long y, OI_number c= OI_undefined, OI_number pct=100) ;
		virtual	OI_number		last_column(OI_number r= OI_undefined) ;
		virtual	OI_number		last_row(OI_number c= OI_undefined) ;
		virtual	void			new_column(OI_number c, OI_number r= OI_undefined) ;
		virtual	void			new_row(OI_number r, OI_number c= OI_undefined) ;
		virtual	OI_number		next_column(OI_number c, OI_number r= OI_undefined) ;
		virtual	OI_number		next_row(OI_number r, OI_number c= OI_undefined) ;
		virtual	OI_number		prev_column(OI_number c, OI_number r= OI_undefined) ;
		virtual	OI_number		prev_row(OI_number r, OI_number c= OI_undefined) ;
	};

#endif /* OI_basmnu_H */
