//
// Qt Sample Application: cursor.cpp
//
// Creates a custom mouse cursor.
//

#include <qbitmap.h>
#include <qwidget.h>
#include <qapp.h>


// cb_bits and cm_bits was generated by X bitmap program.

#define cb_width  32
#define cb_height 32

static unsigned char cb_bits[] = {		// cursor bitmap
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x0f, 0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 0xf0, 0x7f, 0x00, 0x00,
   0x38, 0xe0, 0x00, 0x00, 0x1c, 0xc0, 0x81, 0x03, 0x0e, 0x80, 0x83, 0x03,
   0x06, 0x00, 0x83, 0x03, 0x06, 0x00, 0x83, 0x03, 0x06, 0x00, 0x83, 0x03,
   0x06, 0x00, 0xf3, 0x1f, 0x06, 0x00, 0xf3, 0x1f, 0x06, 0x00, 0x83, 0x03,
   0x06, 0x00, 0x83, 0x03, 0x0e, 0x80, 0x83, 0x03, 0x1c, 0xc0, 0x81, 0x03,
   0x38, 0xe0, 0x83, 0x03, 0xf0, 0xff, 0x87, 0x1f, 0xe0, 0x3f, 0x87, 0x3f,
   0x80, 0x0f, 0x06, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define cm_width  32
#define cm_height 32

static unsigned char cm_bits[] = {		// cursor bitmap mask
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x0f, 0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 0xf0, 0x7f, 0x00, 0x00,
   0xf8, 0xff, 0x00, 0x00, 0xfc, 0xff, 0x81, 0x03, 0xfe, 0xff, 0x83, 0x03,
   0xfe, 0xff, 0x83, 0x03, 0xfe, 0xff, 0x83, 0x03, 0xfe, 0xff, 0x83, 0x03,
   0xfe, 0xff, 0xf3, 0x1f, 0xfe, 0xff, 0xf3, 0x1f, 0xfe, 0xff, 0x83, 0x03,
   0xfe, 0xff, 0x83, 0x03, 0xfe, 0xff, 0x83, 0x03, 0xfc, 0xff, 0x81, 0x03,
   0xf8, 0xff, 0x83, 0x03, 0xf0, 0xff, 0x87, 0x1f, 0xe0, 0x3f, 0x87, 0x3f,
   0x80, 0x0f, 0x06, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


int main( int argc, char **argv )
{
    QApplication a( argc, argv );
    QWidget w;					// just create a plain widget
    QBitmap cb( cb_width, cb_height, (char *)cb_bits, TRUE );
    QBitmap cm( cm_width, cm_height, (char *)cm_bits, TRUE );
    QCursor c( cb, cm );			// create bitmap cursor
    w.setCursor( c );				// set widget cursor
    w.show();
    return a.exec( &w );
}
