//
// Qt Sample Application: desktop.cpp
//
// Demonstrates that the desktop can be painted, just like any other
// widget.
//

#include <qimage.h>
#include <qpainter.h>
#include <qapp.h>
#include <stdio.h>

//
// Draw polygon on desktop.
//

extern "C" int rand();

static int velocity( int i )			// change velocity
{
    const velmax = 15;
    const velmin = 4;
    if ( i == 1 || i == 2 )
	i = (rand()&0x7fff % velmax)/3 + velmin;
    else
	i = (rand()&0x7fff % velmax) + velmin;
    return i;
}


void poly()
{
    QWidget *d = QApplication::desktop();
    d->setBackgroundColor( white );		// white desktop

    const int maxpoints = 5;
    const int maxcurves = 8;
    static int xvel[maxpoints];
    static int yvel[maxpoints];
    int head = 0;
    int tail = -maxcurves + 2;
    QPointArray *a = new QPointArray[ maxcurves ];
    register QPointArray *p;
    QRect r = d->rect();			// desktop rectangle

    for ( int i=0; i<maxcurves; i++ )
	a[i].resize( maxpoints );
    p = &a[0];
    for ( i=0; i<maxpoints; i++ ) {		// setup first polygon points
	p->setPoint( i, (rand()&0x7fff) % r.width(),
		        (rand()&0x7fff) % r.height() );
	xvel[i] = velocity(i);
	yvel[i] = velocity(i);
    }

    QPainter paint;
    paint.begin( d );				// start painting desktop

    for ( int ntimes=0; ntimes<2000; ntimes++ ) {
	QColor c;
	c.setHSV( rand()%360, 180, 255 );	// random color
	paint.setBrush( c );
	paint.drawPolygon( a[head] );
	if ( ++tail >= maxcurves )
	    tail = 0;

	int minx=r.left(), maxx=r.right();
	int miny=r.top(),  maxy=r.bottom();
	int x, y;
	p = &a[head];
	if ( ++head >= maxcurves )
	    head = 0;
	for ( int i=0; i<maxpoints; i++ ) {	// calc new curve
	    p->point( i, &x, &y );
	    x += xvel[i];
	    y += yvel[i];
	    if ( x >= maxx ) {
		x = maxx - (x - maxx + 1);
		xvel[i] = -velocity(i);
	    }
	    if ( x <= minx ) {
		x = minx + (minx - x + 1);
		xvel[i] = velocity(i);
	    }
	    if ( y >= maxy ) {
		y = maxy - (y - maxy + 1);
		yvel[i] = -velocity(i);
	    }
	    if ( y <= miny ) {
		y = miny + (miny - y + 1);
		yvel[i] = velocity(i);
	    }
	    a[head].setPoint( i, x, y );
	}
    }
    paint.end();				// painting done
    delete[] a;
}


//
// Rotate pattern on desktop.
//

void rotate()
{
    const int w = 64;
    const int h = 64;
    QImage image( w, h, 8, 128 );		// create image
    for ( int i=0; i<128; i++ )			// build color table
	image.setColor( i, QRGB(i,0,0) );
    for ( int y=0; y<h; y++ ) {			// set image pixels
	uchar *p = image.scanline(y);
	for ( int x=0; x<w; x++ )
	    *p++ = (x+y)%128;
    }

    QPixmap pm;
    pm = image;					// convert image to pixmap
    pm.enableImageCache( TRUE );		// rotation will be faster

    QWidget *d = QApplication::desktop();	// w = desktop widget

    for ( i=0; i<=360; i += 2 ) {
	Q2DMatrix m;
	m.rotate( i );				// rotate coordinate system
	QPixmap rpm = pm.xForm( m );		// rpm = rotated pixmap
	d->setBackgroundPixmap( rpm );		// set desktop pixmap
	d->update();				// repaint desktop
    }
}


//
// The program starts here.
//

int main( int argc, char **argv )
{
    QApplication app( argc, argv );

    if ( argc == 2 ) {
	if ( strcmp(argv[1],"-poly") == 0 )
	    poly();
	else if ( strcmp(argv[1],"-rotate") == 0 )
	    rotate();
	else
	    argc = 1;
    }

    if ( argc != 2 ) {
	fprintf( stderr, "Usage:\n\tdesktop -poly\tor\n\tdesktop -rotate\n" );
	return 1;
    }
    return 0;
}
