.\" $Id: ninstall.MAN,v 3.4.1.1 1993/11/19 06:26:56 davewt Exp $
.TH NINSTALL 1 "@VERSION@ - @DATE@"
.SH NAME
ninstall \- copies files and creates directories setting their
attributes.
.SH SYNOPSIS
.B ninstall
[\-c] [\-d] [\-g <group> [\-h] [\-m <mode>] [\-o <owner>] [\-s] [\-v]
<file1> <file2>
.br
.B ninstall
[\-c] [\-d] [\-g <group> [\-h] [\-m <mode>] [\-o <owner>] [\-s] [\-v]
<file> [...] <dir>
.br
.B ninstall
[\-d] [\-g <group> [\-h] [\-m <mode>] [\-o <owner>] [\-v] <dir>
.SH DESCRIPTION
\fINinstall\fP is an enhanced version of BSD install, with the
addition of an "\-d" option which creates a directory and the capability
of installing multiple files into a directory.  This is identical
to the features in Gnu install, even if the command-line syntax is
not as flexible.  Unlike Gnu install, \fIninstall\fP  is a Bourne
shell script which can be distributed with other software packages
without portability concerns.  Usually employed in Makefiles,
\fIninstall\fP moves or copies programs and data files into their
destination directories.  It is also used to create the destination
directories and any leading directories.  It can set permissions,
owner and group of installed file or directory.
.SH COMMAND-LINE OPTIONS
.TP
\fB\-c\fP
Use copy to install files.  Like in Gnu install, copy is the default
installation command.  This option is kept for compatability purposes.
.TP
\fB\-d\fP
Create directory with all non-existing leading directories
.TP
\fB\-g\fP <group>
Set group ownership default is current group)
.TP
\fB\-h\fP
Display help message
.TP
\fB\-m\fP <mode>
Set permission mode for installed file (default is 755)
.TP
\fB\-o\fP <owner>
Set ownership (default is current owner)
.TP
\fB\-s\fP
Strip the symbol tables from installed programs
.TP
\fB\-v\fP
Display version number
.SH AUTHOR
Geraldo Veiga (based on manual page for Gnu install)
