/*
 * GamesPak
 *
 * Copyright (C) Evan Harris, 1994
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#include "vga16.h"
#include "mouse.h"


void
RenderMousePointer(int x, int y, int light, int dark)
{
    vga16_setpixel(light, x    , y);
    vga16_setpixel(light, x + 1, y);
    vga16_setpixel(light, x + 2, y);
    vga16_setpixel(light, x + 3, y);
    vga16_setpixel(light, x + 4, y);
    vga16_setpixel(light, x + 5, y);
    vga16_setpixel(light, x    , y + 1);
    vga16_setpixel(dark , x + 1, y + 1);
    vga16_setpixel(dark , x + 2, y + 1);
    vga16_setpixel(light, x + 3, y + 1);
    vga16_setpixel(light, x    , y + 2);
    vga16_setpixel(dark , x + 1, y + 2);
    vga16_setpixel(dark , x + 2, y + 2);
    vga16_setpixel(light, x + 3, y + 2);
    vga16_setpixel(light, x + 4, y + 2);
    vga16_setpixel(light, x    , y + 3);
    vga16_setpixel(light, x + 1, y + 3);
    vga16_setpixel(light, x + 2, y + 3);
    vga16_setpixel(dark , x + 3, y + 3);
    vga16_setpixel(light, x + 4, y + 3);
    vga16_setpixel(light, x + 5, y + 3);
    vga16_setpixel(light, x    , y + 4);
    vga16_setpixel(light, x + 2, y + 4);
    vga16_setpixel(light, x + 3, y + 4);
    vga16_setpixel(dark , x + 4, y + 4);
    vga16_setpixel(light, x + 5, y + 4);
    vga16_setpixel(light, x + 6, y + 4);
    vga16_setpixel(light, x    , y + 5);
    vga16_setpixel(light, x + 3, y + 5);
    vga16_setpixel(light, x + 4, y + 5);
    vga16_setpixel(dark , x + 5, y + 5);
    vga16_setpixel(light, x + 6, y + 5);
    vga16_setpixel(light, x + 7, y + 5);
    vga16_setpixel(light, x + 4, y + 6);
    vga16_setpixel(light, x + 5, y + 6);
    vga16_setpixel(light, x + 6, y + 6);
    vga16_setpixel(light, x + 5, y + 7);
}


void
RestoreUnderMousePointer(int x, int y, int *colour)
{
    vga16_setpixel(colour[0], x    , y);
    vga16_setpixel(colour[1], x + 1, y);
    vga16_setpixel(colour[2], x + 2, y);
    vga16_setpixel(colour[3], x + 3, y);
    vga16_setpixel(colour[4], x + 4, y);
    vga16_setpixel(colour[5], x + 5, y);
    vga16_setpixel(colour[6], x    , y + 1);
    vga16_setpixel(colour[7], x + 1, y + 1);
    vga16_setpixel(colour[8], x + 2, y + 1);
    vga16_setpixel(colour[9], x + 3, y + 1);
    vga16_setpixel(colour[10], x    , y + 2);
    vga16_setpixel(colour[11], x + 1, y + 2);
    vga16_setpixel(colour[12], x + 2, y + 2);
    vga16_setpixel(colour[13], x + 3, y + 2);
    vga16_setpixel(colour[14], x + 4, y + 2);
    vga16_setpixel(colour[15], x    , y + 3);
    vga16_setpixel(colour[16], x + 1, y + 3);
    vga16_setpixel(colour[17], x + 2, y + 3);
    vga16_setpixel(colour[18], x + 3, y + 3);
    vga16_setpixel(colour[19], x + 4, y + 3);
    vga16_setpixel(colour[20], x + 5, y + 3);
    vga16_setpixel(colour[21], x    , y + 4);
    vga16_setpixel(colour[22], x + 2, y + 4);
    vga16_setpixel(colour[23], x + 3, y + 4);
    vga16_setpixel(colour[24], x + 4, y + 4);
    vga16_setpixel(colour[25], x + 5, y + 4);
    vga16_setpixel(colour[26], x + 6, y + 4);
    vga16_setpixel(colour[27], x    , y + 5);
    vga16_setpixel(colour[28], x + 3, y + 5);
    vga16_setpixel(colour[29], x + 4, y + 5);
    vga16_setpixel(colour[30], x + 5, y + 5);
    vga16_setpixel(colour[31], x + 6, y + 5);
    vga16_setpixel(colour[32], x + 7, y + 5);
    vga16_setpixel(colour[33], x + 4, y + 6);
    vga16_setpixel(colour[34], x + 5, y + 6);
    vga16_setpixel(colour[35], x + 6, y + 6);
    vga16_setpixel(colour[36], x + 5, y + 7);
}


void
SaveUnderMousePointer(int x, int y, int *colour)
{
    colour[0] = vga16_getpixel(x    , y);
    colour[1] = vga16_getpixel(x + 1, y);
    colour[2] = vga16_getpixel(x + 2, y);
    colour[3] = vga16_getpixel(x + 3, y);
    colour[4] = vga16_getpixel(x + 4, y);
    colour[5] = vga16_getpixel(x + 5, y);
    colour[6] = vga16_getpixel(x    , y + 1);
    colour[7] = vga16_getpixel(x + 1, y + 1);
    colour[8] = vga16_getpixel(x + 2, y + 1);
    colour[9] = vga16_getpixel(x + 3, y + 1);
    colour[10] = vga16_getpixel(x    , y + 2);
    colour[11] = vga16_getpixel(x + 1, y + 2);
    colour[12] = vga16_getpixel(x + 2, y + 2);
    colour[13] = vga16_getpixel(x + 3, y + 2);
    colour[14] = vga16_getpixel(x + 4, y + 2);
    colour[15] = vga16_getpixel(x    , y + 3);
    colour[16] = vga16_getpixel(x + 1, y + 3);
    colour[17] = vga16_getpixel(x + 2, y + 3);
    colour[18] = vga16_getpixel(x + 3, y + 3);
    colour[19] = vga16_getpixel(x + 4, y + 3);
    colour[20] = vga16_getpixel(x + 5, y + 3);
    colour[21] = vga16_getpixel(x    , y + 4);
    colour[22] = vga16_getpixel(x + 2, y + 4);
    colour[23] = vga16_getpixel(x + 3, y + 4);
    colour[24] = vga16_getpixel(x + 4, y + 4);
    colour[25] = vga16_getpixel(x + 5, y + 4);
    colour[26] = vga16_getpixel(x + 6, y + 4);
    colour[27] = vga16_getpixel(x    , y + 5);
    colour[28] = vga16_getpixel(x + 3, y + 5);
    colour[29] = vga16_getpixel(x + 4, y + 5);
    colour[30] = vga16_getpixel(x + 5, y + 5);
    colour[31] = vga16_getpixel(x + 6, y + 5);
    colour[32] = vga16_getpixel(x + 7, y + 5);
    colour[33] = vga16_getpixel(x + 4, y + 6);
    colour[34] = vga16_getpixel(x + 5, y + 6);
    colour[35] = vga16_getpixel(x + 6, y + 6);
    colour[36] = vga16_getpixel(x + 5, y + 7);
}
