#ifndef __AUDIO_H__
#define __AUDIO_H__ 

/*****************************************************************************
 *
 * SGI audio library 
 *
 * audio.h
 *	header file for use with /usr/lib/libaudio.a
 *
 * Copyright 1991, Silicon Graphics, Inc.
 * All Rights Reserved.
 *
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
 * the contents of this file may not be disclosed to third parties, copied or
 * duplicated in any form, in whole or in part, without the prior written
 * permission of Silicon Graphics, Inc.
 *
 * RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
 * and Computer Software clause at DFARS 252.227-7013, and/or in similar or
 * successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
 * rights reserved under the Copyright Laws of the United States.
 *
 ****************************************************************************/
#ident "$Revision: 1.16 $"

#ifdef _LANGUAGE_C_PLUS_PLUS
extern "C" {
#endif

/************************ sample rates in Hz ********************/
#define AL_RATE_48000 	48000
#define AL_RATE_44100	44100
#define AL_RATE_32000	32000
#define AL_RATE_22050	22050
#define AL_RATE_16000	16000
#define AL_RATE_11025	11025
#define AL_RATE_8000	8000

/************************ sample widths in bytes *****************/
#define AL_SAMPLE_8	1
#define AL_SAMPLE_16	2
    /* AL_SAMPLE_24 is the low 24 bits of a long, sign extended to 32 bits */
#define AL_SAMPLE_24	4

#ifdef NOTYET
#define AL_FPFORMAT 1
/* the following values where chosen arbitrarily */
#define AL_SAMPLE_FLOATCAST  320000 /* 4 bytes: cast int sample as float  */
#define AL_SAMPLE_DOUBLECAST 640000 /* 8 bytes: cast int sample as double */
#define AL_SAMPLE_FLOATNORM  320001 /* 4 bytes: normalized to [-1.0,1.0]  */
#define AL_SAMPLE_DOUBLENORM 640001 /* 8 bytes: normalized to [-1.0,1.0]  */
#endif /* NOTYET */

/************************ port widths in # of channels ***********/
#define AL_MONO		1
#define AL_STEREO	2

/************************ input source ***************************/
#define AL_INPUT_LINE	0
#define AL_INPUT_MIC	1
#define AL_INPUT_DIGITAL 2

/************************ port related enumerations **************/
typedef enum { ALHOLD, ALRELEASE } ALportState;
typedef enum { ALATTAIL, ALATHEAD, ALATMARK, ALATTIME } ALtrigger;

typedef struct _ALconfig  *ALconfig;
typedef struct _ALport *ALport;

/*
 * port configuration
 * - used for rarely changing state values
 */
extern ALconfig  	ALnewconfig(void);	
extern void	ALfreeconfig(ALconfig);
extern void	ALsetconfig(ALport, ALconfig);
extern ALconfig	ALgetconfig(ALport);
extern void	ALsetqueuesize(ALconfig, long);
extern long	ALgetqueuesize(ALconfig);
extern void	ALsetwidth(ALconfig, long);
extern long	ALgetwidth(ALconfig);
extern void	ALsetchannels(ALconfig, long);
extern long	ALgetchannels(ALconfig);
#ifdef NOTYET
extern void	ALsetsamplerate(ALconfig, long);
extern long	ALgetsamplerate(ALconfig);
extern void	ALsetcompression(ALconfig, long);
extern long	ALgetcompression(ALconfig);
extern void	ALsetinterleave(ALconfig, long);
extern long	ALgetinterleave(ALconfig);
extern void	ALsetdevice(ALconfig, long);
extern long	ALgetdevice(ALconfig);
#endif /* NOTYET */

/*
 * port manipulation
 * - used to change the dynamic state of a port
 */
extern ALport	ALopenport(const char* /*name*/, const char* /*direction*/, 
                                                              ALconfig);
extern void	ALcloseport(ALport);	
extern int 	ALgetfd(ALport);
extern long	ALgetfilled(ALport);
extern long	ALgetfillable(ALport);
extern void	ALreadsamps(ALport, void* /*buf*/, long /*count*/);
extern void	ALwritesamps(ALport, void* /*buf*/, long /*count*/);
extern void  	ALsetfillpoint(ALport, long);	
extern long	ALgetfillpoint(ALport);
#ifdef NOTYET
extern void	ALput1(ALport port, char /*leftsamp*/, char /*rightsamp*/);
extern void	ALput2(ALport port, short /*leftsamp*/, short /*rightsamp*/);
extern void	ALput4(ALport port, long /*leftsamp*/, long /*rightsamp*/);
extern void	ALget1(ALport port, char* /*leftsamp*/, char* /*rightsamp*/);
extern void	ALget2(ALport port, short* /*leftsamp*/, short* /*rightsamp*/);
extern void	ALget4(ALport port, long* /*leftsamp*/, long* /*rightsamp*/);
extern void	ALcommit(ALport, long);
extern void	ALskip(ALport, long);
extern void	ALhold(ALport, ALtrigger);
extern void	ALrelease(ALport, ALtrigger);
extern void	ALmarktime(ALport* /*ports*/, long /*portcount*/,
				  struct timezone* /*microtime*/);
extern void	ALmarksample(ALport* /*ports*/, long /*portcount*/,
				  long* /*markpoints*/);
#endif /* NOTYET */

/*
 * hardware configuration
 * - global state of a piece of hardware
 * - PVbuffer is an Parameter/Value list stored in an array of longs.
 */
#define AL_DEFAULT_DEVICE	1
extern long	ALqueryparams(long /*device*/, long* /*PVbuffer*/,
				long /*maxlength*/);
extern void	ALgetparams(long /*device*/, long* /*PVbuffer*/,
				long /*bufferlength*/);
extern void	ALsetparams(long /*device*/, long* /*PVbuffer*/,
				long /*bufferlength*/);
extern void	ALgetminmax(long /*device*/, long /*param*/,
				long* /*minparam*/, long* /*maxparam*/);
extern long	ALgetdefault(long /*device*/, long /*parameter*/);
extern char*	ALgetname(long /*device*/, long /*parameter*/);

/************************ known parameters ************************/
#define AL_INPUT_SOURCE		0
#define AL_LEFT_INPUT_ATTEN	1
#define AL_RIGHT_INPUT_ATTEN	2
#define AL_INPUT_RATE		3
#define AL_OUTPUT_RATE		4
#define AL_LEFT_SPEAKER_GAIN	5
#define AL_RIGHT_SPEAKER_GAIN	6
#define AL_INPUT_COUNT		7
#define AL_OUTPUT_COUNT		8
#define AL_UNUSED_COUNT		9
#define AL_SYNC_INPUT_TO_AES	10
#define AL_SYNC_OUTPUT_TO_AES	11

/************************ attribute types ************************/
#define AL_ENUM_VALUE	0	/* only certain values are valid */
#define AL_RANGE_VALUE	1	/* any value in range is valid */

/*
 * error handler setup
 */
typedef void (*ALerrfunc)(long,const char*,...);
extern ALerrfunc ALseterrorhandler(ALerrfunc efunc);

/*
 * error codes
 */

	/* not impimented yet */
#define AL_BAD_NOT_IMPLEMENTED	0
	/* tried to use an invalid port */
#define AL_BAD_PORT		1
	/* tried to use an invalid configuration */
#define AL_BAD_CONFIG		2
	/* tried to use an invalid deviec */
#define AL_BAD_DEVICE		3
	/* unable to access the hardware */
#define AL_BAD_DSP_ACCESS	4
	/* ioctl to the hardware failed */
#define AL_BAD_DSP_IOCTL	5
	/* no hardware port available */
#define AL_BAD_DSP_NO_PORTS	6
	/* not able to allocate a port */
#define AL_BAD_NO_PORTS		7
	/* not able to make a configuration */
#define AL_BAD_NO_CONFIGS	8
	/* no space for internal buffers */
#define AL_BAD_NO_BUFFERSPACE	9
	/* attempt to set an invalid queue size */
#define AL_BAD_QSIZE		10
	/* attempt to set an invalid fillpoint */
#define AL_BAD_FILLPOINT	11
	/* null buffer pointer */
#define AL_BAD_BUFFER_NULL	12
	/* negative count */
#define AL_BAD_COUNT_NEG	13
	/* a parameter/value buffer that doesn't make sense */
#define AL_BAD_PVBUFFER		14
	/* negative buffer length */
#define AL_BAD_BUFFERLENGTH_NEG	15
	/* odd length parameter/value buffer */
#define AL_BAD_BUFFERLENGTH_ODD	16
	/* invalid channel specifier */
#define AL_BAD_CHANNELS		17
	/* invalid parameter */
#define AL_BAD_PARAM		18

#ifdef _LANGUAGE_C_PLUS_PLUS
}
#endif

#endif /* __AUDIO_H__ */
