#include "defines.h"
#include "struct.h"
#include "globals.h"
#include "protos.h"

static int write = 0;

static void inputplayername(int player);

/* no comment */
static void inputplayername(int player)
{
  char buffer[256];
  char *cp;
  char name[MAX_SCORENAME]; /* Three initials and a null */

  while(!P[player].name[0]) {
    sfx(SFX_CONGRAT);
    sprintf(buffer,"congratulations player %d!",player);
    cp = vgets(buffer,"Please enter your name",MAX_SCORENAME,
      ship_color(player));
    strncpy(name,cp,MAX_SCORENAME);
    name[MAX_SCORENAME-1] = 0; /* terminate it to be sure */
    strcpy(P[player].name,name);
  }
  write = 1;
}

static char *mk_high_string(char *string,level_high *lh)
{
  static int i = 0;
  static char buffer[256];
  static char *names[] = {
    "Gretchen", "Eric S", "Mom", "Dad", "Tony", "Acey", "ZAP",
    "Mike", "Linda", "Alyssa",
    "George", "Wade", "Blinn",
    "Willis", "Genetti", "Bart", "Pierce",
    "Ellen", "Sandra", "Suresh",
    "Chad", "Debbie",
    "Reagan", "Blondie", "Scrambler", "2600", "Warren R",
    "Nathan", "Shevin", "Tim", "Josh", "Trevor",
    "Craig", "Randy", "Howard", "Dennis", "Reed", "Brian", "Dennis",
    "Bradley", "Laura", "Weylin", "Bob", "Craig", "Donna", "Doug",
    "Wes", "Paul", "Chris", "Sharon", "George", 
    "EOF",
  };

  if(!strcmp(names[++i],"EOF")) i = 0;

  sprintf(buffer,"\03%-6d @ %6.2f%% & %5.2f sec. %12s, %13s",
      lh->score,
      lh->accuracy,
      lh->time / 100.0,
      lh->name[0]?lh->name:names[i],
      string
  );
  return buffer;
}

void zero_level_stats(int i)
{
    P[i].finishtime = 0;  /* Now that we have these, zero to prevent
			     updating wrong missions (!!) -whoops */
    P[i].startscore = P[i].score;
    P[i].startfired = P[i].fired;
    P[i].starthit = P[i].hit;
}

/* This functions checks everyone's high scores and times and accuracy
   and writes new high score tables if someone beat something */
void update_misshigh(mission *mp)
{
  int cur_level = 0;
  int i;
  static level_high lh;

#ifdef __LINUX__
  return;
#endif
  write = 0;
  if(Next_level < 1) return;

  cur_level = Next_level - 1;

  if(!mp) return;

  for(i=1;i<=Num_scores;i++) {
    if(!Game_over && Level) { /* If just completed a level, give bonus */
      /* score += (MAX(0,bonus_score-time) * accuracy) */
      P[i].score += (int)(
	 (MAX(1000,(Level->bonus - P[i].finishtime))) *
	 ( P[i].hit - P[i].starthit )/
	( P[i].fired - P[i].startfired + (P[i].fired == P[i].startfired)));
    }

    if(P[i].score > mp->topscore) {
      inputplayername(i);
      mp->topscore = P[i].score;
      strcpy(mp->topname,P[i].name);
    }

    lh.score = P[i].score - P[i].startscore;
    lh.time = P[i].finishtime;

    /* If player didn't complete level, they don't deserve an accuracy */
    if(P[i].numlives <= 0) lh.accuracy = 0.0;
    else lh.accuracy = (float)(100.0*( P[i].hit - P[i].starthit )/
		  (float)(P[i].fired-P[i].startfired
		       + (P[i].fired==P[i].startfired)));

    if((lh.accuracy > mp->high[cur_level].acc.accuracy)) {
      inputplayername(i);
      strcpy(mp->high[cur_level].acc.name,P[i].name);
      mp->high[cur_level].acc.score = lh.score;
      mp->high[cur_level].acc.accuracy = lh.accuracy;
      mp->high[cur_level].acc.time = lh.time;
    }

    if(lh.score > mp->high[cur_level].score.score) {
      inputplayername(i);
      strcpy(mp->high[cur_level].score.name,P[i].name);
      mp->high[cur_level].score.score = lh.score;
      mp->high[cur_level].score.accuracy = lh.accuracy;
      mp->high[cur_level].score.time = lh.time;
    }

    /* This really is meant for single player only since multi-players 
       can really just not come out and get a good time. */
    if((!Game_over) && (Num_players==1) &&
      ((!(mp->high[cur_level].time.time)) ||
	lh.time < mp->high[cur_level].time.time)) {
      inputplayername(i);
      strcpy(mp->high[cur_level].time.name,P[i].name);
      mp->high[cur_level].time.score = lh.score;
      mp->high[cur_level].time.accuracy = lh.accuracy;
      mp->high[cur_level].time.time = lh.time;
    }
  }
  if(write) write_mission_high(mp);
}

static void print_high(int font)
{
  char buffer[80];
  mission *mp;
  int cur_level = 0;

  if(Mission_list) mp = Mission_list[Selected_mission];
  else return;

  if(Next_level < 1) return;
  else cur_level = Next_level -1;

  drawmode(PUPDRAW);
  color(3);
  vcprint(font,
    mk_high_string("BEST SCORE",&(mp->high[cur_level].score)));
  vcprint(font,
    mk_high_string("BEST ACCURACY",&(mp->high[cur_level].acc)));
  if(Num_scores == 1 || Game_over) vcprint(font,
    mk_high_string("BEST TIME",&(mp->high[cur_level].time)));
  else vcprint(font," ");
}

void print_cur_high(int font)
{
  int cdmode;
  cdmode = getdrawmode();

  color(1);
  vmovrel2(font,0,-2.5);
  vcprint(font,"\01 Current  level statistics \01");
  vmovrel2(font,0,1);
  print_high(font);

  drawmode(cdmode);
}

void print_prev_high(int font)
{
  int cdmode;
  cdmode = getdrawmode();

  if(Next_level < 2) return;
  Next_level--;

  color(2);
  vmovrel2(font,0,-2.5);
  vcprint(font,"\01 Previous level statistics \01");
  vmovrel2(font,0,1);
  print_high(font);

  Next_level++;

  drawmode(cdmode);
}
