#define __RAWKS_MALLOC__
#define DBG 0

#include "defines.h"
#include <malloc.h>
#include "struct.h"
#include "protos.h"
#include "globals.h"

/* This is a real limited data structure for simple animation, but it
   was *really* easy to do.  I won't say any more or less than that.
   - Aaron Michael Hightower */

xyz ***make_3d_array(int num_frames,int num_verts)
{
  int i,j;
  xyz ***t;

  t = (xyz ***)calloc(sizeof(xyz **),num_frames);

  for(i=0;i<num_frames;i++) {

    t[i] = (xyz **)calloc(sizeof(xyz *),num_verts);

    for(j=0;j<num_verts;j++) {
      t[i][j] = (xyz *)calloc(sizeof(xyz),1);
    }
  }
/* Removed (of course) in favor of calloc() */
/*   for(i=0;i<num_frames;i++) for(j=0;j<num_verts;j++) t[i][j]->x = 0.0; */

  return t;
}

void free_rock_geom(rock *r)
{
  rock *tr;
  int i,j;
  xyz ***arr;

  if(!r || !r->name) return;
  /* Only can free geometry in the library */
  if(!(r = already_loaded_geometry(r->name))) return;

  if(r==Rock_geom_lib) Rock_geom_lib = r->next;
  else {
    if(r->prev) r->prev->next = r->next;
    if(r->next) r->next->prev = r->prev;
  }

  if(!(arr = r->vertex)) return;

  for(i=0;i < r->num_frames;i++) {
    for(j=0;j < r->num_verts;j++) {
      free(arr[i][j]);
    }
    free(arr[i]);
  }
  free(arr);

  r->vertex = NULL;
}
