// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

#ifndef __Explos__
#define __Explos__

#include <stdlib.h>
#include <math.h>
#include <vgagl.h>

#include "Bitmap.h"
#include "bitmaps.h"
#include "ObjTools.h"
#include "PtrList.h"

#define BMAX	200
//////////////////////////////////////////////////////////////////////////////
class Explosion : protected Life {
    public:
    	Explosion( int xp, int yp, int size, int duration, 
    	           double xvel=0, double yvel=0);
    	           
	void Explosion::draw() const
		{
		register int i;
		for(i=0;i<Vsize;i++) gl_setpixel( Vbit[i].x(), Vbit[i].y(), 254 );
		}

	void Explosion::tick()
		{
		register int i;
		for(i=0;i<Vsize;i++) Vbit[i].moveNoWrap();
		Life::tick();
		}
	    
    private:
	FastTrajectory	Vbit[BMAX];
	int		Vsize;

    };


//////////////////////////////////////////////////////////////////////////////
class Boom
    {
    public:
    	
	static void add( int xp, int yp, int size, int duration, 
    	                 double xvel=0, double yvel=0)
    		{
    	        list.add(new Explosion(xp,yp,size,duration,xvel,yvel));
    		}
    	
    	static void tick();
	static void draw();
	static void die() { list.removeAll(); }
		
    private:
    
	static PtrList<Explosion>	list;
    };
    
#endif
