// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

#include "Obj.h"

// Create ship bitmaps rotated in different position, 
// with/without thrust flame
Bitmap	Ship::ship[SHIPTURNS];
Bitmap  Ship::shipThr[SHIPTURNS];

void Ship::init()
	{
	// use the rotate function of the bitmap object to create
	// ship bitmaps for each of the SHIPTURNS rotated positions.
	int 	i,j,k;
	Angle   angle=0;

	
	k = SHIPTURNS>>2;	// SHIPTURNS must be multiple of 4
		
	for(j=0; j<k; j++)
		{
		ship[j]    = ship0;
		shipThr[j] = ship1;

		// since our angles are 0..255, 64 is 90 normal degrees
		angle = j*64/k;;

		if (angle!=0)
			{
			ship[j].rot( angle );
			shipThr[j].rot( angle );
			}
		
		for(i=1; i<4; i++)
			{
			ship[j+i*k].copy(ship[j+(i-1)*k]);
			ship[j+i*k].rotc90();
			
			shipThr[j+i*k].copy(shipThr[j+(i-1)*k]);
			shipThr[j+i*k].rotc90();

			}
		}

#ifdef COMPILE_BITMAPS
	// compile ship bitmaps
	for(i=0; i<SHIPTURNS; i++)
		{
		ship[i].compile();
		shipThr[i].compile();
		}
//	shield.compile();
#endif
				
	}


Bitmap  Spinner::spinnerBitmaps[SPINNERTURNS];
BitmapPtr  Spinner::morphBitmaps[10];
void Spinner::init()
	{
	// use the rotate function of the bitmap object to create
	// bitmaps for each of the SPINNERTURNS rotated positions.
	int 	i,j,k;
	Angle   angle=0;

	
	k = SPINNERTURNS>>2;	// SPINNERTURNS must be multiple of 4
		
	for(j=0; j<k; j++)
		{
		spinnerBitmaps[j]    = spinner;

		// since our angles are 0..255, 64 is 90 normal degrees
		angle = j*64/k;;

		if (angle!=0)
			{
			spinnerBitmaps[j].rot( angle );
			}
		
		for(i=1; i<4; i++)
			{
			spinnerBitmaps[j+i*k].copy(spinnerBitmaps[j+(i-1)*k]);
			spinnerBitmaps[j+i*k].rotc90();
			}

		morphBitmaps[0] = &medast;
		morphBitmaps[1] = &morph1;
		morphBitmaps[2] = &morph2;
		morphBitmaps[3] = &morph3;
		morphBitmaps[4] = &morph4;
		morphBitmaps[5] = &morph5;
		morphBitmaps[6] = &morph6;
		morphBitmaps[7] = &morph7;
		morphBitmaps[8] = &morph8;
		morphBitmaps[9] = &morph9;

		}

#ifdef COMPILE_BITMAPS
	// compile spinner bitmaps
	for(i=0; i<SPINNERTURNS; i++)
		{
		spinnerBitmaps[i].compile();
		}
#endif
				
	}
