/* Routines to test out CX100 device driver */
/* SVGALib viewer for frame grabber */
/* Written by: Danny Sung */
/* Started:  06/07/1995  13:36 */
/* Finished: */

#include <stdio.h>
#include <stdlib.h>
#include <vga.h>
#include <stdio.h>

#include <vga.h>
#include <vgagl.h>

#include "cxlib.h"

/* #define WAIT_INPUT */
#define VGAMODE		G320x200x256

void set_vga_palette(void);

#define LINE_WIDTH 320

int main(int argc, char *argv[])
{
	char s[1024];
	char *ptr;
	int cxfd;
	GraphicsContext *PhysicalScreen;

	if( (cxfd=cx_open("../cx100")) == -1 )
		{ perror("scxdemo"); return(0); }

	if( !(ptr = (char *)malloc(64*1024)) )
		{ perror("view"); return(0); }

	printf("Press any key to go into graphics mode\n"); gets(s);

		/* Initialize graphics */
	vga_init();
	vga_setmode(VGAMODE);
	gl_enableclipping();
	gl_setcontextvga(VGAMODE);
	PhysicalScreen = gl_allocatecontext();
	gl_getcontext(PhysicalScreen);

		/* Set greyscale */
	set_vga_palette();
	while(1)
	{
		cx_getframe(cxfd, ptr, 64*1024);

		if( cx_getresolution(cxfd) )
		{
			printf("High resolution not yet supported.\n");
/* Don't try this code.  It doesn't work. */
/*
			vert = 42; horz = 96; linewidth = 512;
			for(i=0; i<400; i+=2)
			{
				ioctl(cxfd, FG_SET_PAGE, (i+vert)>>7);
				write(ramfd, ptr+linewidth*((i+vert)&127)+horz-40, linewidth);
			}
*/
		}
		else	/* Low resolution */
		{
			gl_putbox(0, 0, cx_imagewidth(cxfd), 200, ptr);
		}
		vga_setcolor(0xff);
		vga_drawpixel(0,0);
		vga_drawpixel(256,199);
	}

	printf("Press a key to exit.\n");
	gets(s);
	vga_setmode(TEXT);

	cx_close(cxfd);
	return(1);
}


void set_vga_palette(void)
{
	int i;
	int pal[768];

	for(i=0; i<256*3; i++)
		pal[i] = (char) (i/12);

	vga_setpalvec(0, 256, pal);
}

