/*                                                 -*-mode:C;tab-width:8-*-
 * 
 * roitest.c -- simple program to test roi-based grabbing
 *              example: "./roitest 10x10+0+0 20x20+5+60 15x60+40+50"
 *
 * Copyright (C) 1995 Alessandro Rubini  -- rubini@ipvvis.unipv.it
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "cxdrv.h"



int main(int argc, char **argv)
{
Cxg_Roi *rois, *ptr;
FILE *f; int fd;
int i, err=0;
char *prgname=argv[0];
char *devname="/dev/cxg0";
char *buffer;
int bufsize=4096;

  if (argc>1 && argv[1][0]=='/')
	{ devname=argv[1]; argc--; argv++; }

  if (argc>1 && argv[1][0]=='-')
	{ bufsize=atoi(argv[1]+1); argc--; argv++; }
  PDEBUG((stderr,"bufsize is %i\n",bufsize));
  buffer=malloc(bufsize);
  if (!buffer) {perror("malloc"); exit(1);}

  if (argc==1)
	{
	fprintf(stderr,"%s: usage \"%s [dev] [-bufsize] <geometry> ...\n",
			prgname,prgname);
	exit(1);
	}
  rois=malloc(sizeof(Cxg_Roi)*(argc-1));
  rois->count=argc-1;

  for (i=1, ptr=rois; i<argc; i++, ptr++)
	{
	if (sscanf(argv[i],"%hdx%hd+%hd+%hd",
			   &ptr->wid,&ptr->hei,&ptr->x,&ptr->y)!=4)
	  {
	  fprintf(stderr,"%s: \"%s\" not a valid geometry\n",prgname,argv[i]);
	  err++;
	  }
	PDEBUGG((stderr,"geometry \"%s\" -- ok\n",argv[i]));
	PDEBUG((stderr,"roi %p: %dx%d+%d+%d (next is %p)\n",ptr,
          ptr->wid,ptr->hei,ptr->x,ptr->y,ptr->next));

	}
  if (err) exit(err);

  f=fopen(devname,"r");
  if (!f)
	{ perror(devname); exit(1); }

  fd=fileno(f);
  err=0;
  err += Cxg_SetPage(fd,0)<0;
  err += Cxg_GrabLive(fd)<0;
  err += Cxg_SetBit(fd,CXG_BIT_DISP_RAM)<0;
  err += Cxg_LowRes(fd,1)<0;
  err += Cxg_RamPage(fd,0x0a)<0;
  err += Cxg_PgmMode(fd,0)<0;
  err += Cxg_SetRoi(fd,rois)<0;

  if (err) {perror("ioctl()"); exit(1);}

  while(1)
	write(fileno(stdout),buffer,read(fd,buffer,bufsize));

  return 0;
}



