/*  Sierpinski's Gasket Generator in C */
/*  A test of the VGA_libraries for UNIX */
/*  By:  Elliott Frisch <efrisch@wsp1.wspice.com> */

/*  Copyright (C) 1995 Free Software Foundation,  Inc. 
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either version 2, or (at your option)
    any later version.
  
    This program is distributed in the hope that it will be useful,  
    but WITHOUT ANY WARRANTY;  without even the implied warranty of
    MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program;  if not, write to the Free Software 
    Foundation,  Inc., 675 Mass Ave, Cambridge, MA 02139,  USA. */    
    
#include <stdio.h>
#include <stdlib.h>
#include <vga.h>
#include <vgakeyboard.h>
#include <time.h>

void main()
{
  int max_x,max_y,half_x;
  register int x,y,color,find;
  time_t t;

  srand((unsigned) time(&t));

  for  (find=0;find<14;find++) {
    if (!vga_hasmode(find)) {
      find--;
      break;
    }
  }
  
  vga_setmode(find);
  max_x=vga_getxdim();
  max_y=vga_getydim();
  half_x=(max_x/2);
  x=max_x/2;
  y=max_y/2;
  color = 1;
  
  keyboard_init();  
  do {
    color=(get_rand(3)%3)+1;
    switch(color) {
    case 1:
      x=((x+half_x)/2);
      y=((y+1)/2);
      break;

    case 2:
      x=((x+1)/2);
      y=((y+max_y)/2);
      break;

    case 3:
      x=((x+max_x)/2);
      y=((y+max_y)/2);
      break;
    default:
      exit(1);
    }
  vga_setcolor(color);
  vga_drawpixel(x,y);
  } while (!keyboard_update());

  keyboard_close(); 
  printf("Any Constructive Comments?\n");
  printf("Send them to Elliott Frisch <efrisch@wsp1.wspice.com>\n");
  exit(0);
}

/* From man pages on rand */
get_rand(int my_range)
{
  int i, j;

  do {
     i = RAND_MAX / my_range;
     i *= my_range;
  }  while ((j = rand()) >= i);

  return j % i;
}
