/*
 * Copyright (c) 1995 The Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * 	This product includes software developed by the Network Research
 * 	Group at Lawrence Berkeley National Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: builder-rtvc.cc,v 1.1 95/11/12 00:51:23 mccanne Exp $ (LBL)";
#endif

#include <unistd.h>
#include <stdio.h>

/*
 * This module factored out separately from grabber-rtvc.cc since
 * we distribute only the grabber-rtvc.o object and different
 * versions of gcc use different naming conventions for the
 * static constructors (so we use C call instead).
 */
extern "C" rtvc_build_device(int devno);

static class RTVCBuilder {
public:
	RTVCBuilder();
	static int checkdev(int n);
} rtvc_builder;

int RTVCBuilder::checkdev(int n)
{
	char wrk[30];
	sprintf(wrk, "/dev/rtvc%d", n);
	return (access(wrk, F_OK));
}

RTVCBuilder::RTVCBuilder()
{
	if (checkdev(0) == 0 && checkdev(1) < 0) {
		/* don't number them if there's only one. */
		rtvc_build_device(-1);
		return;
	}
	for (int devno = 0; ; ++devno) {
		if (checkdev(devno) < 0)
			break;
		rtvc_build_device(devno);
	}
}
