/*  VT1500 Device Driver for Linux, Version 1.0.5
 *  Copyright (C) 1995  M. Gutschke
 *
 *  At the time of writing my e-mail address is:
 *	Internet: gutschk@uni-muenster.de
 *  My snail mail address is:
 *	Markus Gutschke
 *	Schlage 5a
 *	48268 Greven-Gimbte
 *	Germany
 *  If you like this software, I would appreciate if you sent me a postcard
 *  from your hometown. Under the terms of the GNU general public license
 *  you are free to include this program into (commercial) software
 *  distributions (e.g. putting it onto CD-ROM); nonetheless, I would really
 *  appreciate if you dropped me a short note (sending me a sample copy of
 *  your distribution would be even more appreciated!)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdarg.h>
#include <string.h>
#include <stdio.h>

#include "osd.h"
#include "tvcontrol.h"

static void sndString(unsigned short *ptr)
{
  while (*ptr != 0xFFFF)
    sndCmd(*ptr++);
  return;
}

void clearScreen()
{
  sndCmd(0x80BA); sndCmd(0x0042);
  return;
}

void showHelp()
{
  static unsigned short data[] = {
    0x80BA,0x42,0x80BA,0x78,0x20,0x30,0x80BA,0x79,0x9C,0xA0,0xBA,
    0x80BA,0x51,0x80BA,0x78,0x4E,0x80BA,0x0A,0x80|'?',0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,
    0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80|'H',0x80BA,0x0C,0x80|'e',
    0x80BA,0x0C,0x80|'l',0x80BA,0x0C,0x80|'p',0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80|'M',0x80BA,0x0C,0x80|'e',
    0x80BA,0x0C,0x80|'n',0x80BA,0x0C,0x80|'u',0x80BA,0x02,0x80|'~',
    0x80BA,0x20,0x3E,0x80BA,0x79,0x9C,0xA0,0xBA,0x80BA,0x51,
    0x80BA,0x78,0x4E,0x80BA,0x0A,0x80|'S',0x80BA,0x0C,0x80BA,0x1C,0xFF,
    0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80BA,0x1D,0xFF,
    0x80BA,0x0C,0x80|'T',0x80BA,0x0C,0x80|'V',0x80BA,0x0C,
    0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80|'<',0x80BA,0x0C,0x80|'-',
    0x80BA,0x0C,0x80|'>',0x80BA,0x0C,0x80BA,0x1D,0xFF,
    0x80BA,0x0C,0x80|'V',0x80BA,0x0C,0x80|'C',0x80BA,0x0C,0x80|'R',
    0x80BA,0x02,0x80|'~',0x80BA,0x21,0x3D,0x80BA,0x79,0x9C,0xA0,0xBA,
    0x80BA,0x51,0x80BA,0x78,0x4E,0x80BA,0x0A,0x80|'M',0x80BA,0x0C,
    0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80|'M',0x80BA,0x0C,0x80|'u',
    0x80BA,0x0C,0x80|'t',0x80BA,0x0C,0x80|'e',0x80BA,0x0C,
    0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80|'S',0x80BA,0x0C,0x80|'w',
    0x80BA,0x0C,0x80|'i',0x80BA,0x0C,0x80|'t',0x80BA,0x0C,0x80|'c',
    0x80BA,0x0C,0x80|'h',0x80BA,0x02,0x80|'~',0x80BA,0x22,0x3D,
    0x80BA,0x79,0x9C,0xA0,0xBA,0x80BA,0x51,0x80BA,0x78,0x4E,
    0x80BA,0x0A,0x80|'E',0x80BA,0x0A,0x80|'S',0x80BA,0x0A,0x80|'C',
    0x80BA,0x0C,0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80|'E',
    0x80BA,0x0C,0x80|'x',0x80BA,0x0C,0x80|'t',0x80BA,0x0C,0x80|'e',
    0x80BA,0x0C,0x80|'n',0x80BA,0x0C,0x80|'d',0x80BA,0x0C,0x80|'e',
    0x80BA,0x0C,0x80|'d',0x80BA,0x0C,0x80BA,0x1D,0xFF,
    0x80BA,0x0C,0x80|'M',0x80BA,0x0C,0x80|'e',0x80BA,0x0C,0x80|'n',
    0x80BA,0x0C,0x80|'u',0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x02,0x80|'~',0x80BA,0x24,0x31,
    0x80BA,0x79,0x9C,0xA0,0xBA,0x80BA,0x51,0x80BA,0x78,0x4E,
    0x80BA,0x0A,0x80|'P',0x80BA,0x0C,0x80|'A',0x80BA,0x0C,0x80|'L',
    0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80|'<',
    0x80BA,0x0C,0x80|'-',0x80BA,0x0C,0x80|'>',0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x0A,0x80|'N',0x80BA,0x0C,0x80|'T',
    0x80BA,0x0C,0x80|'S',0x80BA,0x0C,0x80|'C',0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x02,0x80|'~',0x80BA,0x24,0x3F,
    0x80BA,0x79,0x9C,0xA0,0xBA,0x80BA,0x51,0x80BA,0x78,0x4E,
    0x80BA,0x0A,0x80|'B',0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,
    0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80|'B',
    0x80BA,0x0C,0x80|'a',0x80BA,0x0C,0x80|'s',0x80BA,0x0C,0x80|'s',
    0x80BA,0x0C,0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80|'C',
    0x80BA,0x0C,0x80|'o',0x80BA,0x0C,0x80|'n',0x80BA,0x0C,0x80|'t',
    0x80BA,0x0C,0x80|'r',0x80BA,0x0C,0x80|'o',0x80BA,0x0C,0x80|'l',
    0x80BA,0x02,0x80|'~',0x80BA,0x26,0x30,0x80BA,0x79,0x9C,0xA0,0xBA,
    0x80BA,0x51,0x80BA,0x78,0x4E,0x80BA,0x0A,0x80|'C',0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80BA,0x1C,0xFF,0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80|'C',0x80BA,0x0C,0x80|'o',
    0x80BA,0x0C,0x80|'l',0x80BA,0x0C,0x80|'o',0x80BA,0x0C,0x80|'r',
    0x80BA,0x0C,0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80|'C',
    0x80BA,0x0C,0x80|'o',0x80BA,0x0C,0x80|'n',0x80BA,0x0C,0x80|'t',
    0x80BA,0x0C,0x80|'r',0x80BA,0x0C,0x80|'o',0x80BA,0x0C,0x80|'l',
    0x80BA,0x02,0x80|'~',0x80BA,0x27,0x32,0x80BA,0x79,0x9C,0xA0,0xBA,
    0x80BA,0x51,0x80BA,0x78,0x4E,0x80BA,0x0A,0x80|'T',0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80BA,0x1C,0xFF,0x80BA,0x0C,
    0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80|'T',0x80BA,0x0C,0x80|'r',
    0x80BA,0x0C,0x80|'e',0x80BA,0x0C,0x80|'b',0x80BA,0x0C,0x80|'l',
    0x80BA,0x0C,0x80|'e',0x80BA,0x0C,0x80BA,0x1C,0xFF,
    0x80BA,0x0C,0x80|'C',0x80BA,0x0C,0x80|'o',0x80BA,0x0C,0x80|'n',
    0x80BA,0x0C,0x80|'t',0x80BA,0x0C,0x80|'r',0x80BA,0x0C,0x80|'o',
    0x80BA,0x0C,0x80|'l',0x80BA,0x02,0x80|'~',0x80BA,0x28,0x35,
    0x80BA,0x79,0x9C,0xA0,0xBA,0x80BA,0x51,0x80BA,0x78,0x4E,
    0x80BA,0x0A,0x80|'V',0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,
    0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80|'V',
    0x80BA,0x0C,0x80|'o',0x80BA,0x0C,0x80|'l',0x80BA,0x0C,0x80|'u',
    0x80BA,0x0C,0x80|'m',0x80BA,0x0C,0x80|'e',0x80BA,0x0C,
    0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80|'C',0x80BA,0x0C,0x80|'o',
    0x80BA,0x0C,0x80|'n',0x80BA,0x0C,0x80|'t',0x80BA,0x0C,0x80|'r',
    0x80BA,0x0C,0x80|'o',0x80BA,0x0C,0x80|'l',0x80BA,0x02,0x80|'~',
    0x80BA,0x29,0x38,0x80BA,0x79,0x9C,0xA0,0xBA,0x80BA,0x51,
    0x80BA,0x78,0x4E,0x80BA,0x0A,0x80|'<',0x80BA,0x0A,0x80|'>',
    0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80BA,0x1C,0xFF,
    0x80BA,0x0C,0x80|'S',0x80BA,0x0C,0x80|'w',0x80BA,0x0C,0x80|'i',
    0x80BA,0x0C,0x80|'t',0x80BA,0x0C,0x80|'c',0x80BA,0x0C,0x80|'h',
    0x80BA,0x0C,0x80BA,0x1D,0xFF,0x80BA,0x0C,0x80|'S',
    0x80BA,0x0C,0x80|'t',0x80BA,0x0C,0x80|'a',0x80BA,0x0C,0x80|'t',
    0x80BA,0x0C,0x80|'i',0x80BA,0x0C,0x80|'o',0x80BA,0x0C,0x80|'n',
    0x80BA,0x02,0x80|'~',0x80BA,0x2A,0x3B,0x80BA,0x79,0x9C,0xA0,0xBA,
    0x80BA,0x51,0x80BA,0x78,0x4E,0x80BA,0x0A,0x80|'Q',0x80BA,0x0C,
    0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80BA,0x1C,0xFF,0x80BA,0x0C,
    0x80BA,0x1C,0xFF,0x80BA,0x0C,0x80|'Q',0x80BA,0x0C,0x80|'u',
    0x80BA,0x0C,0x80|'i',0x80BA,0x0C,0x80|'t',0x80BA,0x2B,0x33,
    0x80BA,0x79,0x9C,0xA0,0xBA,0x80BA,0x51,0x80BA,0x78,0x4E,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80|'-',0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80|'S',0x80BA,0x18,0x80|'P',
    0x80BA,0x18,0x80|'A',0x80BA,0x18,0x80|'C',0x80BA,0x18,0x80|'E',
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80|'-',
    0x80BA,0x03,0x80|'~',0x80BA,0x79,0x43,
    0xFFFF};

  sndString(data);
  return;
}

void showTVVCR(int flag)
{
  static unsigned short data[] = {
    0x80BA,0x42,0x80BA,0x78,0x20,0x30,0x80BA,0x79,0x9F,0xAD,0xB0,
    0x80BA,0x50,0x80BA,0x78,0x4E,0x80BA,0x11,0x80BA,0x1C,0xFF,
    0x80BA,0x11,0x80|'T',0x80BA,0x11,0x80|'V',0x80BA,0x11,
    0x80BA,0x1D,0xFF,0x80BA,0x20,0x34,0x80BA,0x79,0x9F,0xAD,0xB0,
    0x80BA,0x50,0x80BA,0x78,0x4E,0x80BA,0x04,0x80BA,0x1C,0xFF,
    0x80BA,0x04,0x80|'<',0x80BA,0x04,0x80|'+',0x80BA,0x04,0x80|'>',
    0x80BA,0x04,0x80BA,0x1D,0xFF,0x80BA,0x20,0x39,
    0x80BA,0x79,0x9F,0xAD,0xB0,0x80BA,0x50,0x80BA,0x78,0x4E,
    0x80BA,0x08,0x80BA,0x1C,0xFF,0x80BA,0x08,0x80|'V',
    0x80BA,0x08,0x80|'C',0x80BA,0x08,0x80|'R',0x80BA,0x08,
    0x80BA,0x1D,0xFF,0x80BA,0x00,0x80|'~',0x80BA,0x20,0x3F,
    0x80BA,0x79,0x9F,0xAD,0xB0,0x80BA,0x50,0x80BA,0x78,0x4E,
    0x80BA,0x11,0x80BA,0x1C,0xFF,0x80BA,0x11,0x80|';',
    0x80BA,0x11,0x80|';',0x80BA,0x01,0x80|'~',0x80BA,0x79,0x43,
    0xFFFF};
  unsigned short *ptr = data;

  for (; *ptr != 0xFFFF; ptr++)
    if (!flag &&
	ptr[1] != 0x00BB &&
	(ptr[1] & 0xFF80) == 0x80 &&
	ptr[-1] == 0x80BA)
      if (*ptr == 0x11)
	sndCmd(0x08);
      else if (*ptr == 0x08)
	sndCmd(0x11);
      else
	sndCmd(*ptr);
    else if (!flag &&
	     ptr[0] == 0x80BA &&
	     ptr[1] == 0x0011 &&
	     ptr[2] == 0x00BB &&
	     ptr[-1]== 0x00FF) {
      int i;
      for (i = 9; i--;) {
	sndCmd(0x80BA); sndCmd(0x0011);
	sndCmd(0x80BA); sndCmd(0x0011); sndCmd(0x00FF); }
      sndCmd(*ptr); }
    else
      sndCmd(*ptr);
  return;
}

void showMute(int flag)
{
  static unsigned short data[] = {
    0x80BA,0x42,0x80BA,0x78,0x20,0x30,0x80BA,0x79,0x94,0xA3,0xBF,
    0x80BA,0x50,0x80BA,0x78,0x4E,0x80BA,0x18,0x80BA,0x1C,0xFF,
    0x80BA,0x18,0x80|'$',0x80BA,0x18,0x80|'%',0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x03,0x80|'~',0x80BA,0x79,0x43,
    0xFFFF};
  unsigned short *ptr = data;

  for (; *ptr != 0xFFFF; ptr++)
    if (flag)
      if (*ptr == 0xA4) sndCmd(0xAE);
      else if (*ptr == 0xA5) sndCmd(0xAF);
      else sndCmd(*ptr);
    else sndCmd(*ptr);
  return;
}

static void showVal(char *s,int val)
{
  static unsigned short data1[] = {
    0x80BA,0x42,0x80BA,0x78,0x20,0x30,0x80BA,0x79,0x9B,0xAC,0xB5,
    0x80BA,0x50,0x80BA,0x78,0x4E,0x80BA,0x18,0x80BA,0x1C,0xFF,
    0x80BA,0x18,0x80|'<',0x80BA,0x18,0x80|'>',0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x02,0x80|'~',0x80BA,0x20,0xFFF,
    0x80BA,0x79,0x9B,0xAC,0xB5,0x80BA,0x50,0x80BA,0x78,0x4E,
    0x80BA,0x08,0x80BA,0x1C,0xFF,
    0xFFFF};
  static unsigned short data2[] = {
    0x80BA,0x01,0x80|'~',0x80BA,0x79,0x4B,
    0xFFFF};
  unsigned short *ptr;
  int i = 0;

  for (ptr = data1; *ptr != 0xFFFF; ptr++) {
    if (*ptr == 0xFFF)
      sndCmd(0x30 + 5 + i);
    else {
      sndCmd(*ptr);
      if (*ptr == 0xBC &&
	  ptr[-1] == 0x18 &&
	  ptr[-2] == 0x80BA)
	while (*s) {
	  i++;
	  sndCmd(0x80BA); sndCmd(0x18); sndCmd(0x80|*s++); } } }
  for (i = val; i--; ) {
    sndCmd(0x80BA); sndCmd(0x0008); sndCmd(0x00A3); }
  for (i = 15-val; i--; ) {
    sndCmd(0x80BA); sndCmd(0x0008); sndCmd(0x00AD); }
  sndString(data2);
  return;
}

void showBass(int bass)
{
  showVal("Bass",bass);
  return;
}

void showTreble(int treble)
{
  showVal("Treble",treble);
  return;
}

void showVolume(int volume)
{
  showVal("Volume",volume);
  return;
}

void showColor(int highlight,...)
{

  static unsigned short head[] = {
    0x80BA,0x42,0x80BA,0x78,0x20,0x30,0x80BA,0x79,0x9F,0xAD,0xB0,
    0x80BA,0x51,0x80BA,0x78,0x4E,0x80BA,0x14,0x80BA,0x1C,0xFF,
    0x80BA,0x14,0x80BA,0x1D,0xFF,0x80BA,0x14,0x80|';',0x80BA,0x14,
    0x80BA,0x1C,0xFF,0x80BA,0x14,0x80BA,0x1D,0xFF,0x80BA,0x02,0x80|'~',
    0x80BA,0x20,0x36,0x80BA,0x79,0x9F,0xAD,0xB0,0x80BA,0x51,
    0x80BA,0x78,0x4E,0x80BA,0x14,0x80BA,0x1C,0xFF,0x80BA,0x14,0x80|'<',
    0x80BA,0x14,0x80|'+',0x80BA,0x14,0x80|'>',0x80BA,0x14,
    0x80BA,0x1D,0xFF,0x80BA,0x02,0x80|'~',0x80BA,0x20,0x3C,
    0x80BA,0x79,0x9F,0xAD,0xB0,0x80BA,0x51,0x80BA,0x78,0x4E,
    0x80BA,0x14,0x80BA,0x1C,0xFF,0x80BA,0x14,0x80BA,0x1D,0xFF,
    0x80BA,0x14,0x80|'@',0x80BA,0x14,0x80BA,0x1C,0xFF,0x80BA,0x14,
    0x80BA,0x1D,0xFF,0x80BA,0x02,0x80|'~',0x80BA,0x21,0x32,
    0xFFFF};
  static unsigned short begLine[] = {
    0x80BA,0x79,0x9F,0xAD,0xB0,0x80BA,0x51,0x80BA,0x78,0x4E,
    0xFFFF};
  static unsigned short foot[] = {
    0x80BA,0x79,0x43,
    0xFFFF};
  static char *names[7] = {" Brightness%5d",
			   " Saturation%5d",
			   " Contrast  %5d",
			   " Hue       %5d",
			   " Red       %5d",
			   " Green     %5d",
			   " Blue      %5d"};
  int i,col;
  char *ptr,buffer[20];
  va_list vaarg;

  va_start(vaarg,highlight);
  sndString(head);
  for (i = 0; i < 7; i++) {
    col = i == highlight ? 0x10 : 0x18;
    sndString(begLine);
    sprintf(buffer,names[i],va_arg(vaarg,int));
    for (ptr = buffer; *ptr; ptr++) {
      if (*ptr == ' ') {
	sndCmd(0x80BA); sndCmd(col);
	sndCmd(0x80BA); sndCmd(0x1C); sndCmd(0xFF); }
      else {
	sndCmd(0x80BA); sndCmd(col); sndCmd(0x80|(int)*ptr); } }
    if (i != 6) {
      sndCmd(0x80BA); sndCmd(0x02); sndCmd(0xFE);
      sndCmd(0x80BA); sndCmd(0x22+i); sndCmd(0x33+i); }
    else {
      sndCmd(0x80BA); sndCmd(0x03); sndCmd(0xFE); } }
  sndString(foot);
  va_end(vaarg);
  return;
}

static void printString(const char *s)
{
  static unsigned short space[] = {
    0x80BA,0x08,0x80BA,0x1C,0xFF,
    0xFFFF};

  if (!s)
    return;
  for (; *s; s++)
    if (*s == ' ')
      sndString(space);
    else {
      sndCmd(0x80BA); sndCmd(0x08); sndCmd(*s+0x80); }
  return;
}

void showChannel(int num,const char *name,const char *longName)
{
  static unsigned short data1[] = {
    0x80BA,0x42,0x80BA,0x78,0x00|' ',0x30,0x80BA,0x79,0x96,0xA9,0xB0,
    0x80BA,0x50,0x80BA,0x78,0x00|'N',0x80BA,0x08,0x80BA,0x1C,0xFF,
    0x80BA,0x08,0x80BA,0x1D,0xFF,0x80BA,0x08,0x80BA,0x1C,0xFF,
    0x80BA,0x08,0x80BA,0x1D,0xFF,0x80BA,0x08,0x80BA,0x1C,0xFF,
    0x80BA,0x08,0x80BA,0x1D,0xFF,0x80BA,0x08,0x80BA,0x1C,0xFF,
    0x80BA,0x08,0x80BA,0x1D,0xFF,
    0xFFFF};
  static unsigned short data2[] = {
    0x80BA,0x00,0x80|'~',0x80BA,0x20,0x00|';',
    0x80BA,0x79,0x96,0xA9,0xB0,0x80BA,0x50,0x80BA,0x78,0x00|'N',
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,
    0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x00,0x80|'~',
    0x80BA,0x21,0x00|'?',0x80BA,0x79,0x96,0xA9,0xB0,0x80BA,0x50,
    0x80BA,0x78,0x00|'N',0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1C,0xFF,0x80BA,0x00,0x80|'~',
    0x80BA,0x23,0x00|'3',0x80BA,0x79,0x96,0xA9,0xB0,0x80BA,0x50,
    0x80BA,0x78,0x00|'N',0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,
    0x80BA,0x1D,0xFF,0x80BA,0x18,0x80BA,0x1D,0xFF,0x80BA,0x18,
    0x80BA,0x1C,0xFF,0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',
    0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',
    0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',
    0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',
    0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',
    0x80BA,0x00,0x80|'~',0x80BA,0x00,0x80|'~',0x80BA,0x25,0x00|'5',
    0x80BA,0x79,0x96,0xA9,0xB0,0x80BA,0x50,0x80BA,0x78,0x00|'N',
    0x80BA,0x08,0x80BA,0x1D,0xFF,0x80BA,0x08,0x80BA,0x1C,0xFF,
    0xFFFF};
  static unsigned short data3[] = {
    0x80BA,0x01,0x80|'~',0x80BA,0x79,0x00|'C',
    0xFFFF};
  static unsigned short space[] = {
    0x80BA,0x08,0x80BA,0x1C,0xFF,
    0xFFFF};

  sndString(data1);
  if (num >= 0 && num <= 99) {
    if (num < 10)
      sndString(space);
    else {
      sndCmd(0x80BA); sndCmd(0x08); sndCmd(num/10+'0'+0x80); }
    sndCmd(0x80BA); sndCmd(0x08); sndCmd(num%10+'0'+0x80); }
  else {
    sndString(space); sndString(space); }
  sndString(data2);
  if (longName && *longName) {
    int i = (16-strlen(longName))/2;
    while (i-- > 0) sndString(space);
    printString(longName); }
  else {
    printString("   Channel ");
    printString(name); }
  sndString(data3);
  return;
}

