/*  VT1500 Device Driver for Linux, Version 1.0.5
 *  Copyright (C) 1995  M. Gutschke
 *
 *  At the time of writing my e-mail address is:
 *	Internet: gutschk@uni-muenster.de
 *  My snail mail address is:
 *	Markus Gutschke
 *	Schlage 5a
 *	48268 Greven-Gimbte
 *	Germany
 *  If you like this software, I would appreciate if you sent me a postcard
 *  from your hometown. Under the terms of the GNU general public license
 *  you are free to include this program into (commercial) software
 *  distributions (e.g. putting it onto CD-ROM); nonetheless, I would really
 *  appreciate if you dropped me a short note (sending me a sample copy of
 *  your distribution would be even more appreciated!)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __TV_CONTROL_H__
#define __TV_CONTROL_H__

#define CHPREV  100
#define CHNEXT  101
#define CHSTART -1

#define MAXBASS       15
#define MAXTREBLE     15
#define MAXVOLUME     31
#define DEFBRIGHTNESS 54
#define DEFSATURATION 28
#define DEFCONTRAST   49
#define DEFHUE       128
#define DEFRED        32
#define DEFGREEN      32
#define DEFBLUE       32

void initializeTuner(void);
void sndCmd(unsigned short cmd);
void setRadio(int flag);
void setFrq(int frq);
int  setChannel(int channel);
void setVolume(int volume);
void setBass(int bass);
void setTreble(int treble);
void setMute(int flag);
void setVGA(int flag);
void setTV(void);
void setVCR(void);
void setPAL(void);
void setNTSC(void);
void setHue(int hue);
void setBrightness(int brightness);
void setSaturation(int saturation);
void setContrast(int contrast);
void setRed(int red);
void setGreen(int green);
void setBlue(int blue);

const char *channelName(int frq,int *index);
int isVisible(void);
int isRadio(void);
int getTVVCR(void);
int getPALNTSC(void);
int getChannel(void);
int getFrq(void);
int getMute(void);
int getBass(void);
int getTreble(void);
int getVolume(void);
int getBrightness(void);
int getSaturation(void);
int getContrast(void);
int getHue(void);
int getRed(void);
int getGreen(void);
int getBlue(void);
int channelInfo(int *index,int chPrg,int inc,
		const char **name,const char **longName,
		int *frq,int *adj,
		int *prgNum,int *PALNTSC);
void setChannelInfo(int index,char *longName,int adj,int prgNum,int PALNTSC);

extern int forcePort;

#endif
