/*
 * Copyright (c) 1983 Eric P. Allman
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)conf.h	5.17 (Berkeley) 6/1/90
 */

#ifndef CONF_H
# define CONF_H
# ifndef lint
#  ifdef _DEFINE
static char *conf_h_sccs_id = "@(#)conf.h	5.17 (Berkeley) 6/1/90";
static char *conf_h_rcs_id = "@(#)$Id: conf.h,v 5.17.0.20 1991/08/14 18:30:39 paul Exp $";
#  endif /* _DEFINE */
# endif /* !lint */

/*
**  CONF.H -- User-configurable parameters for sendmail
*/

/*
**  Table sizes, etc....
**	There shouldn't be much need to change these....
*/

# define MAXLINE	1024		/* max line length */
# define MAXNAME	256		/* max length of a name */
# define MAXFIELD	4096		/* max total length of a hdr field */
# define MAXPV		40		/* max # of parms to mailers */
# define MAXHOP		25		/* max value of HopCount */
# define MAXATOM	200		/* max atoms per address */
# define MAXMAILERS	25		/* maximum mailers known to system */
# define MAXRWSETS	40		/* max # of sets of rewriting rules */
# define MAXPRIORITIES	25		/* max values for Precedence: field */
# define MAXTRUST	30		/* maximum number of trusted users */
# define MAXUSERENVIRON	40		/* max # of items in user environ */
# define QUEUESIZE	600		/* max # of jobs per queue run */
# define MAXMXHOSTS	10		/* max # of MX records */

/*
** Compilation platform.  Include one from the following list:
**
** 3b1.h aix3.h aixrt.h bsd43.h bsd44.h convex.h domainos.h dynix.h hpux.h
** irix.h isc.h next.h osx.h proto.h ptx.h riscos.h sunos4.h ultrix3.h
** ultrix4.h umax.h
*/

# include "config/bsd44.h"

/*
**  Compilation options.
**
**	#define these if they are available; comment them out otherwise.
*/

# define DBM		1	/* use DBM library (may require -ldbm) */
# define NO_PADDING	1	/* don't pad dbm strings with ASCII NULL */

/*
 * Define only 1 of the various {N,G,S,M,H}DBM libraries.  N.B., HDBM
 * assumes that ndbm.o was included in the libhash.a file.
 */
/*# define NDBM		1	/* new DBM library available (requires DBM) */
# define GDBM		1	/* gnu DBM library available (requires DBM) */
/*# define SDBM		1	/* Ozan Yigit's PD ndbm (requires DBM) */
/*# define MDBM		1	/* UMaryland's ndbm variant (requires DBM) */
/*# define HDBM		1	/* Berkeley's hashing package (requires DBM) */

/*# define YP		1	/* enable Yellow Pages code */
/*# define FUZZY	1	/* enable fuzzy matching of local user names */
# define LOG		1	/* enable logging */
# define SMTP		1	/* enable user and server SMTP */
# define QUEUE		1	/* enable queueing */
# define QUEUE_MACVALUE	'$'	/* save the $r and $s macros in queue file */
/* # define UGLYUUCP	1	/* output ugly UUCP From lines */
# define DAEMON		1	/* include the daemon (requires IPC & SMTP) */
# define NAMED_BIND	1	/* use Berkeley Internet Domain Server */
/*# define TTYNAME	1	/* set macro y to basename of tty device */
/*# define NOTUNIX	1	/* Define if msgs lack a UNIX "From " line */

/*
 * Enable non-standard SMTP mods for talking to the DEC mail11v3 program.
 * This option is necessary only on Ultrix machines that wish to act as
 * Internet <=> Decnet mail gateways.  DECNETNAME must also be defined
 * in your ida/cf/foo.m4 file to include the Decnet rulesets in the sendmail.cf
 * file.
 */
/*# define MAIL11V3	1	/* */

/*
 * Munge argv to display current status for ps.  This will not work on systems
 * derived from System 5.  On some systems such as Apollos, it will cause core
 * dumps.
 */
# define SETPROCTITLE	1	/* */

/*
 * Support character set translation and 8-bit mailers between cooperating
 * sites.  Intended for sites whose character set is not US ASCII.  See
 * ../ida/charset.
 */
/*# define BIT8		1	/* */

/*
** Change this to the location where sendmail should read its configuration
** file.  Older systems used /usr/lib/sendmail.cf, some newer systems move
** this file to /etc/sendmail.cf.
*/
# define	_PATH_SENDMAILCF	"/etc/sendmail.cf"	/* */

/*
** Comment out the following line if freeze files don't work on your platform.
** Freeze files will not work on the Next (no sbrk()), nor Apollo boxes.
** Fixes for the latter are solicted.  The RS/6000 (but not the RT) AIX
** restriction has been lifted.
*/
# if !defined(NeXT) && !defined(apollo) && !defined(ISC)&& !defined(AIX)
#  define	_PATH_SENDMAILFC	"/etc/sendmail.fc"	/* */
# endif /* !NeXT && !apollo && !ISC && !AIX */

/*
** Comment out this line if you don't want sendmail to write a file with
** the daemon's pid.
*/
/*# define	_PATH_SENDMAILPID   	"/var/run/sendmail.pid"	/* */
# define	_PATH_SENDMAILPID	"/etc/sendmail.pid"	/* */

/*
** Various hardware/OS #defines are used in the code.  Most of these
** are typically set by the C preprocessor or compiler.  In some cases
** you may need to #define some of these here, or use a -D CFLAGS argument
** in the Makefile.  Many are used only in the getloadavg.c file.  These
** are the macros currently in use:
**
** BSD4_4     ISC        USG        __convex__ hp9000     macII      sun
** CRAY       NeXT       UTEK       alliant    hp9000s800 mips       unixpc
** CRAY2      SYSV       AIX        apollo     hpux       sequent    vax
** DGUX       UMAX       _AIX       att        i386       sgi
*/

/* Linux stuff */
#define SYSV
#define LACK_WAIT3

#endif /* !CONF_H */
