function retval = reshape (a, m, n)

# Form an m x n matrix from the elements of a (taken in fortran's
# column major ordering).

  if (nargin != 3)
    error ('usage: reshape (a, m, n)');
  else
    [nr, nc] = size (a);
    if (nr * nc == m * n)
      tmp = do_fortran_indexing;
      do_fortran_indexing = 'yes';
      retval = zeros (m, n);
      retval (:) = a;
      do_fortran_indexing = tmp;
    else
      error ('reshape: sizes must match');
    endif
  endif

endfunction
